/****************************************/
/*					*/
/****************************************/
/* Start      : 13/10/2002		*/
/* Version    : 1.00			*/
/* Last Update: 13/10/2002		*/
/****************************************/

/*
  Copyright (c) 2002,2003 Stefanos Harhalakis

  This file is part of commonlib.

  netinfo is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netinfo is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netinfo; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _BASEDB_H
#define _BASEDB_H

#include "v/lconfig.h"
#include "config.h"

#ifdef NEED_CRYPT_WORKAROUND
#	define	crypt crypt2
#endif
#include "libpq++.h"
#ifdef NEED_CRYPT_WORKAROUND
#	undef crypt
#endif

#define INT4	s_32


class BASEDB
{
 public:
	PgDatabase	*pgdb;
	ExecStatusType	est;
 private:
 public:
			BASEDB		();
			~BASEDB		();
			BASEDB		(const BASEDB &db);
	int		Connect		(const char *path, const char *dbname, const char *user, const char *pass);
								// Return:	1: Connected
								//		0: Error
	void		Disconnect	();
	int		Exec		(char *cmd);	// Return: >0: OK, 0: Error(see est) or tuples==0, -1: Error (est unspecified)
	int		Commit		();		// Do a "COMMIT WORK". Return the result of Exec

	const char*	GetValue	(int tup_num, int field_num);
	int		Tuples		();
	int		CmdTuples	();	// Return number of rows affected by insert, update or delete

	int		Begin		();	// Begin a transaction
	int		End		();	// End a transaction

	int		CallFunction	(const char *func);	// Call a function using select. Return the result of Exec
	int		DeclareCursor	(const char *cursor, const char *select);	// Declare cursor for select
	int		Fetch		(const char *cursor);	// fetch from cursor

	int		LockTable	(const char *tName);	// Lock table in ACCESS EXCLUSIVE MODE -- One reader/writer
	int		LockTableWrite	(const char *tName);	// Lock table in EXCLUSIVE MODE - One writer, many readers

	int		ReindexTable	(const char *tName);	// Reindex a table - Will begin/end a transaction
};

#endif

