/*
  Copyright (c) 2003 Stefanos Harhalakis

  This file is part of netmap.

  netmap is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netmap is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netmap; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#define _CONF_CC
#include "conf.h"

#include "v/misc/keytable2.cc"
#include "v/misc/nkeytable.cc"

CFG			conf;
KEYTABLE<NETDEV>	netdevs;	// Key is the ip

CFG_VAR vars[]={
//	name,			p,			dflt,		type,		flags,			opt
//	{"LOGFILE",		&conf.logfile,		NULL,		TYPE_LL,	NOINIT | REHASH,	NULL},
	{"DBNAME",		&conf.dbname,		NULL,		TYPE_LL,	NOINIT,			NULL},
	{"DBUSER",		&conf.dbuser,		NULL,		TYPE_LL,	NOINIT,			NULL},
	{"DBPASS",		&conf.dbpass,		NULL,		TYPE_LL,	NOINIT,			NULL},
	{NULL,			NULL,			NULL,		0,		0,			NULL}
};

SIMPLE_CONFIG	scfg(vars);

void	init_conf(const char *fn)
{
	if (fn!=NULL)
		conf.cfg_file=fn;

	scfg.Read(conf.cfg_file.p);
}

