/*
  Copyright (c) 2003 Stefanos Harhalakis

  This file is part of netmap.

  netmap is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netmap is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netmap; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _CONF_H
#define _CONF_H

#include "config.h"

#include "v/misc/simpleconfigfile.h"
#include "v/misc/keytable2.h"
#include "v/misc/nkeytable.h"

#define BPS_INVALID     (u_32)0xFFFFFFFF

#if (SIZEOF_UNSIGNED_LONG_LONG == 8)
	typedef unsigned long long	u_64;
#else
	typedef unsigned long		u_64;	// A limitation for systems that don't support 64bit integers
#endif

struct CFG
{
	LONGLINE	cfg_file;
	LONGLINE	dbname,dbuser,dbpass;
};

class IFACE
{
 public:
	LONGLINE		descr,alias;
	int			index;
	u_32			bytes_in, bytes_out;
	u_32			speed;
	time_t			ts;

	// filed from database
	u_32			last_bytes_in, last_bytes_out;
	time_t			last_ts;
 private:
 	void	ddd		(const IFACE &d)
		{ descr=d.descr; bytes_in=d.bytes_in; bytes_out=d.bytes_out; index=d.index;
		speed=d.speed; alias=d.alias; ts=d.ts; 
		last_bytes_in=d.last_bytes_in; last_bytes_out=d.last_bytes_out; last_ts=d.last_ts; }
 public:
		IFACE		() {descr=""; bytes_in=bytes_out=0; index=-1; speed=0; alias=""; ts=0; }
		IFACE		(const IFACE &d) { ddd(d); }
	IFACE&	operator=	(const IFACE &d) { ddd(d); return(*this); }
};

struct NETDEV
{
	LONGLINE		ip;
	LONGLINE		community;
	LONGLINE		name;
	NKEYTABLE<IFACE>	ifaces;		// key is ifindex
	u_32			flags;
	u_32			uptime;
	u_32			cpu1, cpu2, cpu3;	// for cisco: 1: 5s, 2: 1m, 3: 5m
							// for netsnmp: load*100
	u_64			mem_used, mem_free;
};

#ifndef _CONF_CC
extern CFG			conf;
extern KEYTABLE<NETDEV>		netdevs;	// key is IP
#endif

void	init_conf(const char *fn=NULL);

#endif

