/*
  Copyright (c) 2003 Stefanos Harhalakis

  This file is part of netmap.

  netmap is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netmap is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netmap; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _DB_H
#define _DB_H

#include "basedb.h"
#include "v/lconfig.h"
#include "conf.h"

int	connect_db	();
void	close_db	();
int	get_netdevs	();	// Fill netdevs. Return # of netdevs.
//void	update_iface	(const char *netdev_ip, const char *ifdescr,
//			const char *ifalias, int ifindex, u_32 cur_in, u_32 cur_out, u_32 speed,
//			time_t ts);
void	update_iface	(const char *netdev_ip, IFACE *piface);
void	update_ifacct	(const char *netdev_ip, IFACE *piface);
//void	update_ifacct	(const char *netdev_ip, const char *ifdescr,
//			u_32 cur_in, u_32 cur_out, time_t ts);
//void	update_ifacct	(const char *netdev_ip, const char *ifdescr,
//			u_32 cur_in, u_32 cur_out,  u_32 last_in, u_32 last_out,
//			u_32 bps_max, time_t last_ts, time_t cur_ts);
void	update_netdev	(const char *netdev_ip, u_32 uptime, u_32 cpu1, u_32 cpu2, u_32 cpu3,
			u_32 memused, u_32 memfree);
void	update_memacct	(const char *netdev_ip, u_32 memused);
void	update_cpuacct	(const char *netdev_ip, u_32 cpu);
void	do_rotate	();
void	do_final	();	// Run final SQL commands
void	db_begin_update	();	// Begin a transaction and lock tables
void	db_end_update	();

#ifndef _DB_CC
extern BASEDB	db;
#endif

#endif

