/****************************************/
/*					*/
/****************************************/
/* Start      : 03/01/2003		*/
/* Version    : 1.00			*/
/* Last Update: 03/01/2003		*/
/****************************************/

/*
  Copyright (c) 2003 Stefanos Harhalakis

  This file is part of netmap.

  netmap is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netmap is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netmap; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "conffile.h"

#include "conf.h"
#include "db.h"
#include "snmp.h"

void	init()
{
	int	n;

	conf.cfg_file=CONFFILE;
	init_conf();
	
	n=connect_db();
	if (!n)
	{
		fprintf(stderr,"Error connecting to database\n");
		exit(1);
	}
	
	get_netdevs();
}

void	end()
{
	close_db();
}

int main()
{
	init();
	snmp_doit();
	update_db();
	end();
}
