/*
  Copyright (c) 2003 Stefanos Harhalakis

  This file is part of netmap.

  netmap is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  netmap is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with netmap; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _SNMP_H
#define _SNMP_H

#include "conf.h"

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>

struct	DEVICE_DATA
{
	snmp_session	session, *psession;
	oid		root_oid[MAX_OID_LEN];
	size_t		root_oid_len;
	oid		cur_oid[MAX_OID_LEN];
	size_t		cur_oid_len;
	
	int		status;	// -1: Error, 0: Begin
				// 1: Wait ifDescr, 2: Got it
				// 3: Wait ifInOctets, 4: Got it
				// 5: Wait ifOutOctets, 6: Got it
				// 100: Done
				
	NETDEV		*pnetdev;
};

void 	snmp_doit();
void	update_db();

#endif

