#
# AC_LIB_PROCLIST(MIN_VERSION)
# ----------------------------
# Detect libproclist and set CFLAGS, CXXFLAGS and LDFLAGS as needed
# Set variable proclist_static to point to the static lib
# Set use_static_proclist toy 1 if a static link with proclist is requited
# Substitute LIBPROCLIST with $proclist_static or -lvlib
AC_DEFUN([AC_LIB_PROCLIST],
	[
		AC_ARG_WITH(	proclist,
				[AC_HELP_STRING([--with-proclist=DIR],
							[where libproclist is installed])],
				[tmpPLpref="$with_proclist"	])

		AC_ARG_ENABLE(	static-proclist,
				[AC_HELP_STRING(	[--enable-static-proclist],
							[Use static version of proclist])],
				[if test "$enable_static_proclist" = "yes" ; then
					use_static_proclist=1
				else
					use_static_proclist=0
				fi],
				[use_static_proclist=0])

		AC_REQUIRE([AC_PROG_CC])

dnl		AC_REQUIRE([AC_LANG_CPLUSPLUS])

		AC_MSG_CHECKING([for libproclist])

		AC_MSG_RESULT([])

		AC_PATH_PROG(PL_CONFIG, proclist-config,[-],[$tmpPLpref/bin:$PATH])

		if test "$PL_CONFIG" = "-" ; then
			AC_MSG_ERROR([libproclist is required])
		else
			AC_CACHE_CHECK(	[libproclist version],
					[pl_cv_lib_version],
					[
						pl_cv_lib_version=`$PL_CONFIG --version`
					])
		fi

		tmpVER="$pl_cv_lib_version"
		tmpPL_V1=`echo "$tmpVER" | cut -d'.' -f1`
		tmpPL_V2=`echo "$tmpVER" | cut -d'.' -f2`
		tmpPL_V3=`echo "$tmpVER" | cut -d'.' -f3`

		tmpPL_RV1=`echo "$1" | cut -d'.' -f1`
		tmpPL_RV2=`echo "$1" | cut -d'.' -f2`
		tmpPL_RV3=`echo "$1" | cut -d'.' -f3`

		BAD=0

		if test "$tmpPL_V1" -lt "$tmpPL_RV1" ; then
			BAD=1
		else
			if test "$tmpPL_V1" -eq "$tmpPL_RV1"  ; then
				if test "$tmpPL_V2" -lt "$tmpPL_RV2" ; then
					BAD=1
				else
					if test "$tmpPL_V2" -eq "$tmpPL_RV2" ; then
						if test "$tmpPL_V3" -lt "$tmpPL_RV3" ; then
							BAD=1
						fi
					fi
				fi
			fi
		fi

		if test "$BAD" -eq 1 ; then
			AC_MSG_ERROR([libproclist $tmpPL_RV1.$tmpPL_RV2.$tmpPL_RV3 or newer is required])
		fi

		AC_CACHE_CHECK(	[for required extra CFLAGS],
				[pl_cv_extraenv_CFLAGS],
				[ AC_TRY_COMPILE(	[#include <proclist.h>	],
							[pl_get_proclist();],
							[pl_cv_extraenv_CFLAGS=none],
							[	tmpPL_xtra=`$PL_CONFIG --cxxflags`
								pl_cv_extraenv_CFLAGS="$tmpPL_xtra"
								tmpCFLAGS="${CFLAGS}"
								CFLAGS="${CFLAGS} $tmpPL_xtra"

								AC_TRY_COMPILE(	[#include <proclist.h>    ],
										[],
										[pl_cv_extraenv_CFLAGS="$tmpPL_xtra"],
										[pl_cv_extraenv_CFLAGS=""]
									)

								CFLAGS="${tmpCFLAGS}"
								]
					)]
			)

		if test "$pl_cv_extraenv_CFLAGS" = "" ; then
			AC_MSG_ERROR([Unable to compile sample program])
		fi

		if test ! "$pl_cv_extraenv_CFLAGS" = "none" ; then
			CFLAGS="${CFLAGS} $pl_cv_extraenv_CFLAGS"
			CXXFLAGS="${CXXFLAGS} $pl_cv_extraenv_CFLAGS"
		fi


		AC_CACHE_CHECK(	[for required extra LDFLAGS],
				[pl_cv_extraenv_LDFLAGS],
				[
					tmpLIBS="${LIBS}"
					LIBS="${LIBS} -lproclist"
					AC_TRY_LINK(	[#include <proclist.h>	],
							[pl_get_proclist();],
							[pl_cv_extraenv_LDFLAGS="none"],
							[
								tmpLDFLAGS="${LDFLAGS}"
								tmpPL_xtra=`$PL_CONFIG --ldflags`
								LDFLAGS="${LDFLAGS} $tmpPL_xtra"
								AC_TRY_LINK(	[#include<proclist.h>	],
										[pl_get_proclist();		],
										[pl_cv_extraenv_LDFLAGS="${tmpPL_xtra}"],
										[pl_cv_extraenv_LDFLAGS=""]
									)

								LDFLAGS="${tmpLDFLAGS}"
							])
					LIBS="${tmpLIBS}"
				])
		if test "$pl_cv_extraenv_LDFLAGS" = "" ; then
			AC_MSG_ERROR([Unable to link with libproclist])
		fi

		if test ! "$pl_cv_extraenv_LDFLAGS" = "none" ; then
			LDFLAGS="${LDFLAGS} $pl_cv_extraenv_LDFLAGS"
		fi

		AC_CACHE_CHECK(	[for static version],
				[pl_cv_path_static],
				[	pldir=`${PL_CONFIG} --libdir`
					if test -f "${pldir}/libproclist.a" ; then
						pl_cv_path_static="${pldir}/libproclist.a"
					else
						pl_cv_path_static="missing"
					fi])
		if test "${pl_cv_path_static}" = "missing" ; then
			proclist_static=""
		else
			proclist_static="${pl_cv_path_static}"
		fi

		if test "${use_static_proclist}" = "1" ; then
			AC_SUBST(LIBPROCLIST,[${proclist_static}])
		else
			AC_SUBST(LIBPROCLIST,[-lproclist])
		fi

	])	# AC_LIB_PROCLIST

