/*
  Copyright (c) 2002,2003,2004 Stefanos Harhalakis

  This file is part of libproclist.

  libproclist is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  libproclist is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with libproclist; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: pl_exec.c,v 1.2 2004/06/13 13:34:19 v13 Exp $
*/

/*
	Run the ps command
*/

#define PL_EXEC_CC

#include "config.h"

#include "pl_exec.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char	**pl_exec_psbuf=NULL;
int	pl_exec_psbuf_lines=0;

/*
	Clear the buffer
*/
static void	clear_buffer()
{
	int	n;

	if (pl_exec_psbuf==NULL)
		return;

	for (n=0;n<pl_exec_psbuf_lines;n++)
	{
		free(pl_exec_psbuf[n]);
	}

	free(pl_exec_psbuf);

	pl_exec_psbuf_lines=0;
	pl_exec_psbuf=NULL;
}

/*
	add a line to the buffer
	return: 0: ok
		-1: Error
*/
static int	add_buf_line(const char *line)
{
	pl_exec_psbuf_lines++;

	if (pl_exec_psbuf==NULL)
		pl_exec_psbuf=(char **)malloc(sizeof(char *) * pl_exec_psbuf_lines);
	else
		pl_exec_psbuf=(char **)realloc(pl_exec_psbuf, sizeof(char *) * pl_exec_psbuf_lines);

	if (pl_exec_psbuf==NULL)
	{
		return(-1);
	}

	pl_exec_psbuf[pl_exec_psbuf_lines-1]=strdup(line);

	return(0);
}



/*
	Run the ps command.
	Store the output in a buffer
	Return:
		>=0: Exit status of shell
		-1: Error on poppen()
		-2: Not enough memory
		-3: Other error
*/
int	pl_run_ps()
{
	FILE	*f;
	char	line[1024],*p;
	char	cmd[1024];
	int	n;
	int	ret;

	clear_buffer();

	sprintf(cmd,"%s %s 2>/dev/null",PS_COMMAND, PS_ARGS);

	f=popen(cmd,"r");

	if (f==NULL)
	{
		return(-1);
	}

	while (!feof(f))
	{
		p=fgets(line, 1024, f);

		if (p!=NULL)
		{
			if (strlen(line)>1020)	// WTF?
			{
				pclose(f);
				return(-3);
			}

			n=add_buf_line(line);
			if (n<0)
			{
				pclose(f);
				return(-2);
			}
		}
	}

	n=pclose(f);

	return(n);
}
