/*
  Copyright (c) 2002,2003,2004 Stefanos Harhalakis

  This file is part of libproclist.

  libproclist is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  libproclist is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with libproclist; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: pl_parse.c,v 1.3 2004/06/13 13:34:19 v13 Exp $
*/

#define _PL_PARSE_CC

#include "pl_parse.h"
#include "pl_exec.h"

#include "proclist.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct pl_procinfo	**pl_proclist=NULL;
int			pl_proclist_count=0;

static uid_t	get_uid(const char *name)
{
	uid_t		id;
	char		*p;
	struct passwd	*pwd;

	id=(uid_t)strtol(name,&p,10);

	if ((p==NULL) || (*p==0))
		return(id);

	pwd=getpwnam(name);
	if (pwd==NULL)
		return((uid_t)-1);

	id=pwd->pw_uid;

	return(id);
}

static gid_t	get_gid(const char *name)
{
	gid_t		id;
	char		*p;
	struct group	*grp;

	id=(gid_t)strtol(name,&p,10);

	if ((p==NULL) || (*p==0))
		return(id);

	grp=getgrnam(name);
	if (grp==NULL)
		return((gid_t)-1);

	id=grp->gr_gid;

	return(id);
}

static void	clear_pl_proclist()
{
	int	n;

	if (pl_proclist==NULL)
	{
		return;
	}

	for (n=0;n<pl_proclist_count;n++)
	{
		free(pl_proclist[n]->tty);
		free(pl_proclist[n]->cmd);
		free(pl_proclist[n]);
	}
	free(pl_proclist);
	pl_proclist=NULL;
	pl_proclist_count=0;
}

/*
	-1 : error
	0: OK
*/
static int	add_ps_line(pid_t pid, pid_t ppid, uid_t euid, gid_t egid, char *tty, char *cmd)
{
	char	*p;

	pl_proclist_count++;
	if (pl_proclist==NULL)
		pl_proclist=(struct pl_procinfo **)malloc(sizeof(struct pl_procinfo *) * pl_proclist_count);
	else
		pl_proclist=(struct pl_procinfo **)realloc(pl_proclist, sizeof(struct pl_procinfo *) * pl_proclist_count);

	if (pl_proclist==NULL)
		return(-1);

#define	KOKO	pl_proclist[pl_proclist_count-1]
	KOKO=(struct pl_procinfo *)malloc(sizeof(struct pl_procinfo));
	KOKO->pid=pid;
	KOKO->ppid=ppid;
	KOKO->euid=euid;
	KOKO->egid=egid;
	KOKO->tty=strdup(tty);
	KOKO->cmd=strdup(cmd);
	
	p=KOKO->cmd;
	while (*p && *p!='\n' && *p!='\r')	// Remove trailing CR/LF
		p++;
	*p=0;
#undef KOKO

	return(0);
}


/*
	-1: Error adding line to list
	0: Invalid line
	1: OK
*/
static int	parse_add_ps_line(char *line)
{
	char		*p;
	char		buf[101];
	char		tty[100];
	int		n;
	long		pid,ppid,euid,egid;
	char		*p2;

#define	NOSPACE	while(*p==' ' || *p=='\t') p++;
#define GET_STR	n=0; \
		while((n<100) && (*p!=' ' && *p!='\t' && *p!=0)) \
		{	\
			buf[n]=*p;	\
			n++; p++;	\
		}	\
		buf[n]=0;

	p=line;

	NOSPACE
	GET_STR
	pid=strtol(buf,&p2,10);
	if ((p2!=NULL) && (*p2!=0))	// invalid line
		return(0);

//	printf("pid={%s} (%d)\n",buf,pid);

	NOSPACE
	GET_STR
	ppid=strtol(buf,&p2,10);
	if ((p2!=NULL) && (*p2!=0))	// invalid line
		return(0);

//	printf("ppid={%s} (%d)\n",buf,ppid);

	NOSPACE
	GET_STR
	euid=get_uid(buf);

//	printf("user={%s} (%d)\n",buf,euid);

	NOSPACE
	GET_STR
	egid=get_gid(buf);

	NOSPACE
	GET_STR
	strcpy(tty,buf);

	NOSPACE
	GET_STR
	// buf is the command

//	printf("group={%s} (%d)\n",buf,egid);

#undef GET_STR
#undef NOSPACE
	
	n=add_ps_line(pid,ppid,euid,egid,tty,buf);

	if (n<0)
		return(-1);
		
	return(1);
}

/*
	Build the process list
	Return:
		-1: Error
		>0: Number of processes
*/
int	pl_get_procs()
{
	int	n,m,cnt;

	clear_pl_proclist();
	cnt=0;

	for (n=0;n<pl_exec_psbuf_lines;n++)
	{
//		printf("%s",buf[n]);
		m=parse_add_ps_line(pl_exec_psbuf[n]);
		if (m==-1)
			return(-1);
		if (m==1)
			cnt++;
	}

	return(cnt);
}


