/* src/proclist.h.  Generated by configure.  */
/*
  Copyright (c) 2002,2003,2004 Stefanos Harhalakis

  This file is part of libproclist.

  libproclist is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  libproclist is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with libproclist; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: proclist.h.in,v 1.4 2004/06/13 13:34:19 v13 Exp $
*/

#ifndef _PROCLIST_H
#define _PROCLIST_H

/* #undef uid_t */
/* #undef gid_t */
/* #undef pid_t */

#include <pwd.h>
#include <grp.h>
#include <sys/types.h>

struct pl_procinfo
{
	pid_t	pid;
	pid_t	ppid;
	uid_t	euid;
	gid_t	egid;
	char	*tty;
	char	*cmd;
};

#ifndef _PL_PARSE_CC
extern struct pl_procinfo	**pl_proclist;
extern int			pl_proclist_count;
#endif

/*
	Get the process list.
	Return:
		-1: Internal error
		0: Error executing ps
		>0: Number of processes
*/
#ifdef __cplusplus
extern "C" {
#endif

int	pl_get_proclist();

#ifdef __cplusplus
}
#endif

#endif
