﻿/****** Object:  Table [dbo].[BiCatProcesos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[BiCatProcesos](
	[IdProceso] [int] IDENTITY(1,1) NOT NULL,
	[Proceso] [varchar](50) NOT NULL,
	[Grabar] [bit] NOT NULL,
 CONSTRAINT [PK_BiCatProcesos] PRIMARY KEY CLUSTERED 
(
	[IdProceso] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[BiCatSistemas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[BiCatSistemas](
	[IdSistema] [int] IDENTITY(1,1) NOT NULL,
	[Sistema] [varchar](50) NOT NULL,
 CONSTRAINT [PK_BiCatSistemas] PRIMARY KEY CLUSTERED 
(
	[IdSistema] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Bitacora]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Bitacora](
	[IdBitacora] [int] IDENTITY(1,1) NOT NULL,
	[IdSistema] [int] NOT NULL,
	[IdModulo] [int] NOT NULL,
	[IdProceso] [int] NOT NULL,
	[IdUsuario] [int] NOT NULL,
	[Fecha] [smalldatetime] NOT NULL,
	[Descripcion] [varchar](50) NOT NULL,
 CONSTRAINT [PK_Bitacora] PRIMARY KEY CLUSTERED 
(
	[IdBitacora] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicContratantes]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicContratantes](
	[IdContratante] [int] IDENTITY(1,1) NOT NULL,
	[Contratante] [varchar](20) NOT NULL,
	[Nombre] [varchar](90) NOT NULL,
	[IdCiudad] [int] NULL,
	[Telefono] [varchar](30) NULL,
	[Direccion] [varchar](80) NULL,
	[Colonia] [varchar](30) NULL,
	[CodPost] [varchar](6) NULL,
	[Rfc] [varchar](13) NULL,
 CONSTRAINT [PK_LicContratantes] PRIMARY KEY CLUSTERED 
(
	[IdContratante] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicLicitaciones]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicLicitaciones](
	[IdLicitacion] [int] IDENTITY(1,1) NOT NULL,
	[Licitacion] [varchar](20) NOT NULL,
	[IdContratante] [int] NOT NULL,
	[IdResponsable] [int] NULL,
	[FechaLicitacion] [datetime] NOT NULL,
	[NumeroLicitacion] [varchar](40) NOT NULL,
	[LugarLicitacion] [varchar](110) NULL,
	[IdCiudadLicitacion] [int] NULL,
	[CodPostLicitacion] [varchar](6) NULL,
	[ColoniaLicitacion] [varchar](100) NULL,
	[DireccionLicitacion] [varchar](80) NULL,
	[PorcentajeIVA] [smallmoney] NOT NULL,
	[NombreObra] [varchar](500) NOT NULL,
	[IdCiudadObra] [int] NULL,
	[CodPostObra] [varchar](6) NULL,
	[ColoniaObra] [varchar](100) NULL,
	[DireccionObra] [varchar](80) NULL,
	[IdMoneda] [int] NOT NULL,
	[DecimalesRedondeo] [smallint] NOT NULL,
	[FechaFinal] [date] NOT NULL,
	[FechaInicio] [date] NOT NULL,
	[CapturarPorcentaje] [bit] NOT NULL,
	[NoPeriodos] [smallint] NOT NULL,
	[Periodicidad] [smallint] NOT NULL,
	[NumeroContrato] [varchar](30) NULL,
	[PermitirCantidadCero] [bit] NOT NULL,
	[EstatusLicitacion] [smallint] NOT NULL,
	[IdTipoLicitacion] [int] NOT NULL,
	[Version] [int] NOT NULL,
	[objIndirecto] [varbinary](max) NULL,
 CONSTRAINT [PK_LicLicitaciones] PRIMARY KEY CLUSTERED 
(
	[IdLicitacion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicLicitacionesContratistas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicLicitacionesContratistas](
	[IdLicitacionContratista] [int] IDENTITY(1,1) NOT NULL,
	[IdLicitacion] [int] NOT NULL,
	[IdContratista] [int] NULL,
	[Base] [bit] NOT NULL,
	[IndirectosCampo] [decimal](18, 0) NOT NULL,
	[IndirectoOficina] [decimal](18, 0) NOT NULL,
	[Financiamiento] [decimal](18, 0) NOT NULL,
	[Utilidad] [decimal](18, 0) NOT NULL,
	[CargosAdicionales] [decimal](18, 0) NOT NULL,
	[MontoCosto] [decimal](18, 0) NOT NULL,
	[MontoPrecio] [decimal](18, 0) NOT NULL,
	[InicioProyecto] [date] NOT NULL,
	[FinProyecto] [date] NULL,
	[Lugar] [smallint] NOT NULL,
	[Ganador] [bit] NOT NULL,
	[NumeroContratista] [smallint] NOT NULL,
 CONSTRAINT [PK_LicLicitacionesContratistas] PRIMARY KEY CLUSTERED 
(
	[IdLicitacionContratista] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicLicitacionesContratistasCuadro]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicLicitacionesContratistasCuadro](
	[IdLicitacionContratistaCuadro] [int] IDENTITY(1,1) NOT NULL,
	[IdLicitacionContratista] [int] NOT NULL,
	[IdLicitacionPresupuesto] [int] NOT NULL,
	[Costo] [decimal](18, 0) NOT NULL,
	[Precio] [decimal](18, 0) NOT NULL,
 CONSTRAINT [PK_LicLicitacionesContratistasCuadro] PRIMARY KEY CLUSTERED 
(
	[IdLicitacionContratistaCuadro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicLicitacionesContratistasDocumentos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicLicitacionesContratistasDocumentos](
	[IdLicitacionContratistaDocumento] [int] IDENTITY(1,1) NOT NULL,
	[IdLicitacionContratista] [int] NOT NULL,
	[NombreDocumento] [varchar](80) NOT NULL,
	[ObjDocumento] [varbinary](max) NULL,
	[Extension] [varchar](10) NOT NULL,
	[SustituyeVariables] [bit] NOT NULL,
	[EntregaContratista] [bit] NOT NULL,
 CONSTRAINT [PK_LicLicitacionesContratistasDocumentos] PRIMARY KEY CLUSTERED 
(
	[IdLicitacionContratistaDocumento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicLicitacionesContratistasInsumos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicLicitacionesContratistasInsumos](
	[IdLicitacionContratistaInsumo] [int] IDENTITY(1,1) NOT NULL,
	[IdLicitacionContratista] [int] NOT NULL,
	[IdLicitacionInsumo] [int] NOT NULL,
	[Costo] [decimal](18, 0) NOT NULL,
 CONSTRAINT [PK_LicLicitacionesContratistasInsumos] PRIMARY KEY CLUSTERED 
(
	[IdLicitacionContratistaInsumo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicLicitacionesContratistasPeriodos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicLicitacionesContratistasPeriodos](
	[IdLicitacionContratistaPeriodo] [int] IDENTITY(1,1) NOT NULL,
	[IdLicitacionContratista] [int] NOT NULL,
	[NoPeriodo] [smallint] NOT NULL,
	[Costo] [decimal](18, 0) NOT NULL,
	[Precio] [decimal](18, 0) NOT NULL,
 CONSTRAINT [PK_LicLicitacionesContratistasPeriodos] PRIMARY KEY CLUSTERED 
(
	[IdLicitacionContratistaPeriodo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicLicitacionesContratistasPrograma]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicLicitacionesContratistasPrograma](
	[IdLicitacionContratistaPrograma] [int] IDENTITY(1,1) NOT NULL,
	[IdLicitacionContratista] [int] NOT NULL,
	[IdLicitacionPresupuesto] [int] NOT NULL,
	[NoPeriodo] [smallint] NOT NULL,
	[Porcentaje] [decimal](18, 6) NOT NULL,
 CONSTRAINT [PK_LicLicitacionesContratistasPrograma] PRIMARY KEY CLUSTERED 
(
	[IdLicitacionContratistaPrograma] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicLicitacionesDocumentos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicLicitacionesDocumentos](
	[IdLicitacionDocumento] [int] IDENTITY(1,1) NOT NULL,
	[IdLicitacion] [int] NOT NULL,
	[NombreDocumento] [varchar](80) NOT NULL,
	[ObjDocumento] [varbinary](max) NULL,
	[Extension] [varchar](10) NOT NULL,
	[SustituyeVariables] [bit] NOT NULL,
	[EntregaContratista] [bit] NOT NULL,
 CONSTRAINT [PK_LicLicitacionesDocumentos] PRIMARY KEY CLUSTERED 
(
	[IdLicitacionDocumento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicLicitacionesFlujo]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicLicitacionesFlujo](
	[IdLicitacionFlujo] [int] IDENTITY(1,1) NOT NULL,
	[IdLicitacion] [int] NOT NULL,
	[Flujo] [varchar](20) NOT NULL,
	[Descripcion] [varchar](80) NOT NULL,
	[OrdenFlujo] [int] NOT NULL,
 CONSTRAINT [PK_LicLicitacionesFlujo] PRIMARY KEY CLUSTERED 
(
	[IdLicitacionFlujo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicLicitacionesFlujoDet]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicLicitacionesFlujoDet](
	[IdLicitacionFlujoDet] [int] IDENTITY(1,1) NOT NULL,
	[IdLicitacionFlujo] [int] NOT NULL,
	[Paso] [varchar](20) NOT NULL,
	[DescripcionPaso] [varchar](80) NOT NULL,
	[OrdenPaso] [int] NOT NULL,
 CONSTRAINT [PK_LicLicitacionesFlujoDet] PRIMARY KEY CLUSTERED 
(
	[IdLicitacionFlujoDet] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicLicitacionesInsumos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicLicitacionesInsumos](
	[IdLicitacionInsumo] [int] IDENTITY(1,1) NOT NULL,
	[IdLicitacion] [int] NOT NULL,
	[Codigo] [varchar](20) NOT NULL,
	[Descripcion] [varchar](8000) NOT NULL,
	[Unidad] [varchar](20) NOT NULL,
	[Tipo] [smallint] NOT NULL,
	[DescripcionTipo] [varchar](40) NOT NULL,
 CONSTRAINT [PK_LicLicitacionesInsumos] PRIMARY KEY CLUSTERED 
(
	[IdLicitacionInsumo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicLicitacionesPartidas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicLicitacionesPartidas](
	[IdLicitacionPartida] [int] IDENTITY(1,1) NOT NULL,
	[IdLicitacion] [int] NOT NULL,
	[IdPartidaPadre] [int] NULL,
	[Partida] [varchar](20) NOT NULL,
	[Renglon] [int] NOT NULL,
	[PartidaWBS] [varchar](120) NULL,
	[DescripcionPartida] [varchar](8000) NOT NULL,
 CONSTRAINT [PK_LicLicitacionesPartidas] PRIMARY KEY CLUSTERED 
(
	[IdLicitacionPartida] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicLicitacionesPresupuesto]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicLicitacionesPresupuesto](
	[IdLicitacionPresupuesto] [int] IDENTITY(1,1) NOT NULL,
	[IdLicitacion] [int] NOT NULL,
	[IdLicitacionPartida] [int] NOT NULL,
	[Control] [int] NOT NULL,
	[Renglon] [int] NOT NULL,
	[CantidadTotal] [decimal](18, 6) NOT NULL,
	[Codigo] [varchar](20) NOT NULL,
	[Descripcion] [varchar](8000) NOT NULL,
	[Unidad] [varchar](20) NOT NULL,
 CONSTRAINT [PK_LicLicitacionesPresupuesto] PRIMARY KEY CLUSTERED 
(
	[IdLicitacionPresupuesto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicTiposLicitacion]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicTiposLicitacion](
	[IdTipoLicitacion] [int] IDENTITY(1,1) NOT NULL,
	[TipoLicitacion] [varchar](20) NOT NULL,
	[Descripcion] [varchar](80) NULL,
 CONSTRAINT [PK_LicTiposLicitacion] PRIMARY KEY CLUSTERED 
(
	[IdTipoLicitacion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicTiposLicitacionDocumentos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicTiposLicitacionDocumentos](
	[IdTipoLicitacionDocumento] [int] IDENTITY(1,1) NOT NULL,
	[IdTipoLicitacion] [int] NOT NULL,
	[NombreDocumento] [varchar](80) NOT NULL,
	[ObjDocumento] [varbinary](max) NULL,
	[Extension] [varchar](10) NOT NULL,
	[SustituyeVariables] [bit] NOT NULL,
	[EntregaContratista] [bit] NOT NULL,
 CONSTRAINT [PK_LicTiposLicitacionDocumentos] PRIMARY KEY CLUSTERED 
(
	[IdTipoLicitacionDocumento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicTiposLicitacionFlujo]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicTiposLicitacionFlujo](
	[IdTipoLicitacionFlujo] [int] IDENTITY(1,1) NOT NULL,
	[IdTipoLicitacion] [int] NOT NULL,
	[Flujo] [varchar](20) NOT NULL,
	[Descripcion] [varchar](80) NOT NULL,
	[OrdenFlujo] [int] NOT NULL,
 CONSTRAINT [PK_LicTiposLicitacionPasos] PRIMARY KEY CLUSTERED 
(
	[IdTipoLicitacionFlujo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LicTiposLicitacionFlujoDet]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LicTiposLicitacionFlujoDet](
	[IdTipoLicitacionFlujoDet] [int] IDENTITY(1,1) NOT NULL,
	[IdTipoLicitacionFlujo] [int] NOT NULL,
	[Paso] [varchar](20) NOT NULL,
	[DescripcionPaso] [varchar](80) NOT NULL,
	[OrdenPaso] [int] NOT NULL,
 CONSTRAINT [PK_LicTiposLicitacionFlujoDet] PRIMARY KEY CLUSTERED 
(
	[IdTipoLicitacionFlujoDet] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCalendarios]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCalendarios](
	[IdCalendario] [int] IDENTITY(1,1) NOT NULL,
	[Calendario] [varchar](20) NOT NULL,
	[Descripcion] [varchar](40) NOT NULL,
	[Lunes] [bit] NOT NULL,
	[Martes] [bit] NOT NULL,
	[Miercoles] [bit] NOT NULL,
	[Jueves] [bit] NOT NULL,
	[Viernes] [bit] NOT NULL,
	[Sabado] [bit] NOT NULL,
	[Domingo] [bit] NOT NULL,
	[Predeterminado] [bit] NOT NULL,
 CONSTRAINT [PK_CvCalendarios] PRIMARY KEY CLUSTERED 
(
	[IdCalendario] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCalendariosDet]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCalendariosDet](
	[IdPuCalendarioDet] [int] IDENTITY(1,1) NOT NULL,
	[IdCalendario] [int] NOT NULL,
	[FechaNoLaborable] [datetime] NOT NULL,
	[Descripcion] [varchar](40) NOT NULL,
 CONSTRAINT [PK_PuCalendariosDet] PRIMARY KEY CLUSTERED 
(
	[IdPuCalendarioDet] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCamara]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCamara](
	[IdCamara] [int] IDENTITY(1,1) NOT NULL,
	[Codigo] [varchar](10) NOT NULL,
	[Descripcion] [varchar](50) NOT NULL,
 CONSTRAINT [PK_PuCamara] PRIMARY KEY CLUSTERED 
(
	[IdCamara] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCatalogo]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCatalogo](
	[IdCodigo] [int] IDENTITY(1,1) NOT NULL,
	[Codigo] [varchar](20) NOT NULL,
	[IdFamilia] [int] NULL,
	[IdProcedimiento] [int] NULL,
	[IdFichaTecnica] [int] NULL,
	[IdImagen] [int] NULL,
	[IdUnidad] [int] NOT NULL,
	[IdProveedor] [int] NULL,
	[DescripcionLarga] [varchar](8000) NOT NULL,
	[Descripcion] [varchar](40) NOT NULL,
	[IdTipo] [smallint] NOT NULL,
	[Referencia] [varchar](20) NULL,
	[EsPorcentaje] [tinyint] NOT NULL,
	[VolumenDefault] [decimal](18, 6) NOT NULL,
	[EsAgrupador] [bit] NOT NULL,
	[PorcentajeFondoGarantia] [smallmoney] NOT NULL,
 CONSTRAINT [PK_PuCatalogo] PRIMARY KEY CLUSTERED 
(
	[IdCodigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCatalogoIndices]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCatalogoIndices](
	[IdCatalogoIndice] [int] IDENTITY(1,1) NOT NULL,
	[IdCodigo] [int] NOT NULL,
	[IdFamiliaIndice] [int] NOT NULL,
 CONSTRAINT [PK_PuCatalogoIndices] PRIMARY KEY CLUSTERED 
(
	[IdCatalogoIndice] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCatDocumentosContratista]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCatDocumentosContratista](
	[IdCatDocumentoContratista] [int] IDENTITY(1,1) NOT NULL,
	[Codigo] [varchar](20) NOT NULL,
	[Descripcion] [varchar](100) NOT NULL,
	[Inscripcion] [bit] NOT NULL,
	[Refrendo] [bit] NOT NULL,
 CONSTRAINT [PK_PuCatDocumentosContratista] PRIMARY KEY CLUSTERED 
(
	[IdCatDocumentoContratista] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCatDocumentosContratos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCatDocumentosContratos](
	[IdCatDocumentoContrato] [int] IDENTITY(1,1) NOT NULL,
	[Codigo] [varchar](20) NOT NULL,
	[Descripcion] [varchar](100) NOT NULL,
 CONSTRAINT [PK_PuCatDocumentosContratos] PRIMARY KEY CLUSTERED 
(
	[IdCatDocumentoContrato] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCatEspecialidadesContratista]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCatEspecialidadesContratista](
	[IdCatEspecialidadContratista] [int] IDENTITY(1,1) NOT NULL,
	[Codigo] [varchar](10) NOT NULL,
	[Descripcion] [varchar](50) NOT NULL,
 CONSTRAINT [PK_PuEspecialidadesContratista] PRIMARY KEY CLUSTERED 
(
	[IdCatEspecialidadContratista] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCatMaquinariaContratista]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCatMaquinariaContratista](
	[IdCatMaquinariaContratista] [int] IDENTITY(1,1) NOT NULL,
	[Codigo] [varchar](10) NOT NULL,
	[Descripcion] [varchar](50) NOT NULL,
 CONSTRAINT [PK_PuCatMaquinariaContratista] PRIMARY KEY CLUSTERED 
(
	[IdCatMaquinariaContratista] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCentros]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCentros](
	[IdCentro] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[Centro] [varchar](20) NOT NULL,
	[Descripcion] [varchar](80) NOT NULL,
	[Acepta_Mov] [bit] NOT NULL,
	[Cerrado] [bit] NOT NULL,
	[Prototipo] [varchar](61) NULL,
	[Cliente] [varchar](114) NULL,
	[StatusCliente] [varchar](61) NULL,
	[SaldoVencido] [money] NULL,
	[CambioProyecto] [bit] NOT NULL,
	[TipoCredito] [varchar](61) NULL,
	[DTU] [date] NULL,
	[Terminada] [bit] NOT NULL,
	[FechaTerminacion] [date] NULL,
	[FechaPromesa] [date] NULL,
	[FechaTramite] [date] NULL,
	[Bloqueado] [bit] NOT NULL,
	[Observaciones] [nchar](200) NULL,
 CONSTRAINT [PK_PuCentros] PRIMARY KEY CLUSTERED 
(
	[IdCentro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCiudades]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCiudades](
	[IdCiudad] [int] IDENTITY(1,1) NOT NULL,
	[Ciudad] [varchar](20) NOT NULL,
	[Descripcion] [varchar](40) NOT NULL,
	[IdEstado] [int] NOT NULL,
 CONSTRAINT [PK_PuCiudades] PRIMARY KEY CLUSTERED 
(
	[IdCiudad] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuClientes]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuClientes](
	[IdCliente] [int] IDENTITY(1,1) NOT NULL,
	[Cliente] [varchar](20) NOT NULL,
	[Nombre] [varchar](1000) NOT NULL,
	[Direccion] [varchar](80) NULL,
	[Colonia] [varchar](30) NULL,
	[IdCiudad] [int] NULL,
	[CodigoPostal] [varchar](6) NULL,
	[Telefono] [varchar](30) NULL,
	[Mail] [varchar](100) NULL,
 CONSTRAINT [PK_PuClientes] PRIMARY KEY CLUSTERED 
(
	[IdCliente] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuClientesContactos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuClientesContactos](
	[IdClienteContacto] [int] IDENTITY(1,1) NOT NULL,
	[IdCliente] [int] NOT NULL,
	[Nombre] [varchar](80) NOT NULL,
	[Cargo] [varchar](100) NULL,
	[Telefono] [varchar](30) NULL,
	[Mail] [varchar](50) NULL,
 CONSTRAINT [PK_PuClientesContactos] PRIMARY KEY CLUSTERED 
(
	[IdClienteContacto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratantesConsecutivos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratantesConsecutivos](
	[IdContratanteConsecutivo] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[IdContratista] [int] NOT NULL,
	[FolioContrato] [int] NOT NULL,
 CONSTRAINT [PK_PuContratantesConsecutivos] PRIMARY KEY CLUSTERED 
(
	[IdContratanteConsecutivo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratistaMaquinaria]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratistaMaquinaria](
	[IdContratistaMaquinaria] [int] IDENTITY(1,1) NOT NULL,
	[IdContratista] [int] NOT NULL,
	[IdCatMaquinariaContratista] [int] NOT NULL,
	[Cantidad] [int] NOT NULL,
 CONSTRAINT [PK_PuContratistaMaquinaria] PRIMARY KEY CLUSTERED 
(
	[IdContratistaMaquinaria] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratistas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratistas](
	[IdContratista] [int] IDENTITY(1,1) NOT NULL,
	[Contratista] [varchar](20) NOT NULL,
	[IdMoneda] [int] NOT NULL,
	[RazonSocial] [varchar](120) NOT NULL,
	[Observaciones] [varchar](255) NULL,
	[idCiudad] [int] NOT NULL,
	[Delegacion] [varchar](30) NULL,
	[Direccion] [varchar](80) NULL,
	[NoExt] [varchar](10) NULL,
	[NoInt] [varchar](10) NULL,
	[Colonia] [varchar](30) NULL,
	[CodigoPostal] [varchar](6) NULL,
	[Telefono] [varchar](30) NULL,
	[Fax] [varchar](30) NULL,
	[Lada] [varchar](10) NULL,
	[Mail] [varchar](100) NULL,
	[Especialidad] [varchar](100) NULL,
	[NumEscritura] [varchar](20) NULL,
	[FechaEscritura] [datetime] NULL,
	[Notario] [varchar](80) NULL,
	[CiudadNotario] [varchar](80) NULL,
	[CiudadRegistroNotario] [varchar](80) NULL,
	[FolioRegistroNotario] [varchar](20) NULL,
	[DomicilioNotario] [varchar](120) NULL,
	[RepresentanteLegal] [varchar](80) NULL,
	[EscrituraRepresentante] [varchar](20) NULL,
	[FechaEscrituraRepresentante] [datetime] NULL,
	[NotarioRepresentante] [varchar](80) NULL,
	[NumeroNotaria] [varchar](10) NULL,
	[RFC] [varchar](15) NULL,
	[RegistroCamara] [varchar](30) NULL,
	[NumeroRegistroCamara] [varchar](40) NULL,
	[FechaInscripcionRegistro] [datetime] NULL,
	[CiudadInscripcionRegistro] [varchar](20) NULL,
	[NumeroRegistroPublico] [varchar](40) NULL,
	[VolumenEscritura] [varchar](20) NULL,
	[FojasEscritura] [varchar](20) NULL,
	[LibroEscritura] [varchar](20) NULL,
	[ObjetoSocial] [varchar](255) NULL,
	[RegistroIMSS] [varchar](20) NULL,
	[Infonavit] [varchar](20) NULL,
	[EsDestajista] [bit] NOT NULL,
	[NoPreregistro] [int] NULL,
	[Emp_IdSesionCAOP] [int] NULL,
	[Emp_IdTipoProveedor] [int] NULL,
	[Emp_NoEmpresa] [int] NULL,
	[Emp_IdContribuyente] [int] NULL,
	[Emp_NoInscripcion2008] [int] NULL,
	[Emp_NoInscripcion2007] [int] NULL,
	[Emp_CapitalContable] [money] NULL,
	[Emp_EsPersonaFisica] [bit] NOT NULL,
	[Emp_Observaciones] [text] NULL,
	[ConstE_IdEmpresaAfianzadora] [int] NULL,
	[ConstE_ImporteLineaAfianciamiento] [money] NULL,
	[AccE_Accionista1] [varchar](50) NULL,
	[AccE_Accionista2] [varchar](50) NULL,
	[AccE_Accionista3] [varchar](50) NULL,
	[AccE_Accionista4] [varchar](50) NULL,
	[AccE_Accionista5] [varchar](50) NULL,
	[AccE_Accionista6] [varchar](50) NULL,
	[RegisE_RegOPM] [varchar](12) NULL,
	[RegisE_FechaPreregistro] [datetime] NULL,
	[RegisE_FechaBalance] [datetime] NULL,
	[RegisE_LicMunicipal] [varchar](20) NULL,
	[RegisE_RegIMSS] [varchar](20) NULL,
	[RegisE_RegINFONAVIT] [varchar](20) NULL,
	[RegisE_RegEstatal] [varchar](20) NULL,
	[RegisE_SEDEUR] [varchar](20) NULL,
	[RegisE_IdCamara] [int] NULL,
	[RegisE_RegCamara] [varchar](20) NULL,
	[RegisE_FechaEntregaConstancia] [datetime] NULL,
	[DatosC_FechaOficio] [datetime] NULL,
	[DatosC_NoOficio] [int] NULL,
	[DatosC_IdStatusControlPadron] [int] NULL,
	[DatosC_VigenciaRegistroOPM] [datetime] NULL,
	[DatosC_FechaInscripcion] [datetime] NULL,
	[DatosC_NIPInternet] [varchar](50) NULL,
	[DatosC_CalificacionCalidad] [int] NULL,
	[Perito_NombreResponsable] [varchar](70) NULL,
	[Perito_Carrera] [varchar](70) NULL,
	[Perito_Cedula] [varchar](20) NULL,
	[Perito_FechaCedula] [datetime] NULL,
	[Perito_RegistroOPM] [varchar](20) NULL,
	[Perito_RegistroColegio] [varchar](20) NULL,
	[IdUsuario] [int] NULL,
	[IdUsuarioImprimeContrarecibo] [int] NULL,
	[IdUsuarioGeneraRegistroDefinitivo] [int] NULL,
 CONSTRAINT [PK_PuContratistas] PRIMARY KEY CLUSTERED 
(
	[IdContratista] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratistasActividades]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratistasActividades](
	[IdContratistaActividad] [int] IDENTITY(1,1) NOT NULL,
	[IdContratista] [int] NOT NULL,
	[IdCodigo] [int] NOT NULL,
 CONSTRAINT [PK_PuContratistasActividades] PRIMARY KEY CLUSTERED 
(
	[IdContratistaActividad] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratistasDocumentos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratistasDocumentos](
	[IdContratistaDocumento] [int] IDENTITY(1,1) NOT NULL,
	[IdContratista] [int] NOT NULL,
	[Extension] [varchar](10) NULL,
	[Descripcion] [varchar](100) NOT NULL,
	[Entregado] [bit] NOT NULL,
	[Inscripcion] [bit] NOT NULL,
	[Refrendo] [bit] NOT NULL,
	[ObjContratistaDocumento] [varbinary](max) NULL,
 CONSTRAINT [PK_PuContratistasDocumentos] PRIMARY KEY CLUSTERED 
(
	[IdContratistaDocumento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratistasEspecialidades]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratistasEspecialidades](
	[IdContratistaEspecialidad] [int] IDENTITY(1,1) NOT NULL,
	[IdContratista] [int] NOT NULL,
	[IdCatEspecialidadContratista] [int] NOT NULL,
	[Porcentaje] [money] NOT NULL,
 CONSTRAINT [PK_PuContratistasEspecialidades] PRIMARY KEY CLUSTERED 
(
	[IdContratistaEspecialidad] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratistasRefrendos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratistasRefrendos](
	[IdContratistaRefrendo] [int] IDENTITY(1,1) NOT NULL,
	[IdContratista] [int] NOT NULL,
	[FechaRefrendo] [datetime] NOT NULL,
	[FechaVigencia] [datetime] NOT NULL,
	[IdUsuarioRefrendo] [int] NOT NULL,
 CONSTRAINT [PK_PuContratistasRefrendos] PRIMARY KEY CLUSTERED 
(
	[IdContratistaRefrendo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratistasRepresentantesL]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratistasRepresentantesL](
	[IdRepresentanteLegal] [int] IDENTITY(1,1) NOT NULL,
	[RepresentanteLegal] [varchar](50) NULL,
	[Caracter] [varchar](120) NULL,
	[NoActaConstitutiva] [int] NULL,
	[FechaEscritura] [datetime] NULL,
	[NoNotariaPublica] [int] NULL,
	[NombreNotario] [varchar](50) NULL,
	[IdCiudad] [int] NULL,
	[IdContratista] [int] NOT NULL,
 CONSTRAINT [PK_PuContratistasRepresentantesL] PRIMARY KEY CLUSTERED 
(
	[IdRepresentanteLegal] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratos](
	[IdContrato] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[FolioContrato] [int] NOT NULL,
	[FolioAuxiliar] [varchar](30) NULL,
	[idContratista] [int] NOT NULL,
	[IdContratante] [int] NOT NULL,
	[Fecha] [datetime] NOT NULL,
	[Descripcion] [varchar](500) NOT NULL,
	[CapturarPorcentajeAnticipo] [bit] NOT NULL,
	[PorcentajeAnticipo] [money] NOT NULL,
	[Anticipo] [money] NOT NULL,
	[CapturarPorcentajeFonGar] [bit] NOT NULL,
	[PorcentajeFonGar] [money] NOT NULL,
	[FonGar] [money] NOT NULL,
	[PorcentajeIVA] [money] NOT NULL,
	[Iva] [money] NOT NULL,
	[FechaInicial] [datetime] NOT NULL,
	[FechaFin] [datetime] NOT NULL,
	[FianzaAnticipo] [varchar](15) NULL,
	[FianzaCumplimiento] [varchar](15) NULL,
	[FianzaGarantia] [varchar](15) NULL,
	[ImporteSubcontrato] [money] NOT NULL,
	[ImporteOrdenesCambio] [money] NOT NULL,
	[Finiquitado] [bit] NOT NULL,
	[idResidente] [int] NOT NULL,
	[idSupIntendente1] [int] NULL,
	[idSupIntendente2] [int] NULL,
	[idVoBo] [int] NULL,
	[DocumentoLegal] [varchar](8000) NULL,
	[Objeto] [varchar](500) NULL,
	[Autorizado] [bit] NOT NULL,
	[Cancelado] [bit] NOT NULL,
	[IdPlantillaContrato] [int] NULL,
	[FolioEstimaciones] [int] NOT NULL,
	[FolioOC] [int] NOT NULL,
	[TipoCosto] [int] NOT NULL,
	[IdFirma1] [int] NULL,
	[IdFirma2] [int] NULL,
	[IdFirma3] [int] NULL,
	[IdFirma4] [int] NULL,
	[IdFirma5] [int] NULL,
	[IdFirma6] [int] NULL,
	[IdFirma7] [int] NULL,
	[IdFirma8] [int] NULL,
	[Concepto1] [varchar](80) NULL,
	[Concepto2] [varchar](80) NULL,
	[Concepto3] [varchar](80) NULL,
	[Concepto4] [varchar](80) NULL,
	[Concepto5] [varchar](80) NULL,
	[Concepto6] [varchar](80) NULL,
	[Concepto7] [varchar](80) NULL,
	[Concepto8] [varchar](80) NULL,
	[LugarDeExpedicion] [varchar](80) NULL,
	[EsProveedor] [bit] NOT NULL,
	[TipoContrato] [varchar](50) NULL,
	[ImporteDelEjercicio] [money] NOT NULL,
	[FechaAnticipo] [date] NULL,
	[FechaPartida] [date] NULL,
	[PartidaPresupuestal] [varchar](50) NULL,
	[MontoIncumplimiento] [money] NOT NULL,
	[DiasSuspensionObra] [varchar](20) NULL,
	[VecesSuspensionObra] [varchar](20) NULL,
	[DocumentosAnexos] [varchar](20) NULL,
	[CiudadFirmaContrato] [varchar](20) NULL,
	[MontoFianza] [money] NOT NULL,
	[EsDestajo] [bit] NOT NULL,
	[NumeroRegistroAdjudicacion] [int] NULL,
	[NumeroLicitacion] [varchar](40) NULL,
	[IdPrograma] [int] NULL,
	[VersionSAP] [int] NULL,
 CONSTRAINT [PK_PuContratos] PRIMARY KEY CLUSTERED 
(
	[IdContrato] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratosConsecutivos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratosConsecutivos](
	[IdContratoConsecutivo] [int] IDENTITY(1,1) NOT NULL,
	[IdContrato] [int] NOT NULL,
	[FolioOrdenCambio] [int] NOT NULL,
	[FolioEstimacion] [int] NOT NULL,
	[FolioRenglonContrato] [int] NOT NULL,
	[FolioGenerador] [int] NOT NULL,
	[ConsecutivoEstimacion] [int] NOT NULL,
 CONSTRAINT [PK_PuContratosConsecutivos] PRIMARY KEY CLUSTERED 
(
	[IdContratoConsecutivo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratosDeducciones]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratosDeducciones](
	[IdContratoDeduccion] [int] IDENTITY(1,1) NOT NULL,
	[IdContrato] [int] NOT NULL,
	[IdDeduccion] [int] NOT NULL,
	[Porcentaje] [money] NOT NULL,
 CONSTRAINT [PK_PuContratosDeducciones] PRIMARY KEY CLUSTERED 
(
	[IdContratoDeduccion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratosDet]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratosDet](
	[IdContratoDet] [int] IDENTITY(1,1) NOT NULL,
	[IdContrato] [int] NOT NULL,
	[IdPresupuestoConcepto] [int] NOT NULL,
	[Renglon] [int] NOT NULL,
	[Cantidad] [decimal](18, 6) NOT NULL,
	[CantidadAdicional] [decimal](18, 6) NOT NULL,
	[Costo] [money] NOT NULL,
	[DescripcionLarga] [varchar](8000) NOT NULL,
	[Costo97] [decimal](19, 4) NOT NULL,
	[ExportadoSAP] [bit] NOT NULL,
 CONSTRAINT [PK_PuContratosDet] PRIMARY KEY CLUSTERED 
(
	[IdContratoDet] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratosDocumentos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratosDocumentos](
	[IdContratoDocumento] [int] IDENTITY(1,1) NOT NULL,
	[IdContrato] [int] NOT NULL,
	[Codigo] [varchar](20) NOT NULL,
	[Descripcion] [varchar](100) NOT NULL,
	[Entregado] [bit] NOT NULL,
 CONSTRAINT [PK_PuContratosDocumentos] PRIMARY KEY CLUSTERED 
(
	[IdContratoDocumento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratosFacturas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratosFacturas](
	[IdContratoFactura] [int] IDENTITY(1,1) NOT NULL,
	[IdContrato] [int] NOT NULL,
	[IdDocumento] [int] NOT NULL,
	[VersionContratoFactura] [varchar](20) NULL,
	[ObjContratoFactura] [varbinary](max) NULL,
 CONSTRAINT [PK_PuContratosFacturas] PRIMARY KEY CLUSTERED 
(
	[IdContratoFactura] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratosMonedas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratosMonedas](
	[IdContratoMoneda] [int] IDENTITY(1,1) NOT NULL,
	[IdContrato] [int] NOT NULL,
	[IdMoneda] [int] NOT NULL,
	[Paridad] [decimal](18, 8) NOT NULL,
 CONSTRAINT [PK_PuContratosMonedas] PRIMARY KEY CLUSTERED 
(
	[IdContratoMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContratosPlantillas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContratosPlantillas](
	[IdContratoPlantilla] [int] IDENTITY(1,1) NOT NULL,
	[IdContrato] [int] NOT NULL,
	[IdDocumento] [int] NOT NULL,
	[VersionContratoPlantilla] [varchar](20) NULL,
	[ObjContratoPlantilla] [varbinary](max) NULL,
 CONSTRAINT [PK_PuContratosPlantillas] PRIMARY KEY CLUSTERED 
(
	[IdContratoPlantilla] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuContribuyente]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuContribuyente](
	[IdContribuyente] [int] IDENTITY(1,1) NOT NULL,
	[Codigo] [varchar](10) NOT NULL,
	[Descripcion] [varchar](50) NOT NULL,
 CONSTRAINT [PK_PuContribuyente] PRIMARY KEY CLUSTERED 
(
	[IdContribuyente] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuConversionesAcad]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuConversionesAcad](
	[IdConversionAcad] [int] IDENTITY(1,1) NOT NULL,
	[IdUnidad] [int] NOT NULL,
	[IdUnidadAcad] [int] NOT NULL,
 CONSTRAINT [PK_PuConversionesAcad] PRIMARY KEY CLUSTERED 
(
	[IdConversionAcad] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCostosHorarios]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCostosHorarios](
	[IdCostoHorario] [int] IDENTITY(1,1) NOT NULL,
	[IdExpIns] [int] NOT NULL,
	[IdExpInsCF] [int] NOT NULL,
	[IdExpInsVa] [int] NULL,
	[IdExpInsLla] [int] NULL,
	[IdExpInsComb] [int] NULL,
	[IdExpInsAcei] [int] NULL,
	[IdExpInsOtrasFuentes] [int] NULL,
	[IdExpInsPza] [int] NULL,
	[IdExpinsE] [int] NULL,
	[IdExpinsR] [int] NULL,
	[foper] [decimal](18, 10) NOT NULL,
	[potencia] [decimal](18, 10) NOT NULL,
	[ve] [int] NOT NULL,
	[ha] [int] NOT NULL,
	[vr] [decimal](18, 10) NOT NULL,
	[s] [decimal](18, 10) NOT NULL,
	[q] [decimal](18, 10) NOT NULL,
	[factcomb] [decimal](18, 6) NOT NULL,
	[ccarter] [decimal](18, 4) NOT NULL,
	[horasc] [int] NOT NULL,
	[faceite] [decimal](18, 6) NOT NULL,
	[hllantas] [int] NOT NULL,
	[hPiezas] [int] NOT NULL,
	[NumSerie] [varchar](20) NULL,
	[Capacidad] [varchar](25) NULL,
	[VidaUtil] [varchar](25) NULL,
	[ValorComercial] [money] NOT NULL,
	[Disponibilidad] [varchar](1) NULL,
	[Modelo] [varchar](25) NULL,
	[Ubicacion] [varchar](25) NULL,
	[Marca] [varchar](25) NULL,
	[factFuentes] [decimal](18, 6) NOT NULL,
	[UnidadPotencia] [varchar](5) NOT NULL,
	[Propietario] [varchar](80) NULL,
	[TipoCombustible] [smallint] NOT NULL,
	[CalculoDetallado] [bit] NOT NULL,
	[CantidadCombustible] [decimal](18, 6) NOT NULL,
	[CantidadLubricante] [decimal](18, 6) NOT NULL,
	[ProponerCodigos] [bit] NOT NULL,
 CONSTRAINT [PK_PuCostosHorarios] PRIMARY KEY CLUSTERED 
(
	[IdCostoHorario] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCostosHorariosMO]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCostosHorariosMO](
	[IdCostoHorarioMO] [int] IDENTITY(1,1) NOT NULL,
	[IdCostoHorario] [int] NOT NULL,
	[IdExpins] [int] NOT NULL,
	[Renglon] [smallint] NOT NULL,
	[Dividir] [bit] NOT NULL,
	[Volumen] [decimal](18, 6) NOT NULL,
 CONSTRAINT [PK_PuCostosHorariosMO] PRIMARY KEY CLUSTERED 
(
	[IdCostoHorarioMO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCostosHorariosOC]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCostosHorariosOC](
	[IdCostoHorarioOC] [int] IDENTITY(1,1) NOT NULL,
	[IdCostoHorario] [int] NOT NULL,
	[IdExpins] [int] NOT NULL,
	[Renglon] [smallint] NOT NULL,
	[Dividir] [bit] NOT NULL,
	[Volumen] [decimal](18, 6) NOT NULL,
 CONSTRAINT [PK_PuCostosHorariosOC] PRIMARY KEY CLUSTERED 
(
	[IdCostoHorarioOC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCostosHorariosTI]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCostosHorariosTI](
	[IdCostoHorarioTI] [int] IDENTITY(1,1) NOT NULL,
	[IdCostoHorario] [int] NOT NULL,
	[IdMoneda] [int] NOT NULL,
	[TasaInteres] [decimal](18, 10) NOT NULL,
 CONSTRAINT [PK_PuCostosHorariosTI] PRIMARY KEY CLUSTERED 
(
	[IdCostoHorarioTI] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCostosXCiudad]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCostosXCiudad](
	[IdCostoXCiudad] [int] IDENTITY(1,1) NOT NULL,
	[IdCiudad] [int] NOT NULL,
	[IdCodigo] [int] NOT NULL,
	[IdProveedor] [int] NOT NULL,
	[IdMoneda] [int] NOT NULL,
	[Fecha] [datetime] NOT NULL,
	[Costo] [money] NOT NULL,
	[ProveedorDefault] [bit] NOT NULL,
 CONSTRAINT [PK_PuCostoXCiudad] PRIMARY KEY CLUSTERED 
(
	[IdCostoXCiudad] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuCuotasVigentesImss]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuCuotasVigentesImss](
	[IdCuotasVigentesImss] [int] IDENTITY(1,1) NOT NULL,
	[Clave] [varchar](4) NOT NULL,
	[CuotaFijaPat] [money] NULL,
	[ExcedentePat] [money] NULL,
	[ExcedenteAse] [money] NULL,
	[PrestDinPat] [money] NULL,
	[PrestDinAse] [money] NULL,
	[GastoMedPenPat] [money] NULL,
	[GastoMedPenAse] [money] NULL,
	[InvalidezVidaPat] [money] NULL,
	[InvalidezVidaAse] [money] NULL,
	[GuarderiasPat] [money] NULL,
	[RetiroPat] [money] NULL,
	[CesantiaVejezPat] [money] NULL,
	[CesantiaVejezAse] [money] NULL,
	[LimiteSuperior1] [money] NULL,
	[LimiteSuperior2] [money] NULL,
 CONSTRAINT [PK_PuCuotasVigentesImss] PRIMARY KEY CLUSTERED 
(
	[IdCuotasVigentesImss] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuDeducciones]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuDeducciones](
	[IdDeduccion] [int] IDENTITY(1,1) NOT NULL,
	[Deduccion] [varchar](20) NOT NULL,
	[Descripcion] [varchar](80) NOT NULL,
	[Porcentaje] [money] NULL,
 CONSTRAINT [PK_PuDeducciones] PRIMARY KEY CLUSTERED 
(
	[IdDeduccion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuDocumentos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuDocumentos](
	[IdDocumento] [int] IDENTITY(1,1) NOT NULL,
	[Documento] [varchar](80) NOT NULL,
	[Neodata] [bit] NOT NULL,
	[IdTipoDocumento] [int] NOT NULL,
	[Version] [varchar](20) NULL,
	[Extension] [varchar](10) NOT NULL,
	[ObjDocumento] [varbinary](max) NULL,
	[ObjImagen] [varbinary](max) NULL,
 CONSTRAINT [PK_PuDocumentos] PRIMARY KEY CLUSTERED 
(
	[IdDocumento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuEmpresaAfianzadora]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuEmpresaAfianzadora](
	[IdEmpresaAfianzadora] [int] IDENTITY(1,1) NOT NULL,
	[Codigo] [varchar](10) NOT NULL,
	[Descripcion] [varchar](50) NOT NULL,
 CONSTRAINT [PK_PuEmpresaAfianzadora] PRIMARY KEY CLUSTERED 
(
	[IdEmpresaAfianzadora] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuEmpresas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuEmpresas](
	[IdEmpresa] [int] IDENTITY(1,1) NOT NULL,
	[Empresa] [varchar](20) NOT NULL,
	[RazonSocial] [varchar](100) NOT NULL,
	[Direccion] [varchar](80) NULL,
	[Colonia] [varchar](30) NULL,
	[IdCiudad] [int] NULL,
	[Telefono] [varchar](30) NULL,
	[Mail] [varchar](50) NULL,
	[RFC] [varchar](13) NULL,
	[IMSS] [varchar](10) NULL,
	[CMIC] [varchar](40) NULL,
	[Infonavit] [varchar](20) NULL,
	[IdResponsable] [int] NULL,
	[Fax] [varchar](30) NULL,
	[CodigoPostal] [varchar](6) NULL,
	[SitioWeb] [varchar](50) NULL,
 CONSTRAINT [PK_PuEmpresas] PRIMARY KEY CLUSTERED 
(
	[IdEmpresa] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuEstados]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuEstados](
	[IdEstado] [int] IDENTITY(1,1) NOT NULL,
	[Estado] [varchar](5) NOT NULL,
	[Nombre] [varchar](30) NULL,
 CONSTRAINT [PK_Estados] PRIMARY KEY CLUSTERED 
(
	[IdEstado] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuEstimaciones]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuEstimaciones](
	[IdEstimacion] [int] IDENTITY(1,1) NOT NULL,
	[IdContrato] [int] NOT NULL,
	[IdEstimacionTipo] [int] NOT NULL,
	[FolioEstimacion] [int] NOT NULL,
	[ConsecutivoEstimacion] [int] NOT NULL,
	[FolioAuxiliar] [varchar](30) NULL,
	[ImporteAnticipo] [money] NOT NULL,
	[PorcentajeAnticipo] [decimal](18, 6) NOT NULL,
	[CapturarPorcentajeAnticipo] [bit] NOT NULL,
	[ImporteFonGar] [money] NOT NULL,
	[PorcentajeFonGar] [decimal](18, 6) NOT NULL,
	[CapturarPorcentajeFonGar] [bit] NOT NULL,
	[DevolucionFonGar] [money] NOT NULL,
	[PorcentajeFonGarDev] [decimal](18, 6) NOT NULL,
	[CapturarPorcentajeFonGarDev] [bit] NOT NULL,
	[PagoACuenta] [money] NULL,
	[ImporteDeductiva] [money] NOT NULL,
	[ImporteDescuentos] [money] NOT NULL,
	[ImporteLiquido] [money] NOT NULL,
	[FechaInicial] [datetime] NOT NULL,
	[FechaFin] [datetime] NOT NULL,
	[ImporteIVA] [money] NOT NULL,
	[Observaciones] [varchar](8000) NULL,
	[Cancelada] [bit] NOT NULL,
	[idUsuarioCancelada] [int] NULL,
	[Elaborada] [bit] NOT NULL,
	[idUsuarioElaborada] [int] NULL,
	[FechaElaborada] [datetime] NULL,
	[EnRevision] [bit] NOT NULL,
	[idUsuarioEnRevision] [int] NULL,
	[FechaEnRevision] [datetime] NULL,
	[Aprobada] [bit] NOT NULL,
	[idUsuarioAprobada] [int] NULL,
	[FechaAprobada] [datetime] NULL,
	[Pagada] [bit] NOT NULL,
	[idUsuarioPagada] [int] NULL,
	[FechaPagada] [datetime] NULL,
	[AvanceFisico] [money] NOT NULL,
	[AvanceFinanciero] [money] NOT NULL,
 CONSTRAINT [PK_PuEstimaciones] PRIMARY KEY CLUSTERED 
(
	[IdEstimacion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuEstimacionesDeducciones]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuEstimacionesDeducciones](
	[IdEstimacionDeduccion] [int] IDENTITY(1,1) NOT NULL,
	[IdEstimacion] [int] NOT NULL,
	[IdDeduccion] [int] NOT NULL,
	[Porcentaje] [decimal](18, 6) NOT NULL,
	[Importe] [money] NOT NULL,
	[CapturarPorcentaje] [bit] NOT NULL,
 CONSTRAINT [PK_PuEstimacionesDeducciones] PRIMARY KEY CLUSTERED 
(
	[IdEstimacionDeduccion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuEstimacionesDet]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuEstimacionesDet](
	[IdEstimacionDet] [int] IDENTITY(1,1) NOT NULL,
	[IdEstimacion] [int] NOT NULL,
	[IdContratoDet] [int] NOT NULL,
	[Cantidad] [decimal](18, 6) NOT NULL,
	[Costo] [money] NOT NULL,
 CONSTRAINT [PK_PuEstimacionesDet] PRIMARY KEY CLUSTERED 
(
	[IdEstimacionDet] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuEstimacionesEstatusHistorico]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuEstimacionesEstatusHistorico](
	[idEstimacionEstatusH] [int] IDENTITY(1,1) NOT NULL,
	[idEstimacion] [int] NOT NULL,
	[idUsuario] [int] NOT NULL,
	[FechaCambio] [smalldatetime] NOT NULL,
	[EstatusAnt] [int] NOT NULL,
	[EstatusNvo] [int] NOT NULL,
	[Observaciones] [varchar](100) NULL,
 CONSTRAINT [PK_PuEstimacionesEstatusHistorico] PRIMARY KEY CLUSTERED 
(
	[idEstimacionEstatusH] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuEstimacionesTipos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuEstimacionesTipos](
	[IdEstimacionTipo] [int] NOT NULL,
	[EstimacionTipo] [varchar](20) NOT NULL,
	[Sigla] [varchar](1) NOT NULL,
 CONSTRAINT [PK_PuTiposConceptos] PRIMARY KEY CLUSTERED 
(
	[IdEstimacionTipo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuExpIns]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuExpIns](
	[IdExpIns] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[IdCodigo] [int] NOT NULL,
	[IdProveedor] [int] NULL,
	[IdIntelimat] [int] NULL,
	[Expins] [decimal](18, 8) NOT NULL,
	[Nivel] [smallint] NOT NULL,
	[ExpInsl] [bit] NOT NULL,
	[InsumoIntegrado] [bit] NOT NULL,
	[Participa] [bit] NOT NULL,
	[EsCostoHorario] [bit] NOT NULL,
	[IdPresupuestoPartida] [int] NULL,
	[Marca] [bit] NOT NULL,
	[PendienteAnalizar] [bit] NOT NULL,
	[ObservacionPendiente] [varchar](40) NULL,
	[CantidadParaRequerir] [decimal](18, 8) NOT NULL,
 CONSTRAINT [PK_PuCostos] PRIMARY KEY CLUSTERED 
(
	[IdExpIns] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuExpInsCostos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuExpInsCostos](
	[IdExpInsCosto] [int] IDENTITY(1,1) NOT NULL,
	[IdExpIns] [int] NOT NULL,
	[IdMoneda] [int] NOT NULL,
	[Costo] [money] NOT NULL,
	[Fecha] [datetime] NOT NULL,
	[Costo93] [money] NOT NULL,
	[Costo94] [money] NOT NULL,
	[Costo95] [money] NOT NULL,
	[Costo96] [money] NOT NULL,
	[Costo97] [money] NOT NULL,
	[Costo98] [money] NOT NULL,
 CONSTRAINT [PK_PuExpInsCostos] PRIMARY KEY CLUSTERED 
(
	[IdExpInsCosto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuExpInsCostosBitacora]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuExpInsCostosBitacora](
	[IdExpInsCostoBitacora] [int] IDENTITY(1,1) NOT NULL,
	[IdExpInsCosto] [int] NOT NULL,
	[Fecha] [datetime] NOT NULL,
	[IdUsuario] [int] NOT NULL,
	[Costo] [money] NOT NULL,
 CONSTRAINT [PK_PuExpInsCostosBitacora] PRIMARY KEY CLUSTERED 
(
	[IdExpInsCostoBitacora] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuExpinsCostosEQ]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuExpinsCostosEQ](
	[IdExpinsCostosEQ] [int] IDENTITY(1,1) NOT NULL,
	[IdExpInsCosto] [int] NOT NULL,
	[CostoCF] [money] NOT NULL,
	[CostoMO] [money] NOT NULL,
	[CostoCO] [money] NOT NULL,
 CONSTRAINT [PK_PuExpinsCostosEQ] PRIMARY KEY CLUSTERED 
(
	[IdExpinsCostosEQ] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuExpInsCostosOP]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuExpInsCostosOP](
	[IdExpInsCostoOP] [int] IDENTITY(1,1) NOT NULL,
	[IdExpInsCosto] [int] NOT NULL,
	[CostoLAB] [money] NOT NULL,
	[Fletes] [money] NOT NULL,
	[Maniobra] [money] NOT NULL,
	[Almacenaje] [money] NOT NULL,
	[Derechos] [money] NOT NULL,
	[Mermas] [money] NOT NULL,
 CONSTRAINT [PK_PuExpInsCostosOP] PRIMARY KEY CLUSTERED 
(
	[IdExpInsCostoOP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuExpInsDestajos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuExpInsDestajos](
	[IdExpInsDestajo] [int] IDENTITY(1,1) NOT NULL,
	[IdExpIns] [int] NOT NULL,
	[IdMoneda] [int] NOT NULL,
	[CostoMaximo] [money] NOT NULL,
	[CostoDestajo] [money] NOT NULL,
 CONSTRAINT [PK_PuExpInsDestajos] PRIMARY KEY CLUSTERED 
(
	[IdExpInsDestajo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuExpInsIntelimat]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuExpInsIntelimat](
	[IdExpInsIntelimat] [int] IDENTITY(1,1) NOT NULL,
	[IdExpIns] [int] NOT NULL,
	[Parametro] [varchar](80) NOT NULL,
	[Valor] [varchar](255) NULL,
 CONSTRAINT [PK_PuImatUDet] PRIMARY KEY CLUSTERED 
(
	[IdExpInsIntelimat] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuExpInsMO]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuExpInsMO](
	[IdExpInsMO] [int] IDENTITY(1,1) NOT NULL,
	[IdExpInsCosto] [int] NOT NULL,
	[SalarioBase] [money] NOT NULL,
	[Fasar] [decimal](18, 8) NOT NULL,
	[SalarioReal] [money] NOT NULL,
	[FactorSalarioIntegrado] [decimal](18, 8) NOT NULL,
	[SalarioIntegrado] [money] NOT NULL,
	[Viaticos] [money] NOT NULL,
	[AlimentacionYHospedaje] [money] NOT NULL,
	[GastosDeSepelio] [money] NOT NULL,
	[OtrasPrestaciones] [money] NOT NULL,
	[TipoFasar] [smallint] NOT NULL,
	[RiesgosdeTrabajo] [decimal](18, 8) NULL,
 CONSTRAINT [PK_PuCostosMO] PRIMARY KEY CLUSTERED 
(
	[IdExpInsMO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuExpinsPar]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuExpinsPar](
	[IdExpinsPar] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuestoPartida] [int] NOT NULL,
	[IdExpIns] [int] NOT NULL,
	[Expins] [decimal](18, 8) NOT NULL,
 CONSTRAINT [PK_PuExpinsPar] PRIMARY KEY CLUSTERED 
(
	[IdExpinsPar] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuExpinsXconcepto]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuExpinsXconcepto](
	[IdExpinsXconcepto] [int] IDENTITY(1,1) NOT NULL,
	[IdCodigoMatriz] [int] NOT NULL,
	[IdCodigoInsumo] [int] NOT NULL,
	[Volumen] [decimal](18, 10) NOT NULL,
 CONSTRAINT [PK_PuExpinsXconcepto] PRIMARY KEY CLUSTERED 
(
	[IdExpinsXconcepto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuFamilias]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuFamilias](
	[idFamilia] [int] IDENTITY(1,1) NOT NULL,
	[Familia] [varchar](20) NOT NULL,
	[Descripcion] [varchar](40) NULL,
 CONSTRAINT [PK_Familias] PRIMARY KEY CLUSTERED 
(
	[idFamilia] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuFamiliasIndices]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuFamiliasIndices](
	[IdFamiliaIndice] [int] IDENTITY(1,1) NOT NULL,
	[Codigo] [varchar](20) NOT NULL,
	[IdIndice] [int] NOT NULL,
	[Descripcion] [varchar](8000) NOT NULL,
 CONSTRAINT [PK_PuFamiliasIndices] PRIMARY KEY CLUSTERED 
(
	[IdFamiliaIndice] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuFichasTecnicas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuFichasTecnicas](
	[IdFichaTecnica] [int] IDENTITY(1,1) NOT NULL,
	[FichaTecnica] [varchar](20) NOT NULL,
	[DescripcionLarga] [varchar](8000) NULL,
	[RutaArchivo] [varchar](250) NULL,
 CONSTRAINT [PK_PuFichasTecnicas] PRIMARY KEY CLUSTERED 
(
	[IdFichaTecnica] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuGeneradores]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuGeneradores](
	[IdGenerador] [int] IDENTITY(1,1) NOT NULL,
	[IdContrato] [int] NOT NULL,
	[FolioGenerador] [int] NOT NULL,
	[FolioContratista] [int] NOT NULL,
	[Hoja] [int] NOT NULL,
	[IdResponsableContratista] [int] NULL,
	[IdResponsableContratante] [int] NULL,
	[Fecha] [datetime] NOT NULL,
	[FechaInicial] [datetime] NOT NULL,
	[FechaFinal] [datetime] NOT NULL,
	[IdNormal] [int] NULL,
	[IdAdicional] [int] NULL,
	[IdExtraordinaria] [int] NULL,
	[AvanceFisico] [bit] NOT NULL,
	[idUsuarioAvanceFisico] [int] NULL,
	[FechaAvanceFisico] [datetime] NULL,
	[EnConciliacion] [bit] NOT NULL,
	[idUsuarioEnConciliacion] [int] NULL,
	[FechaEnConciliacion] [datetime] NULL,
	[Conciliado] [bit] NOT NULL,
	[idUsuarioConciliado] [int] NULL,
	[FechaConciliado] [datetime] NULL,
 CONSTRAINT [PK_PuGeneradores] PRIMARY KEY CLUSTERED 
(
	[IdGenerador] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuGeneradoresDet]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuGeneradoresDet](
	[IdGeneradorDet] [int] IDENTITY(1,1) NOT NULL,
	[IdGenerador] [int] NOT NULL,
	[IdContratoDet] [int] NOT NULL,
	[Cantidad] [decimal](18, 6) NOT NULL,
	[CantidadNormal] [decimal](18, 6) NOT NULL,
	[CantidadExcedente] [decimal](18, 6) NOT NULL,
	[CantidadExtraordinaria] [decimal](18, 6) NOT NULL,
	[PorcentajeFondoGarantia] [smallmoney] NOT NULL,
	[PorcentajeRetencion] [smallmoney] NOT NULL,
	[ImporteFondoGarantia] [money] NOT NULL,
	[ImporteRetencion] [money] NOT NULL,
	[CostoDestajo] [money] NOT NULL,
	[FondoGarantiaPagado] [money] NOT NULL,
	[FondoGarantiaPagadoFecha] [datetime] NULL,
	[FondoGarantiaPagadoObservaciones] [varchar](50) NULL,
	[Observaciones] [varchar](150) NULL,
 CONSTRAINT [PK_PuGeneradoresDet] PRIMARY KEY CLUSTERED 
(
	[IdGeneradorDet] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuGeneradoresDocumentos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuGeneradoresDocumentos](
	[IdGeneradorDocumento] [int] IDENTITY(1,1) NOT NULL,
	[IdGenerador] [int] NOT NULL,
	[Documento] [varchar](80) NOT NULL,
	[Descripcion] [varchar](200) NOT NULL,
	[ObjGeneradorDocumento] [varbinary](max) NULL,
 CONSTRAINT [PK_PuGeneradoresDocumentos] PRIMARY KEY CLUSTERED 
(
	[IdGeneradorDocumento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuGeneradoresEstatusHistorico]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuGeneradoresEstatusHistorico](
	[idGeneradorEstatusH] [int] IDENTITY(1,1) NOT NULL,
	[idGenerador] [int] NOT NULL,
	[idUsuario] [int] NOT NULL,
	[FechaCambio] [smalldatetime] NOT NULL,
	[EstatusAnt] [int] NOT NULL,
	[EstatusNvo] [int] NOT NULL,
	[Observaciones] [varchar](100) NULL,
 CONSTRAINT [PK_PuGeneradoresEstatusHistorico] PRIMARY KEY CLUSTERED 
(
	[idGeneradorEstatusH] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuGeneradoresIC]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuGeneradoresIC](
	[IdGenerador] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NULL,
	[Renglon] [int] NULL,
	[NombreGenerador] [varchar](80) NULL,
	[ObjGenerador] [varbinary](max) NULL,
 CONSTRAINT [PK_PuGeneradoresIC] PRIMARY KEY CLUSTERED 
(
	[IdGenerador] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuImagenes]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuImagenes](
	[IdImagen] [int] IDENTITY(1,1) NOT NULL,
	[Partida] [varchar](40) NULL,
	[Descripcion] [varchar](40) NOT NULL,
	[IdFamilia] [int] NULL,
	[TipoArchivo] [varchar](8) NULL,
	[CheckSum] [varchar](40) NOT NULL,
	[Imagen] [varbinary](max) NULL,
 CONSTRAINT [PK_PuImagenes] PRIMARY KEY CLUSTERED 
(
	[IdImagen] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuIndices]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuIndices](
	[IdIndice] [int] IDENTITY(1,1) NOT NULL,
	[Codigo] [varchar](20) NOT NULL,
	[Descripcion] [varchar](50) NOT NULL,
	[FechaActualizacion] [date] NULL,
	[Predeterminado] [bit] NOT NULL,
	[urlDescarga] [varchar](500) NULL,
 CONSTRAINT [PK_PuIndices] PRIMARY KEY CLUSTERED 
(
	[IdIndice] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuIndicesDet]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuIndicesDet](
	[IdIndiceDet] [int] IDENTITY(1,1) NOT NULL,
	[IdFamiliaIndice] [int] NOT NULL,
	[Año] [int] NOT NULL,
	[Mes] [int] NOT NULL,
	[Indice] [decimal](18, 8) NOT NULL,
 CONSTRAINT [PK_PuIndicesDet] PRIMARY KEY CLUSTERED 
(
	[IdIndiceDet] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuIntelimat]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuIntelimat](
	[IdInteliMat] [int] IDENTITY(1,1) NOT NULL,
	[Partida] [varchar](40) NULL,
	[InteliMat] [varchar](80) NOT NULL,
	[Cadena] [varchar](20) NULL,
	[Autor] [varchar](20) NULL,
	[Fecha] [smalldatetime] NOT NULL,
	[EsNeodata] [bit] NULL,
	[EsLibre] [bit] NOT NULL,
	[ObjInteliMat] [varbinary](max) NULL,
 CONSTRAINT [PK_PuIntelimat] PRIMARY KEY CLUSTERED 
(
	[IdInteliMat] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuInteliPres]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuInteliPres](
	[IdInteliPre] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[Renglon] [int] NOT NULL,
	[NombreInteliPre] [varchar](80) NOT NULL,
	[ObjInteliPre] [varbinary](max) NULL,
 CONSTRAINT [PK_PuInteliPres] PRIMARY KEY CLUSTERED 
(
	[IdInteliPre] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuLigasRuta]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuLigasRuta](
	[IdLigaRuta] [int] IDENTITY(1,1) NOT NULL,
	[IdConceptoOrigen] [int] NOT NULL,
	[IdConceptoDestino] [int] NOT NULL,
	[TipoRelacion] [tinyint] NOT NULL,
	[Lag] [smallint] NOT NULL,
 CONSTRAINT [PK_PuPrecedencias] PRIMARY KEY CLUSTERED 
(
	[IdLigaRuta] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuMatrices]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuMatrices](
	[IdMatriz] [int] IDENTITY(1,1) NOT NULL,
	[IdCodigoMatriz] [int] NOT NULL,
	[Renglon] [smallint] NOT NULL,
	[IdCodigoInsumo] [int] NOT NULL,
	[Dividir] [bit] NOT NULL,
	[Volumen] [decimal](18, 6) NOT NULL,
	[Expresion] [varchar](50) NULL,
 CONSTRAINT [PK_PuMatrices] PRIMARY KEY CLUSTERED 
(
	[IdMatriz] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuMonedas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuMonedas](
	[IdMoneda] [int] IDENTITY(1,1) NOT NULL,
	[Moneda] [int] NOT NULL,
	[Descripcion] [varchar](20) NOT NULL,
	[RemateMoneda] [varchar](20) NOT NULL,
	[ParidadContratos] [decimal](18, 8) NOT NULL,
	[EsCalculada] [bit] NOT NULL,
	[DescripcionIngles] [varchar](20) NULL,
	[RemateIngles] [varchar](20) NULL,
 CONSTRAINT [PK_PuMonedas] PRIMARY KEY CLUSTERED 
(
	[IdMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuMonedasCalculadas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuMonedasCalculadas](
	[IdMonedaCalculada] [int] IDENTITY(1,1) NOT NULL,
	[IdMoneda] [int] NOT NULL,
	[IdMonedaIntegrante] [int] NOT NULL,
	[Paridad] [decimal](18, 8) NOT NULL,
 CONSTRAINT [PK_PuMonedasCalculadas] PRIMARY KEY CLUSTERED 
(
	[IdMonedaCalculada] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuMovimientos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuMovimientos](
	[IdMovimiento] [int] IDENTITY(1,1) NOT NULL,
	[Descripcion] [varchar](40) NOT NULL,
	[Suma] [bit] NOT NULL,
 CONSTRAINT [PK_PuMovimientos] PRIMARY KEY CLUSTERED 
(
	[IdMovimiento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuOficiosParametros]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuOficiosParametros](
	[IdOficioParametro] [int] IDENTITY(1,1) NOT NULL,
	[Parametro] [varchar](30) NOT NULL,
	[Descripcion] [varchar](50) NOT NULL,
 CONSTRAINT [PK_PuOficiosParametros] PRIMARY KEY CLUSTERED 
(
	[IdOficioParametro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuOrdenesCambio]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuOrdenesCambio](
	[IdOrdenCambio] [int] IDENTITY(1,1) NOT NULL,
	[IdContrato] [int] NOT NULL,
	[NumeroOrdenCambio] [int] NOT NULL,
	[Fecha] [smalldatetime] NOT NULL,
	[RazonCambio] [varchar](300) NOT NULL,
	[IdOrdenCambioTipo] [int] NOT NULL,
 CONSTRAINT [PK_PuOrdenesCambio] PRIMARY KEY CLUSTERED 
(
	[IdOrdenCambio] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuOrdenesCambioDet]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuOrdenesCambioDet](
	[IdOrdenCambioDet] [int] IDENTITY(1,1) NOT NULL,
	[IdOrdenCambio] [int] NOT NULL,
	[IdContratoDet] [int] NOT NULL,
	[Cantidad] [decimal](18, 6) NOT NULL,
 CONSTRAINT [PK_PuOrdenesCambioDet] PRIMARY KEY CLUSTERED 
(
	[IdOrdenCambioDet] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuOrdenesCambioTipo]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuOrdenesCambioTipo](
	[IdOrdenCambioTipo] [int] IDENTITY(1,1) NOT NULL,
	[OrdenCambio] [varchar](20) NOT NULL,
	[Descripcion] [varchar](40) NOT NULL,
 CONSTRAINT [PK_PuOrdenesCambioTipo] PRIMARY KEY CLUSTERED 
(
	[IdOrdenCambioTipo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuParametros]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuParametros](
	[IdParametro] [int] IDENTITY(1,1) NOT NULL,
	[Parametro] [varchar](30) NOT NULL,
	[Valor] [varchar](250) NULL,
	[Explicacion] [varchar](250) NULL,
	[Especifico] [bit] NOT NULL,
 CONSTRAINT [PK_PuParametros] PRIMARY KEY CLUSTERED 
(
	[IdParametro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPorcentajesFinanciamiento]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPorcentajesFinanciamiento](
	[IdPorcentajeFinanciamiento] [int] IDENTITY(1,1) NOT NULL,
	[IdPrograma] [int] NOT NULL,
	[NoPeriodo] [smallint] NOT NULL,
 CONSTRAINT [PK_PuPorcentajesFinanciamiento] PRIMARY KEY CLUSTERED 
(
	[IdPorcentajeFinanciamiento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPorcentajesFM]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPorcentajesFM](
	[IdPorcentajeFM] [int] IDENTITY(1,1) NOT NULL,
	[IdPorcentajeFinanciamiento] [int] NOT NULL,
	[IdMoneda] [int] NOT NULL,
	[CostoEQ] [money] NOT NULL,
	[Costo] [money] NOT NULL,
	[Precio] [money] NOT NULL,
	[CostoMA] [money] NOT NULL,
	[CostoMO] [money] NOT NULL,
	[CostoOtros] [money] NOT NULL,
 CONSTRAINT [PK_PuPorcentajesFM] PRIMARY KEY CLUSTERED 
(
	[IdPorcentajeFM] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestos](
	[IdPresupuesto] [int] IDENTITY(1,1) NOT NULL,
	[Presupuesto] [varchar](20) NOT NULL,
	[Nombre] [varchar](500) NOT NULL,
	[IdCliente] [int] NULL,
	[IdEmpresa] [int] NULL,
	[Direccion] [varchar](80) NULL,
	[Colonia] [varchar](30) NULL,
	[IdCiudad] [int] NULL,
	[CodPost] [varchar](6) NULL,
	[Telefono] [varchar](30) NULL,
	[Maiil] [varchar](50) NULL,
	[Observaciones] [varchar](8000) NULL,
	[IdResponsable] [int] NULL,
	[Bloqueado] [bit] NOT NULL,
	[Autorizado] [bit] NOT NULL,
	[Cerrado] [bit] NOT NULL,
	[PorcentajeIVA] [smallmoney] NOT NULL,
	[FechaUltimoUso] [datetime] NULL,
	[RequiereCalcular] [bit] NOT NULL,
	[Cargo] [varchar](100) NULL,
	[RequiereTotalizar] [bit] NOT NULL,
	[RequiereCalcularWBS] [bit] NOT NULL,
	[IdVendedor] [int] NULL,
	[IdClienteContacto] [int] NULL,
	[EsMaestro] [bit] NOT NULL,
	[IdTipoLicitacion] [int] NULL,
	[IdUsuarioCreo] [int] NULL,
	[IdUsuarioBloqueo] [int] NULL,
 CONSTRAINT [PK_Proyectos] PRIMARY KEY CLUSTERED 
(
	[IdPresupuesto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosAdjuntos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosAdjuntos](
	[IdPresupuestoAdjunto] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[IdOficio] [int] NULL,
	[IdCostoHorario] [int] NULL,
	[VersionCostoHorario] [varchar](20) NULL,
	[VersionOficio] [varchar](20) NULL,
	[ObjCostoHorario] [varbinary](max) NULL,
	[ObjOficios] [varbinary](max) NULL,
 CONSTRAINT [PK_PuPresupuestosAdjuntos] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestoAdjunto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosAdjuntosMonedas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosAdjuntosMonedas](
	[IdPresupuestoAdjuntoMoneda] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[IdFasar] [int] NULL,
	[IdSobreCosto] [int] NULL,
	[IdPieIndirecto] [int] NULL,
	[IdMoneda] [int] NOT NULL,
	[VersionFasar] [varchar](20) NULL,
	[VersionSobreCosto] [varchar](20) NULL,
	[VersionIndirecto] [varchar](20) NULL,
	[ObjFasar] [varbinary](max) NULL,
	[ObjSobreCosto] [varbinary](max) NULL,
	[ObjPieIndirecto] [varbinary](max) NULL,
 CONSTRAINT [PK_PuAdjuntosPresupuesto] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestoAdjuntoMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosConceptos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosConceptos](
	[IdPresupuestoConcepto] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[IdPresupuestoPartida] [int] NOT NULL,
	[IdExpIns] [int] NOT NULL,
	[IdEstimacionTipo] [int] NOT NULL,
	[IdAgrupador] [int] NULL,
	[Control] [int] NOT NULL,
	[Renglon] [int] NOT NULL,
	[Cantidad] [decimal](18, 6) NOT NULL,
	[CantidadTotal] [decimal](18, 6) NOT NULL,
	[Marca] [bit] NOT NULL,
	[CodigoAuxiliar] [varchar](40) NULL,
	[DescripcionAuxiliar] [varchar](8000) NULL,
	[IndirectoEspecial] [bit] NOT NULL,
	[PorcentajeIndirectoEspecial] [decimal](18, 8) NOT NULL,
	[RutaGenerador] [varchar](250) NULL,
	[AEstimar] [bit] NOT NULL,
	[YaEstimado] [bit] NOT NULL,
	[Programado] [bit] NOT NULL,
	[IdCentro] [int] NULL,
	[IdContratista] [int] NULL,
	[Bloqueado] [bit] NOT NULL,
 CONSTRAINT [PK_PuPresupuestos] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestoConcepto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosConceptosPrecios]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosConceptosPrecios](
	[IdPresupuestoConceptoPrecio] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuestoConcepto] [int] NOT NULL,
	[IdMoneda] [int] NOT NULL,
	[Precio] [money] NOT NULL,
 CONSTRAINT [PK_PuPresupuestosConceptosPrecios] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestoConceptoPrecio] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosConsecutivos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosConsecutivos](
	[idConsecutivo] [int] IDENTITY(1,1) NOT NULL,
	[idPresupuesto] [int] NOT NULL,
	[FolioControlConcepto] [int] NOT NULL,
	[FolioEstructuraPartidas] [int] NOT NULL,
	[FolioPrograma] [int] NOT NULL,
	[FolioBitacora] [int] NOT NULL,
 CONSTRAINT [PK_PuPresupuestosConsecutivos] PRIMARY KEY CLUSTERED 
(
	[idConsecutivo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosMonedas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosMonedas](
	[IdPresupuestoMoneda] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[IdMonedaCalculada] [int] NOT NULL,
	[IdMoneda] [int] NOT NULL,
	[Paridad] [decimal](18, 8) NOT NULL,
	[Fecha] [smalldatetime] NULL,
 CONSTRAINT [PK_PuPresupuestosMonedas] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestoMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosOficios]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosOficios](
	[IdPresupuestoOficio] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[IdOficioParametro] [int] NOT NULL,
	[Valor] [varchar](250) NOT NULL,
 CONSTRAINT [PK_PuPresupuestosOficios] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestoOficio] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosParametros]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosParametros](
	[IdPresupuestoParametro] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[Parametro] [varchar](30) NOT NULL,
	[Valor] [varchar](250) NULL,
	[Explicacion] [varchar](250) NULL,
 CONSTRAINT [PK_PuParametrosPresupuestos] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestoParametro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosPartidas]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosPartidas](
	[IdPresupuestoPartida] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[IdPartidaPadre] [int] NULL,
	[Partida] [varchar](20) NOT NULL,
	[IdImagen] [int] NULL,
	[Renglon] [int] NOT NULL,
	[PartidaWBS] [varchar](120) NULL,
	[Cantidad] [decimal](18, 6) NOT NULL,
	[MetrosCuadrados] [decimal](18, 6) NOT NULL,
	[DescripcionPartida] [varchar](40) NOT NULL,
	[DescripcionPartidaLarga] [varchar](8000) NOT NULL,
	[IdCentro] [int] NULL,
	[PartidaAuxiliar] [varchar](20) NULL,
	[ClavePresupuestal] [varchar](20) NULL,
 CONSTRAINT [PK_PuPresupuestosPartidas] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestoPartida] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosPartidasCostos]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosPartidasCostos](
	[IdPresupuestoPartidaCosto] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuestoPartida] [int] NOT NULL,
	[IdMoneda] [int] NOT NULL,
	[Costo] [money] NOT NULL,
	[Precio] [money] NOT NULL,
	[Fecha] [datetime] NOT NULL,
	[CostoTotal] [money] NOT NULL,
	[PrecioTotal] [money] NOT NULL,
	[Costo1Nivel] [money] NOT NULL,
	[Precio1Nivel] [money] NOT NULL,
 CONSTRAINT [PK_PuPresupuestosPartidasCostos] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestoPartidaCosto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosPrecios]    Script Date: 09/10/2018 11:01:03 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosPrecios](
	[IdPresupuestoPrecio] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[IdMoneda] [int] NOT NULL,
	[PrecioTotal] [money] NOT NULL,
	[CostoTotal] [money] NOT NULL,
	[CostoMO] [money] NOT NULL,
	[CostoMA] [money] NOT NULL,
	[CostoEQ] [money] NOT NULL,
	[CostoOtros] [money] NOT NULL,
 CONSTRAINT [PK_PuPresupuestosPrecios] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestoPrecio] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosPrestamos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosPrestamos](
	[IdPresupuestoPrestamo] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[IdContratista] [int] NOT NULL,
 CONSTRAINT [PK_PuPresupuestosPrestamos] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestoPrestamo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosPrestamosDet]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosPrestamosDet](
	[IdPresupuestoPrestamoDet] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuestoPrestamo] [int] NOT NULL,
	[Fecha] [datetime] NOT NULL,
	[IdMovimiento] [int] NOT NULL,
	[IdEstimacion] [int] NULL,
	[Monto] [money] NOT NULL,
	[Observaciones] [varchar](100) NULL,
 CONSTRAINT [PK_PuPresupuestosPrestamosDet] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestoPrestamoDet] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosVersion]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosVersion](
	[IdPresupuestoVersion] [int] IDENTITY(1,1) NOT NULL,
	[Consecutivo] [int] NOT NULL,
	[Presupuesto] [varchar](20) NOT NULL,
	[Nombre] [varchar](500) NOT NULL,
	[Fecha] [datetime] NOT NULL,
	[Observaciones] [varchar](8000) NULL,
	[IdUsuario] [int] NOT NULL,
	[ObjPresupuesto] [varbinary](max) NULL,
 CONSTRAINT [PK_PuPresupuestosVersion] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestoVersion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuPresupuestosVersionCostos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuPresupuestosVersionCostos](
	[IdPresupuestosVersionCosto] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuestoVersion] [int] NOT NULL,
	[IdMoneda] [int] NOT NULL,
	[Costo] [money] NOT NULL,
	[Importe] [money] NOT NULL,
 CONSTRAINT [PK_PuPresupuestosVersionCostos] PRIMARY KEY CLUSTERED 
(
	[IdPresupuestosVersionCosto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuProcedimientos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuProcedimientos](
	[IdProcedimiento] [int] IDENTITY(1,1) NOT NULL,
	[Procedimiento] [varchar](20) NOT NULL,
	[DescripcionLarga] [varchar](8000) NULL,
 CONSTRAINT [PK_PuProcedimientos] PRIMARY KEY CLUSTERED 
(
	[IdProcedimiento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuProgramaConceptos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuProgramaConceptos](
	[IdProgramaConcepto] [int] IDENTITY(1,1) NOT NULL,
	[IdPrograma] [int] NOT NULL,
	[IdPresupuestoConcepto] [int] NOT NULL,
	[IdResponsable] [int] NULL,
	[FechaInicio] [date] NOT NULL,
	[FechaFinal] [date] NOT NULL,
	[Duracion] [int] NOT NULL,
	[Rendimiento] [decimal](18, 6) NOT NULL,
	[ActividadCritica] [bit] NOT NULL,
	[Holgura] [int] NOT NULL,
	[FechaInicioTardia] [date] NULL,
	[FechaFinalTardia] [date] NULL,
	[Avance] [smallmoney] NOT NULL,
	[FechaInicioReal] [date] NULL,
	[FechaFinalReal] [date] NULL,
	[Total] [decimal](18, 6) NOT NULL,
 CONSTRAINT [PK_PuProgramaConceptos_1] PRIMARY KEY CLUSTERED 
(
	[IdProgramaConcepto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuProgramaConceptosPeriodos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuProgramaConceptosPeriodos](
	[IdProgramaConceptoPeriodo] [int] IDENTITY(1,1) NOT NULL,
	[IdProgramaConcepto] [int] NOT NULL,
	[NoPeriodo] [smallint] NOT NULL,
	[Porcentaje] [decimal](18, 6) NOT NULL,
 CONSTRAINT [PK_PuProgramaConceptos] PRIMARY KEY CLUSTERED 
(
	[IdProgramaConceptoPeriodo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuProgramaPartidas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuProgramaPartidas](
	[IdProgramaPartida] [int] IDENTITY(1,1) NOT NULL,
	[IdPrograma] [int] NOT NULL,
	[IdPresupuestoPartida] [int] NOT NULL,
	[IdResponsable] [int] NULL,
	[ActividadCritica] [bit] NOT NULL,
	[FechaInicio] [date] NOT NULL,
	[FechaFinal] [date] NOT NULL,
	[Duracion] [int] NOT NULL,
	[Total] [decimal](18, 6) NOT NULL,
 CONSTRAINT [PK_PuProgramaPartidas_1] PRIMARY KEY CLUSTERED 
(
	[IdProgramaPartida] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuProgramas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuProgramas](
	[IdPrograma] [int] IDENTITY(1,1) NOT NULL,
	[IdPresupuesto] [int] NOT NULL,
	[IdCalendario] [int] NOT NULL,
	[NoPrograma] [int] NOT NULL,
	[Descripcion] [varchar](40) NOT NULL,
	[FechaInicio] [date] NOT NULL,
	[FechaFinal] [date] NOT NULL,
	[NoPeriodos] [smallint] NOT NULL,
	[Periodicidad] [smallint] NOT NULL,
	[CapturarPorcentaje] [bit] NOT NULL,
	[Vigente] [bit] NOT NULL,
	[DiasCalendario] [int] NOT NULL,
	[DiasHabiles] [int] NOT NULL,
	[IdUsuario] [int] NULL,
	[FechaUso] [datetime] NULL,
 CONSTRAINT [PK_PuProgramas] PRIMARY KEY CLUSTERED 
(
	[IdPrograma] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuProgramasTipos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuProgramasTipos](
	[IdProgramaTipo] [int] IDENTITY(1,1) NOT NULL,
	[IdPrograma] [int] NOT NULL,
	[IdTipo] [smallint] NOT NULL,
	[Participa] [bit] NOT NULL,
	[Horas] [money] NOT NULL,
 CONSTRAINT [PK_PuProgramasTipos] PRIMARY KEY CLUSTERED 
(
	[IdProgramaTipo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuProgramaSum]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuProgramaSum](
	[IdProgramaSum] [int] IDENTITY(1,1) NOT NULL,
	[IdPrograma] [int] NOT NULL,
	[IdExpIns] [int] NOT NULL,
	[NoPeriodo] [smallint] NOT NULL,
	[Cantidad] [decimal](18, 8) NOT NULL,
 CONSTRAINT [PK_PuProgramaSumXCon] PRIMARY KEY CLUSTERED 
(
	[IdProgramaSum] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuProgramaSumXPar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuProgramaSumXPar](
	[IdProgramaSumXPar] [int] IDENTITY(1,1) NOT NULL,
	[IdProgramaPartida] [int] NOT NULL,
	[IdExpIns] [int] NOT NULL,
	[NoPeriodo] [smallint] NOT NULL,
	[Cantidad] [decimal](18, 8) NOT NULL,
 CONSTRAINT [PK_PuProgramaSumXPar] PRIMARY KEY CLUSTERED 
(
	[IdProgramaSumXPar] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuProveedores]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuProveedores](
	[IdProveedor] [int] IDENTITY(1,1) NOT NULL,
	[Proveedor] [varchar](20) NOT NULL,
	[idCiudad] [int] NULL,
	[RazonSocial] [varchar](122) NOT NULL,
	[Rfc] [varchar](15) NULL,
	[Direccion] [varchar](80) NULL,
	[Colonia] [varchar](30) NULL,
	[CodigoPostal] [varchar](6) NULL,
	[Telefono] [varchar](40) NULL,
	[Fax] [varchar](40) NULL,
	[Mail] [varchar](100) NULL,
	[Contacto] [varchar](80) NULL,
	[Observaciones] [varchar](8000) NULL,
	[Celular] [varchar](40) NULL,
	[PaginaWeb] [varchar](80) NULL,
	[ProveedorDefault] [bit] NOT NULL,
 CONSTRAINT [PK_PuProveedores] PRIMARY KEY CLUSTERED 
(
	[IdProveedor] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuReferenciaAcad]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuReferenciaAcad](
	[IdReferenciaAcad] [int] IDENTITY(1,1) NOT NULL,
	[Referencia] [int] NOT NULL,
	[Descripcion] [varchar](40) NOT NULL,
 CONSTRAINT [PK_PuReferenciaAcad] PRIMARY KEY CLUSTERED 
(
	[IdReferenciaAcad] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuRepCarpetas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuRepCarpetas](
	[IdRepCarpeta] [int] IDENTITY(1,1) NOT NULL,
	[Carpeta] [varchar](255) NOT NULL,
	[Predeterminada] [bit] NOT NULL,
 CONSTRAINT [PK_PuRepCarpetas] PRIMARY KEY CLUSTERED 
(
	[IdRepCarpeta] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuRepHojas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuRepHojas](
	[IdRepHoja] [int] IDENTITY(1,1) NOT NULL,
	[IdRepLibro] [int] NOT NULL,
	[NombreHoja] [varchar](80) NOT NULL,
 CONSTRAINT [PK_PuReportesHojasXls] PRIMARY KEY CLUSTERED 
(
	[IdRepHoja] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuRepLibros]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuRepLibros](
	[IdRepLibro] [int] IDENTITY(1,1) NOT NULL,
	[IdRepCarpeta] [int] NOT NULL,
	[NombreLibro] [varchar](255) NOT NULL,
 CONSTRAINT [PK_PuReportesXls] PRIMARY KEY CLUSTERED 
(
	[IdRepLibro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuRepOpciones]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuRepOpciones](
	[IdRepOpcion] [int] IDENTITY(1,1) NOT NULL,
	[IdRepHoja] [int] NOT NULL,
	[IdUsuario] [int] NOT NULL,
	[IdParametro] [int] NOT NULL,
	[ValorString] [varchar](255) NULL,
	[ValorNumero] [decimal](18, 6) NULL,
	[ValorFecha] [datetime] NULL,
 CONSTRAINT [PK_PuRepOpciones] PRIMARY KEY CLUSTERED 
(
	[IdRepOpcion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuRepParametros]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuRepParametros](
	[IdParametro] [int] IDENTITY(1,1) NOT NULL,
	[Parametro] [varchar](80) NOT NULL,
 CONSTRAINT [PK_PuRepParametros] PRIMARY KEY CLUSTERED 
(
	[IdParametro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuResponsables]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuResponsables](
	[IdResponsable] [int] IDENTITY(1,1) NOT NULL,
	[Responsable] [varchar](20) NOT NULL,
	[Nombre] [varchar](80) NOT NULL,
	[Cargo] [varchar](100) NULL,
	[Telefono] [varchar](30) NULL,
	[Mail] [varchar](50) NULL,
 CONSTRAINT [PK_Responsables] PRIMARY KEY CLUSTERED 
(
	[IdResponsable] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuSesionCAOP]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuSesionCAOP](
	[IdSesionCAOP] [int] IDENTITY(1,1) NOT NULL,
	[Codigo] [varchar](10) NOT NULL,
	[Descripcion] [varchar](50) NOT NULL,
 CONSTRAINT [PK_PuSesionCAOP] PRIMARY KEY CLUSTERED 
(
	[IdSesionCAOP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuStatusControlPadron]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuStatusControlPadron](
	[IdStatusControlPadron] [int] IDENTITY(1,1) NOT NULL,
	[Codigo] [varchar](10) NOT NULL,
	[Descripcion] [varchar](50) NOT NULL,
 CONSTRAINT [PK_PuStatusControlPadron] PRIMARY KEY CLUSTERED 
(
	[IdStatusControlPadron] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuTipoInsumos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuTipoInsumos](
	[IdTipo] [smallint] NOT NULL,
	[Descripcion] [varchar](40) NOT NULL
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuTipoProveedor]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuTipoProveedor](
	[IdTipoProveedor] [int] IDENTITY(1,1) NOT NULL,
	[Codigo] [varchar](10) NOT NULL,
	[Descripcion] [varchar](50) NOT NULL,
 CONSTRAINT [PK_PuTipoProveedor] PRIMARY KEY CLUSTERED 
(
	[IdTipoProveedor] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuTiposDocumentos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuTiposDocumentos](
	[IdTipoDocumento] [int] NOT NULL,
	[TipoDocumento] [varchar](40) NOT NULL,
	[Word] [bit] NOT NULL,
	[AceptaImagen] [bit] NOT NULL,
 CONSTRAINT [PK_PuTiposDocumentos] PRIMARY KEY CLUSTERED 
(
	[IdTipoDocumento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuTiposLicitacion]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuTiposLicitacion](
	[IdTipoLicitacion] [int] IDENTITY(1,1) NOT NULL,
	[Tipo] [varchar](20) NOT NULL,
	[DescripcionTipo] [varchar](50) NOT NULL,
 CONSTRAINT [PK_PuTiposLicitacion] PRIMARY KEY CLUSTERED 
(
	[IdTipoLicitacion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuUnidades]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuUnidades](
	[IdUnidad] [int] IDENTITY(1,1) NOT NULL,
	[Unidad] [varchar](20) NOT NULL,
	[Descripcion] [varchar](40) NOT NULL,
 CONSTRAINT [PK_PuUnidades] PRIMARY KEY CLUSTERED 
(
	[IdUnidad] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuUnidadesAcad]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuUnidadesAcad](
	[IdUnidadAcad] [int] IDENTITY(1,1) NOT NULL,
	[Unidad] [varchar](20) NOT NULL,
	[Descripcion] [varchar](40) NOT NULL,
	[IdReferenciaAcad] [int] NOT NULL,
 CONSTRAINT [PK_PuUnidadesAcad] PRIMARY KEY CLUSTERED 
(
	[IdUnidadAcad] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PuVendedores]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PuVendedores](
	[IdVendedor] [int] IDENTITY(1,1) NOT NULL,
	[Vendedor] [varchar](20) NOT NULL,
	[Nombre] [varchar](80) NOT NULL,
	[Cargo] [varchar](100) NULL,
	[Telefono] [varchar](30) NULL,
	[Mail] [varchar](50) NULL,
 CONSTRAINT [PK_PuVendedores] PRIMARY KEY CLUSTERED 
(
	[IdVendedor] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[SegGrupoPermisos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SegGrupoPermisos](
	[IdGrupoPermiso] [int] NOT NULL,
	[GrupoPermiso] [varchar](50) NOT NULL,
	[IdSistema] [int] NOT NULL,
 CONSTRAINT [PK_SegGrupoPermisos] PRIMARY KEY CLUSTERED 
(
	[IdGrupoPermiso] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[SegPerfil]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SegPerfil](
	[IdPerfil] [int] IDENTITY(1,1) NOT NULL,
	[Descripcion] [nvarchar](255) NOT NULL,
	[Masc_Permisos] [ntext] NULL,
	[IdSistema] [int] NOT NULL,
 CONSTRAINT [PK_SegPerfil] PRIMARY KEY CLUSTERED 
(
	[IdPerfil] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[SegPermisos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SegPermisos](
	[Permiso] [int] NOT NULL,
	[GrupoDescripcion] [varchar](120) NULL,
	[SubGrupoDescripcion] [varchar](120) NULL,
	[Descripcion] [varchar](120) NOT NULL,
	[Nombre_Permiso] [varchar](50) NOT NULL,
	[IdGrupoPermiso] [int] NOT NULL,
	[IdSistema] [int] NOT NULL,
	[PermisoDinamico] [bit] NOT NULL,
 CONSTRAINT [PK_SegPermisos] PRIMARY KEY CLUSTERED 
(
	[Permiso] ASC,
	[IdSistema] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[SegSistemas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SegSistemas](
	[IdSistema] [int] NOT NULL,
	[Nombre] [nvarchar](40) NOT NULL,
	[Texto] [nvarchar](80) NULL,
 CONSTRAINT [PK_SegSistemas] PRIMARY KEY CLUSTERED 
(
	[IdSistema] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[SegUsuarios]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SegUsuarios](
	[IdUsuario] [int] IDENTITY(1,1) NOT NULL,
	[Nombre] [varchar](50) NOT NULL,
	[Usuario] [varchar](20) NOT NULL,
	[Password] [varchar](50) NOT NULL,
	[FechaCambioPwd] [datetime] NULL,
	[Caduca] [bit] NOT NULL,
	[Intentos] [int] NOT NULL,
	[Bloqueado] [varchar](50) NOT NULL,
	[Email] [varchar](50) NULL,
 CONSTRAINT [PK_SegUsuarios] PRIMARY KEY CLUSTERED 
(
	[IdUsuario] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[SegUsuariosSistemas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SegUsuariosSistemas](
	[IdSistema] [int] NOT NULL,
	[IdUsuario] [int] NOT NULL,
	[IdPerfil] [int] NULL,
	[Masc_Permisos] [ntext] NULL,
 CONSTRAINT [PK_SegUsuariosSistemas] PRIMARY KEY CLUSTERED 
(
	[IdSistema] ASC,
	[IdUsuario] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[SegUsuariosXProyecto]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SegUsuariosXProyecto](
	[idUsuario] [int] NOT NULL,
	[idPresupuesto] [int] NOT NULL,
	[idSistema] [int] NOT NULL,
	[Escritura] [bit] NOT NULL,
 CONSTRAINT [PK_SegUsuariosXProyecto] PRIMARY KEY CLUSTERED 
(
	[idUsuario] ASC,
	[idPresupuesto] ASC,
	[idSistema] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Version]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Version](
	[idVersion] [int] IDENTITY(1,1) NOT NULL,
	[LlaveUnica] [int] NOT NULL,
	[Version] [nvarchar](10) NOT NULL,
	[Hora] [nvarchar](4) NOT NULL,
	[versionMayor] [int] NOT NULL,
	[AsignaDatosDefault] [bit] NULL,
	[EstructuraOK] [bit] NULL,
	[VersionNeodata] [int] NULL,
	[NombreNeodata] [varchar](40) NULL,
	[idSistema] [int] NULL,
 CONSTRAINT [PK_Version] PRIMARY KEY CLUSTERED 
(
	[idVersion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[PuCalendarios] ON 

INSERT [dbo].[PuCalendarios] ([IdCalendario], [Calendario], [Descripcion], [Lunes], [Martes], [Miercoles], [Jueves], [Viernes], [Sabado], [Domingo], [Predeterminado]) VALUES (1, N'PREDETERMINADO', N'CALENDARIO PREDETERMINADO', 1, 1, 1, 1, 1, 1, 1, 1)
INSERT [dbo].[PuCalendarios] ([IdCalendario], [Calendario], [Descripcion], [Lunes], [Martes], [Miercoles], [Jueves], [Viernes], [Sabado], [Domingo], [Predeterminado]) VALUES (2, N'6DIAS', N'CALENDARIO DE SEIS DIAS  A LA SEMANA', 1, 1, 1, 1, 1, 1, 0, 0)
INSERT [dbo].[PuCalendarios] ([IdCalendario], [Calendario], [Descripcion], [Lunes], [Martes], [Miercoles], [Jueves], [Viernes], [Sabado], [Domingo], [Predeterminado]) VALUES (3, N'5DIAS', N'CALENDARIO DE CINCO DIAS A LA SEMANA', 1, 1, 1, 1, 1, 0, 0, 0)
SET IDENTITY_INSERT [dbo].[PuCalendarios] OFF
SET IDENTITY_INSERT [dbo].[PuCuotasVigentesImss] ON 

INSERT [dbo].[PuCuotasVigentesImss] ([IdCuotasVigentesImss], [Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES (1, N'1998', 13.9000, 6.0000, 2.0000, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 15.0000)
INSERT [dbo].[PuCuotasVigentesImss] ([IdCuotasVigentesImss], [Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES (2, N'1999', 14.5500, 5.5100, 1.8400, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 16.0000)
INSERT [dbo].[PuCuotasVigentesImss] ([IdCuotasVigentesImss], [Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES (3, N'2000', 15.2000, 5.0200, 1.6800, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 17.0000)
INSERT [dbo].[PuCuotasVigentesImss] ([IdCuotasVigentesImss], [Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES (4, N'2001', 15.8500, 4.5300, 1.5200, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 18.0000)
INSERT [dbo].[PuCuotasVigentesImss] ([IdCuotasVigentesImss], [Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES (5, N'2002', 16.5000, 4.0400, 1.3600, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 19.0000)
INSERT [dbo].[PuCuotasVigentesImss] ([IdCuotasVigentesImss], [Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES (6, N'2003', 17.1500, 3.5500, 1.2000, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 20.0000)
INSERT [dbo].[PuCuotasVigentesImss] ([IdCuotasVigentesImss], [Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES (7, N'2004', 17.8000, 3.0600, 1.0400, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 21.0000)
INSERT [dbo].[PuCuotasVigentesImss] ([IdCuotasVigentesImss], [Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES (8, N'2005', 18.4500, 2.5700, 0.8800, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 22.0000)
INSERT [dbo].[PuCuotasVigentesImss] ([IdCuotasVigentesImss], [Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES (9, N'2006', 19.1000, 2.0800, 0.7200, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 23.0000)
INSERT [dbo].[PuCuotasVigentesImss] ([IdCuotasVigentesImss], [Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES (10, N'2007', 19.7500, 1.5900, 0.5600, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 24.0000)
INSERT [dbo].[PuCuotasVigentesImss] ([IdCuotasVigentesImss], [Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES (11, N'2008', 20.4000, 1.1000, 0.4000, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 25.0000)
INSERT [dbo].[PuCuotasVigentesImss] ([IdCuotasVigentesImss], [Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES (12, N'2009', 20.4000, 1.1000, 0.4000, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 25.0000)
INSERT [dbo].[PuCuotasVigentesImss] ([IdCuotasVigentesImss], [Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES (13, N'2010', 20.4000, 1.1000, 0.4000, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 25.0000)
SET IDENTITY_INSERT [dbo].[PuCuotasVigentesImss] OFF
SET IDENTITY_INSERT [dbo].[PuDocumentos] ON 

INSERT [dbo].[PuDocumentos] ([IdDocumento], [Documento], [Neodata], [IdTipoDocumento], [Version], [Extension], [ObjDocumento], [ObjImagen]) VALUES (1, N'EstandarCostoHorario', 1, 3, N'2011-09-19-12', N'.xls', 0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000030000002E0100000000000000100000FEFFFFFF00000000FEFFFFFF000000002B0100002C0100002D010000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF09081000000605006632CD07C980010006060000E1000200B004C10002000000E20000005C0070001700004A6F73E9204C75ED7320436F6CED6E2052616DED72657A202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202042000200B004610102000000C00100003D01080001000300020004009C0002001100190002000000120002000000130002000000AF0102000000BC01020000003D001200F1FFF1FF8F25CD2338000000000001002E034000020000008D00020000002200020000000E0002000100B70102000000DA000200000031001A00C8000000FF7F9001000000000000050141007200690061006C0031001E00DC000000080090010000000200000701430061006C00690062007200690031001E00DC000000080090010000000200000701430061006C00690062007200690031001E00DC000000080090010000000200000701430061006C00690062007200690031001A00C8000100FF7FBC02000000020000050141007200690061006C0031001A00C8000000FF7F9001000000020000050141007200690061006C0031001A00C8000100FF7FBC02000000020000050141007200690061006C0031001A00A0000000FF7F9001000000020000050141007200690061006C0031001A00A0000100FF7FBC02000000020000050141007200690061006C0031001A008C000000FF7F9001000000020000050141007200690061006C0031001A008C000100FF7FBC02000000020000050141007200690061006C00310022008C000000FF7F900100000002000009014100670065006E006300790020004600420031001C00A0000000FF7F900100000002000006015400610068006F006D00610031001A00B4000100FF7FBC02000000020000050141007200690061006C0031001C00A00001005100BC0200000002000006015400610068006F006D00610031001C00A00000005100900100000002000006015400610068006F006D00610031001A00C8000000FF7F9001000000020000050141007200690061006C0031001A00C8000000FF7F9001000000000000050141007200690061006C0031001E00DC000000080090010000000200000701430061006C00690062007200690031001E00DC000000090090010000000200000701430061006C00690062007200690031001E00DC000000110090010000000200000701430061006C00690062007200690031001E00DC0001000A00BC020000000200000701430061006C00690062007200690031001E00DC0001000900BC020000000200000701430061006C00690062007200690031001E00DC0000000A0090010000000200000701430061006C00690062007200690031001E00DC0001003E00BC020000000200000701430061006C00690062007200690031001E00DC0000003E0090010000000200000701430061006C00690062007200690031001A00C80004000C009001000001020000050141007200690061006C0031001E00DC000000140090010000000200000701430061006C00690062007200690031001E00DC000000130090010000000200000701430061006C00690062007200690031001E00DC0001003F00BC020000000200000701430061006C00690062007200690031001E00DC0000000A0090010000000200000701430061006C00690062007200690031001E00DC000200170090010000000200000701430061006C00690062007200690031001E00680101003E00BC020000000200000701430061006D00620072006900610031001E002C0101003E00BC020000000200000701430061006C00690062007200690031001E00040101003E00BC020000000200000701430061006C00690062007200690031001E00DC0001000800BC020000000200000701430061006C00690062007200690031001E00B4000000080090010000000200000701430061006C00690062007200690031001E00B40003000800BC020000000200000701430061006C00690062007200690031001E00B40001000A00BC020000000200000701430061006C00690062007200690031001E00B40000000A0090010000000200000701430061006C00690062007200690031001E00B40001000800BC020000000200000701430061006C00690062007200690031001E00C80001000800BC020000000200000701430061006C00690062007200690031001A00A000000008009001000000020000050141007200690061006C001E0418000500130000222422232C2323303B5C2D222422232C2323301E041D000600180000222422232C2323303B5B5265645D5C2D222422232C2323301E041E000700190000222422232C2323302E30303B5C2D222422232C2323302E30301E04230008001E0000222422232C2323302E30303B5B5265645D5C2D222422232C2323302E30301E0435002A003000005F2D2224222A20232C2323305F2D3B5C2D2224222A20232C2323305F2D3B5F2D2224222A20222D225F2D3B5F2D405F2D1E042C0029002700005F2D2A20232C2323305F2D3B5C2D2A20232C2323305F2D3B5F2D2A20222D225F2D3B5F2D405F2D1E043D002C003800005F2D2224222A20232C2323302E30305F2D3B5C2D2224222A20232C2323302E30305F2D3B5F2D2224222A20222D223F3F5F2D3B5F2D405F2D1E0434002B002F00005F2D2A20232C2323302E30305F2D3B5C2D2A20232C2323302E30305F2D3B5F2D2A20222D223F3F5F2D3B5F2D405F2D1E041000A4000B0000222422232C2323302E30301E041100A5000C00005B24245D232C2323302E30301E040D00A600080000302E3030303030301E043C00A7003700005F2D2A20232C2323302E3030303030305F2D3B5C2D2A20232C2323302E3030303030305F2D3B5F2D2A20222D223F3F5F2D3B5F2D405F2D1E040B00A800060000302E303030301E040E00A900090000302E303030303030301E040B00AA00060000302E303030251E040C00AB00070000302E30303030251E041100AC000C000064642F6D6D2F797979793B40E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E000140000000000F5FF200000000000000000000000C020E0001400000000000100200000000000000000000000C020E000140013000000F5FF200000B40000000000000004AC20E000140013000000F5FF200000B400000000000000049D20E000140013000000F5FF200000B400000000000000049A20E000140013000000F5FF200000B40000000000000004AF20E000140013000000F5FF200000B400000000000000049B20E000140013000000F5FF200000B400000000000000049A20E000140013000000F5FF200000B400000000000000049B20E000140013000000F5FF200000B400000000000000049D20E000140013000000F5FF200000B40000000000000004AB20E000140013000000F5FF200000B40000000000000004AD20E000140013000000F5FF200000B400000000000000049B20E000140013000000F5FF200000B400000000000000049A20E000140014000000F5FF200000B400000000000000049B20E000140014000000F5FF200000B40000000000000004B520E000140014000000F5FF200000B40000000000000004B320E000140014000000F5FF200000B40000000000000004AD20E000140014000000F5FF200000B400000000000000049B20E000140014000000F5FF200000B400000000000000049D20E000140015000000F5FF200000B400000000000000049B20E000140016000000F5FF200000941111970B970B00048920E000140017000000F5FF200000946666BF1FBF1F0004B720E000140018000000F5FF200000D40060000000050000C020E000140019000000F5FF200000F40000000000000000C020E000140014000000F5FF200000B40000000000000004B820E000140014000000F5FF200000B40000000000000004B520E000140014000000F5FF200000B40000000000000004B320E000140014000000F5FF200000B40000000000000004B620E000140014000000F5FF200000B40000000000000004B120E000140014000000F5FF200000B400000000000000048A20E00014001A000000F5FF200000941111970B970B0004AB20E00014001B000000F4FF000000F40000000000000000C020E00014001C000000F5FF200000B40000000000000004AE20E000140012002B00F5FF200000F80000000000000000C020E000140012002900F5FF200000F80000000000000000C020E000140006000000F5FF200000000000000000000000C020E000140013002B00F5FF200000F80000000000000000C020E000140011002C00F5FF200000F80000000000000000C020E000140012002A00F5FF200000F80000000000000000C020E000140013002C00F5FF200000F80000000000000000C020E00014001D000000F5FF200000B40000000000000004AB20E000140006000000F5FF200000000000000000000000C020E000140013000000F5FF200000000000000000000000C020E000140012000000F5FF2000009C1111160B160B00049A20E000140012000900F5FF200000F80000000000000000C020E000140013000900F5FF200000F80000000000000000C020E00014001E000000F5FF200000941111BF1FBF1F00048920E00014001F000000F5FF200000F40000000000000000C020E000140020000000F5FF200000F40000000000000000C020E000140021000000F5FF200000F40000000000000000C020E000140022000000F5FF200000D400500000001C0000C020E000140023000000F5FF200000D400500000800D0000C020E000140019000000F5FF200000D400200000800D0000C020E000140024000000F5FF200000D400610000381C0000C020E0001400070000000100260000180000000000000000C020E0001400050000000100220000180000000000000000C020E0001400000000000100210000100000000000000000C020E0001400000000000100000000701111402040201004AA20E00014000700000001000200007801014020402010048D20E00014000700000001000200007810014020402010048D20E00014000700000001000A00007810014020402010048D20E00014000700000001000000007801114020402010063320E00014000000000001000000007000114020402010063320E00014000700000001000800007810114020402010063320E0001400060000000100000000781110402040201004AA20E0001400000000000100000000701110402040201004AA20E0001400060000000100000000781111402040201004AA20E00014001B000000E102080000F01111402040201006AA20E00014000000000001000000007010114020402010063320E00014000700000001000800007811114020402010063320E0001400060000000100000000781101402040201004AA20E0001400000000000100000000701101402040201004AA20E00014000700000001000000007801004020402010063320E00014000000000001000000007010004020402010063320E00014000700000001000800007810004020402010063320E0001400060000000100000000780111402040201004AA20E0001400060000008103200000000000000000000000C020E00014000900A50021030300003C0000000000000000C020E00014000900A50021031300003C6060402040201000C020E000140008000900C103100000380060402040201000C020E00014000900A50021031300003C0060402040201000C020E0001400090000002103130000380060402040201000C020E0001400090000002103110000380060402040201000C020E0001400090000002103010000380060402040201000C020E0001400090000002103010000380660402040201000C020E00014000800A50021030300003C0000000000000000C020E0001400090000008103200000286000402040201000C020E000140008002C0021031100003C0000000000000000C020E0001400080000002103000000380000000000000000C020E0001400080000002103010000380000000000000000C020E0001400080000002103010000380600402040201000C020E000140008002C0021030300003C0000000000000000C020E0001400080000008103220000380000000000000000C020E00014000800A60021030300003C0000000000000000C020E000140009002C0081031000003C6011402040201000C020E00014000900A50021031300003C0111402040201000C020E0001400080000008103200000280000000000000000C020E000140009000A0021030300003C6000402040201000C020E0001400090000008103200000280000000000000000C020E00014000900020021030300003C0000000000000000C020E00014000A0000002103010000380000000000000000C020E000140009002C0031031300003C6060402040201000C020E0001400090000008103100000380060402040201000C020E000140009002C0081031000003C0060402040201000C020E0001400060000008103100000300060402040201000C020E00014000A0000002103010000380060402040201000C020E0001400080000002103010000380660402040201000C020E000140008002C0081031000003C6000402040201000C020E000140008000900C103130000380000000000000000C020E000140008002C0081031000003C0000000000000000C020E0001400080000002103130000380000000000000000C020E0001400080000008103200000280600402040201000C020E0001400060000008103200000206000402040201000C020E000140008002C0081032000002C6000402040201000C020E000140008000900C103030000380000000000000000C020E00014000800A40081031000003C7077402040201000C020E00014000800A40081031200003C7777402040201000C020E00014000800A70031031200003C7777402040201000C020E000140008002C006103120000387777402040201000C020E0001400080000008103120000387777402040201000C020E000140008000900C103030000380700402040201000C020E000140008002C0031031100003C0070402040201000C020E000140008000900C103030000380070402040201000C020E0001400080000002103110000380070402040201000C020E00014000A0000002103110000380070402040201000C020E0001400080000002103110000380670402040201000C020E000140008002C0031031100003C0000000000000000C020E0001400080000002103110000380000000000000000C020E00014000A0000002103110000380000000000000000C020E0001400080000002103110000380600402040201000C020E000140008000900C103200000280000000000000000C020E000140008002C0021031300003C0000000000000000C020E000140008002C0021030100003C0000000000000000C020E000140008000900C903200000280000000000000000C020E000140009002C0031031000003C6060402040201000C020E00014000900020021031300003C0060402040201000C020E000140009002C0031031000003C0060402040201000C020E000140008002C0031030300003C6000402040201000C020E000140008000900C103200000680000000000000000C020E000140009002C0031030000003C0000000000000000C020E000140008002C0031030000003C0000000000000000C020E000140008002C0031031000003C0000000000000000C020E000140008000900C103030000780000000000000000C020E00014000B002B003103020000386000402040201000C020E00014000B0000002103010000380000000000000000C020E00014000B0000002103010000380600402040201000C020E0001400060000008103200000200066402040201000C020E00014000800A80081030200003C6060402040201000C020E00014000C0000002103030000380060402040201000C020E0001400060000008103200000280060402040201000C020E0001400060000008103200000280160402040201000C020E000140008002B003103010000380060402040201000C020E00014000800020081030000003C0060402040201000C020E00014000A0000002103000000380060402040201000C020E0001400080000002103000000380660402040201000C020E0001400080000002103010000386000402040201000C020E0001400080000002103030000380000000000000000C020E0001400060000008103000000380000000000000000C020E0001400060000008103000000380100402040201000C020E000140008002B003103010000380000000000000000C020E00014000800020081030000003C0000000000000000C020E00014000A0000002103000000380000000000000000C020E0001400080000002103000000380600402040201000C020E000140008002C006103000000380000000000000000C020E000140008000900C103000000380000000000000000C020E0001400060000008103000000306000402040201000C020E0001400080000002903010000386000402040201000C020E0001400080000008103000000380000000000000000C020E0001400080000002103030000380006402040201000C020E0001400060000008103000000380006402040201000C020E0001400060000008103200000200060402040201000C020E0001400080000009103200000280060402040201000C020E0001400080000009103210000380160402040201000C020E0001400080000009103260000381060402040201000C020E0001400060000008103200000200001402040201000C020E0001400080000009103200000280001402040201000C020E0001400080000009103020000386010402040201000C020E0001400080000009103000000380010402040201000C020E0001400060000008103000000300000000000000000C020E0001400080000009103000000380000000000000000C020E0001400090000009103000000386000402040201000C020E0001400080000009103030000380600402040201000C020E0001400080000009103000000386000402040201000C020E0001400090000009103020000386000402040201000C020E0001400090000009103020000380000000000000000C020E0001400080000009103020000386000402040201000C020E0001400080000009103020000380000000000000000C020E00014000D000F0091030300003C0000000000000000C020E0001400090000009103010000386000402040201000C020E0001400090000009103020000386006402040201000C020E0001400090000009103020000380006402040201000C020E0001400060000008103000000300006402040201000C020E0001400080000009103030000380606402040201000C020E0001400250000009103200000080000000000000002C020E000140025002C006103200000080000000000000002C020E0001400250000009103200000480000000000000002C020E00014000800A80081032000006C6000402040201000C020E0001400250000009103200000680000000000000002C020E0001400250000009103200000680600402040201002C020E00014000800A80081032000006C60104020402010063520E00014002500A90091032000006C00104020402010063520E00014002500000091032000006800104020402010063520E00014002500000091032000006806104020402010063520E00014000800A80081032000006C60014020402010063520E00014002500A80031032000006C00014020402010063520E00014002500000091032000006800014020402010063520E00014002500000091032000006806014020402010063520E00014000800A80081032000006C60164020402010063320E00014002500000091032000006800164020402010063320E00014002600000091032000006806164020402010063320E00014000800A80081032000002C6000402040201000C020E0001400250000009103200000280000000000000002C020E0001400250000009103200000280600402040201002C020E0001400270000009103200000080000000000000002C020E00014000800A80081032000006C60104020402010061D20E00014002500A60091032000006C00104020402010061D20E00014002500000091032000006800104020402010061D20E00014002500000091032000006806104020402010061D20E00014000800A80081032000006C60014020402010061D20E00014002500020091032000006C00014020402010061D20E00014002500000091032000006800014020402010061D20E00014002500000091032000006806014020402010061D20E00014000800A80081032000006C60164020402010063520E00014002500000091032000006800164020402010063520E00014002600000091032000006806164020402010063520E00014000800A80081032000006C60104020402010061B20E000140025002C0061032000006800104020402010061B20E00014002500000091032000006800104020402010061B20E00014002500000091032000006806104020402010061B20E00014000800A80081032000006C60014020402010061B20E000140025002C0061032000006800014020402010061B20E00014002500000091032000006800014020402010061B20E00014002500000091032000006806014020402010061B20E00014000800A80081032000006C60164020402010061B20E00014002500000091032000006800164020402010061B20E00014002600000091032000006806164020402010061B20E00014000800A80081032000002C6006402040201000C020E0001400250000009103200000280006402040201002C020E0001400250000009103200000280606402040201002C020E00014000800A80081032000002C6060402040201000C020E0001400250000009103200000280060402040201002C020E0001400250000009103200000280660402040201002C020E0001400250000009103200000286001402040201002C020E0001400250000009103220000380001402040201002C020E0001400250000009103200000280001402040201002C020E0001400250000009103200000280601402040201002C020E00014002500000091032000006860064020402010061A20E00014002500000091032000006800064020402010061A20E00014002500000091032000006806064020402010061A20E0001400250000009103200000286161402040201002C020E0001400250000009103200000281161402040201002C020E0001400250000009103200000281661402040201002C020E00014002500000091032000006811114020402010062D20E00014002500000091032000006816114020402010062D20E000140008002C006103200000280000000000000000C020E000140008002C006103200000286111402040201000C020E0001400250000009103200000286111402040201002C020E0001400280000009103200000280000000000000002C020E000140008002C0061032000006811114020402010063320E00014002500000091032000006811114020402010063320E00014002500000091032000006816114020402010063320E00014000800A80031032000006C11114020402010063320E00014000800000081032200007811114020402010063320E0001400270000009103200000280000000000000002C020E000140025002C0091032000006C61114020402010062B20E00014002500000091032000006811114020402010062B20E00014002500000091032000006816114020402010062B20E00014002500000091032000006861114020402010062B20E000140025002C0061032000006810114020402010062F20E000140025002C0061032000006811114020402010062F20E000140025002C0061032000006800114020402010062F20E00014002500000091032000006810114020402010062F20E00014002500000091032000006801114020402010062F20E00014002500000091032000006C11114020402010062B20E000140025002C0091032000006C11114020402010062B20E000140025000900C103030000780007402040201002C020E000140025000900C103030000781107402040201002C020E0001400290000009103010000780007402040201002C020E00014002500000091032000006811174020402010062F20E00014002500000091032000006801174020402010062F20E000140025000900C103030000780000000000000002C020E000140025000900C103030000781100402040201002C020E000140029002C0091030100007C0000000000000002C020E000140025002C006103200000281077402040201002C020E000140025002C006103200000281177402040201002C020E000140025002C006103200000280077402040201002C020E0001400250000009103200000281177402040201002C020E0001400250000009103220000380177402040201002C020E0001400250000009103200000280177402040201002C020E000140025000900C103030000780077402040201002C020E000140025000900C103030000781177402040201002C020E0001400290000009103010000780077402040201002C020E00014000800000081032000006811114020402010062D20E000140025002C0061032000006810774020402010062F20E000140025002C0061032000006811774020402010062F20E000140025002C0061032000006800774020402010062F20E00014002500000091032000006811774020402010062F20E00014002500000091032200007801774020402010062F20E00014002500000091032000006801774020402010062F20E000140008002C0061032000006861114020402010063320E0001400250000009103200000281111402040201002C020E000140025002C006103200000281111402040201002C020E0001400250000009103200000281707402040201002C020E0001400250000009103200000280707402040201002C020E0001400250000009103200000287707402040201002C020E0001400250000009103200000287107402040201002C020E0001400250000009103200000287717402040201002C020E0001400250000009103200000287117402040201002C020E0001400250000009103200000281777402040201002C020E0001400250000009103200000280777402040201002C020E0001400250000009103200000287777402040201002C020E0001400250000009103200000287177402040201002C020E0001400250000009103200000281771402040201002C020E0001400250000009103200000280771402040201002C020E0001400250000009103200000287771402040201002C020E0001400250000009103200000287171402040201002C020E000140025002C0061032000006810714020402010062F20E000140025002C0061032000006811714020402010062F20E000140025002C0061032000006800714020402010062F20E00014002500000091032000006811714020402010062F20E00014002500000091032200007801714020402010062F20E00014002500000091032000006801714020402010062F20E000140025000900C103030000780071402040201002C020E000140025000900C103030000781171402040201002C020E0001400290000009103010000780071402040201002C020E0001400250000009103200000286116402040201002C020E0001400260000009103210000381110402040201002C020E0001400260000009103120000381111402040201002C020E0001400290000009103200000281111402040201002C020E0001400290000009103220000780010402040201002C020E0001400290000009103220000781110402040201002C020E0001400260000009103220000780000000000000002C020E0001400260000009103220000786166402040201002C020E0001400260000009103220000781166402040201002C020E0001400260000009103220000781666402040201002C020E0001400250000009103260000382022402040201002C020E0001400250000009103260000380022402040201002C020E0001400250000009103260000380222402040201002C020E00014002A0000009103200000580000000000000002C020E00014002A00000091032000005800000000000000063520E00014002500000091032000006806164020402010063520E00014002500000091032000006800164020402010063520E00014002500000091032000006860164020402010063520E0001400080000008103030000380000000000000000C020E0001400090000000100080000781111402040201004AA20E00014000900000021030100007806664020402010060920E00014000900000021030600007800664020402010060920E00014000900000021030600007810664020402010060920E00014000900000021030200007811664020402010060920E00014000900000021030200007861664020402010060920E00014000900000021030600007860664020402010060920E00014000900000021030200007800664020402010060920E00014000900000021030100007800664020402010060920E000140009002C0061030100007800664020402010060920E000140009002C0061032000006800664020402010060920E000140009002C0061032000006860664020402010060920E00014000800000081032200007877774020402010060920E00014000800000081032200007870774020402010060920E0001400090000000100090000781111402040201004AA20E0001400090000000100080000781110402040201004AA20E00014000900310001000800007C1111402040201004AA20E000140009000E0001000900007C1111402040201004AA20E00014000900310001000900007C1111402040201004AA20E0001400090000000100080000781011402040201004AA20E000140009000E0001000900007C1101402040201004AA20E00014000900A40001000900007C1111402040201004AA20E000140009000A0001000900007C1111402040201004AA20E0001400090000000100090000781011402040201004AA20E00014002500000091032000006816114020402010060920E00014002500000091032000006811114020402010060920E00014000800000081032000006811114020402010060920E000140008000900C1032200007811114020402010060920E00014000800000081032200007811114020402010060920E00014002500000091032000006806114020402010060920E00014002500000091032000006801114020402010060920E00014002500000091032000006800114020402010060920E000140008002C0081032000006C61114020402010060920E00014002500000091032000006806114020402010060920E00014002500000091032000006811114020402010060920E000140025002C0061032000006860114020402010060920E00014002500000091032000006816114020402010060920E000140025002C0091032000006C61114020402010060920E000140025002C0061032000006861114020402010060920E00014002500000091032000006816114020402010060920E00014002500000091032000006811114020402010060920E00014002500000091032000006861114020402010060920E00014002500000091032000006816114020402010060920E00014002500000091032000006811114020402010060920E000140008002C0061030300007861114020402010060920E00014002500000091032000006816164020402010060920E00014002500000091032000006811164020402010060920E000140008002C0061032000006811164020402010060920E00014002500000091032000006816114020402010060920E00014002500000091032000006811114020402010060920E000140008002C0061032000006811114020402010060920E000140008002B0031032000006811114020402010060920E00014000800000081032200007811114020402010060920E00014002500000091032000006816114020402010060920E00014002500000091032000006811114020402010060920E00014000800000081032200007811114020402010060920E000140008002C0081032000006C11114020402010060920E00014000800000081032000006811114020402010060920E00014000800000081032000006861114020402010060920E00014002500000091032000006800064020402010060920E00014002500000091032000006800000000000000060920E00014002500000091032000006800604020402010060920E00014002600000091032000006806064020402010060920E00014002600000091032000006806004020402010060920E00014000800A80081032000006C00064020402010060920E0001400250000009103090000180000000000000002C020E00014000600000081032000006006064020402010060920E00014000900000021030600007800064020402010060920E00014000600000081032600007000064020402010060920E00014000600000081032600007060064020402010060920E00014000900000021030300007806014020402010060920E00014000800000021030000007800014020402010060920E00014000900000021030300007800014020402010060920E00014000800000021030200007800014020402010060920E00014000A00000021030100007801014020402010060920E00014000600000081032000006000014020402010060920E00014000600000081032000006060014020402010060920E00014000A00000021030100007801004020402010060920E00014000900000021030300007800000000000000060920E00014000800000021030100007800000000000000060920E00014000600000081032000006000000000000000060920E00014000600000081032000006060004020402010060920E00014000A00000021030100007801104020402010060920E00014000800000021030300007800000000000000060920E00014000800000081030200007800000000000000060920E0001400080000002103000000380606402040201000C020E00014000A0000002103000000380006402040201000C020E000140008002C006103000000380006402040201000C020E00014000800A50021030300003C0006402040201000C020E0001400060000008103000000380106402040201000C020E0001400080000008103030000380006402040201000C020E0001400060000008103000000306006402040201000C020E0001400080000002103030000380066402040201000C020E0001400080000008103020000380066402040201000C020E0001400060000008103000000300066402040201000C020E000140006002B003103000000380066402040201000C020E000140008000900C103020000380066402040201000C020E00014000600000081032000006006014020402010060920E00014000800000021030300007800014020402010060920E00014000800000021030100007800014020402010060920E00014000600000081030000007000014020402010060920E000140006002B0031030000007801014020402010060920E00014000600000081032000006006604020402010060920E00014000800000021030300007800604020402010060920E00014000800000081030100007800604020402010060920E00014000600000081030000007000604020402010060920E000140006002B0031030000007801604020402010060920E00014000600000081032000006000604020402010060920E00014000600000081032000006060604020402010060920E00014000D0000009103000000380000000000000000C020E0001400080000009103210000380101402040201000C020E0001400090000009103220000386101402040201000C020E0001400090000009103200000381001402040201000C020E00014000800000081032000006801114020402010060920E00014002500000091032000006860114020402010060920E000140025002C004103200000287771402040201002C020E000140025002C004103200000287777402040201002C020E000140025002C004103200000287717402040201002C020E00014000800AA00C1032000006C11114020402010062D20E00014000800A60081032000006C61114020402010062D20E0001400260000009103210000380110402040201002C020E000140025002C004103200000280771402040201002C020E000140025002C004103200000280777402040201002C020E000140025002C004103200000280717402040201002C020E000140025002C0091032000002C0111402040201002C020E0001400260000009103210000382702402040201002C020E000140025002C0091032000002C2711402040201002C020E000140025002C0091032000006C11114020402010062F20E00014002500000091032000006C61114020402010062B20E00014000800020081030300003C0000000000000000C020E00014002900000091032000006806604020402010060920E00014000800AB00C1030000003C0000000000000000C020E00014000800AB00C1032200007C11114020402010060920E00014002500000091032000006801074020402010062F20E00014002500000091032200007801074020402010062F20E00014002500000091032000006811074020402010062F20E00014002500000091032000006811114020402010062F20E00014002500000041032000002C2771402040201002C020E00014002500000041032000002C2777402040201002C020E00014002500000041032000002C2717402040201002C020E0001400080000000100200000080000000000000000C020E00014000800AC0021030100003C0000000000000000C020E00014000900000021030100007806664020402010060920E00014000900000021030100007800664020402010060920E00014000800000081032200007870774020402010060920E00014000900000021030200007801664000402010060920E00014000900000021030200007860664020402010060920E00014000800AA00C1030200007C00014020402010060920E00014000800AA00C1030200007C00604020402010060920E00014002B0000009103220000386160402040201002C020E00014002B0000009103220000386100402040000002C020E0001400080000009103220000386100402040000000C020E00014000900000091031A0000386101402040201000C020E00014002A00000091032200005800000000000000063520E00014002500000091030900007800000000000000060920E00014000E00000021030A0000380006402040201000C020E00014000E00000021030A0000380000000000000000C020E00014000900000021030100007806664020402010060920E00014000900000021030100007800664020402010060920E00014000800000021030D00007806004020402010060920E00014001300000091030800007000000000000000060920E00014001300000091030000007006004020402010060920E00014001300000091030000007000000000000000060920E00014000E0000008103220000580000000000000000C020E00014000900000021031200007800164020402010060920E0001400080000002103090000380000000000000000C020E0001400000000000100000000100000000000000000C020E00014000800000081032200007806774020402010060920E00014000800000081032200007870774020402010060920E0001400080000008103120000380677402040201000C020E0001400080000008103120000387077402040201000C020E00014000800020091032200003C0601402040201000C020E00014000800020091032200003C0001402040201000C020E00014000800020091032200003C1001402040201000C020E00014000E0000009103220000380660402040201000C020E00014000E0000009103220000380060402040201000C020E00014000E0000009103220000381060402040201000C0207C0814007C0800000000000000000000000018021A3C949B7D0841007D080000000000000000000000001000000003000D0014000300000001000000302E3030303030300E00050002040014000300656604000000405F2D2D202020207D0841007D080000000000000000000000001100000003000D0014000300000001000000302E3030303030300E00050002040014000300656605000000405F2D2D202020207D0841007D080000000000000000000000001200000003000D0014000300000001000000302E3030303030300E00050002040014000300656606000000405F2D2D202020207D0841007D080000000000000000000000001300000003000D0014000300000001000000302E3030303030300E00050002040014000300656607000000405F2D2D202020207D0841007D080000000000000000000000001400000003000D0014000300000001000000302E3030303030300E00050002040014000300656608000000405F2D2D202020207D0841007D080000000000000000000000001500000003000D0014000300000001000000302E3030303030300E00050002040014000300656609000000405F2D2D202020207D0841007D080000000000000000000000001600000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C04000000405F2D2D202020207D0841007D080000000000000000000000001700000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C05000000405F2D2D202020207D0841007D080000000000000000000000001800000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C06000000405F2D2D202020207D0841007D080000000000000000000000001900000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C07000000405F2D2D202020207D0841007D080000000000000000000000001A00000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C08000000405F2D2D202020207D0841007D080000000000000000000000001B00000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C09000000405F2D2D202020207D0841007D080000000000000000000000001C00000003000D0014000300000000000000302E3030303030300E00050002040014000300323304000000405F2D2D202020207D0841007D080000000000000000000000001D00000003000D0014000300000000000000302E3030303030300E00050002040014000300323305000000405F2D2D202020207D0841007D080000000000000000000000001E00000003000D0014000300000000000000302E3030303030300E00050002040014000300323306000000405F2D2D202020207D0841007D080000000000000000000000001F00000003000D0014000300000000000000302E3030303030300E00050002040014000300323307000000405F2D2D202020207D0841007D080000000000000000000000002000000003000D0014000300000000000000302E3030303030300E00050002040014000300323308000000405F2D2D202020207D0841007D080000000000000000000000002100000003000D0014000300000000000000302E3030303030300E00050002040014000300323309000000405F2D2D202020207D0841007D080000000000000000000000002200000003000D00140002000000006100FF302E3030303030300E000500020400140002000000C6EFCEFF405F2D2D202020207D0891007D080000000000000000000000002300000007000D00140002000000FA7D00FF302E3030303030300E000500020400140002000000F2F2F2FF405F2D2D2020202007001400020000007F7F7FFF202020202020202008001400020000007F7F7FFF202020202020202009001400020000007F7F7FFF00000000000000000A001400020000007F7F7FFF00000000000000007D0891007D080000000000000000000000002400000007000D0014000300000000000000302E3030303030300E000500020400140002000000A5A5A5FF405F2D2D2020202007001400020000003F3F3FFF202020202020202008001400020000003F3F3FFF202020202020202009001400020000003F3F3FFF00000000000000000A001400020000003F3F3FFF00000000000000007D0841007D080000000000000000000000002500000003000D00140002000000FA7D00FF302E3030303030300E000500020800140002000000FF8001FF405F2D2D202020207D082D007D080000000000000000000000002600000002000D0014000300000003000000302E3030303030300E000500027D0841007D080000000000000000000000002700000003000D0014000300000000000000302E3030303030300E00050002040014000300000004000000405F2D2D202020207D0841007D080000000000000000000000002800000003000D0014000300000000000000302E3030303030300E00050002040014000300000005000000405F2D2D202020207D0841007D080000000000000000000000002900000003000D0014000300000000000000302E3030303030300E00050002040014000300000006000000405F2D2D202020207D0841007D080000000000000000000000002A00000003000D0014000300000000000000302E3030303030300E00050002040014000300000007000000405F2D2D202020207D0841007D080000000000000000000000002B00000003000D0014000300000000000000302E3030303030300E00050002040014000300000008000000405F2D2D202020207D0841007D080000000000000000000000002C00000003000D0014000300000000000000302E3030303030300E00050002040014000300000009000000405F2D2D202020207D0891007D080000000000000000000000002D00000007000D001400020000003F3F76FF302E3030303030300E000500020400140002000000FFCC99FF405F2D2D2020202007001400020000007F7F7FFF202020202020202008001400020000007F7F7FFF202020202020202009001400020000007F7F7FFF00000000000000000A001400020000007F7F7FFF00000000000000007D0828007D080000000000000000000000002E00000001000D001400030000000A000000302E3030303030307D0841007D080000000000000000000000002F00000003000D001400020000009C0006FF302E3030303030300E000500020400140002000000FFC7CEFF405F2D2D202020207D082D007D080000000000000000000000003300000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000003600000002000D0014000300000001000000302E3030303030300E000500027D0841007D080000000000000000000000003700000003000D001400020000009C6500FF302E3030303030300E000500020400140002000000FFEB9CFF405F2D2D202020207D082D007D080000000000000000000000003900000002000D0014000300000001000000302E3030303030300E000500027D0878007D080000000000000000000000003A00000005000400140002000000FFFFCCFF302E3030303030300700140002000000B2B2B2FF00FFEB9CFF405F2D0800140002000000B2B2B2FF007F7F7FFF2020200900140002000000B2B2B2FF007F7F7FFF2020200A00140002000000B2B2B2FF007F7F7FFF0000007D082D007D080000000000000000000000003C00000002000D0014000300000001000000302E3030303030300E000500027D0891007D080000000000000000000000003D00000007000D001400020000003F3F3FFF302E3030303030300E000500020400140002000000F2F2F2FF405F2D080014000207001400020000003F3F3FFF202020090014000208001400020000003F3F3FFF2020200A0014000209001400020000003F3F3FFF00000000000000000A001400020000003F3F3FFF00000000000000007D082D007D080000000000000000000000003E00000002000D00140002000000FF0000FF302E3030303030300E000500027D082D007D080000000000000000000000003F00000002000D001400020000007F7F7FFF302E3030303030300E000500027D082D007D080000000000000000000000004000000002000D0014000300000003000000302E3030303030300E000500017D0841007D080000000000000000000000004100000003000D0014000300000003000000302E3030303030300E00050002080014000300000004000000405F2D08001400027D0841007D080000000000000000000000004200000003000D0014000300000003000000302E3030303030300E00050002080014000300FF3F04000000405F2D08001400027D0841007D080000000000000000000000004300000003000D0014000300000003000000302E3030303030300E00050002080014000300323304000000405F2D08001400027D0855007D080000000000000000000000004400000004000D0014000300000001000000302E3030303030300E00050002070014000300000004000000405F2D080014000208001400030000000400000020202009001400027D0828007D080000000000000000000000004C000000010004001400030001E006000000302E3030303030307D0828007D080000000000000000000000004D000000010004001400030001E006000000302E3030303030307D0828007D080000000000000000000000004E000000010004001400030001E006000000302E3030303030307D0828007D080000000000000000000000005200000001000D001400030000000A000000302E3030303030307D0828007D0800000000000000000000000053000000010004001400030001E006000000302E3030303030307D0828007D0800000000000000000000000054000000010004001400030001E006000000302E3030303030307D0828007D0800000000000000000000000057000000010004001400030001E006000000302E3030303030307D0828007D0800000000000000000000000058000000010004001400030001E006000000302E3030303030307D0828007D0800000000000000000000000059000000010004001400030001E006000000302E3030303030307D082D007D08000000000000000000000000D000000002000D0014000300000001000000302E3030303030300E000500027D082D007D08000000000000000000000000D100000002000D0014000300000001000000302E3030303030300E000500027D082D007D08000000000000000000000000D200000002000D0014000300000001000000302E3030303030300E000500027D082D007D08000000000000000000000000D400000002000D0014000300000001000000302E3030303030300E000500027D082D007D08000000000000000000000000D500000002000D0014000300000001000000302E3030303030300E000500027D0828007D08000000000000000000000000D6000000010004001400030001E002000000302E3030303030307D0841007D08000000000000000000000000D700000003000D0014000300000001000000302E3030303030300E0005000204001400030001E002000000405F2D08001400027D0841007D08000000000000000000000000D800000003000D0014000300000001000000302E3030303030300E0005000204001400030001E002000000405F2D08001400027D0841007D08000000000000000000000000D900000003000D0014000300000001000000302E3030303030300E0005000204001400030001E002000000405F2D08001400027D0828007D08000000000000000000000000DA000000010004001400030001E002000000302E3030303030307D0841007D08000000000000000000000000DB00000003000D0014000300000001000000302E3030303030300E0005000204001400030001E002000000405F2D08001400027D0841007D08000000000000000000000000DC00000003000D0014000300000001000000302E3030303030300E0005000204001400030001E002000000405F2D08001400027D0841007D08000000000000000000000000DD00000003000D0014000300000001000000302E3030303030300E0005000204001400030001E002000000405F2D08001400027D0828007D08000000000000000000000000DE000000010004001400030001C002000000302E3030303030307D0841007D08000000000000000000000000DF00000003000D0014000300000001000000302E3030303030300E0005000204001400030001C002000000405F2D08001400027D0841007D08000000000000000000000000E000000003000D0014000300000001000000302E3030303030300E0005000204001400030001C002000000405F2D08001400027D082D007D08000000000000000000000000E200000002000D0014000300000001000000302E3030303030300E000500027D082D007D08000000000000000000000000E300000002000D0014000300000001000000302E3030303030300E000500027D082D007D08000000000000000000000000E400000002000D00140002000000FF0000FF302E3030303030300E000500027D0828007D08000000000000000000000000E50000000100040014000300CC4C05000000302E3030303030307D0841007D08000000000000000000000000E600000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C05000000405F2D08001400027D0841007D08000000000000000000000000E700000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C05000000405F2D08001400027D0841007D08000000000000000000000000E800000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C05000000405F2D08001400027D0828007D08000000000000000000000000E90000000100040014000300CC4C05000000302E3030303030307D0841007D08000000000000000000000000EA00000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C05000000405F2D08001400027D0841007D08000000000000000000000000EB00000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C05000000405F2D08001400027D0841007D08000000000000000000000000EC00000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C05000000405F2D08001400027D0828007D08000000000000000000000000ED0000000100040014000300323305000000302E3030303030307D0841007D08000000000000000000000000EE00000003000D0014000300000001000000302E3030303030300E00050002040014000300323305000000405F2D08001400027D0841007D08000000000000000000000000EF00000003000D0014000300000001000000302E3030303030300E00050002040014000300323305000000405F2D08001400027D0828007D08000000000000000000000000F00000000100040014000300656608000000302E3030303030307D0841007D08000000000000000000000000F100000003000D0014000300000001000000302E3030303030300E00050002040014000300656608000000405F2D08001400027D0841007D08000000000000000000000000F200000003000D0014000300000001000000302E3030303030300E00050002040014000300656608000000405F2D08001400027D0841007D08000000000000000000000000F300000003000D0014000300000001000000302E3030303030300E00050002040014000300656608000000405F2D08001400027D0828007D08000000000000000000000000F40000000100040014000300656608000000302E3030303030307D0841007D08000000000000000000000000F500000003000D0014000300000001000000302E3030303030300E00050002040014000300656608000000405F2D08001400027D0841007D08000000000000000000000000F600000003000D0014000300000001000000302E3030303030300E00050002040014000300656608000000405F2D08001400027D0841007D08000000000000000000000000F700000003000D0014000300000001000000302E3030303030300E00050002040014000300656608000000405F2D08001400027D0828007D08000000000000000000000000F80000000100040014000300323308000000302E3030303030307D0841007D08000000000000000000000000F900000003000D0014000300000001000000302E3030303030300E00050002040014000300323308000000405F2D08001400027D0841007D08000000000000000000000000FA00000003000D0014000300000001000000302E3030303030300E00050002040014000300323308000000405F2D08001400027D082D007D08000000000000000000000000FC00000002000D0014000300000001000000302E3030303030300E000500027D082D007D08000000000000000000000000FD00000002000D0014000300000001000000302E3030303030300E000500027D082D007D08000000000000000000000000FF00000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000000001000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000000101000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000000201000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000000301000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000000401000002000D0014000300000001000000302E3030303030300E000500027D0841007D080000000000000000000000000501000003000D0014000300000001000000302E3030303030300E00050002040014000300656606000000405F2D08001400027D0841007D080000000000000000000000000601000003000D0014000300000001000000302E3030303030300E00050002040014000300656606000000405F2D08001400027D0841007D080000000000000000000000000701000003000D0014000300000001000000302E3030303030300E00050002040014000300656606000000405F2D08001400027D082D007D080000000000000000000000000801000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000000901000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000000A01000002000D0014000300000001000000302E3030303030300E000500027D0841007D080000000000000000000000000B01000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C07000000405F2D08001400027D0841007D080000000000000000000000000C01000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C07000000405F2D08001400027D082D007D080000000000000000000000000F01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000001001000002000D00140002000000FF0000FF302E3030303030300E000500027D0828007D0800000000000000000000000011010000010004001400030001C002000000302E3030303030307D0841007D080000000000000000000000001201000003000D0014000300000001000000302E3030303030300E0005000204001400030001C002000000405F2D08001400027D0841007D080000000000000000000000001301000003000D0014000300000001000000302E3030303030300E0005000204001400030001C002000000405F2D08001400027D0828007D0800000000000000000000000014010000010004001400030001C002000000302E3030303030307D0828007D0800000000000000000000000015010000010004001400030001C002000000302E3030303030307D082D007D080000000000000000000000001601000002000D00140002000000FF0000FF302E3030303030300E000500027D0841007D080000000000000000000000001701000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C06000000405F2D08001400027D0841007D080000000000000000000000001801000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C06000000405F2D08001400027D0841007D080000000000000000000000001901000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C06000000405F2D08001400027D0841007D080000000000000000000000001A01000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C06000000405F2D08001400027D0841007D080000000000000000000000001B01000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000001C01000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000001D01000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000001E01000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000001F01000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000002001000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C06000000405F2D08001400027D0841007D080000000000000000000000002101000003000D0014000300000001000000302E3030303030300E00050002040014000300CC4C06000000405F2D08001400027D082D007D080000000000000000000000002201000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000002301000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000002401000002000D0014000300000001000000302E3030303030300E000500027D0841007D080000000000000000000000002501000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000002601000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D082D007D080000000000000000000000002701000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000002801000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000002901000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000002A01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000002B01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000002C01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000002D01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000002E01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000002F01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000003001000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000003101000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000003201000002000D0014000300000001000000302E3030303030300E000500027D0828007D08000000000000000000000000330100000100040014000300CC4C07000000302E3030303030307D0841007D080000000000000000000000003401000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000003501000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000003601000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000003701000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000003801000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000003901000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0828007D080000000000000000000000003A0100000100040014000200000092D050FF302E3030303030307D082D007D080000000000000000000000003B01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000003C01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000003D01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000003E01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000003F01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000004001000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000004101000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000004201000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000004301000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000004401000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000004501000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000004601000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000004701000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000004801000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000004901000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000004A01000002000D0014000300000001000000302E3030303030300E000500027D0841007D080000000000000000000000004B01000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000004C01000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000004D01000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000004E01000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000004F01000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D0841007D080000000000000000000000005001000003000D0014000300000001000000302E3030303030300E00050002040014000300CDEC00000000405F2D08001400027D082D007D080000000000000000000000005101000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005201000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005301000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005401000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005501000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005601000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005701000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005801000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005901000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005A01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005B01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005C01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005D01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005E01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000005F01000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000006001000002000D0014000300000001000000302E3030303030300E000500027D082D007D080000000000000000000000006101000002000D0014000300000001000000302E3030303030300E000500027D0841007D080000000000000000000000006201000003000D0014000300000001000000302E3030303030300E0005000204001400030034F302000000405F2D08001400027D0841007D080000000000000000000000006301000003000D0014000300000001000000302E3030303030300E0005000204001400030001E002000000405F2D08001400027D0841007D080000000000000000000000006401000003000D0014000300000001000000302E3030303030300E0005000204001400030001E002000000405F2D08001400027D0841007D080000000000000000000000006501000003000D0014000300000001000000302E3030303030300E0005000204001400030001E002000000405F2D08001400027D0874007D080000000000000000000000006801000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D080000000000000000000000006901000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D080000000000000000000000006A01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D080000000000000000000000006B01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D080000000000000000000000006C01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D080000000000000000000000006D01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D080000000000000000000000006E01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D080000000000000000000000006F01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D080000000000000000000000007001000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D080000000000000000000000007101000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D080000000000000000000000007201000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D0800000000000000000000000073010000010006006000010000000000000000000000000000000000E03F000000000000E03F000000000000E03F000000000000E03F0200000003000000000000000000000000000000000000000000030008000000000000000000F03FCD666633B399E93F7D0874007D0800000000000000000000000074010000010006006000010000000000000000000000000000000000E03F000000000000E03F000000000000E03F000000000000E03F0200000003000000000000000000000000000000000000000000030008000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000007F01000003000D001400030000000100000000000000000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030009000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000008001000003000D001400030000000100000000000000000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030009000000000000000000F03FCD666633B399E93F7D0874007D080000000000000000000000008101000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030009000000000000000000F03FCD666633B399E93F7D0874007D080000000000000000000000008201000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030009000000000000000000F03FCD666633B399E93F7D0874007D080000000000000000000000008301000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030009000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000008401000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030009000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000008501000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030009000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000008601000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030009000000000000000000F03FCD666633B399E93F7D0874007D080000000000000000000000008701000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030009000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000008801000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030005000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000008901000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030005000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000008A01000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030005000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000008B01000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030005000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000008C01000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030005000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000008D01000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030005000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000008E01000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030007000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000008F01000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030007000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000009001000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030007000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000009101000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000009201000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D080000000000000000000000009301000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000009401000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399D93F7D088D007D080000000000000000000000009501000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399D93F7D0874007D080000000000000000000000009601000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399D93F7D088D007D080000000000000000000000009701000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399D93F7D088D007D080000000000000000000000009801000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399D93F7D0874007D080000000000000000000000009901000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399D93F7D0874007D080000000000000000000000009A01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399D93F7D0874007D080000000000000000000000009B01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399D93F7D088D007D080000000000000000000000009C01000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030004000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000009D01000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030004000000000000000000F03FCD666633B399E93F7D0874007D080000000000000000000000009E01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030004000000000000000000F03FCD666633B399E93F7D0874007D080000000000000000000000009F01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030004000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000A001000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030004000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000A101000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030004000000000000000000F03FCD666633B399E93F7D088D007D08000000000000000000000000A201000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D088D007D08000000000000000000000000A301000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D088D007D08000000000000000000000000A401000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D088D007D08000000000000000000000000A501000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D088D007D08000000000000000000000000A601000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000A701000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D082D007D08000000000000000000000000A801000002000D001400030000000100000000805640000000000E000500027D0874007D08000000000000000000000000A901000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D08000000000000000000000000AA01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D08000000000000000000000000AB01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D08000000000000000000000000AC01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D08000000000000000000000000AD01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000AE01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000AF01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000B001000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000B101000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000B201000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000B301000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000B401000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000B501000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000B601000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000B701000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000B801000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000B901000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000BA01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000BB01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000C801000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000C901000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000CA01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000CB01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000CC01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000CD01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000CE01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000CF01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000D001000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000D101000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000D201000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000D301000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000D801000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030009000000000000000000F03FCD666633B399E93F7D0841007D08000000000000000000000000D901000003000D001400030000000100000000805640000000000E0005000204001400030000000000000000000000000000007D082D007D08000000000000000000000000DA01000002000D001400030000000100000000805640000000000E000500027D082D007D08000000000000000000000000DB01000002000D001400030000000100000000805640000000000E000500027D082D007D08000000000000000000000000DC01000002000D001400030000000100000000805640000000000E000500027D0828007D08000000000000000000000000DD0100000100040014000300CC4C0700000000805640000000007D0828007D08000000000000000000000000DE0100000100040014000300CC4C0700000000805640000000007D082D007D08000000000000000000000000DF01000002000D001400030000000100000000805640000000000E000500027D082D007D08000000000000000000000000E001000002000D001400030000000100000000805640000000000E000500027D082D007D08000000000000000000000000E101000002000D001400030000000100000000805640000000000E000500027D082D007D08000000000000000000000000E201000002000D001400030000000100000000805640000000000E000500027D082D007D08000000000000000000000000E301000002000D001400030000000100000000805640000000000E000500027D082D007D08000000000000000000000000E401000002000D001400030000000100000000805640000000000E000500027D082D007D08000000000000000000000000E501000002000D001400030000000100000000805640000000000E000500027D0841007D08000000000000000000000000E601000003000D001400030000000100000000805640000000000E00050002040014000300CDEC0000000000000000000000007D0841007D08000000000000000000000000E701000003000D001400030000000100000000805640000000000E00050002040014000300CC4C0600000000000000000000007D088D007D08000000000000000000000000E901000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000EB01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030009000000000000000000F03FCD666633B399E93F7D0841007D08000000000000000000000000EC01000003000D001400030000000100000000805640000000000E00050002040014000300CDEC0000000000000000000000007D0841007D08000000000000000000000000ED01000003000D001400030000000100000000805640000000000E00050002040014000300CDEC0000000000000000000000007D0841007D08000000000000000000000000EE01000003000D001400030000000100000000805640000000000E00050002040014000300CDEC0000000000000000000000007D0841007D08000000000000000000000000EF01000003000D001400030000000100000000805640000000000E00050002040014000300CDEC0000000000000000000000007D082D007D08000000000000000000000000F001000002000D001400030000000100000000805640000000000E000500027D082D007D08000000000000000000000000F101000002000D001400030000000100000000805640000000000E000500027D082D007D08000000000000000000000000F201000002000D001400030000000100000000805640000000000E000500027D0874007D08000000000000000000000000F501000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D08000000000000000000000000F601000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D08000000000000000000000000F7010000010006006000010000000000000000000000000000000000E03F000000000000E03F000000000000E03F000000000000E03F0200000003000000000000000000000000000000000000000000030008000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000F801000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D08000000000000000000000000F901000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D08000000000000000000000000FA01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D08000000000000000000000000FB01000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0828007D08000000000000000000000000FC01000001000D001400030000000100000000805640000000007D0828007D08000000000000000000000000FD01000001000D001400030000000100000000805640000000007D0841007D080000000000000000000000000002000003000D001400030000000100000000805640000000000E0005000204001400030034F30200000000000000000000007D088D007D080000000000000000000000000102000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D080000000000000000000000000402000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D080000000000000000000000000502000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D080000000000000000000000000602000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000000702000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000000802000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D088D007D080000000000000000000000000902000003000D001400030000000100000000805640000000000E000500020600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030006000000000000000000F03FCD666633B399E93F7D0874007D080000000000000000000000000B02000001000600600000000000000000000080564000000000000000000000000000000000000000000000000000000000000000000200000003000000000000000000000000000000000000000000030008000000000000000000F03F9ACC4C662633E33F7D0874007D080000000000000000000000000E020000010006006000010000000000000000000000000000000000E03F000000000000E03F000000000000E03F000000000000E03F0200000003000000000000000000000000000000000000000000030008000000000000000000F03FCD666633B399E93F7D0874007D080000000000000000000000000F020000010006006000010000000000000000000000000000000000E03F000000000000E03F000000000000E03F000000000000E03F0200000003000000000000000000000000000000000000000000030008000000000000000000F03FCD666633B399E93F9302130010000E0000323025202D20C96E66617369733192084F0092080000000000000000000001041EFF0E0032003000250020002D002000C9006E006600610073006900730031000000030001000C0007046566DCE6F1FF05000C0007010000000000FF25000500029302130011000E0000323025202D20C96E66617369733292084F00920800000000000000000000010422FF0E0032003000250020002D002000C9006E006600610073006900730032000000030001000C0007056566F2DCDBFF05000C0007010000000000FF25000500029302130012000E0000323025202D20C96E66617369733392084F00920800000000000000000000010426FF0E0032003000250020002D002000C9006E006600610073006900730033000000030001000C0007066566EBF1DEFF05000C0007010000000000FF25000500029302130013000E0000323025202D20C96E66617369733492084F0092080000000000000000000001042AFF0E0032003000250020002D002000C9006E006600610073006900730034000000030001000C0007076566E4DFECFF05000C0007010000000000FF25000500029302130014000E0000323025202D20C96E66617369733592084F0092080000000000000000000001042EFF0E0032003000250020002D002000C9006E006600610073006900730035000000030001000C0007086566DAEEF3FF05000C0007010000000000FF25000500029302130015000E0000323025202D20C96E66617369733692084F00920800000000000000000000010432FF0E0032003000250020002D002000C9006E006600610073006900730036000000030001000C0007096566FDE9D9FF05000C0007010000000000FF25000500029302130016000E0000343025202D20C96E66617369733192084F0092080000000000000000000001041FFF0E0034003000250020002D002000C9006E006600610073006900730031000000030001000C000704CC4CB8CCE4FF05000C0007010000000000FF25000500029302130017000E0000343025202D20C96E66617369733292084F00920800000000000000000000010423FF0E0034003000250020002D002000C9006E006600610073006900730032000000030001000C000705CC4CE6B8B7FF05000C0007010000000000FF25000500029302130018000E0000343025202D20C96E66617369733392084F00920800000000000000000000010427FF0E0034003000250020002D002000C9006E006600610073006900730033000000030001000C000706CC4CD8E4BCFF05000C0007010000000000FF25000500029302130019000E0000343025202D20C96E66617369733492084F0092080000000000000000000001042BFF0E0034003000250020002D002000C9006E006600610073006900730034000000030001000C000707CC4CCCC0DAFF05000C0007010000000000FF2500050002930213001A000E0000343025202D20C96E66617369733592084F0092080000000000000000000001042FFF0E0034003000250020002D002000C9006E006600610073006900730035000000030001000C000708CC4CB7DEE8FF05000C0007010000000000FF2500050002930213001B000E0000343025202D20C96E66617369733692084F00920800000000000000000000010433FF0E0034003000250020002D002000C9006E006600610073006900730036000000030001000C000709CC4CFCD5B4FF05000C0007010000000000FF2500050002930213001C000E0000363025202D20C96E66617369733192084F00920800000000000000000000010420FF0E0036003000250020002D002000C9006E006600610073006900730031000000030001000C000704323395B3D7FF05000C0007000000FFFFFFFF2500050002930213001D000E0000363025202D20C96E66617369733292084F00920800000000000000000000010424FF0E0036003000250020002D002000C9006E006600610073006900730032000000030001000C0007053233DA9694FF05000C0007000000FFFFFFFF2500050002930213001E000E0000363025202D20C96E66617369733392084F00920800000000000000000000010428FF0E0036003000250020002D002000C9006E006600610073006900730033000000030001000C0007063233C4D79BFF05000C0007000000FFFFFFFF2500050002930213001F000E0000363025202D20C96E66617369733492084F0092080000000000000000000001042CFF0E0036003000250020002D002000C9006E006600610073006900730034000000030001000C0007073233B1A0C7FF05000C0007000000FFFFFFFF25000500029302130020000E0000363025202D20C96E66617369733592084F00920800000000000000000000010430FF0E0036003000250020002D002000C9006E006600610073006900730035000000030001000C000708323392CDDCFF05000C0007000000FFFFFFFF25000500029302130021000E0000363025202D20C96E66617369733692084F00920800000000000000000000010434FF0E0036003000250020002D002000C9006E006600610073006900730036000000030001000C0007093233FABF8FFF05000C0007000000FFFFFFFF250005000293020A0022000500004275656E6192083D0092080000000000000000000001011AFF05004200750065006E0061000000030001000C0005FF0000C6EFCEFF05000C0005FF0000006100FF250005000293020C00230007000043E16C63756C6F92087900920800000000000000000000010216FF07004300E1006C00630075006C006F000000070001000C0005FF0000F2F2F2FF05000C0005FF0000FA7D00FF250005000206000E0005FF00007F7F7FFF010007000E0005FF00007F7F7FFF010008000E0005FF00007F7F7FFF010009000E0005FF00007F7F7FFF010093021A00240015000043656C646120646520636F6D70726F62616369F36E92089500920800000000000000000000010217FF1500430065006C0064006100200064006500200063006F006D00700072006F006200610063006900F3006E000000070001000C0005FF0000A5A5A5FF05000C0007000000FFFFFFFF250005000206000E0005FF00003F3F3FFF060007000E0005FF00003F3F3FFF060008000E0005FF00003F3F3FFF060009000E0005FF00003F3F3FFF06009302140025000F000043656C64612076696E63756C61646192085300920800000000000000000000010218FF0F00430065006C00640061002000760069006E00630075006C006100640061000000030005000C0005FF0000FA7D00FF250005000207000E0005FF0000FF8001FF06009302110026000C0000456E636162657A61646F203492083F00920800000000000000000000010313FF0C0045006E0063006100620065007A00610064006F00200034000000020005000C00070300001F497DFF250005000293020D002700080000C96E6661736973319208430092080000000000000000000001041DFF0800C9006E006600610073006900730031000000030001000C00070400004F81BDFF05000C0007000000FFFFFFFF250005000293020D002800080000C96E66617369733292084300920800000000000000000000010421FF0800C9006E006600610073006900730032000000030001000C0007050000C0504DFF05000C0007000000FFFFFFFF250005000293020D002900080000C96E66617369733392084300920800000000000000000000010425FF0800C9006E006600610073006900730033000000030001000C00070600009BBB59FF05000C0007000000FFFFFFFF250005000293020D002A00080000C96E66617369733492084300920800000000000000000000010429FF0800C9006E006600610073006900730034000000030001000C00070700008064A2FF05000C0007000000FFFFFFFF250005000293020D002B00080000C96E6661736973359208430092080000000000000000000001042DFF0800C9006E006600610073006900730035000000030001000C00070800004BACC6FF05000C0007000000FFFFFFFF250005000293020D002C00080000C96E66617369733692084300920800000000000000000000010431FF0800C9006E006600610073006900730036000000030001000C0007090000F79646FF05000C0007000000FFFFFFFF250005000293020C002D00070000456E747261646192087900920800000000000000000000010214FF070045006E00740072006100640061000000070001000C0005FF0000FFCC99FF05000C0005FF00003F3F76FF250005000206000E0005FF00007F7F7FFF010007000E0005FF00007F7F7FFF010008000E0005FF00007F7F7FFF010009000E0005FF00007F7F7FFF0100930204002E8008FF92083A00920800000000000000000000010208FF0C00480069007000650072007600ED006E00630075006C006F000000010005000C00070A00000000FFFF93020F002F000A0000496E636F72726563746F9208470092080000000000000000000001011BFF0A0049006E0063006F00720072006500630074006F000000030001000C0005FF0000FFC7CEFF05000C0005FF00009C0006FF250005000293020400308003FF92082600920800000000000000000000010503FF08004D0069006C006C0061007200650073000000000093020400318006FF92082E00920800000000000000000000010506FF0C004D0069006C006C00610072006500730020005B0030005D000000000093020F0032000A00004D696C6C61726573203293020F0033000A00004D696C6C61726573203393020400348004FF92082200920800000000000000000000010504FF06004D006F006E006500640061000000000093020400358007FF92082A00920800000000000000000000010507FF0A004D006F006E0065006400610020005B0030005D000000000093020D0036000800004D6F6E656461203293020C0037000700004E65757472616C9208410092080000000000000000000001011CFF07004E00650075007400720061006C000000030001000C0005FF0000FFEB9CFF05000C0005FF00009C6500FF250005000293020400008000FF92082200920800000000000000000000010100FF06004E006F0072006D0061006C000000000093020D0038000800004E6F726D616C203293020D0039000800004E6F726D616C2033920837009208000000000000000000000000FFFF08004E006F0072006D0061006C00200033000000020005000C0007010000000000FF250005000293020A003A000500004E6F7461739208640092080000000000000000000001020AFF05004E006F007400610073000000050001000C0005FF0000FFFFCCFF06000E0005FF0000B2B2B2FF010007000E0005FF0000B2B2B2FF010008000E0005FF0000B2B2B2FF010009000E0005FF0000B2B2B2FF0100930204003B8005FF92082A00920800000000000000000000010505FF0A0050006F007200630065006E00740061006A00650000000000930211003C000C0000506F7263656E7475616C203293020B003D0006000053616C69646192087700920800000000000000000000010215FF0600530061006C006900640061000000070001000C0005FF0000F2F2F2FF05000C0005FF00003F3F3FFF250005000206000E0005FF00003F3F3FFF010007000E0005FF00003F3F3FFF010008000E0005FF00003F3F3FFF010009000E0005FF00003F3F3FFF0100930219003E00140000546578746F20646520616476657274656E63696192084F0092080000000000000000000001020BFF140054006500780074006F00200064006500200061006400760065007200740065006E006300690061000000020005000C0005FF0000FF0000FF2500050002930216003F00110000546578746F206578706C6963617469766F92084900920800000000000000000000010235FF110054006500780074006F0020006500780070006C006900630061007400690076006F000000020005000C0005FF00007F7F7FFF250005000293020B00400006000054ED74756C6F9208330092080000000000000000000001030FFF06005400ED00740075006C006F000000020005000C00070300001F497DFF250005000193020D00410008000054ED74756C6F203192084500920800000000000000000000010310FF08005400ED00740075006C006F00200031000000030005000C00070300001F497DFF250005000207000E00070400004F81BDFF050093020D00420008000054ED74756C6F203292084500920800000000000000000000010311FF08005400ED00740075006C006F00200032000000030005000C00070300001F497DFF250005000207000E000704FF3FA7BFDEFF050093020D00430008000054ED74756C6F203392084500920800000000000000000000010312FF08005400ED00740075006C006F00200033000000030005000C00070300001F497DFF250005000207000E000704323395B3D7FF020093020A004400050000546F74616C92084D00920800000000000000000000010319FF050054006F00740061006C000000040005000C0007010000000000FF250005000206000E00070400004F81BDFF010007000E00070400004F81BDFF06008E0858008E080000000000000000000090000000110011005400610062006C0065005300740079006C0065004D0065006400690075006D0039005000690076006F0074005300740079006C0065004C006900670068007400310036009200E200380000000000FFFFFF00FF00000000FF00000000FF00FFFF0000FF00FF0000FFFF00800000000080000000008000808000008000800000808000C0C0C000808080008080FF0080206000FFFFC000A0E0E00060008000FF8080000080C000C0C0FF0000008000FF00FF00FFFF000000FFFF008000800080000000008080000000FF0000CCFF0069FFFF00CCFFCC00FFFF9900A6CAF000CC9CCC00CC99FF00E3E3E3003366FF0033CCCC003399330099993300996633009966660066669900969696003333CC00336666000033000033330000663300009933660033339900424242005C100E00030000000000FFFFFF000000000060010200000085001A007F0B0100000012004E5F43616D706F732047656E6572616C657385001C00233F0100000014004E5F43616D706F73204573706563696669636F738500100071AD010000000800457374616E6461728500130043F2010000000B00536F6C6F41637469766F259A0818009A0800000000000000000000010000000000000001000000A3081000A30800000000000000000000000000008C00040022003400AE0104000400010417000E00020000000000000000000100010018001A00000000040700000000000000000000617265613A0000130002001800290000000013070000000000000000000043616E7469646164436F6D6275737469626C653A01003F000400180034000000001E070000000000000000000043616E7469646164436F6D6275737469626C655F73696E446574616C6C653A0100150003001800280000000012070000000000000000000043616E74696461644C7562726963616E74653A01003E000400180033000000001D070000000000000000000043616E74696461644C7562726963616E74655F73696E446574616C6C653A01001700030018001F000000000907000000000000000000004361706163696461643A010054000300180025000000000F07000000000000000000004361706163696461644361727465723A01001A00030018001B00000000050700000000000000000000636172676F3A00001000020018002600000000100700000000000000000000436172676F46696A6F4465736561646F3A01004200030018002E00000000180700000000000000000000636172676F726573706F6E7361626C6564656C616F6272613A00002A00020018001C000000000607000000000000000000006369756461643A000007000200180023000000000D0700000000000000000000636975646164636C69656E74653A000018000200180024000000000E070000000000000000000063697564616464656C616F6272613A00002400020018001A00000000040700000000000000000000636D69633A00000C000200180022000000000C0700000000000000000000436F6469676F45717569706F3A01005000030018002900000000130700000000000000000000636F6469676F706F7374616C636C69656E74653A00001700020018002A00000000140700000000000000000000636F6469676F706F7374616C64656C616F6272613A00002600020018001D00000000070700000000000000000000636F6C6F6E69613A000006000200180024000000000E0700000000000000000000636F6C6F6E6961636C69656E74653A000016000200180025000000000F0700000000000000000000636F6C6F6E696164656C616F6272613A000023000200180021000000000B0700000000000000000000436F6D6275737469626C653A01001300030018002900000000130700000000000000000000436F6D6275737469626C655F466F726D756C613A010007000B0018002800000000120700000000000000000000436F6D6275737469626C65415F4D6F6E746F3A010007000E0018002800000000120700000000000000000000436F6D6275737469626C65455F4D6F6E746F3A010007000F0018002D00000000170700000000000000000000436F6D6275737469626C65455F506F7263656E74616A653A01000700080018002800000000120700000000000000000000436F6D6275737469626C65525F4D6F6E746F3A01000700100018002D00000000170700000000000000000000436F6D6275737469626C65525F506F7263656E74616A653A01000700090018002C00000000160700000000000000000000436F6D6275737469626C655375737469747563696F6E3A010007000D00180024000000000E0700000000000000000000436F6E73756D6F4465736561646F3A01004600030018001F00000000090700000000000000000000436F6E73756D6F47613A01001C00040018001F00000000090700000000000000000000436F6E73756D6F4C743A01001D00040018002700000000110700000000000000000000436F6E73756D6F73446574616C6C61646F3A01003D000300180025000000000F0700000000000000000000636F6E746163746F636C69656E74653A00001B000200180021000000000B0700000000000000000000436F73746F41637469766F3A010038000400180025000000000F0700000000000000000000436F73746F436172676F46696A6F413A010035000400180025000000000F0700000000000000000000436F73746F436172676F46696A6F453A010036000400180025000000000F0700000000000000000000436F73746F436172676F46696A6F523A01003700040018002600000000100700000000000000000000436F73746F436F6D6275737469626C653A010014000300180023000000000D0700000000000000000000436F73746F436F6E73756D6F413A01000E000E00180023000000000D0700000000000000000000436F73746F436F6E73756D6F453A01000E000F00180023000000000D0700000000000000000000436F73746F436F6E73756D6F523A01000E001000180021000000000B0700000000000000000000436F73746F4573706572613A010039000400180025000000000F0700000000000000000000436F73746F4C7562726963616E74653A010016000300180025000000000F0700000000000000000000436F73746F4F7065726163696F6E413A010010000E00180025000000000F0700000000000000000000436F73746F4F7065726163696F6E453A010010000F00180025000000000F0700000000000000000000436F73746F4F7065726163696F6E523A01001000100018002700000000110700000000000000000000436F73746F4F747261734675656E7465733A010020000300180021000000000B0700000000000000000000436F73746F507A734573703A010007000300180022000000000C0700000000000000000000436F73746F526573657276613A01003A00040018002700000000110700000000000000000000646563696D616C65737265646F6E64656F3A000033000200180030000000001A0700000000000000000000446563696D616C65735265646F6E64656F566F6C756D656E65733A01004D000300180022000000000C0700000000000000000000646570617274616D656E746F3A00001400020018002A00000000140700000000000000000000446570726563696163696F6E5F466F726D756C613A010003000B0018002E00000000180700000000000000000000446570726563696163696F6E5F5375737469747563696F6E3A010003000D0018002900000000130700000000000000000000446570726563696163696F6E415F4D6F6E746F3A010003000E0018002900000000130700000000000000000000446570726563696163696F6E455F4D6F6E746F3A010003000F0018002E00000000180700000000000000000000446570726563696163696F6E455F50726F63656E74616A653A01000300080018002900000000130700000000000000000000446570726563696163696F6E525F4D6F6E746F3A01000300100018002E00000000180700000000000000000000446570726563696163696F6E525F506F7263656E74616A653A010003000900180027000000001107000000000000000000004465736372697063696F6E45717569706F3A01005100030018002600000000100700000000000000000000646972656363696F6E636C69656E74653A00001500020018002900000000130700000000000000000000646972656363696F6E6465636F6E637572736F3A00001F00020018002700000000110700000000000000000000646972656363696F6E64656C616F6272613A00002200020018001F00000000090700000000000000000000646F6D6963696C696F3A00000500020018001B00000000050700000000000000000000656D61696C3A00000B000200180022000000000C0700000000000000000000656D61696C636C69656E74653A00001A000200180023000000000D0700000000000000000000656D61696C64656C616F6272613A00002800020018001C0000000006070000000000000000000065737461646F3A000008000200180024000000000E070000000000000000000065737461646F64656C616F6272613A000025000200180027000000001107000000000000000000004578706C6F746172496E73756D6F7343483A01004E00030018002700000000110700000000000000000000466163746F72436F6D6275737469626C653A01001800030018002600000000100700000000000000000000466163746F724C7562726963616E74653A01001900030018002900000000130700000000000000000000466163746F724D616E74656E696D69656E746F3A010027000300180025000000000F0700000000000000000000466163746F724F7065726163696F6E3A01000B00030018002800000000120700000000000000000000466163746F724F747261734675656E7465733A01001F00030018002700000000110700000000000000000000466163746F7252656E64696D69656E746F3A01000F000300180027000000001107000000000000000000006665636861636F6E766F6361746F7269613A00003A000200180025000000000F070000000000000000000066656368616465636F6E637572736F3A00001D000200180021000000000B07000000000000000000006665636861696E6963696F3A00002B0002001800260000000010070000000000000000000066656368617465726D696E6163696F6E3A00002C00020018002900000000130700000000000000000000486F7261734566656374697661735475726E6F3A01001000040018002E00000000180700000000000000000000486F7261734566656374697661735475726E6F546578746F3A01001100040018001F00000000090700000000000000000000486F7261735841F16F3A01002200030018002600000000100700000000000000000000496D7072696D6972436F6D706C6574613A01005500030018001A00000000040700000000000000000000696D73733A00000E000200180032000000001C0700000000000000000000496E64696361646F7245636F6E6F6D69636F5265666572656E6369613A010028000200180030000000001A0700000000000000000000496E64696361646F724573706563696669636F4D65726361646F3A01002900020018001F00000000090700000000000000000000696E666F6E617669743A00000D000200180025000000000F0700000000000000000000496E6963696F4F7065726163696F6E3A01000200120018002900000000130700000000000000000000496E6963696F4F74726F73436F6E73756D6F733A010002001B0018002700000000110700000000000000000000496E76657273696F6E5F466F726D756C613A010004000B0018002B00000000150700000000000000000000496E76657273696F6E5F5375737469747563696F6E3A010004000D0018002600000000100700000000000000000000496E76657273696F6E415F4D6F6E746F3A010004000E0018002600000000100700000000000000000000496E76657273696F6E455F4D6F6E746F3A010004000F0018002B00000000150700000000000000000000496E76657273696F6E455F506F7263656E74616A653A01000400080018002600000000100700000000000000000000496E76657273696F6E525F4D6F6E746F3A01000400100018002B00000000150700000000000000000000496E76657273696F6E525F506F7263656E74616A653A010004000900180025000000000F07000000000000000000004C6C616E7461735F466F726D756C613A010009000B00180029000000001307000000000000000000004C6C616E7461735F5375737469747563696F6E3A010009000D00180024000000000E07000000000000000000004C6C616E746173415F4D6F6E746F3A010009000E00180024000000000E07000000000000000000004C6C616E746173455F4D6F6E746F3A010009000F00180029000000001307000000000000000000004C6C616E746173455F506F7263656E74616A653A010009000800180024000000000E07000000000000000000004C6C616E746173525F4D6F6E746F3A010009001000180029000000001307000000000000000000004C6C616E746173525F506F7263656E74616A653A010009000900180028000000001207000000000000000000004C7562726963616E74655F466F726D756C613A010008000B0018002C000000001607000000000000000000004C7562726963616E74655F5375737469747563696F6E3A010008000D00180027000000001107000000000000000000004C7562726963616E7465415F4D6F6E746F3A010008000E00180027000000001107000000000000000000004C7562726963616E7465455F4D6F6E746F3A010008000F0018002C000000001607000000000000000000004C7562726963616E7465455F506F7263656E74616A653A010008000800180027000000001107000000000000000000004C7562726963616E7465525F4D6F6E746F3A01000800100018002C000000001607000000000000000000004C7562726963616E7465525F506F7263656E74616A653A010008000900180023000000000D07000000000000000000004D616E74656E696D69656E746F3A01002D00040018002A000000001407000000000000000000004D616E74656E696D69656E746F415F4D6F6E746F3A010006000E0018002A000000001407000000000000000000004D616E74656E696D69656E746F455F4D6F6E746F3A010006000F0018002F000000001907000000000000000000004D616E74656E696D69656E746F455F506F7263656E74616A653A01000600080018002A000000001407000000000000000000004D616E74656E696D69656E746F525F4D6F6E746F3A01000600100018002F000000001907000000000000000000004D616E74656E696D69656E746F525F506F7263656E74616A653A01000600090018002B000000001507000000000000000000004D616E74656E696D696E65746F5F466F726D756C613A010006000B0018001C000000000607000000000000000000004D6F64656C6F3A010052000300180023000000000D07000000000000000000006E6F6D627265636C69656E74653A000012000200180024000000000E07000000000000000000006E6F6D62726564656C616F6272613A000021000200180031000000001B07000000000000000000004E7565766F436F6566696369656E7465436F6D6275737469626C653A01004700030018002A000000001407000000000000000000004E7565766F4661746F724C7562726963616E74653A01004B00030018002B000000001507000000000000000000004E7565766F56616C6F724164717569736963696F6E3A010043000300180025000000000F07000000000000000000006E756D636F6E766F6361746F7269613A000039000200180026000000001007000000000000000000006E756D65726F6465636F6E637572736F3A00001E000200180023000000000D07000000000000000000004E756D65726F446553657269653A010053000300180027000000001107000000000000000000004F7065726163696F6E5F466F726D756C613A010010000B0018002A000000001407000000000000000000004F7065726163696F6E436F6D6275737469626C653A010007000C0018002B000000001507000000000000000000004F7065726163696F6E455F506F7263656E74616A653A01000B000800180026000000001007000000000000000000004F7065726163696F6E4C6C616E7461733A010009000C00180029000000001307000000000000000000004F7065726163696F6E4C7562726963616E74653A010008000C0018002B000000001507000000000000000000004F7065726163696F6E4F747261734675656E7465733A01000B000C0018002F000000001907000000000000000000004F7065726163696F6E5069657A6173457370656369616C65733A01000A000C0018002B000000001507000000000000000000004F7065726163696F6E525F506F7263656E74616A653A01000B00090018002D000000001707000000000000000000004F7472614675656E746573455F506F7263656E74616A653A01000C00080018002D000000001707000000000000000000004F7472614675656E746573525F506F7263656E74616A653A01000C00090018002A000000001407000000000000000000004F747261734675656E7465735F466F726D756C613A01000B000B0018002E000000001807000000000000000000004F747261734675656E7465735F5375737469747563696F6E3A01000B000D00180029000000001307000000000000000000004F747261734675656E746573415F4D6F6E746F3A01000B000E0018002B000000001507000000000000000000004F747261734675656E7465734465456E65726769613A01001E000300180029000000001307000000000000000000004F747261734675656E746573455F4D6F6E746F3A01000B000F00180029000000001307000000000000000000004F747261734675656E746573525F4D6F6E746F3A01000B001000180024000000000E07000000000000000000005069657A61735F466F726D756C613A01000A000B00180026000000001007000000000000000000005069657A61735F537573747563696F6E3A01000A000D00180023000000000D07000000000000000000005069657A6173415F4D6F6E746F3A01000A000E00180023000000000D07000000000000000000005069657A6173455F4D6F6E746F3A01000A000F00180028000000001207000000000000000000005069657A6173455F506F7263656E74616A653A01000A000800180023000000000D07000000000000000000005069657A6173525F4D6F6E746F3A01000A001000180028000000001207000000000000000000005069657A6173525F506F7263656E74616A653A01000A000900180024000000000E0700000000000000000000706C617A6F63616C63756C61646F3A00003100020018001F00000000090700000000000000000000706C617A6F7265616C3A00003200020018002E00000000180700000000000000000000706F7263656E74616A65697661707265737570756573746F3A00002F000200180025000000000F0700000000000000000000506F74656E6369614E6F6D696E616C3A01000A00030018002700000000110700000000000000000000506F74656E6369614F706572616369F36E3A01000C0004001800270000000011070000000000000000000050726563696F4164717569736963696F6E3A01000300030018002B0000000015070000000000000000000050726563696F45717569706F41646963696F6E616C3A010005000300180023000000000D070000000000000000000050726563696F4C6C616E7461733A010004000300180022000000000C07000000000000000000005072696D6153656775726F733A010026000300180023000000000D07000000000000000000007072696D6572616D6F6E6564613A000034000200180021000000000B070000000000000000000072617A6F6E736F6369616C3A0000040002001800290000000013070000000000000000000072656D6174657072696D6572616D6F6E6564613A0000360002001800290000000013070000000000000000000072656D617465736567756E64616D6F6E6564613A000037000200180021000000000B0700000000000000000000726573706F6E7361626C653A00000F00020018002900000000130700000000000000000000726573706F6E7361626C6564656C616F6272613A000029000200180019000000000307000000000000000000007266633A00000900020018002A0000000014070000000000000000000053616C6172696F5265616C4F7065726163696F6E3A010008001700180023000000000D0700000000000000000000736567756E64616D6F6E6564613A000035000200180025000000000F070000000000000000000053656775726F735F466F726D756C613A010005000B001800290000000013070000000000000000000053656775726F735F5375737469747563696F6E3A010005000D00180024000000000E070000000000000000000053656775726F73415F4D6F6E746F3A010005000E00180024000000000E070000000000000000000053656775726F73455F4D6F6E746F3A010005000F001800290000000013070000000000000000000053656775726F73455F506F7263656E74616A653A010005000800180024000000000E070000000000000000000053656775726F73525F4D6F6E746F3A0100050010001800290000000013070000000000000000000053656775726F73525F506F7263656E74616A653A010005000900180021000000000B070000000000000000000054617361496E74657265733A01002500030018001E0000000008070000000000000000000074656C65666F6E6F3A00000A000200180025000000000F070000000000000000000074656C65666F6E6F636C69656E74653A0000190002001800260000000010070000000000000000000074656C65666F6E6F64656C616F6272613A000027000200180025000000000F07000000000000000000005469656D706F43616D62696F4C75623A01001B000300180026000000001007000000000000000000007469706F64656C696369746163696F6E3A00003B00020018002C00000000160700000000000000000000546F74616C4C7562726963616E74654465736561646F3A01004A00030018002800000000120700000000000000000000546F74616C4F74726F73436F6E73756D6F733A010008002200180033000000001D0700000000000000000000746F74616C707265737570756573746F7072696D6572616D6F6E6564613A00002D000200180033000000001D0700000000000000000000746F74616C707265737570756573746F736567756E64616D6F6E6564613A00002E000200180025000000000F070000000000000000000056616C6F724D617175696E617269613A010009000400180022000000000C070000000000000000000056616C6F72526573636174653A0100240003001800270000000011070000000000000000000056616C6F72526573636174654D6F6E746F3A010024000400180021000000000B07000000000000000000005669646145636F41F16F733A010021000400180022000000000C07000000000000000000005669646145636F45514872733A010023000300180027000000001107000000000000000000005669646145636F4C6C616E7461734872733A010006000300180026000000001007000000000000000000005669646145636F5069657A61734872733A010008000300C1010800C1010000D5380200EB00EE120F0000F0E6120000000006F03000000001140000050000000A00000004000000020000000500000001000000010000000300000012000000040000000D0000001F0001F068120000520007F060120000050595B4EEA0F3A255ED466DD73EC064323CFF003C12000002000000000000000000E307A0461DF03412000095B4EEA0F3A255ED466DD73EC064323CFFFFD8FFE000104A46494600010101006000600000FFE1001645786966000049492A0008000000000000000000FFDB004300080606070605080707070909080A0C140D0C0B0B0C1912130F141D1A1F1E1D1A1C1C20242E2720222C231C1C2837292C30313434341F27393D38323C2E333432FFDB0043010909090C0B0C180D0D1832211C213232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232FFC000110800E0010603012200021101031101FFC4001F0000010501010101010100000000000000000102030405060708090A0BFFC400B5100002010303020403050504040000017D01020300041105122131410613516107227114328191A1082342B1C11552D1F02433627282090A161718191A25262728292A3435363738393A434445464748494A535455565758595A636465666768696A737475767778797A838485868788898A92939495969798999AA2A3A4A5A6A7A8A9AAB2B3B4B5B6B7B8B9BAC2C3C4C5C6C7C8C9CAD2D3D4D5D6D7D8D9DAE1E2E3E4E5E6E7E8E9EAF1F2F3F4F5F6F7F8F9FAFFC4001F0100030101010101010101010000000000000102030405060708090A0BFFC400B51100020102040403040705040400010277000102031104052131061241510761711322328108144291A1B1C109233352F0156272D10A162434E125F11718191A262728292A35363738393A434445464748494A535455565758595A636465666768696A737475767778797A82838485868788898A92939495969798999AA2A3A4A5A6A7A8A9AAB2B3B4B5B6B7B8B9BAC2C3C4C5C6C7C8C9CAD2D3D4D5D6D7D8D9DAE2E3E4E5E6E7E8E9EAF2F3F4F5F6F7F8F9FAFFDA000C03010002110311003F00F7FA28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800C8F5A323D6B07C5BABCFA07872EF52B648E4962298593257970A7A11EA6BCD7FE16E6B607FC79E9F8FF0071FF00F8AA89D48C373B70D97D7C4C79A9AD3D4F67C8F514B91EB5CBF83BC551F89F4D691D562BD84E26897A0F461EC6B6B53B96B2D2AEEE91433C10BC8A0F4240269A926AE8E7A94674EA7B292B32EE47A8A5C8F5AF31F0BFC45D4B5DF115A6993DA5AC714DB83326EDC308C7D7D8569F8F3C617FE179ECA3B38ADA413AB96F355891823A608F5A9F691E5E63A2580AF1ACA835EF33BBA2BC63FE16E6B9FF003E7A7FFDF0FF00FC5D1FF0B775CFF9F3D3FF00EF87FF00E2EA3EB10EE747F62E33F97F13D9B23D45191EB5E75E0AF1E6A3E25D75ECAEEDED638D60693742AC0E4301DC9F5ADAF15F8C6D3C2C91C6D135C5E4C3290AB01C762C7B0E0F6ED5A2A9171E6E8724F055E1595071F78EB28CD78E7FC2DED4F191A75A63FDE6FF001A5FF85BDAA1E9A75A1FC5BFC6A3EB14FB9D7FD8B8CFE53D8723D452E41EF5E4B61F172537206A3A6A084E32D031DCBEF83D7F31F8D7A626A11CDA57DBEDD84B1984CA8474618C8AB84D4FE138F1383AD86FE2AB17B345794FFC2DE9F1FF002068FF00F020FF00F134BFF0B7A7FF00A0347FF8107FF89AEDFA9D6DEC707B781EAB9A322BCA47C5E9B233A2A119ED707FF89AEA3C33E39B1F124A6D9627B7BB0BBBCA760437A853DFF1C7E9533C2D584799AD0A8D58BD11D76452647AD20E05727E37F1737862D6DD6DA38A6BC9DC911C992020EA7823B9007E3E958C22E72E58EE5CA4A2AECEBB23D68CD78D8F8AFACFFCF9E9E46704EC7E7A7FB5E95EADA56A306ABA5DBDF407F753206193C8F507DC1E0FD2B4AB42A525EFA2215233D117B23D68C8F5AE5FC6FE21BAF0D68D0DE5A450C923DC088ACC09182AC7B11FDD15C1FF00C2D9D6FF00E7CAC3FEF87FFE2E9D3C354A8AF1429558C5D99EC94578DFFC2D9D6FFE7CEC3FEF87FF00E2E8FF0085B3ADFF00CF9D87FDF0FF00FC5D6BF51ADD85EDE07B252640EE2A969178F7FA2D8DE4A1564B8B78E5655E80B28271F9D62F8CFC503C33A62CB0A249792BEC8A37E87A162791D063F122B963094A5CAB73472495D9D4645191EB5E363E2CEB40F367A7FD36BF4FFBEABD3BC3FACC7AEE8B6D7F1E019146F51FC2E3EF0FF3DAB4AB87A94B59A26356327646B51483A52D626814514500723F127FE445D47EB1FF00E8C5AF2BF0878753C48FA8DAE76DC25B7990393801C30C03EC73FAE7A8AF54F893FF00222EA1F58FFF004625711F088FFC4FEF71FF003EDFFB30AE5AA94AAA4CFA2CBEA4A965D5271DD3FF002394D3350BEF0A78804AA8527B7731CB11E038CE0A9F638FD01ED5EDD73AA5BEB3E0ABCBFB47DD1CB672119EAA769C83EE2B9AF88DE0F3A8DBB6B161166EE119991460CAA3BFD475F71C7502BCFF00C39E279746B5BFB0918BD95EC0E857B23952038FC783EC47A0153774A4E2F666F529C733A51AF4FE38DAE4FF000F307C75A663A664FF00D16F5E9DE32D73C3FA44D6ABACE95F6E79158C67C94936818CFDE231D45798FC3CC9F1DE9BEB993AFF00D737AF52F17CDE15865B5FF848D10C855BC92C8EDC719FBA3E95547F87EE99667CBF5F4A49BD3A6E72DFF09AF813FE8561FF0080507FF1547FC26BE04FFA15BFF24A0FFE2AA5179F0BFF00E79C7FF7E66FF0A5FB67C2EFF9E71FFDF99BFC28BBFE644F2D1FF9F753EF37FC1FABF87B59B8BA9347D1D6CA481555DCDBA2121B3C02A49FE1FE55E6BF11E4924F1BDF2BB92152355FF646C078FC49FCEBD2BC297FE106BC9ADBC3BB16774DF22AC722E554E33961FED7EB5E6DF1220963F1BDE3BA102648E443EA3685FE6B4AB7F0FC8BCAECB30764D69A5F73D0BC23E0DD157C3765713D85BDCCF730ACD23CC81BEF0DD819CF0338ADF3E15F0FF7D16C3FF01D7FC2B90F0BFC44D12DFC3D67697F335B4F6D12C38F2D9810A3008201EC2B6BFE164F85BFE822DFF7E24FFE26B58B8596C79B88A78EF6AEEA5BF99E6BF10F43B3D0FC42AB61108A29621379638087241C0F4E0715E85E09C9F865175C88AE00C9FF0069ABCDBC75E22B6F126BC97168ADF67863112B38C6FE49271E9C8EBE95E97E0B478FE194224565630CCDF30C1C16720FE2083F8D45069D67CA7A19A73ACBA92ABF17E3D4F2DF0958DB6A7E29B1B3BB8BCC825660CA495CE149ED8F4AF5E1F0FBC2E3FE614BFF007FA4FF00E2ABC83C237F6DA678A2C6F2EE5F2ADE2625DB693D55BB0AF5E1F113C2D81FF133FF00C9797FF89AF731AEAF3AE4BD8F90A1C96D4CBF127807C3F0E817F736D68D6D34103CAAE92B1E5549C10C48FD2B83F87848F1D69A7A67CDC81FF5CDBFC2BB8F12FC41D066D02F6D6C6E24BA9AE21785556365C1652324B01D2B89F87685BC75A795048512124761E5B0CFE7C5551553EAF375027CBED23CA7B94B34704524B2BAA471A9666638000E4927E95E03AEEA575E2CF143C90A3B99A4105B479C10B9F940F43CE4FB935E83F13FC41F61D2D74881B13DD8CCA41E5621FE278FA0359BF0B7C3BBA5935DBA4E1731DB023BFF00137F41F56ACB0C951A6EB4BE45557CF3505B1078CFC110E93E18B1BAB450D25A288AE9D7832063F7BFEFA38FA1F6A93E15EBFB249B449DC6D7CCB6FE9BB1F32FE433F81AF4FBAB58EF2CE6B69D03C52A94753DC11822BE7FD4AD2F3C29E2778D1CACD6B2EF8643FC4BC153F439E7F2ABA13788A6E94B7E81523ECE4A6B63DF6F74FB3D422115EDB43711AB6F0B2A0600F4CF3F8D64DF785F414B0B875D1EC55844C4308141040EC71C56868DAA43ACE916DA842309326EDBDD4F423F0391F854FA87FC83AE7D3C97FE55E7C65284B96F6D4DDA8C95D9E03E158E29BC53A6C33C31CB0C932AB46E32A41E3A1073DABDC3FE116D03FE80BA77E16C9FE15E21E11FF91BF4AFFAF94FE75F438AEEC7C9C66ACFA1861E29A772148E3B681628A358E28D42AA28C2AA81C607A5783F8BB5B93C49E2676B70D2408DE4DB228FBC33D87AB1E7F103B57A47C48F10FF0064E846CE17C5D5EE5171D93F88FB67EEFE27D2B94F863E1DFB66A2DAC5C2E60B5256107F8A423AFE03F523D296162A941D79FC82ABE692822D7887C06BA7781ADE581375F59832DC95FE30DF7BFEF9E31EC0FAD54F861AEFD8F5493499A4FDCDDFCD193D04807F503F30B5EBD2224B1323AEE5618607A115F3FF00893489BC31E269218999446E26B6947076E72A47B8E47D726AF0F53EB109529EFD05523ECDA923E83047B5312E6096468E39A3775FBCAAC091F515CAD9EB49E23D0F489049B52F27F26E950E39547664EBC02507D54FBD62F87DE4D461D9773241E558FDA2391A28A368496C2BC5B00F90053B83753C11824570FB26AF7E86FED1743D268AAD633BDCE9F6D712279724B12BB27F749009145646853D7B46875FD1E7D367778E398AE5A3EBC306FE9591E18F045A7862F66BAB7B99E57963F2D848460739F4F6AEB28A4E29BB9B46BD48D37493F75F4232B94C11C7A63AD709A87C2BD26F7509AE63B8B9804ADBFCA8F6ED04F5EA2BBFA294A0A5B851C455A0EF4E56387D0FE1BD8687ABDBEA30DE5D3C9006DA8DB769CA91E9EF57FC4FE0BB4F144D6F24F713C260560A22C60E71D723DABA9A28E48DAD63478DC43A8AAB97BCBA9E73FF000A874AFF00A08DEFFE3BFE147FC2A1D2BFE8237BFF008EFF00857A35151EC61D8DBFB5719FF3F19C7F873C0565E1BD4DAFADEEAE25768CC58931800907D3DAAFF88BC25A7789ADD23BD575923CF973C780E9F43835D0D156A114AD639A58AAD2AAAB397BDDCF393F0834AEBFDA37A3DBE5FF000A3FE150E97FF411BDFF00C77FC2BD1A8A8F630EC747F6A633FE7E33CF6DBE1369105CA4B2DCDE4E8AC1B633801B1EA40E9EDC57706D23FB09B4441145E598C0418DA318E2AD515718A8EC73D7C4D5AEEF56573CEFFE152697FF00410BDFFC77FC28FF008549A5FF00D042F7FF001DFF000AF44A2BABEB55BF98E3F630EC79DFFC2A4D289FF8FF00BD3FF7C7FF00135D1787FC21A6786C3B59C723CD270F3C872D8F41D80FC3FA57454544EBD49AB49E838D2845DD2389D67E1DDAEB9AB4DA85D6A17625908C05DA02E380071D00AEAEC6C60D3AC20B3B64290C2811477C0FEB56E8A99D49CD28B7A229452771A738AE6BC49E0BB0F135C433DCC93432C4A543C4402C3A8CE41E8738FA9AE9E8A519383BC771B4A4ACCC1F0DF86E2F0CDACB6B6D733CB048FBC2CBB7E538C1C10075C0FCBDEB6268BCFB79226240752A48EBC8A9A8A4E4DBE67B82492B1C369BF0D34FD3753B7BE8EF6ED9A070E11B6E091F8576E060018A751553A93A8EF3771462A3B1C77883C056DE21D59EFAEAFEED18A84454DBB500EC38F5C9FC6BA0D234BB7D174D86C2D5088A15C0CF56F527DC9E6B468A1D49B8A8B7A028A4EE276AE7FC4DE11B2F14241F6A796292027649163383DB907D01AE868A98C9C5DE3B8DA4D599CBE89E0BB4D12D6E6D52E2E6682765729230F9197A32900107EEF3DB68C62AE8D04BED5BABEBABA85463C99122556E41C1D88B91C0E33838E41ADBA2A9D493776C4A290D00E28A7515050514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451400514514005145140051451401FFFD953000BF01E000000BF0008000800810141000008864100000000C00140000008C5410000000040001EF1100000000D0000080C00000817000008F7000010FC00441EB9010000530100002E00004441544F532047454E4552414C4553205041524120494D5052455349D34E204445204C4F53205245504F525445530B00004445534352495043494F4E1300004441544F53204445204C4120454D50524553411500004E6F6D627265206465206C6120656D70726573612E180000446F6D6963696C696F206465206C6120656D70726573612E150000436F6C6F6E6961206465206C6120656D707265736124000043697564616420646F6E6465207365206C6F63616C697A61206C6120656D70726573612E120000524643206465206C6120656D70726573612E1A000054656C65666F6E6F287329206465206C6120656D70726573612E200000436F7272656F20656C65637472F36E69636F206465206C6120656D70726573611C0000526567697374726F20434D4943206465206C6120656D70726573612E210000526567697374726F20494E464F4E41564954206465206C6120656D70726573612E1C0000526567697374726F20494D5353206465206C6120656D70726573612E3300004E6F6D6272652064656C20726573706F6E7361626C65206465206C6120656D7072657361202870617261206669726D6173292E240000436172676F2064656C20726573706F6E7361626C65202870617261206669726D6173292E1200004441544F532044454C20434F4E435552534F13000046656368612064656C20636F6E637572736F2E1400004EFA6D65726F2064656C20636F6E637572736F2E1000004441544F53204445204C41204F4252411200004E6F6D627265206465206C61206F6272612E15000044697265636369F36E206465206C61206F6272612E21000043697564616420646F6E6465207365206C6F63616C697A61206C61206F6272612E1000004441544F5320454E434142455A41444F1800004441544F53204445204C4120434F4E564F4341544F5249412700004E756D65726F206465206C6120636F6E766F6361746F7269612064656C20636F6E637572736F2E1900004665636861206465206C6120636F6E766F6361746F7269612E1200005469706F206465206C696369746163696F6E0F00004E4F4D4252452044452043454C444105000056414C4F520B000072617A6F6E736F6369616C1500004E656F646174612C20532E412E20646520432E562E090000646F6D6963696C696F11000041737472F36E6F6D6F73204E6F2E203232070000636F6C6F6E6961080000457363616E64F36E0600006369756461640600004DE97869636F06000065737461646F3B0000456E74696461642066656465726174697661206F2070726F76696E63696120646F6E6465207365206C6F63616C697A61206C6120656D7072657361100000446973747269746F204665646572616C0300007266630C00004E454F39333035313945464108000074656C65666F6E6F0A0000353237382D33382D3530050000656D61696C160000736F706F727465406E656F646174612E636F6D2E6D78040000636D6963090000696E666F6E61766974040000696D73730B0000726573706F6E7361626C65050000636172676F1100004441544F532044454C20434C49454E54450D00006E6F6D627265636C69656E74651300004E6F6D6272652064656C20636C69656E74652E8B000053697374656D6120646520436F6D756E69636163696F6E65732079205472616E73706F727465732C2053697374656D61206465205472616E73706F72746520436F6C65637469766F204D6574726F2C2041646D696E69737472616369F36E2047656E6572616C206465205265637572736F732C204CED6E656120313220284CED6E656120446F7261646129040000617265611D0000417265612064656C20636C69656E74652071756520636F6E766F63612E29000053756264697265636369F36E20646520706C616E65616369F36E207920707265737570756573746F730C0000646570617274616D656E746F240000446570617274616D656E746F2064656C20636C69656E746520717565206C69636974612E1800004C696369746163696F6E6573207920636F6E637572736F730F000066656368616465636F6E637572736F1000006E756D65726F6465636F6E637572736F0E0000323030392F303235372D3030303123000055626963616369F36E2064656C20636F6E637572736F202864697265636369F36E292E2C000042616A612043616C69666F726E69612032352C20456469666963696F20422C20446573706163686F203230310E00006E6F6D62726564656C616F6272612700005472616D6F2064652042617272616E63612064656C204D756572746F206120546C61687561632E0E000063697564616464656C616F6272610E000065737461646F64656C616F6272612D000045737461646F206F2070726F76696E63696120646F6E6465207365206C6F63616C697A61206C61206F6272612E0B00006665636861696E6963696F10000066656368617465726D696E6163696F6E240000446563696D616C65732070617261207265646F6E64656F20646520696D706F727465732E0500005045534F5307000044D34C415245530400004D2E4E2E0300005553440F00006E756D636F6E766F6361746F7269611100006665636861636F6E766F6361746F7269611000007469706F64656C696369746163696F6E07000050FA626C6963611000004449524543544F522047454E4552414C1700004A4F524745204C2E2044C156414C4F53204D4943454C49F401003132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930370000466563686120646520696E6963696F206465206C61206F6272612028636F6E203120656E2070726F6772616D61206465206F627261292E3C00004665636861206465207465726D696E616369F36E206465206C61206F6272612028636F6E203120656E2070726F6772616D61206465206F627261292E380000446573637269706369F36E206465206C61206D6F6E656461203120656E20717565207365206D75657374726120656C207265706F7274652E15000052656D617465206465206C61206D6F6E6564612031380000446573637269706369F36E206465206C61206D6F6E656461203220656E20717565207365206D75657374726120656C207265706F7274652E15000052656D617465206465206C61206D6F6E6564612032100000646972656363696F6E636C69656E7465130000636F6469676F706F7374616C636C69656E74650E0000636F6C6F6E6961636C69656E74650D0000636975646164636C69656E74650F000074656C65666F6E6F636C69656E74650C0000656D61696C636C69656E7465110000646972656363696F6E64656C616F6272610F0000636F6C6F6E696164656C616F627261140000636F6469676F706F7374616C64656C616F62726110000074656C65666F6E6F64656C616F6272610D0000656D61696C64656C616F627261130000726573706F6E7361626C6564656C616F627261130000436F6C6F6E6961206465206C61206F6272612E19000043F36469676F20706F7374616C206465206C61206F6272612E140000436F6C6F6E69612064656C20636C69656E74652E1A000043F36469676F20706F7374616C2064656C20636C69656E74652E1300004369756461642064656C20636C69656E74652E15000054656CE9666F6E6F2064656C20636C69656E74652E130000652D4D61696C2064656C20636C69656E74652E2300004E6F6D6272652064656C20636F6E746163746F20636F6E20656C20636C69656E74652E16000044697265636369F36E2064656C20636C69656E74652E0F0000636F6E746163746F636C69656E746514000054656CE9666F6E6F206465206C61206F6272612E120000652D4D61696C206465206C61206F6272612E170000526573706F6E7361626C65206465206C61206F6272612E110000646563696D616C65737265646F6E64656F0D00007072696D6572616D6F6E6564610D0000736567756E64616D6F6E65646113000072656D617465736567756E64616D6F6E656461130000646972656363696F6E6465636F6E637572736F13000072656D6174657072696D6572616D6F6E6564610E0000706C617A6F63616C63756C61646F260000447572616369F36E206465206C61206F62726120656E2064696173206E61747572616C65732E240000447572616369F36E206465206C61206F62726120656E206469617320686162696C65732E090000706C617A6F7265616C180000636172676F726573706F6E7361626C6564656C616F627261210000436172676F2064656C20726573706F6E7361626C65206465206C61206F6272612E1D0000436172676F20726573706F6E7361626C65206465206C61206F6272612E1D0000746F74616C707265737570756573746F7072696D6572616D6F6E656461250000546F74616C2064656C20707265737570756573746F207072696D657261206D6F6E6564612E1B0000506F7263656E74616A652069766120707265737570756573746F2E180000706F7263656E74616A65697661707265737570756573746F1D0000746F74616C707265737570756573746F736567756E64616D6F6E656461250000546F74616C2064656C20707265737570756573746F20736567756E6461206D6F6E6564612E1F0000434F53544F204449524543544F20484F5241202D204D415155494E4152494103000053723D070000494D504F5254450C000053414C4152494F205245414C060000554E4944414408000043414E544944414409000043415445474F5249410F00004949492E2D204F504552414349D34E10000053756D6120646520436F6E73756D6F7305000053756D613A070000496D706F7274650900004F706572616369F36E08000043616E7469646164050000436F73746F060000556E696461640B00004465736372697063696F6E12000066292E2D4F74726F7320436F6E73756D6F730D000049492E2D20434F4E53554D4F5311000053756D6120436172676F732046696A6F7307000052455345525641010000250600004553504552410600004143544956410B00004F5045524143494F4E4553100000492E2D20434152474F532046494A4F53290000434F4E53554D4F5320454E5452452043414D42494F204445204C5542202847613D2043432F4361293A0300006872730300004C74730200004850110000504F54454E434941204E4F4D494E414C3A0400002F4C74730100002003000048727311000045515549504F2041444943494F4E414C3A170000564944412045434F4E4F4D49434120454E2041D14F533A1400005469706F20646520436F6D6275737469626C653A06000053657269653A22000025205072696D6120416E75616C2050726F6D6564696F2064652053656775726F733A0A00004361706163696461643A0700004D6F64656C6F3A2B0000496E64696361646F72204573706563696669636F206465206D65726361646F2064652053656775726F733A18000025205461736120646520496E746572657320416E75616C3A220000496E64696361646F722045636F6E6F6D69636F206465205265666572656E6369613A07000043F36469676F3A11000020204441544F532047454E4552414C4553600000414EC14C495349532C2043C14C43554C4F204520494E54454752414349D34E204445204C4F5320434F53544F5320484F524152494F53204445204C41204D415155494E4152494120592045515549504F20444520434F4E53545255434349D34E0900004C69636974616E7465090000444F43554D454E544F0A000055626963616369F36E3A0500004F6272613A06000046454348413A0B00004C69636974616369F36E3A0C0000446570656E64656E6369613A0900004361706163696461640F00004E756D65726F2064652053657269650600004D6F64656C6F060000436F6469676F4F0000436F6E203120736520696E64696361207369207365206578706C6F74616E206C6F7320496E73756D6F7320646520436F73746F7320486F726172696F732C2030206E6F207365206578706C6F74616E240000457873706C6F74617220496E73756D6F7320646520436F73746F7320486F726172696F731700004E6F65766F20466163746F72436F6D6275737469626C65180000546F74616C204C7562726963616E7465204465736561646F23000043E16C63756C6F20656E205265766572736120436F73746F204C7562726963616E74651F00004E7565766F20436F6566696369656E7465206465204C7562726963616E74650F0000436F6E73756D6F204465736561646F24000043616C63756C6F20656E205265766572736120436F6E73756D6F20656E204C6974726F731A00004E7565766F2056616C6F7220646520416471756973696369F36E110000436172676F46696A6F204465736561646F1E000043E16C75636C6F7320656E207265766572736120436172676F2046696A6F0B0000434F4D4255535449424C453C0000536520636F6E736964657261206C612063616E746964616420646520636F6E73756D6F732063617074757261646F20656E20656C2073697374656D610A00004C5542524943414E54453700007365207574696C697A61206C6F7320666163746F726573207061726120656C2063616C63756C6F206465206C6F7320636F6E73756D6F732E0000436F6E73756D6F7320646520436F6D6275737469626C652079204C7562726963616E746520646574616C6C61646F4E00005061726120656C2063E16C63756C6F206465206C612063616E746964616420646520436F6D6275737469626C652079204C7562726963616E7465205574696C697A616E646F20466163746F7265730D0000436F73746F20526573657276610C0000436F73746F204573706572610C0000436F73746F2041637469766F120000436172676F2046696A6F2052657365727661110000436172676F2046696A6F20457370657261100000436172676F2046696A6F20416374766F0D00004F54524F53434F4E53554D4F53020000506F0900004F504552414349D34E02000041651100005049455A415320455350454349414C45530100004E0700004C4C414E5441530200004C621800004F54524153204655454E54455320444520454E4552474941020000436F0100004D0D00004D414E54454E494D49454E544F020000536D07000053454755524F530200006C6D090000494E56455253494F4E010000440C000044455052454349414349D34E2A0000496E64696361646F72204573706563696669636F206465206D65726361646F2064652053656775726F73310000496E64696361646F722045636F6E6F6D69636F2064652050617261207461736120646520496E746572657320416E75616C0200004B6F170000464143544F52204445204D414E54454E494D49454E544F010000731F00005052494D4120414E55414C2050524F4D4544494F2044452053454755524F53010000691500005441534120444520494E544552455320414E55414C020000567211000056414C4F5220444520524553434154452002000056650E0000564944412045434F4E4F4D4943410300004865610D0000484F52415320504F522041D14F160000564944412045434F4E4F4D49434120454E2041D14F53110000436F73746F4F747261734675656E746573120000466163746F724F747261734675656E7465730C0000454C45435452494349444144110000434F4E53554D4F20454E204C4954524F530200004761220000434F4E53554D4F5320454E5452452043414D42494F204445204C55423D43432F436102000043612100005449454D504F20454E5452452043414D42494F204445204C5542524943414E544502000043431400004341504143494441442044454C204341525445520200004661160000434F4546494349454E5445204C5542524943414E54450200004663170000434F4546494349454E544520434F4D4255535449424C451F000043414E5449444144204445204C5542524943414E544520504F5220484F52410200005061100000434F53544F204C5542524943414E544520000043414E544944414420444520434F4D4255535449424C4520504F5220484F52410200005063110000434F53544F20434F4D4255535449424C450800004741534F4C494E411300005449504F20444520434F4D4255535449424C451E0000434F53544F20504F522053414C4152494F204445204F504552414349D34E0200004874240000484F524153204546454354495641532044452054524142414A4F20504F52205455524E4F0200004672150000464143544F522044452052454E44494D49454E544F160000484F5241532044454C205455524E4F2028486F7261290100005319000053414C4152494F205245414C2044454C204F50455241444F520E0000546F74616C20436F6E73756D6F731800004F74726173204675656E74657320646520456E6572676961030000506F70150000504F54454E434941204445204F504552414349D34E1C000062292E2D4F74726173204675656E74657320646520456E6572676961020000466F130000464143544F52204445204F504552414349D34E1100005069657A617320457370656369616C6573150000504F54454E434941204E4F4D494E414C20284870290700004C6C616E746173020000566D13000056414C4F52204445204C41204D415155494E410A00004C7562726963616E74650200005661190000564944412045434F4E4F4D49434120505A41532045535045430B0000436F6D6275737469626C65020000506516000050524543494F20505A415320455350454349414C45530D00004D616E74656E696D69656E746F020000566E210000564944412045434F4E4F4D494341204445204C4C414E54415320284A7565676F2907000053656775726F7310000045515549504F2041444943494F4E414C090000496E7665727369F36E020000506E14000050524543494F204A5545474F204C4C414E5441530C000044657072656369616369F36E15000050524543494F204445204144515549534943494F4E0B0000446573637269706369F36E0D0000546578746F20436D706C65746F070000526573657276610600004573706572610600004163746976610B0000537573746974756369F36E060000446976696465070000466F726D756C61050000436172676F11000043616D706F732043616C63756C61646F7305000056616C6F720800005661726961626C65090000506172616D6574726F0D00004F54524F5320434F4E53554D4F0C00004E6F6D656E636C61747572611C0000446563696D616C6573205265646F6E64656F20566F6C756D656E65731F00004365746573206120323820646961732064656C2031342F7365702F32303039610000504554524F4C495A41444F5241202044452038303030204C542E20204445203135352048502C204D4F544F522056414D204D4F442E363535382020424F4D424120373536204C504D20424152524120332E3636204D2053494E204348415349532E0900004551504554524F3031080000502D323030392D311000005753513434353735372D53444534343506000038303030204C270000546173612064652053656775726F7320416D65726963612064656C2031342F7365702F323030394F0000202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202A0000484F524153204546454354495641532044452054524142414A4F20504F52205455524E4F20544558544F1A0000496D7072696D697220646573637269706369F36E206C617267610100002A140000446573637269706369F36E20636F6D706C6574610E00004F74726F7320436F6E73756D6F73040000303032380B000041525420343520412E49560800004152542E20323130120000444F43554D454E544F20524C4F507953524DFF005A0108008BEB00000C00000067EC0000E80000007BED0000FC0100003AEE0000BB020000E1EE00006203000076EF0000F7030000D7EF000058040000C3F000004405000096F100001706000086F200000707000005F3000086070000FAF500007B0A0000C1F60000420B00005CF70000DD0B00002FF80000B00C0000D1F80000520D0000A9F900002A0E0000B4FA0000350F000018FB0000990F000075FB0000F60F0000DAFB00005B1000003CFC0000BD100000F4FC000075110000DAFD00005B12000038FE0000B912000067FF0000E81300007E000100FF14000049010100CA150000A101010022160000DE0101005F16000097020100181700000D0301008E170000AC0301002D1800002C040100AD180000C2040100431900006B050100EC190000F90501007A1A00006E060100EF1A0000EC0601006D1B00005B070100DC1B0000B90701003A1C0000A0080100211D0000990901001A1E000063081600630800000000000000000000160000000000000002009608100096080000000000000000000042E501009B0810009B0800000000000000000000010000008C0810008C0800000000000000000000000000000A00000009081000000610006632CD07C9800100060600000B02180000000000000000003C000000B32E0100893601006F3D01000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C10514000000150000008300020001008400020000002600080090C7E3F1783CDE3F27000800FCFD7EBFDFEFE73F2800080069341A8D46A3D13F29000800ACD56AB55AADD63F4D00202000004800500020004C0061007300650072004A006500740020005000330030003000350000000000000000000000000000000000000000000000000000000000000001040006DC00342143FF800701000100EA0A6F08640001000F005802020001005802030000004C00650074007400650072000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000010000000200000014010000FFFFFFFF0000000000000000000000000000000044494E552200A006DC08581824D4305500000000000000000000000000000000000000000000000000000000390000000000000000000100000002000000000000000000000001000000000002000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100010001000100010001000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000A0060000534D544A00000000100090064800500020004C0061007300650072004A00650074002000500033003000300035002000500043004C00200036000000496E70757442696E00464F524D534F5552434500524553444C4C00556E69726573444C4C005265736F6C7574696F6E00363030647069004661737452657300547275650048504C706953656C656374696F6E004E6F6E65005072696E745175616C69747947726F757000505147726F75705F32004F7269656E746174696F6E00504F5254524149540048504F7269656E74526F746174653138300046616C736500506170657253697A65004C4554544552004D6564696154797065004155544F00436F6C6C617465004F46460052455443686F69636500547275650048504F757470757442696E4F7269656E746174696F6E0046414345444F574E00485053747261696768745061706572506174680046616C7365004850436F76657273004F746865725F5061676573004F757470757442696E004175746F0045636F6E6F6D6F64650046616C7365004850504A4C456E636F64696E670055544638004850506170657253697A65414C4D436F6E73747261696E747300454E565F313000546578744173426C61636B0046616C736500545441734269746D61707353657474696E670054544D6F64654F75746C696E6500416C7465726E6174654C6574746572486561640046616C7365004850536D6172744475706C657853696E676C65506167654A6F620054727565004850536D6172744475706C65784F6464506167654A6F6200547275650048504D616E75616C4475706C65784469616C6F674D6F64656C004D6F64656C6573730048504D61704D616E75616C46656564546F547261793100547275650048505072696E744F6E426F746853696465734D616E75616C6C790046616C73650048504D616E75616C4475706C65784469616C6F674974656D7300496E737472756374696F6E49445F30315F46414345444F574E2D4E4F524F544154450048504D616E75616C466565644F7269656E746174696F6E0046414345444F574E004850446F6350726F705265736F75726365446174610068707A686C3433652E636162004850436F6C6F724D6F6465004D4F4E4F4348524F4D455F4D4F444500485050444C547970650050444C5F50434C360048504A6F624163636F756E74696E670048504A4F42414343545F4A4F4241434E540048504A6F6242794A6F624F76657272696465004A424A4F004850426F726E4F6E44617465004850424F440048505072696E74496E477261795363616C650046616C73650048504475706C69636174654A6F624E616D654F766572726964650053574657005053416C69676E6D656E7446696C650048505A4C5334336500505353657276696365734F7074696F6E0050726E537461745F5349445F3234325F4249445F3439375F4849445F313535323100505353657276696365735F446576696365616E64537570706C6965735374617475730054525545004850536D6172744875625F4F6E6C696E65646961676E6F73746963746F6F6C730054525545004850536D6172744875625F537570706F7274616E6474726F75626C6573686F6F74696E670054525545004850536D6172744875625F50726F647563746D616E75616C730054525545004850536D6172744875625F436865636B666F72647269766572757064617465730054525545004850536D6172744875625F53686F776D65686F770054525545004850536D6172744875625F4F72646572737570706C6965730054525545004850536D61727448756200496E65745F5349445F3236335F4249445F3531345F4849445F323635004850436F6E73756D6572437573746F6D50617065720054727565004850456E61626C6552415753706F6F6C696E670054727565004A52436F6E73747261696E7473004A524348445061727469616C004850436F6C6F72536D617274004175746F6D61746963004A524844496E7374616C6C6564004A5248444F6666004A5248444E6F74496E7374616C6C6564004A5248444F6666004850584D4C46696C65557365640068706333307835362E786D6C004475706C6578004E4F4E45004850506170657253697A654475706C6578436F6E73747261696E74730041360048504D65646961547970654475706C6578436F6E73747261696E7473004845415659000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005818000049555048100011000000000001000000020000000100000000000000000000000300000000000000000000000100010064000100000003000200000001000000020000004C00650074007400650072000000000000000000000000000000000000000000000000000100EA0A6F080000FFFFFFFFFFFFFFFFFFFFFFFF01000000060000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000010000000000000000000000000000000000000000000000000000000000000020005B006E0069006E00670075006E0061005D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020005B006E0069006E00670075006E0061005D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000041007200690061006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003400000050000000000000000100000000000000C0C0C00000000000C0C0C000000000000000000000000000000000000100000001000000640000000000000000000000000000000000803F0000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000201000003010000000000000000000001000000010000000000000000000000000000004A0043004F004C0049004E00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003C004100750074006F006D00E1007400690063006F003E000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000100000001000000010000000100000001000000000000000100000001000000010000000000000000000000000000000100000000000000000000000100000050000000000000000000000000000000010000000100000001000000010000000F00000014010000000000000F00000014010000000000000200000000000000000000000F000000140100000F0000001401000000000000000000000000000052BB0D00340800003408000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120100001101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000064000000010000004D006900630072006F0073006F006600740020004F0066006600690063006500200045007800630065006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000069000000F10C000000000000000000006A000000FD0B000000000000000000006B0000009E11000000000000000000006B000000FF0B000000000000000000006D000000F90B000000000000000000006D000000F90B0000000000000000000002000000FFFFFFFF455843454C2E45584500000000000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000F000000140100000F000000140100000F000000140100000F00000014010000000000000000000000000000130100000000000000000000008000800100000043003A005C004100720063006800690076006F0073002000640065002000700072006F006700720061003C00F2016D0061005C004D006900630072006F0073006F006600740020004F00660066006900630065005C004F0066006600690063006500310032005C0045005800430045004C002E004500580045000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000A100220001003C000100010001000200580258020000000000000000000000000000000001009C0826009C08000000000000000000000000000000000000000000000000000004000000000000000000550002000A007D000C0000000000B61E0F00020000007D000C0001000100004B0F00060000007D000C0002000200B6320F00020000007D000C00030003006D0EF301020000007D000C000400000124090F000000000000020E00000000003C00000000000400000008021000000000000300FF000000000040010F0008021000010000000300FF000000000040010F0008021000020000000300FF000000000040010F0008021000030000000300FF000000000040010F0008021000040000000300FF000000000040010F0008021000050000000300FF000000000040010F0008021000060000000300FF000000000040010F0008021000070000000300FF000000000040010F0008021000080000000300FF000000000040010F0008021000090000000300FF000000000040010F00080210000A0000000300FF000000000040010F00080210000B0000000300FF000000000040010F00080210000C0000000300FF000000000040010F00080210000D0000000300FF000000000040010F00080210000E0000000300FF000000000040010F00080210000F0000000300FF000000000040010F0008021000100000000300FF000000000040010F0008021000110000000300FF000000000040010F0008021000120000000300A3020000000000010F0008021000130000000300FF000000000040010F0008021000140000000300FF000000000040010F0008021000150000000300FF000000000040010F0008021000160000000300FF000000000040010F0008021000170000000300FF000000000040010F0008021000180000000300FF000000000040010F0008021000190000000300FF000000000040010F00080210001A0000000300FF000000000040010F00080210001B0000000300FF000000000040010F00080210001C0000000300FF000000000040010F00080210001D0000000300FF000000000040010F00080210001E0000000300FF000000000040010F00080210001F0000000300FF000000000040010F00FD000A0000000000450000000000BE000A0000000100450046000200BE000C00010000004700470047000200FD000A000200000049001B000000FD000A00020001004A0001000000FD000A00020002004B001C000000FD000A00030000004C0002000000BE000A00030001004D004E000200FD000A00040000004F001D000000FD000A0004000100500003000000FD000A000400020076011E000000FD000A000500000051001F000000FD000A0005000100480004000000FD000A0005000200670120000000FD000A0006000000510021000000FD000A0006000100480005000000FD000A0006000200670122000000FD000A0007000000510023000000FD000A0007000100480006000000FD000A0007000200670124000000FD000A0008000000480025000000FD000A0008000100510026000000FD000A0008000200670127000000FD000A0009000000480028000000FD000A0009000100480007000000FD000A0009000200670129000000FD000A000A00000048002A000000FD000A000A000100480008000000FD000A000A00020067012B000000FD000A000B00000048002C000000FD000A000B000100480009000000FD000A000B00020052002D000000FD000A000C00000051002E000000FD000A000C00010048000A0000007E020A000C00020077011E5A4B00FD000A000D00000051002F000000FD000A000D00010048000B0000007E020A000D00020077013A85F102FD000A000E000000510030000000FD000A000E00010048000C0000007E020A000E000200770156346F1DFD000A000F000000510031000000FD000A000F00010048000D000000FD000A000F000200670153000000FD000A0010000000510032000000FD000A001000010048000E000000FD000A0010000200670152000000FD000A00110000004C0033000000BE000A001100010053004E000200FD000A0012000000510034000000FD000A0012000100510035000000FD000A0012000200750136000000FD000A0013000000480037000000FD000A0013000100480038000000FD000A0013000200670139000000FD000A001400000048003A000000FD000A001400010048003B000000FD000A001400020067013C000000FD000A001500000048005B000000FD000A001500010048006F000000FD000A001500020067016F000000FD000A001600000048005D000000FD000A0016000100480069000000FD000A0016000200670169000000FD000A001700000048005C000000FD000A001700010048006A000000FD000A001700020067016A000000FD000A001800000048005E000000FD000A001800010048006B000000FD000A001800020067016B000000FD000A001900000048005F000000FD000A001900010048006C000000FD000A001900020067016C000000FD000A001A000000480060000000FD000A001A00010048006D000000FD000A001A00020067016D000000FD000A001B000000480070000000FD000A001B00010048006E000000FD000A001B00020067016E000000FD000A001C0000004C000F000000BE000A001C00010053004E000200FD000A001D00000051003D000000FD000A001D0001004800100000007E020A001D0002007801208AE340FD000A001E00000051003E000000FD000A001E000100480011000000FD000A001E00020079013F000000FD000A001F000000510078000000FD000A001F000100510040000000FD000A001F000200750141000000D70044006E0700006C021C0010002A001C002A002A002A002A002A002A002A002A002A002A002A002A002A001C002A002A002A002A002A002A002A002A002A002A001C002A002A0008021000200000000300FF000000000040010F0008021000210000000300E9070000000000010F0008021000220000000300FF000000000040010F0008021000230000000300FF000000000040010F0008021000240000000300FF000000000040010F0008021000250000000300FF000000000040010F0008021000260000000300FF000000000040010F0008021000270000000300FF000000000040010F0008021000280000000300FF000000000040010F0008021000290000000300FF000000000040010F00080210002A0000000300FF000000000040010F00080210002B0000000300FF000000000040010F00080210002C0000000300FF000000000040010F00080210002D0000000300FF000000000040010F00080210002E0000000300FF000000000040010F00080210002F0000000300FF000000000040010F0008021000300000000300FF000000000040010F0008021000310000000300FF000000000040010F0008021000320000000300FF000000000040010F0008021000330000000300FF000000000040010F0008021000340000000300FF000000000040010F0008021000350000000300FF000000000040010F0008021000360000000300FF000000000040010F0008021000370000000300FF000000000040010F0008021000380000000300FF000000000040010F0008021000390000000300FF000000000040010F00080210003A0000000300FF000000000040010F00080210003B0000000300FF000000000040010F00FD000A00200000004C0012000000BE000A0020000100530054000200FD000A0021000000510042000000FD000A0021000100480013000000FD000A00210002007A0154000000FD000A0022000000510061000000FD000A0022000100480014000000FD000A0022000200750143000000FD000A0023000000510062000000FD000A0023000100480067000000FD000A0023000200750167000000FD000A0024000000510044000000FD000A0024000100480015000000FD000A0024000200750124000000FD000A0025000000510045000000FD000A0025000100510046000000FD000A0025000200750127000000FD000A0026000000510063000000FD000A0026000100510068000000FD000A0026000200750168000000FD000A0027000000510064000000FD000A0027000100510071000000FD000A0027000200750171000000FD000A0028000000510065000000FD000A0028000100510072000000FD000A0028000200750172000000FD000A0029000000510066000000FD000A0029000100510073000000FD000A0029000200750173000000FD000A002A00000051007E000000FD000A002A00010051007F000000FD000A002A000200750180000000FD000A002B000000510047000000FD000A002B0001004800550000007E020A002B0002007801408BE340FD000A002C000000550048000000FD000A002C0001005600560000007E020A002C0002007B01409EE340FD000A002D000000510081000000FD000A002D0001004800820000007E020A002D0002007C01006AF840FD000A002E000000510085000000FD000A002E0001004800860000007E020A002E0002007C01002ABE40FD000A002F000000510084000000FD000A002F0001004800830000007E020A002F0002007D0101002E40FD000A00300000004C0016000000BE000A003000010053004E000200FD000A003100000048007A000000FD000A003100010048007B0000007E020A0031000200750100206340FD000A003200000048007D000000FD000A003200010048007C0000007E020A0032000200750100A06040FD000A0033000000510074000000FD000A00330001005100490000007E020A0033000200750100000040FD000A0034000000510075000000FD000A0034000100510057000000FD000A003400020067014A000000FD000A0035000000510076000000FD000A0035000100510059000000FD000A003500020067014B000000FD000A0036000000510079000000FD000A0036000100510058000000FD000A003600020067014C000000FD000A0037000000510077000000FD000A003700010051005A000000FD000A003700020067014D000000FD000A0038000000570017000000BE000A0038000100580059000200FD000A003900000051004E000000FD000A0039000100480018000000FD000A003900020079014F010000FD000A003A00000051004F000000FD000A003A0001004800190000007E020A003A00020078016087E340FD000A003B0000005A0050000000FD000A003B00010048001A000000FD000A003B0002007E0151000000D7003C009E0600001C021C002A002A002A002A002A002A002A002A002A002A002A002A002A002A002A001C002A002A002A002A002A002A002A001C002A002A00EC0050000F0002F048000000100008F00800000001000000000800000F0003F0300000000F0004F028000000010009F0100000000000000000000000000000000000000002000AF00800000000080000050000003E021200A406000000004000000000000000000000008B0810008B0800000000000000000000000002001D000F00030000000000000100000000000000990002002409B801BA000B000B0002000200D0C9EA79F9BACE118C8200AA004BA90B02000000170000001700000073006F0070006F0072007400650040006E0065006F0064006100740061002E0063006F006D002E006D0078000000E0C9EA79F9BACE118C8200AA004BA90B540000006D00610069006C0074006F003A0073006F0070006F0072007400650040006E0065006F0064006100740061002E0063006F006D002E006D0078000000795881F43B1D7F48AF2C825DC485276300000000A5AB000067081700670800000000000000000000020001FFFFFFFF034400000A00000009081000000610006632CD07C9800100060600000B021C0000000000000000005D0000005B620100A98A010053970100989E01000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000F00081000200C104140000001500000083000200000084000200000026000800666666666666E63F27000800666666666666E63F28000800000000000000E83F29000800000000000000E83F4D00202000004800500020004C0061007300650072004A006500740020005000330030003000350000000000000000000000000000000000000000000000000000000000000001040006DC00342143FF800701000100EA0A6F08640001000F005802020001005802030000004C00650074007400650072000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000010000000200000014010000FFFFFFFF0000000000000000000000000000000044494E552200A006DC08581824D4305500000000000000000000000000000000000000000000000000000000390000000000000000000100000002000000000000000000000001000000000002000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100010001000100010001000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000A0060000534D544A00000000100090064800500020004C0061007300650072004A00650074002000500033003000300035002000500043004C00200036000000496E70757442696E00464F524D534F5552434500524553444C4C00556E69726573444C4C005265736F6C7574696F6E00363030647069004661737452657300547275650048504C706953656C656374696F6E004E6F6E65005072696E745175616C69747947726F757000505147726F75705F32004F7269656E746174696F6E00504F5254524149540048504F7269656E74526F746174653138300046616C736500506170657253697A65004C4554544552004D6564696154797065004155544F00436F6C6C617465004F46460052455443686F69636500547275650048504F757470757442696E4F7269656E746174696F6E0046414345444F574E00485053747261696768745061706572506174680046616C7365004850436F76657273004F746865725F5061676573004F757470757442696E004175746F0045636F6E6F6D6F64650046616C7365004850504A4C456E636F64696E670055544638004850506170657253697A65414C4D436F6E73747261696E747300454E565F313000546578744173426C61636B0046616C736500545441734269746D61707353657474696E670054544D6F64654F75746C696E6500416C7465726E6174654C6574746572486561640046616C7365004850536D6172744475706C657853696E676C65506167654A6F620054727565004850536D6172744475706C65784F6464506167654A6F6200547275650048504D616E75616C4475706C65784469616C6F674D6F64656C004D6F64656C6573730048504D61704D616E75616C46656564546F547261793100547275650048505072696E744F6E426F746853696465734D616E75616C6C790046616C73650048504D616E75616C4475706C65784469616C6F674974656D7300496E737472756374696F6E49445F30315F46414345444F574E2D4E4F524F544154450048504D616E75616C466565644F7269656E746174696F6E0046414345444F574E004850446F6350726F705265736F75726365446174610068707A686C3433652E636162004850436F6C6F724D6F6465004D4F4E4F4348524F4D455F4D4F444500485050444C547970650050444C5F50434C360048504A6F624163636F756E74696E670048504A4F42414343545F4A4F4241434E540048504A6F6242794A6F624F76657272696465004A424A4F004850426F726E4F6E44617465004850424F440048505072696E74496E477261795363616C650046616C73650048504475706C69636174654A6F624E616D654F766572726964650053574657005053416C69676E6D656E7446696C650048505A4C5334336500505353657276696365734F7074696F6E0050726E537461745F5349445F3234325F4249445F3439375F4849445F313535323100505353657276696365735F446576696365616E64537570706C6965735374617475730054525545004850536D6172744875625F4F6E6C696E65646961676E6F73746963746F6F6C730054525545004850536D6172744875625F537570706F7274616E6474726F75626C6573686F6F74696E670054525545004850536D6172744875625F50726F647563746D616E75616C730054525545004850536D6172744875625F436865636B666F72647269766572757064617465730054525545004850536D6172744875625F53686F776D65686F770054525545004850536D6172744875625F4F72646572737570706C6965730054525545004850536D61727448756200496E65745F5349445F3236335F4249445F3531345F4849445F323635004850436F6E73756D6572437573746F6D50617065720054727565004850456E61626C6552415753706F6F6C696E670054727565004A52436F6E73747261696E7473004A524348445061727469616C004850436F6C6F72536D617274004175746F6D61746963004A524844496E7374616C6C6564004A5248444F6666004A5248444E6F74496E7374616C6C6564004A5248444F6666004850584D4C46696C65557365640068706333307835362E786D6C004475706C6578004E4F4E45004850506170657253697A654475706C6578436F6E73747261696E74730041360048504D65646961547970654475706C6578436F6E73747261696E7473004845415659000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005818000049555048100011000000000001000000020000000100000000000000000000000300000000000000000000000100010064000100000003000200000001000000020000004C00650074007400650072000000000000000000000000000000000000000000000000000100EA0A6F080000FFFFFFFFFFFFFFFFFFFFFFFF01000000060000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000010000000000000000000000000000000000000000000000000000000000000020005B006E0069006E00670075006E0061005D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020005B006E0069006E00670075006E0061005D0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000041007200690061006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003400000050000000000000000100000000000000C0C0C00000000000C0C0C000000000000000000000000000000000000100000001000000640000000000000000000000000000000000803F0000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000201000003010000000000000000000001000000010000000000000000000000000000004A0043004F004C0049004E00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003C004100750074006F006D00E1007400690063006F003E000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000100000001000000010000000100000001000000000000000100000001000000010000000000000000000000000000000100000000000000000000000100000050000000000000000000000000000000010000000100000001000000010000000F00000014010000000000000F00000014010000000000000200000000000000000000000F000000140100000F0000001401000000000000000000000000000052BB0D00340800003408000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120100001101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000064000000010000004D006900630072006F0073006F006600740020004F0066006600690063006500200045007800630065006C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000069000000F10C000000000000000000006A000000FD0B000000000000000000006B0000009E11000000000000000000006B000000FF0B000000000000000000006D000000F90B000000000000000000006D000000F90B0000000000000000000002000000FFFFFFFF455843454C2E45584500000000000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000F000000140100000F000000140100000F000000140100000F00000014010000000000000000000000000000130100000000000000000000008000800100000043003A005C004100720063006800690076006F0073002000640065002000700072006F006700720061003C00F2016D0061005C004D006900630072006F0073006F006600740020004F00660066006900630065005C004F0066006600690063006500310032005C0045005800430045004C002E004500580045000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000A100220001006400010001000100020058025802333333333333D33F333333333333D33F01009C0826009C0800000000000000000000000000000000000000000000000000003C330000000000000000550002000A007D000C00000000009203D000020000007D000C0001000100B626D000020000007D000C00020002006D07D000060000007D000C00030003000011D000020000007D000C0004000400B60ED000020000007D000C00050005002406D000020000007D000C00060006002413D000020000007D000C00070007006D0BD000020000007D000C0008000800000BD000020000007D000C00090009006D0BD000020000007D000C000A000A006D04D000020000007D000C000B000B006D24D000060000007D000C000C000C009205D000020000007D000C000D000D00491ED000060000007D000C000E000E00490CD000020000007D000C000F000F006D0BD000020000007D000C00100012006D0BD000000000007D000C0013001300242AD000020000007D000C00140014000013D000020000007D000C00150015009209D000020000007D000C0016001600240ED000020000007D000C0017001700490ED000020000007D000C0018001B006D0BD000000000007D000C001C001C002422D000020000007D000C001D001D00DB16D000020000007D000C001E0020006D0BD000000000007D000C00210021009209D000020000007D000C00220000016D0BD0000000000000020E00000000005D00000001002300000008021000000001002300FF000000000000010F20080210000100010023000E010000000000010F20080210000200010023000E010000000000010F3008021000030001002300FF000000000000010F1008021000040001002300F0000000000000010F0008021000050001002300F0000000000000010F0008021000060001002300F0000000000000010F0008021000070001002300F0000000000000010F0008021000080001002300F0000000000000010F0008021000090001002300F0000000000000010F00080210000A0001002300F0000000000000010F00080210000B0001002300F0000000000000010F00080210000C0001002300F0000000000000010F00080210000D0001002300F0000000000000010F00080210000E0001002300F0000000000000010F00080210000F0001002300F0000000000000010F0008021000100001001100F0000000000000010F0008021000110001001100F0000000000000010F0008021000120001001100F0000000000000010F0008021000130001001100F0000000000000010F0008021000140001001100F0000000000000010F0008021000150001001100F0000000000000010F0008021000160001001100F0000000000000010F0008021000170001001100F0000000000000010F0008021000180001001100F0000000000000010F0008021000190001001100F0000000000000010F00080210001A0001001100F0000000000000010F00080210001B0001001100F0000000000000010F00080210001C0001001100F0000000000000010F00080210001D0001001100F0000000000000010F00080210001E0001001100F0000000000000010F00080210001F0001001100F0000000000000010F00FD000A000100010000024001000001020600010002000002FD000A00010003006201A6000000FD000A00010004006201A600000001020600010005006101FD000A00010012006001D9000000BE001400010013005F015F015F015F015F015E015E011900FD000A0001001B0060013F010000BE00140001001C005F015F015F015F015F015F015E012200FD000A00020001005D013E010000FD000A00020002005C013D010000FD000A00020003005B013C010000FD000A00020004005B013B01000001020600020005005A01FD000A000200060058013A010000FD000A0002000700590136010000FD000A0002000800590135010000FD000A0002000900580134010000FD000A0002000B00570139010000FD000A0002000C00570138010000FD000A0002000D00570137010000FD000A0002000E00560136010000FD000A0002000F00560135010000FD000A0002001000560134010000FD000A00020012005501BF000000FD000A0002001300550133010000FD000A0002001400550132010000FD000A0002001500550195000000FD000A0002001600550193000000FD000A0002001700550194000000FD000A0002001800DF0191000000FD000A0002001900E401D8000000FD000A0002001B005501BF000000FD000A0002001C0055014D010000FD000A0002001D00550132010000FD000A0002001E00550195000000FD000A0002001F00550193000000FD000A0002002000550194000000FD000A0002002100550192000000FD000A0002002200550191000000FD000A0003000100940131010000010206000300020095017E020A000300030096010068B040BE000A00030004005401E2000500FD000A0003000600530130010000BD0018000300070052010000F03F52010000F03F510101002E4009000600580003000B005001000000000000FFFF000004000BFF4200171C0061292E2D20444550524543494143494F4E2E2E2E2E2E2E2E44203D285A010009000200081701002D085A01002400020008170200292F085A010023000200080702280025000061292E2D20444550524543494143494F4E2E2E2E2E2E2E2E44203D28566D2D5672292F56650102060003000C004F010600670003000D004E01000000000000FFFF200004000DFF51001701002843BA00000017090024232C2323232E2323413000081701002D0843BC00000017090024232C2323232E23234130000817010029081701002F0843BE000000170800232C2323232E30304130000807021B001800002824342C3230302E2D243432302E292F362C3030302E30300600580003000E004D01295C8FC2F528E43F000006000DFF42005A0100230003C01E00000D190228005A0100090004C05A0100240004C004155A0100230003C006433200000019400001411B0019080A001E000019080300420301000600290003000F004C01295C8FC2F528E43F0000030010FF13004403000EC04339000000054332000000411B0006002900030010004B010AD7A3703D0AB73F000006000EFF13004403000EC0433B000000054332000000411B00BE000E00030012004A014901490149011500BD0018000300160049010000F03FDA0100000000E00100000000180006004D0003001900F00100000000000000000000100004FF370044030016C01E00000D19021F001940000244030017C044030016C006433200000019400001411B0019080A001E00001908030042030100BE00140003001B004A0149014901490149014901480121007E020A0003002200470100000000FD000A000400010097012F010000FD000A000400020098012E0100007E020A0004000300990100000000BE000A00040004000F01E2000500FD000A000400060032012D010000BD0018000400070031010000F03F31010000F03F30010000F03F090006008C0004000B002F01000000000000FFFF000005000BFF7600171901620029002E002D00200049004E00560045005200530049004F004E0026202E002E002E002E002E002E002E002E002E002E005A01002B00020008170400203D2028085A010009000200081701002B085A01002400020008170200292A085A010025000200081702002F32085A0100220002000807025B002C0001620029002E002D00200049004E00560045005200530049004F004E0026202E002E002E002E002E002E002E002E002E002E006C006D0020003D002000280056006D002B005600720029002A0069002F0032004800650061000102060004000C002E0106007C0004000D002D01000000000000FFFF200003000EFF66001701002843BA00000017090024232C2323232E2323413000081701002B0843BC000000170A0024232C2323232E232323413000081701002908170100780843B000000017090023232E303030302025413000081704002F283278084353000000081701002908070225002200002824342C3230302E2B243432302E297831322E3030303020252F28327832303030290600600004000E002C01EC51B81E85EBC13F000005000DFF4A0043530000001E00000D190232005A0100090004C05A0100240004C003155A0100250003C0051E02005A0100220003C00515064332000000411B001519080A001E000019080300420301000600290004000F002B01EC51B81E85EBC13F00002B0004FF13004404000EC0435F000000054332000000411B0006002900040010002A01EC51B81E85EBC13F000004000FFF13004404000EC04361000000054332000000411B00BE000E0004001200460145014501450115007E020A0004001600450100000040BE000A0004001700DB01E101180006004D0004001900F10100000000000000000000050019FF370044040016C01E00000D19021F001940000244040017C044040016C006433200000019400001411B0019080A001E00001908030042030100BE00140004001B00460145014501450145014501440121007E020A0004002200430100000000FD000A000500010097012C010000010206000500020098017E020A0005000300990100000000BE000A00050004000F01E2000500FD000A000500060032012B010000BD0018000500070031010000F03F31010000F03F30010000F03F09000600800005000B003901000000000000FFFF000006000BFF6A00171301630029002E002D002000530045004700550052004F0053002620262026202E002E002E002E005A01002C00020008170400203D2028085A0100090002C0081701002B085A0100240002C008170200292A085A0100260002C0081702002F32085A0100220002C00807024F00260001630029002E002D002000530045004700550052004F0053002620262026202E002E002E002E0053006D0020003D002000280056006D002B005600720029002A0073002F0032004800650061000102060005000C00380106007B0005000D003701000000000000FFFF2000040010FF65001701002843BA00000017090024232C2323232E3030413000081701002B0843BC00000017090024232C2323232E303041300008170200297808439F00000017070023232E30302025413000081703002F28320817010078085A0100220003C0081701002908070226002300002824342C3230302E30302B243432302E30302978342E303020252F28327832303030290600680005000E0036019A9999999999A93F000003000DFF520043530000001E00000D19023A005A0100090004C05A0100240004C003155A0100260003C0051E02005A0100220003C0051506433200000019400001411B00194002011519080A001E000019080300420301000600290005000F0035019A9999999999A93F0000380004FF13004405000EC043AD000000054332000000411B00060029000500100034019A9999999999A93F000005000FFF13004405000EC043AF000000054332000000411B00BE000E0005001200460145014501450115007E020A0005001600450100000000BE000A0005001700DB01E101180006004D0005001900F10100000000000000000000060019FF370044050016C01E00000D19021F001940000244050017C044050016C006433200000019400001411B0019080A001E00001908030042030100BE00160005001B00460145014501450145014501440143012200FD000A000600010097012A010000FD000A00060002009801290100007E020A00060003009A0100000000BE000A00060004000F01E2000500FD000A0006000600320128010000BD0018000600070031010000F03F310100000000300101002E4009000600540006000B002F01000000000000FFFF000007000BFF3E0017170064292E2D204D414E54454E494D49454E544F2E2E2E2E2E5A01002D00020008170300203D20085A0100270002C0081701002A085A01002A0002C008070222001F000064292E2D204D414E54454E494D49454E544F2E2E2E2E2E4D203D204B6F2A440102060006000C002E0106002A0006000D002D01000000000000FFFF20002A0004FF14005A0100270003C01703002078200843370000000807020D000A0000302E38207820302E363306002B0006000E002C01000000000000E03F0000350004FF15005A0100270003C04337000000054332000000411B000600290006000F002B0100000000000000000000370004FF130043710000004373000000054332000000411B0006002900060010002A017B14AE47E17AB43F000006000FFF130043710000004375000000054332000000411B00BE000E0006001200460145014501450115007E020A0006001600450100000000BE000A0006001700DB01E101180006004D0006001900F10100000000000000000000070019FF370044060016C01E00000D19021F001940000244060017C044060016C006433200000019400001411B0019080A001E00001908030042030100BE00160006001B00460145014501450145014501440143012200FD000A0007000100970127010000FD000A00070002009801260100007E020A0007000300990100000000BE000A00070004000F01E2000500FD000A0007000600320125010000BD0018000700070031010000F03F31010100144030010000000009000600C80007000B003901000000000000FFFF000008000BFFB20043200000001E01000B19025E00171401610029002E00200043004F004D004200550053005400490042004C00450026202E0026202E002E005A01002E000200081701003D085A010018000200081701002A085A01000C000200081701002A085A0100140002000819084600171E01610029002E00200043004F004D004200550053005400490042004C00450026202E0026202E002E0043006F003D004700680020007800200050006300190803004203010007024300200001610029002E00200043004F004D004200550053005400490042004C00450026202E0026202E002E0043006F003D00460063002A0050006F0070002A00500063007E020A0007000C0038010000000006005D0007000D003701000000000000FFFF2000080017FF470043200000001E01000B1902210043470000001701007808439B00000008170300782024084326000000081908180043030000001702007824084326000000081908030042030100070211000E00003178302E31303732782024342E350600570007000E003601B81E85EB51B8DE3F0000070010FF410043200000001E01000B19021900194000014347000000439B0000000543260000000519081200430300000043260000000519080300420301004332000000411B000600290007000F0035017B14AE47E17A943F00002E0004FF13004407000EC04319000000054332000000411B0006002900070010003401000000000000000000000A0010FF13004407000EC0431B000000054332000000411B00BE0014000700120042014101410141014101DC01E201180006004D0007001900F20100000000000000000000030019FF370044070016C01E00000D19021F001940000244070017C044070016C006433200000019400001411B0019080A001E00001908030042030100BE00160007001B0040013F013F013F013F013F013E013D012200FD000A0008000100970124010000FD000A00080002009801230100007E020A00080003009B0100000000BE000A00080004000F01E2000500FD000A0008000600320122010000BD0018000800070031010000F03F31010100144030010000000009000600FA0008000B002F01000000000000FFFF0000080022FFE40043200000001E01000B19028000171601630029002E0020004C007500620072006900630061006E007400650026202620262026202E002E002E002E005A0100300002C0081703003D5B28085A010019000200081701002A085A01000C00020008170200292B085A01001A000200081701002F085A01001B000200081702005D2A085A0100160002000819085600172601630029002E0020004C007500620072006900630061006E007400650026202620262026202E002E002E002E004C0062003D0020002800410068002B0047006100290020007800200050006100190803004203010007025B002C0001630029002E0020004C007500620072006900630061006E007400650026202620262026202E002E002E002E004C0062003D005B002800460061002A0050006F00700029002B00430043002F00430061005D002A00500061007E020A0008000C002E01000000000600920008000D002D01000000000000FFFF200007000EFF7C0043200000001E01000B190246001702005B284348000000081701007808439B00000008170200292B084307000000081701002F0843B4000000081705005D2078202408432B000000081702006C740819082800170100284305000000081701002B08431E00000008170200292A08432B000000081908030042030100070223002000005B28302E3030373578302E31303732292B302F305D2078202431362E34386C740600310008000E002C017B14AE47E17A843F0000240004FF1B00194000014304000000432B00000005433200000019400001411B000600290008000F002B0100000000000000000000080010FF13004408000EC0436D000000054332000000411B0006002900080010002A0100000000000000000000330004FF13004408000EC0436F000000054332000000411B00BE001000080012003B013B013B013B013B01160006002300080017003C0100000000000000000000080018FF0D00250300070017C017C01910AB040600230008001800E301000000000000000000000D0004FF0D00250300070018C018C0191004040600230008001900E5010000000000000000000010000DFF0D00250300070019C019C019100404BE00140008001B003B013B013B013B013B013B013B01210006002300080022003B0100000000000000000000090004FF0D00250300070022C022C019100404FD000A0009000100970121010000FD000A000900020098012001000001020600090003009B0106002F00090004003A01000000000068B040000009000BFF1900439C000000439E000000044330000000044332000000411B000102060009000500E200FD000A000900060032011F010000BD0018000900070031010000F03F310101002E4030010000000009000600650009000B003901000000000000FFFF000009000EFF4F00171501640029002E0020004C006C0061006E0074006100730026202620262026202E0026202E002E002E002E005A010031000200081701003D085A010004000200081701002F085A0100060002000807023B001C0001640029002E0020004C006C0061006E0074006100730026202620262026202E0026202E002E002E002E004E003D0050006E002F0056006E007E020A0009000C0038010000F03F0600660009000D003701000000000000FFFF20000A000DFE5000439E00000017090024232C2323232E30304130001701002F0843BF0000001E00000D1902180043BF000000170500232C232323194000014130001908100023BF0000001940000119080300420301000807020900060000242E30302F3006004A0009000E00360100000000000000000000090010FF340043BF0000001E00000D19021800439E00000043BF00000006154332000000411B0019080E001E00001940000119080300420301000600290009000F00350100000000000000000000310004FF13004409000EC04366000000054332000000411B0006002900090010003401000000000000000000000A000BFF13004409000EC04368000000054332000000411B00FD000A000A0001000C011E010000010206000A0002000B017E020A000A000300330100005440BE000A000A0004000F01E2000500FD000A000A00060032011D010000BD0018000A00070031010000F03F310100000000300100000000090006006D000A000B002F01000000000000FFFF00000A000EFF5700171901650029002E0020005000690065007A0061007300200045007300700065006300690061006C006500730026202E002E002E005A010032000200081701003D085A010007000200081701002F085A0100080002000807024500210001650029002E0020005000690065007A0061007300200045007300700065006300690061006C006500730026202E002E002E00410065003D00500065002F00560061007E020A000A000C002E010000F03F060064000A000D002D01000000000000FFFF2000110004FF4E00433000000017090024232C2323232C30304130001701002F0843C00000001E00000D1902180043C0000000170500232C2323231940000241300019080E001E000019400001190803004203010008070208000500002430302F3006004A000A000E002C01000000000000000000000A000FFF340043C00000001E00000D19021800433000000043C000000006154332000000411B0019080E001E0000194000011908030042030100060029000A000F002B01000000000000000000000B000DFF1300440A000EC04394000000054332000000411B00060029000A0010002A0100000000000000000000100010FF1300440A000EC04396000000054332000000411B00FD000A000B0001000C011C010000FD000A000B0002000B011B01000003020E000B000300DD01DC114E0B5EF4553FBE000A000B0004000F01E2000500FD000A000B000600290192000000BD0018000B00070028010000F03F28010000F03F27010000F03F0900FD000A000B000B00EC011A0100007E020A000B000C00ED0100000000060037000B000D00EC01000000000000FFFF20000B000EFF2100432F00000017090024232C2323232E3030413000170300202A2008434B0000000807020B00080000242E3030202A203006002D000B000E00EC01000000000000000000000B000FFF170019400001434B000000432F000000054332000000411B00060029000B000F00EC010000000000000000000010000BFF1300440B000EC04388000000054332000000411B00060029000B001000EE010000000000000000000008000DFF1300440B000EC04389000000054332000000411B00FD000A000C0001000C0119010000FD000A000C0002000B0118010000010206000C0003000B01060029000C000400DE015396218E7571BB3F000007000DFF1300439A000000434A000000054333000000411B00010206000C000500E200FD000A000C000600240117010000BD0018000C00070023010000F03F2301010014402201000000000900BE0012000C000B002F012F012F012F012F012D011000FD000A000D000100190115010000FD000A000D00020018011401000006001B000D000400210100000000000000000000210004FF050043A7000000010206000D0005001001FD000A000D000B0026014E010000BE000A000D000C00260126010D0006001B000D000E002601000000000000000000003F0004FF050043B7000000060029000D000F002601000000000000000000000E000EFF1300440D000EC04319000000054332000000411B00060029000D0010002501000000000000000000000E0010FF1300440D000EC0431A000000054332000000411B00FD000A000E000100190113010000010206000E00020018017E020A000E000300200100001040BE000A000E0004000F01E2000500FD000A000E000B00260116010000BE000A000E000C00260126010D00060029000E000E0026015C8FC2F5285CDF3F00000D0010FF13002507000B000EC00EC01910AB04440D000EC003060029000E000F0026017B14AE47E17A943F00002C0004FF13002507000B000FC00FC019100444440D000FC003060029000E001000EF0100000000000000000000300004FF13002507000B0010C010C019104444440D0010C003FD000A000F000100190112010000FD000A000F0002001801110100007E020A000F00030018010000F03FBE000A000F0004000F01E2000500FD000A0010000100190110010000FD000A001000020018010F0100000102060010000300180106002900100004001A01000000000000104000001C0004FF1300440E0003C0440F0003C0054332000000411B000102060010000500E2000600310010000B001F01000000000000FFFF0000340004FF1B0044120002C01701003D08440D0002C0081701002F0844100002C00807020A00070000506F3D532F48740102060010000C001E0106001B0010000D00E60100000000000000000000470003FF050044080019C00600210010000E001D010000000000000000000007000FFF0B004410000DC0440B0007C0050600210010000F001C010000000000000000000010000EFF0B00440B0008C04410000DC00506002100100010001B010000000000000000000010000FFF0B004410000DC0438700000005FD000A001100010019014A010000BE000A00110002001801180103000600B80011000400E701000100000000FFFF0000040019FFA20044030016C01E00000D19028A0044030016C044040016C01E00000D190260001701002C44040016C00844050016C01E00000D190235001701002C44050016C00844060016C01E00000D19020E001701002C44060016C00819080A0017000019080300420301000819080E001700001940000119080300420301000819080E00170000194000011908030042030100194000010819080A00170000190803004203010007020600030000312C320102060011000500E200FD000A001200010019010E010000FD000A00120002001801D80000000102060012000300180106002900120004001701000000000000000000004B0003FF1300440D0004C044100004C0064332000000411B0001020600120005001001FD000A00130001009C010D01000001020600130002009D01FD000A00130003009E010C010000BE000A00130004000F01E2000500FD000A00140001009C010B010000FD000A00140002009D010A0100007E020A00140003009F0100001240BE000A00140004000F01E20005000102060014000A00E200FD000A00150001009C010901000001020600150002009D017E020A0015000300A00100000440BE000A00150004000F01E20005000102060015000A00E200FD000A00160001009C0108010000FD000A00160002009D01070100007E020A00160003009F0101C09940FD000A00160004000F01A60000000102060016000500E2000102060016000A00E200FD000A00170001009C010601000001020600170002009D017E020A0017000300A00101B07240BE000A00170004000F01E20005000102060017000A00E200FD000A00180001009C0105010000FD000A00180002009D01040100007E020A0018000300A0010000F03FBE000A00180004000F01E20005000102060018000A00E200FD000A00190001009C0103010000FD000A00190002009D01020100007E020A0019000300A0010100E83FBE000A00190004000F01E20005000102060019000A00E200FD000A001A0001009C0101010000FD000A001A0002009D01000100007E020A001A000300A00100000000BE000A001A0004000F01E2000500FD000A001A000600D00049010000010206001A000A00E200FD000A001B0001009C01FF000000FD000A001B0002009D01FE0000007E020A001B000300A00100000000BE000A001B0004000F01E2000500010206001B000A00E200FD000A001C0001009C01FD000000FD000A001C0002009D01FC000000010206001C000300A001060045001C000400A101000000000000000000001D0004FF2F0043B40000001E00000D19021700430700000043B4000000064333000000411B0019080A001E00001908030042030100010206001C000500E200010206001C000A00E200FD000A001D0001009C01FB000000BE000A001D0002009D01A0010300060055001D000400A101000000000000000000000C0004FF3F0043B4000000194000011E0000194000010D19021B00439B000000434700000005433300000019400001411B0019080E001E0000194000011908030042030100010206001D0005001601010206001D000A00E200FD000A001E0001001301DF000000010206001E0002001201FD000A001E0003001501FA000000BE000A001E0004000F01E2000500010206001E000A00E200FD000A001F0001001301F9000000010206001F00020012017E020A001F000300140100000000BE000A001F0004000F01E2000500010206001F000A00E200D7004400762600006C0200008A00AE01D502670347034B023103E1036202420257019D00DA00D70038003801EC005D00340042003E004C003E004200420050004200830089003E0008021000200001000B00F0000000000000010F0008021000210001000B00F0000000000000010F0008021000220001000B00F0000000000000010F0008021000230001000B00F0000000000000010F0008021000240001000B00F0000000000000010F0008021000250001000B00F0000000000000010F0008021000260001000B00F0000000000000010F0008021000270001000B00F0000000000000010F0008021000280001000B00F0000000000000010F0008021000290001000B00F0000000000000010F00080210002A0001000B00F0000000000000010F00080210002B0001000B00F0000000000000010F00080210002C0001000B00F0000000000000010F00080210002D0001000B00F0000000000000010F00080210002E0001000B00F0000000000000010F00080210002F0001000B00F0000000000000010F0008021000300001000700F0000000000000010F0008021000310001000700F0000000000000010F0008021000320001000700F0000000000000010F0008021000330001000700F0000000000000010F0008021000340001000700F0000000000000010F0008021000350001000700F0000000000000010F0008021000360001000700F0000000000000010F0008021000370001000700F0000000000000010F0008021000380001000700F0000000000000010F0008021000390001000700F0000000000000010F00080210003A0001000700F0000000000000010F00080210003B0001000700FF000000000000010F20080210003C0001000700FF000000000000010F10080210003D0001000700F0000000000000010F00080210003E0001000700F0000000000000010F00080210003F0001000700FF000000000000010F20FD000A00200001001301F8000000010206002000020012017E020A0020000300110100000000BE000A00200004000F01E20005000102060020000A00E200FD000A00210001007F01F700000001020600210002008001060041002100040081010000000000000840000003000BFF2B0043530000001E00000D190213001940000143BE00000043530000000619080A001E000019080300420301000102060021000500E2000102060021000A00E200FD000A00220001007F01F6000000FD000A00220002008001F50000007E020A0022000300810100409F40FD000A00220004000F01A60000000102060022000500E2000102060022000A00E200FD000A00230001007F01F4000000FD000A00230002008001F30000007E020A0023000300D8010070B740BE000A00230004000F01E20005000102060023000A00E200FD000A00240001007F01F2000000FD000A00240002008001F10000007E020A0024000300820101002440060029002400040087010000000000407A4000000D000EFF130043BA00000043BB000000054332000000411B00010206002400050010010102060024000A00E200FD000A00250001007F01F0000000FD000A00250002008001EF0000007E020A0025000300EB0101002840BE000A00250004000F01E2000500FD000A00260001007F01EE000000FD000A00260002008001ED0000007E020A0026000300EB0101001040BE000A00260004000F010D010500FD000A00270001007F01EC000000FD000A00270002008001EB0000007E020A0027000300830101005440BE000A00270004000E010D010500FD000A00280001008401EA000000FD000A0028000200850142010000BE000C00280003008601D9010D010500FD000A00290001008401E9000000FD000A0029000200850148010000BE000C00290003008601D9010D010500FD000A002A0001008801E8000000FD000A002A0002008901E7000000010206002A000300890106001B002A0004008A01295C8FC2F528E43F000003000FFF05004337000000010206002A0005000D01FD000A002B0001008801E6000000FD000A002B0002008901E5000000010206002B000300890106001B002B0004008A01EC51B81E85EBC13F00000D000FFF0500435D000000010206002B000500E200FD000A002C0001008801E4000000FD000A002C0002008901E3000000010206002C000300890106001B002C0004008A019A9999999999A93F0000050010FF050043AB000000010206002C000500E200FD000A002D0001008801E2000000FD000A002D0002008901E1000000010206002D000300890106001B002D0004008A01000000000000E03F0000060010FF05004371000000010206002D000500E200FD000A002E0001008B01CB000000FD000A002E0002008901E0000000010206002E000300890106001B002E0004008C01B81E85EB51B8DE3F000009000FFF05004317000000010206002E000500E200FD000A002F0001008B01DF000000BE000A002F00020089018901030006001B002F0004008C0100000000000000000000120004FF0500438C000000010206002F000500E200FD000A00300001008B01CD000000FD000A00300002008901DE0000000102060030000300890106001B00300004008C017B14AE47E17A843F000008000FFF0500436B0000000102060030000500E200FD000A00310001008B01DD000000FD000A00310002008901DC0000000102060031000300890106001B00310004008C01000000000000000000003E0004FF050043640000000102060031000500E200FD000A00320001008B01DB000000FD000A00320002008901DA0000000102060032000300890106001B00320004008C01000000000000000000002F0004FF050043920000000102060032000500E200FD000A00330001008B01D9000000FD000A00330002008901D80000000102060033000300890106001B00330004008D010000000000000000000005000EFF0500432C0000000102060033000500E200FD000A00340001008B01D7000000BE000A003400020089018901030006001B00340004008D0100000000000000000000080019FF050043B70000000102060034000500E200FD000A00350001008E01D6000000BE000A00350002008F018F01030006002D003500040090012085EB51B81EF53F00000E000FFF1700433700000043AB00000003437100000003435D000000030102060035000500E200FD000A00360001008E01D5000000BE000A00360002008F018F01030006002D003600040090013E0AD7A3703DEA3F00003A0004FF1700433800000043AC00000003437200000003435E000000030102060036000500E200FD000A00370001008E01D4000000BE000A00370002008F018F01030006002D003700040090010BD7A3703D0AD73F0000360004FF1700433A00000043AE000000034374000000034360000000030102060037000500E200FD000A00380001009101D3000000BE000A003800020092019201030006006100380004009301F6285C8FC2F5FC3F0000430003FF4B004346000000194000011E0000194000010B19022500194000014323000000432700000003432C00000019400001034332000000411B001908100019400001232300000019080300420301000102060038000500E200FD000A00390001009101D2000000BE000A003900020092019201030006003300390004009301E17A14AE47E1EA3F0000FA0FB0FD1D00194000014324000000432800000003432D000000034332000000411B000102060039000500E200FD000A003A0001009101D1000000BE000A003A000200920192010300060033003A00040093010AD7A3703D0AD73F0000390004FF1D00194000014325000000432900000003432E000000034332000000411B00010206003A000500E200BE0010003B0001000A01090109010801E2000500FD000A003C0001000701D0000000BE000C003C0002000601060105010400FD000A003D0001000401CF000000010206003D00020003017E020A003D00030002010000F03F010206003D00040001017E020A003D000500D0000000F03FFD000A003D000600D000CE000000FD000A003E000100E300CD000000BE000A003E000200E200E2000300060079003E000400E1002D431CEBE2364A3F000008000EFF630043200000001E01000B190239004348000000439B000000051543B40000001E00000D19021000430700000043B4000000061519080A001E0000190803004203010003190810002305000000194000011908030042030100433300000019400001411B007E020A003E000500D00000000000FD000A003E000600D000CC000000FD000A003F0001000001CB000000BE000A003F000200FF00FF00030006004C003F000400FE005396218E7571BB3F000004000EFF360043200000001E01000B190210004347000000439B00000005151908100023030000001940000119080300420301004333000000411B00D7004400620C00006C023E0071004C0042006B003800380038002C002C004F004F004F004F004F0045004F004F004F004F0045005700570057008B005D005D0014001E004C00B500080210004000010007000E010000000000010F3008021000410001000700FF000000000000010F1008021000420001000700F0000000000000010F0008021000430001000700F0000000000000010F0008021000440001000700FF000000000000010F2008021000450001000700FF000000000000010F1008021000460001000700F0000000000000010F0008021000470001000700F0000000000000010F0008021000480001000700FF000000000000010F2008021000490001000700FF000000000000010F10080210004A0001000700F0000000000000010F00080210004B0001000700F0000000000000010F00080210004C0001000700FF000000000000010F20080210004D0001000700FF000000000000010F10080210004E0001000700F0000000000000010F00080210004F0001000700FF000000000000010F2008021000500001000A00FF000000000000010F1008021000510001000A00A3020000000040010F0008021000520001000A00F0000000000000010F0008021000530001000A00F0000000000000010F0008021000540001000A00F0000000000000010F0008021000550001000A00FF000000000000010F2008021000560001000A00FF000000000000010F1008021000580001000A000E010000000040010F00080210005B0001000A00F0000000000000010F00080210005C0001000A00F0000000000000010F00BE000C0040000100FD00FC00FC000300FD000A0040000400FB00A6000000FD000A0041000100FA00CA000000BE000C0041000200F900F900F8000400FD000A0042000100F700C90000000102060042000200F6007E020A0042000300F500000000000102060042000400F400FD000A0043000100F300C80000000102060043000200F2000600610043000300F100000000000000000000002D0004FF4B0043230000001E00000D19022F0043BA000000432300000006154309000000054332000000411B001519400001433000000003439E0000000319080E001E00001940000119080300420301000102060043000400F000BE000E0044000100E300E200E200E1000400FD000A0045000100EF00C7000000BE000C0045000200EE00EE00ED000400FD000A0046000100EC00C60000000102060046000200EB007E020A0046000300EA00000000000102060046000400E900FD000A0047000100E800C50000000102060047000200E7000600430047000300E60000000000000000000000320004FF2D00439B0000001E00000D19020F00431D000000439B0000000619080A001E000019080300420301001E0600411B00BE000A0047000400E500E4000500BE000E0048000100E300E200E200E1000400FD000A0049000100E000C4000000BE000C0049000200DF00DF00DE000400FD000A004A000100DD00C3000000010206004A000200DC007E020A004A000300DB0000000000010206004A000400DA00FD000A004B000100D900C2000000010206004B000200D8000600DD004B000300D700000000000000000000000B0010FFC700439B0000001E00000D1902390043B40000001E00000D19021D0043B6000000430700000043B400000006150415439B0000000619080A001E0000190803002203010019080E001E00001940000119080300420301001E00000D19025500439B0000001E00000D1902390043B40000001E00000D19021D0043B6000000430700000043B400000006150415439B0000000619080A001E0000190803002203010019080A001E0000190803002203010019080E001E00001940000119080300420301001E0600411B00010206004B000400D600BE000E004C000100D500D400D400D3000400FD000A004D000100630141010000010206004D00020064017E020A004D000300640100001040010206004D0004006501FD000A004E000100D900C1000000010206004E000200D8007E020A004E000300D80000000000010206004E000400D600FD000A004E000600D000C0000000BE000E004F000100D500D400D400D3000400FD000A0050000100A501BF0000000102060050000200A201FD000A0050000300A201440100000102060050000400A701FD000A0051000100A601960000000102060051000200A301FD000A0051000300010243010000BE001200510004000102010201020102A801A8010900FD000A0052000100A601BE0000000102060052000200A301FD000A0052000300A301450100000102060052000400A301FD000A0053000100A601BD0000000102060053000200A301FD000A0053000300A301460100000102060053000400A301FD000A0054000100A601BC0000000102060054000200A301FD000A0054000300A301470100000102060054000400A301FD000A0055000100E9014B0100000102060055000200A4017E020A0055000300A4010000F03F0102060055000400A401010206005B000100D200010206005C000300D100D7003800FD060000F4011E001E003000870012001E0030006D0012001E0030000301120030003E00120030003C003000300030003000000000000A00C201DC0224000300040009010B005C0024000300040009030E00A80124000300040009050F000D1924000300030009051000000D25000400030009010B43070025000400030009070F0415432500040003000909101E000026000500040009010B080E003E000500030009040D0300421B000500040009040E55004326000500030009070F02390026000500030009091019021D27000600040009010B00004327000600030009070F9B00002700060003000909101908032B000700030009010B1E00002B000700030009070F080E002B00070003000909100300422D000800030009010B00411B2D000800030009030D00411B2E000800040009050E00411B2D000800030009070F00411B2D00080003000909100100421E00080004000903170000003300080004000909220002001A00090004000903040000002E000900040009010B0000002E000900030009030D0000002E000900030009070F0000002E00090003000909100001002F000A00040009010B0000002F000A00040009030D0000002F000A00030009070F0000002F000A0003000909100000002C000B00040009030D0000002C000B00030009070F0000002C000B0003000909100000000A000D0003000901040000003C000D00040009090E00000025000E00030009030F0000003E001000040009040B00000036001000040009090E0000003E001000030009070F0000003E00100003000909100000002000110004000903040000001E001200030009030400000021001C0004000909040000001400210003000908040000001B002400040009080400000026002C0004000905040000002C002E0003000903040000002D00300003000905040000003E00330003000905040000000E00340003000902040000003F00360004000905040000002400370003000909040000002900380003000905040000003F00390003000907040000003F003A0003000909040000002400430003000907030000002C004B000300090503000000EC00C8000F0002F048020000200008F00800000005000000040400000F0003F0300200000F0004F028000000010009F0100000000000000000000000000000000000000002000AF00800000000040000050000000F0004F078000000A20C0AF00800000001040000000A000093000BF036000000800080925B0B8B0002000000BF00080008005801000000008101FFFFE1008301FFFFE1000102000000003F0203000300BF0302000200000010F0120000000300040095004D0069000500B9035100F500000011F0000000005D003400150012001900010011400000000000000000000000000D0016007A2BBE7C9AB44F4D9DF1F5FD64FB8E9000001000000000000000EC00080000000DF000000000B60112001202000000000000000058001800000000003C005900006A636F6C696E3A0A5365207574696C697A61207061726120636F6E73696465726172206F206E6F206C6F7320696E73756D6F73207061726120656C2063E16C63756C6F2064656C20636F73746F2064656C2045717569706F3C00180000000F000000000007001000000000005800FF7F00000000EC0078000F0004F078000000A20C0AF00800000002040000000A000093000BF0360000008000C0925B0B8B0002000000BF00080008005801000000008101FFFFE1008301FFFFE1000102000000003F0203000300BF0302000200000010F01200000003000D004800010072000D00B3020500D000000011F0000000005D003400150012001900020011400000000000000000000000000D00160039D004105D6E0440AF6BD6A40414A2C30000BF00080000000000EC00080000000DF000000000B60112001202000000000000000078001800000000003C007900006A636F6C696E3A0A5365207574696C697A61207920736520636F6E73696465726120656E20656C2063E16C63756C6F207061726120736162657220736920736520646976696465206F206D756C74696D706C6963612070617261207361636172206C61206578706C6F7369F36E20646520496E73756D6F733C00180000000F000000000007001000000000007800FF7F00000000EC0078000F0004F078000000A20C0AF00800000003040000000A000093000BF036000000800000935B0B8B0002000000BF00080008005801000000008101FFFFE1008301FFFFE1000102000000003F0203000300BF0302000200000010F0120000000300040095004C0088000500B9035000A600000011F0000000005D003400150012001900030011400000000000000000000000000D001600EEAA69D1793B1046B001F769A5A457E70000BF00080000000000EC00080000000DF000000000B60112001202000000000000000088001800000000003C008900006A636F6C696E3A0A45737461207661726961626C6520657320696E7465726E612079206E6F2070726F7669656E652064656C2073697374656D612C2061666563746120706F74656E636961206465206F706572616369F36E2C206361626E746964616420646520636F6D6275737469626C652C2063616E7469646164206C6962726963616E74650A3C00180000000F000000000007001000000000008800FF7F00000000EC0078000F0004F078000000A20C0AF00800000004040000000A000093000BF036000000800040935B0B8B0002000000BF00080008005801000000008101FFFFE1008301FFFFE1000102000000003F0203000300BF0302000200000010F012000000030004009500540040000500B9035800E400000011F0000000005D003400150012001900040011400000000000000000000000000D001600DB3B10E9EB96A54D94FF4DEF949766740000BF00080000000000EC00080000000DF000000000B60112001202000000000000000089001000000000003C008A00006A636F6C696E3A536920656C2076616C6F72206573746120656E203120736520696D7072696D65206C6120646573637269706369F36E20636F6D706C657461207369206573746120656E203020736520696D7072696D65206C61206465736369706369F36E20636F7274612C2070617261206C61206F706572616369F36E207920636F6E73756D6F733C00100000000F00000000008900FF7F000000001C00120002000C00000002000600006A636F6C696E6F1C0012004D000300000003000600006A636F6C696E6F1C0012004E000300000001000600006A636F6C696E6F1C00120055000300000004000600006A636F6C696E6F3E021200B4000000000040000000000064006C6900008B0810008B080000000000000000000000006A691D000F00030000000000000100000000000000E500120002000100010001000200510051000300070067081700670800000000000000000000020001FFFFFFFF0344000071081D00710800000000000000000000050001FFFFFFFFFFFFFFFF0D0000000000720812047208010002000C000600090005000000000000010000000000000002000C0006000900000000000100000001000000000000000000000040000000663200000608DE0000000000000000000000000000000000000000000000000000000000000000000600005461626C61330400010000310100000000000000000000000000000000000000FFFFFFFF01000000B1000000FFFFFFFF01000030050000436172676F0003383C06800701430061006C00690062007200690000004E6366E5FE070000EC04000002000000FC0400001400000000000000000000000400000000000000040000000000B400000000000000BC02000000000000080000000000000000FFFFFF0000000000000000000000000100000000000000000000000100010000000000000000774020402000000000C0200000FFFF000002000D001400030000000100000000000000080000000E0005000200000000FFFF0200000000000000000000000000000000000000FFFFFFFF01000000B1000000FFFFFFFF010000300600004163746976610003383C06800701430061006C00690062007200690000004E6366E5FE070000EC04000002000000FC0400001400000000000000000000000400000000000000040000000000B4000000000000009001000000000000080000000000000000FFFFFF0000000000000000000000000100000000000000000000000100030000000000000011774020402000000000C0200000FFFF000002000D001400030000000100000000000000080000000E0005000200000000FFFF0300000000000000000000000000000000000000FFFFFFFF01000000B1000000FFFFFFFF010000300600004573706572610003383C06800701430061006C00690062007200690000004E6366E5FE070000EC04000002000000FC0400001400000000000000000000000400000000000000040000000000B4000000000000009001000000000000080000000000000000FFFFFF0000000000000000000000000100000000000000000000000100030000000000000011774020402000000000C0200000FFFF000002000D001400030000000100000000000000080000000E0005000200000000FFFF0400000000000000000000000000000000000000FFFFFFFF01000000B1000000FFFFFFFF01000030070000526573657276610003383C06800701430061006C00690062007200690000004E6366E5FE070000EC04000002000000FC0400001400000000000000000000000400000000000000040000000000B4000000000000009001000000000000080000000000000000FFFFFF0000000000000000000000000100000000000000000000000100030000000000000000774020402000000000C0200000FFFF000002000D001400030000000100000000000000080000000E0005000200000000FFFF770866007708000000000000000000000000010000000A000000FFFFFFFF0A000000FFFFFFFF00000000FFFFFFFF0E0000000E00000000000000FFFF38A006800000C020FFFF38A006800000C020FF033F9006801111402040200000FFDF3F900280001000000020000077082700770800000000000000000000010001000000048A1000005461626C655374796C654C696768743177081E007708000000000000000000000200010000000600005461626C61330000000A00000009081000000610006632CD07C9800100060600000B021C00000000000000000041000000DAB401003DCF010067ED0100C3ED01000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C104140009000600002652263826501500000083000200000084000200000026000800BA5C2E97CBE5E23F270008004D2693C96432C93F28000800EE76BBDD6EB7DB3F29000800180C0683C160E03F4D003E0600005C005C006E0065006F0064006100740061007300650072007600650072005C004800500020004C0061007300650072004A00650074002000500032000000000001040201DC00600503FF8007010001000000000064000100070058020100010058020100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000002000000010000000100000000000000000000000000000000000000020100004800500020004C0061007300650072004A0065007400200050003200300031003400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003C060000EC0B000000000000000000003C060000B00600000000000013000000EC130000C8190000010000000000000000000000000000000000000000000000000000000100000001000000030000000100000064000000010000000F27000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000100000000000000960000000000000034000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040170000E2200000FFFFFFFF0000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000013000000000000000100000000000000010000000100000000000000010000000000000000000000020000000000000000000000000000000100000001000000010000000000000000000000020000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040170000E22000000000000000000000000000000000000000000000640000000000000000000000000000006400000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000000000000000000000000000000000000000000000000000000FFFFFFFF40170000E2200000010000000100000000000000000000000000000001000000010000000100000001000000A1002200010055000100010001000200580258020A8542A15028D43F52B81E85EB51D83F01009C0826009C080000000000000000000000000000000000000000000000000000E4510000000000000000550002000A007D000C0000000000DB015B00020000007D000C0001000100490D5B00020000007D000C000200020000155B00020000007D000C000300030024145B00020000007D000C0004000400240E5B00020000007D000C0005000500000B5B00020000007D000C0006000600DB045B00020000007D000C0007000700000B5B00020000007D000C000800080024085B00020000007D000C0009000900490B5B00020000007D000C000A0000016D0B5B000000000000020E00000000004100000001000A00000008021000000001000A003C000000000040010F2008021000010001000A000E010000000000010F1008021000020001000A00FF000000000000010F0008021000030001000A00FF000000000040010F0008021000040001000A00FF000000000040010F0008021000050001000A002C010000000040010F0008021000060001000A001D010000000040010F0008021000070001000A003B010000000040010F0008021000080001000A00C1020000000040010F0008021000090001000A00FF000000000040010F00080210000A0001000A00FF000000000040010F00080210000B0001000A00FF000000000040010F20080210000C0001000A001D010000000000010F30080210000D0001000A00FF000000000040010F10080210000E0001000A00FF000000000000010F00080210000F0001000A00FF000000000000010F0008021000100001000A00FF000000000000010F0008021000110001000A00FF000000000000010F0008021000120001000A000E010000000000010F2008021000130001000A004B000000000040010F3008021000140001000A000E010000000000010F1008021000150001000A00FF000000000000010F0008021000160001000A00FF000000000000010F0008021000170001000A00FF000000000000010F0008021000180001000A00FF000000000000010F0008021000190001000A00FF000000000000010F00080210001A0001000A00FF000000000000010F00080210001B0001000A00FF000000000000010F00080210001C0001000A00FF000000000000010F00080210001D0001000A00FF000000000000010F00080210001E0001000A00FF000000000000010F00080210001F0001000A00FF000000000000010F00FD000A0001000100CF00BB00000006001B00010002000202000000000000FFFF00000B0004FF0500437800000007028E008B000053697374656D6120646520436F6D756E69636163696F6E65732079205472616E73706F727465732C2053697374656D61206465205472616E73706F72746520436F6C65637469766F204D6574726F2C2041646D696E69737472616369F36E2047656E6572616C206465205265637572736F732C204CED6E656120313220284CED6E656120446F7261646129BE00140001000300020202020202CE00CE00CD00CC000900BE00180002000100C4000302030203020302C100C100C900C8000900BE00180003000100C4000302030203020302C100C100C900CB000900FD000A0004000100C400BA00000006001B00040002006700000000000000FFFF0000010002FF0500437E000000070211000E0000323030392F303235372D30303031FD000A0004000300CA00B900000006001B0004000400F40100000000208AE34000003B0007FE0500434E000000BE00100004000500C200C100C100C900C8000900FD000A0005000100C400B800000006001B00050002000C02000000000000FFFF0000250001FF050043790000000702F701F401003132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930BE001400050003000C020C020C020D02C100C700C6000900BE00180006000100C4000C020C020C020C020D02C100C200C5000900BE00180007000100C4000C020C020C020C020D02C100C200C5000900BE00160008000100C4000C020C020C020C020D02C100C2000800FD000A0008000900FF0152010000FD000A0009000100C400B70000000600510009000200D401000000000000FFFF0000040002FF3B00433F000000194000011701002C194000010819400001430D0000001940000108194000011701002C19400001081940000143450000001940000108070242003F00005472616D6F2064652042617272616E63612064656C204D756572746F206120546C61687561632E2C4DE97869636F2C446973747269746F204665646572616CBE00140009000300D401D401C200C100C100C000FD01090006001B000A0001001202000100000000FFFF0000140008FF050043A1000000070218001500004E656F646174612C20532E412E20646520432E562EBE000A000A00020013021402030006001B000A000400D501000200000000FFFF0000050002FF050043A400000007021A001700004A4F524745204C2E2044C156414C4F53204D4943454C49BE000E000A000500BE00BD00BD00D7010800FD000A000A000900FE0150010000FD000A000B0001001502B5000000BE000A000B00020016021702030006001B000B000400BB00000200000000FFFF00000A0004FF05004308000000070213001000004449524543544F522047454E4552414CBE000C000B000500BA00B900B9000700FD000A000B000800BC00A6000000FD000A000B000900FC0151010000FD000A000C0001000A02B4000000BE0016000C0002000A020A020A020A020A020A020A020A020900BE000A000D000100A901AA010200FD000A000D0003000B02B3000000BE0012000D0004000B020B02AB01AB01AB01AC010900FD000A000E000100AD01B200000006001B000E000200AE01000000000000FFFF0000110003FF0500430F00000007020C000900004551504554524F3031FD000A000E000300AF01AE00000006001B000E000400AE01000000000000FFFF00000E0007FF0500437700000007020B00080000502D323030392D31010206000E000500B101FD000A000E000600AF01AD00000006001B000E000700B001000000000000FFFF0000120008FF050043060000000702090006000038303030204CBE000A000E000800B201B301090006001B000F0001000602000100000000FFFF0000110008FF0500433C00000007026400610000504554524F4C495A41444F5241202044452038303030204C542E20204445203135352048502C204D4F544F522056414D204D4F442E363535382020424F4D424120373536204C504D20424152524120332E3636204D2053494E204348415349532EBE000E000F000200070207020702B4010500FD000A000F000600B501AB00000006001B000F000700B601000000000000FFFF0000100007FF0500437F000000070213001000005753513434353735372D534445343435BE000A000F000800B701B8010900BE001000100001000802090209020902B9010500FD000A0010000600BA01AA00000006001B0010000700BB01000000000000FFFF0000140001FF0500431500000007020B000800004741534F4C494E41BE000A0010000800B701B80109000102060011000100C801FD000A0011000200C901B100000006001B0011000300CA01000000000000FFFF00000F0001FF05004356000000070222001F00004365746573206120323820646961732064656C2031342F7365702F32303039BE000C0011000400CB01CC01B2010600FD000A0011000700C901B000000006001B0011000800FA01B81E85EB51B8BE3F0000120003FF050043B00000000102060011000900B3010102060012000100CD01FD000A0012000200CE01AF00000006001B0012000300CF01000000000000FFFF00000E0004FF0500435700000007022A00270000546173612064652053656775726F7320416D65726963612064656C2031342F7365702F32303039BE000C0012000400D001D101D2010600FD000A0012000700CE01AC00000006001B0012000800FB017B14AE47E17AA43F00000F0007FF0500439F0000000102060012000900D301BE00180013000100A100C301C401C501C601A100C301C701A100090006001D0014000100BC01000100000000FFFF0000140003FF07005A0100030001C00702180015000050524543494F204445204144515549534943494F4E0102060014000200BD0106001B0014000300BE01000000000068B0400000150001FF0500439C000000BE000C0014000400BF01C001B8000600FD000A0014000700B700A900000006001B0014000800C10100000000000008400000090002FF050043BD0000000102060014000900C2010600380015000100B100000000000000FFFF0000150003FF22005A0100040001C01702002028085A0100040002C0081940000117010029194000010807021C0019000050524543494F204A5545474F204C4C414E5441532028506E290102060015000200B00006001B0015000300B20000000000000000000000150007FF0500439E000000BE000C00150004006400AD00AC0006000600420015000700AB00000000000000FFFF0000150008FF2C005A0100220001C01940000117030020202819400001085A0100220002C0194000010819400001170200293A0807021800150000484F52415320504F522041D14F202028486561293A06001B001500080066010000000000409F400000160003FF05004353000000FD000A0015000900AA00A7000000FD000A0016000100B100A80000000102060016000200B00006001B0016000300B20000000000000000000000160007FF0500439D000000BE000C0016000400B600AD00AC00060006003D0016000700AB00000000000000FFFF0000170001FF27005A0100230001C0194000011702002028085A0100230002C0194000010819400001170200293A0807021700140000564944412045434F4E4F4D49434120285665293A06001B00160008006601000000000070B74000001E0003FF050043BE000000FD000A0016000900AA00A70000000600380017000100B100000000000000FFFF0000170003FF22005A0100060001C01702002028085A0100060002C0081940000117010029194000010807022900260000564944412045434F4E4F4D494341204445204C4C414E54415320284A7565676F292028566E290102060017000200B00006001B0017000300AF0000000000000000000000170007FF050043BF000000FD000A00170004006800A1000000BE000A0017000500AD00AC00060006003D0017000700AB00000000000000FFFF0000170008FF27005A0100140001C0194000011702002028085A0100140002C0194000010819400001170200293A0807021A00170000434F53544F20434F4D4255535449424C4520285063293A06001B0017000800660100000000000012400000180001FF05004326000000FD000A0017000900B500A50000000600440018000100B100000000000000FFFF0000180003FF2E005A0100070001C019400001170200202819400001085A0100070002C019400001081940000117010029194000010807021E001B000050524543494F20505A415320455350454349414C455320285065290102060018000200B00006001B0018000300B20000000000000000000000180007FF05004330000000BE000C00180004006400AD00AC00060006003D0018000700AB00000000000000FFFF0000180008FF27005A0100160001C0194000011702002028085A0100160002C0194000010819400001170200293A0807021900160000434F53544F204C5542524943414E544520285061293A06001B001800080066017B14AE47E17A30400000190001FF0500432B000000FD000A0018000900B500A50000000600450019000100B100000000000000FFFF0000190003FF2F005A0100080001C0194000011703002020281940000108194000015A0100080002C01940000108194000011701002908070222001F0000564944412045434F4E4F4D49434120505A41532045535045432020285661290102060019000200B00006001B0019000300AF0000000000000000000000190008FF050043C0000000FD000A00190004006800A1000000BE000A0019000500AD00AC000600FD000A0019000700AB00A400000006001B00190008006601000000000000544000001A0001FF0500439A000000FD000A0019000900AA00A3000000060041001A000100B100000000000000FFFF00001A0007FF2B005A0100090001C01940000117030020202819400001085A0100090002C0194000010819400001170100290807021C0019000056414C4F52204445204C41204D415155494E41202028566D29010206001A000200B00006001B001A000300B200000000000068B04000002B0009FF050043BA000000BE000C001A0004006400AD00AC00060006003D001A000700AB00000000000000FFFF00001A0008FF27005A01000B0001C0194000011702002028085A01000B0002C0194000010819400001170200293A0807021C00190000464143544F52204445204F504552414349D34E2028466F293A06001B001A0008006601DC114E0B5EF4553F00001B0001FF0500434A000000010206001A000900B400060041001B000100B100001100000000FFFF00001B0003FF2B005A0100240001C01940000117030020202819400001085A0100240002C0194000010819400001170100290807021A0017000056414C4F52204445205245534341544520202028567229010206001B000200B00006001B001B000300B3009A9999999999B93F00001B0007FF050043BB00000006001B001B000400B2000000000000407A400000240003FF050043BC000000BE000A001B000500AD00AC000600060041001B000700AB00000000000000FFFF00001C0001FF2B005A01000C0001C019400001170200202819400001085A01000C0002C0194000010819400001170200293A0807021F001C0000504F54454E434941204445204F504552414349D34E2028506F70293A06001B001B00080066015396218E7571BB3F00002B0005FF0500439B000000010206001B000900AA00060040001C000100B100009600000000FFFF00001C0003FF2A005A0100250001C019400001170200202819400001085A0100250002C0194000010819400001170100290807021C001900005441534120444520494E544552455320414E55414C20286929010206001C000200B00006001B001C000300EA01B81E85EB51B8BE3F00001C0007FF050043B0000000BE000C001C0004008100AD00AC00060006003D001C000700AB00000000000000FFFF00001C0008FF27005A0100270001C0194000011702002028085A0100270002C0194000010819400001170200293A08070220001D0000464143544F52204445204D414E54454E494D49454E544F20284B6F293A06001B001C00080066019A9999999999E93F00001D0001FF05004349000000010206001C000900AA00060040001D000100B100009900000000FFFF00001D0003FF2A005A0100260001C019400001170200202819400001085A0100260002C01940000108194000011701002908070226002300005052494D4120414E55414C2050524F4D4544494F2044452053454755524F5320287329010206001D000200B00006001B001D000300EA017B14AE47E17AA43F00001D0007FF0500439F000000BE000C001D0004008100AD00AC00060006003D001D000700AB00000000000000FFFF00001D0008FF27005A0100180001C0194000011702002028085A0100180002C0194000010819400001170200293A08070220001D0000434F4546494349454E544520434F4D4255535449424C4520284663293A06001B001D0008006601000000000000F03F00001E0001FF05004347000000010206001D000900AA00060040001E000100B100000000000000FFFF00001E0007FF2A005A01000D0001C019400001170200202819400001085A01000D0002C01940000108194000011701002908070220001D000053414C4152494F205245414C2044454C204F50455241444F5220285329010206001E000200B00006001B001E000300B200000000000000000000002C0005FF050043A7000000BE000C001E0004009300AD00AC000600060041001E000700AB00000000000000FFFF00001E0008FF2B005A0100190001C019400001170200202819400001085A0100190002C0194000010819400001170200293A0807021F001C0000434F4546494349454E5445204C5542524943414E544520284661293A06001B001E0008006601B81E85EB51B87E3F00001F0001FF05004348000000010206001E000900AA0006003C001F000100B100001E00000000FFFF00001F0007FF26005A0100120001C0194000011702002028085A0100120002C0194000010819400001170100290807022600230000434F53544F20504F522053414C4152494F204445204F504552414349D34E2028506F29010206001F000200B00006001B001F000300B200000000000000000000003E0005FF0500432C000000BE000C001F0004009300AD00AC000600060039001F000700AB00000000000000FFFF00001F0008FF23005A01001A0001C0194000011702002028085A01001A0002C00819400001170200293A0807021D001A00004341504143494441442044454C2043415254455220284343293A06001B001F000800660100000000000000000000200001FF05004307000000FD000A001F000900AA00A2000000D70044009B1900006C020000D7001C001C00830040021C001C002800C100A6007E0028003200CB00EB005E00A400AC001C00AD002401D0003A012E01EF0028014A012B013501320108021000200001000A00FF000000000000010F0008021000210001000A000E010000000000010F2008021000220001000A001D010000000000010F3008021000230001000A0078000000000040010F1008021000240001000A00FF000000000000010F0008021000250001000A00FF000000000000010F0008021000260001000A00FF000000000000010F0008021000270001000A00FF000000000000010F0008021000280001000A0069000000000040010F0008021000290001000A000E010000000000010F20080210002A0001000A001D010000000000010F30080210002B0001000A000E010000000000010F10080210002C0001000A00FF000000000000010F00080210002D0001000A00FF000000000000010F00080210002E0001000A00FF000000000000010F00080210002F0001000A00FF000000000000010F0008021000300001000A00FF000000000000010F0008021000310001000A00FF000000000000010F0008021000320001000A00FF000000000000010F0008021000330001000A00FF000000000000010F0008021000340001000A00FF000000000000010F0008021000350001000A0078000000000040010F0008021000360001000A00FF000000000000010F0008021000370001000A0078000000000040010F0008021000380001000A000E010000000000010F2008021000390001000A001D010000000000010F30080210003A0001000A000E010000000000010F10080210003B0001000A00FF000000000000010F00080210003C0001000A00FF000000000000010F00080210003D0001000A00FF000000000000010F00080210003E0001000A000E010000000000010F20080210003F0001000A001D010000000000010F3006003C0020000100B100000000000000FFFF0000200007FF26005A0100100001C0194000011702002028085A0100100002C0194000010819400001170100290807022C00290000484F524153204546454354495641532044452054524142414A4F20504F52205455524E4F20284874290102060020000200B00006001B0020000300E801000000000000FFFF00002F0003FF0500435200000007020600030000312C32FD000A0020000400AE00A1000000BE000A0020000500AD00AC00060006003D0020000700AB00000000000000FFFF0000200008FF27005A01000F0001C0194000011702002028085A01000F0002C0194000010819400001170200293A0807021E001B0000464143544F522044452052454E44494D49454E544F20284672293A06001B00200008006601000000000000F03F0000210001FF0500434C0000000102060020000900AA0006003C0021000100A900000000000000FFFF0000210003FF26005A01001B0001C0194000011702002028085A01001B0002C01940000108194000011701002908070229002600005449454D504F20454E5452452043414D42494F204445204C5542524943414E544520284361290102060021000200A80006001B0021000300A70000000000000000000000210009FF050043B4000000FD000A0021000400A600A1000000BE000A0021000500A500A4000600FD000A0021000800A300A00000000600210021000900A20000000000000000000000240001FF0B00431E0000001E0400411B00FD000A002200010068019F00000001020600220002006901FD000A00220003006A019E00000001020600220004006A01FD000A00220005006B019D000000FD000A00220006006B019B000000FD000A00220007006B019C000000FD000A00220008006B019B000000FD000A00220009006C019A000000BE00180023000100A0009F009F009F009F0073009B0073009E00090006001B00240001006900000000000000FFFF0000240006FF050043350000000702280025000061292E2D20444550524543494143494F4E2E2E2E2E2E2E2E44203D28566D2D5672292F56650102060024000200730006001B00240003006800000000000000FFFF0000380005FF0500433600000007021B001800002824342C3230302E2D243432302E292F362C3030302E30300102060024000400680006001B00240005009B00295C8FC2F528E43F0000270003FF0500433700000006001B00240006009D00000000000000F03F0000240008FF0500433900000006001B00240007009B00295C8FC2F528E43F0000270005FF0500433800000006001B00240008009D00333333333333C33F0000250006FF0500433B00000006001B002400090098000AD7A3703D0AB73F00003F0005FF0500433A00000006001B0025000100900000D700000000FFFF0000270001FF0500435B00000007025B002C0001620029002E002D00200049004E00560045005200530049004F004E0026202E002E002E002E002E002E002E002E002E002E006C006D0020003D002000280056006D002B005600720029002A0069002F00320048006500610001020600250002008F0006001B00250003008E00000000000000FFFF0000260005FF0500435C000000070225002200002824342C3230302E2B243432302E297831322E3030303020252F283278323030302901020600250004008E0006001B00250005009B00EC51B81E85EBC13F0000250009FF0500435D00000006001B00250006009D00000000000000F03F0000250008FF0500435F00000006001B00250007009C00EC51B81E85EBC13F00002D0005FF0500435E00000006001B00250008009D00000000000000F03F0000260006FF0500436100000006001B00250009009800EC51B81E85EBC13F0000250007FF0500436000000006001B00260001009000005100000000FFFF00002F0001FF050043A900000007024F00260001630029002E002D002000530045004700550052004F0053002620262026202E002E002E002E0053006D0020003D002000280056006D002B005600720029002A0073002F00320048006500610001020600260002008F0006001B00260003008E00000000000000FFFF00001B0004FF050043AA000000070226002300002824342C3230302E30302B243432302E30302978342E303020252F283278323030302901020600260004008E0006001B00260005009C009A9999999999A93F0000260009FF050043AB00000006001B00260006009900000000000000F03F0000260008FF050043AD00000006001B00260007009B009A9999999999A93F0000290005FF050043AC00000006001B00260008009900000000000000F03F0000270006FF050043AF00000006001B002600090098009A9999999999A93F0000260007FF050043AE00000006001B00270001006900009900000000FFFF00002B0001FF05004376000000070222001F000064292E2D204D414E54454E494D49454E544F2E2E2E2E2E4D203D204B6F2A440102060027000200730006002800270003006800000000000000FFFF0000250003FF120043490000001703002078200844240005C00807020D000A0000302E38207820302E36330102060027000400680006001B00270005009B00000000000000E03F0000270009FF0500437100000006001B0027000600990000000000000000000000270008FF0500437300000006001B00270007009B0000000000000000000000240009FF0500437200000006001B00270008009900333333333333C33F00002B0006FF0500437500000006001B002700090098007B14AE47E17AB43F0000270007FF05004374000000BE0018002800010069007300680068009B0099009A00990098000900BE000C00290001006300620061000300FD000A002900040060009900000006001B002900050097002085EB51B81EF53F0000240007FF050043230000000102060029000600960006001B002900070097003E0AD7A3703DEA3F0000FA0FB0FD050043240000000102060029000800960006001B002900090095000BD7A3703D0AD73F00003F0007FF05004325000000FD000A002A000100040298000000BE0016002A00020005026901690169016901690169016D01090006001B002B0001006900000100000000FFFF00002D0001FF0500431600000007024300200001610029002E00200043004F004D004200550053005400490042004C00450026202E0026202E002E0043006F003D00460063002A0050006F0070002A0050006300010206002B000200730006001B002B0003006800000000000000FFFF00002B0007FF0500431C000000070211000E00003178302E31303732782024342E35010206002B000400680006001B002B0005009300B81E85EB51B8DE3F00002E0001FF0500431700000006001B002B00060094009A9999999999A93F00002B0008FF0500431900000006001B002B00070093007B14AE47E17A943F00002C0003FF0500431800000006001B002B0008009100000000000000000000002C0001FF0500431B00000006001B002B0009008000000000000000000000002F0009FF0500431A00000006001B002C0001009000000000000000FFFF00002C0006FF0500438A00000007021F001C000062292E2D4F74726173204675656E74657320646520456E6572676961010206002C000200730006001B002C0003008E00000000000000FFFF00002E0007FF0500438B00000007020B00080000242E3030202A2030010206002C000400810006001B002C0005009300000000000000000000002C0009FF0500438C00000006001B002C00060094009A9999999999A93F00002C0008FF0500438800000006001B002C0007009300000000000000000000000E0002FF0500438E00000006001B002C0008009100000000000000000000002D0006FF0500438900000006001B002C0009008000000000000000000000002D0003FF0500438F00000006001B002D0001009000000000000000FFFF20002E0009FF0500436900000007025B002C0001630029002E0020004C007500620072006900630061006E007400650026202620262026202E002E002E002E004C0062003D005B002800460061002A0050006F00700029002B00430043002F00430061005D002A0050006100010206002D0002008F0006001B002D0003008E00000000000000FFFF2000200003FF0500436A000000070223002000005B28302E3030373578302E31303732292B302F305D2078202431362E34386C74010206002D0004008E0006001B002D00050066007B14AE47E17A843F00002D0007FF0500436B00000006001B002D00060081009A9999999999A93F00002D0008FF0500436D00000006001B002D000700660000000000000000000000380007FF0500436C00000006001B002D0008008100000000000000000000002E0005FF0500436F00000006001B002D000900800000000000000000000000380009FF0500436E00000006001B002E0001009000000000000000FFFF20003E0004FF0500436200000007023B001C0001640029002E0020004C006C0061006E0074006100730026202620262026202E0026202E002E002E002E004E003D0050006E002F0056006E00010206002E0002008F0006001B002E0003008E00000000000000FFFF2000330001FF0500436300000007020900060000242E30302F30010206002E0004008E0006001B002E0005009200000000000000000000002E0006FF0500436400000006001B002E0006009100333333333333C33F00002E0008FF0500436600000006001B002E0007009200000000000000000000001B0008FF0500436500000006001B002E0008009100000000000000000000002F0006FF0500436800000006001B002E0009008000000000000000000000002F0007FF0500436700000006001B002F0001009000000000000000FFFF20003E0009FF0500439000000007024500210001650029002E0020005000690065007A0061007300200045007300700065006300690061006C006500730026202E002E002E00410065003D00500065002F0056006100010206002F0002008F0006001B002F0003008E00000000000000FFFF2000360007FF05004391000000070208000500002430302F30010206002F0004008E0006001B002F0005008D00000000000000000000001A0003FF0500439200000006001B002F0006008100000000000000000000002F0008FF0500439400000006001B002F0007008D00000000000000000000002C0007FF0500439300000006001B002F000800810000000000000000000000320003FF0500439600000006001B002F000900800000000000000000000000260001FF05004395000000FD000A00300001008C0097000000BE001600300002008B008A008A00880089008800810080000900FD000A00310001000E029600000001020600310002000F02FD000A0031000300730195000000FD000A0031000400730194000000FD000A0031000500730193000000FD000A003100060073014C010000FD000A0031000700740191000000BE000A003100080087008000090006005100320001001002000000000000000000002E0003FF3B004354000000194000011E0100194000010B19020F00194000013A010003001CC019081600194000023A010003001DC01940000119080300420301000102060032000200110206001D0032000300860000000000000000000000320004FF07005A010003001EC006001D0032000400850000000000000000000000320005FF07005A0100030020C006001D0032000500840000000000000000000000320006FF07005A010003001FC006001D0032000600830000000000000000000000320007FF07005A0100030021C006001D0032000700820000000000000000000000330003FF07005A0100030022C0BE000A00320008008100800009000600510033000100100200000000000000000000340001FF3B004354000000194000011E0100194000010B19020F00194000013A010004001CC019081600194000023A010004001DC01940000119080300420301000102060033000200110206001D0033000300860000000000000000000000330004FF07005A010004001EC006001D0033000400850000000000000000000000330005FF07005A0100040020C006001D0033000500840000000000000000000000330006FF07005A010004001FC006001D0033000600830000000000000000000000330007FF07005A0100040021C006001D0033000700820000000000000000000000330009FF07005A0100040022C0FD000A00330008006E009000000006001B00330009006D0000000000000000000000360005FF050043B700000006005100340001001002000000000000000000003B0002FF3B004354000000194000011E0100194000010B19020F00194000013A010005001CC019081600194000023A010005001DC01940000119080300420301000102060034000200110206001D0034000300860000000000000000000000340004FF07005A010005001EC006001D0034000400850000000000000000000000340005FF07005A0100050020C006001D0034000500840000000000000000000000340006FF07005A010005001FC006001D0034000600830000000000000000000000340007FF07005A0100050021C006001D0034000700820000000000000000000000360004FF07005A0100050022C0BE000A0034000800810080000900BE000C00350001007E006F006F00030001020600350009007F00BE000C00360001007E006F006F00030006002F00360004007D00000000000000FFFF2000360006FF190017160053756D61206465204F74726F7320436F6E73756D6F730702190016000053756D61206465204F74726F7320436F6E73756D6F7306001B00360005007C0000000000000000000000340003FF050044330009C006001B00360006007B009A9999999999A93F0000360008FF0500431900000006002900360007006600000000000000000000002F0005FF130044360006C044360005C0054332000000411B0006001B00360008007B0000000000000000000000360009FF0500431B00000006002100360009007A00000000000000000000003A0001FF0B0044360008C044360005C005BE001800370001007E006F006F007D007C007B0066007B007A000900BE000C00380001007900780077000300FD000A003800040060008F00000006001B003800050076005C8FC2F5285CDF3F0000240005FF0500432700000001020600380006007500060029003800070076007B14AE47E17A943F00002D0009FF1300252B002F0007C007C01910404344360007C0030102060038000800750006002900380009007400000000000000000000001F0003FF1300252B002F0009C009C01910434444360009C003FD000A003900010068018E000000FD000A003900020069018D000000FD000A003900030069018C000000FD000A003900040069018B000000FD000A003900050069018A00000001020600390006006901FD000A00390007006E0189000000BE000A003900080069016D01090006001D003A0001006900000000000000000000003A0003FF07005A0100030012C006004D003A0002006800000000000000000000003C0009FF37004354000000194000011E0100194000010B19020F00194000013A01000300138019081200194000013A010003001480190803004203010006001D003A0003006C00000000000000F03F00003A0004FF07005A0100030016C006001D003A0004006B00000000000000000000003A0005FF07005A0100030015C006001D003A0005006A00000000000000000000003B0001FF07005A0100030017C0010206003A000600680006001D003A000700660000000000000000000000320001FF07005A0100030018C0BE000A003A00080072006500090006001D003B0001006900000000000000000000003B0003FF07005A0100040012C006004D003B0002006800000000000000000000003C0002FF37004354000000194000011E0100194000010B19020F00194000013A01000400138019081200194000013A010004001480190803004203010006001D003B0003006C00000000000000004000003B0004FF07005A0100040016C006001D003B0004006B00000000000000000000003B0005FF07005A0100040015C006001D003B0005006A00000000000000000000003C0001FF07005A0100040017C0010206003B000600670006001D003B0007006600000000000000000000003C0007FF07005A0100040018C0BE000A003B00080071007000090006001D003C0001006900000000000000000000003C0003FF07005A0100050012C006004D003C0002006800000000000000000000003D0002FF37004354000000194000011E0100194000010B19020F00194000013A01000500138019081200194000013A010005001480190803004203010006001D003C0003006C00000000000000000000003C0004FF07005A0100050016C006001D003C0004006B00000000000000000000003C0005FF07005A0100050015C006001D003C0005006A00000000000000000000003D0001FF07005A0100050017C0010206003C000600670006001D003C0007006600000000000000000000003D0007FF07005A0100050018C0FD000A003C0008006E008800000006001B003C0009006D00000000000000000000000A0001FF050043A700000006001D003D0001006900000000000000000000003D0003FF07005A0100060012C006004D003D0002006800000000000000000000003A0002FF37004354000000194000011E0100194000010B19020F00194000013A01000600138019081200194000013A010006001480190803004203010006001D003D0003006C00000000000000000000003D0004FF07005A0100060016C006001D003D0004006B00000000000000000000003D0005FF07005A0100060015C006001D003D0005006A00000000000000000000003E0006FF07005A0100060017C0010206003D000600670006001D003D0007006600000000000000000000003A0007FF07005A0100060018C0BE000A003D0008005C0065000900BE000C003E0001006300620061000300060035003E0004006000000000000000FFFF2000250005FF1F0017120053756D61206465204F706572616369F36E201940000143800000000807021C0019000053756D61206465204F706572616369F36E20506F3D532F487406001B003E0005005F0000000000000000000000260003FF0500432C00000006001B003E0006005E00000000000000F03F00003E0008FF0500438200000006001B003E0007005F00000000000000000000002B0003FF0500432D00000006001B003E0008005E00000000000000F03F0000160008FF0500438700000006001B003E0009005D00000000000000000000003E0007FF0500432E000000FD000A003F000100680187000000BE000C003F0002006F016F017001040006001B003F0005007101F6285C8FC2F5FC3F00003F0009FF05004322000000010206003F000600710106001B003F0007007101E17A14AE47E1EA3F0000290007FF0500432A000000010206003F000800710106001B003F00090072010AD7A3703D0AD73F0000290009FF05004331000000D7004400E21D00006C024B01E50076001C00380175016A0131011C008F00280049011F0173013901420128006C001201310112011A000F011C00AB006C000E010E012D010E010401080210004000000000000E010000000000010F10D7000600140000000000C2017C023B0004000300090704010AD7030005000200090B020009FF21000A0002000904010000650800160002000919086E201907001A000200090E0300000003001B000200090D044380DA31001B0002000904080100014B001E00020009030361004E33001F000200090403393031380024000400090503313233360024000200090409333435050025000200090B01353637250025000400090303373839040025000200091005393031250025000400090507313233040025000200090F09333435260026000400090303353637050026000200091005373839290026000400090507393031050026000200090F09313233070027000200090B01333435060027000200090E033536372D0027000200090405373839270027000400090507393031060027000200090F0931323343002900020009030533343539002900020009040935363708002B000200090B013738392B002B0004000903033930312E002B0002000904073132330A002B00020009100933343509002C000200090F033536370B002C0002000910053738392C002C00040009050739303114002C00040009080931323308002D0002000922013334352D002D0004000905053536373F002E0002000904013738390A002E000200090D033930310A002E000200090B093132332B002F0004000905013334352D002F0004000903033536370B002F000200090D07000000090032000200090D0100000025003600040009010700EC0B060038000200090D05003C0608003800020009100700130011003A00020009040200010008003C0002000918090000003E003E00040009050500000010003E000200090E0700030010003E000200090F090001003A003F000200090405000000EC0006010F0002F0FE000000300008F00800000002000000110C00000F0003F0E60000000F0004F028000000010009F0100000000000000000000000000000000000000002000AF008000000000C0000050000000F0004F0AE000000B2040AF008000000110C0000000A0000A3000BF0740000007F008000FB0104410100000005C1100000003F0100000600BF0100001000FF01000018003F031000180080C31800000081C310000000BF030000020050004E004700540045005300540000006C006F0067006F0065006D0070007200650073006100000050004E00470054004500530054000000000010F01200000000000800240002000F000900FD0207006200000011F0000000005D0026001500120008001100116000000000000000000000000007000200FFFF080002000000000000003E021200A40000000000400000003C006400000000008B0810008B0800000000000000000000000002001D000F00031200080000000100120012000808E50062000C0031003100010002003200320001000200330033000100020034003400010002000A000A00010003000B000B000100030001000300020005002A002A00010002000F001000010004000C000C00010009000D000D0003000500050008000200060067081700670800000000000000000000020001FFFFFFFF034400000A00000009081000000610006632CD07C9800100060600000B021C00000000000000000041000000ACF9010003140200802D0200DC2D02000D00020001000C00020064000F000200010011000200000010000800FCA9F1D24D62503F5F00020001002A00020000002B0002000000820002000100800008000000000000000000250204000000FF0081000200C104140009000600002652263826501500000083000200000084000200000026000800BA5C2E97CBE5E23F270008004D2693C96432C93F2800080052B81E85EB51E03F29000800333333333333E33F4D003E0600005C005C006E0065006F0064006100740061007300650072007600650072005C004800500020004C0061007300650072004A00650074002000500032000000000001040201DC00600503FF8007010001000000000064000100070058020100010058020100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000002000000010000000100000000000000000000000000000000000000020100004800500020004C0061007300650072004A0065007400200050003200300031003400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003C060000EC0B000000000000000000003C060000B00600000000000013000000EC130000C8190000010000000000000000000000000000000000000000000000000000000100000001000000030000000100000064000000010000000F27000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000100000000000000960000000000000034000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040170000E2200000FFFFFFFF0000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000013000000000000000100000000000000010000000100000000000000010000000000000000000000020000000000000000000000000000000100000001000000010000000000000000000000020000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040170000E22000000000000000000000000000000000000000000000640000000000000000000000000000006400000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000000000000000000000000000000000000000000000000000000FFFFFFFF40170000E2200000010000000100000000000000000000000000000001000000010000000100000001000000A1002200010055000100010001000200580258020A8542A15028D43F52B81E85EB51D83F01009C0826009C080000000000000000000000000000000000000000000000000000E4510000000000000000550002000A007D000C0000000000DB005B00020000007D000C0001000100490D5B00020000007D000C00020002006D165B00020000007D000C000300030000155B00020000007D000C0004000400000E5B00020000007D000C0005000500000B5B00020000007D000C0006000600DB045B00020000007D000C0007000700000B5B00020000007D000C000800080024075B00020000007D000C0009000900B60A5B00020000007D000C000A0000016D0B5B000000000000020E00000000004100000001000A00000008021000000001000A003C000000000040010F2008021000010001000A000E010000000000010F1008021000020001000A00FF000000000000010F0008021000030001000A00FF000000000040010F0008021000040001000A00FF000000000040010F0008021000050001000A002C010000000040010F0008021000060001000A001D010000000040010F0008021000070001000A003B010000000040010F0008021000080001000A00C1020000000040010F0008021000090001000A00FF000000000040010F00080210000A0001000A00FF000000000040010F00080210000B0001000A00FF000000000040010F20080210000C0001000A001D010000000000010F30080210000D0001000A00FF000000000040010F10080210000E0001000A00FF000000000000010F00080210000F0001000A00FF000000000000010F0008021000100001000A00FF000000000000010F0008021000110001000A00FF000000000000010F0008021000120001000A000E010000000000010F2008021000130001000A004B000000000040010F3008021000140001000A000E010000000000010F1008021000150001000A00FF000000000000010F0008021000160001000A00FF000000000000010F0008021000170001000A00FF000000000000010F0008021000180001000A00FF000000000000010F0008021000190001000A00FF000000000000010F00080210001A0001000A00FF000000000000010F00080210001B0001000A00FF000000000000010F00080210001C0001000A00FF000000000000010F00080210001D0001000A00FF000000000000010F00080210001E0001000A00FF000000000000010F00080210001F0001000A00FF000000000000010F00FD000A0001000100CF00BB00000006001B00010002000202000000000000FFFF00002F0003FF0500437800000007028E008B000053697374656D6120646520436F6D756E69636163696F6E65732079205472616E73706F727465732C2053697374656D61206465205472616E73706F72746520436F6C65637469766F204D6574726F2C2041646D696E69737472616369F36E2047656E6572616C206465205265637572736F732C204CED6E656120313220284CED6E656120446F7261646129BE00140001000300020202020202CE00CE00CD00CC000900BE00180002000100C4000302030203020302C100C100C900C8000900BE00180003000100C4000302030203020302C100C100C900CB000900FD000A0004000100C400BA00000006001B00040002006700000000000000FFFF0000010002FF0500437E000000070211000E0000323030392F303235372D30303031FD000A0004000300CA00B900000006001B0004000400F40100000000208AE3400000040002FF0500434E000000BE00100004000500C200C100C100C900C8000900FD000A0005000100C400B800000006001B00050002000C02000000000000FFFF0000040004FF050043790000000702F701F401003132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930BE001400050003000C020C020C020D02C100C700C6000900BE00180006000100C4000C020C020C020C020D02C100C200C5000900BE00180007000100C4000C020C020C020C020D02C100C200C5000900BE00180008000100C4000C020C020C020C020D02C100C200C3000900FD000A0009000100C400B70000000600510009000200D401000000000000FFFF0000050002FF3B00433F000000194000011701002C194000010819400001430D0000001940000108194000011701002C19400001081940000143450000001940000108070242003F00005472616D6F2064652042617272616E63612064656C204D756572746F206120546C61687561632E2C4DE97869636F2C446973747269746F204665646572616CBE00140009000300D401D401C200C100C100C000BF00090006001B000A0001001202000100000000FFFF0000090002FF050043A1000000070218001500004E656F646174612C20532E412E20646520432E562EBE000A000A00020013021402030006001B000A000400D501000200000000FFFF00000A0001FF050043A400000007021A001700004A4F524745204C2E2044C156414C4F53204D4943454C49BE000E000A000500BE00BD00BD00D7010800FD000A000A000900D601B6000000FD000A000B0001001502B5000000BE000A000B00020016021702030006001B000B000400BB00000200000000FFFF00000A0004FF05004308000000070213001000004449524543544F522047454E4552414CBE000C000B000500BA00B900B9000700FD000A000B000800BC00A6000000FD000A000B000900FC0150010000FD000A000C0001000A02B4000000BE0016000C0002000A020A020A020A020A020A020A020A020900BE000A000D000100A901AA010200FD000A000D0003000B02B3000000BE0012000D0004000B020B02AB01AB01AB01AC010900FD000A000E000100AD01B200000006001B000E000200AE01000000000000FFFF00000B0004FF0500430F00000007020C000900004551504554524F3031FD000A000E000300AF01AE00000006001B000E000400AE01000000000000FFFF00000E0002FF0500437700000007020B00080000502D323030392D31010206000E000500B101FD000A000E000600AF01AD00000006001B000E000700B001000000000000FFFF00000E0004FF050043060000000702090006000038303030204CBE000A000E000800B201B301090006001B000F0001000602000100000000FFFF00000E0007FF0500433C00000007026400610000504554524F4C495A41444F5241202044452038303030204C542E20204445203135352048502C204D4F544F522056414D204D4F442E363535382020424F4D424120373536204C504D20424152524120332E3636204D2053494E204348415349532EBE000E000F000200070207020702B4010500FD000A000F000600B501AB00000006001B000F000700B601000000000000FFFF00000F0001FF0500437F000000070213001000005753513434353735372D534445343435BE000A000F000800B701B8010900BE001000100001000802090209020902B9010500FD000A0010000600BA01AA00000006001B0010000700BB01000000000000FFFF00000F0007FF0500431500000007020B000800004741534F4C494E41BE000A0010000800B701B80109000102060011000100C801FD000A0011000200C901B100000006001B0011000300CA01000000000000FFFF0000100007FF05004356000000070222001F00004365746573206120323820646961732064656C2031342F7365702F32303039BE000C0011000400CB01CC01B2010600FD000A0011000700C901B000000006001B0011000800FA01B81E85EB51B8BE3F0000110003FF050043B00000000102060011000900B3010102060012000100CD01FD000A0012000200CE01AF00000006001B0012000300CF01000000000000FFFF0000110008FF0500435700000007022A00270000546173612064652053656775726F7320416D65726963612064656C2031342F7365702F32303039BE000C0012000400D001D101D2010600FD000A0012000700CE01AC00000006001B0012000800FB017B14AE47E17AA43F0000120003FF0500439F0000000102060012000900D301BE00180013000100A100C301C401C501C601A100C301C701A100090006001D0014000100BC01000100000000FFFF0000120008FF07005A0100030001C00702180015000050524543494F204445204144515549534943494F4E0102060014000200BD0106001B0014000300BE01000000000068B0400000140001FF0500439C000000BE000C0014000400BF01C001B8000600FD000A0014000700B700A900000006001B0014000800C101000000000000084000002B0001FF050043BD0000000102060014000900C2010600380015000100B100000000000000FFFF0000140003FF22005A0100040001C01702002028085A0100040002C0081940000117010029194000010807021C0019000050524543494F204A5545474F204C4C414E5441532028506E290102060015000200B00006001B0015000300B20000000000000000000000150001FF0500439E000000BE000C00150004006400AD00AC0006000600420015000700AB00000000000000FFFF0000150003FF2C005A0100220001C01940000117030020202819400001085A0100220002C0194000010819400001170200293A0807021800150000484F52415320504F522041D14F202028486561293A06001B001500080066010000000000409F400000150007FF05004353000000FD000A0015000900AA00A7000000FD000A0016000100B100A80000000102060016000200B00006001B0016000300B20000000000000000000000150008FF0500439D000000BE000C0016000400B600AD00AC00060006003D0016000700AB00000000000000FFFF0000160003FF27005A0100230001C0194000011702002028085A0100230002C0194000010819400001170200293A0807021700140000564944412045434F4E4F4D49434120285665293A06001B00160008006601000000000070B7400000160007FF050043BE000000FD000A0016000900AA00A70000000600380017000100B100000000000000FFFF0000160008FF22005A0100060001C01702002028085A0100060002C0081940000117010029194000010807022900260000564944412045434F4E4F4D494341204445204C4C414E54415320284A7565676F292028566E290102060017000200B00006001B0017000300AF0000000000000000000000170001FF050043BF000000FD000A00170004006800A1000000BE000A0017000500AD00AC00060006003D0017000700AB00000000000000FFFF0000170003FF27005A0100140001C0194000011702002028085A0100140002C0194000010819400001170200293A0807021A00170000434F53544F20434F4D4255535449424C4520285063293A06001B0017000800660100000000000012400000170007FF05004326000000FD000A0017000900B500A50000000600440018000100B100000000000000FFFF0000170008FF2E005A0100070001C019400001170200202819400001085A0100070002C019400001081940000117010029194000010807021E001B000050524543494F20505A415320455350454349414C455320285065290102060018000200B00006001B0018000300B20000000000000000000000180001FF05004330000000BE000C00180004006400AD00AC00060006003D0018000700AB00000000000000FFFF0000180003FF27005A0100160001C0194000011702002028085A0100160002C0194000010819400001170200293A0807021900160000434F53544F204C5542524943414E544520285061293A06001B001800080066017B14AE47E17A30400000180007FF0500432B000000FD000A0018000900B500A50000000600450019000100B100000000000000FFFF0000180008FF2F005A0100080001C0194000011703002020281940000108194000015A0100080002C01940000108194000011701002908070222001F0000564944412045434F4E4F4D49434120505A41532045535045432020285661290102060019000200B00006001B0019000300AF0000000000000000000000190001FF050043C0000000FD000A00190004006800A1000000BE000A0019000500AD00AC000600FD000A0019000700AB00A400000006001B0019000800660100000000000054400000190003FF0500439A000000FD000A0019000900AA00A3000000060041001A000100B100000000000000FFFF0000190008FF2B005A0100090001C01940000117030020202819400001085A0100090002C0194000010819400001170100290807021C0019000056414C4F52204445204C41204D415155494E41202028566D29010206001A000200B00006001B001A000300B200000000000068B04000002E0001FF050043BA000000BE000C001A0004006400AD00AC00060006003D001A000700AB00000000000000FFFF00001A0001FF27005A01000B0001C0194000011702002028085A01000B0002C0194000010819400001170200293A0807021C00190000464143544F52204445204F504552414349D34E2028466F293A06001B001A0008006601DC114E0B5EF4553F00001A0007FF0500434A000000010206001A000900B400060041001B000100B100001100000000FFFF00001A0008FF2B005A0100240001C01940000117030020202819400001085A0100240002C0194000010819400001170100290807021A0017000056414C4F52204445205245534341544520202028567229010206001B000200B00006001B001B000300B3009A9999999999B93F00001B0001FF050043BB00000006001B001B000400B2000000000000407A400000240003FF050043BC000000BE000A001B000500AD00AC000600060041001B000700AB00000000000000FFFF00001B0003FF2B005A01000C0001C019400001170200202819400001085A01000C0002C0194000010819400001170200293A0807021F001C0000504F54454E434941204445204F504552414349D34E2028506F70293A06001B001B00080066015396218E7571BB3F00003C0009FF0500439B000000010206001B000900AA00060040001C000100B100009600000000FFFF00001B0007FF2A005A0100250001C019400001170200202819400001085A0100250002C0194000010819400001170100290807021C001900005441534120444520494E544552455320414E55414C20286929010206001C000200B00006001B001C000300EA01B81E85EB51B8BE3F00001C0001FF050043B0000000BE000C001C0004008100AD00AC00060006003D001C000700AB00000000000000FFFF00001C0003FF27005A0100270001C0194000011702002028085A0100270002C0194000010819400001170200293A08070220001D0000464143544F52204445204D414E54454E494D49454E544F20284B6F293A06001B001C00080066019A9999999999E93F00001C0007FF05004349000000010206001C000900AA00060040001D000100B100009900000000FFFF00001C0008FF2A005A0100260001C019400001170200202819400001085A0100260002C01940000108194000011701002908070226002300005052494D4120414E55414C2050524F4D4544494F2044452053454755524F5320287329010206001D000200B00006001B001D000300EA017B14AE47E17AA43F00001D0001FF0500439F000000BE000C001D0004008100AD00AC00060006003D001D000700AB00000000000000FFFF00001D0003FF27005A0100180001C0194000011702002028085A0100180002C0194000010819400001170200293A08070220001D0000434F4546494349454E544520434F4D4255535449424C4520284663293A06001B001D0008006601000000000000F03F00001D0007FF05004347000000010206001D000900AA00060040001E000100B100000000000000FFFF00001D0008FF2A005A01000D0001C019400001170200202819400001085A01000D0002C01940000108194000011701002908070220001D000053414C4152494F205245414C2044454C204F50455241444F5220285329010206001E000200B00006001B001E000300B20000000000000000000000240001FF050043A7000000BE000C001E0004009300AD00AC000600060041001E000700AB00000000000000FFFF00001E0001FF2B005A0100190001C019400001170200202819400001085A0100190002C0194000010819400001170200293A0807021F001C0000434F4546494349454E5445204C5542524943414E544520284661293A06001B001E0008006601B81E85EB51B87E3F00001E0007FF05004348000000010206001E000900AA0006003C001F000100B100001E00000000FFFF00001E0008FF26005A0100120001C0194000011702002028085A0100120002C0194000010819400001170100290807022600230000434F53544F20504F522053414C4152494F204445204F504552414349D34E2028506F29010206001F000200B00006001B001F000300B20000000000000000000000260003FF0500432C000000BE000C001F0004009300AD00AC000600060039001F000700AB00000000000000FFFF00001F0001FF23005A01001A0001C0194000011702002028085A01001A0002C00819400001170200293A0807021D001A00004341504143494441442044454C2043415254455220284343293A06001B001F0008006601000000000000000000001F0007FF05004307000000FD000A001F000900AA00A2000000D70044008F1900006C020000D7001C001C00830040021C001C001C00C100A6007E0028003200CB00EB005E00A400AC001C00AD002401D0003A012E01EF0028014A012B013501320108021000200001000A00FF000000000000010F0008021000210001000A000E010000000000010F2008021000220001000A001D010000000000010F3008021000230001000A0078000000000040010F1008021000240001000A00FF000000000000010F0008021000250001000A00FF000000000000010F0008021000260001000A00FF000000000000010F0008021000270001000A00FF000000000000010F0008021000280001000A0069000000000040010F0008021000290001000A000E010000000000010F20080210002A0001000A001D010000000000010F30080210002B0001000A000E010000000000010F10080210002C0001000A00FF000000000000010F00080210002D0001000A00FF000000000000010F00080210002E0001000A00FF000000000000010F00080210002F0001000A00FF000000000000010F0008021000300001000A00FF000000000000010F0008021000310001000A00FF000000000000010F0008021000320001000A00FF000000000000010F0008021000330001000A00FF000000000000010F0008021000340001000A00FF000000000000010F0008021000350001000A0078000000000040010F0008021000360001000A00FF000000000000010F0008021000370001000A0078000000000040010F0008021000380001000A000E010000000000010F2008021000390001000A001D010000000000010F30080210003A0001000A000E010000000000010F10080210003B0001000A00FF000000000000010F00080210003C0001000A00FF000000000000010F00080210003D0001000A00FF000000000000010F00080210003E0001000A000E010000000000010F20080210003F0001000A001D010000000000010F3006003C0020000100B100000000000000FFFF00001F0008FF26005A0100100001C0194000011702002028085A0100100002C0194000010819400001170100290807022C00290000484F524153204546454354495641532044452054524142414A4F20504F52205455524E4F20284874290102060020000200B00006001B0020000300E801000000000000FFFF0000210009FF0500435200000007020600030000312C32FD000A0020000400AE00A1000000BE000A0020000500AD00AC00060006003D0020000700AB00000000000000FFFF0000200001FF27005A01000F0001C0194000011702002028085A01000F0002C0194000010819400001170200293A0807021E001B0000464143544F522044452052454E44494D49454E544F20284672293A06001B00200008006601000000000000F03F0000200007FF0500434C0000000102060020000900AA0006003C0021000100A900000000000000FFFF0000200008FF26005A01001B0001C0194000011702002028085A01001B0002C01940000108194000011701002908070229002600005449454D504F20454E5452452043414D42494F204445204C5542524943414E544520284361290102060021000200A80006001B0021000300A70000000000000000000000210001FF050043B4000000FD000A0021000400A600A1000000BE000A0021000500A500A4000600FD000A0021000800A300A00000000600210021000900A200000000000000000000001E0003FF0B00431E0000001E0400411B00FD000A0022000100F5019F00000001020600220002006901FD000A00220003006A019E00000001020600220004006A01FD000A0022000500F8019D000000BE000E00220006006E016E016E01F9010900BE00180023000100A0009F009F009F009F0073009B0073009E00090006001B00240001006900000000000000FFFF0000260001FF050043350000000702280025000061292E2D20444550524543494143494F4E2E2E2E2E2E2E2E44203D28566D2D5672292F56650102060024000200730006001B00240003006800000000000000FFFF0000380005FF0500433600000007021B001800002824342C3230302E2D243432302E292F362C3030302E30300102060024000400680006001B00240005009B00295C8FC2F528E43F0000270003FF05004337000000BE000E00240006009D009B009D009800090006001B00250001009000000000000000FFFF00002F0005FF0500435B00000007025B002C0001620029002E002D00200049004E00560045005200530049004F004E0026202E002E002E002E002E002E002E002E002E002E006C006D0020003D002000280056006D002B005600720029002A0069002F00320048006500610001020600250002008F0006001B00250003008E00000000000000FFFF0000260005FF0500435C000000070225002200002824342C3230302E2B243432302E297831322E3030303020252F283278323030302901020600250004008E0006001B00250005009B00EC51B81E85EBC13F00002D0005FF0500435D000000BE000E00250006009D009C009D009800090006001B00260001009000000000000000FFFF0000270001FF050043A900000007024F00260001630029002E002D002000530045004700550052004F0053002620262026202E002E002E002E0053006D0020003D002000280056006D002B005600720029002A0073002F00320048006500610001020600260002008F0006001B00260003008E00000000000000FFFF00001B0004FF050043AA000000070226002300002824342C3230302E30302B243432302E30302978342E303020252F283278323030302901020600260004008E0006001B00260005009C009A9999999999A93F0000290005FF050043AB000000BE000E002600060099009B0099009800090006001B00270001006900000000000000FFFF0000330009FF05004376000000070222001F000064292E2D204D414E54454E494D49454E544F2E2E2E2E2E4D203D204B6F2A440102060027000200730006002800270003006800000000000000FFFF0000250003FF120043490000001703002078200844240005C00807020D000A0000302E38207820302E36330102060027000400680006001B00270005009B00000000000000E03F00003F0005FF05004371000000BE000E002700060099009B00990098000900BE0018002800010069007300680068009B0099009A00990098000900BE000C00290001006300620061000300FD000A002900040060009900000006001B002900050097002085EB51B81EF53F0000270005FF05004323000000BE000E002900060096009700960095000900FD000A002A000100040298000000BE0016002A00020005026901690169016901690169016D01090006001B002B0001006900000100000000FFFF00002D0001FF0500431600000007024300200001610029002E00200043004F004D004200550053005400490042004C00450026202E0026202E002E0043006F003D00460063002A0050006F0070002A0050006300010206002B000200730006001B002B0003006800000000000000FFFF00002E0005FF0500431C000000070211000E00003178302E31303732782024342E35010206002B000400680006001B002B0005009300B81E85EB51B8DE3F0000360009FF05004317000000BE000E002B0006009400930091008000090006001B002C0001009000000000000000FFFF0000210003FF0500438A00000007021F001C000062292E2D4F74726173204675656E74657320646520456E6572676961010206002C000200730006001B002C0003008E00000000000000FFFF00002C0005FF0500438B00000007020B00080000242E3030202A2030010206002C000400810006001B002C0005009300000000000000000000003E0004FF0500438C000000BE000E002C0006009400930091008000090006001B002D0001009000000000000000FFFF20002E0003FF0500436900000007025B002C0001630029002E0020004C007500620072006900630061006E007400650026202620262026202E002E002E002E004C0062003D005B002800460061002A0050006F00700029002B00430043002F00430061005D002A0050006100010206002D0002008F0006001B002D0003008E00000000000000FFFF2000250001FF0500436A000000070223002000005B28302E3030373578302E31303732292B302F305D2078202431362E34386C74010206002D0004008E0006001B002D00050066007B14AE47E17A843F00003E0005FF0500436B000000BE000E002D0006008100660081008000090006001B002E0001009000000000000000FFFF20002F0001FF0500436200000007023B001C0001640029002E0020004C006C0061006E0074006100730026202620262026202E0026202E002E002E002E004E003D0050006E002F0056006E00010206002E0002008F0006001B002E0003008E00000000000000FFFF20002D0003FF0500436300000007020900060000242E30302F30010206002E0004008E0006001B002E0005009200000000000000000000001B0008FF05004364000000BE000E002E0006009100920091008000090006001B002F0001009000000000000000FFFF20002C0003FF0500439000000007024500210001650029002E0020005000690065007A0061007300200045007300700065006300690061006C006500730026202E002E002E00410065003D00500065002F0056006100010206002F0002008F0006001B002F0003008E00000000000000FFFF2000200003FF05004391000000070208000500002430302F30010206002F0004008E0006001B002F0005008D00000000000000000000002B0005FF0500439200000006001B002F0006008100000000000000000000002C0001FF05004394000000BE000C002F0007008D00810080000900FD000A00300001008C0097000000BE001600300002008B008A008A00880089008800810080000900FD000A00310001000E029600000001020600310002000F02FD000A0031000300730195000000FD000A0031000400730194000000FD000A0031000500730193000000FD000A003100060073014C010000FD000A0031000700F70191000000BE000A003100080087008000090006005100320001001002000000000000000000002F0006FF3B004354000000194000011E0100194000010B19020F00194000013A010003001CC019081600194000023A010003001DC01940000119080300420301000102060032000200110206001D0032000300860000000000000000000000320001FF07005A010003001EC006001D0032000400850000000000000000000000320003FF07005A0100030020C006001D0032000500840000000000000000000000320004FF07005A010003001FC006001D0032000600830000000000000000000000320005FF07005A0100030021C006001D0032000700820000000000000000000000320006FF07005A0100030022C0BE000A00320008008100800009000600510033000100100200000000000000000000320007FF3B004354000000194000011E0100194000010B19020F00194000013A010004001CC019081600194000023A010004001DC01940000119080300420301000102060033000200110206001D0033000300860000000000000000000000330001FF07005A010004001EC006001D0033000400850000000000000000000000330003FF07005A0100040020C006001D0033000500840000000000000000000000330004FF07005A010004001FC006001D0033000600830000000000000000000000330005FF07005A0100040021C006001D0033000700820000000000000000000000330006FF07005A0100040022C0FD000A00330008006E009000000006001B00330009006D0000000000000000000000360005FF050043B70000000600510034000100100200000000000000000000330007FF3B004354000000194000011E0100194000010B19020F00194000013A010005001CC019081600194000023A010005001DC01940000119080300420301000102060034000200110206001D0034000300860000000000000000000000340001FF07005A010005001EC006001D0034000400850000000000000000000000340003FF07005A0100050020C006001D0034000500840000000000000000000000340004FF07005A010005001FC006001D0034000600830000000000000000000000340005FF07005A0100050021C006001D0034000700820000000000000000000000340006FF07005A0100050022C0BE000A0034000800810080000900BE000C00350001007E006F006F00030001020600350009007F00BE000C00360001007E006F006F00030006002F00360004007D00000000000000FFFF2000340007FF190017160053756D61206465204F74726F7320436F6E73756D6F730702190016000053756D61206465204F74726F7320436F6E73756D6F7306001B00360005007C0000000000000000000000360007FF050044330009C006001B00360006007B009A9999999999A93F0000360004FF050043190000000600290036000700660000000000000000000000380007FF130044360006C044360005C0054332000000411B0006001B00360008007B0000000000000000000000360006FF0500431B00000006002100360009007A0000000000000000000000380009FF0B0044360008C044360005C005BE001800370001007E006F006F007D007C007B0066007B007A000900BE000C00380001007900780077000300FD000A003800040060008F00000006001B003800050076005C8FC2F5285CDF3F0000240005FF050043270000000102060038000600750006002900380007007600000000000000000000001A0003FF1300252B002F0007C007C01910404344360007C0030102060038000800750006002900380009007400000000000000000000002B0003FF1300252B002F0009C009C01910434444360009C003FD000A0039000100F5018E000000FD000A003900020069018D000000FD000A003900030069018C000000FD000A003900040069018B000000FD000A003900050069018A00000001020600390006006901FD000A00390007006E0189000000BE000A003900080069016D01090006001D003A000100690000000000000000000000360008FF07005A0100030012C006004D003A0002006800000000000000000000003A0001FF37004354000000194000011E0100194000010B19020F00194000013A01000300138019081200194000013A010003001480190803004203010006001D003A0003006C00000000000000F03F00003A0002FF07005A0100030016C006001D003A0004006B00000000000000000000003A0003FF07005A0100030015C006001D003A0005006A00000000000000000000003A0004FF07005A0100030017C0010206003A000600680006001D003A0007006600000000000000000000003A0005FF07005A0100030018C0BE000A003A00080072006500090006001D003B0001006900000000000000000000003A0007FF07005A0100040012C006004D003B0002006800000000000000000000003B0001FF37004354000000194000011E0100194000010B19020F00194000013A01000400138019081200194000013A010004001480190803004203010006001D003B0003006C00000000000000004000003B0002FF07005A0100040016C006001D003B0004006B00000000000000000000003B0003FF07005A0100040015C006001D003B0005006A00000000000000000000003B0004FF07005A0100040017C0010206003B000600670006001D003B0007006600000000000000000000003B0005FF07005A0100040018C0BE000A003B00080071007000090006001D003C0001006900000000000000000000003B0007FF07005A0100050012C006004D003C0002006800000000000000000000003C0001FF37004354000000194000011E0100194000010B19020F00194000013A01000500138019081200194000013A010005001480190803004203010006001D003C0003006C00000000000000000000003C0002FF07005A0100050016C006001D003C0004006B00000000000000000000003C0003FF07005A0100050015C006001D003C0005006A00000000000000000000003C0004FF07005A0100050017C0010206003C000600670006001D003C0007006600000000000000000000003C0005FF07005A0100050018C0FD000A003C0008006E008800000006001B003C0009006D0000000000000000000000250005FF050043A700000006001D003D0001006900000000000000000000003C0007FF07005A0100060012C006004D003D0002006800000000000000000000003D0001FF37004354000000194000011E0100194000010B19020F00194000013A01000600138019081200194000013A010006001480190803004203010006001D003D0003006C00000000000000000000003D0002FF07005A0100060016C006001D003D0004006B00000000000000000000003D0003FF07005A0100060015C006001D003D0005006A00000000000000000000003D0004FF07005A0100060017C0010206003D000600670006001D003D0007006600000000000000000000003D0005FE07005A0100060018C0BE000A003D0008005C0065000900BE000C003E0001006300620061000300060035003E0004006000000000000000FFFF2000140008FF1F0017120053756D61206465204F706572616369F36E201940000143800000000807021C0019000053756D61206465204F706572616369F36E20506F3D532F487406001B003E0005005F00000000000000000000001F0003FF0500432C000000BE000E003E0006005E005F005E005D000900FD000A003F000100F50187000000BE000C003F000200F601F6017001040006001B003F0005007101F6285C8FC2F5FC3F0000FA0FB0FD05004322000000BE000E003F00060071017101710172010900D7004400351900006C024B01E50050001C00CE000B010001C7001C004F002800DF00B5000901CF00F50028006C001201310112011A000F011C00AB006C000E010E012D010E019A00080210004000000000000E010000000000010F10D7000600140000000000C201BC0104000100030009040201710109001A000200090B030FB0FD1B001B0003000904040000650D001B000200090E086E20193C001E00030009090300000026001F0003000903034380DA0400200002000919030100011D002100020009040961004E040024000200090B013930312400240003000903033132332C00250002000904033334352B0025000200090405353637060026000200090B01373839050026000200090E0339303126002600030009050531323327002700030009010133343503002700020009100335363737002700020009040537383938002900020009040539303107002B000200090F0331323310002B0002000910053334350B002C000200090E0335363710002C000200090B0537383936002D00030009070339303108002D000200090F0531323309002E000200090E0133343508002E000200090D0335363724002E0002000904053738390A002F000200090E0139303133002F0003000901033132332F002F0003000905053334353800380003000905053536370900380002000904073738392B00380003000903093930312B003C00030009050931323334003E0002000904043334353F003F000300090505353637EC0006010F0002F0FE000000400008F008000000020000000C1000000F0003F0E60000000F0004F028000000010009F0100000000000000000000000000000000000000002000AF00800000000100000050000000F0004F0AE000000B2040AF0080000000C100000000A0000A3000BF0740000007F008000FB0104410100000005C1100000003F0100000600BF0100001000FF01000018003F031000180080C31800000081C310000000BF030000020050004E004700540045005300540000006C006F0067006F0065006D0070007200650073006100000050004E00470054004500530054000000000010F012000000000007006E030100E4000900D40207003D00000011F0000000005D0026001500120008000C00116000000000000000000000000007000200FFFF080002000000000000003E021200A40000000000400000003C006400000000008B0810008B0800000000000000000000000002001D000F00030000000000000100000000000000E50062000C00010003000200050005000800020006000A000A00010003000B000B00010003000C000C00010009000D000D00030005000F001000010004002A002A0001000200310031000100020032003200010002003300330001000200340034000100020067081700670800000000000000000000020001FFFFFFFF034400000A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF0000060102000000000000000000000000000000000001000000E0859FF2F94F6810AB9108002B27B3D930000000C40000000800000001000000480000000400000050000000060000006000000008000000780000000B000000980000000C000000A40000000D000000B000000013000000BC00000002000000E40400001E000000080000006E656F64617461001E00000010000000323031312D30392D31392D31320000001E000000180000004A6F73E9204C75ED7320436F6CED6E2052616DED72657A0040000000003048939F45CC0140000000803644EBEB20CA014000000080F2340BD676CC010300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FEFF000006010200000000000000000000000000000000000200000002D5CDD59C2E1B10939708002B2CF9AE4400000005D5CDD59C2E1B10939708002B2CF9AE801100003C11000008000000010000004800000017000000500000000B000000580000001000000060000000130000006800000016000000700000000D000000780000000C000000F110000002000000E40400000300000000000E000B000000000000000B000000000000000B000000000000000B000000000000001E100000C4000000130000004E5F43616D706F732047656E6572616C657300150000004E5F43616D706F73204573706563696669636F730009000000457374616E646172000C000000536F6C6F41637469766F25000500000061726561001400000043616E7469646164436F6D6275737469626C65001F00000043616E7469646164436F6D6275737469626C655F73696E446574616C6C65001300000043616E74696461644C7562726963616E7465001E00000043616E74696461644C7562726963616E74655F73696E446574616C6C65000A00000043617061636964616400100000004361706163696461644361727465720006000000636172676F0011000000436172676F46696A6F4465736561646F0019000000636172676F726573706F6E7361626C6564656C616F6272610007000000636975646164000E000000636975646164636C69656E7465000F00000063697564616464656C616F6272610005000000636D6963000D000000436F6469676F45717569706F0014000000636F6469676F706F7374616C636C69656E74650015000000636F6469676F706F7374616C64656C616F6272610008000000636F6C6F6E6961000F000000636F6C6F6E6961636C69656E74650010000000636F6C6F6E696164656C616F627261000C000000436F6D6275737469626C650014000000436F6D6275737469626C655F466F726D756C610013000000436F6D6275737469626C65415F4D6F6E746F0013000000436F6D6275737469626C65455F4D6F6E746F0018000000436F6D6275737469626C65455F506F7263656E74616A650013000000436F6D6275737469626C65525F4D6F6E746F0018000000436F6D6275737469626C65525F506F7263656E74616A650017000000436F6D6275737469626C655375737469747563696F6E000F000000436F6E73756D6F4465736561646F000A000000436F6E73756D6F4761000A000000436F6E73756D6F4C740012000000436F6E73756D6F73446574616C6C61646F0010000000636F6E746163746F636C69656E7465000C000000436F73746F41637469766F0010000000436F73746F436172676F46696A6F410010000000436F73746F436172676F46696A6F450010000000436F73746F436172676F46696A6F520011000000436F73746F436F6D6275737469626C65000E000000436F73746F436F6E73756D6F41000E000000436F73746F436F6E73756D6F45000E000000436F73746F436F6E73756D6F52000C000000436F73746F4573706572610010000000436F73746F4C7562726963616E74650010000000436F73746F4F7065726163696F6E410010000000436F73746F4F7065726163696F6E450010000000436F73746F4F7065726163696F6E520012000000436F73746F4F747261734675656E746573000C000000436F73746F507A73457370000D000000436F73746F526573657276610012000000646563696D616C65737265646F6E64656F001B000000446563696D616C65735265646F6E64656F566F6C756D656E6573000D000000646570617274616D656E746F0015000000446570726563696163696F6E5F466F726D756C610019000000446570726563696163696F6E5F5375737469747563696F6E0014000000446570726563696163696F6E415F4D6F6E746F0014000000446570726563696163696F6E455F4D6F6E746F0019000000446570726563696163696F6E455F50726F63656E74616A650014000000446570726563696163696F6E525F4D6F6E746F0019000000446570726563696163696F6E525F506F7263656E74616A6500120000004465736372697063696F6E45717569706F0011000000646972656363696F6E636C69656E74650014000000646972656363696F6E6465636F6E637572736F0012000000646972656363696F6E64656C616F627261000A000000646F6D6963696C696F0006000000656D61696C000D000000656D61696C636C69656E7465000E000000656D61696C64656C616F627261000700000065737461646F000F00000065737461646F64656C616F62726100120000004578706C6F746172496E73756D6F7343480012000000466163746F72436F6D6275737469626C650011000000466163746F724C7562726963616E74650014000000466163746F724D616E74656E696D69656E746F0010000000466163746F724F7065726163696F6E0013000000466163746F724F747261734675656E7465730012000000466163746F7252656E64696D69656E746F00120000006665636861636F6E766F6361746F726961001000000066656368616465636F6E637572736F000C0000006665636861696E6963696F001100000066656368617465726D696E6163696F6E0014000000486F7261734566656374697661735475726E6F0019000000486F7261734566656374697661735475726E6F546578746F000A000000486F7261735841F16F0011000000496D7072696D6972436F6D706C6574610005000000696D7373001D000000496E64696361646F7245636F6E6F6D69636F5265666572656E636961001B000000496E64696361646F724573706563696669636F4D65726361646F000A000000696E666F6E617669740010000000496E6963696F4F7065726163696F6E0014000000496E6963696F4F74726F73436F6E73756D6F730012000000496E76657273696F6E5F466F726D756C610016000000496E76657273696F6E5F5375737469747563696F6E0011000000496E76657273696F6E415F4D6F6E746F0011000000496E76657273696F6E455F4D6F6E746F0016000000496E76657273696F6E455F506F7263656E74616A650011000000496E76657273696F6E525F4D6F6E746F0016000000496E76657273696F6E525F506F7263656E74616A6500100000004C6C616E7461735F466F726D756C6100140000004C6C616E7461735F5375737469747563696F6E000F0000004C6C616E746173415F4D6F6E746F000F0000004C6C616E746173455F4D6F6E746F00140000004C6C616E746173455F506F7263656E74616A65000F0000004C6C616E746173525F4D6F6E746F00140000004C6C616E746173525F506F7263656E74616A6500130000004C7562726963616E74655F466F726D756C6100170000004C7562726963616E74655F5375737469747563696F6E00120000004C7562726963616E7465415F4D6F6E746F00120000004C7562726963616E7465455F4D6F6E746F00170000004C7562726963616E7465455F506F7263656E74616A6500120000004C7562726963616E7465525F4D6F6E746F00170000004C7562726963616E7465525F506F7263656E74616A65000E0000004D616E74656E696D69656E746F00150000004D616E74656E696D69656E746F415F4D6F6E746F00150000004D616E74656E696D69656E746F455F4D6F6E746F001A0000004D616E74656E696D69656E746F455F506F7263656E74616A6500150000004D616E74656E696D69656E746F525F4D6F6E746F001A0000004D616E74656E696D69656E746F525F506F7263656E74616A6500160000004D616E74656E696D696E65746F5F466F726D756C6100070000004D6F64656C6F000E0000006E6F6D627265636C69656E7465000F0000006E6F6D62726564656C616F627261001C0000004E7565766F436F6566696369656E7465436F6D6275737469626C6500150000004E7565766F4661746F724C7562726963616E746500160000004E7565766F56616C6F724164717569736963696F6E00100000006E756D636F6E766F6361746F72696100110000006E756D65726F6465636F6E637572736F000E0000004E756D65726F4465536572696500120000004F7065726163696F6E5F466F726D756C6100150000004F7065726163696F6E436F6D6275737469626C6500160000004F7065726163696F6E455F506F7263656E74616A6500110000004F7065726163696F6E4C6C616E74617300140000004F7065726163696F6E4C7562726963616E746500160000004F7065726163696F6E4F747261734675656E746573001A0000004F7065726163696F6E5069657A6173457370656369616C657300160000004F7065726163696F6E525F506F7263656E74616A6500180000004F7472614675656E746573455F506F7263656E74616A6500180000004F7472614675656E746573525F506F7263656E74616A6500150000004F747261734675656E7465735F466F726D756C6100190000004F747261734675656E7465735F5375737469747563696F6E00140000004F747261734675656E746573415F4D6F6E746F00160000004F747261734675656E7465734465456E657267696100140000004F747261734675656E746573455F4D6F6E746F00140000004F747261734675656E746573525F4D6F6E746F000F0000005069657A61735F466F726D756C6100110000005069657A61735F537573747563696F6E000E0000005069657A6173415F4D6F6E746F000E0000005069657A6173455F4D6F6E746F00130000005069657A6173455F506F7263656E74616A65000E0000005069657A6173525F4D6F6E746F00130000005069657A6173525F506F7263656E74616A65000F000000706C617A6F63616C63756C61646F000A000000706C617A6F7265616C0019000000706F7263656E74616A65697661707265737570756573746F0010000000506F74656E6369614E6F6D696E616C0012000000506F74656E6369614F706572616369F36E001200000050726563696F4164717569736963696F6E001600000050726563696F45717569706F41646963696F6E616C000E00000050726563696F4C6C616E746173000D0000005072696D6153656775726F73000E0000007072696D6572616D6F6E656461000C00000072617A6F6E736F6369616C001400000072656D6174657072696D6572616D6F6E656461001400000072656D617465736567756E64616D6F6E656461000C000000726573706F6E7361626C650014000000726573706F6E7361626C6564656C616F6272610004000000726663001500000053616C6172696F5265616C4F7065726163696F6E000E000000736567756E64616D6F6E656461001000000053656775726F735F466F726D756C61001400000053656775726F735F5375737469747563696F6E000F00000053656775726F73415F4D6F6E746F000F00000053656775726F73455F4D6F6E746F001400000053656775726F73455F506F7263656E74616A65000F00000053656775726F73525F4D6F6E746F001400000053656775726F73525F506F7263656E74616A65000C00000054617361496E7465726573000900000074656C65666F6E6F001000000074656C65666F6E6F636C69656E7465001100000074656C65666F6E6F64656C616F62726100100000005469656D706F43616D62696F4C756200110000007469706F64656C696369746163696F6E0017000000546F74616C4C7562726963616E74654465736561646F0013000000546F74616C4F74726F73436F6E73756D6F73001E000000746F74616C707265737570756573746F7072696D6572616D6F6E656461001E000000746F74616C707265737570756573746F736567756E64616D6F6E656461001000000056616C6F724D617175696E61726961000D00000056616C6F7252657363617465001200000056616C6F72526573636174654D6F6E746F000C0000005669646145636F41F16F73000D0000005669646145636F455148727300120000005669646145636F4C6C616E74617348727300110000005669646145636F5069657A6173487273000C100000040000001E00000011000000486F6A61732064652063E16C63756C6F0003000000040000001E0000001200000052616E676F7320636F6E206E6F6D6272650003000000C0000000BC0000000300000000000000200000000100000038000000020000004000000001000000020000000C0000005F5049445F484C494E4B530002000000E404000041000000740000000600000003000000640014000300000000000000030000000000000003000000060000001F0000001E0000006D00610069006C0074006F003A0073006F0070006F0072007400650040006E0065006F0064006100740061002E0063006F006D002E006D00780000001F000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000002000000030000000400000005000000060000000700000008000000090000000A0000000B0000000C0000000D0000000E0000000F000000100000001100000012000000130000001400000015000000160000001700000018000000190000001A0000001B0000001C0000001D0000001E0000001F000000200000002100000022000000230000002400000025000000260000002700000028000000290000002A0000002B0000002C0000002D0000002E0000002F000000300000003100000032000000330000003400000035000000360000003700000038000000390000003A0000003B0000003C0000003D0000003E0000003F000000400000004100000042000000430000004400000045000000460000004700000048000000490000004A0000004B0000004C0000004D0000004E0000004F000000500000005100000052000000530000005400000055000000560000005700000058000000590000005A0000005B0000005C0000005D0000005E0000005F000000600000006100000062000000630000006400000065000000660000006700000068000000690000006A0000006B0000006C0000006D0000006E0000006F000000700000007100000072000000730000007400000075000000760000007700000078000000790000007A0000007B0000007C0000007D0000007E0000007F000000800000008100000082000000830000008400000085000000860000008700000088000000890000008A0000008B0000008C0000008D0000008E0000008F000000900000009100000092000000930000009400000095000000960000009700000098000000990000009A0000009B0000009C0000009D0000009E0000009F000000A0000000A1000000A2000000A3000000A4000000A5000000A6000000A7000000A8000000A9000000AA000000AB000000AC000000AD000000AE000000AF000000B0000000B1000000B2000000B3000000B4000000B5000000B6000000B7000000B8000000B9000000BA000000BB000000BC000000BD000000BE000000BF000000C0000000C1000000C2000000C3000000C4000000C5000000C6000000C7000000C8000000C9000000CA000000CB000000CC000000CD000000CE000000CF000000D0000000D1000000D2000000D3000000D4000000D5000000D6000000D7000000D8000000D9000000DA000000DB000000DC000000DD000000DE000000DF000000E0000000E1000000E2000000E3000000E4000000E5000000E6000000E7000000E8000000E9000000EA000000EB000000EC000000ED000000EE000000EF000000F0000000F1000000F2000000F3000000F4000000F5000000F6000000F7000000F8000000F9000000FA000000FB000000FC000000FD000000FE000000FF000000000100000101000002010000030100000401000005010000060100000701000008010000090100000A0100000B0100000C0100000D0100000E0100000F010000100100001101000012010000130100001401000015010000160100001701000018010000FEFFFFFF1A0100001B0100001C0100001D0100001E0100001F01000020010000FEFFFFFF22010000230100002401000025010000260100002701000028010000290100002A010000FEFFFFFFFDFFFFFFFDFFFFFFFDFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000501FFFFFFFFFFFFFFFF020000002008020000000000C000000000000046000000000000000000000000B016B6BDE476CC01FEFFFFFF000000000000000057006F0072006B0062006F006F006B0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000009C310200000000000500530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000000000000000000000000000000000000280002010100000003000000FFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000190100000010000000000000050044006F00630075006D0065006E007400530075006D006D0061007200790049006E0066006F0072006D006100740069006F006E000000000000000000000038000201FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000210100003C12000000000000, NULL)
SET IDENTITY_INSERT [dbo].[PuDocumentos] OFF
SET IDENTITY_INSERT [dbo].[PuEstados] ON 

INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (1, N'AGS', N'Aguascalientes')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (2, N'BC', N'Baja California')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (3, N'BCS', N'Baja California Sur')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (4, N'CAM', N'Campeche')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (5, N'CHI', N'Chihuahua')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (6, N'CHIS', N'Chiapas')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (7, N'COAH', N'Coahuila')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (8, N'COL', N'Colima')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (9, N'DF', N'Distrito Federal')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (10, N'DUR', N'Durango')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (11, N'GRO', N'Guerrero')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (12, N'GTO', N'Guanajuato')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (13, N'HGO', N'Hidalgo')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (14, N'JAL', N'Jalisco')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (15, N'MEX', N'Estado de México')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (16, N'MICH', N'Michoacán')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (17, N'MOR', N'Morelos')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (18, N'NAY', N'Nayarit')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (19, N'NL', N'Nuevo León')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (20, N'OAX', N'Oaxaca')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (21, N'PUE', N'Puebla')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (22, N'QR', N'Quintana Roo')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (23, N'QRO', N'Queretaro')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (24, N'SIN', N'SINALOA')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (25, N'SLP', N'San Luis Potosí')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (26, N'SON', N'Sonora')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (27, N'TAB', N'Tabasco')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (28, N'TAM', N'Tamaulipas')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (29, N'TLX', N'Tlaxcala')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (30, N'VER', N'Veracruz')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (31, N'YUC', N'Yucatán')
INSERT [dbo].[PuEstados] ([IdEstado], [Estado], [Nombre]) VALUES (32, N'ZAC', N'Zacatecas')
SET IDENTITY_INSERT [dbo].[PuEstados] OFF
INSERT [dbo].[PuEstimacionesTipos] ([IdEstimacionTipo], [EstimacionTipo], [Sigla]) VALUES (1, N'NORMAL', N'N')
INSERT [dbo].[PuEstimacionesTipos] ([IdEstimacionTipo], [EstimacionTipo], [Sigla]) VALUES (2, N'EXCEDENTE', N'E')
INSERT [dbo].[PuEstimacionesTipos] ([IdEstimacionTipo], [EstimacionTipo], [Sigla]) VALUES (3, N'EXTRAORDINARIA', N'X')
SET IDENTITY_INSERT [dbo].[PuMonedas] ON 

INSERT [dbo].[PuMonedas] ([IdMoneda], [Moneda], [Descripcion], [RemateMoneda], [ParidadContratos], [EsCalculada], [DescripcionIngles], [RemateIngles]) VALUES (1, 0, N'PESOS', N'M.N.', CAST(1.00000000 AS Decimal(18, 8)), 0, NULL, NULL)
INSERT [dbo].[PuMonedas] ([IdMoneda], [Moneda], [Descripcion], [RemateMoneda], [ParidadContratos], [EsCalculada], [DescripcionIngles], [RemateIngles]) VALUES (2, 1, N'DOLARES', N'DLS', CAST(1.00000000 AS Decimal(18, 8)), 0, NULL, NULL)
INSERT [dbo].[PuMonedas] ([IdMoneda], [Moneda], [Descripcion], [RemateMoneda], [ParidadContratos], [EsCalculada], [DescripcionIngles], [RemateIngles]) VALUES (3, 2, N'EUROS', N'EURO', CAST(1.00000000 AS Decimal(18, 8)), 0, NULL, NULL)
SET IDENTITY_INSERT [dbo].[PuMonedas] OFF
SET IDENTITY_INSERT [dbo].[PuMovimientos] ON 

INSERT [dbo].[PuMovimientos] ([IdMovimiento], [Descripcion], [Suma]) VALUES (1, N'Retención', 0)
INSERT [dbo].[PuMovimientos] ([IdMovimiento], [Descripcion], [Suma]) VALUES (2, N'Devolución retención', 1)
INSERT [dbo].[PuMovimientos] ([IdMovimiento], [Descripcion], [Suma]) VALUES (3, N'Préstamo', 1)
INSERT [dbo].[PuMovimientos] ([IdMovimiento], [Descripcion], [Suma]) VALUES (4, N'Cobro préstamo', 0)
SET IDENTITY_INSERT [dbo].[PuMovimientos] OFF
SET IDENTITY_INSERT [dbo].[PuParametros] ON 

INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (1, N'RutaReportes', N'C:\Neodata2011R2\Reportes', N'Ruta para los formatos de reportes', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (2, N'DecimalesRedondeo', N'2', N'Número de decimales para el redondeo de importes', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (3, N'DescripcionBaseDeDatos', N'PU2011R2 27-09-2011', N'Descripción de la Base de Datos', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (4, N'DefaultTipoPartida', N'4', N'Tipo Insumo default en partidas', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (5, N'DefaultTipoMatriz', N'1', N'Tipo Insumo default en matrices', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (6, N'CHDefaultUnidadEsperaReserva', N'HR', N'Unidad que se propondrá para el insumo en espera y en reserva', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (7, N'CHDefaultUnidadLlantas', N'JGO', N'Unidad que se propondrá para el insumo de llantas', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (8, N'CHDefaultUnidadPiezas', N'JGO', N'Unidad que se propondrá para el insumo de piezas especiales', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (9, N'CHDefaultUnidadCombustible', N'LT', N'Unidad que se propondrá para el combustible del equipo', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (10, N'CHDefaultUnidadLubricante', N'LT', N'Unidad que se propondrá para el lubricante del equipo', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (11, N'CHDefaultUnidadVA', N'PZA', N'Unidad que se propondrá para el valor de adquisicion del equipo', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (12, N'CHpconsumosR', N'0', N'% de consumos en reserva', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (13, N'CHpconsumosE', N'0.05', N'% de consumos en espera', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (14, N'CHpdepreciacionR', N'0.15', N'% de depreciacion en reserva', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (15, N'CHpdepreciacionE', N'1', N'% de depreciacion en espera', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (16, N'CHpinversionR', N'1', N'% de inversion en reserva', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (17, N'CHpinversionE', N'1', N'% de inversion en espera', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (18, N'CHpllantasR', N'0', N'% de llantas en reserva', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (19, N'CHpllantasE', N'0.15', N'% de llantas en espera', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (20, N'CHplubricanteR', N'0', N'% de lubricante en reserva', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (21, N'CHplubricanteE', N'0.05', N'% de lubricante en espera', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (22, N'CHpmantenimientoR', N'0.15', N'% de mantenimiento en reserva', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (23, N'CHpmantenimientoE', N'0', N'% de mantenimiento en espera', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (24, N'CHpoperacionR', N'1', N'% de operacion en reserva', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (25, N'CHpoperacionE', N'1', N'% de operacion en espera', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (26, N'CHppiezasR', N'0', N'% de piezas especiales en reserva', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (27, N'CHppiezasE', N'0', N'% de piezas especiales en espera', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (28, N'CHpsegurosR', N'1', N'% de seguros en reserva', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (29, N'CHpsegurosE', N'1', N'% de seguros en espera', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (30, N'DecimalesRedondeoConceptos', N'4', N'Número de decimales para el redondeo de cantidades en conceptos', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (31, N'DecimalesRedondeoMatrices', N'6', N'Número de decimales para el redondeo de cantidades en matrices', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (32, N'UltimaSesion', NULL, N'Se guarda el estado de Presupuestos abiertos en la última sesión', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (33, N'AbrirAyudaEnEdicion', N'0', N'Determina que el usuario abra la ayuda en modo de edición', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (34, N'CHDefaultUnidadPotencia', N'HP', N'Unidad Default para la potencia en Costos Horarios', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (35, N'SegundaMonedaEnPresupuesto', NULL, N'Define si se muestran columnas adicionales con datos de una segunda moneda', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (36, N'TercerMonedaEnPresupuesto', NULL, N'Define si se muestran columnas adicionales con datos de una tercer moneda', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (37, N'CuartaMonedaEnPresupuesto', NULL, N'Define si se muestran columnas adicionales con datos de una primera moneda', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (38, N'OPArea', N'AREA', N'Área donde se realizará la obra', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (39, N'OPDepartamento', N'DEPARTAMENTO', N'Departamento donde se realizará la obra', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (40, N'OPLibroFasar', N'', N'Libro Fasar', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (41, N'OPLibroSobrecosto', N'', N'Libro Sobrecosto', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (42, N'OPLibroCH', N'EstandarCostoHorario', N'Libro Costos Horarios', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (43, N'OPFechaLicitacion', N'36526', N'Fecha de lalicitación', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (44, N'OPNumeroLicitacion', N'LICITACIÓN', N'Número de licitación', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (45, N'OPLugarCelebracion', N'MÉXICO, D. F.', N'Lugar de celebración de la licitación', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (46, N'OPNumeroConvocatoria', N'CONVOCATORIA', N'Número de convocatoria', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (47, N'OPFechaPublicacion', N'36526', N'Fecha de poblicación', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (48, N'IVA', N'0.16', N'Porcentaje de iva de la obra', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (49, N'OPSobrepasarCantidadContratos', N'0', N'Permite sobrepasar la cantidad del contrato', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (50, N'OPSobrepasarCostoContratos', N'0', N'Permite sobrepasar el costo de los contratos', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (51, N'DecimalesRedondeoExpIns', N'8', N'Número de decimales para el redondeo de cantidades en explosión de insumos', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (52, N'OPOficios', N'', N'Libro Oficios', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (53, N'OPPieIndirectos', N'', N'Libro para Pie de indirectos', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (54, N'NivCen1', N'3', N'Ubicaciones', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (55, N'NivCen2', N'3', N'Ubicaciones', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (56, N'NivCen3', N'2', N'Ubicaciones', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (57, N'NivCen4', N'0', N'Ubicaciones', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (58, N'NivCen5', N'0', N'Ubicaciones', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (59, N'NivCen6', N'0', N'Ubicaciones', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (60, N'NivCen7', N'0', N'Ubicaciones', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (61, N'MascaraCentro', N'-', N'Mascara para Ubicaciones', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (62, N'NoNivelesPartidas', N'0', N'Número de niveles de partidas', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (63, N'NivelesPartidas', NULL, N'Valores separados por comas del tamaño por nivel', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (64, N'FRiesgoTrabajo', N'7.58875', N'Fasar Riesgo de trabajo', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (65, N'FPagosTerceros', N'0', N'Fasar Pagos a terceros', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (66, N'FSalarioMinimo', N'57.46', N'Fasar Salario mínimo', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (67, N'FAñoAplicacion', N'2009', N'Fasar Año de aplicación', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (68, N'FConsiderarPrestaciones', N'1', N'Fasar Considerar prestaciones', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (69, N'CHFactorLubricanteSinHP', N'0.003', N'CH Factor de lubricante para potencia 0', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (70, N'CHFactorLubricanteConHP', N'0.0033', N'CH Factor de lubricante para potencia mayor que cero', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (71, N'CHFactorGasolina', N'0.2271', N'CH Factor de combustible (gasolina)', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (72, N'CHFactorDiesel', N'0.1514', N'CH Factor de combustible (diesel)', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (73, N'CHFactorOtros', N'0', N'CH Factor de combustible (Otros)', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (74, N'CHExplotarInsumos', N'0', N'CH Indica si se explotan los consumos y la operacion del costo horario', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (75, N'OPUsarPieIndirectos', N'0', N'Indica que el pie de indirectos interviene en el cálculo', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (76, N'OrdenarMatricesPorTipo', N'1', NULL, 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (77, N'OPEmpresa', N'EMPRESA1', N'Los presupuestos nuevos propondrán esta empresa por default', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (78, N'SCFactorSFP', N'0.005', N'Factor para la obtencion de la SFP', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (79, N'SCIndicadorReferencia', N'TIIE', N'Indicador Economico de Refenercnia', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (80, N'SCPorcentajeUtilidadPropuesta', N'0', N'Porcentaje de Utilidad propuesta', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (81, N'SCTasaIniteres', N'0', N'Tasa de interes usada', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (82, N'SCPuntosBanco', N'0', N'Porcentaje de puntos del banco', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (83, N'SCPorcentajeAnticipo1', N'0', N'Porcentaje del primer Anticipo', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (84, N'SCPorcentajeIndirectoTotal', N'0', N'Porcentaje de Pie de indirectos', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (85, N'SCTipoAnticipo', N'1', N'Tipo de anticipo', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (86, N'SCPorcentajeAnticipo2', N'0', N'Porcentaje del segundo Anticipo', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (87, N'SCImporteEjercicio1', N'0', N'Importe del primer ejercicio presupuestal', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (88, N'SCLibroSobrecosto', N'0', N'Libro de sobrecosto', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (89, N'SCPrograma', N'0', N'Programa de Obra', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (90, N'SCMoneda', N'0', N'Moneda a reportar', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (91, N'SCLibroIndirectos', N'0', N'Libro de pie de indirectos', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (92, N'SCPeriodoEntregaAnticipo2', N'0', N'Periodo de entrega del segundo anticipo', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (93, N'SeparadorPartidas', N'.', N'Separador de partidas para el pegado desde excel', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (94, N'MostrarCostoPrecioEnPpto', N'0', N'Mostrar Costo = 0, Precio = 1 en Presupuesto', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (95, N'SCIndirecto', N'0', N'Porcentaje de Indirecto', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (96, N'SCIndirectoCampo', N'0', N'Porcentaje de Indirecto de Campo', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (97, N'SCIndirectoOficina', N'0', N'Porcentaje de Indirecto de Oficinas', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (98, N'SCFinanciamiento', N'0', N'Porcentaje de Financiamiento', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (99, N'SCUtilidad', N'0', N'Porcentaje de Utilidad', 1)
GO
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (100, N'SCCargosAdicionales', N'0', N'Porcentaje Cargos Adicionales', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (101, N'NumeroRenglonesCatalogo', N'0', N'Numero de renglones maximo para el catálogo general', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (102, N'RutaLogotipoReportes', N'C:\Neodata2011R2\Reportes\LogoNeodata.jpg', N'Ruta del Logotipo de Reportes', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (103, N'OPResponsable', N'RES001', N'Los presupuestos nuevos propondrán este responsable por default', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (104, N'OPPeriodicidad', N'', N'Periodicidad', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (105, N'OPFechaInicio', N'36526', N'Fecha de inicio del programa de obra.', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (106, N'OPFechaTerminacion', N'36526', N'Fecha de terminación del programa de obra.', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (107, N'OPProgramaObraActivo', N'0', N'Indicas el programa de obra activo', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (108, N'CalculoTipoExplosion', N'0', N'Tipo de explosión de insumos calculada 0=Todo el presupuesto, 1=Los marcados, 2= No calcular explosion', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (109, N'CalculoDecimalesExplosion', N'6', N'Numero de decimales para el calculo de la cantidad de la explosion de insumos', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (110, N'CalculoMostrarErrores', N'0', N'Mostrar la ventana de errores potenciales al terminar el calculo', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (111, N'CalculoOrdenarMatrices', N'0', N'Ordenar las matrices por tipo de insumo', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (112, N'CalculoMismaTasaTCH', N'0', N'Calcular los costos horarios con la misma tasa de interes', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (113, N'CalculoExpXConcepto', N'0', N'Calcular la explosión de insumos x concepto', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (114, N'CalculoExpXPartida', N'0', N'Calcular la explosión de insumos x partida', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (115, N'CalculoExplotarTch', N'1', N'Explotar los insumos de costos horarios', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (116, N'CalculoNoExplotarIntegrados', N'0', N'No explotar los insumos integrados', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (117, N'CalculoProgSum', N'0', N'Calcular el programa de suministros', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (118, N'CalculoProgSumXPar', N'0', N'Calcular el programa de suministros por partida', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (119, N'CalculoUltimaMoneda', N'0', N'Ultima moneda calculada', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (120, N'CalculoUltimoPrograma', N'-1', N'Ultimo programa calculado', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (121, N'OPPlazo', N'0', N'Duración de la obra en días naturales', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (122, N'ImportacionObra2009', N'', N'Nombre de la ultima obra 2009 de la que se importó', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (123, N'SCImporteMoGravable', N'0', N'Importe de la mano de obra gravable del presupuesto', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (124, N'ReportesCompatiblesExcel', N'1', N'Generar reportes con compatibilidad para excel', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (125, N'NumeroPaginasExportarExcel', N'500', N'Número de páginas por hoja para exportar los reportes a excel', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (126, N'MostrarImagen', N'0', N'Indica si se mostrara o no las imágenes en el sistema', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (127, N'OPCiudad', N'DF', N'Ciudad que se propondrá en todas las obras nuevas', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (128, N'FSar', N'2', N'Factor de SAR para el patrón', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (129, N'FInfonavit', N'5', N'Fator de Inonavit para el patrón', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (130, N'FNomina', N'0', N'Facto de Impuesto sobre nómina', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (131, N'AnchoCodigo', N'12', N'Ancho del código autogenerado por ''''?''''', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (132, N'CHpOtrasFuentesR', N'0', N'% de otras fuentes de energia en reserva', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (133, N'CHpOtrasFuentesE', N'0.05', N'% de otras fuentes de energia en espera', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (134, N'BuscarInsumosEnMaestro', N'1', N'Define si los insumos por agregar se buscan en la explosión de insumos del maestro o en e catálogo general', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (135, N'MascaraPresupuesto', N'OBRA-####', N'Máscara para creación del código del presupuesto', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (136, N'ConsecutivoPresupuesto', N'1', N'Consecutivo para creación del código del presupuesto', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (137, N'GenerarPptoAutomatico', N'0', N'Generar el código de presupuesto en automático', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (138, N'CHIndicadorReferencia', N'TIIE', N'Indicador Economico de Refenercnia', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (139, N'CHIndicadorMercado', N'TIIE', N'Indicador Especifico de mercado de Seguros', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (140, N'FechaDeCorte', N'36526', N'Fecha de corte para marcar los conceptos a estimar', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (141, N'NivelPartidaUbicacion', N'1', N'Nivel de partida para la ubicación', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (142, N'ContratanteDestajos', NULL, N'contratante para los contratos de pago y destajo', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (143, N'PeriodoDeCorte', NULL, N'Se usa para el cálculo del programa de suministros acumulado', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (144, N'RutaFiltro', N'0', N'El tipo de filtro seleccionado ', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (145, N'RutaIdFiltro', N'0', N'Id del tipo de filtro seleccionado', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (146, N'FacturaEstimacionDestajo', NULL, N'Documento para contratos de destajo para la factura de estimación', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (147, N'SoloOficiosParamRelacionados', N'0', N'Solo mostrar parametros relacionados a obra en la ventana oficios', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (148, N'CVServidor', N'(LOCAL)', N'Servidor BD para comunicación con CV', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (149, N'CVBaseDatos', N'', N'Base de datos para comunicación con CV', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (150, N'CVUsuarioBD', N'', N'Usuario de BD para comunicación con CV', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (151, N'CVContraseniaBD', N'', N'Contraseña de BD para comunicación con CV', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (152, N'CVAutenticacionWindows', N'0', N'Indica si se usará autenticación windows en la comunicación con CV', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (153, N'CVProyecto', N'', N'Proyecto de CV relacionado con la obra de PU2010', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (154, N'RutaLicitaciones', NULL, N'Ruta del archivo de licitaciones', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (155, N'ConModificarPrograma', N'0', N'Modificar programa vigente al generar estimaciones', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (156, N'DiasVigenciaCurcContratista', N'365', N'Días para la vigencia de la CURC de un Contratista', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (157, N'NombreDirectorObras', N'Director de la obra', N'Nombre del Director de la Obra', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (158, N'ContratistaVigencia', N'365', N'Vigencia de un Contratista en días', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (159, N'EnvioCorreoCuenta', NULL, N'Cuenta de correo para envio de correos', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (160, N'EnvioCorreoServidor', NULL, N'Servidor de correo para envio de correos', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (161, N'EnvioCorreoPuerto', NULL, N'Puerto para envio de correos', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (162, N'EnvioCorreoUsuario', NULL, N'Usuario para envio de correos', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (163, N'EnvioCorreoContraseña', NULL, N'Contraseña para envio de correos', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (164, N'DividirDescripcionCada', N'500', N'Dividir la descripción cada n caracteres para reportes', 1)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (165, N'RptTipoPapel', N'1', N'Representa el tipo de papel a utilizar para la impresión', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (166, N'RptAncho', N'0', N'Representa el ancho del papel a utilizar', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (167, N'RptAlto', N'0', N'Representa el alto del papel a utilizar', 0)
INSERT [dbo].[PuParametros] ([IdParametro], [Parametro], [Valor], [Explicacion], [Especifico]) VALUES (168, N'IndiceReferencia', NULL, N'Id del tipo de indice uitlizado para ajuste', 1)
SET IDENTITY_INSERT [dbo].[PuParametros] OFF
SET IDENTITY_INSERT [dbo].[PuReferenciaAcad] ON 

INSERT [dbo].[PuReferenciaAcad] ([IdReferenciaAcad], [Referencia], [Descripcion]) VALUES (1, 1, N'Item')
INSERT [dbo].[PuReferenciaAcad] ([IdReferenciaAcad], [Referencia], [Descripcion]) VALUES (2, 2, N'Longitud')
INSERT [dbo].[PuReferenciaAcad] ([IdReferenciaAcad], [Referencia], [Descripcion]) VALUES (3, 3, N'Superficie "A"')
INSERT [dbo].[PuReferenciaAcad] ([IdReferenciaAcad], [Referencia], [Descripcion]) VALUES (4, 6, N'Volumen')
SET IDENTITY_INSERT [dbo].[PuReferenciaAcad] OFF
SET IDENTITY_INSERT [dbo].[PuResponsables] ON 

INSERT [dbo].[PuResponsables] ([IdResponsable], [Responsable], [Nombre], [Cargo], [Telefono], [Mail]) VALUES (1, N'RES001', N'ING. JORGE DAVALOS', N'DIRECTOR GENERAL', NULL, NULL)
SET IDENTITY_INSERT [dbo].[PuResponsables] OFF
INSERT [dbo].[PuTipoInsumos] ([IdTipo], [Descripcion]) VALUES (1, N'MATERIALES')
INSERT [dbo].[PuTipoInsumos] ([IdTipo], [Descripcion]) VALUES (3, N'EQUIPO Y HERRAMIENTA')
INSERT [dbo].[PuTipoInsumos] ([IdTipo], [Descripcion]) VALUES (2, N'MANO DE OBRA')
INSERT [dbo].[PuTipoInsumos] ([IdTipo], [Descripcion]) VALUES (4, N'BASICOS')
INSERT [dbo].[PuTipoInsumos] ([IdTipo], [Descripcion]) VALUES (5, N'SUBCONTRATOS')
INSERT [dbo].[PuTiposDocumentos] ([IdTipoDocumento], [TipoDocumento], [Word], [AceptaImagen]) VALUES (1, N'Sobrecosto', 0, 0)
INSERT [dbo].[PuTiposDocumentos] ([IdTipoDocumento], [TipoDocumento], [Word], [AceptaImagen]) VALUES (2, N'Fasar', 0, 0)
INSERT [dbo].[PuTiposDocumentos] ([IdTipoDocumento], [TipoDocumento], [Word], [AceptaImagen]) VALUES (3, N'Costos horarios', 0, 0)
INSERT [dbo].[PuTiposDocumentos] ([IdTipoDocumento], [TipoDocumento], [Word], [AceptaImagen]) VALUES (4, N'Oficios', 1, 0)
INSERT [dbo].[PuTiposDocumentos] ([IdTipoDocumento], [TipoDocumento], [Word], [AceptaImagen]) VALUES (5, N'Pie de indirectos', 0, 1)
INSERT [dbo].[PuTiposDocumentos] ([IdTipoDocumento], [TipoDocumento], [Word], [AceptaImagen]) VALUES (6, N'Factura de estimaciones', 0, 0)
INSERT [dbo].[PuTiposDocumentos] ([IdTipoDocumento], [TipoDocumento], [Word], [AceptaImagen]) VALUES (7, N'Plantillas contratos', 1, 0)
SET IDENTITY_INSERT [dbo].[PuTiposLicitacion] ON 

INSERT [dbo].[PuTiposLicitacion] ([IdTipoLicitacion], [Tipo], [DescripcionTipo]) VALUES (1, N'Ia', N'LICITACIÓN PÚBLICA NACIONAL')
INSERT [dbo].[PuTiposLicitacion] ([IdTipoLicitacion], [Tipo], [DescripcionTipo]) VALUES (2, N'Ib', N'LICITACIÓN PÚBLICA INTERNACIONAL')
INSERT [dbo].[PuTiposLicitacion] ([IdTipoLicitacion], [Tipo], [DescripcionTipo]) VALUES (3, N'II', N'INVITACIÓN A CUANDO MENOS TRES PERSONAS')
INSERT [dbo].[PuTiposLicitacion] ([IdTipoLicitacion], [Tipo], [DescripcionTipo]) VALUES (4, N'III', N'ADJUDICACIÓN DIRECTA')
SET IDENTITY_INSERT [dbo].[PuTiposLicitacion] OFF
SET IDENTITY_INSERT [dbo].[PuUnidades] ON 

INSERT [dbo].[PuUnidades] ([IdUnidad], [Unidad], [Descripcion]) VALUES (1, N'HR', N'HORA')
INSERT [dbo].[PuUnidades] ([IdUnidad], [Unidad], [Descripcion]) VALUES (2, N'JGO', N'JUEGO')
INSERT [dbo].[PuUnidades] ([IdUnidad], [Unidad], [Descripcion]) VALUES (3, N'LT', N'LITRO')
INSERT [dbo].[PuUnidades] ([IdUnidad], [Unidad], [Descripcion]) VALUES (4, N'PZA', N'PIEZA')
INSERT [dbo].[PuUnidades] ([IdUnidad], [Unidad], [Descripcion]) VALUES (5, N'HP', N'HORSE POWER')
SET IDENTITY_INSERT [dbo].[PuUnidades] OFF
INSERT [dbo].[SegGrupoPermisos] ([IdGrupoPermiso], [GrupoPermiso], [IdSistema]) VALUES (502, N'Catálogos', 5)
INSERT [dbo].[SegGrupoPermisos] ([IdGrupoPermiso], [GrupoPermiso], [IdSistema]) VALUES (503, N'Control de Obra', 5)
INSERT [dbo].[SegGrupoPermisos] ([IdGrupoPermiso], [GrupoPermiso], [IdSistema]) VALUES (507, N'Corporativo', 5)
INSERT [dbo].[SegGrupoPermisos] ([IdGrupoPermiso], [GrupoPermiso], [IdSistema]) VALUES (501, N'Herramientas', 5)
INSERT [dbo].[SegGrupoPermisos] ([IdGrupoPermiso], [GrupoPermiso], [IdSistema]) VALUES (506, N'Licitaciones', 5)
INSERT [dbo].[SegGrupoPermisos] ([IdGrupoPermiso], [GrupoPermiso], [IdSistema]) VALUES (505, N'Presupuesto', 5)
INSERT [dbo].[SegGrupoPermisos] ([IdGrupoPermiso], [GrupoPermiso], [IdSistema]) VALUES (508, N'Reportes', 5)
INSERT [dbo].[SegGrupoPermisos] ([IdGrupoPermiso], [GrupoPermiso], [IdSistema]) VALUES (504, N'Ruta crítica', 5)
INSERT [dbo].[SegGrupoPermisos] ([IdGrupoPermiso], [GrupoPermiso], [IdSistema]) VALUES (500, N'Sistema', 5)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (1, N'Herramientas', N'Seguridad', N'Seguridad', N'btnSeguridad', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (2, N'Herramientas', N'Opciones', N'Opciones', N'btnOpciones', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (3, N'Herramientas', N'Importaciones', N'Importar general de PU2009', N'btnImportarGeneral2009', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (4, N'Catálogos', N'Catálogos', N'Ciudades', N'btnCatCiudades', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (5, N'Catálogos', N'Catálogos', N'Ciudades (Escritura)', N'ModificarCatCiudades', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (6, N'Catálogos', N'Catálogos', N'Estados', N'btnCatEstados', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (7, N'Catálogos', N'Catálogos', N'Estados (Escritura)', N'ModificarCatEstados', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (8, N'Catálogos', N'Catálogos', N'Familias', N'btnCatFamilias', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (9, N'Catálogos', N'Catálogos', N'Familias (Escritura)', N'ModificarCatFamilias', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (10, N'Catálogos', N'Catálogos', N'Fichas Técnicas', N'btnCatFichas', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (11, N'Catálogos', N'Catálogos', N'Fichas Técnicas (Escritura)', N'ModificarCatFichas', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (12, N'Catálogos', N'Catálogos', N'General', N'btnCatGeneral', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (13, N'Catálogos', N'Catálogos', N'General (Escritura)', N'ModificarCatGeneral', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (14, N'Catálogos', N'Catálogos', N'Mano de Obra', N'btnCatGeneralMo', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (15, N'Catálogos', N'Catálogos', N'Mano de Obra (Escritura)', N'ModificarCatGeneralMO', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (16, N'Catálogos', N'Catálogos', N'Materiales', N'btnCatGeneralMat', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (17, N'Catálogos', N'Catálogos', N'Materiales (Escritura)', N'ModificarCatGeneralMAT', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (18, N'Catálogos', N'Catálogos', N'Maquinaria', N'btnCatGeneralMaq', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (19, N'Catálogos', N'Catálogos', N'Maquinaria (Escritura)', N'ModificarCatGeneralEQ', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (20, N'Catálogos', N'Catálogos', N'Imágenes', N'btnCatImagenes', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (21, N'Catálogos', N'Catálogos', N'Imágenes (Escritura)', N'ModificarCatImagenes', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (22, N'Catálogos', N'Catálogos', N'Procedimientos', N'btnCatProcedimientos', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (23, N'Catálogos', N'Catálogos', N'Procedimientos (Escritura)', N'ModificarCatProcedimientos', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (24, N'Catálogos', N'Catálogos', N'Proveedores', N'btnCatProveedores', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (25, N'Catálogos', N'Catálogos', N'Proveedores (Escritura)', N'ModificarCatProveedores', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (26, N'Catálogos', N'Catálogos', N'Tipos de Insumo', N'btnCatTiposInsumo', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (27, N'Catálogos', N'Catálogos', N'Tipos de Insumo (Escritura)', N'ModificarCatTiposDeInsumo', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (28, N'Catálogos', N'Catálogos', N'Unidades', N'btnCatUnidades', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (29, N'Catálogos', N'Catálogos', N'Unidades (Escritura)', N'ModificarCatUnidades', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (30, N'Control de Obra', N'Catálogos', N'Listado de Contratistas', N'btnCatContratistas', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (31, N'Control de Obra', N'Catálogos', N'Contratistas', N'btnDetContratistas', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (32, N'Control de Obra', N'Contratos', N'Contratos', N'btnContratos', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (33, N'Catálogos', N'Catálogos', N'Clientes', N'btnCatClientes', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (34, N'Catálogos', N'Catálogos', N'Responsables', N'btnCatResponsables', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (35, N'Catálogos', N'Catálogos', N'Intelimat', N'btnCatIntelimat', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (36, N'Catálogos ', N'Catálogos ', N'Intelimat (Escritura)', N'ModificarIntelimat', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (37, N'Ruta crítica', N'Ruta crítica', N'Definir mas de un programa de obra', N'DefineVariosProgramas', 504, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (38, N'Catálogos', N'Catálogos', N'Monedas', N'btnCatMonedas', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (39, N'Catálogos', N'Catálogos', N'Monedas (Escritura)', N'ModificarCatMonedas', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (40, N'Catálogos', N'Catálogos', N'Calendarios', N'btnCatCalendarios', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (41, N'Catálogos', N'Catálogos', N'Calendarios (Escritura)', N'ModificarCatCalendarios', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (42, N'Control de Obra', N'Catálogos', N'Plantillas', N'btnPlantillasContratos', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (43, N'Presupuesto', N'Catálogos', N'Mano de Obra', N'btnxManoDeObra', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (44, N'Presupuesto', N'Catálogos', N'Mano de Obra (Escritura)', N'ModificarPresupuestoMO', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (45, N'Presupuesto', N'Catálogos', N'Maquinaria', N'btnxMaquinaria', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (46, N'Presupuesto', N'Catálogos', N'Maquinaria (Escritura)', N'ModificarPresupuestoEQ', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (47, N'Catálogos', N'Catálogos', N'Obras', N'btnCatObras', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (48, N'Catálogos', N'Catálogos', N'Obras (Escritura)', N'ModificarCatObras', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (49, N'Presupuesto', N'Costos Horarios', N'Costos Horarios', N'AbrirCostosHorarios', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (50, N'Presupuesto', N'Costos Horarios', N'Costos Horarios  (Escritura)', N'ModificarCostosHorarios', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (51, N'Catálogos', N'Catálogos', N'Empresas', N'btnCatEmpresas', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (52, N'Catálogos', N'Catálogos', N'Empresas (Escritura)', N'ModificarCatEmpresas', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (53, N'Control de Obra', N'Estimaciones', N'Generadores', N'btnGeneradores', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (54, N'Presupuesto', N'Catálogo', N'Insumos y Conceptos', N'btnxExpIns', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (55, N'Presupuesto', N'Catálogo', N'Insumos y Conceptos (Escritura)', N'ModificarInsumosConceptos', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (56, N'Control de Obra', N'Catálogos', N'Ubicaciones', N'btnUbicaciones', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (57, N'Catálogos', N'Catálogos', N'Responsables (Escritura)', N'ModificarCatResponsables', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (58, N'Catálogos', N'Catálogos', N'Clientes (Escritura)', N'ModificarCatClientes', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (59, N'Control de Obra', N'Catálogos', N'Deducciones', N'btnCatDeducciones', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (60, N'Control de Obra', N'Catálogos', N'Deducciones(Escritura)', N'ModificarCatDeducciones', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (61, N'Presupuesto', N'Catálogos', N'Materiales', N'btnxMateriales', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (62, N'Presupuesto', N'Catálogos', N'Materiales (Escritura)', N'ModificarPresupuestoMat', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (63, N'Presupuesto', N'Presupuesto', N'Depurar', N'DepurarPresupuesto', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (64, N'Presupuesto', N'Presupuesto', N'Unificar Códigos', N'UnificarCodigos', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (65, N'Presupuesto', N'Presupuesto', N'Participa', N'AbrirParticipa', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (66, N'Presupuesto', N'Presupuesto', N'Participa (Escritura)', N'ModificarParticipa', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (67, N'Presupuesto', N'Presupuesto', N'Participa (Eliminar Insumo)', N'EliminarInsumoParticipa', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (68, N'Presupuesto', N'Catálogo', N'Insumos y Conceptos Afectar Costos', N'AfectarCostos', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (69, N'Presupuesto', N'Presupuesto', N'Actualizar costos', N'btnxActualizarCostos', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (70, N'Presupuesto', N'Presupuesto', N'Consulta presupuesto completo', N'btnxConsultaPresupuestoCompleto', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (71, N'Control de Obra', N'Estimaciones', N'Estatus Elaborada', N'EstimacionesElaborada', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (72, N'Control de Obra', N'Estimaciones', N'Estatus En revisión', N'EstimacionesEnRevision', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (73, N'Control de Obra', N'Estimaciones', N'Estatus Aprobada', N'EstimacionesAprobada', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (74, N'Control de Obra', N'Estimaciones', N'Estatus Pagada', N'EstimacionesPagada', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (75, N'Control de Obra', N'Estimaciones', N'Cancelar Estimación', N'EstimacionesCancelar', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (76, N'Presupuesto', N'Oficios', N'Oficios', N'AbrirOficios', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (77, N'Presupuesto', N'Oficios', N'Oficios', N'btnxGenerarOficios', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (78, N'Presupuesto', N'Oficios', N'Oficios (Escritura)', N'ModificarOficios', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (79, N'Control de Obra', N'Estimaciones', N'Estimaciones', N'btnxEstimaciones', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (80, N'Catálogos', N'Catálogos', N'Documentos', N'btnCatDocumentos', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (81, N'Catálogos', N'Catálogos', N'Documentos (Escritura)', N'ModificarDocumentos', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (82, N'Control de Obra', N'Estimaciones', N'Estimado Vs. Programado', N'btnxEstimaVsProgr', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (83, N'Herramientas', N'Opciones', N'Eliminar Obras', N'EliminarPresupuestos', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (84, N'Control de Obra', N'Contratos', N'Autorizar contratos', N'AutorizarContratos', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (85, N'Control de Obra', N'Contratos', N'Finiquitar contratos', N'FiniquitarContratos', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (86, N'Control de Obra', N'Contratos', N'Cancelar contratos', N'CancelarContratos', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (87, N'Herramientas', N'Opciones', N'Eliminar catálogo de obras', N'EliminarBaseDeDatos', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (88, N'Herramientas', N'Opciones', N'Ejecutar SQL', N'EjecutarSQL', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (89, N'Control de Obra', N'Generadores', N'Estatus Avance físico', N'GeneradorAvanceFisico', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (90, N'Control de Obra', N'Generadores', N'Estatus En conciliación', N'GeneradorEnConciliacion', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (91, N'Control de Obra', N'Generadores', N'Estatus Conciliado', N'GeneradorConciliado', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (92, N'Herramientas', N'Opciones', N'Importar Seguridad', N'cmdImportarSeguridad', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (93, N'Presupuesto', N'Presupuesto', N'Máscara de código de obra', N'MascaraCodigoObra', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (94, N'Catálogos', N'Catálogos', N'Vendedores', N'btnCatVendedores', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (95, N'Catálogos', N'Catálogos', N'Vendedores (Escritura)', N'ModificarCatVendedores', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (96, N'Herramientas', N'Opciones', N'Asignar Obra Bloqueada', N'ObraBloqueada', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (97, N'Herramientas', N'Opciones', N'Asignar Obra Maestro', N'ObraMaestro', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (98, N'Herramientas', N'Opciones', N'Ver todas las obras (Lectura)', N'VerTodasLasObrasLectura', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (99, N'Herramientas', N'Opciones', N'Ver todas las obras (Escritura)', N'VerTodasLasObrasEscritura', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (100, N'Catálogos', N'Catálogos', N'Tipos de licitación', N'btnCatTiposLicitacion', 502, 5, 0)
GO
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (101, N'Catálogos', N'Catálogos', N'Tipos de licitación (Escritura)', N'ModificarCatTiposLicitacion', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (102, N'Presupuesto', N'Presupuesto', N'Convertir matrices a partidas', N'btnxConvertirMatricesAPartidas', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (103, N'Herramientas', N'Seguridad', N'Seguridad por Proyecto', N'btnSeguridadProyecto', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (104, N'Presupuesto', N'Presupuesto', N'Importar Opus', N'btnImportarOpus', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (105, N'Presupuesto', N'Presupuesto', N'Importar ArchiCad', N'btnImportarArchicad', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (106, N'Presupuesto', N'Presupuesto', N'Importar Revit', N'btnImportarRevit', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (107, N'Presupuesto', N'Catálogos', N'Matrices de Básicos', N'btnMatricesBasicos', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (108, N'Control de Obra', N'Generadores', N'Captura masiva de destajos', N'GeneradoresPorDestajo', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (109, N'Control de Obra', N'Catálogos', N'Actividades por contratista', N'AsignarActividadesContr', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (110, N'Control de Obra', N'Catálogos', N'Costos de destajo', N'btnxCostosDestajo', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (111, N'Control de Obra', N'Catálogos', N'Costos de destajo(Escritura)', N'CostosDestajo', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (112, N'Presupuesto', N'Presupuesto', N'Fasar', N'btnxFASAR', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (113, N'Presupuesto', N'Presupuesto', N'SobreCostos', N'btnxSobrecosto', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (114, N'Presupuesto', N'Presupuesto', N'Ruta Crítica', N'btnxRutaCritica', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (115, N'Control de Obra', N'Catálogos', N'Retenciones', N'btnxRetenciones', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (116, N'Control de Obra', N'Catálogos', N'Retenciones (Escritura)', N'Retenciones', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (117, N'Presupuesto', N'Presupuesto', N'Partidas por niveles', N'btnxPartidasPorNiveles', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (118, N'Herramientas', N'Opciones', N'Convertir catálogo de obras a estandar', N'btnxConvertirBDEstandar', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (119, N'Control de Obra', N'Generadores', N'Editar Retención', N'EditarRetencion', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (120, N'Control de Obra', N'Generadores', N'Editar Fondo de Garantía', N'EditarFondoGarantia', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (121, N'Control de Obra', N'Generadores', N'Conciliar Generador Directo', N'ConciliarGeneradorDirecto', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (122, N'Presupuesto', N'Presupuesto', N'Generar archivo intercambio', N'btnxGenerarArchivoIntercambio', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (123, N'Presupuesto', N'Presupuesto', N'Recibir archivo intercambio', N'btnxRecibirArchivoIntercambio', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (124, N'Control de Obra', N'Estimaciones', N'Devolución del Fondo de Garantía', N'btnxDevolucionFondoGarantia', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (125, N'Control de Obra', N'Estimaciones', N'Exportación a SAP', N'btnExportacionSAP', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (126, N'Licitaciones', N'Catálogos', N'Tipo Proveedor', N'btnxCatTipoProveedor', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (127, N'Licitaciones', N'Catálogos', N'Tipo Proveedor (Escritura)', N'CatTipoProveedorEscritura', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (128, N'Licitaciones', N'Catálogos', N'Sesión CAOP', N'btnxCatSesionCAOP', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (129, N'Licitaciones', N'Catálogos', N'Sesión CAOP (Escritura)', N'CatSesionCAOPEscritura', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (130, N'Licitaciones', N'Catálogos', N'Empresas Afinanzadoras', N'btnxCatEmpresasAfianzadoras', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (131, N'Licitaciones', N'Catálogos', N'Empresas Afinanzadoras (Escritura)', N'CatEmpresasAfianzadorasEscritura', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (132, N'Licitaciones', N'Catálogos', N'Cámaras', N'btnxCatCamaras', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (133, N'Licitaciones', N'Catálogos', N'Cámaras (Escritura)', N'CatCamarasEscritura', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (134, N'Licitaciones', N'Catálogos', N'Estatus Control Padrón', N'btnxCatEstatusControlPadron', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (135, N'Licitaciones', N'Catálogos', N'Estatus Control Padrón (Escritura)', N'CatEstatusControlPadronEscritura', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (136, N'Licitaciones', N'Catálogos', N'Especialidades Contratistas', N'btnxCatEspecialidadesContratistas', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (137, N'Licitaciones', N'Catálogos', N'Especialidades Contratistas (Escritura)', N'CatEspecialidadesContratistasEscritura', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (138, N'Licitaciones', N'Catálogos', N'Maquinaria Contratistas', N'btnxCatMaquinariaContratistas', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (139, N'Licitaciones', N'Catálogos', N'Maquinaria Contratistas (Escritura)', N'CatMaquinariaContratistasEscritura', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (140, N'Licitaciones', N'Catálogos', N'Documentos Contratistas', N'btnxCatDocumentosContratistas', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (141, N'Licitaciones', N'Catálogos', N'Documentos Contratistas (Escritura)', N'CatDocumentosContratistasEscritura', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (142, N'Licitaciones', N'Catálogos', N'Documentos Contratos', N'btnxCatDocumentosContratos', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (143, N'Licitaciones', N'Catálogos', N'Documentos Contratos (Escritura)', N'CatDocumentosContratosEscritura', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (144, N'Licitaciones', N'Catálogos', N'Contribuyentes', N'btnxCatContribuyentes', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (145, N'Licitaciones', N'Catálogos', N'Contribuyentes (Escritura)', N'CatContribuyentesEscritura', 506, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (146, N'Corporativo', N'Corporativo', N'Generar versión de obra', N'btnGeneraHistorico', 507, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (147, N'Corporativo', N'Corporativo', N'Bitacora de costos (lectura)', N'btnBitacoraCostos', 507, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (148, N'Corporativo', N'Corporativo', N'Bitacora de costos (Eliminar)', N'DepurarBitacoraCostos', 507, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (149, N'Corporativo', N'Corporativo', N'Consulta obras (lectura)', N'btnObraHistoricoConsulta', 507, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (150, N'Corporativo', N'Corporativo', N'Consulta obras (Restaurar)', N'RestaurarObra', 507, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (151, N'Corporativo', N'Corporativo', N'Costos x ciudad (lectura)', N'btnCostoXCiudad', 507, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (152, N'Corporativo', N'Corporativo', N'Costos x ciudad (Escritura)', N'ModificarCostosXciudad', 507, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (153, N'Corporativo', N'Corporativo', N'Consulta costos x Ciudad (lectura)', N'btnxConsultaCostos', 507, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (154, N'Corporativo', N'Corporativo', N'Consulta costos x Ciudad (pegado)', N'CostosXCiudadPegado', 507, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (155, N'Reportes', N'Reportes', N'Impresión', N'btnxImprimir', 508, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (156, N'Herramientas', N'Opciones', N'Copiar', N'CopiarClipboard', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (157, N'Reportes', N'Reportes', N'Enviar reporte a excel', N'ImprimirExcel', 508, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (158, N'Reportes', N'Reportes', N'Generar vista previa reporte', N'VistaPrevia', 508, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (159, N'Herramientas', N'Importaciones', N'Exportación a Pu2009', N'btnExportar2009', 501, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (160, N'Control de Obra', N'Estimaciones', N'Exportar todos los conceptos a sap', N'btnExportacionSAPTodos', 503, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (161, N'Presupuesto', N'Presupuesto', N'Exportar ArchiCad', N'btnxExportarArchiCad', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (162, N'Catálogos', N'Ajuste de costos', N'Indices', N'btnReferenciaIndices', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (163, N'Catálogos', N'Ajuste de costos', N'Indices (Escritura)', N'ModificarIndicesReferencia', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (164, N'Catálogos', N'Ajuste de costos', N'Familias de indices', N'btnFamiliaIndices', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (165, N'Catálogos', N'Ajuste de costos', N'Familias de indices(Escritura)', N'ModificarFamiliaIndices', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (166, N'Catálogos', N'Ajuste de costos', N'Ajuste de costos', N'btnAjusteCostos', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (167, N'Catálogos', N'Ajuste de costos', N'Asignar índices a insumos', N'AsignarIndicesInsumo', 502, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (168, N'Presupuesto', N'Presupuesto', N'Ajustar presupuesto', N'btnxAjustarPresupuesto', 505, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (169, N'Reportes', N'Reportes', N'Imprimir desde el grid', N'ImprimirGrid', 508, 5, 0)
INSERT [dbo].[SegPermisos] ([Permiso], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [IdSistema], [PermisoDinamico]) VALUES (170, N'Herramientas', N'Opciones', N'Crear obras', N'CrearPresupuestos', 501, 5, 0)
INSERT [dbo].[SegSistemas] ([IdSistema], [Nombre], [Texto]) VALUES (1, N'Administración Central', N'Administración Central')
INSERT [dbo].[SegSistemas] ([IdSistema], [Nombre], [Texto]) VALUES (2, N'Administración de Obra', N'Administración de Obra')
INSERT [dbo].[SegSistemas] ([IdSistema], [Nombre], [Texto]) VALUES (3, N'Comercialización de viviendas', N'Comercialización de viviendas')
INSERT [dbo].[SegSistemas] ([IdSistema], [Nombre], [Texto]) VALUES (4, N'Neodata CRM', N'Neodata CRM')
INSERT [dbo].[SegSistemas] ([IdSistema], [Nombre], [Texto]) VALUES (5, N'Precios Unitarios 2010', N'Precios Unitarios 2010')
SET IDENTITY_INSERT [dbo].[SegUsuarios] ON 

INSERT [dbo].[SegUsuarios] ([IdUsuario], [Nombre], [Usuario], [Password], [FechaCambioPwd], [Caduca], [Intentos], [Bloqueado], [Email]) VALUES (1, N'neodata', N'neodata', N'', NULL, 0, 0, N'LPeSIX2ePbs=', NULL)
SET IDENTITY_INSERT [dbo].[SegUsuarios] OFF
INSERT [dbo].[SegUsuariosSistemas] ([IdSistema], [IdUsuario], [IdPerfil], [Masc_Permisos]) VALUES (5, 1, NULL, N'n10XjTy+Jjv4Axd3kg8K/Y1CvO9ySovoxr3xu5ST0C6F4kB14QEg0OLYpwlhCXpFvoPARX7CB6MjdLwiQtj9ciqM7wciudGEOG5TG2KOcQQ9+HxMM3DXJwWWXygiE1RFA4f2WuJfzjXQnurdql5M5btT9XpgQbOj7u/j0o7/My7l6EnhNwPOwSvdcWUNYVUvE2Njy44pMLB51kAbrGjVbHt3+6SQPxbaqB9mI1ozEDGgNClYOB/sRje/7XBcAhKIdKNl7jMEccCuXkX1o+pP2VtDkmZVWPaugqVuTNpBW5W19HvN7ZQEjA==')
SET IDENTITY_INSERT [dbo].[Version] ON 

INSERT [dbo].[Version] ([idVersion], [LlaveUnica], [Version], [Hora], [versionMayor], [AsignaDatosDefault], [EstructuraOK], [VersionNeodata], [NombreNeodata], [idSistema]) VALUES (1, 1, N'2011/09/27', N'1324', 0, 0, 1, 2011, N'Precios Unitarios 2011', 5)
SET IDENTITY_INSERT [dbo].[Version] OFF
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_BiCatProcesos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_BiCatProcesos] ON [dbo].[BiCatProcesos]
(
	[Proceso] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_BiCatSistemas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_BiCatSistemas] ON [dbo].[BiCatSistemas]
(
	[Sistema] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_LicContratantes]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicContratantes] ON [dbo].[LicContratantes]
(
	[Contratante] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_LicLicitaciones]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicLicitaciones] ON [dbo].[LicLicitaciones]
(
	[Licitacion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_LicLicitacionesContratistas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicLicitacionesContratistas] ON [dbo].[LicLicitacionesContratistas]
(
	[IdLicitacion] ASC,
	[IdContratista] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_LicLicitacionesContratistasCuadro]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicLicitacionesContratistasCuadro] ON [dbo].[LicLicitacionesContratistasCuadro]
(
	[IdLicitacionContratista] ASC,
	[IdLicitacionPresupuesto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_LicLicitacionesContratistasDocumentos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicLicitacionesContratistasDocumentos] ON [dbo].[LicLicitacionesContratistasDocumentos]
(
	[IdLicitacionContratista] ASC,
	[NombreDocumento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_LicLicitacionesContratistasInsumos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_LicLicitacionesContratistasInsumos] ON [dbo].[LicLicitacionesContratistasInsumos]
(
	[IdLicitacionContratista] ASC,
	[IdLicitacionContratistaInsumo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_LicLicitacionesContratistasPeriodos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicLicitacionesContratistasPeriodos] ON [dbo].[LicLicitacionesContratistasPeriodos]
(
	[IdLicitacionContratista] ASC,
	[NoPeriodo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_LicLicitacionesContratistasPrograma]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicLicitacionesContratistasPrograma] ON [dbo].[LicLicitacionesContratistasPrograma]
(
	[IdLicitacionContratista] ASC,
	[IdLicitacionPresupuesto] ASC,
	[NoPeriodo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_LicLicitacionesDocumentos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicLicitacionesDocumentos] ON [dbo].[LicLicitacionesDocumentos]
(
	[IdLicitacion] ASC,
	[NombreDocumento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_LicLicitacionesFlujo]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicLicitacionesFlujo] ON [dbo].[LicLicitacionesFlujo]
(
	[IdLicitacion] ASC,
	[Flujo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_LicLicitacionesFlujoDet]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicLicitacionesFlujoDet] ON [dbo].[LicLicitacionesFlujoDet]
(
	[IdLicitacionFlujo] ASC,
	[Paso] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_LicLicitacionesInsumos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicLicitacionesInsumos] ON [dbo].[LicLicitacionesInsumos]
(
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_LicLicitacionesPartidas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicLicitacionesPartidas] ON [dbo].[LicLicitacionesPartidas]
(
	[IdLicitacion] ASC,
	[IdPartidaPadre] ASC,
	[Partida] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_LicLicitacionesPresupuesto]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicLicitacionesPresupuesto] ON [dbo].[LicLicitacionesPresupuesto]
(
	[IdLicitacion] ASC,
	[IdLicitacionPartida] ASC,
	[Renglon] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_LicLicitacionesPresupuesto_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicLicitacionesPresupuesto_1] ON [dbo].[LicLicitacionesPresupuesto]
(
	[IdLicitacion] ASC,
	[Control] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_LicTiposLicitacion]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicTiposLicitacion] ON [dbo].[LicTiposLicitacion]
(
	[TipoLicitacion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_LicTiposLicitacionDocumentos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicTiposLicitacionDocumentos] ON [dbo].[LicTiposLicitacionDocumentos]
(
	[IdTipoLicitacion] ASC,
	[NombreDocumento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_LicTiposLicitacionFlujo]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_LicTiposLicitacionFlujo] ON [dbo].[LicTiposLicitacionFlujo]
(
	[IdTipoLicitacion] ASC,
	[OrdenFlujo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_LicTiposLicitacionPasos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_LicTiposLicitacionPasos] ON [dbo].[LicTiposLicitacionFlujo]
(
	[IdTipoLicitacion] ASC,
	[Flujo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_LicTiposLicitacionFlujoDet]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_LicTiposLicitacionFlujoDet] ON [dbo].[LicTiposLicitacionFlujoDet]
(
	[IdTipoLicitacionFlujo] ASC,
	[Paso] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_LicTiposLicitacionFlujoDet_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_LicTiposLicitacionFlujoDet_1] ON [dbo].[LicTiposLicitacionFlujoDet]
(
	[IdTipoLicitacionFlujo] ASC,
	[OrdenPaso] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [In_CvCalendariosCalendario]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [In_CvCalendariosCalendario] ON [dbo].[PuCalendarios]
(
	[Calendario] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuCalendariosDet]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCalendariosDet] ON [dbo].[PuCalendariosDet]
(
	[IdCalendario] ASC,
	[FechaNoLaborable] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuCamara]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCamara] ON [dbo].[PuCamara]
(
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuCatalogo]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCatalogo] ON [dbo].[PuCatalogo]
(
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuCatalogoIndices]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCatalogoIndices] ON [dbo].[PuCatalogoIndices]
(
	[IdCodigo] ASC,
	[IdFamiliaIndice] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuCatalogoIndices_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuCatalogoIndices_1] ON [dbo].[PuCatalogoIndices]
(
	[IdCodigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuCatalogoIndices_2]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuCatalogoIndices_2] ON [dbo].[PuCatalogoIndices]
(
	[IdFamiliaIndice] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuCatDocumentosContratista]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCatDocumentosContratista] ON [dbo].[PuCatDocumentosContratista]
(
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuCatDocumentosContratos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCatDocumentosContratos] ON [dbo].[PuCatDocumentosContratos]
(
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuEspecialidadesContratista]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuEspecialidadesContratista] ON [dbo].[PuCatEspecialidadesContratista]
(
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuCatMaquinariaContratista]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCatMaquinariaContratista] ON [dbo].[PuCatMaquinariaContratista]
(
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuCentros]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCentros] ON [dbo].[PuCentros]
(
	[IdPresupuesto] ASC,
	[Centro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuCiudades]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCiudades] ON [dbo].[PuCiudades]
(
	[Ciudad] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuClientes]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuClientes] ON [dbo].[PuClientes]
(
	[Cliente] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuClientesContactos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuClientesContactos] ON [dbo].[PuClientesContactos]
(
	[IdCliente] ASC,
	[Nombre] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuContratantesConsecutivos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuContratantesConsecutivos] ON [dbo].[PuContratantesConsecutivos]
(
	[IdPresupuesto] ASC,
	[IdContratista] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuContratistaMaquinaria]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuContratistaMaquinaria] ON [dbo].[PuContratistaMaquinaria]
(
	[IdContratista] ASC,
	[IdCatMaquinariaContratista] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuContratistasActividades]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuContratistasActividades] ON [dbo].[PuContratistasActividades]
(
	[IdContratista] ASC,
	[IdCodigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuContratistasEspecialidades]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuContratistasEspecialidades] ON [dbo].[PuContratistasEspecialidades]
(
	[IdCatEspecialidadContratista] ASC,
	[IdContratista] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuContratistasRefrendos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuContratistasRefrendos] ON [dbo].[PuContratistasRefrendos]
(
	[IdContratista] ASC,
	[FechaRefrendo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuContratos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuContratos] ON [dbo].[PuContratos]
(
	[IdPresupuesto] ASC,
	[FolioContrato] ASC,
	[IdContratante] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuContratosConsecutivos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuContratosConsecutivos] ON [dbo].[PuContratosConsecutivos]
(
	[IdContrato] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuContratosDeducciones]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuContratosDeducciones] ON [dbo].[PuContratosDeducciones]
(
	[IdContrato] ASC,
	[IdDeduccion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuContratosDet]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuContratosDet] ON [dbo].[PuContratosDet]
(
	[IdContrato] ASC,
	[IdPresupuestoConcepto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuContratosDocumentos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuContratosDocumentos] ON [dbo].[PuContratosDocumentos]
(
	[IdContrato] ASC,
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuContratosFacturas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuContratosFacturas] ON [dbo].[PuContratosFacturas]
(
	[IdContrato] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuContratosMonedas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuContratosMonedas] ON [dbo].[PuContratosMonedas]
(
	[IdContrato] ASC,
	[IdMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuContratosPlantillas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuContratosPlantillas] ON [dbo].[PuContratosPlantillas]
(
	[IdContrato] ASC,
	[IdDocumento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuContribuyente]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuContribuyente] ON [dbo].[PuContribuyente]
(
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuConversionesAcad]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuConversionesAcad] ON [dbo].[PuConversionesAcad]
(
	[IdUnidad] ASC,
	[IdUnidadAcad] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuCostosHorarios]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCostosHorarios] ON [dbo].[PuCostosHorarios]
(
	[IdExpIns] ASC,
	[IdExpInsCF] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuCostosHorariosMO]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCostosHorariosMO] ON [dbo].[PuCostosHorariosMO]
(
	[IdCostoHorario] ASC,
	[IdExpins] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuCostosHorariosOC]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCostosHorariosOC] ON [dbo].[PuCostosHorariosOC]
(
	[IdCostoHorario] ASC,
	[IdExpins] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuCostosHorariosTI]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCostosHorariosTI] ON [dbo].[PuCostosHorariosTI]
(
	[IdCostoHorario] ASC,
	[IdMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuCostoXCiudad]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCostoXCiudad] ON [dbo].[PuCostosXCiudad]
(
	[IdCiudad] ASC,
	[IdCodigo] ASC,
	[IdProveedor] ASC,
	[IdMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuCuotasVigentesImss]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCuotasVigentesImss] ON [dbo].[PuCuotasVigentesImss]
(
	[Clave] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuDeducciones]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuDeducciones] ON [dbo].[PuDeducciones]
(
	[Deduccion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuDocumentos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuDocumentos] ON [dbo].[PuDocumentos]
(
	[Documento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuEmpresaAfianzadora]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuEmpresaAfianzadora] ON [dbo].[PuEmpresaAfianzadora]
(
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuEmpresas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuEmpresas] ON [dbo].[PuEmpresas]
(
	[Empresa] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuEmpresas_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuEmpresas_1] ON [dbo].[PuEmpresas]
(
	[RazonSocial] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [EstadoCodigo]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [EstadoCodigo] ON [dbo].[PuEstados]
(
	[Estado] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuEstimaciones]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuEstimaciones] ON [dbo].[PuEstimaciones]
(
	[IdContrato] ASC,
	[IdEstimacionTipo] ASC,
	[FolioEstimacion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuEstimaciones_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuEstimaciones_1] ON [dbo].[PuEstimaciones]
(
	[IdContrato] ASC,
	[ConsecutivoEstimacion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuEstimacionesDeducciones]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuEstimacionesDeducciones] ON [dbo].[PuEstimacionesDeducciones]
(
	[IdEstimacion] ASC,
	[IdDeduccion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuEstimacionesDet]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuEstimacionesDet] ON [dbo].[PuEstimacionesDet]
(
	[IdEstimacion] ASC,
	[IdContratoDet] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuEstimacionesEstatusHistorico]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuEstimacionesEstatusHistorico] ON [dbo].[PuEstimacionesEstatusHistorico]
(
	[idEstimacion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuEstimacionesEstatusHistorico_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuEstimacionesEstatusHistorico_1] ON [dbo].[PuEstimacionesEstatusHistorico]
(
	[idUsuario] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuTiposConceptos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuTiposConceptos] ON [dbo].[PuEstimacionesTipos]
(
	[IdEstimacionTipo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuTiposConceptos_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuTiposConceptos_1] ON [dbo].[PuEstimacionesTipos]
(
	[EstimacionTipo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuCostos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCostos] ON [dbo].[PuExpIns]
(
	[IdPresupuesto] ASC,
	[IdCodigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuCostos_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuCostos_1] ON [dbo].[PuExpIns]
(
	[IdCodigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuExpIns]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuExpIns] ON [dbo].[PuExpIns]
(
	[IdPresupuesto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuExpIns_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuExpIns_1] ON [dbo].[PuExpIns]
(
	[IdIntelimat] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuExpInsCostos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuExpInsCostos] ON [dbo].[PuExpInsCostos]
(
	[IdExpIns] ASC,
	[IdMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuExpinsCostosEQ]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuExpinsCostosEQ] ON [dbo].[PuExpinsCostosEQ]
(
	[IdExpInsCosto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuExpInsCostosOP]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuExpInsCostosOP] ON [dbo].[PuExpInsCostosOP]
(
	[IdExpInsCosto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuExpInsDestajos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuExpInsDestajos] ON [dbo].[PuExpInsDestajos]
(
	[IdExpIns] ASC,
	[IdMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuImatUDet]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuImatUDet] ON [dbo].[PuExpInsIntelimat]
(
	[IdExpIns] ASC,
	[Parametro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuCostosMO]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCostosMO] ON [dbo].[PuExpInsMO]
(
	[IdExpInsCosto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuExpinsPar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuExpinsPar] ON [dbo].[PuExpinsPar]
(
	[IdPresupuestoPartida] ASC,
	[IdExpIns] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuExpinsXconcepto]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuExpinsXconcepto] ON [dbo].[PuExpinsXconcepto]
(
	[IdCodigoMatriz] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuExpinsXconcepto_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuExpinsXconcepto_1] ON [dbo].[PuExpinsXconcepto]
(
	[IdCodigoInsumo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuExpinsXconcepto_2]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuExpinsXconcepto_2] ON [dbo].[PuExpinsXconcepto]
(
	[IdCodigoMatriz] ASC,
	[IdCodigoInsumo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuFamilias]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuFamilias] ON [dbo].[PuFamilias]
(
	[Familia] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuFamiliasIndices]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuFamiliasIndices] ON [dbo].[PuFamiliasIndices]
(
	[IdIndice] ASC,
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuFichasTecnicas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuFichasTecnicas] ON [dbo].[PuFichasTecnicas]
(
	[FichaTecnica] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuGeneradores]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuGeneradores] ON [dbo].[PuGeneradores]
(
	[IdContrato] ASC,
	[FolioGenerador] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuGeneradoresDet]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuGeneradoresDet] ON [dbo].[PuGeneradoresDet]
(
	[IdGenerador] ASC,
	[IdContratoDet] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuGeneradoresDocumentos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuGeneradoresDocumentos] ON [dbo].[PuGeneradoresDocumentos]
(
	[IdGenerador] ASC,
	[Documento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuImagenes]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuImagenes] ON [dbo].[PuImagenes]
(
	[IdFamilia] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuImagenes_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuImagenes_1] ON [dbo].[PuImagenes]
(
	[Partida] ASC,
	[Descripcion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuImagenes_2]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuImagenes_2] ON [dbo].[PuImagenes]
(
	[CheckSum] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuIndices]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuIndices] ON [dbo].[PuIndices]
(
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuIndicesDet]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuIndicesDet] ON [dbo].[PuIndicesDet]
(
	[IdFamiliaIndice] ASC,
	[Año] ASC,
	[Mes] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuIntelimat]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuIntelimat] ON [dbo].[PuIntelimat]
(
	[Partida] ASC,
	[InteliMat] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuInteliPres]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuInteliPres] ON [dbo].[PuInteliPres]
(
	[IdPresupuesto] ASC,
	[Renglon] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuLigasRuta]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuLigasRuta] ON [dbo].[PuLigasRuta]
(
	[IdConceptoOrigen] ASC,
	[IdConceptoDestino] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuLigasRuta_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuLigasRuta_1] ON [dbo].[PuLigasRuta]
(
	[IdConceptoDestino] ASC,
	[IdConceptoOrigen] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuMatrices]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuMatrices] ON [dbo].[PuMatrices]
(
	[IdCodigoMatriz] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuMatrices_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuMatrices_1] ON [dbo].[PuMatrices]
(
	[IdCodigoInsumo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuMonedas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuMonedas] ON [dbo].[PuMonedas]
(
	[Moneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuMonedasCalculadas_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuMonedasCalculadas_1] ON [dbo].[PuMonedasCalculadas]
(
	[IdMoneda] ASC,
	[IdMonedaIntegrante] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuMovimientos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuMovimientos] ON [dbo].[PuMovimientos]
(
	[Descripcion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuOficiosParametros]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuOficiosParametros] ON [dbo].[PuOficiosParametros]
(
	[Parametro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuOrdenesCambio]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuOrdenesCambio] ON [dbo].[PuOrdenesCambio]
(
	[IdContrato] ASC,
	[IdOrdenCambio] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuOrdenesCambioDet]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuOrdenesCambioDet] ON [dbo].[PuOrdenesCambioDet]
(
	[IdOrdenCambio] ASC,
	[IdContratoDet] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuOrdenesCambioTipo]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuOrdenesCambioTipo] ON [dbo].[PuOrdenesCambioTipo]
(
	[OrdenCambio] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuParametros]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuParametros] ON [dbo].[PuParametros]
(
	[Parametro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuPorcentajesFinanciamiento]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPorcentajesFinanciamiento] ON [dbo].[PuPorcentajesFinanciamiento]
(
	[IdPrograma] ASC,
	[NoPeriodo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuPorcentajesFM]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPorcentajesFM] ON [dbo].[PuPorcentajesFM]
(
	[IdPorcentajeFinanciamiento] ASC,
	[IdMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_Proyectos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_Proyectos] ON [dbo].[PuPresupuestos]
(
	[Presupuesto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuAdjuntosPresupuesto]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuAdjuntosPresupuesto] ON [dbo].[PuPresupuestosAdjuntosMonedas]
(
	[IdPresupuesto] ASC,
	[IdMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuPresupuestosConceptos_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPresupuestosConceptos_1] ON [dbo].[PuPresupuestosConceptos]
(
	[IdPresupuesto] ASC,
	[Control] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuPresupuestosConceptosPrecios]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPresupuestosConceptosPrecios] ON [dbo].[PuPresupuestosConceptosPrecios]
(
	[IdPresupuestoConcepto] ASC,
	[IdMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuPresupuestosConsecutivos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPresupuestosConsecutivos] ON [dbo].[PuPresupuestosConsecutivos]
(
	[idPresupuesto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuPresupuestosMonedas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPresupuestosMonedas] ON [dbo].[PuPresupuestosMonedas]
(
	[IdPresupuesto] ASC,
	[IdMonedaCalculada] ASC,
	[IdMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuPresupuestosOficios]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPresupuestosOficios] ON [dbo].[PuPresupuestosOficios]
(
	[IdPresupuesto] ASC,
	[IdOficioParametro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuPresupuestosParametros]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPresupuestosParametros] ON [dbo].[PuPresupuestosParametros]
(
	[IdPresupuesto] ASC,
	[Parametro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuPartidas_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE NONCLUSTERED INDEX [IX_PuPartidas_1] ON [dbo].[PuPresupuestosPartidas]
(
	[IdPartidaPadre] ASC,
	[Renglon] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuPresupuestosPartidas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPresupuestosPartidas] ON [dbo].[PuPresupuestosPartidas]
(
	[IdPresupuesto] ASC,
	[IdPartidaPadre] ASC,
	[Partida] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuPresupuestosPartidasCostos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPresupuestosPartidasCostos] ON [dbo].[PuPresupuestosPartidasCostos]
(
	[IdPresupuestoPartida] ASC,
	[IdMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuPresupuestosPrecios]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPresupuestosPrecios] ON [dbo].[PuPresupuestosPrecios]
(
	[IdPresupuesto] ASC,
	[IdMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuPresupuestosPrestamosDet]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPresupuestosPrestamosDet] ON [dbo].[PuPresupuestosPrestamosDet]
(
	[Fecha] ASC,
	[IdPresupuestoPrestamo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuPresupuestosVersion]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPresupuestosVersion] ON [dbo].[PuPresupuestosVersion]
(
	[Presupuesto] ASC,
	[Consecutivo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuPresupuestosVersionCostos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPresupuestosVersionCostos] ON [dbo].[PuPresupuestosVersionCostos]
(
	[IdPresupuestoVersion] ASC,
	[IdMoneda] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuProcedimientos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuProcedimientos] ON [dbo].[PuProcedimientos]
(
	[Procedimiento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuProgramaConceptos_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuProgramaConceptos_1] ON [dbo].[PuProgramaConceptos]
(
	[IdPrograma] ASC,
	[IdPresupuestoConcepto] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuProgramaConceptosPeriodos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuProgramaConceptosPeriodos] ON [dbo].[PuProgramaConceptosPeriodos]
(
	[IdProgramaConcepto] ASC,
	[NoPeriodo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuProgramaPartidas_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuProgramaPartidas_1] ON [dbo].[PuProgramaPartidas]
(
	[IdPrograma] ASC,
	[IdPresupuestoPartida] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuProgramas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuProgramas] ON [dbo].[PuProgramas]
(
	[IdPresupuesto] ASC,
	[NoPrograma] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuProgramasTipos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuProgramasTipos] ON [dbo].[PuProgramasTipos]
(
	[IdPrograma] ASC,
	[IdTipo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuProgramaSumXCon_1]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuProgramaSumXCon_1] ON [dbo].[PuProgramaSum]
(
	[IdPrograma] ASC,
	[IdExpIns] ASC,
	[NoPeriodo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuProgramaSumXPar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuProgramaSumXPar] ON [dbo].[PuProgramaSumXPar]
(
	[IdProgramaPartida] ASC,
	[IdExpIns] ASC,
	[NoPeriodo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuProveedores]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuProveedores] ON [dbo].[PuProveedores]
(
	[Proveedor] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuReferenciaAcad]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuReferenciaAcad] ON [dbo].[PuReferenciaAcad]
(
	[Referencia] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuRepCarpetas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuRepCarpetas] ON [dbo].[PuRepCarpetas]
(
	[Carpeta] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuReportesHojasXls]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuReportesHojasXls] ON [dbo].[PuRepHojas]
(
	[IdRepLibro] ASC,
	[NombreHoja] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_PuRepOpciones]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuRepOpciones] ON [dbo].[PuRepOpciones]
(
	[IdRepHoja] ASC,
	[IdUsuario] ASC,
	[IdParametro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuRepParametros]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuRepParametros] ON [dbo].[PuRepParametros]
(
	[Parametro] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuResponsables]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuResponsables] ON [dbo].[PuResponsables]
(
	[Responsable] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuSesionCAOP]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuSesionCAOP] ON [dbo].[PuSesionCAOP]
(
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuStatusControlPadron]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuStatusControlPadron] ON [dbo].[PuStatusControlPadron]
(
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [aaaaaTipoInsumos_PK]    Script Date: 09/10/2018 11:01:04 a. m. ******/
ALTER TABLE [dbo].[PuTipoInsumos] ADD  CONSTRAINT [aaaaaTipoInsumos_PK] PRIMARY KEY NONCLUSTERED 
(
	[IdTipo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuTipoProveedor]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuTipoProveedor] ON [dbo].[PuTipoProveedor]
(
	[Codigo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuTiposDocumentos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuTiposDocumentos] ON [dbo].[PuTiposDocumentos]
(
	[TipoDocumento] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuTiposLicitacion]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuTiposLicitacion] ON [dbo].[PuTiposLicitacion]
(
	[Tipo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuUnidades]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuUnidades] ON [dbo].[PuUnidades]
(
	[Unidad] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuUnidadesAcad]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuUnidadesAcad] ON [dbo].[PuUnidadesAcad]
(
	[Unidad] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_PuVendedores]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuVendedores] ON [dbo].[PuVendedores]
(
	[Vendedor] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_SegGrupoPermisos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_SegGrupoPermisos] ON [dbo].[SegGrupoPermisos]
(
	[GrupoPermiso] ASC,
	[IdSistema] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_SegPerfil]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_SegPerfil] ON [dbo].[SegPerfil]
(
	[IdSistema] ASC,
	[Descripcion] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_SegPermisos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_SegPermisos] ON [dbo].[SegPermisos]
(
	[IdSistema] ASC,
	[Nombre_Permiso] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_SegSistemas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_SegSistemas] ON [dbo].[SegSistemas]
(
	[Nombre] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_SegUsuarios]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_SegUsuarios] ON [dbo].[SegUsuarios]
(
	[Usuario] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_Version_Unico]    Script Date: 09/10/2018 11:01:04 a. m. ******/
CREATE UNIQUE NONCLUSTERED INDEX [IX_Version_Unico] ON [dbo].[Version]
(
	[LlaveUnica] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
ALTER TABLE [dbo].[BiCatProcesos] ADD  CONSTRAINT [DF_BiCatProcesos_Grabar]  DEFAULT ((1)) FOR [Grabar]
GO
ALTER TABLE [dbo].[LicLicitaciones] ADD  CONSTRAINT [DF_LicLicitaciones_PorcentajeIVA1]  DEFAULT ((0)) FOR [PorcentajeIVA]
GO
ALTER TABLE [dbo].[LicLicitaciones] ADD  CONSTRAINT [DF_LicLicitaciones_DecimalesRedondeo]  DEFAULT ((2)) FOR [DecimalesRedondeo]
GO
ALTER TABLE [dbo].[LicLicitaciones] ADD  CONSTRAINT [DF_LicLicitaciones_CapturarPorcentaje]  DEFAULT ((1)) FOR [CapturarPorcentaje]
GO
ALTER TABLE [dbo].[LicLicitaciones] ADD  CONSTRAINT [DF_LicLicitaciones_NoPeriodos]  DEFAULT ((1)) FOR [NoPeriodos]
GO
ALTER TABLE [dbo].[LicLicitaciones] ADD  CONSTRAINT [DF_LicLicitaciones_Periodicidad]  DEFAULT ((0)) FOR [Periodicidad]
GO
ALTER TABLE [dbo].[LicLicitaciones] ADD  CONSTRAINT [DF_LicLicitaciones_PermitirCantidadCero]  DEFAULT ((0)) FOR [PermitirCantidadCero]
GO
ALTER TABLE [dbo].[LicLicitaciones] ADD  CONSTRAINT [DF_LicLicitaciones_EstatusLicitacion]  DEFAULT ((1)) FOR [EstatusLicitacion]
GO
ALTER TABLE [dbo].[LicLicitaciones] ADD  CONSTRAINT [DF_LicLicitaciones_Version]  DEFAULT ((0)) FOR [Version]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas] ADD  CONSTRAINT [DF_LicLicitacionesContratistas_Base_1]  DEFAULT ((0)) FOR [Base]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas] ADD  CONSTRAINT [DF_LicLicitacionesContratistas_PorcenIndirCampo]  DEFAULT ((0)) FOR [IndirectosCampo]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas] ADD  CONSTRAINT [DF_LicLicitacionesContratistas_SCIndirectoOficina]  DEFAULT ((0)) FOR [IndirectoOficina]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas] ADD  CONSTRAINT [DF_LicLicitacionesContratistas_SCFinanciamiento]  DEFAULT ((0)) FOR [Financiamiento]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas] ADD  CONSTRAINT [DF_LicLicitacionesContratistas_SCUtilidad]  DEFAULT ((0)) FOR [Utilidad]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas] ADD  CONSTRAINT [DF_LicLicitacionesContratistas_SCCargosAdicionales]  DEFAULT ((0)) FOR [CargosAdicionales]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas] ADD  CONSTRAINT [DF_LicLicitacionesContratistas_MontoCosto]  DEFAULT ((0)) FOR [MontoCosto]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas] ADD  CONSTRAINT [DF_LicLicitacionesContratistas_MontoPrecio]  DEFAULT ((0)) FOR [MontoPrecio]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas] ADD  CONSTRAINT [DF_LicLicitacionesContratistas_Lugar]  DEFAULT ((0)) FOR [Lugar]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas] ADD  CONSTRAINT [DF_LicLicitacionesContratistas_Ganador]  DEFAULT ((0)) FOR [Ganador]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas] ADD  CONSTRAINT [DF_LicLicitacionesContratistas_NumeroContratista]  DEFAULT ((0)) FOR [NumeroContratista]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasCuadro] ADD  CONSTRAINT [DF_LicLicitacionesContratistasCuadro_Costo]  DEFAULT ((0)) FOR [Costo]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasCuadro] ADD  CONSTRAINT [DF_LicLicitacionesContratistasCuadro_Precio]  DEFAULT ((0)) FOR [Precio]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasDocumentos] ADD  CONSTRAINT [DF_LicLicitacionesContratistasDocumentos_Extension]  DEFAULT ('.xlsx') FOR [Extension]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasDocumentos] ADD  CONSTRAINT [DF_LicLicitacionesContratistasDocumentos_SustituyeVariables]  DEFAULT ((0)) FOR [SustituyeVariables]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasDocumentos] ADD  CONSTRAINT [DF_LicLicitacionesContratistasDocumentos_EntregaContratista]  DEFAULT ((0)) FOR [EntregaContratista]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasInsumos] ADD  CONSTRAINT [DF_LicLicitacionesContratistasInsumos_Costo]  DEFAULT ((0)) FOR [Costo]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasPeriodos] ADD  CONSTRAINT [DF_LicLicitacionesContratistasPeriodos_NoPeriodo]  DEFAULT ((1)) FOR [NoPeriodo]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasPeriodos] ADD  CONSTRAINT [DF_LicLicitacionesContratistasPeriodos_Costo]  DEFAULT ((0)) FOR [Costo]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasPeriodos] ADD  CONSTRAINT [DF_LicLicitacionesContratistasPeriodos_Precio]  DEFAULT ((0)) FOR [Precio]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasPrograma] ADD  CONSTRAINT [DF_LicLicitacionesContratistasPrograma_NoPeriodo]  DEFAULT ((1)) FOR [NoPeriodo]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasPrograma] ADD  CONSTRAINT [DF_LicLicitacionesContratistasPrograma_Porcentaje]  DEFAULT ((0)) FOR [Porcentaje]
GO
ALTER TABLE [dbo].[LicLicitacionesDocumentos] ADD  CONSTRAINT [DF_LicLicitacionesDocumentos_Extension]  DEFAULT ('.xlsx') FOR [Extension]
GO
ALTER TABLE [dbo].[LicLicitacionesDocumentos] ADD  CONSTRAINT [DF_LicLicitacionesDocumentos_SustituyeVariables]  DEFAULT ((0)) FOR [SustituyeVariables]
GO
ALTER TABLE [dbo].[LicLicitacionesDocumentos] ADD  CONSTRAINT [DF_LicLicitacionesDocumentos_EntregaContratista]  DEFAULT ((0)) FOR [EntregaContratista]
GO
ALTER TABLE [dbo].[LicLicitacionesFlujo] ADD  CONSTRAINT [DF_LicLicitacionesFlujo_Orden]  DEFAULT ((0)) FOR [OrdenFlujo]
GO
ALTER TABLE [dbo].[LicLicitacionesFlujoDet] ADD  CONSTRAINT [DF_LicLicitacionesFlujoDet_Orden]  DEFAULT ((0)) FOR [OrdenPaso]
GO
ALTER TABLE [dbo].[LicLicitacionesInsumos] ADD  CONSTRAINT [DF_LicLicitacionesInsumos_Tipo]  DEFAULT ((1)) FOR [Tipo]
GO
ALTER TABLE [dbo].[LicLicitacionesPartidas] ADD  CONSTRAINT [DF_LicLicitacionesPartidas_Renglon]  DEFAULT ((1)) FOR [Renglon]
GO
ALTER TABLE [dbo].[LicLicitacionesPresupuesto] ADD  CONSTRAINT [DF_LicLicitacionesPresupuesto_Renglon]  DEFAULT ((10)) FOR [Renglon]
GO
ALTER TABLE [dbo].[LicLicitacionesPresupuesto] ADD  CONSTRAINT [DF_LicLicitacionesPresupuesto_CantidadTotal]  DEFAULT ((0)) FOR [CantidadTotal]
GO
ALTER TABLE [dbo].[LicTiposLicitacionDocumentos] ADD  CONSTRAINT [DF_LicTiposLicitacionDocumentos_Extension]  DEFAULT ('.xlsx') FOR [Extension]
GO
ALTER TABLE [dbo].[LicTiposLicitacionDocumentos] ADD  CONSTRAINT [DF_LicTiposLicitacionDocumentos_SustituyeDatos]  DEFAULT ((0)) FOR [SustituyeVariables]
GO
ALTER TABLE [dbo].[LicTiposLicitacionDocumentos] ADD  CONSTRAINT [DF_LicTiposLicitacionDocumentos_LLenadoPorContratista]  DEFAULT ((0)) FOR [EntregaContratista]
GO
ALTER TABLE [dbo].[LicTiposLicitacionFlujo] ADD  CONSTRAINT [DF_LicTiposLicitacionFlujo_Orden]  DEFAULT ((0)) FOR [OrdenFlujo]
GO
ALTER TABLE [dbo].[LicTiposLicitacionFlujoDet] ADD  CONSTRAINT [DF_LicTiposLicitacionFlujoDet_Orden]  DEFAULT ((0)) FOR [OrdenPaso]
GO
ALTER TABLE [dbo].[PuCalendarios] ADD  CONSTRAINT [DF_CvCalendarios_Texto]  DEFAULT (N'CALENDARIO') FOR [Descripcion]
GO
ALTER TABLE [dbo].[PuCalendarios] ADD  CONSTRAINT [DF_PuCalendarios_Lunes]  DEFAULT ((1)) FOR [Lunes]
GO
ALTER TABLE [dbo].[PuCalendarios] ADD  CONSTRAINT [DF_PuCalendarios_Martes]  DEFAULT ((1)) FOR [Martes]
GO
ALTER TABLE [dbo].[PuCalendarios] ADD  CONSTRAINT [DF_PuCalendarios_Miercoles]  DEFAULT ((1)) FOR [Miercoles]
GO
ALTER TABLE [dbo].[PuCalendarios] ADD  CONSTRAINT [DF_PuCalendarios_Jueves]  DEFAULT ((1)) FOR [Jueves]
GO
ALTER TABLE [dbo].[PuCalendarios] ADD  CONSTRAINT [DF_PuCalendarios_Viernes]  DEFAULT ((1)) FOR [Viernes]
GO
ALTER TABLE [dbo].[PuCalendarios] ADD  CONSTRAINT [DF_PuCalendarios_Sabado]  DEFAULT ((1)) FOR [Sabado]
GO
ALTER TABLE [dbo].[PuCalendarios] ADD  CONSTRAINT [DF_PuCalendarios_Domingo]  DEFAULT ((0)) FOR [Domingo]
GO
ALTER TABLE [dbo].[PuCalendarios] ADD  CONSTRAINT [DF_PuCalendarios_Predeterminado]  DEFAULT ((0)) FOR [Predeterminado]
GO
ALTER TABLE [dbo].[PuCatalogo] ADD  CONSTRAINT [DF_PuCatalogo_EsPorcentaje]  DEFAULT ((0)) FOR [EsPorcentaje]
GO
ALTER TABLE [dbo].[PuCatalogo] ADD  CONSTRAINT [DF_PuCatalogo_PorcentajeDefault]  DEFAULT ((0)) FOR [VolumenDefault]
GO
ALTER TABLE [dbo].[PuCatalogo] ADD  CONSTRAINT [DF_PuCatalogo_EsAgrupador]  DEFAULT ((0)) FOR [EsAgrupador]
GO
ALTER TABLE [dbo].[PuCatalogo] ADD  CONSTRAINT [DF_PuCatalogo_FondoGarantia]  DEFAULT ((0)) FOR [PorcentajeFondoGarantia]
GO
ALTER TABLE [dbo].[PuCatDocumentosContratista] ADD  CONSTRAINT [DF_PuCatDocumentosContratista_Inscripcion]  DEFAULT ((0)) FOR [Inscripcion]
GO
ALTER TABLE [dbo].[PuCatDocumentosContratista] ADD  CONSTRAINT [DF_PuCatDocumentosContratista_Refrendo]  DEFAULT ((0)) FOR [Refrendo]
GO
ALTER TABLE [dbo].[PuCentros] ADD  CONSTRAINT [DF_PuCentros_Acepta_Mov]  DEFAULT ((0)) FOR [Acepta_Mov]
GO
ALTER TABLE [dbo].[PuCentros] ADD  CONSTRAINT [DF_PuCentros_Cerrado]  DEFAULT ((0)) FOR [Cerrado]
GO
ALTER TABLE [dbo].[PuCentros] ADD  CONSTRAINT [DF_PuCentros_CambioProyecto]  DEFAULT ((0)) FOR [CambioProyecto]
GO
ALTER TABLE [dbo].[PuCentros] ADD  CONSTRAINT [DF_PuCentros_Terminada]  DEFAULT ((0)) FOR [Terminada]
GO
ALTER TABLE [dbo].[PuCentros] ADD  CONSTRAINT [DF_PuCentros_Bloquedo]  DEFAULT ((0)) FOR [Bloqueado]
GO
ALTER TABLE [dbo].[PuContratantesConsecutivos] ADD  CONSTRAINT [DF_PuContratantesConsecutivos_FolioContrato]  DEFAULT ((0)) FOR [FolioContrato]
GO
ALTER TABLE [dbo].[PuContratistaMaquinaria] ADD  CONSTRAINT [DF_PuContratistaMaquinaria_Cantidad]  DEFAULT ((0)) FOR [Cantidad]
GO
ALTER TABLE [dbo].[PuContratistas] ADD  CONSTRAINT [DF_PuContratistas_EsDestajista]  DEFAULT ((0)) FOR [EsDestajista]
GO
ALTER TABLE [dbo].[PuContratistas] ADD  CONSTRAINT [DF_PuContratistas_Emp_EsPersonaFisica]  DEFAULT ((0)) FOR [Emp_EsPersonaFisica]
GO
ALTER TABLE [dbo].[PuContratistasDocumentos] ADD  CONSTRAINT [DF_PuContratistasDocumentos_Entregado]  DEFAULT ((0)) FOR [Entregado]
GO
ALTER TABLE [dbo].[PuContratistasDocumentos] ADD  CONSTRAINT [DF_PuContratistasDocumentos_Inscripcion]  DEFAULT ((0)) FOR [Inscripcion]
GO
ALTER TABLE [dbo].[PuContratistasDocumentos] ADD  CONSTRAINT [DF_PuContratistasDocumentos_Refrendo]  DEFAULT ((0)) FOR [Refrendo]
GO
ALTER TABLE [dbo].[PuContratistasEspecialidades] ADD  CONSTRAINT [DF_PuContratistasEspecialidades_money]  DEFAULT ((0)) FOR [Porcentaje]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_CapturarPorcentajeAnticipo]  DEFAULT ((1)) FOR [CapturarPorcentajeAnticipo]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_PorcentajeAnticipo]  DEFAULT ((0)) FOR [PorcentajeAnticipo]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_Anticipo]  DEFAULT ((0)) FOR [Anticipo]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_CapturarPorcentajeFonGar]  DEFAULT ((1)) FOR [CapturarPorcentajeFonGar]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_PorcentajeFonGar]  DEFAULT ((0)) FOR [PorcentajeFonGar]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_FonGar]  DEFAULT ((0)) FOR [FonGar]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_PorcentajeIVA]  DEFAULT ((0)) FOR [PorcentajeIVA]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_Iva]  DEFAULT ((0)) FOR [Iva]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_ImporteSubcontrato]  DEFAULT ((0)) FOR [ImporteSubcontrato]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_ImporteAdendum]  DEFAULT ((0)) FOR [ImporteOrdenesCambio]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_Finiquitado]  DEFAULT ((0)) FOR [Finiquitado]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_Autorizado]  DEFAULT ((0)) FOR [Autorizado]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_Cancelado]  DEFAULT ((0)) FOR [Cancelado]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_FolioEstimaciones]  DEFAULT ((0)) FOR [FolioEstimaciones]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_FolioOC]  DEFAULT ((0)) FOR [FolioOC]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_EsContrato]  DEFAULT ((1)) FOR [TipoCosto]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_EsCliente]  DEFAULT ((1)) FOR [EsProveedor]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_ImporteDelEjercicio]  DEFAULT ((0)) FOR [ImporteDelEjercicio]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_MontoIncumplimiento]  DEFAULT ((0)) FOR [MontoIncumplimiento]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_MontoFianza]  DEFAULT ((0)) FOR [MontoFianza]
GO
ALTER TABLE [dbo].[PuContratos] ADD  CONSTRAINT [DF_PuContratos_EsDestajo]  DEFAULT ((0)) FOR [EsDestajo]
GO
ALTER TABLE [dbo].[PuContratosConsecutivos] ADD  CONSTRAINT [DF_PuContratosConsecutivos_FolioOC]  DEFAULT ((0)) FOR [FolioOrdenCambio]
GO
ALTER TABLE [dbo].[PuContratosConsecutivos] ADD  CONSTRAINT [DF_PuContratosConsecutivos_FolioEstimaciones]  DEFAULT ((0)) FOR [FolioEstimacion]
GO
ALTER TABLE [dbo].[PuContratosConsecutivos] ADD  CONSTRAINT [DF_PuContratosConsecutivos_RenglonContrato]  DEFAULT ((0)) FOR [FolioRenglonContrato]
GO
ALTER TABLE [dbo].[PuContratosConsecutivos] ADD  CONSTRAINT [DF_PuContratosConsecutivos_FolioGenerador]  DEFAULT ((0)) FOR [FolioGenerador]
GO
ALTER TABLE [dbo].[PuContratosConsecutivos] ADD  CONSTRAINT [DF_PuContratosConsecutivos_ConsecutivoEstimacion]  DEFAULT ((0)) FOR [ConsecutivoEstimacion]
GO
ALTER TABLE [dbo].[PuContratosDeducciones] ADD  CONSTRAINT [DF_PuContratosDeducciones_Porcentaje]  DEFAULT ((0)) FOR [Porcentaje]
GO
ALTER TABLE [dbo].[PuContratosDet] ADD  CONSTRAINT [DF_PuContratosDet_Cantidad]  DEFAULT ((0)) FOR [Cantidad]
GO
ALTER TABLE [dbo].[PuContratosDet] ADD  CONSTRAINT [DF_PuContratosDet_CantidadAdicional]  DEFAULT ((0)) FOR [CantidadAdicional]
GO
ALTER TABLE [dbo].[PuContratosDet] ADD  CONSTRAINT [DF_PuContratosDet_Costo]  DEFAULT ((0)) FOR [Costo]
GO
ALTER TABLE [dbo].[PuContratosDet] ADD  CONSTRAINT [DF_PuContratosDet_CostoMOGravable]  DEFAULT ((0)) FOR [Costo97]
GO
ALTER TABLE [dbo].[PuContratosDet] ADD  CONSTRAINT [DF_PuContratosDet_ExportadosSAP]  DEFAULT ((0)) FOR [ExportadoSAP]
GO
ALTER TABLE [dbo].[PuContratosDocumentos] ADD  CONSTRAINT [DF_PuContratosDocumentos_Entregado]  DEFAULT ((0)) FOR [Entregado]
GO
ALTER TABLE [dbo].[PuContratosMonedas] ADD  CONSTRAINT [DF_PuContratosMonedas_Paridad]  DEFAULT ((1)) FOR [Paridad]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_foper]  DEFAULT ((0)) FOR [foper]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_potencia]  DEFAULT ((0)) FOR [potencia]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_ve]  DEFAULT ((0)) FOR [ve]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_ha]  DEFAULT ((0)) FOR [ha]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_vr]  DEFAULT ((0)) FOR [vr]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_s]  DEFAULT ((0)) FOR [s]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_q]  DEFAULT ((0)) FOR [q]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_factcomb]  DEFAULT ((0)) FOR [factcomb]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_ccarter]  DEFAULT ((0)) FOR [ccarter]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_horasc]  DEFAULT ((0)) FOR [horasc]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_faceite]  DEFAULT ((0)) FOR [faceite]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_hllantas]  DEFAULT ((0)) FOR [hllantas]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_hPiezas]  DEFAULT ((0)) FOR [hPiezas]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_ValorComercial]  DEFAULT ((0)) FOR [ValorComercial]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_factFuentes]  DEFAULT ((0)) FOR [factFuentes]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_UnidadPotencia]  DEFAULT ('HP') FOR [UnidadPotencia]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_TipoCombustible]  DEFAULT ((1)) FOR [TipoCombustible]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_CalculoDetallado]  DEFAULT ((1)) FOR [CalculoDetallado]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_CantidadCombustible]  DEFAULT ((0)) FOR [CantidadCombustible]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_CantidadLubricante]  DEFAULT ((0)) FOR [CantidadLubricante]
GO
ALTER TABLE [dbo].[PuCostosHorarios] ADD  CONSTRAINT [DF_PuCostosHorarios_ProponerCodigos]  DEFAULT ((0)) FOR [ProponerCodigos]
GO
ALTER TABLE [dbo].[PuCostosHorariosMO] ADD  CONSTRAINT [DF_PuCostosHorariosMO_Renglon]  DEFAULT ((0)) FOR [Renglon]
GO
ALTER TABLE [dbo].[PuCostosHorariosMO] ADD  CONSTRAINT [DF_PuCostosHorariosMO_Dividir]  DEFAULT ((0)) FOR [Dividir]
GO
ALTER TABLE [dbo].[PuCostosHorariosMO] ADD  CONSTRAINT [DF_PuCostosHorariosMO_Volumen]  DEFAULT ((0)) FOR [Volumen]
GO
ALTER TABLE [dbo].[PuCostosHorariosOC] ADD  CONSTRAINT [DF_PuCostosHorariosOC_Renglon]  DEFAULT ((0)) FOR [Renglon]
GO
ALTER TABLE [dbo].[PuCostosHorariosOC] ADD  CONSTRAINT [DF_PuCostosHorariosOC_Dividir]  DEFAULT ((0)) FOR [Dividir]
GO
ALTER TABLE [dbo].[PuCostosHorariosOC] ADD  CONSTRAINT [DF_PuCostosHorariosOC_Volumen]  DEFAULT ((0)) FOR [Volumen]
GO
ALTER TABLE [dbo].[PuCostosXCiudad] ADD  CONSTRAINT [DF_PuCostosXCiudad_ProveedorDefault]  DEFAULT ((0)) FOR [ProveedorDefault]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_CuotaFijaPat]  DEFAULT ((0)) FOR [CuotaFijaPat]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_ExcedentePat]  DEFAULT ((0)) FOR [ExcedentePat]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_ExcedenteAse]  DEFAULT ((0)) FOR [ExcedenteAse]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_PrestDinPat]  DEFAULT ((0)) FOR [PrestDinPat]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_PrestDinAse]  DEFAULT ((0)) FOR [PrestDinAse]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_GastoMedPenPat]  DEFAULT ((0)) FOR [GastoMedPenPat]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_GastoMedPenAse]  DEFAULT ((0)) FOR [GastoMedPenAse]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_InvalidezVidaPat]  DEFAULT ((0)) FOR [InvalidezVidaPat]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_InvalidezVidaAse]  DEFAULT ((0)) FOR [InvalidezVidaAse]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_GuarderiasPat]  DEFAULT ((0)) FOR [GuarderiasPat]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_RetiroPat]  DEFAULT ((0)) FOR [RetiroPat]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_CesantiaVejezPat]  DEFAULT ((0)) FOR [CesantiaVejezPat]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_CesantiaVejezAse]  DEFAULT ((0)) FOR [CesantiaVejezAse]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_LimiteSuperior1]  DEFAULT ((0)) FOR [LimiteSuperior1]
GO
ALTER TABLE [dbo].[PuCuotasVigentesImss] ADD  CONSTRAINT [DF_PuCuotasVigentesImss_LimiteSuperior2]  DEFAULT ((0)) FOR [LimiteSuperior2]
GO
ALTER TABLE [dbo].[PuDeducciones] ADD  CONSTRAINT [DF_PuDeducciones_Porcentaje]  DEFAULT ((0)) FOR [Porcentaje]
GO
ALTER TABLE [dbo].[PuDocumentos] ADD  CONSTRAINT [DF_PuDocumentos_Neodata]  DEFAULT ((0)) FOR [Neodata]
GO
ALTER TABLE [dbo].[PuDocumentos] ADD  CONSTRAINT [DF_PuDocumentos_Extension]  DEFAULT ('.xlsx') FOR [Extension]
GO
ALTER TABLE [dbo].[PuEstados] ADD  CONSTRAINT [DF__Estados__Estado__1BC821DD]  DEFAULT ('EDO') FOR [Estado]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_ImporteAnticipo]  DEFAULT ((0)) FOR [ImporteAnticipo]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_PorcentajeAnticipo]  DEFAULT ((0)) FOR [PorcentajeAnticipo]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_CapturarPorcentajeAnticipo]  DEFAULT ((1)) FOR [CapturarPorcentajeAnticipo]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_ImporteFonGar]  DEFAULT ((0)) FOR [ImporteFonGar]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_PorcentajeFonGar]  DEFAULT ((0)) FOR [PorcentajeFonGar]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_CapturarPorcentajeFonGar]  DEFAULT ((1)) FOR [CapturarPorcentajeFonGar]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_DevolucionFonGar]  DEFAULT ((0)) FOR [DevolucionFonGar]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_PorcentajeFonGarDev]  DEFAULT ((0)) FOR [PorcentajeFonGarDev]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_CapturarPorcentajeFonGarDev]  DEFAULT ((1)) FOR [CapturarPorcentajeFonGarDev]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_PagoACuenta]  DEFAULT ((0)) FOR [PagoACuenta]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_ImporteDeductiva]  DEFAULT ((0)) FOR [ImporteDeductiva]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_ImporteDescuentos]  DEFAULT ((0)) FOR [ImporteDescuentos]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_ImporteLiquido]  DEFAULT ((0)) FOR [ImporteLiquido]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_ImporteIVA]  DEFAULT ((0)) FOR [ImporteIVA]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_Cancelada]  DEFAULT ((0)) FOR [Cancelada]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_Elaborada]  DEFAULT ((0)) FOR [Elaborada]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_EnRevision]  DEFAULT ((0)) FOR [EnRevision]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_Aprobada]  DEFAULT ((0)) FOR [Aprobada]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_Pagada]  DEFAULT ((0)) FOR [Pagada]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_AvanceFisico]  DEFAULT ((0)) FOR [AvanceFisico]
GO
ALTER TABLE [dbo].[PuEstimaciones] ADD  CONSTRAINT [DF_PuEstimaciones_AvanceFinanciero]  DEFAULT ((0)) FOR [AvanceFinanciero]
GO
ALTER TABLE [dbo].[PuEstimacionesDeducciones] ADD  CONSTRAINT [DF_PuEstimacionesDeducciones_Porcentaje]  DEFAULT ((0)) FOR [Porcentaje]
GO
ALTER TABLE [dbo].[PuEstimacionesDeducciones] ADD  CONSTRAINT [DF_PuEstimacionesDeducciones_Importe]  DEFAULT ((0)) FOR [Importe]
GO
ALTER TABLE [dbo].[PuEstimacionesDeducciones] ADD  CONSTRAINT [DF_PuEstimacionesDeducciones_CapturarPorcentaje]  DEFAULT ((1)) FOR [CapturarPorcentaje]
GO
ALTER TABLE [dbo].[PuEstimacionesDet] ADD  CONSTRAINT [DF_PuEstimacionesDet_Precio]  DEFAULT ((0)) FOR [Costo]
GO
ALTER TABLE [dbo].[PuExpIns] ADD  CONSTRAINT [DF_PuExplosionXProyecto_Expins]  DEFAULT ((0)) FOR [Expins]
GO
ALTER TABLE [dbo].[PuExpIns] ADD  CONSTRAINT [DF_PuExplosionXProyecto_Nivel]  DEFAULT ((0)) FOR [Nivel]
GO
ALTER TABLE [dbo].[PuExpIns] ADD  CONSTRAINT [DF_PuExplosionXProyecto_ExpInsl]  DEFAULT ((0)) FOR [ExpInsl]
GO
ALTER TABLE [dbo].[PuExpIns] ADD  CONSTRAINT [DF_PuExplosionXProyecto_insumoIntegrado]  DEFAULT ((0)) FOR [InsumoIntegrado]
GO
ALTER TABLE [dbo].[PuExpIns] ADD  CONSTRAINT [DF_PuCostos_Participa]  DEFAULT ((0)) FOR [Participa]
GO
ALTER TABLE [dbo].[PuExpIns] ADD  CONSTRAINT [DF_PuExpIns_EsCostoHorario]  DEFAULT ((0)) FOR [EsCostoHorario]
GO
ALTER TABLE [dbo].[PuExpIns] ADD  CONSTRAINT [DF_PuExpIns_Marca]  DEFAULT ((0)) FOR [Marca]
GO
ALTER TABLE [dbo].[PuExpIns] ADD  CONSTRAINT [DF_PuExpIns_PendienteAnalizar]  DEFAULT ((0)) FOR [PendienteAnalizar]
GO
ALTER TABLE [dbo].[PuExpIns] ADD  CONSTRAINT [DF_PuExpIns_CantidadParaRequerir]  DEFAULT ((0)) FOR [CantidadParaRequerir]
GO
ALTER TABLE [dbo].[PuExpInsCostos] ADD  CONSTRAINT [DF_PuExpInsCostos_Costo]  DEFAULT ((0)) FOR [Costo]
GO
ALTER TABLE [dbo].[PuExpInsCostos] ADD  CONSTRAINT [DF_PuExpInsCostos_Costo93]  DEFAULT ((0)) FOR [Costo93]
GO
ALTER TABLE [dbo].[PuExpInsCostos] ADD  CONSTRAINT [DF_PuExpInsCostos_Costo94]  DEFAULT ((0)) FOR [Costo94]
GO
ALTER TABLE [dbo].[PuExpInsCostos] ADD  CONSTRAINT [DF_PuExpInsCostos_Costo95]  DEFAULT ((0)) FOR [Costo95]
GO
ALTER TABLE [dbo].[PuExpInsCostos] ADD  CONSTRAINT [DF_PuExpInsCostos_Costo96]  DEFAULT ((0)) FOR [Costo96]
GO
ALTER TABLE [dbo].[PuExpInsCostos] ADD  CONSTRAINT [DF_PuExpInsCostos_Costo97]  DEFAULT ((0)) FOR [Costo97]
GO
ALTER TABLE [dbo].[PuExpInsCostos] ADD  CONSTRAINT [DF_PuExpInsCostos_Costo98]  DEFAULT ((0)) FOR [Costo98]
GO
ALTER TABLE [dbo].[PuExpinsCostosEQ] ADD  CONSTRAINT [DF_PuExpinsCostosEQ_CostoLAB]  DEFAULT ((0)) FOR [CostoCF]
GO
ALTER TABLE [dbo].[PuExpinsCostosEQ] ADD  CONSTRAINT [DF_PuExpinsCostosEQ_CostoCF1]  DEFAULT ((0)) FOR [CostoMO]
GO
ALTER TABLE [dbo].[PuExpinsCostosEQ] ADD  CONSTRAINT [DF_PuExpinsCostosEQ_CostoCF2]  DEFAULT ((0)) FOR [CostoCO]
GO
ALTER TABLE [dbo].[PuExpInsCostosOP] ADD  CONSTRAINT [DF_PuExpInsCostosOP_CostoLAB]  DEFAULT ((0)) FOR [CostoLAB]
GO
ALTER TABLE [dbo].[PuExpInsCostosOP] ADD  CONSTRAINT [DF_PuExpInsCostosOP_Fletes]  DEFAULT ((0)) FOR [Fletes]
GO
ALTER TABLE [dbo].[PuExpInsCostosOP] ADD  CONSTRAINT [DF_PuExpInsCostosOP_Maniobra]  DEFAULT ((0)) FOR [Maniobra]
GO
ALTER TABLE [dbo].[PuExpInsCostosOP] ADD  CONSTRAINT [DF_PuExpInsCostosOP_Almacenaje]  DEFAULT ((0)) FOR [Almacenaje]
GO
ALTER TABLE [dbo].[PuExpInsCostosOP] ADD  CONSTRAINT [DF_PuExpInsCostosOP_Derechos]  DEFAULT ((0)) FOR [Derechos]
GO
ALTER TABLE [dbo].[PuExpInsCostosOP] ADD  CONSTRAINT [DF_PuExpInsCostosOP_Mermas]  DEFAULT ((0)) FOR [Mermas]
GO
ALTER TABLE [dbo].[PuExpInsDestajos] ADD  CONSTRAINT [DF_PuExpInsDestajos_Costo]  DEFAULT ((0)) FOR [CostoMaximo]
GO
ALTER TABLE [dbo].[PuExpInsDestajos] ADD  CONSTRAINT [DF_PuExpInsDestajos_CostoDestajo]  DEFAULT ((0)) FOR [CostoDestajo]
GO
ALTER TABLE [dbo].[PuExpInsMO] ADD  CONSTRAINT [DF_PuCostosMO_Costo_1]  DEFAULT ((0)) FOR [SalarioBase]
GO
ALTER TABLE [dbo].[PuExpInsMO] ADD  CONSTRAINT [DF_PuCostosMO_Factor_1]  DEFAULT ((1)) FOR [Fasar]
GO
ALTER TABLE [dbo].[PuExpInsMO] ADD  CONSTRAINT [DF_PuCostosMO_SalarioReal]  DEFAULT ((0)) FOR [SalarioReal]
GO
ALTER TABLE [dbo].[PuExpInsMO] ADD  CONSTRAINT [DF_PuCostosMO_Fsi]  DEFAULT ((1)) FOR [FactorSalarioIntegrado]
GO
ALTER TABLE [dbo].[PuExpInsMO] ADD  CONSTRAINT [DF_PuCostosMO_SalarioIntegrado]  DEFAULT ((0)) FOR [SalarioIntegrado]
GO
ALTER TABLE [dbo].[PuExpInsMO] ADD  CONSTRAINT [DF_PuCostosMO_Viaticos]  DEFAULT ((0)) FOR [Viaticos]
GO
ALTER TABLE [dbo].[PuExpInsMO] ADD  CONSTRAINT [DF_PuCostosMO_Alimentacion]  DEFAULT ((0)) FOR [AlimentacionYHospedaje]
GO
ALTER TABLE [dbo].[PuExpInsMO] ADD  CONSTRAINT [DF_PuCostosMO_GastosDeSepelio]  DEFAULT ((0)) FOR [GastosDeSepelio]
GO
ALTER TABLE [dbo].[PuExpInsMO] ADD  CONSTRAINT [DF_PuCostosMO_OtrasPrestaciones]  DEFAULT ((0)) FOR [OtrasPrestaciones]
GO
ALTER TABLE [dbo].[PuExpInsMO] ADD  CONSTRAINT [DF_PuExpInsMO_TipoFasar]  DEFAULT ((1)) FOR [TipoFasar]
GO
ALTER TABLE [dbo].[PuExpInsMO] ADD  CONSTRAINT [DF_PuExpInsMO_RiesgosdeTrabajo]  DEFAULT ((0)) FOR [RiesgosdeTrabajo]
GO
ALTER TABLE [dbo].[PuExpinsPar] ADD  CONSTRAINT [DF_PuExpinsPar_Expins]  DEFAULT ((0)) FOR [Expins]
GO
ALTER TABLE [dbo].[PuExpinsXconcepto] ADD  CONSTRAINT [DF_PuExpinsXconcepto_Volumen]  DEFAULT ((0)) FOR [Volumen]
GO
ALTER TABLE [dbo].[PuGeneradores] ADD  CONSTRAINT [DF_PuGeneradores_FolioContratista]  DEFAULT ((0)) FOR [FolioContratista]
GO
ALTER TABLE [dbo].[PuGeneradores] ADD  CONSTRAINT [DF_PuGeneradores_Hoja]  DEFAULT ((0)) FOR [Hoja]
GO
ALTER TABLE [dbo].[PuGeneradores] ADD  CONSTRAINT [DF_PuGeneradores_AvanceFisico]  DEFAULT ((0)) FOR [AvanceFisico]
GO
ALTER TABLE [dbo].[PuGeneradores] ADD  CONSTRAINT [DF_PuGeneradores_EnConciliacion]  DEFAULT ((0)) FOR [EnConciliacion]
GO
ALTER TABLE [dbo].[PuGeneradores] ADD  CONSTRAINT [DF_PuGeneradores_Conciliado]  DEFAULT ((0)) FOR [Conciliado]
GO
ALTER TABLE [dbo].[PuGeneradoresDet] ADD  CONSTRAINT [DF_PuGeneradoresDet_Cantidad]  DEFAULT ((0)) FOR [Cantidad]
GO
ALTER TABLE [dbo].[PuGeneradoresDet] ADD  CONSTRAINT [DF_PuGeneradoresDet_CantidadNormal]  DEFAULT ((0)) FOR [CantidadNormal]
GO
ALTER TABLE [dbo].[PuGeneradoresDet] ADD  CONSTRAINT [DF_PuGeneradoresDet_CantidadExcedente]  DEFAULT ((0)) FOR [CantidadExcedente]
GO
ALTER TABLE [dbo].[PuGeneradoresDet] ADD  CONSTRAINT [DF_PuGeneradoresDet_CantidadExtraordinaria]  DEFAULT ((0)) FOR [CantidadExtraordinaria]
GO
ALTER TABLE [dbo].[PuGeneradoresDet] ADD  CONSTRAINT [DF_PuGeneradoresDet_PorcentajeFondoGarantia]  DEFAULT ((0)) FOR [PorcentajeFondoGarantia]
GO
ALTER TABLE [dbo].[PuGeneradoresDet] ADD  CONSTRAINT [DF_PuGeneradoresDet_CantidadRetencion]  DEFAULT ((0)) FOR [PorcentajeRetencion]
GO
ALTER TABLE [dbo].[PuGeneradoresDet] ADD  CONSTRAINT [DF_PuGeneradoresDet_Importe]  DEFAULT ((0)) FOR [ImporteFondoGarantia]
GO
ALTER TABLE [dbo].[PuGeneradoresDet] ADD  CONSTRAINT [DF_PuGeneradoresDet_ImporteRetencion]  DEFAULT ((0)) FOR [ImporteRetencion]
GO
ALTER TABLE [dbo].[PuGeneradoresDet] ADD  CONSTRAINT [DF_PuGeneradoresDet_CostoDestajo]  DEFAULT ((0)) FOR [CostoDestajo]
GO
ALTER TABLE [dbo].[PuGeneradoresDet] ADD  CONSTRAINT [DF_PuGeneradoresDet_FondoGarantiaPagado_1]  DEFAULT ((0)) FOR [FondoGarantiaPagado]
GO
ALTER TABLE [dbo].[PuIndices] ADD  CONSTRAINT [DF_PuIndices_Predeterminado]  DEFAULT ((0)) FOR [Predeterminado]
GO
ALTER TABLE [dbo].[PuIndicesDet] ADD  CONSTRAINT [DF_PuIndicesDet_Indice]  DEFAULT ((0)) FOR [Indice]
GO
ALTER TABLE [dbo].[PuIntelimat] ADD  CONSTRAINT [DF_PuIntelimat_EsNeodata]  DEFAULT ((1)) FOR [EsNeodata]
GO
ALTER TABLE [dbo].[PuIntelimat] ADD  CONSTRAINT [DF_PuIntelimat_EsLibre]  DEFAULT ((0)) FOR [EsLibre]
GO
ALTER TABLE [dbo].[PuLigasRuta] ADD  CONSTRAINT [DF_PuPrecedencias_TipoRel]  DEFAULT ((0)) FOR [TipoRelacion]
GO
ALTER TABLE [dbo].[PuLigasRuta] ADD  CONSTRAINT [DF_PuPrecedencias_Lag]  DEFAULT ((0)) FOR [Lag]
GO
ALTER TABLE [dbo].[PuMatrices] ADD  CONSTRAINT [DF_PuMatrices_Renglon]  DEFAULT ((0)) FOR [Renglon]
GO
ALTER TABLE [dbo].[PuMatrices] ADD  CONSTRAINT [DF_PuMatrices_Dividir]  DEFAULT ((0)) FOR [Dividir]
GO
ALTER TABLE [dbo].[PuMatrices] ADD  CONSTRAINT [DF_PuMatrices_Volumen]  DEFAULT ((0)) FOR [Volumen]
GO
ALTER TABLE [dbo].[PuMonedas] ADD  CONSTRAINT [DF_PuMonedas_ParidadContratos]  DEFAULT ((1)) FOR [ParidadContratos]
GO
ALTER TABLE [dbo].[PuMonedas] ADD  CONSTRAINT [DF_PuMonedas_EsCalculada]  DEFAULT ((0)) FOR [EsCalculada]
GO
ALTER TABLE [dbo].[PuMonedasCalculadas] ADD  CONSTRAINT [DF_PuMonedasCalculadas_Paridad]  DEFAULT ((1)) FOR [Paridad]
GO
ALTER TABLE [dbo].[PuMovimientos] ADD  CONSTRAINT [DF_PuMovimientos_Suma]  DEFAULT ((1)) FOR [Suma]
GO
ALTER TABLE [dbo].[PuOrdenesCambioDet] ADD  CONSTRAINT [DF_PuOrdenesCambioDet_Cantidad]  DEFAULT ((0)) FOR [Cantidad]
GO
ALTER TABLE [dbo].[PuParametros] ADD  CONSTRAINT [DF_PuParametros_Especifico]  DEFAULT ((0)) FOR [Especifico]
GO
ALTER TABLE [dbo].[PuPorcentajesFM] ADD  CONSTRAINT [DF_PuPorcentajesFM_CostoEQ]  DEFAULT ((0)) FOR [CostoEQ]
GO
ALTER TABLE [dbo].[PuPorcentajesFM] ADD  CONSTRAINT [DF_PuPorcentajesFM_Costo]  DEFAULT ((0)) FOR [Costo]
GO
ALTER TABLE [dbo].[PuPorcentajesFM] ADD  CONSTRAINT [DF_PuPorcentajesFM_Precio]  DEFAULT ((0)) FOR [Precio]
GO
ALTER TABLE [dbo].[PuPorcentajesFM] ADD  CONSTRAINT [DF_PuPorcentajesFM_CostoMA]  DEFAULT ((0)) FOR [CostoMA]
GO
ALTER TABLE [dbo].[PuPorcentajesFM] ADD  CONSTRAINT [DF_PuPorcentajesFM_CostoMO]  DEFAULT ((0)) FOR [CostoMO]
GO
ALTER TABLE [dbo].[PuPorcentajesFM] ADD  CONSTRAINT [DF_PuPorcentajesFM_CostoOtros]  DEFAULT ((0)) FOR [CostoOtros]
GO
ALTER TABLE [dbo].[PuPresupuestos] ADD  CONSTRAINT [DF__Proyectos__Cierr__3AA1AEB8]  DEFAULT ((0)) FOR [Bloqueado]
GO
ALTER TABLE [dbo].[PuPresupuestos] ADD  CONSTRAINT [DF_PuPresupuestos_Autorizado]  DEFAULT ((0)) FOR [Autorizado]
GO
ALTER TABLE [dbo].[PuPresupuestos] ADD  CONSTRAINT [DF_PuPresupuestos_Cerrado]  DEFAULT ((0)) FOR [Cerrado]
GO
ALTER TABLE [dbo].[PuPresupuestos] ADD  CONSTRAINT [DF_Proyectos_PIVA]  DEFAULT ((0)) FOR [PorcentajeIVA]
GO
ALTER TABLE [dbo].[PuPresupuestos] ADD  CONSTRAINT [DF_PuPresupuestos_RequiereCalcular]  DEFAULT ((1)) FOR [RequiereCalcular]
GO
ALTER TABLE [dbo].[PuPresupuestos] ADD  CONSTRAINT [DF_PuPresupuestos_RequiereTotalizar]  DEFAULT ((1)) FOR [RequiereTotalizar]
GO
ALTER TABLE [dbo].[PuPresupuestos] ADD  CONSTRAINT [DF_PuPresupuestos_RequiereCalcularWBS]  DEFAULT ((0)) FOR [RequiereCalcularWBS]
GO
ALTER TABLE [dbo].[PuPresupuestos] ADD  CONSTRAINT [DF_PuPresupuestos_EsMaestro]  DEFAULT ((0)) FOR [EsMaestro]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] ADD  CONSTRAINT [DF_PuPresupuestos_Renglon]  DEFAULT ((10)) FOR [Renglon]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] ADD  CONSTRAINT [DF_PuPresupuestos_Cantidad]  DEFAULT ((0)) FOR [Cantidad]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] ADD  CONSTRAINT [DF_PuPresupuestosConceptos_CantidadTotal]  DEFAULT ((0)) FOR [CantidadTotal]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] ADD  CONSTRAINT [DF_PuPresupuestos_Marca]  DEFAULT ((0)) FOR [Marca]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] ADD  CONSTRAINT [DF_PuPresupuestos_IndirL]  DEFAULT ((0)) FOR [IndirectoEspecial]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] ADD  CONSTRAINT [DF_PuPresupuestos_IndirM]  DEFAULT ((0)) FOR [PorcentajeIndirectoEspecial]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] ADD  CONSTRAINT [DF_PuPresupuestosConceptos_Programado]  DEFAULT ((0)) FOR [AEstimar]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] ADD  CONSTRAINT [DF_PuPresupuestosConceptos_YaEstimado]  DEFAULT ((1)) FOR [YaEstimado]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] ADD  CONSTRAINT [DF_PuPresupuestosConceptos_Terminada]  DEFAULT ((0)) FOR [Programado]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] ADD  CONSTRAINT [DF_PuPresupuestosConceptos_Bloqueada]  DEFAULT ((0)) FOR [Bloqueado]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptosPrecios] ADD  CONSTRAINT [DF_PuPresupuestosConceptosPrecios_Precio]  DEFAULT ((0)) FOR [Precio]
GO
ALTER TABLE [dbo].[PuPresupuestosConsecutivos] ADD  CONSTRAINT [DF_PuPresupuestosConsecutivos_FolioControl]  DEFAULT ((0)) FOR [FolioControlConcepto]
GO
ALTER TABLE [dbo].[PuPresupuestosConsecutivos] ADD  CONSTRAINT [DF_PuPresupuestosConsecutivos_FolioEstructura]  DEFAULT ((0)) FOR [FolioEstructuraPartidas]
GO
ALTER TABLE [dbo].[PuPresupuestosConsecutivos] ADD  CONSTRAINT [DF_PuPresupuestosConsecutivos_FolioPrograma]  DEFAULT ((0)) FOR [FolioPrograma]
GO
ALTER TABLE [dbo].[PuPresupuestosConsecutivos] ADD  CONSTRAINT [DF_PuPresupuestosConsecutivos_FolioBitacora]  DEFAULT ((0)) FOR [FolioBitacora]
GO
ALTER TABLE [dbo].[PuPresupuestosMonedas] ADD  CONSTRAINT [DF_PuPresupuestosMonedas_Paridad]  DEFAULT ((1)) FOR [Paridad]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidas] ADD  CONSTRAINT [DF_PuPartidas_Renglon]  DEFAULT ((1)) FOR [Renglon]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidas] ADD  CONSTRAINT [DF_PuPresupuestosPartidas_Cantidad]  DEFAULT ((1)) FOR [Cantidad]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidas] ADD  CONSTRAINT [DF_PuPresupuestosPartidas_MetrosCuadrados]  DEFAULT ((1)) FOR [MetrosCuadrados]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidasCostos] ADD  CONSTRAINT [DF_PuPresupuestosPartidasCostos_Costo]  DEFAULT ((0)) FOR [Costo]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidasCostos] ADD  CONSTRAINT [DF_PuPresupuestosPartidasCostos_Precio]  DEFAULT ((0)) FOR [Precio]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidasCostos] ADD  CONSTRAINT [DF_PuPresupuestosPartidasCostos_CostoTotal]  DEFAULT ((0)) FOR [CostoTotal]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidasCostos] ADD  CONSTRAINT [DF_PuPresupuestosPartidasCostos_PrecioTotal]  DEFAULT ((0)) FOR [PrecioTotal]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidasCostos] ADD  CONSTRAINT [DF_PuPresupuestosPartidasCostos_Costo1Nivel]  DEFAULT ((0)) FOR [Costo1Nivel]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidasCostos] ADD  CONSTRAINT [DF_PuPresupuestosPartidasCostos_Precio1Nivel]  DEFAULT ((0)) FOR [Precio1Nivel]
GO
ALTER TABLE [dbo].[PuPresupuestosPrecios] ADD  CONSTRAINT [DF_PuPresupuestosPrecios_PrecioTotal]  DEFAULT ((0)) FOR [PrecioTotal]
GO
ALTER TABLE [dbo].[PuPresupuestosPrecios] ADD  CONSTRAINT [DF_PuPresupuestosPrecios_CostoTotal]  DEFAULT ((0)) FOR [CostoTotal]
GO
ALTER TABLE [dbo].[PuPresupuestosPrecios] ADD  CONSTRAINT [DF_PuPresupuestosPrecios_CostoMO]  DEFAULT ((0)) FOR [CostoMO]
GO
ALTER TABLE [dbo].[PuPresupuestosPrecios] ADD  CONSTRAINT [DF_PuPresupuestosPrecios_CostoMA]  DEFAULT ((0)) FOR [CostoMA]
GO
ALTER TABLE [dbo].[PuPresupuestosPrecios] ADD  CONSTRAINT [DF_PuPresupuestosPrecios_CostoEQ]  DEFAULT ((0)) FOR [CostoEQ]
GO
ALTER TABLE [dbo].[PuPresupuestosPrecios] ADD  CONSTRAINT [DF_PuPresupuestosPrecios_CostoOtros]  DEFAULT ((0)) FOR [CostoOtros]
GO
ALTER TABLE [dbo].[PuPresupuestosPrestamosDet] ADD  CONSTRAINT [DF_PuPresupuestosPrestamosDet_Monto]  DEFAULT ((0)) FOR [Monto]
GO
ALTER TABLE [dbo].[PuPresupuestosVersionCostos] ADD  CONSTRAINT [DF_PuPresupuestosVersionCostos_Costo]  DEFAULT ((0)) FOR [Costo]
GO
ALTER TABLE [dbo].[PuPresupuestosVersionCostos] ADD  CONSTRAINT [DF_PuPresupuestosVersionCostos_Importe]  DEFAULT ((0)) FOR [Importe]
GO
ALTER TABLE [dbo].[PuProgramaConceptos] ADD  CONSTRAINT [DF_PuProgramaConceptos_Duracion]  DEFAULT ((1)) FOR [Duracion]
GO
ALTER TABLE [dbo].[PuProgramaConceptos] ADD  CONSTRAINT [DF_PuProgramaConceptos_Rendimiento]  DEFAULT ((1)) FOR [Rendimiento]
GO
ALTER TABLE [dbo].[PuProgramaConceptos] ADD  CONSTRAINT [DF_PuProgramaConceptos_ActividadCritica]  DEFAULT ((0)) FOR [ActividadCritica]
GO
ALTER TABLE [dbo].[PuProgramaConceptos] ADD  CONSTRAINT [DF_PuProgramaConceptos_Holgura]  DEFAULT ((-1)) FOR [Holgura]
GO
ALTER TABLE [dbo].[PuProgramaConceptos] ADD  CONSTRAINT [DF_PuProgramaConceptos_Avance]  DEFAULT ((0)) FOR [Avance]
GO
ALTER TABLE [dbo].[PuProgramaConceptos] ADD  CONSTRAINT [DF_PuProgramaConceptos_Total]  DEFAULT ((0)) FOR [Total]
GO
ALTER TABLE [dbo].[PuProgramaConceptosPeriodos] ADD  CONSTRAINT [DF_PuProgramaConceptos_NoPeriodo]  DEFAULT ((1)) FOR [NoPeriodo]
GO
ALTER TABLE [dbo].[PuProgramaConceptosPeriodos] ADD  CONSTRAINT [DF_PuProgramaConceptos_Porcentaje]  DEFAULT ((0)) FOR [Porcentaje]
GO
ALTER TABLE [dbo].[PuProgramaPartidas] ADD  CONSTRAINT [DF_PuProgramaPartidas_ActividadCritica]  DEFAULT ((0)) FOR [ActividadCritica]
GO
ALTER TABLE [dbo].[PuProgramaPartidas] ADD  CONSTRAINT [DF_PuProgramaPartidas_Duracion]  DEFAULT ((1)) FOR [Duracion]
GO
ALTER TABLE [dbo].[PuProgramaPartidas] ADD  CONSTRAINT [DF_PuProgramaPartidas_Total]  DEFAULT ((0)) FOR [Total]
GO
ALTER TABLE [dbo].[PuProgramas] ADD  CONSTRAINT [DF_PuProgramas_NumPeriodos]  DEFAULT ((1)) FOR [NoPeriodos]
GO
ALTER TABLE [dbo].[PuProgramas] ADD  CONSTRAINT [DF_PuProgramas_Periodicidad]  DEFAULT ((0)) FOR [Periodicidad]
GO
ALTER TABLE [dbo].[PuProgramas] ADD  CONSTRAINT [DF_PuProgramas_CapturarCantidad]  DEFAULT ((1)) FOR [CapturarPorcentaje]
GO
ALTER TABLE [dbo].[PuProgramas] ADD  CONSTRAINT [DF_PuProgramas_Activo]  DEFAULT ((1)) FOR [Vigente]
GO
ALTER TABLE [dbo].[PuProgramas] ADD  CONSTRAINT [DF_PuProgramas_DiasNaturales]  DEFAULT ((0)) FOR [DiasCalendario]
GO
ALTER TABLE [dbo].[PuProgramas] ADD  CONSTRAINT [DF_PuProgramas_DiasCalculados]  DEFAULT ((0)) FOR [DiasHabiles]
GO
ALTER TABLE [dbo].[PuProgramasTipos] ADD  CONSTRAINT [DF_PuProgramasTipos_Participa]  DEFAULT ((0)) FOR [Participa]
GO
ALTER TABLE [dbo].[PuProgramasTipos] ADD  CONSTRAINT [DF_PuProgramasTipos_Horas]  DEFAULT ((0)) FOR [Horas]
GO
ALTER TABLE [dbo].[PuProgramaSum] ADD  CONSTRAINT [DF_PuProgramaSumXCon_NoPeriodo]  DEFAULT ((1)) FOR [NoPeriodo]
GO
ALTER TABLE [dbo].[PuProgramaSum] ADD  CONSTRAINT [DF_PuProgramaSumXCon_Cantidad]  DEFAULT ((0)) FOR [Cantidad]
GO
ALTER TABLE [dbo].[PuProgramaSumXPar] ADD  CONSTRAINT [DF_PuProgramaSumXPar_NoPeriodo]  DEFAULT ((1)) FOR [NoPeriodo]
GO
ALTER TABLE [dbo].[PuProgramaSumXPar] ADD  CONSTRAINT [DF_PuProgramaSumXPar_Cantidad]  DEFAULT ((0)) FOR [Cantidad]
GO
ALTER TABLE [dbo].[PuProveedores] ADD  CONSTRAINT [DF_PuProveedores_ProveedorDefault]  DEFAULT ((0)) FOR [ProveedorDefault]
GO
ALTER TABLE [dbo].[PuRepCarpetas] ADD  CONSTRAINT [DF_PuRepCarpetas_Predeterminada]  DEFAULT ((0)) FOR [Predeterminada]
GO
ALTER TABLE [dbo].[PuTipoInsumos] ADD  CONSTRAINT [DF__TipoInsumo__tipo__4DB4832C]  DEFAULT ((1)) FOR [IdTipo]
GO
ALTER TABLE [dbo].[PuTiposDocumentos] ADD  CONSTRAINT [DF_PuTiposDocumentos_Word]  DEFAULT ((0)) FOR [Word]
GO
ALTER TABLE [dbo].[PuTiposDocumentos] ADD  CONSTRAINT [DF_PuTiposDocumentos_AceptaImagen]  DEFAULT ((0)) FOR [AceptaImagen]
GO
ALTER TABLE [dbo].[SegPermisos] ADD  CONSTRAINT [DF_SegPermisos_PermisoDinamico]  DEFAULT ((0)) FOR [PermisoDinamico]
GO
ALTER TABLE [dbo].[SegUsuarios] ADD  CONSTRAINT [DF_SegUsuarios_Caduca]  DEFAULT ((0)) FOR [Caduca]
GO
ALTER TABLE [dbo].[SegUsuarios] ADD  CONSTRAINT [DF_SegUsuarios_Intentos]  DEFAULT ((0)) FOR [Intentos]
GO
ALTER TABLE [dbo].[SegUsuariosXProyecto] ADD  CONSTRAINT [DF_SegUsuariosXProyecto_Escritura]  DEFAULT ((0)) FOR [Escritura]
GO
ALTER TABLE [dbo].[Version] ADD  CONSTRAINT [DF_Version_LlaveUnica]  DEFAULT ((1)) FOR [LlaveUnica]
GO
ALTER TABLE [dbo].[Version] ADD  CONSTRAINT [DF_Version_Fecha]  DEFAULT ('0000') FOR [Hora]
GO
ALTER TABLE [dbo].[Version] ADD  CONSTRAINT [DF__Version__version__15FA39EE]  DEFAULT ((0)) FOR [versionMayor]
GO
ALTER TABLE [dbo].[Bitacora]  WITH CHECK ADD  CONSTRAINT [FK_Bitacora_BiCatProcesos] FOREIGN KEY([IdProceso])
REFERENCES [dbo].[BiCatProcesos] ([IdProceso])
GO
ALTER TABLE [dbo].[Bitacora] CHECK CONSTRAINT [FK_Bitacora_BiCatProcesos]
GO
ALTER TABLE [dbo].[Bitacora]  WITH CHECK ADD  CONSTRAINT [FK_Bitacora_BiCatSistemas] FOREIGN KEY([IdSistema])
REFERENCES [dbo].[BiCatSistemas] ([IdSistema])
GO
ALTER TABLE [dbo].[Bitacora] CHECK CONSTRAINT [FK_Bitacora_BiCatSistemas]
GO
ALTER TABLE [dbo].[LicContratantes]  WITH CHECK ADD  CONSTRAINT [FK_LicContratantes_PuCiudades] FOREIGN KEY([IdCiudad])
REFERENCES [dbo].[PuCiudades] ([IdCiudad])
GO
ALTER TABLE [dbo].[LicContratantes] CHECK CONSTRAINT [FK_LicContratantes_PuCiudades]
GO
ALTER TABLE [dbo].[LicLicitaciones]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitaciones_LicContratantes] FOREIGN KEY([IdContratante])
REFERENCES [dbo].[LicContratantes] ([IdContratante])
GO
ALTER TABLE [dbo].[LicLicitaciones] CHECK CONSTRAINT [FK_LicLicitaciones_LicContratantes]
GO
ALTER TABLE [dbo].[LicLicitaciones]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitaciones_LicTiposLicitacion] FOREIGN KEY([IdTipoLicitacion])
REFERENCES [dbo].[LicTiposLicitacion] ([IdTipoLicitacion])
GO
ALTER TABLE [dbo].[LicLicitaciones] CHECK CONSTRAINT [FK_LicLicitaciones_LicTiposLicitacion]
GO
ALTER TABLE [dbo].[LicLicitaciones]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitaciones_PuCiudades] FOREIGN KEY([IdCiudadLicitacion])
REFERENCES [dbo].[PuCiudades] ([IdCiudad])
GO
ALTER TABLE [dbo].[LicLicitaciones] CHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades]
GO
ALTER TABLE [dbo].[LicLicitaciones]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitaciones_PuCiudades1] FOREIGN KEY([IdCiudadObra])
REFERENCES [dbo].[PuCiudades] ([IdCiudad])
GO
ALTER TABLE [dbo].[LicLicitaciones] CHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades1]
GO
ALTER TABLE [dbo].[LicLicitaciones]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitaciones_PuMonedas] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[LicLicitaciones] CHECK CONSTRAINT [FK_LicLicitaciones_PuMonedas]
GO
ALTER TABLE [dbo].[LicLicitaciones]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitaciones_PuResponsables] FOREIGN KEY([IdResponsable])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[LicLicitaciones] CHECK CONSTRAINT [FK_LicLicitaciones_PuResponsables]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesContratistas_LicLicitaciones] FOREIGN KEY([IdLicitacion])
REFERENCES [dbo].[LicLicitaciones] ([IdLicitacion])
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas] CHECK CONSTRAINT [FK_LicLicitacionesContratistas_LicLicitaciones]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesContratistas_PuContratistas] FOREIGN KEY([IdContratista])
REFERENCES [dbo].[PuContratistas] ([IdContratista])
GO
ALTER TABLE [dbo].[LicLicitacionesContratistas] CHECK CONSTRAINT [FK_LicLicitacionesContratistas_PuContratistas]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasCuadro]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesContratistasCuadro_LicLicitacionesContratistas] FOREIGN KEY([IdLicitacionContratista])
REFERENCES [dbo].[LicLicitacionesContratistas] ([IdLicitacionContratista])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasCuadro] CHECK CONSTRAINT [FK_LicLicitacionesContratistasCuadro_LicLicitacionesContratistas]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasCuadro]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesContratistasCuadro_LicLicitacionesPresupuesto] FOREIGN KEY([IdLicitacionPresupuesto])
REFERENCES [dbo].[LicLicitacionesPresupuesto] ([IdLicitacionPresupuesto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasCuadro] CHECK CONSTRAINT [FK_LicLicitacionesContratistasCuadro_LicLicitacionesPresupuesto]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasDocumentos]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesContratistasDocumentos_LicLicitacionesContratistas] FOREIGN KEY([IdLicitacionContratista])
REFERENCES [dbo].[LicLicitacionesContratistas] ([IdLicitacionContratista])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasDocumentos] CHECK CONSTRAINT [FK_LicLicitacionesContratistasDocumentos_LicLicitacionesContratistas]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasInsumos]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesContratistasInsumos_LicLicitacionesContratistas] FOREIGN KEY([IdLicitacionContratista])
REFERENCES [dbo].[LicLicitacionesContratistas] ([IdLicitacionContratista])
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasInsumos] CHECK CONSTRAINT [FK_LicLicitacionesContratistasInsumos_LicLicitacionesContratistas]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasInsumos]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesContratistasInsumos_LicLicitacionesInsumos] FOREIGN KEY([IdLicitacionInsumo])
REFERENCES [dbo].[LicLicitacionesInsumos] ([IdLicitacionInsumo])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasInsumos] CHECK CONSTRAINT [FK_LicLicitacionesContratistasInsumos_LicLicitacionesInsumos]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasPeriodos]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesContratistasPeriodos_LicLicitacionesContratistas] FOREIGN KEY([IdLicitacionContratista])
REFERENCES [dbo].[LicLicitacionesContratistas] ([IdLicitacionContratista])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasPeriodos] CHECK CONSTRAINT [FK_LicLicitacionesContratistasPeriodos_LicLicitacionesContratistas]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasPrograma]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesContratistasPrograma_LicLicitacionesContratistas] FOREIGN KEY([IdLicitacionContratista])
REFERENCES [dbo].[LicLicitacionesContratistas] ([IdLicitacionContratista])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasPrograma] CHECK CONSTRAINT [FK_LicLicitacionesContratistasPrograma_LicLicitacionesContratistas]
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasPrograma]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesContratistasPrograma_LicLicitacionesPresupuesto] FOREIGN KEY([IdLicitacionPresupuesto])
REFERENCES [dbo].[LicLicitacionesPresupuesto] ([IdLicitacionPresupuesto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[LicLicitacionesContratistasPrograma] CHECK CONSTRAINT [FK_LicLicitacionesContratistasPrograma_LicLicitacionesPresupuesto]
GO
ALTER TABLE [dbo].[LicLicitacionesDocumentos]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesDocumentos_LicLicitaciones] FOREIGN KEY([IdLicitacion])
REFERENCES [dbo].[LicLicitaciones] ([IdLicitacion])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[LicLicitacionesDocumentos] CHECK CONSTRAINT [FK_LicLicitacionesDocumentos_LicLicitaciones]
GO
ALTER TABLE [dbo].[LicLicitacionesFlujo]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesFlujo_LicLicitaciones] FOREIGN KEY([IdLicitacion])
REFERENCES [dbo].[LicLicitaciones] ([IdLicitacion])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[LicLicitacionesFlujo] CHECK CONSTRAINT [FK_LicLicitacionesFlujo_LicLicitaciones]
GO
ALTER TABLE [dbo].[LicLicitacionesFlujoDet]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesFlujoDet_LicLicitacionesFlujo] FOREIGN KEY([IdLicitacionFlujo])
REFERENCES [dbo].[LicLicitacionesFlujo] ([IdLicitacionFlujo])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[LicLicitacionesFlujoDet] CHECK CONSTRAINT [FK_LicLicitacionesFlujoDet_LicLicitacionesFlujo]
GO
ALTER TABLE [dbo].[LicLicitacionesInsumos]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesInsumos_LicLicitaciones] FOREIGN KEY([IdLicitacion])
REFERENCES [dbo].[LicLicitaciones] ([IdLicitacion])
GO
ALTER TABLE [dbo].[LicLicitacionesInsumos] CHECK CONSTRAINT [FK_LicLicitacionesInsumos_LicLicitaciones]
GO
ALTER TABLE [dbo].[LicLicitacionesPartidas]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesPartidas_LicLicitaciones] FOREIGN KEY([IdLicitacion])
REFERENCES [dbo].[LicLicitaciones] ([IdLicitacion])
GO
ALTER TABLE [dbo].[LicLicitacionesPartidas] CHECK CONSTRAINT [FK_LicLicitacionesPartidas_LicLicitaciones]
GO
ALTER TABLE [dbo].[LicLicitacionesPartidas]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesPartidas_LicLicitacionesPartidas] FOREIGN KEY([IdPartidaPadre])
REFERENCES [dbo].[LicLicitacionesPartidas] ([IdLicitacionPartida])
GO
ALTER TABLE [dbo].[LicLicitacionesPartidas] CHECK CONSTRAINT [FK_LicLicitacionesPartidas_LicLicitacionesPartidas]
GO
ALTER TABLE [dbo].[LicLicitacionesPresupuesto]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesPresupuesto_LicLicitaciones] FOREIGN KEY([IdLicitacion])
REFERENCES [dbo].[LicLicitaciones] ([IdLicitacion])
GO
ALTER TABLE [dbo].[LicLicitacionesPresupuesto] CHECK CONSTRAINT [FK_LicLicitacionesPresupuesto_LicLicitaciones]
GO
ALTER TABLE [dbo].[LicLicitacionesPresupuesto]  WITH CHECK ADD  CONSTRAINT [FK_LicLicitacionesPresupuesto_LicLicitacionesPartidas] FOREIGN KEY([IdLicitacionPartida])
REFERENCES [dbo].[LicLicitacionesPartidas] ([IdLicitacionPartida])
GO
ALTER TABLE [dbo].[LicLicitacionesPresupuesto] CHECK CONSTRAINT [FK_LicLicitacionesPresupuesto_LicLicitacionesPartidas]
GO
ALTER TABLE [dbo].[LicTiposLicitacionDocumentos]  WITH CHECK ADD  CONSTRAINT [FK_LicTiposLicitacionDocumentos_LicTiposLicitacion] FOREIGN KEY([IdTipoLicitacion])
REFERENCES [dbo].[LicTiposLicitacion] ([IdTipoLicitacion])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[LicTiposLicitacionDocumentos] CHECK CONSTRAINT [FK_LicTiposLicitacionDocumentos_LicTiposLicitacion]
GO
ALTER TABLE [dbo].[LicTiposLicitacionFlujo]  WITH CHECK ADD  CONSTRAINT [FK_LicTiposLicitacionFlujo_LicTiposLicitacion] FOREIGN KEY([IdTipoLicitacion])
REFERENCES [dbo].[LicTiposLicitacion] ([IdTipoLicitacion])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[LicTiposLicitacionFlujo] CHECK CONSTRAINT [FK_LicTiposLicitacionFlujo_LicTiposLicitacion]
GO
ALTER TABLE [dbo].[LicTiposLicitacionFlujoDet]  WITH CHECK ADD  CONSTRAINT [FK_LicTiposLicitacionFlujoDet_LicTiposLicitacionFlujo] FOREIGN KEY([IdTipoLicitacionFlujo])
REFERENCES [dbo].[LicTiposLicitacionFlujo] ([IdTipoLicitacionFlujo])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[LicTiposLicitacionFlujoDet] CHECK CONSTRAINT [FK_LicTiposLicitacionFlujoDet_LicTiposLicitacionFlujo]
GO
ALTER TABLE [dbo].[PuCalendariosDet]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCalendariosDet_PuCalendarios] FOREIGN KEY([IdCalendario])
REFERENCES [dbo].[PuCalendarios] ([IdCalendario])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuCalendariosDet] CHECK CONSTRAINT [FK_PuCalendariosDet_PuCalendarios]
GO
ALTER TABLE [dbo].[PuCatalogo]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCatalogo_Familias] FOREIGN KEY([IdFamilia])
REFERENCES [dbo].[PuFamilias] ([idFamilia])
GO
ALTER TABLE [dbo].[PuCatalogo] CHECK CONSTRAINT [FK_PuCatalogo_Familias]
GO
ALTER TABLE [dbo].[PuCatalogo]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCatalogo_PuFichasTecnicas] FOREIGN KEY([IdFichaTecnica])
REFERENCES [dbo].[PuFichasTecnicas] ([IdFichaTecnica])
GO
ALTER TABLE [dbo].[PuCatalogo] CHECK CONSTRAINT [FK_PuCatalogo_PuFichasTecnicas]
GO
ALTER TABLE [dbo].[PuCatalogo]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCatalogo_PuImagenes] FOREIGN KEY([IdImagen])
REFERENCES [dbo].[PuImagenes] ([IdImagen])
GO
ALTER TABLE [dbo].[PuCatalogo] CHECK CONSTRAINT [FK_PuCatalogo_PuImagenes]
GO
ALTER TABLE [dbo].[PuCatalogo]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCatalogo_PuProcedimientos] FOREIGN KEY([IdProcedimiento])
REFERENCES [dbo].[PuProcedimientos] ([IdProcedimiento])
GO
ALTER TABLE [dbo].[PuCatalogo] CHECK CONSTRAINT [FK_PuCatalogo_PuProcedimientos]
GO
ALTER TABLE [dbo].[PuCatalogo]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCatalogo_PuProveedores] FOREIGN KEY([IdProveedor])
REFERENCES [dbo].[PuProveedores] ([IdProveedor])
GO
ALTER TABLE [dbo].[PuCatalogo] CHECK CONSTRAINT [FK_PuCatalogo_PuProveedores]
GO
ALTER TABLE [dbo].[PuCatalogo]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCatalogo_PuUnidades] FOREIGN KEY([IdUnidad])
REFERENCES [dbo].[PuUnidades] ([IdUnidad])
GO
ALTER TABLE [dbo].[PuCatalogo] CHECK CONSTRAINT [FK_PuCatalogo_PuUnidades]
GO
ALTER TABLE [dbo].[PuCatalogo]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCatalogo_TipoInsumos] FOREIGN KEY([IdTipo])
REFERENCES [dbo].[PuTipoInsumos] ([IdTipo])
GO
ALTER TABLE [dbo].[PuCatalogo] CHECK CONSTRAINT [FK_PuCatalogo_TipoInsumos]
GO
ALTER TABLE [dbo].[PuCatalogoIndices]  WITH CHECK ADD  CONSTRAINT [FK_PuCatalogoIndices_PuCatalogo] FOREIGN KEY([IdCodigo])
REFERENCES [dbo].[PuCatalogo] ([IdCodigo])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuCatalogoIndices] CHECK CONSTRAINT [FK_PuCatalogoIndices_PuCatalogo]
GO
ALTER TABLE [dbo].[PuCatalogoIndices]  WITH CHECK ADD  CONSTRAINT [FK_PuCatalogoIndices_PuFamiliasIndices] FOREIGN KEY([IdFamiliaIndice])
REFERENCES [dbo].[PuFamiliasIndices] ([IdFamiliaIndice])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuCatalogoIndices] CHECK CONSTRAINT [FK_PuCatalogoIndices_PuFamiliasIndices]
GO
ALTER TABLE [dbo].[PuCiudades]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCiudades_Estados] FOREIGN KEY([IdEstado])
REFERENCES [dbo].[PuEstados] ([IdEstado])
GO
ALTER TABLE [dbo].[PuCiudades] CHECK CONSTRAINT [FK_PuCiudades_Estados]
GO
ALTER TABLE [dbo].[PuClientes]  WITH NOCHECK ADD  CONSTRAINT [FK_PuClientes_PuCiudades] FOREIGN KEY([IdCiudad])
REFERENCES [dbo].[PuCiudades] ([IdCiudad])
GO
ALTER TABLE [dbo].[PuClientes] CHECK CONSTRAINT [FK_PuClientes_PuCiudades]
GO
ALTER TABLE [dbo].[PuClientesContactos]  WITH CHECK ADD  CONSTRAINT [FK_PuClientesContactos_PuClientes] FOREIGN KEY([IdCliente])
REFERENCES [dbo].[PuClientes] ([IdCliente])
GO
ALTER TABLE [dbo].[PuClientesContactos] CHECK CONSTRAINT [FK_PuClientesContactos_PuClientes]
GO
ALTER TABLE [dbo].[PuContratantesConsecutivos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratantesConsecutivos_PuContratistas] FOREIGN KEY([IdContratista])
REFERENCES [dbo].[PuContratistas] ([IdContratista])
GO
ALTER TABLE [dbo].[PuContratantesConsecutivos] CHECK CONSTRAINT [FK_PuContratantesConsecutivos_PuContratistas]
GO
ALTER TABLE [dbo].[PuContratantesConsecutivos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratantesConsecutivos_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
GO
ALTER TABLE [dbo].[PuContratantesConsecutivos] CHECK CONSTRAINT [FK_PuContratantesConsecutivos_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuContratistaMaquinaria]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistaMaquinaria_PuCatMaquinariaContratista] FOREIGN KEY([IdCatMaquinariaContratista])
REFERENCES [dbo].[PuCatMaquinariaContratista] ([IdCatMaquinariaContratista])
GO
ALTER TABLE [dbo].[PuContratistaMaquinaria] CHECK CONSTRAINT [FK_PuContratistaMaquinaria_PuCatMaquinariaContratista]
GO
ALTER TABLE [dbo].[PuContratistaMaquinaria]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistaMaquinaria_PuContratistas] FOREIGN KEY([IdContratista])
REFERENCES [dbo].[PuContratistas] ([IdContratista])
GO
ALTER TABLE [dbo].[PuContratistaMaquinaria] CHECK CONSTRAINT [FK_PuContratistaMaquinaria_PuContratistas]
GO
ALTER TABLE [dbo].[PuContratistas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistas_PuCamara] FOREIGN KEY([RegisE_IdCamara])
REFERENCES [dbo].[PuCamara] ([IdCamara])
GO
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_PuCamara]
GO
ALTER TABLE [dbo].[PuContratistas]  WITH NOCHECK ADD  CONSTRAINT [FK_PuContratistas_PuCiudades] FOREIGN KEY([idCiudad])
REFERENCES [dbo].[PuCiudades] ([IdCiudad])
GO
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_PuCiudades]
GO
ALTER TABLE [dbo].[PuContratistas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistas_PuContribuyente] FOREIGN KEY([Emp_IdContribuyente])
REFERENCES [dbo].[PuContribuyente] ([IdContribuyente])
GO
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_PuContribuyente]
GO
ALTER TABLE [dbo].[PuContratistas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistas_PuEmpresaAfianzadora] FOREIGN KEY([ConstE_IdEmpresaAfianzadora])
REFERENCES [dbo].[PuEmpresaAfianzadora] ([IdEmpresaAfianzadora])
GO
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_PuEmpresaAfianzadora]
GO
ALTER TABLE [dbo].[PuContratistas]  WITH NOCHECK ADD  CONSTRAINT [FK_PuContratistas_PuMonedas] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_PuMonedas]
GO
ALTER TABLE [dbo].[PuContratistas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistas_PuSesionCAOP] FOREIGN KEY([Emp_IdSesionCAOP])
REFERENCES [dbo].[PuSesionCAOP] ([IdSesionCAOP])
GO
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_PuSesionCAOP]
GO
ALTER TABLE [dbo].[PuContratistas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistas_PuStatusControlPadron] FOREIGN KEY([DatosC_IdStatusControlPadron])
REFERENCES [dbo].[PuStatusControlPadron] ([IdStatusControlPadron])
GO
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_PuStatusControlPadron]
GO
ALTER TABLE [dbo].[PuContratistas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistas_PuTipoProveedor] FOREIGN KEY([Emp_IdTipoProveedor])
REFERENCES [dbo].[PuTipoProveedor] ([IdTipoProveedor])
GO
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_PuTipoProveedor]
GO
ALTER TABLE [dbo].[PuContratistas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistas_SegUsuarios] FOREIGN KEY([IdUsuario])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_SegUsuarios]
GO
ALTER TABLE [dbo].[PuContratistas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistas_SegUsuarios1] FOREIGN KEY([IdUsuarioImprimeContrarecibo])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_SegUsuarios1]
GO
ALTER TABLE [dbo].[PuContratistas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistas_SegUsuarios2] FOREIGN KEY([IdUsuarioGeneraRegistroDefinitivo])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_SegUsuarios2]
GO
ALTER TABLE [dbo].[PuContratistasActividades]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistasActividades_PuCatalogo] FOREIGN KEY([IdCodigo])
REFERENCES [dbo].[PuCatalogo] ([IdCodigo])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuContratistasActividades] CHECK CONSTRAINT [FK_PuContratistasActividades_PuCatalogo]
GO
ALTER TABLE [dbo].[PuContratistasActividades]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistasActividades_PuContratistas] FOREIGN KEY([IdContratista])
REFERENCES [dbo].[PuContratistas] ([IdContratista])
GO
ALTER TABLE [dbo].[PuContratistasActividades] CHECK CONSTRAINT [FK_PuContratistasActividades_PuContratistas]
GO
ALTER TABLE [dbo].[PuContratistasDocumentos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistasDocumentos_PuContratistas] FOREIGN KEY([IdContratista])
REFERENCES [dbo].[PuContratistas] ([IdContratista])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuContratistasDocumentos] CHECK CONSTRAINT [FK_PuContratistasDocumentos_PuContratistas]
GO
ALTER TABLE [dbo].[PuContratistasEspecialidades]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistasEspecialidades_PuCatEspecialidadesContratista] FOREIGN KEY([IdCatEspecialidadContratista])
REFERENCES [dbo].[PuCatEspecialidadesContratista] ([IdCatEspecialidadContratista])
GO
ALTER TABLE [dbo].[PuContratistasEspecialidades] CHECK CONSTRAINT [FK_PuContratistasEspecialidades_PuCatEspecialidadesContratista]
GO
ALTER TABLE [dbo].[PuContratistasEspecialidades]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistasEspecialidades_PuContratistas] FOREIGN KEY([IdContratista])
REFERENCES [dbo].[PuContratistas] ([IdContratista])
GO
ALTER TABLE [dbo].[PuContratistasEspecialidades] CHECK CONSTRAINT [FK_PuContratistasEspecialidades_PuContratistas]
GO
ALTER TABLE [dbo].[PuContratistasRefrendos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistasRefrendos_PuContratistas] FOREIGN KEY([IdContratista])
REFERENCES [dbo].[PuContratistas] ([IdContratista])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuContratistasRefrendos] CHECK CONSTRAINT [FK_PuContratistasRefrendos_PuContratistas]
GO
ALTER TABLE [dbo].[PuContratistasRefrendos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistasRefrendos_SegUsuarios] FOREIGN KEY([IdUsuarioRefrendo])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuContratistasRefrendos] CHECK CONSTRAINT [FK_PuContratistasRefrendos_SegUsuarios]
GO
ALTER TABLE [dbo].[PuContratistasRepresentantesL]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistasRepresentantesL_PuCiudades] FOREIGN KEY([IdCiudad])
REFERENCES [dbo].[PuCiudades] ([IdCiudad])
GO
ALTER TABLE [dbo].[PuContratistasRepresentantesL] CHECK CONSTRAINT [FK_PuContratistasRepresentantesL_PuCiudades]
GO
ALTER TABLE [dbo].[PuContratistasRepresentantesL]  WITH CHECK ADD  CONSTRAINT [FK_PuContratistasRepresentantesL_PuContratistas] FOREIGN KEY([IdContratista])
REFERENCES [dbo].[PuContratistas] ([IdContratista])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuContratistasRepresentantesL] CHECK CONSTRAINT [FK_PuContratistasRepresentantesL_PuContratistas]
GO
ALTER TABLE [dbo].[PuContratos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuContratos_PuContratistas] FOREIGN KEY([idContratista])
REFERENCES [dbo].[PuContratistas] ([IdContratista])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuContratistas]
GO
ALTER TABLE [dbo].[PuContratos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratos_PuContratistas1] FOREIGN KEY([IdContratante])
REFERENCES [dbo].[PuContratistas] ([IdContratista])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuContratistas1]
GO
ALTER TABLE [dbo].[PuContratos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuContratos_PuResponsables] FOREIGN KEY([idResidente])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuResponsables]
GO
ALTER TABLE [dbo].[PuContratos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuContratos_PuResponsables1] FOREIGN KEY([idSupIntendente1])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuResponsables1]
GO
ALTER TABLE [dbo].[PuContratos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratos_PuResponsables10] FOREIGN KEY([IdFirma7])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuResponsables10]
GO
ALTER TABLE [dbo].[PuContratos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratos_PuResponsables11] FOREIGN KEY([IdFirma8])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuResponsables11]
GO
ALTER TABLE [dbo].[PuContratos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuContratos_PuResponsables2] FOREIGN KEY([idSupIntendente2])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuResponsables2]
GO
ALTER TABLE [dbo].[PuContratos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuContratos_PuResponsables3] FOREIGN KEY([idVoBo])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuResponsables3]
GO
ALTER TABLE [dbo].[PuContratos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratos_PuResponsables4] FOREIGN KEY([IdFirma1])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuResponsables4]
GO
ALTER TABLE [dbo].[PuContratos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratos_PuResponsables5] FOREIGN KEY([IdFirma2])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuResponsables5]
GO
ALTER TABLE [dbo].[PuContratos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratos_PuResponsables6] FOREIGN KEY([IdFirma3])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuResponsables6]
GO
ALTER TABLE [dbo].[PuContratos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratos_PuResponsables7] FOREIGN KEY([IdFirma4])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuResponsables7]
GO
ALTER TABLE [dbo].[PuContratos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratos_PuResponsables8] FOREIGN KEY([IdFirma5])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuResponsables8]
GO
ALTER TABLE [dbo].[PuContratos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratos_PuResponsables9] FOREIGN KEY([IdFirma6])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuContratos] CHECK CONSTRAINT [FK_PuContratos_PuResponsables9]
GO
ALTER TABLE [dbo].[PuContratosConsecutivos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuContratosConsecutivos_PuContratos] FOREIGN KEY([IdContrato])
REFERENCES [dbo].[PuContratos] ([IdContrato])
GO
ALTER TABLE [dbo].[PuContratosConsecutivos] CHECK CONSTRAINT [FK_PuContratosConsecutivos_PuContratos]
GO
ALTER TABLE [dbo].[PuContratosDeducciones]  WITH CHECK ADD  CONSTRAINT [FK_PuContratosDeducciones_PuContratos] FOREIGN KEY([IdContrato])
REFERENCES [dbo].[PuContratos] ([IdContrato])
GO
ALTER TABLE [dbo].[PuContratosDeducciones] CHECK CONSTRAINT [FK_PuContratosDeducciones_PuContratos]
GO
ALTER TABLE [dbo].[PuContratosDeducciones]  WITH CHECK ADD  CONSTRAINT [FK_PuContratosDeducciones_PuDeducciones] FOREIGN KEY([IdDeduccion])
REFERENCES [dbo].[PuDeducciones] ([IdDeduccion])
GO
ALTER TABLE [dbo].[PuContratosDeducciones] CHECK CONSTRAINT [FK_PuContratosDeducciones_PuDeducciones]
GO
ALTER TABLE [dbo].[PuContratosDet]  WITH NOCHECK ADD  CONSTRAINT [FK_PuContratosDet_PuContratos] FOREIGN KEY([IdContrato])
REFERENCES [dbo].[PuContratos] ([IdContrato])
GO
ALTER TABLE [dbo].[PuContratosDet] CHECK CONSTRAINT [FK_PuContratosDet_PuContratos]
GO
ALTER TABLE [dbo].[PuContratosDet]  WITH NOCHECK ADD  CONSTRAINT [FK_PuContratosDet_PuPresupuestosConceptos] FOREIGN KEY([IdPresupuestoConcepto])
REFERENCES [dbo].[PuPresupuestosConceptos] ([IdPresupuestoConcepto])
GO
ALTER TABLE [dbo].[PuContratosDet] CHECK CONSTRAINT [FK_PuContratosDet_PuPresupuestosConceptos]
GO
ALTER TABLE [dbo].[PuContratosDocumentos]  WITH CHECK ADD  CONSTRAINT [FK_PuContratosDocumentos_PuContratos] FOREIGN KEY([IdContrato])
REFERENCES [dbo].[PuContratos] ([IdContrato])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuContratosDocumentos] CHECK CONSTRAINT [FK_PuContratosDocumentos_PuContratos]
GO
ALTER TABLE [dbo].[PuContratosFacturas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratosFacturas_PuContratos] FOREIGN KEY([IdContrato])
REFERENCES [dbo].[PuContratos] ([IdContrato])
GO
ALTER TABLE [dbo].[PuContratosFacturas] CHECK CONSTRAINT [FK_PuContratosFacturas_PuContratos]
GO
ALTER TABLE [dbo].[PuContratosFacturas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratosFacturas_PuDocumentos] FOREIGN KEY([IdDocumento])
REFERENCES [dbo].[PuDocumentos] ([IdDocumento])
GO
ALTER TABLE [dbo].[PuContratosFacturas] CHECK CONSTRAINT [FK_PuContratosFacturas_PuDocumentos]
GO
ALTER TABLE [dbo].[PuContratosMonedas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratosMonedas_PuContratos] FOREIGN KEY([IdContrato])
REFERENCES [dbo].[PuContratos] ([IdContrato])
GO
ALTER TABLE [dbo].[PuContratosMonedas] CHECK CONSTRAINT [FK_PuContratosMonedas_PuContratos]
GO
ALTER TABLE [dbo].[PuContratosMonedas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratosMonedas_PuMonedas] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuContratosMonedas] CHECK CONSTRAINT [FK_PuContratosMonedas_PuMonedas]
GO
ALTER TABLE [dbo].[PuContratosPlantillas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratosPlantillas_PuContratos] FOREIGN KEY([IdContrato])
REFERENCES [dbo].[PuContratos] ([IdContrato])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuContratosPlantillas] CHECK CONSTRAINT [FK_PuContratosPlantillas_PuContratos]
GO
ALTER TABLE [dbo].[PuContratosPlantillas]  WITH CHECK ADD  CONSTRAINT [FK_PuContratosPlantillas_PuDocumentos] FOREIGN KEY([IdDocumento])
REFERENCES [dbo].[PuDocumentos] ([IdDocumento])
GO
ALTER TABLE [dbo].[PuContratosPlantillas] CHECK CONSTRAINT [FK_PuContratosPlantillas_PuDocumentos]
GO
ALTER TABLE [dbo].[PuConversionesAcad]  WITH CHECK ADD  CONSTRAINT [FK_PuConversionesAcad_PuUnidades] FOREIGN KEY([IdUnidad])
REFERENCES [dbo].[PuUnidades] ([IdUnidad])
GO
ALTER TABLE [dbo].[PuConversionesAcad] CHECK CONSTRAINT [FK_PuConversionesAcad_PuUnidades]
GO
ALTER TABLE [dbo].[PuConversionesAcad]  WITH CHECK ADD  CONSTRAINT [FK_PuConversionesAcad_PuUnidadesAcad] FOREIGN KEY([IdUnidadAcad])
REFERENCES [dbo].[PuUnidadesAcad] ([IdUnidadAcad])
GO
ALTER TABLE [dbo].[PuConversionesAcad] CHECK CONSTRAINT [FK_PuConversionesAcad_PuUnidadesAcad]
GO
ALTER TABLE [dbo].[PuCostosHorarios]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCostosHorarios_PuCostos] FOREIGN KEY([IdExpIns])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuCostosHorarios] CHECK CONSTRAINT [FK_PuCostosHorarios_PuCostos]
GO
ALTER TABLE [dbo].[PuCostosHorarios]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCostosHorarios_PuCostos1] FOREIGN KEY([IdExpInsVa])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuCostosHorarios] CHECK CONSTRAINT [FK_PuCostosHorarios_PuCostos1]
GO
ALTER TABLE [dbo].[PuCostosHorarios]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCostosHorarios_PuCostos2] FOREIGN KEY([IdExpInsLla])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuCostosHorarios] CHECK CONSTRAINT [FK_PuCostosHorarios_PuCostos2]
GO
ALTER TABLE [dbo].[PuCostosHorarios]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCostosHorarios_PuCostos3] FOREIGN KEY([IdExpInsComb])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuCostosHorarios] CHECK CONSTRAINT [FK_PuCostosHorarios_PuCostos3]
GO
ALTER TABLE [dbo].[PuCostosHorarios]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCostosHorarios_PuCostos4] FOREIGN KEY([IdExpInsAcei])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuCostosHorarios] CHECK CONSTRAINT [FK_PuCostosHorarios_PuCostos4]
GO
ALTER TABLE [dbo].[PuCostosHorarios]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCostosHorarios_PuCostos5] FOREIGN KEY([IdExpInsOtrasFuentes])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuCostosHorarios] CHECK CONSTRAINT [FK_PuCostosHorarios_PuCostos5]
GO
ALTER TABLE [dbo].[PuCostosHorarios]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCostosHorarios_PuCostos6] FOREIGN KEY([IdExpInsPza])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuCostosHorarios] CHECK CONSTRAINT [FK_PuCostosHorarios_PuCostos6]
GO
ALTER TABLE [dbo].[PuCostosHorarios]  WITH CHECK ADD  CONSTRAINT [FK_PuCostosHorarios_PuExpIns] FOREIGN KEY([IdExpinsE])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuCostosHorarios] CHECK CONSTRAINT [FK_PuCostosHorarios_PuExpIns]
GO
ALTER TABLE [dbo].[PuCostosHorarios]  WITH CHECK ADD  CONSTRAINT [FK_PuCostosHorarios_PuExpIns1] FOREIGN KEY([IdExpinsR])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuCostosHorarios] CHECK CONSTRAINT [FK_PuCostosHorarios_PuExpIns1]
GO
ALTER TABLE [dbo].[PuCostosHorarios]  WITH CHECK ADD  CONSTRAINT [FK_PuCostosHorarios_PuExpIns2] FOREIGN KEY([IdExpInsCF])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuCostosHorarios] CHECK CONSTRAINT [FK_PuCostosHorarios_PuExpIns2]
GO
ALTER TABLE [dbo].[PuCostosHorariosMO]  WITH CHECK ADD  CONSTRAINT [FK_PuCostosHorariosMO_PuCostosHorarios] FOREIGN KEY([IdCostoHorario])
REFERENCES [dbo].[PuCostosHorarios] ([IdCostoHorario])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuCostosHorariosMO] CHECK CONSTRAINT [FK_PuCostosHorariosMO_PuCostosHorarios]
GO
ALTER TABLE [dbo].[PuCostosHorariosMO]  WITH CHECK ADD  CONSTRAINT [FK_PuCostosHorariosMO_PuExpIns] FOREIGN KEY([IdExpins])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuCostosHorariosMO] CHECK CONSTRAINT [FK_PuCostosHorariosMO_PuExpIns]
GO
ALTER TABLE [dbo].[PuCostosHorariosOC]  WITH CHECK ADD  CONSTRAINT [FK_PuCostosHorariosOC_PuCostosHorarios] FOREIGN KEY([IdCostoHorario])
REFERENCES [dbo].[PuCostosHorarios] ([IdCostoHorario])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuCostosHorariosOC] CHECK CONSTRAINT [FK_PuCostosHorariosOC_PuCostosHorarios]
GO
ALTER TABLE [dbo].[PuCostosHorariosOC]  WITH CHECK ADD  CONSTRAINT [FK_PuCostosHorariosOC_PuExpIns] FOREIGN KEY([IdExpins])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuCostosHorariosOC] CHECK CONSTRAINT [FK_PuCostosHorariosOC_PuExpIns]
GO
ALTER TABLE [dbo].[PuCostosHorariosTI]  WITH CHECK ADD  CONSTRAINT [FK_PuCostosHorariosTI_PuCostosHorarios] FOREIGN KEY([IdCostoHorario])
REFERENCES [dbo].[PuCostosHorarios] ([IdCostoHorario])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuCostosHorariosTI] CHECK CONSTRAINT [FK_PuCostosHorariosTI_PuCostosHorarios]
GO
ALTER TABLE [dbo].[PuCostosHorariosTI]  WITH CHECK ADD  CONSTRAINT [FK_PuCostosHorariosTI_PuMonedas] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuCostosHorariosTI] CHECK CONSTRAINT [FK_PuCostosHorariosTI_PuMonedas]
GO
ALTER TABLE [dbo].[PuCostosXCiudad]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCostosXCiudad_PuMonedas] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuCostosXCiudad] CHECK CONSTRAINT [FK_PuCostosXCiudad_PuMonedas]
GO
ALTER TABLE [dbo].[PuCostosXCiudad]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCostosXCiudad_PuProveedores] FOREIGN KEY([IdProveedor])
REFERENCES [dbo].[PuProveedores] ([IdProveedor])
GO
ALTER TABLE [dbo].[PuCostosXCiudad] CHECK CONSTRAINT [FK_PuCostosXCiudad_PuProveedores]
GO
ALTER TABLE [dbo].[PuCostosXCiudad]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCostoXCiudad_PuCatalogo] FOREIGN KEY([IdCodigo])
REFERENCES [dbo].[PuCatalogo] ([IdCodigo])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuCostosXCiudad] CHECK CONSTRAINT [FK_PuCostoXCiudad_PuCatalogo]
GO
ALTER TABLE [dbo].[PuCostosXCiudad]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCostoXCiudad_PuCiudades] FOREIGN KEY([IdCiudad])
REFERENCES [dbo].[PuCiudades] ([IdCiudad])
GO
ALTER TABLE [dbo].[PuCostosXCiudad] CHECK CONSTRAINT [FK_PuCostoXCiudad_PuCiudades]
GO
ALTER TABLE [dbo].[PuDocumentos]  WITH CHECK ADD  CONSTRAINT [FK_PuDocumentos_PuTiposDocumentos] FOREIGN KEY([IdTipoDocumento])
REFERENCES [dbo].[PuTiposDocumentos] ([IdTipoDocumento])
GO
ALTER TABLE [dbo].[PuDocumentos] CHECK CONSTRAINT [FK_PuDocumentos_PuTiposDocumentos]
GO
ALTER TABLE [dbo].[PuEmpresas]  WITH CHECK ADD  CONSTRAINT [FK_PuEmpresas_PuCiudades] FOREIGN KEY([IdCiudad])
REFERENCES [dbo].[PuCiudades] ([IdCiudad])
GO
ALTER TABLE [dbo].[PuEmpresas] CHECK CONSTRAINT [FK_PuEmpresas_PuCiudades]
GO
ALTER TABLE [dbo].[PuEmpresas]  WITH CHECK ADD  CONSTRAINT [FK_PuEmpresas_PuResponsables] FOREIGN KEY([IdResponsable])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuEmpresas] CHECK CONSTRAINT [FK_PuEmpresas_PuResponsables]
GO
ALTER TABLE [dbo].[PuEstimaciones]  WITH NOCHECK ADD  CONSTRAINT [FK_PuEstimaciones_PuContratos] FOREIGN KEY([IdContrato])
REFERENCES [dbo].[PuContratos] ([IdContrato])
GO
ALTER TABLE [dbo].[PuEstimaciones] CHECK CONSTRAINT [FK_PuEstimaciones_PuContratos]
GO
ALTER TABLE [dbo].[PuEstimaciones]  WITH NOCHECK ADD  CONSTRAINT [FK_PuEstimaciones_PuEstimacionesTipos] FOREIGN KEY([IdEstimacionTipo])
REFERENCES [dbo].[PuEstimacionesTipos] ([IdEstimacionTipo])
GO
ALTER TABLE [dbo].[PuEstimaciones] CHECK CONSTRAINT [FK_PuEstimaciones_PuEstimacionesTipos]
GO
ALTER TABLE [dbo].[PuEstimaciones]  WITH CHECK ADD  CONSTRAINT [FK_PuEstimaciones_SegUsuarios] FOREIGN KEY([idUsuarioCancelada])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuEstimaciones] CHECK CONSTRAINT [FK_PuEstimaciones_SegUsuarios]
GO
ALTER TABLE [dbo].[PuEstimaciones]  WITH CHECK ADD  CONSTRAINT [FK_PuEstimaciones_SegUsuarios1] FOREIGN KEY([idUsuarioElaborada])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuEstimaciones] CHECK CONSTRAINT [FK_PuEstimaciones_SegUsuarios1]
GO
ALTER TABLE [dbo].[PuEstimaciones]  WITH CHECK ADD  CONSTRAINT [FK_PuEstimaciones_SegUsuarios2] FOREIGN KEY([idUsuarioEnRevision])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuEstimaciones] CHECK CONSTRAINT [FK_PuEstimaciones_SegUsuarios2]
GO
ALTER TABLE [dbo].[PuEstimaciones]  WITH CHECK ADD  CONSTRAINT [FK_PuEstimaciones_SegUsuarios3] FOREIGN KEY([idUsuarioAprobada])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuEstimaciones] CHECK CONSTRAINT [FK_PuEstimaciones_SegUsuarios3]
GO
ALTER TABLE [dbo].[PuEstimaciones]  WITH CHECK ADD  CONSTRAINT [FK_PuEstimaciones_SegUsuarios4] FOREIGN KEY([idUsuarioPagada])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuEstimaciones] CHECK CONSTRAINT [FK_PuEstimaciones_SegUsuarios4]
GO
ALTER TABLE [dbo].[PuEstimacionesDeducciones]  WITH CHECK ADD  CONSTRAINT [FK_PuEstimacionesDeducciones_PuDeducciones] FOREIGN KEY([IdDeduccion])
REFERENCES [dbo].[PuDeducciones] ([IdDeduccion])
GO
ALTER TABLE [dbo].[PuEstimacionesDeducciones] CHECK CONSTRAINT [FK_PuEstimacionesDeducciones_PuDeducciones]
GO
ALTER TABLE [dbo].[PuEstimacionesDeducciones]  WITH CHECK ADD  CONSTRAINT [FK_PuEstimacionesDeducciones_PuEstimaciones] FOREIGN KEY([IdEstimacion])
REFERENCES [dbo].[PuEstimaciones] ([IdEstimacion])
GO
ALTER TABLE [dbo].[PuEstimacionesDeducciones] CHECK CONSTRAINT [FK_PuEstimacionesDeducciones_PuEstimaciones]
GO
ALTER TABLE [dbo].[PuEstimacionesDet]  WITH CHECK ADD  CONSTRAINT [FK_PuEstimacionesDet_PuContratosDet] FOREIGN KEY([IdContratoDet])
REFERENCES [dbo].[PuContratosDet] ([IdContratoDet])
GO
ALTER TABLE [dbo].[PuEstimacionesDet] CHECK CONSTRAINT [FK_PuEstimacionesDet_PuContratosDet]
GO
ALTER TABLE [dbo].[PuEstimacionesDet]  WITH CHECK ADD  CONSTRAINT [FK_PuEstimacionesDet_PuEstimaciones] FOREIGN KEY([IdEstimacion])
REFERENCES [dbo].[PuEstimaciones] ([IdEstimacion])
GO
ALTER TABLE [dbo].[PuEstimacionesDet] CHECK CONSTRAINT [FK_PuEstimacionesDet_PuEstimaciones]
GO
ALTER TABLE [dbo].[PuEstimacionesEstatusHistorico]  WITH CHECK ADD  CONSTRAINT [FK_PuEstimacionesEstatusHistorico_PuEstimaciones] FOREIGN KEY([idEstimacion])
REFERENCES [dbo].[PuEstimaciones] ([IdEstimacion])
GO
ALTER TABLE [dbo].[PuEstimacionesEstatusHistorico] CHECK CONSTRAINT [FK_PuEstimacionesEstatusHistorico_PuEstimaciones]
GO
ALTER TABLE [dbo].[PuEstimacionesEstatusHistorico]  WITH CHECK ADD  CONSTRAINT [FK_PuEstimacionesEstatusHistorico_SegUsuarios] FOREIGN KEY([idUsuario])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuEstimacionesEstatusHistorico] CHECK CONSTRAINT [FK_PuEstimacionesEstatusHistorico_SegUsuarios]
GO
ALTER TABLE [dbo].[PuExpIns]  WITH NOCHECK ADD  CONSTRAINT [FK_PuCostos_PuCatalogo] FOREIGN KEY([IdCodigo])
REFERENCES [dbo].[PuCatalogo] ([IdCodigo])
GO
ALTER TABLE [dbo].[PuExpIns] CHECK CONSTRAINT [FK_PuCostos_PuCatalogo]
GO
ALTER TABLE [dbo].[PuExpIns]  WITH CHECK ADD  CONSTRAINT [FK_PuExpIns_PuIntelimat] FOREIGN KEY([IdIntelimat])
REFERENCES [dbo].[PuIntelimat] ([IdInteliMat])
GO
ALTER TABLE [dbo].[PuExpIns] CHECK CONSTRAINT [FK_PuExpIns_PuIntelimat]
GO
ALTER TABLE [dbo].[PuExpIns]  WITH CHECK ADD  CONSTRAINT [FK_PuExpIns_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
GO
ALTER TABLE [dbo].[PuExpIns] CHECK CONSTRAINT [FK_PuExpIns_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuExpIns]  WITH NOCHECK ADD  CONSTRAINT [FK_PuExpIns_PuProveedores] FOREIGN KEY([IdProveedor])
REFERENCES [dbo].[PuProveedores] ([IdProveedor])
GO
ALTER TABLE [dbo].[PuExpIns] CHECK CONSTRAINT [FK_PuExpIns_PuProveedores]
GO
ALTER TABLE [dbo].[PuExpInsCostos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuExpInsCostos_PuExpIns] FOREIGN KEY([IdExpIns])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuExpInsCostos] CHECK CONSTRAINT [FK_PuExpInsCostos_PuExpIns]
GO
ALTER TABLE [dbo].[PuExpInsCostos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuExpInsCostos_PuMonedas] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuExpInsCostos] CHECK CONSTRAINT [FK_PuExpInsCostos_PuMonedas]
GO
ALTER TABLE [dbo].[PuExpInsCostosBitacora]  WITH CHECK ADD  CONSTRAINT [FK_PuExpInsCostosBitacora_PuExpInsCostos] FOREIGN KEY([IdExpInsCosto])
REFERENCES [dbo].[PuExpInsCostos] ([IdExpInsCosto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuExpInsCostosBitacora] CHECK CONSTRAINT [FK_PuExpInsCostosBitacora_PuExpInsCostos]
GO
ALTER TABLE [dbo].[PuExpInsCostosBitacora]  WITH CHECK ADD  CONSTRAINT [FK_PuExpInsCostosBitacora_SegUsuarios] FOREIGN KEY([IdUsuario])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuExpInsCostosBitacora] CHECK CONSTRAINT [FK_PuExpInsCostosBitacora_SegUsuarios]
GO
ALTER TABLE [dbo].[PuExpinsCostosEQ]  WITH CHECK ADD  CONSTRAINT [FK_PuExpinsCostosEQ_PuExpInsCostos] FOREIGN KEY([IdExpInsCosto])
REFERENCES [dbo].[PuExpInsCostos] ([IdExpInsCosto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuExpinsCostosEQ] CHECK CONSTRAINT [FK_PuExpinsCostosEQ_PuExpInsCostos]
GO
ALTER TABLE [dbo].[PuExpInsCostosOP]  WITH CHECK ADD  CONSTRAINT [FK_PuExpInsCostosOP_PuExpInsCostos] FOREIGN KEY([IdExpInsCosto])
REFERENCES [dbo].[PuExpInsCostos] ([IdExpInsCosto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuExpInsCostosOP] CHECK CONSTRAINT [FK_PuExpInsCostosOP_PuExpInsCostos]
GO
ALTER TABLE [dbo].[PuExpInsDestajos]  WITH CHECK ADD  CONSTRAINT [FK_PuExpInsDestajos_PuExpIns] FOREIGN KEY([IdExpIns])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuExpInsDestajos] CHECK CONSTRAINT [FK_PuExpInsDestajos_PuExpIns]
GO
ALTER TABLE [dbo].[PuExpInsDestajos]  WITH CHECK ADD  CONSTRAINT [FK_PuExpInsDestajos_PuMonedas] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuExpInsDestajos] CHECK CONSTRAINT [FK_PuExpInsDestajos_PuMonedas]
GO
ALTER TABLE [dbo].[PuExpInsIntelimat]  WITH CHECK ADD  CONSTRAINT [FK_PuExpInsIntelimat_PuExpIns] FOREIGN KEY([IdExpIns])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuExpInsIntelimat] CHECK CONSTRAINT [FK_PuExpInsIntelimat_PuExpIns]
GO
ALTER TABLE [dbo].[PuExpInsMO]  WITH CHECK ADD  CONSTRAINT [FK_PuExpInsMO_PuExpInsCostos] FOREIGN KEY([IdExpInsCosto])
REFERENCES [dbo].[PuExpInsCostos] ([IdExpInsCosto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuExpInsMO] CHECK CONSTRAINT [FK_PuExpInsMO_PuExpInsCostos]
GO
ALTER TABLE [dbo].[PuExpinsPar]  WITH NOCHECK ADD  CONSTRAINT [FK_PuExpinsPar_PuCostos] FOREIGN KEY([IdExpIns])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuExpinsPar] CHECK CONSTRAINT [FK_PuExpinsPar_PuCostos]
GO
ALTER TABLE [dbo].[PuExpinsPar]  WITH NOCHECK ADD  CONSTRAINT [FK_PuExpinsPar_PuPartidas] FOREIGN KEY([IdPresupuestoPartida])
REFERENCES [dbo].[PuPresupuestosPartidas] ([IdPresupuestoPartida])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuExpinsPar] CHECK CONSTRAINT [FK_PuExpinsPar_PuPartidas]
GO
ALTER TABLE [dbo].[PuExpinsXconcepto]  WITH NOCHECK ADD  CONSTRAINT [FK_PuExpinsXconcepto_PuExpIns] FOREIGN KEY([IdCodigoInsumo])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuExpinsXconcepto] CHECK CONSTRAINT [FK_PuExpinsXconcepto_PuExpIns]
GO
ALTER TABLE [dbo].[PuExpinsXconcepto]  WITH NOCHECK ADD  CONSTRAINT [FK_PuExpinsXconcepto_PuExpIns1] FOREIGN KEY([IdCodigoMatriz])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuExpinsXconcepto] CHECK CONSTRAINT [FK_PuExpinsXconcepto_PuExpIns1]
GO
ALTER TABLE [dbo].[PuFamiliasIndices]  WITH CHECK ADD  CONSTRAINT [FK_PuFamiliasIndices_PuIndices] FOREIGN KEY([IdIndice])
REFERENCES [dbo].[PuIndices] ([IdIndice])
GO
ALTER TABLE [dbo].[PuFamiliasIndices] CHECK CONSTRAINT [FK_PuFamiliasIndices_PuIndices]
GO
ALTER TABLE [dbo].[PuGeneradores]  WITH NOCHECK ADD  CONSTRAINT [FK_PuGeneradores_PuContratos] FOREIGN KEY([IdContrato])
REFERENCES [dbo].[PuContratos] ([IdContrato])
GO
ALTER TABLE [dbo].[PuGeneradores] CHECK CONSTRAINT [FK_PuGeneradores_PuContratos]
GO
ALTER TABLE [dbo].[PuGeneradores]  WITH CHECK ADD  CONSTRAINT [FK_PuGeneradores_PuEstimaciones] FOREIGN KEY([IdNormal])
REFERENCES [dbo].[PuEstimaciones] ([IdEstimacion])
GO
ALTER TABLE [dbo].[PuGeneradores] CHECK CONSTRAINT [FK_PuGeneradores_PuEstimaciones]
GO
ALTER TABLE [dbo].[PuGeneradores]  WITH CHECK ADD  CONSTRAINT [FK_PuGeneradores_PuEstimaciones1] FOREIGN KEY([IdAdicional])
REFERENCES [dbo].[PuEstimaciones] ([IdEstimacion])
GO
ALTER TABLE [dbo].[PuGeneradores] CHECK CONSTRAINT [FK_PuGeneradores_PuEstimaciones1]
GO
ALTER TABLE [dbo].[PuGeneradores]  WITH CHECK ADD  CONSTRAINT [FK_PuGeneradores_PuEstimaciones2] FOREIGN KEY([IdExtraordinaria])
REFERENCES [dbo].[PuEstimaciones] ([IdEstimacion])
GO
ALTER TABLE [dbo].[PuGeneradores] CHECK CONSTRAINT [FK_PuGeneradores_PuEstimaciones2]
GO
ALTER TABLE [dbo].[PuGeneradoresDet]  WITH NOCHECK ADD  CONSTRAINT [FK_PuGeneradoresDet_PuContratosDet] FOREIGN KEY([IdContratoDet])
REFERENCES [dbo].[PuContratosDet] ([IdContratoDet])
GO
ALTER TABLE [dbo].[PuGeneradoresDet] CHECK CONSTRAINT [FK_PuGeneradoresDet_PuContratosDet]
GO
ALTER TABLE [dbo].[PuGeneradoresDet]  WITH NOCHECK ADD  CONSTRAINT [FK_PuGeneradoresDet_PuGeneradores] FOREIGN KEY([IdGenerador])
REFERENCES [dbo].[PuGeneradores] ([IdGenerador])
GO
ALTER TABLE [dbo].[PuGeneradoresDet] CHECK CONSTRAINT [FK_PuGeneradoresDet_PuGeneradores]
GO
ALTER TABLE [dbo].[PuGeneradoresDocumentos]  WITH CHECK ADD  CONSTRAINT [FK_PuGeneradoresDocumentos_PuGeneradores] FOREIGN KEY([IdGenerador])
REFERENCES [dbo].[PuGeneradores] ([IdGenerador])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuGeneradoresDocumentos] CHECK CONSTRAINT [FK_PuGeneradoresDocumentos_PuGeneradores]
GO
ALTER TABLE [dbo].[PuGeneradoresEstatusHistorico]  WITH CHECK ADD  CONSTRAINT [FK_PuGeneradoresEstatusHistorico_PuGeneradores] FOREIGN KEY([idGenerador])
REFERENCES [dbo].[PuGeneradores] ([IdGenerador])
GO
ALTER TABLE [dbo].[PuGeneradoresEstatusHistorico] CHECK CONSTRAINT [FK_PuGeneradoresEstatusHistorico_PuGeneradores]
GO
ALTER TABLE [dbo].[PuGeneradoresEstatusHistorico]  WITH CHECK ADD  CONSTRAINT [FK_PuGeneradoresEstatusHistorico_SegUsuarios] FOREIGN KEY([idUsuario])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuGeneradoresEstatusHistorico] CHECK CONSTRAINT [FK_PuGeneradoresEstatusHistorico_SegUsuarios]
GO
ALTER TABLE [dbo].[PuGeneradoresIC]  WITH CHECK ADD  CONSTRAINT [FK_PuGeneradoresIC_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuGeneradoresIC] CHECK CONSTRAINT [FK_PuGeneradoresIC_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuImagenes]  WITH NOCHECK ADD  CONSTRAINT [FK_PuImagenes_PuFamilias] FOREIGN KEY([IdFamilia])
REFERENCES [dbo].[PuFamilias] ([idFamilia])
GO
ALTER TABLE [dbo].[PuImagenes] CHECK CONSTRAINT [FK_PuImagenes_PuFamilias]
GO
ALTER TABLE [dbo].[PuIndicesDet]  WITH CHECK ADD  CONSTRAINT [FK_PuIndicesDet_PuFamiliasIndices] FOREIGN KEY([IdFamiliaIndice])
REFERENCES [dbo].[PuFamiliasIndices] ([IdFamiliaIndice])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuIndicesDet] CHECK CONSTRAINT [FK_PuIndicesDet_PuFamiliasIndices]
GO
ALTER TABLE [dbo].[PuInteliPres]  WITH CHECK ADD  CONSTRAINT [FK_PuInteliPres_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuInteliPres] CHECK CONSTRAINT [FK_PuInteliPres_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuLigasRuta]  WITH NOCHECK ADD  CONSTRAINT [FK_PuLigasRuta_PuProgramaConceptos] FOREIGN KEY([IdConceptoOrigen])
REFERENCES [dbo].[PuProgramaConceptos] ([IdProgramaConcepto])
GO
ALTER TABLE [dbo].[PuLigasRuta] CHECK CONSTRAINT [FK_PuLigasRuta_PuProgramaConceptos]
GO
ALTER TABLE [dbo].[PuLigasRuta]  WITH CHECK ADD  CONSTRAINT [FK_PuLigasRuta_PuProgramaConceptos1] FOREIGN KEY([IdConceptoDestino])
REFERENCES [dbo].[PuProgramaConceptos] ([IdProgramaConcepto])
GO
ALTER TABLE [dbo].[PuLigasRuta] CHECK CONSTRAINT [FK_PuLigasRuta_PuProgramaConceptos1]
GO
ALTER TABLE [dbo].[PuMatrices]  WITH NOCHECK ADD  CONSTRAINT [FK_PuMatrices_PuCostos] FOREIGN KEY([IdCodigoMatriz])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuMatrices] CHECK CONSTRAINT [FK_PuMatrices_PuCostos]
GO
ALTER TABLE [dbo].[PuMatrices]  WITH NOCHECK ADD  CONSTRAINT [FK_PuMatrices_PuCostos1] FOREIGN KEY([IdCodigoInsumo])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuMatrices] CHECK CONSTRAINT [FK_PuMatrices_PuCostos1]
GO
ALTER TABLE [dbo].[PuMonedasCalculadas]  WITH CHECK ADD  CONSTRAINT [FK_PuMonedasCalculadas_PuMonedas1] FOREIGN KEY([IdMonedaIntegrante])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuMonedasCalculadas] CHECK CONSTRAINT [FK_PuMonedasCalculadas_PuMonedas1]
GO
ALTER TABLE [dbo].[PuMonedasCalculadas]  WITH CHECK ADD  CONSTRAINT [FK_PuMonedasCalculadas_PuMonedas2] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuMonedasCalculadas] CHECK CONSTRAINT [FK_PuMonedasCalculadas_PuMonedas2]
GO
ALTER TABLE [dbo].[PuOrdenesCambio]  WITH CHECK ADD  CONSTRAINT [FK_PuOrdenesCambio_PuContratos] FOREIGN KEY([IdContrato])
REFERENCES [dbo].[PuContratos] ([IdContrato])
GO
ALTER TABLE [dbo].[PuOrdenesCambio] CHECK CONSTRAINT [FK_PuOrdenesCambio_PuContratos]
GO
ALTER TABLE [dbo].[PuOrdenesCambio]  WITH CHECK ADD  CONSTRAINT [FK_PuOrdenesCambio_PuOrdenesCambioTipo] FOREIGN KEY([IdOrdenCambioTipo])
REFERENCES [dbo].[PuOrdenesCambioTipo] ([IdOrdenCambioTipo])
GO
ALTER TABLE [dbo].[PuOrdenesCambio] CHECK CONSTRAINT [FK_PuOrdenesCambio_PuOrdenesCambioTipo]
GO
ALTER TABLE [dbo].[PuOrdenesCambioDet]  WITH NOCHECK ADD  CONSTRAINT [FK_PuOrdenesCambioDet_PuContratosDet] FOREIGN KEY([IdContratoDet])
REFERENCES [dbo].[PuContratosDet] ([IdContratoDet])
GO
ALTER TABLE [dbo].[PuOrdenesCambioDet] CHECK CONSTRAINT [FK_PuOrdenesCambioDet_PuContratosDet]
GO
ALTER TABLE [dbo].[PuOrdenesCambioDet]  WITH CHECK ADD  CONSTRAINT [FK_PuOrdenesCambioDet_PuOrdenesCambio] FOREIGN KEY([IdOrdenCambio])
REFERENCES [dbo].[PuOrdenesCambio] ([IdOrdenCambio])
GO
ALTER TABLE [dbo].[PuOrdenesCambioDet] CHECK CONSTRAINT [FK_PuOrdenesCambioDet_PuOrdenesCambio]
GO
ALTER TABLE [dbo].[PuPorcentajesFinanciamiento]  WITH NOCHECK ADD  CONSTRAINT [FK_PuPorcentajesFinanciamiento_PuProgramas] FOREIGN KEY([IdPrograma])
REFERENCES [dbo].[PuProgramas] ([IdPrograma])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuPorcentajesFinanciamiento] CHECK CONSTRAINT [FK_PuPorcentajesFinanciamiento_PuProgramas]
GO
ALTER TABLE [dbo].[PuPorcentajesFM]  WITH CHECK ADD  CONSTRAINT [FK_PuPorcentajesFM_PuMonedas] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuPorcentajesFM] CHECK CONSTRAINT [FK_PuPorcentajesFM_PuMonedas]
GO
ALTER TABLE [dbo].[PuPorcentajesFM]  WITH CHECK ADD  CONSTRAINT [FK_PuPorcentajesFM_PuPorcentajesFinanciamiento] FOREIGN KEY([IdPorcentajeFinanciamiento])
REFERENCES [dbo].[PuPorcentajesFinanciamiento] ([IdPorcentajeFinanciamiento])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuPorcentajesFM] CHECK CONSTRAINT [FK_PuPorcentajesFM_PuPorcentajesFinanciamiento]
GO
ALTER TABLE [dbo].[PuPresupuestos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuPresupuestos_PuCiudades] FOREIGN KEY([IdCiudad])
REFERENCES [dbo].[PuCiudades] ([IdCiudad])
GO
ALTER TABLE [dbo].[PuPresupuestos] CHECK CONSTRAINT [FK_PuPresupuestos_PuCiudades]
GO
ALTER TABLE [dbo].[PuPresupuestos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuPresupuestos_PuClientes] FOREIGN KEY([IdCliente])
REFERENCES [dbo].[PuClientes] ([IdCliente])
GO
ALTER TABLE [dbo].[PuPresupuestos] CHECK CONSTRAINT [FK_PuPresupuestos_PuClientes]
GO
ALTER TABLE [dbo].[PuPresupuestos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestos_PuClientesContactos] FOREIGN KEY([IdClienteContacto])
REFERENCES [dbo].[PuClientesContactos] ([IdClienteContacto])
GO
ALTER TABLE [dbo].[PuPresupuestos] CHECK CONSTRAINT [FK_PuPresupuestos_PuClientesContactos]
GO
ALTER TABLE [dbo].[PuPresupuestos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestos_PuEmpresas] FOREIGN KEY([IdEmpresa])
REFERENCES [dbo].[PuEmpresas] ([IdEmpresa])
GO
ALTER TABLE [dbo].[PuPresupuestos] CHECK CONSTRAINT [FK_PuPresupuestos_PuEmpresas]
GO
ALTER TABLE [dbo].[PuPresupuestos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuPresupuestos_PuResponsables] FOREIGN KEY([IdResponsable])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuPresupuestos] CHECK CONSTRAINT [FK_PuPresupuestos_PuResponsables]
GO
ALTER TABLE [dbo].[PuPresupuestos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestos_PuTiposLicitacion] FOREIGN KEY([IdTipoLicitacion])
REFERENCES [dbo].[PuTiposLicitacion] ([IdTipoLicitacion])
GO
ALTER TABLE [dbo].[PuPresupuestos] CHECK CONSTRAINT [FK_PuPresupuestos_PuTiposLicitacion]
GO
ALTER TABLE [dbo].[PuPresupuestos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestos_PuVendedores] FOREIGN KEY([IdVendedor])
REFERENCES [dbo].[PuVendedores] ([IdVendedor])
GO
ALTER TABLE [dbo].[PuPresupuestos] CHECK CONSTRAINT [FK_PuPresupuestos_PuVendedores]
GO
ALTER TABLE [dbo].[PuPresupuestos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestos_SegUsuarios] FOREIGN KEY([IdUsuarioCreo])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuPresupuestos] CHECK CONSTRAINT [FK_PuPresupuestos_SegUsuarios]
GO
ALTER TABLE [dbo].[PuPresupuestos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestos_SegUsuarios1] FOREIGN KEY([IdUsuarioBloqueo])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuPresupuestos] CHECK CONSTRAINT [FK_PuPresupuestos_SegUsuarios1]
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosAdjuntos_PuDocumentos] FOREIGN KEY([IdOficio])
REFERENCES [dbo].[PuDocumentos] ([IdDocumento])
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntos] CHECK CONSTRAINT [FK_PuPresupuestosAdjuntos_PuDocumentos]
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosAdjuntos_PuDocumentos1] FOREIGN KEY([IdCostoHorario])
REFERENCES [dbo].[PuDocumentos] ([IdDocumento])
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntos] CHECK CONSTRAINT [FK_PuPresupuestosAdjuntos_PuDocumentos1]
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosAdjuntos_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntos] CHECK CONSTRAINT [FK_PuPresupuestosAdjuntos_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestoAdjuntos_PuDocumentos] FOREIGN KEY([IdFasar])
REFERENCES [dbo].[PuDocumentos] ([IdDocumento])
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas] CHECK CONSTRAINT [FK_PuPresupuestoAdjuntos_PuDocumentos]
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestoAdjuntos_PuDocumentos1] FOREIGN KEY([IdSobreCosto])
REFERENCES [dbo].[PuDocumentos] ([IdDocumento])
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas] CHECK CONSTRAINT [FK_PuPresupuestoAdjuntos_PuDocumentos1]
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestoAdjuntos_PuDocumentos4] FOREIGN KEY([IdPieIndirecto])
REFERENCES [dbo].[PuDocumentos] ([IdDocumento])
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas] CHECK CONSTRAINT [FK_PuPresupuestoAdjuntos_PuDocumentos4]
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestoAdjuntos_PuMonedas] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas] CHECK CONSTRAINT [FK_PuPresupuestoAdjuntos_PuMonedas]
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas]  WITH NOCHECK ADD  CONSTRAINT [FK_PuPresupuestoAdjuntos_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas] CHECK CONSTRAINT [FK_PuPresupuestoAdjuntos_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuPresupuestos_PuCostos] FOREIGN KEY([IdExpIns])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] CHECK CONSTRAINT [FK_PuPresupuestos_PuCostos]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosConceptos_PuCatalogo] FOREIGN KEY([IdAgrupador])
REFERENCES [dbo].[PuCatalogo] ([IdCodigo])
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] CHECK CONSTRAINT [FK_PuPresupuestosConceptos_PuCatalogo]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosConceptos_PuCentros] FOREIGN KEY([IdCentro])
REFERENCES [dbo].[PuCentros] ([IdCentro])
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] CHECK CONSTRAINT [FK_PuPresupuestosConceptos_PuCentros]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosConceptos_PuContratistas] FOREIGN KEY([IdContratista])
REFERENCES [dbo].[PuContratistas] ([IdContratista])
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] CHECK CONSTRAINT [FK_PuPresupuestosConceptos_PuContratistas]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuPresupuestosConceptos_PuEstimacionesTipos] FOREIGN KEY([IdEstimacionTipo])
REFERENCES [dbo].[PuEstimacionesTipos] ([IdEstimacionTipo])
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] CHECK CONSTRAINT [FK_PuPresupuestosConceptos_PuEstimacionesTipos]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuPresupuestosConceptos_PuPartidas] FOREIGN KEY([IdPresupuestoPartida])
REFERENCES [dbo].[PuPresupuestosPartidas] ([IdPresupuestoPartida])
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] CHECK CONSTRAINT [FK_PuPresupuestosConceptos_PuPartidas]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuPresupuestosConceptos_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
GO
ALTER TABLE [dbo].[PuPresupuestosConceptos] CHECK CONSTRAINT [FK_PuPresupuestosConceptos_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptosPrecios]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosConceptosPrecios_PuMonedas] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuPresupuestosConceptosPrecios] CHECK CONSTRAINT [FK_PuPresupuestosConceptosPrecios_PuMonedas]
GO
ALTER TABLE [dbo].[PuPresupuestosConceptosPrecios]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosConceptosPrecios_PuPresupuestosConceptos] FOREIGN KEY([IdPresupuestoConcepto])
REFERENCES [dbo].[PuPresupuestosConceptos] ([IdPresupuestoConcepto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuPresupuestosConceptosPrecios] CHECK CONSTRAINT [FK_PuPresupuestosConceptosPrecios_PuPresupuestosConceptos]
GO
ALTER TABLE [dbo].[PuPresupuestosConsecutivos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuPresupuestosConsecutivos_PuPresupuestos] FOREIGN KEY([idPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
GO
ALTER TABLE [dbo].[PuPresupuestosConsecutivos] CHECK CONSTRAINT [FK_PuPresupuestosConsecutivos_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuPresupuestosMonedas]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosMonedas_PuMonedas] FOREIGN KEY([IdMonedaCalculada])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuPresupuestosMonedas] CHECK CONSTRAINT [FK_PuPresupuestosMonedas_PuMonedas]
GO
ALTER TABLE [dbo].[PuPresupuestosMonedas]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosMonedas_PuMonedas1] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuPresupuestosMonedas] CHECK CONSTRAINT [FK_PuPresupuestosMonedas_PuMonedas1]
GO
ALTER TABLE [dbo].[PuPresupuestosMonedas]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosMonedas_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuPresupuestosMonedas] CHECK CONSTRAINT [FK_PuPresupuestosMonedas_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuPresupuestosOficios]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosOficios_PuOficiosParametros] FOREIGN KEY([IdOficioParametro])
REFERENCES [dbo].[PuOficiosParametros] ([IdOficioParametro])
GO
ALTER TABLE [dbo].[PuPresupuestosOficios] CHECK CONSTRAINT [FK_PuPresupuestosOficios_PuOficiosParametros]
GO
ALTER TABLE [dbo].[PuPresupuestosOficios]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosOficios_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
GO
ALTER TABLE [dbo].[PuPresupuestosOficios] CHECK CONSTRAINT [FK_PuPresupuestosOficios_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuPresupuestosParametros]  WITH NOCHECK ADD  CONSTRAINT [FK_PuPresupuestosParametros_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuPresupuestosParametros] CHECK CONSTRAINT [FK_PuPresupuestosParametros_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidas]  WITH NOCHECK ADD  CONSTRAINT [FK_PuPartidas_PuImagenes] FOREIGN KEY([IdImagen])
REFERENCES [dbo].[PuImagenes] ([IdImagen])
GO
ALTER TABLE [dbo].[PuPresupuestosPartidas] CHECK CONSTRAINT [FK_PuPartidas_PuImagenes]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidas]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosPartidas_PuCentros] FOREIGN KEY([IdCentro])
REFERENCES [dbo].[PuCentros] ([IdCentro])
GO
ALTER TABLE [dbo].[PuPresupuestosPartidas] CHECK CONSTRAINT [FK_PuPresupuestosPartidas_PuCentros]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidas]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosPartidas_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
GO
ALTER TABLE [dbo].[PuPresupuestosPartidas] CHECK CONSTRAINT [FK_PuPresupuestosPartidas_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidas]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosPartidas_PuPresupuestosPartidas] FOREIGN KEY([IdPartidaPadre])
REFERENCES [dbo].[PuPresupuestosPartidas] ([IdPresupuestoPartida])
GO
ALTER TABLE [dbo].[PuPresupuestosPartidas] CHECK CONSTRAINT [FK_PuPresupuestosPartidas_PuPresupuestosPartidas]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidasCostos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosPartidasCostos_PuMonedas] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuPresupuestosPartidasCostos] CHECK CONSTRAINT [FK_PuPresupuestosPartidasCostos_PuMonedas]
GO
ALTER TABLE [dbo].[PuPresupuestosPartidasCostos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosPartidasCostos_PuPresupuestosPartidas] FOREIGN KEY([IdPresupuestoPartida])
REFERENCES [dbo].[PuPresupuestosPartidas] ([IdPresupuestoPartida])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuPresupuestosPartidasCostos] CHECK CONSTRAINT [FK_PuPresupuestosPartidasCostos_PuPresupuestosPartidas]
GO
ALTER TABLE [dbo].[PuPresupuestosPrecios]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosPrecios_PuMonedas] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuPresupuestosPrecios] CHECK CONSTRAINT [FK_PuPresupuestosPrecios_PuMonedas]
GO
ALTER TABLE [dbo].[PuPresupuestosPrecios]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosPrecios_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
GO
ALTER TABLE [dbo].[PuPresupuestosPrecios] CHECK CONSTRAINT [FK_PuPresupuestosPrecios_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuPresupuestosPrestamos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosPrestamos_PuContratistas] FOREIGN KEY([IdContratista])
REFERENCES [dbo].[PuContratistas] ([IdContratista])
GO
ALTER TABLE [dbo].[PuPresupuestosPrestamos] CHECK CONSTRAINT [FK_PuPresupuestosPrestamos_PuContratistas]
GO
ALTER TABLE [dbo].[PuPresupuestosPrestamos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosPrestamos_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
GO
ALTER TABLE [dbo].[PuPresupuestosPrestamos] CHECK CONSTRAINT [FK_PuPresupuestosPrestamos_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuPresupuestosPrestamosDet]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosPrestamosDet_PuEstimaciones] FOREIGN KEY([IdEstimacion])
REFERENCES [dbo].[PuEstimaciones] ([IdEstimacion])
GO
ALTER TABLE [dbo].[PuPresupuestosPrestamosDet] CHECK CONSTRAINT [FK_PuPresupuestosPrestamosDet_PuEstimaciones]
GO
ALTER TABLE [dbo].[PuPresupuestosPrestamosDet]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosPrestamosDet_PuMovimientos] FOREIGN KEY([IdMovimiento])
REFERENCES [dbo].[PuMovimientos] ([IdMovimiento])
GO
ALTER TABLE [dbo].[PuPresupuestosPrestamosDet] CHECK CONSTRAINT [FK_PuPresupuestosPrestamosDet_PuMovimientos]
GO
ALTER TABLE [dbo].[PuPresupuestosPrestamosDet]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosPrestamosDet_PuPresupuestosPrestamos] FOREIGN KEY([IdPresupuestoPrestamo])
REFERENCES [dbo].[PuPresupuestosPrestamos] ([IdPresupuestoPrestamo])
GO
ALTER TABLE [dbo].[PuPresupuestosPrestamosDet] CHECK CONSTRAINT [FK_PuPresupuestosPrestamosDet_PuPresupuestosPrestamos]
GO
ALTER TABLE [dbo].[PuPresupuestosVersion]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosVersion_SegUsuarios] FOREIGN KEY([IdUsuario])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuPresupuestosVersion] CHECK CONSTRAINT [FK_PuPresupuestosVersion_SegUsuarios]
GO
ALTER TABLE [dbo].[PuPresupuestosVersionCostos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosVersionCostos_PuMonedas] FOREIGN KEY([IdMoneda])
REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
ALTER TABLE [dbo].[PuPresupuestosVersionCostos] CHECK CONSTRAINT [FK_PuPresupuestosVersionCostos_PuMonedas]
GO
ALTER TABLE [dbo].[PuPresupuestosVersionCostos]  WITH CHECK ADD  CONSTRAINT [FK_PuPresupuestosVersionCostos_PuPresupuestosVersion] FOREIGN KEY([IdPresupuestoVersion])
REFERENCES [dbo].[PuPresupuestosVersion] ([IdPresupuestoVersion])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuPresupuestosVersionCostos] CHECK CONSTRAINT [FK_PuPresupuestosVersionCostos_PuPresupuestosVersion]
GO
ALTER TABLE [dbo].[PuProgramaConceptos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuProgramaConceptos_PuPresupuestosConceptos1] FOREIGN KEY([IdPresupuestoConcepto])
REFERENCES [dbo].[PuPresupuestosConceptos] ([IdPresupuestoConcepto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuProgramaConceptos] CHECK CONSTRAINT [FK_PuProgramaConceptos_PuPresupuestosConceptos1]
GO
ALTER TABLE [dbo].[PuProgramaConceptos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuProgramaConceptos_PuProgramas1] FOREIGN KEY([IdPrograma])
REFERENCES [dbo].[PuProgramas] ([IdPrograma])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuProgramaConceptos] CHECK CONSTRAINT [FK_PuProgramaConceptos_PuProgramas1]
GO
ALTER TABLE [dbo].[PuProgramaConceptos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuProgramaConceptos_PuResponsables] FOREIGN KEY([IdResponsable])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuProgramaConceptos] CHECK CONSTRAINT [FK_PuProgramaConceptos_PuResponsables]
GO
ALTER TABLE [dbo].[PuProgramaConceptosPeriodos]  WITH NOCHECK ADD  CONSTRAINT [FK_PuProgramaConceptosPeriodos_PuProgramaConceptos] FOREIGN KEY([IdProgramaConcepto])
REFERENCES [dbo].[PuProgramaConceptos] ([IdProgramaConcepto])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuProgramaConceptosPeriodos] CHECK CONSTRAINT [FK_PuProgramaConceptosPeriodos_PuProgramaConceptos]
GO
ALTER TABLE [dbo].[PuProgramaPartidas]  WITH NOCHECK ADD  CONSTRAINT [FK_PuProgramaPartidas_PuPresupuestosPartidas] FOREIGN KEY([IdPresupuestoPartida])
REFERENCES [dbo].[PuPresupuestosPartidas] ([IdPresupuestoPartida])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuProgramaPartidas] CHECK CONSTRAINT [FK_PuProgramaPartidas_PuPresupuestosPartidas]
GO
ALTER TABLE [dbo].[PuProgramaPartidas]  WITH NOCHECK ADD  CONSTRAINT [FK_PuProgramaPartidas_PuProgramas1] FOREIGN KEY([IdPrograma])
REFERENCES [dbo].[PuProgramas] ([IdPrograma])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuProgramaPartidas] CHECK CONSTRAINT [FK_PuProgramaPartidas_PuProgramas1]
GO
ALTER TABLE [dbo].[PuProgramaPartidas]  WITH NOCHECK ADD  CONSTRAINT [FK_PuProgramaPartidas_PuResponsables] FOREIGN KEY([IdResponsable])
REFERENCES [dbo].[PuResponsables] ([IdResponsable])
GO
ALTER TABLE [dbo].[PuProgramaPartidas] CHECK CONSTRAINT [FK_PuProgramaPartidas_PuResponsables]
GO
ALTER TABLE [dbo].[PuProgramas]  WITH CHECK ADD  CONSTRAINT [FK_PuProgramas_PuCalendarios] FOREIGN KEY([IdCalendario])
REFERENCES [dbo].[PuCalendarios] ([IdCalendario])
GO
ALTER TABLE [dbo].[PuProgramas] CHECK CONSTRAINT [FK_PuProgramas_PuCalendarios]
GO
ALTER TABLE [dbo].[PuProgramas]  WITH CHECK ADD  CONSTRAINT [FK_PuProgramas_PuPresupuestos] FOREIGN KEY([IdPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
GO
ALTER TABLE [dbo].[PuProgramas] CHECK CONSTRAINT [FK_PuProgramas_PuPresupuestos]
GO
ALTER TABLE [dbo].[PuProgramasTipos]  WITH CHECK ADD  CONSTRAINT [FK_PuProgramasTipos_PuProgramas] FOREIGN KEY([IdPrograma])
REFERENCES [dbo].[PuProgramas] ([IdPrograma])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuProgramasTipos] CHECK CONSTRAINT [FK_PuProgramasTipos_PuProgramas]
GO
ALTER TABLE [dbo].[PuProgramasTipos]  WITH CHECK ADD  CONSTRAINT [FK_PuProgramasTipos_PuTipoInsumos] FOREIGN KEY([IdTipo])
REFERENCES [dbo].[PuTipoInsumos] ([IdTipo])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuProgramasTipos] CHECK CONSTRAINT [FK_PuProgramasTipos_PuTipoInsumos]
GO
ALTER TABLE [dbo].[PuProgramaSum]  WITH NOCHECK ADD  CONSTRAINT [FK_PuProgramaSumXCon_PuExpIns] FOREIGN KEY([IdExpIns])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuProgramaSum] CHECK CONSTRAINT [FK_PuProgramaSumXCon_PuExpIns]
GO
ALTER TABLE [dbo].[PuProgramaSum]  WITH NOCHECK ADD  CONSTRAINT [FK_PuProgramaSumXCon_PuProgramas] FOREIGN KEY([IdPrograma])
REFERENCES [dbo].[PuProgramas] ([IdPrograma])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuProgramaSum] CHECK CONSTRAINT [FK_PuProgramaSumXCon_PuProgramas]
GO
ALTER TABLE [dbo].[PuProgramaSumXPar]  WITH NOCHECK ADD  CONSTRAINT [FK_PuProgramaSumXPar_PuExpIns] FOREIGN KEY([IdExpIns])
REFERENCES [dbo].[PuExpIns] ([IdExpIns])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuProgramaSumXPar] CHECK CONSTRAINT [FK_PuProgramaSumXPar_PuExpIns]
GO
ALTER TABLE [dbo].[PuProgramaSumXPar]  WITH NOCHECK ADD  CONSTRAINT [FK_PuProgramaSumXPar_PuProgramaPartidas] FOREIGN KEY([IdProgramaPartida])
REFERENCES [dbo].[PuProgramaPartidas] ([IdProgramaPartida])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[PuProgramaSumXPar] CHECK CONSTRAINT [FK_PuProgramaSumXPar_PuProgramaPartidas]
GO
ALTER TABLE [dbo].[PuProveedores]  WITH NOCHECK ADD  CONSTRAINT [FK_PuProveedores_PuCiudades] FOREIGN KEY([idCiudad])
REFERENCES [dbo].[PuCiudades] ([IdCiudad])
GO
ALTER TABLE [dbo].[PuProveedores] CHECK CONSTRAINT [FK_PuProveedores_PuCiudades]
GO
ALTER TABLE [dbo].[PuRepHojas]  WITH CHECK ADD  CONSTRAINT [FK_PuReportesHojasXls_PuReportesXls] FOREIGN KEY([IdRepLibro])
REFERENCES [dbo].[PuRepLibros] ([IdRepLibro])
GO
ALTER TABLE [dbo].[PuRepHojas] CHECK CONSTRAINT [FK_PuReportesHojasXls_PuReportesXls]
GO
ALTER TABLE [dbo].[PuRepLibros]  WITH NOCHECK ADD  CONSTRAINT [FK_PuReportesXls_PuRepCarpetas] FOREIGN KEY([IdRepCarpeta])
REFERENCES [dbo].[PuRepCarpetas] ([IdRepCarpeta])
GO
ALTER TABLE [dbo].[PuRepLibros] CHECK CONSTRAINT [FK_PuReportesXls_PuRepCarpetas]
GO
ALTER TABLE [dbo].[PuRepOpciones]  WITH CHECK ADD  CONSTRAINT [FK_PuRepOpciones_PuReportesHojasXls] FOREIGN KEY([IdRepHoja])
REFERENCES [dbo].[PuRepHojas] ([IdRepHoja])
GO
ALTER TABLE [dbo].[PuRepOpciones] CHECK CONSTRAINT [FK_PuRepOpciones_PuReportesHojasXls]
GO
ALTER TABLE [dbo].[PuRepOpciones]  WITH CHECK ADD  CONSTRAINT [FK_PuRepOpciones_PuRepParametros] FOREIGN KEY([IdParametro])
REFERENCES [dbo].[PuRepParametros] ([IdParametro])
GO
ALTER TABLE [dbo].[PuRepOpciones] CHECK CONSTRAINT [FK_PuRepOpciones_PuRepParametros]
GO
ALTER TABLE [dbo].[PuRepOpciones]  WITH CHECK ADD  CONSTRAINT [FK_PuRepOpciones_SegUsuarios] FOREIGN KEY([IdUsuario])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[PuRepOpciones] CHECK CONSTRAINT [FK_PuRepOpciones_SegUsuarios]
GO
ALTER TABLE [dbo].[PuUnidadesAcad]  WITH CHECK ADD  CONSTRAINT [FK_PuUnidadesAcad_PuReferenciaAcad] FOREIGN KEY([IdReferenciaAcad])
REFERENCES [dbo].[PuReferenciaAcad] ([IdReferenciaAcad])
GO
ALTER TABLE [dbo].[PuUnidadesAcad] CHECK CONSTRAINT [FK_PuUnidadesAcad_PuReferenciaAcad]
GO
ALTER TABLE [dbo].[SegGrupoPermisos]  WITH CHECK ADD  CONSTRAINT [FK_SegGrupoPermisos_SegSistemas] FOREIGN KEY([IdSistema])
REFERENCES [dbo].[SegSistemas] ([IdSistema])
GO
ALTER TABLE [dbo].[SegGrupoPermisos] CHECK CONSTRAINT [FK_SegGrupoPermisos_SegSistemas]
GO
ALTER TABLE [dbo].[SegPerfil]  WITH CHECK ADD  CONSTRAINT [FK_SegPerfil_SegSistemas] FOREIGN KEY([IdSistema])
REFERENCES [dbo].[SegSistemas] ([IdSistema])
GO
ALTER TABLE [dbo].[SegPerfil] CHECK CONSTRAINT [FK_SegPerfil_SegSistemas]
GO
ALTER TABLE [dbo].[SegPermisos]  WITH CHECK ADD  CONSTRAINT [FK_SegPermisos_SegGrupoPermisos] FOREIGN KEY([IdGrupoPermiso])
REFERENCES [dbo].[SegGrupoPermisos] ([IdGrupoPermiso])
GO
ALTER TABLE [dbo].[SegPermisos] CHECK CONSTRAINT [FK_SegPermisos_SegGrupoPermisos]
GO
ALTER TABLE [dbo].[SegPermisos]  WITH CHECK ADD  CONSTRAINT [FK_SegPermisos_SegSistemas] FOREIGN KEY([IdSistema])
REFERENCES [dbo].[SegSistemas] ([IdSistema])
GO
ALTER TABLE [dbo].[SegPermisos] CHECK CONSTRAINT [FK_SegPermisos_SegSistemas]
GO
ALTER TABLE [dbo].[SegUsuariosSistemas]  WITH CHECK ADD  CONSTRAINT [FK_SegUsuariosSistemas_SegPerfil] FOREIGN KEY([IdPerfil])
REFERENCES [dbo].[SegPerfil] ([IdPerfil])
GO
ALTER TABLE [dbo].[SegUsuariosSistemas] CHECK CONSTRAINT [FK_SegUsuariosSistemas_SegPerfil]
GO
ALTER TABLE [dbo].[SegUsuariosSistemas]  WITH CHECK ADD  CONSTRAINT [FK_SegUsuariosSistemas_SegSistemas] FOREIGN KEY([IdSistema])
REFERENCES [dbo].[SegSistemas] ([IdSistema])
GO
ALTER TABLE [dbo].[SegUsuariosSistemas] CHECK CONSTRAINT [FK_SegUsuariosSistemas_SegSistemas]
GO
ALTER TABLE [dbo].[SegUsuariosSistemas]  WITH CHECK ADD  CONSTRAINT [FK_SegUsuariosSistemas_SegUsuarios] FOREIGN KEY([IdUsuario])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[SegUsuariosSistemas] CHECK CONSTRAINT [FK_SegUsuariosSistemas_SegUsuarios]
GO
ALTER TABLE [dbo].[SegUsuariosXProyecto]  WITH CHECK ADD  CONSTRAINT [FK_SegUsuariosXProyecto_PuPresupuestos] FOREIGN KEY([idPresupuesto])
REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
GO
ALTER TABLE [dbo].[SegUsuariosXProyecto] CHECK CONSTRAINT [FK_SegUsuariosXProyecto_PuPresupuestos]
GO
ALTER TABLE [dbo].[SegUsuariosXProyecto]  WITH CHECK ADD  CONSTRAINT [FK_SegUsuariosXProyecto_SegSistemas] FOREIGN KEY([idSistema])
REFERENCES [dbo].[SegSistemas] ([IdSistema])
GO
ALTER TABLE [dbo].[SegUsuariosXProyecto] CHECK CONSTRAINT [FK_SegUsuariosXProyecto_SegSistemas]
GO
ALTER TABLE [dbo].[SegUsuariosXProyecto]  WITH CHECK ADD  CONSTRAINT [FK_SegUsuariosXProyecto_SegUsuarios] FOREIGN KEY([idUsuario])
REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
ALTER TABLE [dbo].[SegUsuariosXProyecto] CHECK CONSTRAINT [FK_SegUsuariosXProyecto_SegUsuarios]
GO
/****** Object:  StoredProcedure [dbo].[NeoBitacoraCostos_GrabaBitacora]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Jose luis colín
-- Create date: 02-Agosto-2009
-- Description:	Graba en la bitacora de costos
-- =============================================
CREATE PROCEDURE [dbo].[NeoBitacoraCostos_GrabaBitacora]
@IdExpIns Int,
@IdMoneda Int,
@IdUsuario Int,
@Costo AS Decimal(18, 6)
AS
BEGIN
DECLARE @CostoActual Decimal(18, 6),
@IdExpInsCostos Int,
@Id Int,
@Bit Bit,
@Error VarChar(200),
@ErrorSeverity Int,
@ErrorState Int
--BEGIN TRAN
BEGIN TRY
IF NOT EXISTS(SELECT idUsuario FROM SegUsuariosXProyecto) AND NOT EXISTS(SELECT IdExpInsCostoBitacora FROM PuExpInsCostosBitacora) BEGIN RETURN END
IF @IdExpIns <= 0
BEGIN
RAISERROR('El valor de IdExpIns debe ser mayor a cero.', 16, 1)
RETURN
END
--Revisa que no sea porcentaje
SELECT @Id = C.EsPorcentaje
FROM PuCatalogo C INNER JOIN
PuExpIns E ON E.IdCodigo = C.IdCodigo
WHERE E.IdExpIns = @IdExpIns
If @Id > 0 RETURN
--Revisa que no tenga matriz
SELECT @Bit = COALESCE(E.EsCostoHorario,0), @Id = M.IdCodigoMatriz
FROM PuExpIns E LEFT JOIN
PuMatrices M ON E.IdExpIns = M.IdCodigoMatriz
WHERE E.IdExpIns = @IdExpIns
If @Id > 0 RETURN
If @Bit > 0 RETURN
--Revisa que no participe como CH
SELECT @Id = COUNT(IdExpIns)
FROM PuCostosHorarios
WHERE IdExpInsCF = @IdExpIns OR IdExpinsE = @IdExpIns OR IdExpinsR = @IdExpIns
If @Id > 0 RETURN
--Busca el IdExpInsCostos
SELECT @IdExpInsCostos = COALESCE(IdExpInsCosto,0)
FROM PuExpInsCostos
WHERE IdExpIns = @IdExpIns AND IdMoneda = @IdMoneda
INSERT INTO PuExpInsCostosBitacora ( IdExpInsCosto, Fecha, IdUsuario, Costo )
VALUES ( @IdExpInsCostos, GETDATE(), @IdUsuario, @Costo )
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al insertar el costo del insumo en la bitacora. No se afectaron registros.', 16, 1)
RETURN
END
--COMMIT TRAN
END TRY
BEGIN CATCH
--	ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCalculo_ActualizaProgSumId]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			Abel Davalos
-- Create date: 07-Octubre-2009
-- Description:	Actualiza en PuProgramaSum por Id Primario
-- =============================================
CREATE PROCEDURE [dbo].[NeoCalculo_ActualizaProgSumId]
@IdProgramaSum int,
@Cantidad Decimal(18,8)
AS
Begin
DECLARE @RegistrosAfectados Int
Begin
UPDATE PuProgramaSum SET Cantidad=@Cantidad WHERE IdProgramaSum=@IdProgramaSum
SET @RegistrosAfectados = @@ROWCOUNT
End
RETURN @RegistrosAfectados
End
GO
/****** Object:  StoredProcedure [dbo].[NeoCalculo_ActualizaProgSumParId]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			Abel Davalos
-- Create date: 07-Octubre-2009
-- Description:	Actualiza en PuProgramaSumXPar por Id Primario
-- =============================================
create PROCEDURE [dbo].[NeoCalculo_ActualizaProgSumParId]
@IdProgramaSumXPar int,
@Cantidad Decimal(18,8)
AS
Begin
DECLARE @RegistrosAfectados Int
Begin
UPDATE PuProgramaSumXPar SET Cantidad=@Cantidad WHERE IdProgramaSumXPar=@IdProgramaSumXPar
SET @RegistrosAfectados = @@ROWCOUNT
End
RETURN @RegistrosAfectados
End
GO
/****** Object:  StoredProcedure [dbo].[NeoCalculo_ExpinsPar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			Abel Davalos
-- Create date: 28-Septiembre-2009
-- Description:	Graba/Actualiza en ExpinsPar
-- =============================================
CREATE PROCEDURE [dbo].[NeoCalculo_ExpinsPar]
@IdExpinsPar int,
@IdPresupuestoPartida Int,
@IdExpins Int,
@Expins Decimal(18,8)
AS
IF @Idexpinspar = 0
Begin
INSERT INTO PuExpInsPar (Expins,IdPresupuestoPartida,IdExpins) VALUES (@Expins, @IdPresupuestoPartida, @IdExpins)
RETURN @@ROWCOUNT
End
ELSE
Begin
UPDATE PuExpinsPar SET Expins=@Expins WHERE Idexpinspar=@Idexpinspar
RETURN @@ROWCOUNT
End
GO
/****** Object:  StoredProcedure [dbo].[NeoCalculo_ProgramaSum]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			Abel Davalos
-- Create date: 07-Octubre-2009
-- Description:	Actualiza en PuProgramaSum
-- =============================================
CREATE PROCEDURE [dbo].[NeoCalculo_ProgramaSum]
@IdPrograma int,
@IdExpins Int,
@NoPeriodo SmallInt,
@Cantidad Decimal(18,8)
AS
Begin
DECLARE @RegistrosAfectados Int
Begin
UPDATE PuProgramaSum SET Cantidad=@Cantidad WHERE IdPrograma=@IdPrograma AND IdExpins=@IdExpins AND NoPeriodo=@NoPeriodo
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
Begin
INSERT INTO PuProgramaSum (IdPrograma,IdExpins,NoPeriodo,Cantidad) VALUES (@IdPrograma,@IdExpins,@NoPeriodo,@Cantidad)
SET @RegistrosAfectados = @@ROWCOUNT
End
End
RETURN @RegistrosAfectados
End
GO
/****** Object:  StoredProcedure [dbo].[NeoCalculo_ProgramaSumPar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			Abel Davalos
-- Create date: 07-Octubre-2009
-- Description:	Actualiza en PuProgramaSum
-- =============================================
CREATE PROCEDURE [dbo].[NeoCalculo_ProgramaSumPar]
@IdProgramaPartida int,
@IdExpins Int,
@NoPeriodo SmallInt,
@Cantidad Decimal(18,8)
AS
Begin
DECLARE @RegistrosAfectados Int
Begin
UPDATE PuProgramaSumXPar SET Cantidad=@Cantidad
WHERE IdProgramaPartida=@IdProgramaPartida AND IdExpins=@IdExpins AND NoPeriodo=@NoPeriodo
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
Begin
INSERT INTO PuProgramaSumXPar (IdProgramaPartida,IdExpins,NoPeriodo,Cantidad)
VALUES (@IdProgramaPartida,@IdExpins,@NoPeriodo,@Cantidad)
SET @RegistrosAfectados = @@ROWCOUNT
End
End
RETURN @RegistrosAfectados
End
GO
/****** Object:  StoredProcedure [dbo].[NeoCatCalendarioEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:		José Luis Colín
---- Create date:	15-Agosto-2009
---- Description:	Elimina un calendario
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatCalendarioEliminar]
@IdCalendario Int
AS
BEGIN
DELETE FROM PuCalendarios WHERE IdCalendario = @IdCalendario
RETURN @@ROWCOUNT
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatCalendarioGarabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 02-Julio-2009
---- Description:	Graba y Actualiza el Catálogo de Calendarios
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatCalendarioGarabarActualizar]
@IdCalendario Int OutPut,
@Calendario Varchar(20),
@Descripcion Varchar(40),
@Lunes Bit,
@Martes Bit,
@Miercoles Bit,
@Jueves	Bit,
@Viernes Bit,
@Sabado Bit,
@Domingo Bit,
@Predeterminado Bit
AS
BEGIN
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @IdCalendario = 0
BEGIN
INSERT INTO PuCalendarios ( Calendario, Descripcion, Lunes, Martes, Miercoles, Jueves, Viernes, Sabado, Domingo, Predeterminado )
VALUES ( @Calendario, @Descripcion, @Lunes, @Martes, @Miercoles, @Jueves, @Viernes, @Sabado, @Domingo, @Predeterminado )
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al Insertar el calendario. No se afectaron registros.', 16, 1)
RETURN
END
SET  @IdCalendario = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuCalendarios
SET Calendario = @Calendario, Descripcion = @Descripcion, Lunes = @Lunes, Martes = @Martes,
Miercoles = @Miercoles, Jueves = @Jueves, Viernes = @Viernes, Sabado = @Sabado, Domingo = @Domingo,
Predeterminado = @Predeterminado
WHERE IdCalendario = @IdCalendario
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al actualizar el calendario. No se afectaron registros.', 16, 1)
RETURN
END
END
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatCalendariosControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 22-Julio-2009
---- Description:	Control de 3 puntos del catálogo de calendarios
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatCalendariosControl3Puntos]
@IdCalendario Int,
@Calendario Varchar(20)
AS
IF  @IdCalendario = 0 AND @Calendario IS NULL
SELECT C.IdCalendario, C.Calendario, C.Descripcion, C.Lunes, C.Martes, C.Miercoles,
C.Jueves, C.Viernes, C.Sabado, C.Domingo, C.Predeterminado
FROM PuCalendarios AS C
ORDER BY C.Calendario
ELSE IF  @IdCalendario = 0 AND @Calendario IS NOT NULL
SELECT C.IdCalendario, C.Calendario, C.Descripcion, C.Lunes, C.Martes, C.Miercoles,
C.Jueves, C.Viernes, C.Sabado, C.Domingo, C.Predeterminado
FROM PuCalendarios AS C
WHERE C.Calendario = @Calendario
ELSE IF @IdCalendario > 0 and @Calendario IS NULL
SELECT C.IdCalendario, C.Calendario, C.Descripcion, C.Lunes, C.Martes, C.Miercoles,
C.Jueves, C.Viernes, C.Sabado, C.Domingo, C.Predeterminado
FROM PuCalendarios AS C
WHERE C.IdCalendario=@IdCalendario
GO
/****** Object:  StoredProcedure [dbo].[NeoCatCiudadesCargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatCiudadesCargaDatos]
AS
SELECT C.IdCiudad, C.Ciudad, C.Descripcion, E.Estado
FROM PuCiudades C INNER JOIN
PuEstados E ON C.IdEstado = E.IdEstado
ORDER BY C.Ciudad
GO
/****** Object:  StoredProcedure [dbo].[NeoCatCiudadesControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:                 José Luis Colín
---- Create date: 22-Julio-2009
---- Description: Control de 3 puntos del catálogo de ciudades
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatCiudadesControl3Puntos]
@Ciudad varchar(20),
@IdCiudad int
AS
IF  @Ciudad IS NULL AND @IdCiudad = 0
SELECT C.IdCiudad,C.Ciudad,C.Descripcion, E.Estado, E.Nombre
FROM PuCiudades as C INNER JOIN
PuEstados as E ON E.IdEstado = C.IdEstado
ORDER BY C.Ciudad
ELSE IF @IdCiudad = 0 AND @Ciudad IS NOT NULL
SELECT C.IdCiudad,C.Ciudad,C.Descripcion, E.Estado, E.Nombre
FROM PuCiudades as C INNER JOIN
PuEstados as E ON E.IdEstado = C.IdEstado
WHERE C.Ciudad = @Ciudad
ELSE IF @IdCiudad > 0 AND @Ciudad IS NULL
SELECT C.IdCiudad,C.Ciudad,C.Descripcion, E.Estado, E.Nombre
FROM PuCiudades as C INNER JOIN
PuEstados as E ON E.IdEstado = C.IdEstado
WHERE IdCiudad = @IdCiudad
GO
/****** Object:  StoredProcedure [dbo].[NeoCatCiudadesEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatCiudadesEliminar]
@IdCiudad int
AS
DELETE FROM PuCiudades WHERE IdCiudad = @IdCiudad
GO
/****** Object:  StoredProcedure [dbo].[NeoCatCiudadesGrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 02-Julio-2009
---- Description:	Graba y Actualiza el Catálogo de Ciudades
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatCiudadesGrabarActualizar]
@IdCiudad Int Output,
@Ciudad Varchar(20),
@Descripcion varchar(40),
@IdEstado Int
AS
BEGIN
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @IdCiudad = 0
BEGIN
INSERT INTO PuCiudades (Ciudad, Descripcion, IdEstado)
VALUES (@Ciudad, @Descripcion, @IdEstado)
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al Insertar la ciudad. No se afectaron registros.', 16, 1)
RETURN
END
SET  @IdCiudad = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuCiudades
SET Ciudad = @Ciudad, Descripcion = @Descripcion, IdEstado = @IdEstado
WHERE IdCiudad = @IdCiudad
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al actualizar la ciudad. No se afectaron registros.', 16, 1)
RETURN
END
END
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatClienteControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatClienteControl3Puntos]
@Cliente varchar(20),
@IdCliente int
AS
IF  @Cliente IS NULL AND @IdCliente = 0
SELECT IdCliente,Cliente,Nombre,Direccion FROM PuClientes ORDER BY Cliente
ELSE IF @IdCliente = 0 and @Cliente is not null
SELECT IdCliente,Cliente,Nombre,Direccion FROM PuClientes WHERE Cliente = @Cliente
ELSE IF @IdCliente > 0 and @Cliente is null
SELECT IdCliente,Cliente,Nombre,Direccion FROM PuClientes WHERE IdCliente = @IdCliente
GO
/****** Object:  StoredProcedure [dbo].[NeoCatClienteEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatClienteEliminar]
@IdCliente int
AS
DELETE FROM PuClientes where IdCliente = @IdCliente
GO
/****** Object:  StoredProcedure [dbo].[NeoCatContratistasCargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatContratistasCargaDatos]
@IdContratista as int
AS
SELECT IdContratista,Contratista,IdMoneda,RazonSocial,Observaciones,
IdCiudad,Delegacion,Direccion,Colonia,CodigoPostal,Telefono,Fax,Mail,
Especialidad,NumEscritura,FechaEscritura,Notario,CiudadNotario,
CiudadRegistroNotario,FolioRegistroNotario,DomicilioNotario,
RepresentanteLegal,EscrituraRepresentante,FechaEscrituraRepresentante,
NotarioRepresentante,NumeroNotaria FROM PuContratistas
WHERE IdContratista = @IdContratista
GO
/****** Object:  StoredProcedure [dbo].[NeoCatContratistasInsertaActualiza]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatContratistasInsertaActualiza]
@IdContratista as int output,
@Contratista as varchar(20),
@IdMoneda as int,
@RazonSocial  as varchar(120),
@Observaciones as varchar(255),
@IdCiudad as int,
@Delegacion as varchar(30),
@Direccion as varchar(80),
@Colonia as varchar(30),
@Telefono as varchar(30),
@Fax as varchar(30),
@Mail as varchar(100),
@CodigoPostal as varchar(6),
@Especialidad as varchar(100),
@NumEscritura as varchar(20),
@FechaEscritura as datetime,
@Notario as varchar(80),
@CiudadNotario as varchar(80),
@CiudadRegistroNotario as varchar(80),
@FolioRegistroNotario as varchar(20),
@DomicilioNotario as varchar(120),
@RepresentanteLegal as varchar(80),
@EscrituraRepresentante as varchar(20),
@FechaEscrituraRepresentante as datetime,
@NotarioRepresentante as varchar(80),
@NumeroNotaria as varchar(10)
AS
IF @IdContratista = 0
BEGIN
INSERT INTO PuContratistas (Contratista,IdMoneda,RazonSocial,
Observaciones,IdCiudad,Delegacion,Direccion,Colonia,CodigoPostal,
Telefono,Fax,Mail,Especialidad,NumEscritura,FechaEscritura,Notario,
CiudadNotario,FolioRegistroNotario,DomicilioNotario,RepresentanteLegal,
EscrituraRepresentante,FechaEscrituraRepresentante,NotarioRepresentante,
NumeroNotaria)
VALUES (@Contratista,@IdMoneda,@RazonSocial,@Observaciones,
@IdCiudad,@Delegacion,@Direccion,@Colonia,@CodigoPostal,
@Telefono,@Fax,@Mail,@Especialidad,@NumEscritura,@FechaEscritura,
@Notario,@CiudadNotario,@FolioRegistroNotario,@DomicilioNotario,
@RepresentanteLegal,@EscrituraRepresentante,@FechaEscrituraRepresentante,
@NotarioRepresentante,@NumeroNotaria)
SET @IdContratista = @@IDENTITY
END
ELSE
UPDATE PuContratistas SET Contratista = @Contratista, IdMoneda = @IdMoneda,
RazonSocial = @RazonSocial, Observaciones = @Observaciones
,IdCiudad = @IdCiudad, Delegacion = @Delegacion, Direccion = @Direccion,
Colonia = @Colonia, CodigoPostal = @CodigoPostal
,Telefono = @Telefono, Fax = @Fax, Mail = @Mail,Especialidad = @Especialidad,
NumEscritura = @NumEscritura,FechaEscritura = @FechaEscritura,Notario=@Notario,
CiudadNotario = @CiudadNotario,FolioRegistroNotario = @FolioRegistroNotario,
DomicilioNotario= @DomicilioNotario,RepresentanteLegal = @RepresentanteLegal,
EscrituraRepresentante= @EscrituraRepresentante,FechaEscrituraRepresentante =
@FechaEscrituraRepresentante,NotarioRepresentante=@NotarioRepresentante,
NumeroNotaria=@NumeroNotaria
Where IdContratista = @IdContratista
GO
/****** Object:  StoredProcedure [dbo].[NeoCatContratistasObtieneContratista]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatContratistasObtieneContratista]
@Contratista as varchar(20)
AS
SELECT IdContratista,Contratista,IdMoneda,RazonSocial,
Observaciones,IdCiudad,Delegacion,Direccion,Colonia,
CodigoPostal,Telefono,Fax,Mail
FROM PuContratistas
WHERE Contratista = @Contratista
GO
/****** Object:  StoredProcedure [dbo].[NeoCatContratosControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatContratosControl3Puntos]
@FolioContrato int,
@IdContrato int,
@IdPresupuesto int,
@IdContratante int,
@TipoBusqueda int
AS
--si quiero todos los contratos sin filtrar por presupuesto
IF  @TipoBusqueda = 1
SELECT PUC.IdContrato,PUC.FolioContrato,PUC.Descripcion,PUCon.Contratista as Contratante,PuCon1.Contratista, puc.Autorizado,PUC.Cancelado FROM PuContratos PUC INNER JOIN
PuContratistas PUCon ON PUC.IdContratante = PUCon.idContratista INNER JOIN PuContratistas PUCon1 ON PUC.idContratista = PUCon1.IdContratista
ORDER BY PUC.FolioContrato
--si quiero todos los contratos de un presupuesto y contratante
ELSE IF @TipoBusqueda = 2
SELECT PUC.IdContrato,PUC.FolioContrato,PUC.Descripcion,PUCon.Contratista as Contratante,PuCon1.Contratista, puc.Autorizado,PUC.Cancelado FROM PuContratos PUC INNER JOIN
PuContratistas PUCon ON PUC.IdContratante = PUCon.idContratista INNER JOIN PuContratistas PUCon1 ON PUC.idContratista = PUCon1.IdContratista
WHERE IdPresupuesto = @IdPresupuesto and IdContratante = @IdContratante
--si quiero un contrato específicamente buscando por folio
ELSE IF  @TipoBusqueda = 3
SELECT PUC.IdContrato,PUC.FolioContrato,PUC.Descripcion,PUCon.Contratista as Contratante,PuCon1.Contratista, puc.Autorizado,PUC.Cancelado FROM PuContratos PUC INNER JOIN
PuContratistas PUCon ON PUC.IdContratante = PUCon.idContratista INNER JOIN PuContratistas PUCon1 ON PUC.idContratista = PUCon1.IdContratista
WHERE PUC.FolioContrato = @FolioContrato
--si quiero un contrato específicamente buscando por id
ELSE IF @TipoBusqueda = 4
SELECT PUC.IdContrato,PUC.FolioContrato,PUC.Descripcion,PUCon.Contratista as Contratante,PuCon1.Contratista, puc.Autorizado,PUC.Cancelado FROM PuContratos PUC INNER JOIN
PuContratistas PUCon ON PUC.IdContratante = PUCon.idContratista INNER JOIN PuContratistas PUCon1 ON PUC.idContratista = PUCon1.IdContratista
WHERE PUC.IdContrato = @IdContrato
--si quiero los contratos por presupuesto
IF  @TipoBusqueda = 5
SELECT PUC.IdContrato,PUC.FolioContrato,PUC.Descripcion,PUCon.Contratista as Contratante,PuCon1.Contratista, puc.Autorizado,PUC.Cancelado FROM PuContratos PUC INNER JOIN
PuContratistas PUCon ON PUC.IdContratante = PUCon.idContratista INNER JOIN PuContratistas PUCon1 ON PUC.idContratista = PUCon1.IdContratista
WHERE PuC.IdPresupuesto = @IdPresupuesto
ORDER BY PUC.FolioContrato
GO
/****** Object:  StoredProcedure [dbo].[NeoCatDocumentosControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:              José Luis Colín
-- Create date: 13-Junio-2009
-- Description:   Muestra el Catálogo de Documentos con diferentes Filtros
-- =============================================
--MuestraTodo = 1
--Sobrecosto = 2
--Fasar = 3
--CostosHorarios = 4
--Oficios = 5
--PieIndirectos = 6
--FacturaEstimaciones = 7
--PlantillasContratos = 8
CREATE PROCEDURE [dbo].[NeoCatDocumentosControl3Puntos]
@Documento Varchar(80),
@IdDocumento Int,
@TipoDocumento Int
AS
DECLARE @NombreTipo Varchar(100),
@Sql NVarchar(1000)
IF @TipoDocumento = 2 SET @NombreTipo = 'Sobrecosto'
IF @TipoDocumento = 3 SET @NombreTipo = 'Fasar'
IF @TipoDocumento = 4 SET @NombreTipo = 'Costos horarios'
IF @TipoDocumento = 5 SET @NombreTipo = 'Oficios'
IF @TipoDocumento = 6 SET @NombreTipo = 'Pie de indirectos'
IF @TipoDocumento = 7 SET @NombreTipo = 'Factura de estimaciones'
IF @TipoDocumento = 8 SET @NombreTipo = 'Plantillas contratos'
IF @Documento IS NULL AND @IdDocumento = 0
BEGIN
SET @Sql = 'SELECT D.IdDocumento, D.Documento, D.ObjDocumento, D.Neodata, T.TipoDocumento, T.Word, D.Version, D.Extension
FROM PuDocumentos AS D INNER JOIN
PuTiposDocumentos AS T ON T.IdTipoDocumento = D.IdTipoDocumento '
IF @TipoDocumento > 1 SET @Sql += ' WHERE T.TipoDocumento = ''' + CAST(@NombreTipo AS VarChar(40)) + ''''
SET @Sql += ' ORDER BY D.Documento'
END
ELSE IF  @IdDocumento = 0  and @Documento IS NOT NULL
SET @Sql = ' SELECT D.IdDocumento, D.Documento, D.ObjDocumento, D.Neodata, T.TipoDocumento, T.Word, D.Version, D.Extension
FROM PuDocumentos AS D INNER JOIN
PuTiposDocumentos AS T ON T.IdTipoDocumento = D.IdTipoDocumento
WHERE D.Documento = ''' + CAST(@Documento AS VarChar(80)) + ''''
ELSE IF   @IdDocumento > 0  AND @Documento IS NULL
SET @Sql = ' SELECT D.IdDocumento, D.Documento,  D.ObjDocumento, D.Neodata, T.TipoDocumento, T.Word, D.Version, D.Extension
FROM PuDocumentos AS D INNER JOIN
PuTiposDocumentos AS T ON T.IdTipoDocumento = D.IdTipoDocumento
WHERE D.IdDocumento = ' + CAST(@IdDocumento AS VARCHAR(10))
EXEC sp_executesql @Sql
GO
/****** Object:  StoredProcedure [dbo].[NeoCatDocumentosEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			Jose Luis Colín Ramírez
-- Create date: 24-Agosto-2009
-- Description:	Elimina del Catalogo de Documentos
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatDocumentosEliminar]
@IdDocumento Int
AS
BEGIN
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRY
DELETE FROM PuDocumentos WHERE IdDocumento = @IdDocumento
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al eliminar la empresa. No se afectaron registros.', 16, 1)
RETURN
END
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatDocumentosGrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:                 José Luis Colín
---- Create date: 24-Junio-2009
---- Description: Graba y Actualiza el catálogo de documentos
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatDocumentosGrabarActualizar]
@IdDocumento Int OutPut,
@ObjDocumento Varbinary(MAX),
@Documento Varchar(80),
@Neodata Bit,
@IdTipoDocumento Int,
@Version Varchar(20),
@Extension as Varchar(10)
AS
BEGIN
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @IdDocumento = 0
BEGIN
INSERT INTO PuDocumentos( Documento, Neodata, IdTipoDocumento, ObjDocumento, version, Extension )
VALUES ( @Documento, @Neodata, @IdTipoDocumento, @ObjDocumento, @Version, @Extension)
SET @RegistrosAfectados = @@ROWCOUNT
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al insertar la imagen. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdDocumento = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuDocumentos
SET Documento = @Documento, Neodata = @Neodata, IdTipoDocumento = @IdTipoDocumento, ObjDocumento = @ObjDocumento,
Version = @Version, Extension = @Extension
WHERE IdDocumento = @IdDocumento
SET @RegistrosAfectados = @@ROWCOUNT
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al actualizar la imagen. No se afectaron registros.', 16, 1)
RETURN
END
END
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatEmpresasControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author: Juan Manuel Ramírez Francisco <Author,,Name>
-- Create date: 06-Ago-2009 <Create Date,,>
-- Description:	Control 3 puntos del catálogo de empresas <Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatEmpresasControl3Puntos]
@IdEmpresa Int,
@Empresa Varchar(20) = NULL
AS
BEGIN
SET NOCOUNT ON;
IF @IdEmpresa  = 0 AND @Empresa  IS NULL
BEGIN
SELECT E.IdEmpresa, E.Empresa, E.RazonSocial, E.Direccion, E.Colonia, E.Telefono, E.Mail, E.RFC, E.IMSS, E.Infonavit, E.CMIC,
E.IdResponsable, R.Responsable, R.Nombre, R.Cargo, E.IdCiudad, C.Ciudad, C.Descripcion AS NombreCiudad, C.IdEstado,
ED.Estado, ED.Nombre AS NombreEstado, E.CodigoPostal, E.Fax
FROM PuEmpresas E LEFT JOIN
PuCiudades C ON E.IdCiudad = C.IdCiudad LEFT JOIN
PuEstados ED ON C.IdEstado = ED.IdEstado LEFT JOIN
PuResponsables R ON E.IdResponsable = R.IdResponsable
ORDER BY E.Empresa
END
ELSE IF @IdEmpresa > 0 AND @Empresa IS NULL
BEGIN
SELECT E.IdEmpresa, E.Empresa, E.RazonSocial, E.Direccion, E.Colonia, E.Telefono, E.Mail, E.RFC, E.IMSS, E.Infonavit, E.CMIC,
E.IdResponsable, R.Responsable, R.Nombre, R.Cargo, E.IdCiudad, C.Ciudad, C.Descripcion AS NombreCiudad, C.IdEstado,
ED.Estado, ED.Nombre AS NombreEstado, E.CodigoPostal, E.Fax
FROM PuEmpresas E LEFT JOIN
PuCiudades C ON E.IdCiudad = C.IdCiudad LEFT JOIN
PuEstados ED ON C.IdEstado = ED.IdEstado LEFT JOIN
PuResponsables R ON E.IdResponsable = R.IdResponsable
WHERE E.IdEmpresa = @IdEmpresa
END
ELSE IF @IdEmpresa = 0 AND @Empresa IS NOT NULL
BEGIN
SELECT E.IdEmpresa, E.Empresa, E.RazonSocial, E.Direccion, E.Colonia, E.Telefono, E.Mail, E.RFC, E.IMSS, E.Infonavit, E.CMIC,
E.IdResponsable, R.Responsable, R.Nombre, R.Cargo, E.IdCiudad, C.Ciudad, C.Descripcion AS NombreCiudad, C.IdEstado,
ED.Estado, ED.Nombre AS NombreEstado, E.CodigoPostal, E.Fax
FROM PuEmpresas E LEFT JOIN
PuCiudades C ON E.IdCiudad = C.IdCiudad LEFT JOIN
PuEstados ED ON C.IdEstado = ED.IdEstado LEFT JOIN
PuResponsables R ON E.IdResponsable = R.IdResponsable
WHERE E.Empresa = @Empresa
END
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatEmpresasEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author: Juan Manuel Ramírez Francisco <Author,,Name>
-- Create date: 06-Ago-2009 <Create Date,,>
-- Description:	Catálogo de Empresas, Eliminar <Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatEmpresasEliminar]
@IdEmpresa Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRY
DELETE FROM PuEmpresas  WHERE IdEmpresa = @IdEmpresa
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al eliminar la empresa. No se afectaron registros.', 16, 1)
RETURN
END
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatEmpresasInsertarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author: Juan Manuel Ramírez Francisco <Author,,Name>
-- Create date: 06-Ago-2009 <Create Date,,>
-- Description:	Catálogo de Empresas, Insertar y Actualizar <Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatEmpresasInsertarActualizar]
@IdEmpresa Int OUT,
@Empresa Varchar(20),
@RazonSocial Varchar(100),
@Direccion Varchar(80),
@Colonia Varchar(30),
@IdCiudad Int,
@Telefono Varchar(30),
@Mail Varchar(50),
@RFC Varchar(13),
@IMSS Varchar(10),
@Infonavit Varchar(20),
@CMIC Varchar(40),
@CodigoPostal Varchar(6),
@Fax Varchar(39),
@IdResponsable Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @IdEmpresa = 0
BEGIN
INSERT INTO PuEmpresas (Empresa, RazonSocial , IdCiudad, Direccion, Colonia, Telefono, Mail, RFC, IMSS, Infonavit, CMIC, IdResponsable, CodigoPostal, Fax)
VALUES (@Empresa , @RazonSocial, @IdCiudad, @Direccion, @Colonia, @Telefono, @Mail, @RFC, @IMSS, @Infonavit, @CMIC, @IdResponsable, @CodigoPostal, @Fax)
IF @@ROWCOUNT < 0
BEGIN
RAISERROR('Error al insertar la Empresa. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdEmpresa = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuEmpresas
SET Empresa = @Empresa, RazonSocial = @RazonSocial, IdCiudad = @IdCiudad, Direccion = @Direccion, Colonia = @Colonia, Telefono = @Telefono,
Mail = @Mail, RFC = @RFC, IMSS = @IMSS, Infonavit = @Infonavit, CMIC = @CMIC, IdResponsable = @IdResponsable, CodigoPostal = @CodigoPostal, Fax = @Fax
WHERE IdEmpresa  = @IdEmpresa
END
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatEstadoEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatEstadoEliminar]
@IdEstado int
AS
DELETE FROM PuEstados WHERE IdEstado = @IdEstado
GO
/****** Object:  StoredProcedure [dbo].[NeoCatEstadoGrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 02-Julio-2009
---- Description:	Graba y Actualiza el Catálogo de Estados
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatEstadoGrabarActualizar]
@IdEstado Int OutPut,
@Estado Varchar(5),
@Nombre Varchar(30)
AS
BEGIN
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @IdEstado = 0
BEGIN
INSERT INTO PuEstados (Estado, Nombre)
VALUES (@Estado, @Nombre)
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al Insertar el estado. No se afectaron registros.', 16, 1)
RETURN
END
SET  @IdEstado = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuEstados
SET Estado = @Estado, Nombre = @Nombre
WHERE IdEstado = @IdEstado
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al actualizar el estado. No se afectaron registros.', 16, 1)
RETURN
END
END
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatEstadosCargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatEstadosCargaDatos]
AS
SELECT IdEstado, Estado, Nombre
FROM PuEstados
ORDER BY Estado
GO
/****** Object:  StoredProcedure [dbo].[NeoCatEstadosControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 22-Julio-2009
---- Description:	Control de 3 puntos del catálogo de estados
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatEstadosControl3Puntos]
@Estado varchar(20),
@IdEstado int
AS
IF @Estado IS NULL AND @IdEstado = 0
SELECT IdEstado,Estado,Nombre
FROM PuEstados
ORDER BY Estado
ELSE IF @IdEstado = 0 AND @Estado IS NOT NULL
SELECT IdEstado,Estado,Nombre
FROM PuEstados
WHERE Estado = @Estado
ELSE IF @IdEstado > 0 AND @Estado IS NULL
SELECT IdEstado,Estado,Nombre
FROM PuEstados
WHERE IdEstado = @IdEstado
GO
/****** Object:  StoredProcedure [dbo].[NeoCatFamiliasCargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatFamiliasCargaDatos]
AS
SELECT IdFamilia, Familia, Descripcion
FROM PuFamilias
ORDER BY Familia
GO
/****** Object:  StoredProcedure [dbo].[NeoCatFamiliasControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 22-Julio-2009
---- Description:	Control de 3 puntos del catálogo de Familias
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatFamiliasControl3Puntos]
@Familia Varchar(20),
@IdFamilia Int
AS
IF @Familia IS NULL AND @IdFamilia = 0
SELECT IdFamilia, Familia, Descripcion
FROM PuFamilias
ORDER BY Familia
ELSE IF @IdFamilia = 0 AND @Familia IS NOT NULL
SELECT IdFamilia, Familia, Descripcion
FROM PuFamilias
WHERE Familia = @Familia
ELSE IF @IdFamilia > 0 AND @Familia IS NULL
SELECT IdFamilia, Familia, Descripcion
FROM PuFamilias
WHERE IdFamilia= @IdFamilia
GO
/****** Object:  StoredProcedure [dbo].[NeoCatFamiliasEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatFamiliasEliminar]
@IdFamilia int
AS
DELETE FROM PuFamilias WHERE IdFamilia = @IdFamilia
GO
/****** Object:  StoredProcedure [dbo].[NeoCatFamiliasGrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 02-Julio-2009
---- Description:	Graba y Actualiza el Catálogo de Familias
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatFamiliasGrabarActualizar]
@IdFamilia Int OutPut,
@Familia Varchar(20),
@Descripcion Varchar(40)
AS
BEGIN
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @IdFamilia = 0
BEGIN
INSERT INTO PuFamilias (Familia, Descripcion)
VALUES (@Familia, @Descripcion)
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al Insertar la familia. No se afectaron registros.', 16, 1)
RETURN
END
SET  @IdFamilia = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuFamilias
SET Familia = @Familia, Descripcion = @Descripcion
WHERE IdFamilia = @IdFamilia
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al actualizar la familia. No se afectaron registros.', 16, 1)
RETURN
END
END
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatFichasCargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatFichasCargaDatos]
AS
SELECT IdFichaTecnica, FichaTecnica, DescripcionLarga, RutaArchivo
FROM PuFichasTecnicas
ORDER BY FichaTecnica
GO
/****** Object:  StoredProcedure [dbo].[NeoCatFichasControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 22-Julio-2009
---- Description:	Control de 3 puntos del catálogo de Fichas
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatFichasControl3Puntos]
@FichaTecnica Varchar(20),
@IdFichaTecnica Int
AS
IF @FichaTecnica IS NULL AND @IdFichaTecnica = 0
SELECT IdFichaTecnica, FichaTecnica, DescripcionLarga, RutaArchivo
FROM PuFichasTecnicas
ORDER BY FichaTecnica
ELSE IF @IdFichaTecnica = 0 AND @FichaTecnica IS NOT NULL
SELECT IdFichaTecnica, FichaTecnica, DescripcionLarga, RutaArchivo
FROM PuFichasTecnicas
WHERE FichaTecnica = @FichaTecnica
ELSE IF @IdFichaTecnica > 0 AND @FichaTecnica IS NULL
SELECT IdFichaTecnica, FichaTecnica, DescripcionLarga, RutaArchivo
FROM PuFichasTecnicas
WHERE IdFichaTecnica = @IdFichaTecnica
GO
/****** Object:  StoredProcedure [dbo].[NeoCatFichasEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatFichasEliminar]
@IdFichaTecnica as int
AS
DELETE FROM PuFichasTecnicas WHERE IdFichaTecnica = @IdFichaTecnica
GO
/****** Object:  StoredProcedure [dbo].[NeoCatFichasGrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 02-Julio-2009
---- Description:	Graba y Actualiza el Catálogo de Fichas
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatFichasGrabarActualizar]
@IdFichaTecnica Int OutPut,
@FichaTecnica Varchar(20),
@DescripcionLarga Varchar(8000),
@RutaArchivo Varchar(250)
AS
BEGIN
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @IdFichaTecnica = 0
BEGIN
INSERT INTO PuFichasTecnicas ( FichaTecnica, DescripcionLarga, RutaArchivo )
VALUES ( @FichaTecnica, @DescripcionLarga, @RutaArchivo )
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al Insertar la Ficha. No se afectaron registros.', 16, 1)
RETURN
END
SET  @IdFichaTecnica = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuFichasTecnicas
SET FichaTecnica = @FichaTecnica, DescripcionLarga = @DescripcionLarga, RutaArchivo = @RutaArchivo
WHERE IdFichaTecnica = @IdFichaTecnica
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al actualizar la Ficha. No se afectaron registros.', 16, 1)
RETURN
END
END
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatGenalEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatGenalEliminar]
@IdCodigo as int
AS
DELETE FROM PuCatalogo WHERE IdCodigo = @IdCodigo
GO
/****** Object:  StoredProcedure [dbo].[NeoCatGeneralAsignaMenuContextual]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatGeneralAsignaMenuContextual]
@Id int,
@IdCodigo int,
@Tipo int
AS
IF @Tipo = 1
--Tipos de Insumo
UPDATE PuCatalogo SET IdTipo = @Id WHERE IdCodigo = @IdCodigo
ELSE IF @Tipo = 2
--Unidades
UPDATE PuCatalogo SET IdUnidad = @Id WHERE IdCodigo = @IdCodigo
ELSE IF @Tipo = 3
--Familias
UPDATE PuCatalogo SET IdFamilia = @Id WHERE IdCodigo = @IdCodigo
ELSE IF @Tipo = 4
--Proveedores
UPDATE PuCatalogo SET IdProveedor = @Id WHERE IdCodigo = @IdCodigo
ELSE IF @Tipo = 5
--Procedimientos
UPDATE PuCatalogo SET IdProcedimiento = @Id WHERE IdCodigo = @IdCodigo
ELSE IF @Tipo = 6
--Fichas Técnicas
UPDATE PuCatalogo SET IdFichaTecnica = @Id WHERE IdCodigo = @IdCodigo
GO
/****** Object:  StoredProcedure [dbo].[NeoCatGeneralBuscaId]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatGeneralBuscaId]
@BuscaEnCatalogo int,
@Codigo Varchar(20)
AS
DECLARE @Id Int
BEGIN
SET NOCOUNT ON;
--Busca el Id del Catálogo General
IF @BuscaEnCatalogo = 1
BEGIN
SELECT @Id = IdCodigo FROM PuCatalogo Where Codigo = @Codigo
END
--Busca el Id del Catálogo de Familias
ELSE IF @BuscaEnCatalogo = 2
BEGIN
SELECT @Id = IdFamilia FROM PuFamilias Where Familia = @Codigo
END
--Busca el Id del Catálogo de Ciudades
ELSE IF @BuscaEnCatalogo = 3
BEGIN
SELECT @Id = IdCiudad FROM PuCiudades Where Ciudad = @Codigo
END
--Busca el Id del Catálogo de Estados
ELSE IF @BuscaEnCatalogo = 4
BEGIN
SELECT @Id = IdEstado FROM PuEstados Where Estado = @Codigo
END
--Busca el Id del Catálogo de Fichas Técnicas
ELSE IF @BuscaEnCatalogo = 5
BEGIN
SELECT @Id = IdFichaTecnica FROM PuFichasTecnicas Where FichaTecnica = @Codigo
END
--Busca el Id del Catálogo de Procedimientos
ELSE IF @BuscaEnCatalogo = 6
BEGIN
SELECT @Id = IdProcedimiento FROM PuProcedimientos Where Procedimiento = @Codigo
END
--Busca el Id del Catálogo de Proveedores
ELSE IF @BuscaEnCatalogo = 7
BEGIN
SELECT @Id = IdProveedor FROM PuProveedores Where Proveedor = @Codigo
END
--Busca el Id del Catálogo de Iipos de Unidades
ELSE IF @BuscaEnCatalogo = 8
BEGIN
SELECT @Id = IdUnidad FROM PuUnidades Where Unidad = @Codigo
END
ELSE IF @BuscaEnCatalogo = 9
BEGIN
SELECT @Id = IdTipo FROM PuTipoInsumos Where IdTipo = @Codigo
END
ELSE IF @BuscaEnCatalogo = 10
BEGIN
SELECT @Id = IdContratista FROM PuContratistas Where Contratista = @Codigo
END
RETURN @Id
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatGeneralControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín
-- Create date: 13-Junio-2009
-- Description:	Buestra el Catálogo General con diferentes Filtros
--@TipoFiltro =1  Muetra Todo el Catálogo
--@TipoFiltro =2  No los insumos que tienen la marca EsPorcentaje
--@TipoFiltro =3  Solo muestra los insumos que tienen la marca de Agrupador
--@TipoFiltro =4  Solo muestra los Materiales
--@TipoFiltro =5  Solo muestra la Mano de Obra
--@TipoFiltro =6  Solo muestra los Equipos
--@TipoFiltro =7  Solo muestra los Tipo 4
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatGeneralControl3Puntos]
@Codigo Varchar(20),
@IdCodigo Int,
@TipoFiltro Int
AS
IF @Codigo IS NULL AND @IdCodigo = 0
BEGIN
IF @TipoFiltro = 1
BEGIN
SELECT C.IdCodigo, C.Codigo, C.IdTipo, C.DescripcionLarga, C.Descripcion, F.Familia,
U.Unidad, C.EsPorcentaje, C.EsAgrupador,
CAST( CASE WHEN C.EsPorcentaje = 0 THEN 0 ELSE 1 END AS Bit) AS Porcentaje
FROM PuCatalogo AS C LEFT JOIN
PuFamilias AS F ON C.IdFamilia = F.IdFamilia INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad
ORDER BY  C.IdTipo, C.Codigo
END
IF @TipoFiltro = 2
BEGIN
SELECT C.IdCodigo, C.Codigo, C.IdTipo, C.DescripcionLarga, C.Descripcion, F.Familia,
U.Unidad, C.EsPorcentaje, C.EsAgrupador,
CAST( CASE WHEN C.EsPorcentaje = 0 THEN 0 ELSE 1 END AS Bit) AS Porcentaje
FROM PuCatalogo AS C LEFT JOIN
PuFamilias AS F ON C.IdFamilia = F.IdFamilia INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad
WHERE C.EsPorcentaje = 0
ORDER BY  C.IdTipo, C.Codigo
END
IF @TipoFiltro = 3
BEGIN
SELECT C.IdCodigo, C.Codigo, C.IdTipo, C.DescripcionLarga, C.Descripcion, F.Familia,
U.Unidad, C.EsPorcentaje, C.EsAgrupador,
CAST( CASE WHEN C.EsPorcentaje = 0 THEN 0 ELSE 1 END AS Bit) AS Porcentaje
FROM PuCatalogo AS C LEFT JOIN
PuFamilias AS F ON C.IdFamilia = F.IdFamilia INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad
WHERE  C.EsAgrupador = 1
ORDER BY  C.IdTipo, C.Codigo
END
IF @TipoFiltro = 4
BEGIN
SELECT C.IdCodigo, C.Codigo, C.IdTipo, C.DescripcionLarga, C.Descripcion, F.Familia,
U.Unidad, CAST( CASE WHEN C.EsPorcentaje = 0 THEN 0 ELSE 1 END AS Bit) AS Porcentaje
FROM PuCatalogo AS C LEFT JOIN
PuFamilias AS F ON C.IdFamilia = F.IdFamilia INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad
WHERE C.IdTipo = 1 AND C.Esporcentaje = 0 AND C.EsAgrupador = 0
ORDER BY C.Codigo
END
IF @TipoFiltro = 5
BEGIN
SELECT C.IdCodigo, C.Codigo, C.IdTipo, C.DescripcionLarga, C.Descripcion, F.Familia,
U.Unidad, CAST( CASE WHEN C.EsPorcentaje = 0 THEN 0 ELSE 1 END AS Bit) AS Porcentaje
FROM PuCatalogo AS C LEFT JOIN
PuFamilias AS F ON C.IdFamilia = F.IdFamilia INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad
WHERE C.IdTipo = 2 AND C.Esporcentaje = 0 AND C.EsAgrupador = 0
ORDER BY C.Codigo
END
IF @TipoFiltro = 6
BEGIN
SELECT C.IdCodigo, C.Codigo, C.IdTipo, C.DescripcionLarga, C.Descripcion, F.Familia,
U.Unidad, CAST( CASE WHEN C.EsPorcentaje = 0 THEN 0 ELSE 1 END AS Bit) AS Porcentaje
FROM PuCatalogo AS C LEFT JOIN
PuFamilias AS F ON C.IdFamilia = F.IdFamilia INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad
WHERE C.IdTipo = 3 AND C.Esporcentaje = 0 AND C.EsAgrupador = 0
ORDER BY C.Codigo
END
IF @TipoFiltro = 7
BEGIN
SELECT C.IdCodigo, C.Codigo, C.IdTipo, C.DescripcionLarga, C.Descripcion, F.Familia,
U.Unidad
FROM PuCatalogo AS C LEFT JOIN
PuFamilias AS F ON C.IdFamilia = F.IdFamilia INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad
WHERE C.IdTipo = 4 AND C.Esporcentaje = 0 AND C.EsAgrupador = 0
ORDER BY C.Codigo
END
END
ELSE IF  @IdCodigo = 0  and @Codigo IS NOT NULL
BEGIN
SELECT C.IdCodigo, C.Codigo, C.IdTipo, C.DescripcionLarga, C.Descripcion, F.Familia,
U.Unidad, C.EsPorcentaje, C.EsAgrupador,
CAST( CASE WHEN C.EsPorcentaje = 0 THEN 0 ELSE 1 END AS Bit) AS Porcentaje
FROM PuCatalogo AS C LEFT JOIN
PuFamilias AS F ON C.IdFamilia = F.IdFamilia INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad
WHERE C.Codigo = @Codigo
ORDER BY  C.IdTipo, C.Codigo
END
ELSE IF   @IdCodigo > 0  AND @Codigo IS NULL
BEGIN
SELECT C.IdCodigo, C.Codigo, C.IdTipo, C.DescripcionLarga, C.Descripcion, F.Familia,
U.Unidad, C.EsPorcentaje, C.EsAgrupador,
CAST( CASE WHEN C.EsPorcentaje = 0 THEN 0 ELSE 1 END AS Bit) AS Porcentaje
FROM PuCatalogo AS C LEFT JOIN
PuFamilias AS F ON C.IdFamilia = F.IdFamilia INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad
WHERE C.IdCodigo = @IdCodigo
ORDER BY  C.IdTipo, C.Codigo
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatGeneralParticicpa]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín Ramírez
-- Create date: 08-Agosto-09
-- Description:	Regresa los coneptos en los que participa el intelimat
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatGeneralParticicpa]
@IdCodigo Int,
@IdMoneda Int
AS
BEGIN
SELECT C.IdCodigo, E.IdExpIns, E.IdPresupuesto,
P.Presupuesto, P.Nombre, C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
E.InsumoIntegrado, C.EsAgrupador, E.EsCostoHorario, C.EsPorcentaje, E.Expins, DC.Costo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuPresupuestos AS P ON P.IdPresupuesto = E.IdPresupuesto LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = @IdMoneda) AS DC ON DC.IdExpIns = E.IdExpIns
WHERE E.IdCodigo = @IdCodigo
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatGeneralParticipa]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín Ramírez
-- Create date: 08-Agosto-09
-- Description:	Regresa los coneptos en los que participa el intelimat
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatGeneralParticipa]
@IdCodigo Int,
@IdMoneda Int
AS
BEGIN
SELECT C.IdCodigo, E.IdExpIns, E.IdPresupuesto,
P.Presupuesto, P.Nombre, C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
E.InsumoIntegrado, C.EsAgrupador, E.EsCostoHorario, C.EsPorcentaje, E.Expins, DC.Costo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuPresupuestos AS P ON P.IdPresupuesto = E.IdPresupuesto LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = @IdMoneda) AS DC ON DC.IdExpIns = E.IdExpIns
WHERE E.IdCodigo = @IdCodigo
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatImagenesBuscaImagen]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín
-- Create date: 10-Junio-2009
-- Description:	Busca si una Imagen se repite en una partida
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatImagenesBuscaImagen]
@Descripcion Varchar(40),
@Partida Varchar(40),
@Id Int OutPut
AS
IF @Partida IS NULL
BEGIN
SELECT @Id = IdImagen
FROM PuImagenes
WHERE Descripcion = @Descripcion AND Partida  IS NULL
SET @Id = COALESCE(@Id,0)
END
ELSE
BEGIN
SELECT @Id = IdImagen
FROM PuImagenes
WHERE Descripcion = @Descripcion AND Partida = @Partida
SET @Id = COALESCE(@Id,0)
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatImagenesCargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatImagenesCargaDatos]
AS
SELECT I.IdImagen, I.Partida, I.Descripcion, I.Imagen, F.Familia, I.TipoArchivo, I.CheckSum
FROM PuImagenes I LEFT JOIN
PuFamilias F ON I.IdFamilia = F.idFamilia
GO
/****** Object:  StoredProcedure [dbo].[NeoCatImagenesControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatImagenesControl3Puntos]
@CheckSum varchar(20),
@IdImagen int
AS
IF  @CheckSum IS NULL AND @IdImagen = 0
SELECT I.IdImagen, I.Imagen, I.Descripcion, F.Familia, I.TipoArchivo
FROM PuImagenes I
LEFT JOIN PuFamilias F ON I.IdFamilia = F.idFamilia
ELSE IF @IdImagen = 0 and @CheckSum is not null
SELECT I.IdImagen, I.Descripcion, I.Imagen, F.Familia, I.TipoArchivo, I.CheckSum
FROM PuImagenes I LEFT JOIN
PuFamilias F ON I.IdFamilia = F.idFamilia
WHERE I.CheckSum = @CheckSum
ELSE IF @IdImagen > 0 and @CheckSum is null
SELECT I.IdImagen, I.Descripcion, I.Imagen, F.Familia, I.TipoArchivo, I.CheckSum
FROM PuImagenes I LEFT JOIN
PuFamilias F ON I.IdFamilia = F.idFamilia
WHERE I.IdImagen = @IdImagen
GO
/****** Object:  StoredProcedure [dbo].[NeoCatImagenesEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatImagenesEliminar]
@IdImagen int
AS
DELETE FROM PuImagenes WHERE IdImagen = @IdImagen
GO
/****** Object:  StoredProcedure [dbo].[NeoCatImagenesGrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 24-Junio-2009
---- Description:	Graba y Actualiza el catálogo de imagenes
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatImagenesGrabarActualizar]
@IdImagen Int OutPut,
@Imagen Varbinary(MAX),
@Descripcion Varchar(40),
@Partida Varchar(40),
@IdFamilia Int,
@TipoArchivo Varchar(8),
@CheckSum Varchar(40)
AS
BEGIN
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @IdImagen = 0
BEGIN
INSERT INTO PuImagenes ( Descripcion, Imagen, IdFamilia, TipoArchivo, CheckSum )
VALUES ( @Descripcion, @Imagen, @IdFamilia, @TipoArchivo, @CheckSum )
SET @RegistrosAfectados = @@ROWCOUNT
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al insertar la imagen. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdImagen = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuImagenes
SET Descripcion = @Descripcion, Imagen = @Imagen, IdFamilia = @IdFamilia, Partida = @Partida,
TipoArchivo = @TipoArchivo, CheckSum = @CheckSum
WHERE IdImagen = @IdImagen
SET @RegistrosAfectados = @@ROWCOUNT
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al actualizar la imagen. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdImagen = @@IDENTITY
END
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatIntelimatBuscaIntelimat]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín
-- Create date: 10-Junio-2009
-- Description:	Busca si un Intelimat se repite en una partida
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatIntelimatBuscaIntelimat]
@Intelimat Varchar(40),
@Partida Varchar(40),
@Id Int OutPut
AS
IF @Partida IS NULL
BEGIN
SELECT  @Id = IdInteliMat FROM PuIntelimat
WHERE InteliMat = @Intelimat AND Partida IS NULL
SET @Id = COALESCE(@Id,0)
END
ELSE
BEGIN
SELECT  @Id = IdInteliMat FROM PuIntelimat
WHERE InteliMat = @Intelimat AND Partida = @Partida
SET @Id = COALESCE(@Id,0)
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatIntelimatControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Abel Dávalos
-- Create date: 08/Julio/2009
-- Description:	Control de 3 puntos de intelimat
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatIntelimatControl3Puntos]
@Intelimat Varchar(80),
@IdIntelimat int
AS
BEGIN
IF @Intelimat IS null  AND @IdIntelimat = 0
SELECT Idintelimat,InteliMat,Autor,Fecha,EsNeodata  FROM PuIntelimat ORDER BY InteliMat
ELSE IF @IdIntelimat = 0 and @Intelimat is not null
SELECT Idintelimat,InteliMat,Autor,Fecha,EsNeodata  FROM PuIntelimat WHERE intelimat = @Intelimat
ELSE IF @IdIntelimat > 0 and @Intelimat is null
SELECT Idintelimat,InteliMat,Autor,Fecha,EsNeodata  FROM PuIntelimat WHERE Idintelimat = @IdIntelimat
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatIntelimatParticicpa]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín Rampirez
-- Create date: 08-Agosto-09
-- Description:	Regresa los coneptos en los que participa el intelimat
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatIntelimatParticicpa]
@IdIntelimat Int
AS
BEGIN
SET NOCOUNT ON;
SELECT  P.Presupuesto, P.Nombre, PP.Partida, PP.DescripcionPartida, PC.IdExpIns,
PC.Renglon, C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
PC.Cantidad, PC.CantidadTotal, PC.IndirectoEspecial, 	PC.PorcentajeIndirectoEspecial, EI.EsCostoHorario,
PC.DescripcionAuxiliar, IM.EsNeodata
FROM PuPresupuestosConceptos AS PC INNER JOIN
PuPresupuestosPartidas AS PP ON PP.IdPresupuestoPartida = PC.IdPresupuestoPartida INNER JOIN
PuPresupuestos AS P ON P.IdPresupuesto = PC.IdPresupuesto INNER JOIN
PuExpIns AS EI ON PC.IdExpIns = EI.IdExpIns INNER JOIN
PuCatalogo AS C ON EI.IdCodigo = C.IdCodigo INNER JOIN
PuUnidades AS U ON C.Idunidad = U.Idunidad LEFT JOIN
PuCatalogo AS C2 ON PC.IdAgrupador = C2.IdCodigo LEFT JOIN
PuIntelimat AS IM ON IM.IdIntelimat = EI.IdIntelimat
WHERE EI.IdIntelimat = @IdIntelimat
ORDER BY PP.Renglon, PC.Renglon
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatMonedasControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 22-Julio-2009
---- Description:	Control de 3 puntos del catálogo de monedas
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatMonedasControl3Puntos]
@IdMoneda Int,
@Moneda Int
AS
IF  @IdMoneda = 0 AND @Moneda = 0
SELECT IdMoneda, Moneda, Descripcion, RemateMoneda, ParidadContratos, EsCalculada
FROM PuMonedas
ORDER BY Moneda
ELSE IF  @IdMoneda = 0 AND @Moneda >0
SELECT IdMoneda, Moneda, Descripcion, RemateMoneda, ParidadContratos, EsCalculada
FROM PuMonedas
WHERE Moneda = @Moneda
ELSE IF @IdMoneda > 0 and @Moneda =0
SELECT IdMoneda, Moneda, Descripcion, RemateMoneda, ParidadContratos, EsCalculada
FROM PuMonedas
WHERE IdMoneda = @IdMoneda
GO
/****** Object:  StoredProcedure [dbo].[NeoCatMonedasEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:		José Luis Colín
---- Create date:	15-Agosto-2009
---- Description:	Elimina una moneda
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatMonedasEliminar]
@IdMoneda Int
AS
BEGIN
DELETE FROM PuMonedas WHERE IdMoneda = @IdMoneda
RETURN @@ROWCOUNT
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatMonedasGrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 24-Junio-2009
---- Description:	Graba y Actualiza el catálogo de Monedas
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatMonedasGrabarActualizar]
@IdMoneda Int OutPut,
@Moneda Int,
@Descripcion Varchar(20),
@RemateMoneda Varchar(20),
@ParidadContratos Decimal(18, 8),
@EsCalculada Bit
AS
BEGIN
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @IdMoneda = 0
BEGIN
INSERT INTO PuMonedas ( Moneda, Descripcion, RemateMoneda, ParidadContratos, EsCalculada )
VALUES ( @Moneda, @Descripcion, @RemateMoneda, @ParidadContratos, @EsCalculada )
SET @RegistrosAfectados = @@ROWCOUNT
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al insertar la moneda. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdMoneda = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuMonedas
SET Moneda = @Moneda, Descripcion = @Descripcion, RemateMoneda = @RemateMoneda,
ParidadContratos = @ParidadContratos, EsCalculada = @EsCalculada
WHERE IdMoneda = @IdMoneda
SET @RegistrosAfectados = @@ROWCOUNT
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al actualizar la moneda. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdMoneda = @@IDENTITY
END
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatPresupuestos_CargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:	Juan Manuel Ramírez Francisco	<Author,,Name>
-- Create date: 28-Jul-09 <Create Date,,>
-- Description:	Control 3 puntos, catálogo de obras <Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatPresupuestos_CargaDatos]
@Decimales Int,
@IdMoneda Int,
@IdSegundaMoneda Int,
@IdTercerMoneda Int,
@DescripcionMoneda2 AS VarChar(40) OUT,
@DescripcionMoneda3 AS VarChar(40) OUT
AS
DECLARE
@Sql AS nVarChar(3000)
BEGIN
SET NOCOUNT ON;
SET @Sql = 'SELECT P.IdPresupuesto, P.Presupuesto, P.Nombre, P.Direccion, P.Colonia, P.Telefono, P.CodPost, P.Maiil, P.Observaciones,
P.IdCliente, CL.Cliente, CL.Nombre AS NombreCliente, P.IdResponsable, P.IdEmpresa, P.IdCiudad, P.PorcentajeIVA, P.Cargo,
C.Ciudad, C.Ciudad AS DescripcionCiudad, C.IdEstado, E.Estado, E.Nombre AS NombreEstado, COALESCE(CO.CostoTotal, 0.0) AS Costo '
IF @IdSegundaMoneda > 0
SET @Sql += ', COALESCE(CO2.CostoTotal, 0.0) AS Costo2 '
END
IF @IdTercerMoneda > 0
SET @Sql += ', COALESCE(CO3.CostoTotal, 0.0) AS Costo3 '
SET @Sql += 'FROM PuPresupuestos P LEFT JOIN
PuClientes CL ON P.IdCliente = CL.IdCliente LEFT JOIN
PuCiudades C ON P.IdCiudad = C.IdCiudad LEFT JOIN
PuEstados E ON C.IdEstado = E.IdEstado LEFT JOIN
(Select PP.IdPresupuesto, PP.CostoTotal
From PuPresupuestosPrecios PP
Where PP.IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS CO ON P.IdPresupuesto = CO.IdPresupuesto '
IF @IdSegundaMoneda  > 0 BEGIN
SET @Sql += 'LEFT JOIN
(Select PP2.IdPresupuesto, PP2.CostoTotal
From PuPresupuestosPrecios PP2
Where PP2.IdMoneda = ' + CAST(@IdSegundaMoneda AS VarChar) + ') AS CO2 ON P.IdPresupuesto = CO2.IdPresupuesto '
SELECT @DescripcionMoneda2 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdSegundaMoneda
IF @IdTercerMoneda  > 0 BEGIN
SET @Sql += 'LEFT JOIN
(Select PP3.IdPresupuesto, PP3.CostoTotal
From PuPresupuestosPrecios PP3
Where PP3.IdMoneda = ' + CAST(@IdTercerMoneda AS VarChar) + ') AS CO3 ON P.IdPresupuesto = CO3.IdPresupuesto '
SELECT @DescripcionMoneda3 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdTercerMoneda
END
END
SET @Sql += 'ORDER BY P.Presupuesto'
EXEC sp_executesql @Sql
GO
/****** Object:  StoredProcedure [dbo].[NeoCatPresupuestos_Control3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:	Juan Manuel Ramírez Francisco	<Author,,Name>
-- Create date: 28-Jul-09 <Create Date,,>
-- Description:	Control 3 puntos, catálogo de obras <Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatPresupuestos_Control3Puntos]
@IdPresupuesto AS Int,
@Presupuesto AS VARCHAR(20) = NULL
AS
BEGIN
SET NOCOUNT ON;
IF @IdPresupuesto = 0 AND @Presupuesto IS NULL
BEGIN
SELECT P.IdPresupuesto, P.Presupuesto, P.Nombre, P.Direccion, P.Colonia, P.Telefono, P.CodPost, P.Maiil, P.Observaciones,
P.PorcentajeIVA, P.IdCliente, CL.Cliente, CL.Nombre AS NombreCliente, P.IdResponsable, P.Cargo,
P.IdCiudad, C.Ciudad, C.Ciudad AS DescripcionCiudad, C.IdEstado, E.Estado, E.Nombre AS NombreEstado, P.IdEmpresa
FROM PuPresupuestos P LEFT JOIN
PuClientes CL ON P.IdCliente = CL.IdCliente LEFT JOIN
PuCiudades C ON P.IdCiudad = C.IdCiudad LEFT JOIN
PuEstados E ON C.IdEstado = E.IdEstado
ORDER BY P.Presupuesto
END
ELSE IF @IdPresupuesto > 0 AND @Presupuesto IS NULL
BEGIN
SELECT P.IdPresupuesto, P.Presupuesto, P.Nombre, P.Direccion, P.Colonia, P.Telefono, P.CodPost, P.Maiil, P.Observaciones,
P.PorcentajeIVA, P.IdCliente, CL.Cliente, CL.Nombre AS NombreCliente, P.IdResponsable, P.Cargo,
P.IdCiudad, C.Ciudad, C.Ciudad AS DescripcionCiudad, C.IdEstado, E.Estado, E.Nombre AS NombreEstado, P.IdEmpresa
FROM PuPresupuestos P LEFT JOIN
PuClientes CL ON P.IdCliente = CL.IdCliente LEFT JOIN
PuCiudades C ON P.IdCiudad = C.IdCiudad LEFT JOIN
PuEstados E ON C.IdEstado = E.IdEstado
WHERE P.IdPresupuesto = @IdPresupuesto
END
ELSE IF @IdPresupuesto = 0 AND @Presupuesto IS NOT NULL
BEGIN
SELECT P.IdPresupuesto, P.Presupuesto, P.Nombre, P.Direccion, P.Colonia, P.Telefono, P.CodPost, P.Maiil, P.Observaciones,
P.PorcentajeIVA, P.IdCliente, CL.Cliente, CL.Nombre AS NombreCliente, P.IdResponsable, P.Cargo,
P.IdCiudad, C.Ciudad, C.Ciudad AS DescripcionCiudad, C.IdEstado, E.Estado, E.Nombre AS NombreEstado, P.IdEmpresa
FROM PuPresupuestos P LEFT JOIN
PuClientes CL ON P.IdCliente = CL.IdCliente LEFT JOIN
PuCiudades C ON P.IdCiudad = C.IdCiudad LEFT JOIN
PuEstados E ON C.IdEstado = E.IdEstado
WHERE P.Presupuesto = @Presupuesto
END
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatPresupuestos_GrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- Batch submitted through debugger: SQLQuery10.sql|7|0|C:\Documents and Settings\jmramirez.DESARROLLO\Configuración local\Temp\~vs31B.sql
-- =============================================
-- Author:	Juan Manuel Ramirez Francisco	<Author,,Name>
-- Create date: 29-Jul-2009 <Create Date,,>
-- Description:	Grabar actualizar catálogo de obras  <Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatPresupuestos_GrabarActualizar]
@IdPresupuesto Int OUT,
@Presupuesto Varchar(20),
@Nombre Varchar(500),
@Iva Money,
@IdCiudad Int,
@IdCliente Int,
@Direccion Varchar(80),
@Colonia Varchar(30),
@Telefono Varchar(30),
@CodPost Varchar(6),
@Mail Varchar(50),
@Observaciones Varchar(8000),
@IdResponsable Int,
@Cargo Varchar(100),
@IdEmpresa Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @IdPresupuesto = 0
BEGIN
INSERT INTO PuPresupuestos (Presupuesto, Nombre, PorcentajeIVA, IdCiudad, IdCliente, Direccion, Colonia, Telefono, CodPost, Maiil, Observaciones,
IdResponsable, IdEmpresa, Cargo)
VALUES (@Presupuesto, @Nombre, @Iva, @IdCiudad, @IdCliente, @Direccion, @Colonia, @Telefono, @CodPost, @Mail, @Observaciones,
@IdResponsable, @IdEmpresa, @Cargo)
IF @@ROWCOUNT < 0
BEGIN
RAISERROR('Error al insertar el Presupuesto. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdPresupuesto = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuPresupuestos
SET Presupuesto = @Presupuesto, Nombre = @Nombre, IdCiudad = @IdCiudad, IdCliente = @IdCliente, Direccion = @Direccion, Colonia = @Colonia,
Telefono = @Telefono, CodPost = @CodPost, Maiil = @Mail, Observaciones = @Observaciones, IdResponsable = @IdResponsable,
IdEmpresa = @IdEmpresa, PorcentajeIVA = @Iva, Cargo = @Cargo
WHERE IdPresupuesto = @IdPresupuesto
END
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatProcedimientosCargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatProcedimientosCargaDatos] AS
SELECT IdProcedimiento, Procedimiento, DescripcionLarga
FROM PuProcedimientos
ORDER BY Procedimiento
GO
/****** Object:  StoredProcedure [dbo].[NeoCatProcedimientosControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 22-Julio-2009
---- Description:	Control de 3 puntos del catálogo de procedimientos
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatProcedimientosControl3Puntos]
@Procedimiento varchar(20),
@IdProcedimiento int
AS
IF  @Procedimiento IS NULL AND @IdProcedimiento = 0
SELECT IdProcedimiento, Procedimiento, DescripcionLarga
FROM PuProcedimientos
ORDER BY Procedimiento
ELSE IF @IdProcedimiento = 0 AND @Procedimiento IS NOT NULL
SELECT IdProcedimiento, Procedimiento, DescripcionLarga
FROM PuProcedimientos
WHERE Procedimiento = @Procedimiento
ELSE IF @IdProcedimiento > 0 AND @Procedimiento IS NULL
SELECT IdProcedimiento, Procedimiento, DescripcionLarga
FROM PuProcedimientos
WHERE IdProcedimiento = @IdProcedimiento
GO
/****** Object:  StoredProcedure [dbo].[NeoCatProcedimientosEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatProcedimientosEliminar]
@IdProcedimiento int
AS
DELETE FROM PuProcedimientos WHERE IdProcedimiento = @IdProcedimiento
GO
/****** Object:  StoredProcedure [dbo].[NeoCatProcedimientosGrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 02-Julio-2009
---- Description:	Graba y Actualiza el Catálogo de Procedimientos
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatProcedimientosGrabarActualizar]
@IdProcedimiento Int OutPut,
@Procedimiento Varchar(20),
@DescripcionLarga Varchar(8000)
AS
BEGIN
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @IdProcedimiento = 0
BEGIN
INSERT INTO PuProcedimientos ( Procedimiento, DescripcionLarga )
VALUES ( @Procedimiento, @DescripcionLarga )
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al Insertar el procedimiento. No se afectaron registros.', 16, 1)
RETURN
END
SET  @IdProcedimiento = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuProcedimientos
SET Procedimiento = @Procedimiento, DescripcionLarga = @DescripcionLarga
WHERE IdProcedimiento = @IdProcedimiento
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al actualizar el procedimiento. No se afectaron registros.', 16, 1)
RETURN
END
END
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatProveedoresCargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatProveedoresCargaDatos] AS
SELECT P.IdProveedor, P.Proveedor, C.Ciudad, P.RazonSocial, P.Rfc, P.Direccion, P.Colonia,
P.CodigoPostal, P.Telefono, P.Fax, P.Mail, P.Contacto, P.Observaciones, P.Celular,
P.PaginaWeb, P.ProveedorDefault
FROM PuProveedores P LEFT JOIN
PuCiudades C ON P.idCiudad = C.IdCiudad
ORDER BY P.Proveedor
GO
/****** Object:  StoredProcedure [dbo].[NeoCatProveedoresControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatProveedoresControl3Puntos]
@Proveedor varchar(20),
@IdProveedor int
AS
IF  @Proveedor IS NULL AND @IdProveedor = 0
SELECT P.IdProveedor, P.Proveedor, C.Ciudad, P.RazonSocial
FROM PuProveedores P LEFT JOIN
PuCiudades C ON P.idCiudad = C.IdCiudad
ORDER BY P.Proveedor
ELSE IF  @IdProveedor = 0 and @Proveedor is not null
SELECT P.IdProveedor, P.Proveedor, C.Ciudad, P.RazonSocial
FROM PuProveedores P LEFT JOIN
PuCiudades C ON P.idCiudad = C.IdCiudad
WHERE  P.Proveedor = @Proveedor
ELSE IF @IdProveedor > 0 and @Proveedor is null
SELECT P.IdProveedor, P.Proveedor, C.Ciudad, P.RazonSocial
FROM PuProveedores P LEFT JOIN
PuCiudades C ON P.idCiudad = C.IdCiudad
WHERE  P.IdProveedor = @IdProveedor
GO
/****** Object:  StoredProcedure [dbo].[NeoCatProveedoresEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Jose Luis Colin
-- Create date: 9-Junio-2009
-- Description:	Elimina un proveedor del catálogo de proveedores
-- =============================================
CREATE PROCEDURE [dbo].[NeoCatProveedoresEliminar]
@IdProveedor int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRY
DELETE FROM PuProveedores WHERE IdProveedor = @IdProveedor
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al eliminar el proveedor. No se afectaron registros.', 16, 1)
RETURN
END
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatProveedoresGrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 02-Julio-2009
---- Description:	Graba y Actualiza el Catálogo de Proveedores
---- =============================================
CREATE PROCEDURE [dbo].[NeoCatProveedoresGrabarActualizar]
@IdCiudad Int,
@IdProveedor Int OutPut,
@Proveedor Varchar(20),
@RazonSocial Varchar(122),
@Rfc Varchar(15),
@Direccion Varchar(80),
@Colonia Varchar(30),
@CodigoPostal Varchar(6),
@Telefono Varchar(40),
@Fax Varchar(40),
@Mail Varchar(100),
@Contacto Varchar(80),
@Observaciones Varchar(8000),
@Celular Varchar(40),
@PaginaWeb Varchar(80),
@ProveedorDefault bit
AS
BEGIN
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @IdProveedor = 0
BEGIN
INSERT INTO PuProveedores (Proveedor, IdCiudad, RazonSocial, Rfc, Direccion, Colonia, CodigoPostal,
Telefono, Fax, Mail, Contacto, Observaciones, Celular, PaginaWeb, ProveedorDefault)
VALUES (@Proveedor, @IdCiudad, @RazonSocial, @Rfc, @Direccion, @Colonia, @CodigoPostal,
@Telefono, @Fax, @Mail, @Contacto, @Observaciones, @Celular, @PaginaWeb, @ProveedorDefault)
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al Insertar el proveedor. No se afectaron registros.', 16, 1)
RETURN
END
SET  @IdProveedor = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuProveedores
SET Proveedor = @Proveedor, IdCiudad = @IdCiudad, RazonSocial = @RazonSocial, Rfc = @Rfc,
Direccion = @Direccion, Colonia = @Colonia, CodigoPostal = @CodigoPostal, Telefono = @Telefono,
Fax = @Fax, Mail = @Mail, Contacto = @Contacto, Observaciones = @Observaciones, Celular =@Celular,
PaginaWeb = @PaginaWeb, ProveedorDefault = @ProveedorDefault
WHERE IdProveedor = @IdProveedor
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al actualizar el proveedor. No se afectaron registros.', 16, 1)
RETURN
END
END
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatProveedoresLlenaRegistro]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatProveedoresLlenaRegistro]
@Proveedor varchar(20)
AS
SELECT ProveedorDefault, PaginaWeb, IdProveedor, Proveedor, idCiudad, RazonSocial, Rfc, Direccion, Colonia,
CodigoPostal, Telefono, Fax, Mail, Contacto, Observaciones, Celular
FROM   PuProveedores
WHERE Proveedor=@Proveedor
GO
/****** Object:  StoredProcedure [dbo].[NeoCatResponsableEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatResponsableEliminar]
@IdResponsable int
AS
DELETE FROM PuResponsables where IdResponsable = @IdResponsable
GO
/****** Object:  StoredProcedure [dbo].[NeoCatResponsableInsertaActualiza]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatResponsableInsertaActualiza]
@Responsable as varchar(20),
@Nombre as varchar(80),
@Cargo as varchar(100),
@Telefono as varchar(30),
@Mail as varchar(100),
@IdResponsable as int output
AS
IF @IdResponsable = 0
BEGIN
INSERT INTO PuResponsables (Responsable,Nombre,Cargo,Telefono,Mail) VALUES (@Responsable,@Nombre,@Cargo,@Telefono,@Mail)
SET @IdResponsable = @@IDENTITY
END
ELSE
UPDATE PuResponsables SET Responsable = @Responsable, Nombre = @Nombre,
Cargo = @Cargo,Telefono=@Telefono,Mail=@Mail Where
IdResponsable = @IdResponsable
GO
/****** Object:  StoredProcedure [dbo].[NeoCatResponsableObtieneDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatResponsableObtieneDatos]
@Responsable as varchar(20)
AS
SELECT IdResponsable,Responsable,Nombre,Cargo,Telefono,Mail
FROM PuResponsables WHERE Responsable = @Responsable
GO
/****** Object:  StoredProcedure [dbo].[NeoCatTiposInsumoCargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatTiposInsumoCargaDatos] AS
SELECT IdTipo, Descripcion
FROM PuTipoInsumos
ORDER BY IdTipo
GO
/****** Object:  StoredProcedure [dbo].[NeoCatTiposInsumoControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatTiposInsumoControl3Puntos]
@Descripcion varchar(40),
@IdTipo int
AS
IF  @Descripcion IS NULL AND @IdTipo = 0
BEGIN
SELECT IdTipo, Descripcion
FROM PuTipoInsumos
ORDER BY IdTipo
END
ELSE IF  @IdTipo = 0 and @Descripcion is not null
BEGIN
SELECT IdTipo, Descripcion
FROM PuTipoInsumos
WHERE Descripcion = @Descripcion
END
ELSE IF @IdTipo > 0 and @Descripcion is null
BEGIN
SELECT IdTipo, Descripcion
FROM PuTipoInsumos
WHERE IdTipo = @IdTipo
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCatTiposInsumosEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatTiposInsumosEliminar]
@IdTipo int
AS
DELETE FROM PuTipoInsumos WHERE IdTipo = @IdTipo
GO
/****** Object:  StoredProcedure [dbo].[NeoCatTiposInsumosGrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatTiposInsumosGrabarActualizar]
@Id int,
@IdTipo int,
@Descripcion varchar (40),
@Error int = 0
AS
BEGIN TRAN
IF @Id =0
BEGIN
INSERT INTO PuTipoInsumos ( IdTipo, Descripcion )  VALUES ( @IdTipo, @Descripcion )
SET @Error=@@Error
END
ELSE
BEGIN
--Se utiliza @IdTipoId ya que si se actualiza por ejemplo el tipo 2 por 3 @IdTipoId tendria el valor 2 y @IdTipo el valor 3
UPDATE PuTipoInsumos SET IdTipo = @IdTipo, Descripcion = @Descripcion
WHERE IdTipo = @Id
SET @Error=@@Error
END
IF @Error =0
COMMIT TRAN
ELSE
ROLLBACK TRAN
GO
/****** Object:  StoredProcedure [dbo].[NeoCatUnidadesCargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatUnidadesCargaDatos] AS
SELECT IdUnidad, Unidad, Descripcion
FROM PuUnidades
ORDER BY Unidad
GO
/****** Object:  StoredProcedure [dbo].[NeoCatUnidadesControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatUnidadesControl3Puntos]
@Unidad varchar(20),
@IdUnidad int
AS
IF  @Unidad IS NULL AND @IdUnidad = 0
SELECT IdUnidad, Unidad, Descripcion FROM PuUnidades ORDER BY Unidad
ELSE IF  @IdUnidad = 0 and @Unidad is not null
SELECT IdUnidad, Unidad, Descripcion FROM PuUnidades WHERE Unidad = @Unidad
ELSE IF @IdUnidad > 0 and @Unidad is null
SELECT IdUnidad, Unidad, Descripcion FROM PuUnidades WHERE IdUnidad = @IdUnidad
GO
/****** Object:  StoredProcedure [dbo].[NeoCatUnidadesEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCatUnidadesEliminar]
@IdUnidad int
AS
DELETE FROM PuUnidades WHERE IdUnidad = @IdUnidad
GO
/****** Object:  StoredProcedure [dbo].[NeoConceptos_AsignarAgrupador]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 5-Junio-2009
-- Description:	Asigna el Agrupador a un Concepto y
--              verifica que este no este asignado en otra partida del mismo presupuesto
-- =============================================
CREATE PROCEDURE [dbo].[NeoConceptos_AsignarAgrupador]
@IdPresupuestoConcepto AS Int,
@IdAgrupador AS Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @Partida AS VarChar(20),
@Error AS VarChar(200)
SELECT @Partida = PP.Partida
FROM PuPresupuestosConceptos PC INNER JOIN
PuPresupuestosPartidas AS PP ON PP.IdPresupuestoPartida = PC.IdPresupuestoPartida
WHERE PC.IdPresupuesto = (SELECT IdPresupuesto
FROM PuPresupuestosConceptos
WHERE IdPresupuestoConcepto = @IdPresupuestoConcepto)
AND PC.IdAgrupador = @IdAgrupador
AND PC.IdPresupuestopartida <> (SELECT IdPresupuestoPartida
FROM PuPresupuestosConceptos
WHERE IdPresupuestoConcepto = @IdPresupuestoConcepto)
-- Reviso si el Agrupador existe en otra partida del mismo presupuesto
IF @Partida IS NULL BEGIN
UPDATE PuPresupuestosConceptos
SET IdAgrupador = @IdAgrupador
WHERE IdPresupuestoConcepto = @IdPresupuestoConcepto
END ELSE BEGIN
SET @Error = 'El agrupador ya existe en la partida: ' + @Partida + '.'
RAISERROR(@Error, 16, 1)
RETURN
END
END
GO
/****** Object:  StoredProcedure [dbo].[NeoConceptos_CargaDatosGrid]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 26-Mayo-2009
-- Description:	Devuelve el DataTable con los Conceptos por Partida
--              opcionalmente filtra o marca los concepto por SqlLike
-- =============================================
CREATE PROCEDURE [dbo].[NeoConceptos_CargaDatosGrid]
@IdPresupuestoPartida AS Int,
@SqlLike AS VarChar(max),
@ExcluirRegistrosEnBusqueda AS Bit,
@IdMoneda AS Int,
@IdMoneda2 AS Int OUT,
@IdMoneda3 AS Int OUT,
@DescripcionMoneda2 AS VarChar(20) OUT,
@DescripcionMoneda3 AS VarChar(20) OUT
AS
DECLARE @Sql AS nVarChar(max),
@Decimales AS Int,
@IdPresupuesto AS Int
-- Obtengo el IdPresupuesto
SELECT @IdPresupuesto = IdPresupuesto FROM PuPresupuestosPartidas WHERE IdPresupuestoPartida = @IdPresupuestoPartida
-- Obtengo el Número de Decimales
EXEC @Decimales = NeoParametros_DecimalesRedondeo @IdPresupuesto = @IdPresupuesto
EXEC NeoMatrices_DameMonedasPresupuesto @IdPresupuesto, @IdMoneda, @IdMoneda2 OUT, @IdMoneda3 OUT
--EXEC @MostrarImagen = NeoParametros_Lee 'MostrarImagen','0', @IdPresupuesto
IF @SqlLike IS NULL BEGIN
SET @Sql = 'SELECT 0 AS MarcaBusqueda, PC.IdPresupuestoConcepto, PC.IdPresupuestoPartida, PC.IdExpIns, PC.Control,
CAST(0 AS Bit) AS Marca, PC.Renglon, EI.Nivel, C.Codigo, C2.Codigo AS Agrupador, C.DescripcionLarga,
C.Descripcion, C.EsPorcentaje, U.Unidad, C.IdTipo, PC.Cantidad, PC.CantidadTotal,
ROUND(COALESCE(EIC.Costo, 0), ' + CAST(@Decimales AS VarChar) + ') AS Costo, ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio, PC.Cantidad * ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe, PC.IndirectoEspecial,
PC.PorcentajeIndirectoEspecial, PC.CodigoAuxiliar, EI.EsCostoHorario,
PC.DescripcionAuxiliar, ET.EstimacionTipo, PC.RutaGenerador,
CASE WHEN PP.PrecioTotal = 0 THEN 0 ELSE (PC.CantidadTotal * ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ')) / PP.PrecioTotal END AS PorcentajeParticipacion,
EI.IdIntelimat, IM.EsNeodata, EI.PendienteAnalizar, I.Imagen '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += ', COALESCE(EIC2.Costo, 0) AS Costo2,
ROUND(COALESCE(PCP2.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio2, PC.CantidadTotal * ROUND(COALESCE(PCP2.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe2 '
SELECT @DescripcionMoneda2 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda2
IF @IdMoneda3 > 0 BEGIN
SET @Sql += ', COALESCE(EIC3.Costo, 0) AS Costo3,
ROUND(COALESCE(PCP3.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio3, PC.CantidadTotal * ROUND(COALESCE(PCP3.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe3 '
SELECT @DescripcionMoneda3 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda3
END
END
SET @Sql += 'FROM PuPresupuestosConceptos AS PC INNER JOIN
PuPresupuestos AS P ON P.IdPresupuesto = PC.IdPresupuesto INNER JOIN
PuExpIns AS EI ON PC.IdExpIns = EI.IdExpIns INNER JOIN
PuCatalogo AS C ON EI.IdCodigo = C.IdCodigo INNER JOIN
PuUnidades AS U ON C.Idunidad = U.Idunidad INNER JOIN
PuEstimacionesTipos AS ET ON ET.IdEstimacionTipo = PC.IdEstimacionTipo LEFT JOIN
PuCatalogo AS C2 ON PC.IdAgrupador = C2.IdCodigo LEFT JOIN
PuIntelimat AS IM ON IM.IdIntelimat = EI.IdIntelimat LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS EIC ON EIC.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PCP ON PCP.IdPresupuestoConcepto = PC.IdPresupuestoConcepto LEFT JOIN
(SELECT IdPresupuesto, PrecioTotal
FROM PuPresupuestosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PP ON PP.IdPresupuesto = P.IdPresupuesto LEFT JOIN
PuImagenes AS I ON I.IdImagen = C.IdImagen '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS EIC2 ON EIC2.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS PCP2 ON PCP2.IdPresupuestoConcepto = PC.IdPresupuestoConcepto '
IF @IdMoneda3 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS EIC3 ON EIC3.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS PCP3 ON PCP3.IdPresupuestoConcepto = PC.IdPresupuestoConcepto '
END
END
SET @Sql += 'WHERE PC.IdPresupuestoPartida = ' + CAST(@IdPresupuestoPartida AS VarChar) + '
ORDER BY PC.Renglon'
END ELSE BEGIN
IF @ExcluirRegistrosEnBusqueda = 1 BEGIN
SET @Sql = 'SELECT 1 AS MarcaBusqueda, PC.IdPresupuestoConcepto, PC.IdPresupuestoPartida,
PC.IdExpIns, PC.Control, CAST(0 AS Bit) AS Marca, PC.Renglon, EI.Nivel, C.Codigo, C2.Codigo AS Agrupador, C.DescripcionLarga,
C.Descripcion, C.EsPorcentaje, U.Unidad, C.IdTipo, PC.Cantidad, PC.CantidadTotal, ROUND(COALESCE(EIC.Costo, 0), ' + CAST(@Decimales AS VarChar) + ') AS Costo, ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio,
PC.Cantidad * ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe, PC.IndirectoEspecial, PC.PorcentajeIndirectoEspecial,
PC.CodigoAuxiliar, PC.DescripcionAuxiliar, ET.EstimacionTipo, PC.RutaGenerador, PC.CodigoAuxiliar, EI.EsCostoHorario,
CASE WHEN PP.PrecioTotal = 0 THEN 0 ELSE (PC.CantidadTotal * ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ')) / PP.PrecioTotal END AS PorcentajeParticipacion,
EI.IdIntelimat, IM.EsNeodata, I.Imagen, EI.PendienteAnalizar '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += ', COALESCE(EIC2.Costo, 0) AS Costo2,
ROUND(COALESCE(PCP2.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio2, PC.CantidadTotal * ROUND(COALESCE(PCP2.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe2 '
SELECT @DescripcionMoneda2 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda2
IF @IdMoneda3 > 0 BEGIN
SET @Sql += ', COALESCE(EIC3.Costo, 0) AS Costo3,
ROUND(COALESCE(PCP3.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio2, PC.CantidadTotal * ROUND(COALESCE(PCP3.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe3 '
SELECT @DescripcionMoneda3 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda3
END
END
SET @Sql += 'FROM PuPresupuestosConceptos AS PC INNER JOIN
PuPresupuestos AS P ON P.IdPresupuesto = PC.IdPresupuesto INNER JOIN
PuExpIns AS EI ON PC.IdExpIns = EI.IdExpIns INNER JOIN
PuCatalogo AS C ON EI.IdCodigo = C.IdCodigo INNER JOIN
PuUnidades AS U ON C.Idunidad = U.Idunidad INNER JOIN
PuEstimacionesTipos AS ET ON ET.IdEstimacionTipo = PC.IdEstimacionTipo LEFT JOIN
PuCatalogo AS C2 ON PC.IdAgrupador = C2.IdCodigo LEFT JOIN
PuIntelimat AS IM ON IM.IdIntelimat = EI.IdIntelimat LEFT JOIN
PuImagenes AS I ON I.IdImagen = C.IdImagen LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS EIC ON EIC.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PCP ON PCP.IdPresupuestoConcepto = PC.IdPresupuestoConcepto LEFT JOIN
(SELECT IdPresupuesto, PrecioTotal
FROM PuPresupuestosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PP ON PP.IdPresupuesto = P.IdPresupuesto '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS EIC2 ON EIC2.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS PCP2 ON PCP2.IdPresupuestoConcepto = PC.IdPresupuestoConcepto '
IF @IdMoneda3 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS EIC3 ON EIC3.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS PCP3 ON PCP3.IdPresupuestoConcepto = PC.IdPresupuestoConcepto '
END
END
SET @Sql += 'WHERE PC.IdPresupuestoPartida = ' + CAST(@IdPresupuestoPartida AS VarChar) + ' ' + @SqlLike + '
ORDER BY PC.Renglon '
END ELSE BEGIN
SET @Sql = 'SELECT COALESCE(M.MarcaBusqueda,0) AS MarcaBusqueda, PC.IdPresupuestoConcepto, PC.IdPresupuestoPartida,
PC.IdExpIns, PC.Control, CAST(0 AS Bit) AS Marca, PC.Renglon, EI.Nivel, C.Codigo, C2.Codigo AS Agrupador, C.DescripcionLarga,
C.Descripcion, C.EsPorcentaje, U.Unidad, C.IdTipo, PC.Cantidad, PC.CantidadTotal, ROUND(COALESCE(EIC.Costo, 0), ' + CAST(@Decimales AS VarChar) + ') AS Costo, ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio,
PC.Cantidad * ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe, PC.IndirectoEspecial, PC.PorcentajeIndirectoEspecial,
PC.CodigoAuxiliar, PC.DescripcionAuxiliar, ET.EstimacionTipo, PC.RutaGenerador, PC.CodigoAuxiliar, EI.EsCostoHorario,
CASE WHEN PP.PrecioTotal = 0 THEN 0 ELSE (PC.CantidadTotal * ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ')) / PP.PrecioTotal END AS PorcentajeParticipacion,
EI.IdIntelimat, IM.EsNeodata, I.Imagen, EI.PendienteAnalizar '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += ', COALESCE(EIC2.Costo, 0) AS Costo2,
ROUND(COALESCE(PCP2.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio2, PC.CantidadTotal * ROUND(COALESCE(PCP2.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe2 '
SELECT @DescripcionMoneda2 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda2
IF @IdMoneda3 > 0 BEGIN
SET @Sql += ', COALESCE(EIC3.Costo, 0) AS Costo3,
ROUND(COALESCE(PCP3.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio2, PC.CantidadTotal * ROUND(COALESCE(PCP3.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe3 '
SELECT @DescripcionMoneda3 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda3
END
END
SET @Sql += 'FROM PuPresupuestosConceptos AS PC INNER JOIN
PuPresupuestos AS P ON P.IdPresupuesto = PC.IdPresupuesto INNER JOIN
PuExpIns AS EI ON PC.IdExpIns = EI.IdExpIns INNER JOIN
PuCatalogo AS C ON EI.IdCodigo = C.IdCodigo INNER JOIN
PuUnidades AS U ON C.Idunidad = U.Idunidad INNER JOIN
PuEstimacionesTipos AS ET ON ET.IdEstimacionTipo = PC.IdEstimacionTipo LEFT JOIN
PuCatalogo AS C2 ON PC.IdAgrupador = C2.IdCodigo LEFT JOIN
PuIntelimat AS IM ON IM.IdIntelimat = EI.IdIntelimat LEFT JOIN
PuImagenes AS I ON I.IdImagen = C.IdImagen LEFT JOIN
(SELECT PC.IdPresupuestoConcepto, 1 AS MarcaBusqueda, C.Codigo
FROM PuPresupuestosConceptos AS PC INNER JOIN
PuExpIns AS EI ON PC.IdExpIns = EI.IdExpIns INNER JOIN
PuCatalogo AS C ON EI.IdCodigo = C.IdCodigo
WHERE PC.IdPresupuestoPartida = ' + CAST(@IdPresupuestoPartida AS VarChar)  + ' ' + @SqlLike + '
) AS M ON M.IdPresupuestoConcepto = PC.IdPresupuestoConcepto LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS EIC ON EIC.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PCP ON PCP.IdPresupuestoConcepto = PC.IdPresupuestoConcepto LEFT JOIN
(SELECT IdPresupuesto, PrecioTotal
FROM PuPresupuestosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PP ON PP.IdPresupuesto = P.IdPresupuesto '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS EIC2 ON EIC2.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS PCP2 ON PCP2.IdPresupuestoConcepto = PC.IdPresupuestoConcepto '
IF @IdMoneda3 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS EIC3 ON EIC3.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS PCP3 ON PCP3.IdPresupuestoConcepto = PC.IdPresupuestoConcepto '
END
END
SET @Sql += 'WHERE PC.IdPresupuestoPartida = ' + CAST(@IdPresupuestoPartida AS VarChar)  + '
ORDER BY PC.Renglon '
END
END
EXEC sp_executesql @Sql
GO
/****** Object:  StoredProcedure [dbo].[NeoConceptos_DameDatosInsumo]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 9-Junio-2009
-- Description:	Devuelve los datos de un Insumo incluyendo su costo si existe en ExpIns
-- =============================================
CREATE PROCEDURE [dbo].[NeoConceptos_DameDatosInsumo]
@IdPresupuesto AS Int,
@IdCodigo AS Int,
@IdMoneda AS Int
AS
BEGIN
SET NOCOUNT ON;
SELECT EI.IdExpIns, C.Codigo, C.Descripcion, C.DescripcionLarga, C.IdTipo, C.EsPorcentaje, U.Unidad,
COALESCE(EI.Costo,0) AS Costo, EI.EsCostoHorario, C.VolumenDefault
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad LEFT JOIN
(SELECT EI.IdExpIns, EI.IdCodigo, EIC.Costo, EI.EsCostoHorario
FROM PuExpIns AS EI LEFT JOIN
PuExpInsCostos AS EIC ON EIC.IdExpIns = EI.IdExpIns
WHERE EI.IdPresupuesto = @IdPresupuesto AND EI.IdCodigo = @IdCodigo AND IdMoneda = @IdMoneda) AS EI ON EI.IdCodigo = C.IdCodigo
WHERE C.IdCodigo = @IdCodigo
END
GO
/****** Object:  StoredProcedure [dbo].[NeoConceptos_Eliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 1-Junio-2009
-- Description:	Método para eliminar conceptos
-- =============================================
CREATE PROCEDURE [dbo].[NeoConceptos_Eliminar]
@IdPresupuestoConcepto AS Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF EXISTS(SELECT IdPresupuestoConcepto FROM PuContratosDet WHERE IdPresupuestoConcepto = @IdPresupuestoConcepto) BEGIN
RAISERROR('El concepto ya esta ligado a un contrato, imposible eliminar.', 16, 1)
RETURN
END
DELETE FROM PuLigasRuta
WHERE IdConceptoOrigen = (SELECT IdProgramaConcepto
FROM PuProgramaConceptos
WHERE IdPresupuestoConcepto = @IdPresupuestoConcepto) OR
IdConceptoDestino = (SELECT IdProgramaConcepto
FROM PuProgramaConceptos
WHERE IdPresupuestoConcepto = @IdPresupuestoConcepto)
DELETE FROM PuPresupuestosConceptos
WHERE IdPresupuestoConcepto = @IdPresupuestoConcepto
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al eliminar el concepto. No se afectaron registros', 16, 1)
RETURN
END
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoConceptos_GrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 27-May-2009
-- Description:	Procedimiento para Guardao /Actualizar Conceptos en Partidas
-- =============================================
CREATE PROCEDURE [dbo].[NeoConceptos_GrabarActualizar]
@IdPresupuesto AS Int,
@IdPresupuestoPartida AS Int,
@IdPresupuestoConcepto AS Int OUTPUT,
@IdCodigo AS Int,
@IdAgrupador AS Int,
@Renglon AS Int OUTPUT,
@IdProveedor AS Int,
@Costo AS Money,
@IdExpIns AS Int OUTPUT,
@Cantidad AS Decimal(18, 6),
@CodigoAuxiliar AS VarChar(40),
@DescripcionAuxiliar AS Text,
@IndirectoEspecial AS Bit,
@PorcentajeIndirectoEspecial AS  decimal(18,8),
@Precio AS Money,
@RutaGenerador AS VarChar(250),
@IdEstimacionTipo AS Int,
@Control AS Int OUTPUT,
@IdMoneda AS Int,
@Nivel AS SmallInt = 0,
@InsumoIntegrado AS Bit = 0,
@EsCostoHorario AS Bit = 0,
@IdInteliMat AS Integer,
@GrabarCosto AS Bit = 1,
@IdUsuario AS Int
AS BEGIN
SET NOCOUNT ON;
DECLARE @CostoActual AS Money,
@Error AS VarChar(1000),
@Severity  AS Int,
@State AS Int
BEGIN TRAN
BEGIN TRY
-- Reviso si el Agrupador existe en otra partida del mismo presupuesto
DECLARE @Partida AS VarChar(20)
SELECT @Partida = PP.Partida
FROM PuPresupuestosConceptos PC INNER JOIN
PuPresupuestosPartidas AS PP ON PP.IdPresupuestoPartida = PC.IdPresupuestoPartida
WHERE PC.IdPresupuesto = @IdPresupuesto
AND PC.IdAgrupador = @IdAgrupador
AND PC.IdPresupuestoPartida <> @IdPresupuestoPartida
IF @Partida IS NOT NULL BEGIN
SET @Error = 'El agrupador ya existe en la partida: ' + @Partida + '.'
RAISERROR(@Error, 16, 1)
RETURN
END
-- Reviso si el Insumo existe en ExpIns si no se inserta
IF @IdExpIns IS NULL BEGIN
SELECT @IdExpIns = IdExpIns FROM PuExpIns WHERE IdCodigo = @IdCodigo
IF @IdExpIns IS NULL
SET @IdExpIns = 0
END
IF @IdExpIns = 0 BEGIN
EXEC @IdExpIns = NeoExpIns_GrabarActualizar @IdExpIns = @IdExpIns, @IdPresupuesto = @IdPresupuesto, @IdCodigo = @IdCodigo, @Costo = @Costo,
@IdMoneda = @IdMoneda, @IdProveedor = @IdProveedor, @CostoFecha = NULL, @InsumoIntegrado = @InsumoIntegrado,
@EsCostoHorario = @EsCostoHorario, @IdInteliMat = @IdInteliMat, @IdUsuario = @IdUsuario
END ELSE BEGIN
IF @IdInteliMat IS NULL BEGIN
EXEC NeoExpIns_QuitarIntelimat @IdExpIns
END ELSE BEGIN
EXEC NeoExpIns_AsignarIntelimat @IdExpIns, @IdInteliMat
END
-- Actualizo EsCostoHorario
UPDATE PuExpIns
SET EsCostoHorario = @EsCostoHorario
WHERE IdExpIns = @IdExpIns
END
-- Actualizo el Costo
IF @GrabarCosto = 1 BEGIN
IF EXISTS(SELECT IdExpInsCosto FROM PuExpInsCostos WHERE IdExpIns = @IdExpIns AND IdMoneda = @IdMoneda ) BEGIN
-- Existe el costo para esta moneda entonces se actualiza
SELECT @CostoActual = Costo FROM PuExpInsCostos WHERE IdExpIns = @IdExpIns AND IdMoneda = @IdMoneda
IF @CostoActual IS NULL BEGIN
RAISERROR('Error al obtener el costo del concepto en ExpIns.', 16, 1)
RETURN
END
-- Revisa si el costo es diferente y lo actualiza
IF @Costo <> @CostoActual BEGIN
UPDATE PuExpInsCostos
SET Costo = @Costo, Fecha = GETDATE()
WHERE IdExpIns = @IdExpIns AND IdMoneda = @IdMoneda
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al actualizar Costo en ExpInsCostos.', 16, 1)
RETURN
END
EXEC NeoBitacoraCostos_GrabaBitacora @IdExpIns, @IdMoneda, @IdUsuario, @Costo
END
END ELSE BEGIN
-- No existe el costo en esta moneda asi que se inserta
INSERT INTO PuExpInsCostos ( IdExpIns, IdMoneda, Costo, Fecha )
VALUES ( @IdExpIns, @IdMoneda, @Costo, GetDate() )
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al insertar Costo en ExpInsCostos.', 16, 1)
RETURN
END
EXEC NeoBitacoraCostos_GrabaBitacora @IdExpIns, @IdMoneda, @IdUsuario, @Costo
END
END
-- Grabo/Actualizo el Concepto
IF @IdPresupuestoConcepto = 0 BEGIN
-- Calculo el campo Control
DECLARE @Tipo AS VarChar(100)
SET @Tipo = 'FolioControlConcepto'
EXEC @Control = NeoPresupuestoConsecutivo_DameSiguiente @Tipo, @IdPresupuesto
-- Si no se asignó renglon se calcula
IF @Renglon Is NULL BEGIN
SELECT @Renglon = MAX(Renglon) FROM PuPresupuestosConceptos WHERE IdPresupuestoPartida = @IdPresupuestoPartida
IF @Renglon IS NULL BEGIN
SET @Renglon = 10
END ELSE BEGIN
SET @Renglon = @Renglon + 10
END
END
-- Insertar
INSERT INTO PuPresupuestosConceptos ( IdPresupuesto, IdPresupuestoPartida, IdExpIns, IdAgrupador, Control,
Renglon, Cantidad, CodigoAuxiliar, DescripcionAuxiliar,
IndirectoEspecial,
PorcentajeIndirectoEspecial, RutaGenerador, IdEstimacionTipo )
VALUES ( @IdPresupuesto, @IdPresupuestoPartida, @IdExpIns, @IdAgrupador, @Control, @Renglon, @Cantidad,
@CodigoAuxiliar, @DescripcionAuxiliar, @IndirectoEspecial,
@PorcentajeIndirectoEspecial, @RutaGenerador, @IdEstimacionTipo )
SET @IdPresupuestoConcepto = @@IDENTITY
END ELSE BEGIN
-- Actualizar
UPDATE PuPresupuestosConceptos
SET IdExpIns = @IdExpIns, Renglon = @Renglon, Cantidad = @Cantidad, CodigoAuxiliar = @CodigoAuxiliar,
DescripcionAuxiliar = @DescripcionAuxiliar,
IndirectoEspecial = @IndirectoEspecial, PorcentajeIndirectoEspecial = @PorcentajeIndirectoEspecial,
RutaGenerador = @RutaGenerador, IdEstimacionTipo = @IdEstimacionTipo, IdAgrupador = @IdAgrupador
WHERE IdPresupuestoConcepto = @IdPresupuestoConcepto
END
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al Grabar/Actualizar. No se afectaron registros', 16, 1)
RETURN
END
-- Marca el presupuesto como Requiere Totalizar
UPDATE PuPresupuestos SET RequiereTotalizar = 1 WHERE IdPresupuesto = @IdPresupuesto AND RequiereTotalizar = 0
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Severity = ERROR_SEVERITY()
SET @State = ERROR_STATE()
SET @Error = ERROR_MESSAGE()
RAISERROR(@Error, @Severity, @State)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosActualizaComplementarios]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosActualizaComplementarios]
@IdFirma1 AS int,
@IdFirma2 as int,
@IdFirma3 as int,
@IdFirma4 as int,
@IdFirma5 AS int,
@IdFirma6 as int,
@IdFirma7 as int,
@IdFirma8 as int,
@Concepto1 as varchar(80),
@Concepto2 as varchar(80),
@Concepto3 as varchar(80),
@Concepto4 as varchar(80),
@Concepto5 as varchar(80),
@Concepto6 as varchar(80),
@Concepto7 as varchar(80),
@Concepto8 as varchar(80),
@LugarExpedicion as varchar(80),
@DocumentoLegal as varchar(200),
@Objeto as varchar(200),
@FianzaGarantia as varchar(20),
@Fianzacumplimiento as varchar(20),
@FianzaAnticipo as varchar(20),
@CapturarPorcentajeAnticipo as bit,
@PorcentajeAnticipo as decimal,
@Anticipo as decimal,
@CapturarPorcentajeFonGar as bit,
@FonGar as decimal,
@PorcentajeFonGar as decimal,
@PorcentajeIva as decimal,
@Iva as decimal,
@IdContrato as int
AS
UPDATE PuContratos SET IdFirma1 = @IdFirma1, IdFirma2 = @IdFirma2,
IdFirma3 = @IdFirma3, IdFirma4 = @IdFirma4, IdFirma5 = @IdFirma5
, IdFirma6 = @IdFirma6, IdFirma7 = @IdFirma7, IdFirma8 = @IdFirma8,
DocumentoLegal = @DocumentoLegal, Objeto = @Objeto, FianzaGarantia = @FianzaGarantia,
FianzaCumplimiento = @FianzaCumplimiento, FianzaAnticipo = @FianzaAnticipo,
CapturarPorcentajeAnticipo=@CapturarPorcentajeAnticipo, PorcentajeAnticipo = @PorcentajeAnticipo,
Anticipo = @Anticipo, CapturarPorcentajeFonGar = @CapturarPorcentajeFonGar,
FonGar = @FonGar, PorcentajeFonGar = @PorcentajeFonGar, PorcentajeIva = @PorcentajeIva, Iva =@Iva
,LugarDeExpedicion = @LugarExpedicion,Concepto1=@Concepto1,
Concepto2=@Concepto2,Concepto3=@Concepto3,Concepto4=@Concepto4,
Concepto5=@Concepto5,
Concepto6=@Concepto6,Concepto7=@Concepto7,Concepto8=@Concepto8
Where IdContrato = @IdContrato
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosActualizaInsertaConsecutivos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosActualizaInsertaConsecutivos]
@IdPresupuesto as int ,
@FolioContrato as int,
@IdContratista as int,
@IdPresup as int
AS
IF  @IdPresup = 0
INSERT INTO PuContratantesConsecutivos (FolioContrato,IdPresupuesto,Idcontratista) VALUES(@FolioContrato,@IdPresupuesto,@Idcontratista)
ELSE
UPDATE PuContratantesConsecutivos SET FolioContrato = @FolioContrato WHERE IdPresupuesto = @IdPresupuesto and IdContratista = @IdContratista
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosCantidadTope]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosCantidadTope]
@IdPresupuestoConcepto as int
AS
SELECT CantidadTotal FROM PuPresupuestosConceptos WHERE IdPresupuestoConcepto = @IdPresupuestoConcepto
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosCargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosCargaDatos]
@IdContrato as int
AS
SELECT  IdContrato, IdPresupuesto, FolioContrato, FolioAuxiliar,
idContratista, Fecha, Descripcion, CapturarPorcentajeAnticipo,
PorcentajeAnticipo, Anticipo, CapturarPorcentajeFonGar,
PorcentajeFonGar, FonGar, PorcentajeIVA, Iva, FechaInicial,
FechaFin, FianzaAnticipo, FianzaCumplimiento,
FianzaGarantia, ImporteSubcontrato, ImporteOrdenesCambio, Finiquitado,
idResidente, idFirma1, idFirma2, IdFirma3,IdFirma4,IdFirma5,IdFirma6,
IdFirma7,IdFirma8,LugardeExpedicion, DocumentoLegal,
Objeto, Autorizado, Cancelado, IdPlantillaContrato,
Concepto1,Concepto2,Concepto3,Concepto4,Concepto5,Concepto6,
Concepto7,Concepto8
FROM         PuContratos
WHERE IdContrato = @IdContrato
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosCargaDatosGrid]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosCargaDatosGrid]
@IdContrato as int
AS
SELECT PuPC.IdPresupuestoConcepto,PuConD.IdContratoDet,PuPC.Renglon,PuPC.Control,
PuET.Sigla, PuPP.Partida, PuC.Codigo, PuC.Descripcion,
PuConD.DescripcionLarga, PuU.Unidad, PUEI.IdExpIns,PuConD.Cantidad,
PuConD.Costo , round(PuConD.Cantidad*PuConD.Costo,2) as Importe
FROM PuExpIns AS PuEI INNER JOIN PuCatalogo as PuC ON PuEI.IdCodigo = PuC.IdCodigo INNER JOIN
PuPresupuestosConceptos as PuPC ON PuEI.IdExpIns = PuPC.IdExpIns
INNER JOIN PuEstimacionesTipos as PuET
ON PuPC.IdEstimacionTipo = PuET.IdEstimacionTipo INNER JOIN
PuContratos as PuCon INNER JOIN PuContratosDet as PuConD ON PuCon.IdContrato = PuConD.IdContrato
ON PuPC.IdPresupuestoConcepto = PuConD.IdPresupuestoConcepto INNER JOIN
PuPresupuestosPartidas as PuPP ON PuPC.IdPresupuestoPartida = PuPP.IdPresupuestoPartida INNER JOIN
PuUnidades as PuU ON PuC.IdUnidad = PuU.IdUnidad WHERE PuCon.IdContrato = @IdContrato
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosCargaEncabezado]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosCargaEncabezado]
@IdContrato as int
AS
SELECT FolioContrato,FolioAuxiliar,IdContratista,Fecha,Descripcion,FechaInicial,FechaFin,IdResidente,IdContratante
TipoCosto FROM PuContratos WHERE IdContrato = @IdContrato
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosCargaParidades]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosCargaParidades]
@IdContrato as int
AS
SELECT CM.IdContratoMoneda,M.Moneda,M.Descripcion,CM.Paridad, cast(1 as bit) as Marca,CM.IdMoneda
FROM PuContratosMonedas CM INNER JOIN PuMonedas M ON CM.IdMoneda = M.IdMoneda
WHERE CM.IdContrato = @IdContrato ORDER BY M.Moneda
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosCargaParidadesCatalogo]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosCargaParidadesCatalogo]
@IdContrato as int
AS
SELECT 0 as IdContratoMoneda,M.Moneda,M.Descripcion,M.ParidadContratos as Paridad,
cast(1 as bit) as Marca,M.IdMoneda FROM PuMonedas M ORDER BY M.Moneda
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosEliminar]
@IdContratoDet as int
AS
DELETE FROM PuContratosDet WHERE  IdContratoDet = @IdContratoDet
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosInsertaActualiza]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosInsertaActualiza]
@IdContrato as int output,
@IdPresupuesto as int,
@FolioContrato as int,
@FolioAuxiliar as varchar(30),
@IdContratista as int,
@Fecha as date,
@Descripcion as varchar(250),
@FechaInicial as date,
@FechaFinal as date,
@IdResidente as int,
@TipoCosto as int
AS
IF @IdContrato = 0
BEGIN
INSERT INTO PuContratos (IdPresupuesto,FolioContrato,FolioAuxiliar,IdContratista,Fecha,
Descripcion,FechaInicial,FechaFin,IdResidente,TipoCosto)
VALUES (@IdPresupuesto,@FolioContrato,@FolioAuxiliar,@IdContratista,@Fecha,
@Descripcion,@FechaInicial,@FechaFinal,@IdResidente,@TipoCosto)
SET  @IdContrato = @@IDENTITY
END
ELSE
UPDATE PuContratos SET IdPresupuesto = @IdPresupuesto, FolioContrato = @FolioContrato
,FolioAuxiliar = @FolioAuxiliar, IdContratista = @IdContratista,Fecha = @Fecha,
Descripcion = @Descripcion,FechaInicial = @FechaInicial, FechaFin = @FechaFinal,
IdResidente = @IdResidente,TipoCosto = @TipoCosto Where IdContrato = @IdContrato
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosInsertaActualizaDet]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosInsertaActualizaDet]
@IdContratoDet as int output ,
@IdContrato as int,
@IdPresupuestoConcepto as int,
@Cantidad as decimal,
@Costo as decimal,
@DescripcionLarga as varchar(500),
@Renglon as int
AS
If @IdContratoDet= 0
BEGIN
INSERT INTO PuContratosDet (IdContrato,IdPresupuestoConcepto,Cantidad,Costo,
DescripcionLarga,Renglon)VALUES (@IdContrato,@IdPresupuestoConcepto,
@Cantidad,@Costo,@DescripcionLarga,@Renglon)
SET @IdContratoDet = @@IDENTITY
END
Else
UPDATE PuContratosDet SET  IdContrato = @IdContrato, IdPresupuestoConcepto
= @IdPresupuestoConcepto, Cantidad = @Cantidad, Costo = @Costo,
DescripcionLarga=@DescripcionLarga,Renglon = @Renglon
Where IdContratoDet = @IdContratoDet
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosInsertaActualizaParidad]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosInsertaActualizaParidad]
@IdContratoMoneda as int output,
@IdContrato as int,
@IdMoneda as int,
@Paridad as decimal
AS
IF @IdContratoMoneda = 0
BEGIN
INSERT INTO PuContratosMonedas(IdContrato,IdMoneda,Paridad)
VALUES (@IdContrato,@IdMoneda,@Paridad)
SET  @IdContratoMoneda = @@IDENTITY
END
ELSE
UPDATE PuContratosMonedas SET  IdContrato = @IdContrato, IdMoneda = @IdMoneda,
Paridad = @Paridad WHERE IdContratoMoneda = @IdContratoMoneda
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosObtieneConsecutivo]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosObtieneConsecutivo]
@IdPresupuesto as int ,
@IdContratista as int
AS
SELECT coalesce(MAX(FolioContrato),0)+1 FROM PuContratantesConsecutivos where idPresupuesto = @idPresupuesto  and IdContratista = @idContratista
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosObtieneDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosObtieneDatos]
@IdCodigo as int ,
@IdContratoDet as int
AS
SELECT PuPC.IdPresupuestoconcepto,PuConD.IdContratoDet, PuET.Sigla, PuPP.Partida, PuC.Codigo,
PuC.Descripcion,PUPC.Renglon,PUPC.Control,PuConD.DescripcionLarga, PuU.Unidad,
PuConD.Cantidad, PuConD.Costo , round(PuConD.Cantidad*PuConD.Costo,2) as Importe
FROM PuExpIns AS PuEI INNER JOIN PuCatalogo as PuC ON PuEI.IdCodigo = PuC.IdCodigo INNER JOIN
PuPresupuestosConceptos as PuPC ON PuEI.IdExpIns = PuPC.IdExpIns AND
PuC.IdCodigo = PuPC.IdAgrupador INNER JOIN PuEstimacionesTipos as PuET
ON PuPC.IdEstimacionTipo = PuET.IdEstimacionTipo INNER JOIN
PuContratos as PuCon INNER JOIN PuContratosDet as PuConD ON PuCon.IdContrato = PuConD.IdContrato
ON PuPC.IdPresupuestoConcepto = PuConD.IdPresupuestoConcepto INNER JOIN
PuPresupuestosPartidas as PuPP ON PuPC.IdPresupuestoPartida = PuPP.IdPresupuestoPartida INNER JOIN
PuUnidades as PuU ON PuC.IdUnidad = PuU.IdUnidad WHERE PuConD.IdContratoDet = @IdContratoDet
and PUC.IdCodigo = @IdCodigo
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosObtieneIdyContrato]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosObtieneIdyContrato]
@EsId as bit,
@Contrato as int
AS
IF @EsId=1
SELECT IdContrato FROM PuContratos Where FolioContrato = @Contrato
ELSE
SELECT FolioContrato FROM PuContratos Where IdContrato = @Contrato
GO
/****** Object:  StoredProcedure [dbo].[NeoContratosObtieneParidadMonedas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoContratosObtieneParidadMonedas]
@Moneda as int
AS
SELECT ParidadContratos as Paridad from PuMonedas where Moneda = @Moneda
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorario_GrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 24-Junio-2009
---- Description:	Graba y Actualiza Costos Horarios
---- =============================================
CREATE PROCEDURE [dbo].[NeoCostoHorario_GrabarActualizar]
@IdCostoHorario Int OutPut,
@CostoTotalEquipo Money,
@IdMoneda Int,
@IdPresupuesto Int,
@IdExpIns Int,
@IdExpInsCF Int,
@IdCatalogoCF Int,
@CostoCF Money,
@IdExpInsVa Int,
@IdCatalogoVA Int,
@CostoVA Money,
@IdExpInsLla Int,
@IdCatalogoLLa Int,
@CostoLL Money,
@IdExpInsComb Int,
@IdCatalogoComb Int,
@CostoCombustible Money,
@IdExpInsAcei Int,
@IdCatalogoLubricante Int,
@CostoLubricante Money,
@IdExpInsOtrasFuentes Int,
@IdCatalogoOtrasFuentes Int,
@CostoOtrasF Money,
@IdExpInsPza Int,
@IdCatalogoPza Int,
@CostoPzsEsp Money,
@IdExpinsE Int,
@IdCatalogoEspera Int,
@CostoEspera Money,
@IdExpinsR Int,
@IdCatalogoReserva Int,
@CostoReserva Money,
@foper Decimal(18, 10),
@potencia Decimal(18, 10),
@ve Int,
@ha Int,
@vr decimal(18, 10),
@s decimal(18, 10),
@q decimal(18, 10),
@TasaInteres decimal(18, 10),
@factcomb decimal(18, 10),
@ccarter decimal(18, 10),
@horasc Int,
@faceite decimal(18, 10),
@hllantas Int,
@hPiezas Int,
@NumSerie Varchar(20),
@Capacidad Varchar(25),
@ValorComercial Money,
@Disponibilidad Varchar(1),
@Modelo Varchar(25),
@Ubicacion Varchar(25),
@Marca Varchar(25),
@factFuentes decimal(18, 10),
@UnidadPotencia Varchar(5),
@Propietario Varchar(80),
@VidaUtil Varchar(25),
@TipoCombustible SmallInt,
@CalculoDetallado Bit,
@CantidadCombustible Decimal(18, 10),
@CantidadLubricante Decimal(18, 10),
@ProponerCodigos Bit
AS
BEGIN
SET NOCOUNT ON;
DECLARE @IdCostoHorarioTI Int,
@NecesitaRoll Bit = 1,
@Id Int,
@IdMatriz Int,
@IdExpInsCosto Int,
@RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
SELECT @IdMatriz = IdCodigoMatriz FROM PuMatrices WHERE IdCodigoMatriz = @IdExpIns
SET @IdMatriz = COALESCE(@IdMatriz,0)
--Valida si el equipo tiene matriz antes de grabarlo como Costsos Horarios
IF @IdMatriz > 0
BEGIN
SELECT @Id = IdCostoHorario FROM PuCostosHorarios WHERE IdExpIns = @IdExpIns
SET @Id = COALESCE(@Id,0)
--Revisa si ya se grabo en la tabla de costos horarios, si es asi se elimina
IF @Id > 0 	BEGIN  DELETE PuCostosHorarios WHERE IdExpIns = @IdExpIns END
--Se actualiza el campo de EsCosto horario
UPDATE PuExpIns SET EsCostoHorario = 0 WHERE  IdExpIns = @IdExpIns
COMMIT TRAN
SET @NecesitaRoll = 0
--Envia el mensaje de error
RAISERROR('El equipo que desea grabar ya tiene una matriz, no puede grabar el análisis de Costo Horario.', 16, 1)
RETURN
END
ELSE
BEGIN
--Se actualiza el campo de EsCosto horario
UPDATE PuExpIns SET EsCostoHorario = 1 WHERE  IdExpIns = @IdExpIns
END
-- SI NO EXISTE EN PUEXPINS SE INSERTA PARA EL EQUIPO EN ESPERA
-- SI TIENE COSTO MAYOR A CERO SE AGREGA O ACTUALIZA
IF NOT @IdExpinsE IS NULL
BEGIN
IF @IdExpinsE = 0
BEGIN
EXEC @IdExpinsE = NeoPresupuestoEquiposInsertaExpIns @IdPresupuesto, @IdCatalogoEspera
END
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos AS E INNER JOIN
PuMonedas AS M ON E.IdMoneda = M.IdMoneda
WHERE E.IdExpIns  = @IdExpinsE AND M.IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE (@IdExpInsCosto,0)
EXEC NeoExpInsCostos_GrabarActualizar @IdExpinsE, @IdMoneda, @CostoEspera
END
SET @IdExpInsCosto = 0
-- SI NO EXISTE EN PUEXPINS SE INSERTA PARA EL EQUIPO EN RESERVA
-- SI TIENE COSTO MAYOR A CERO SE AGREGA O ACTUALIZA
IF NOT @IdExpinsR IS NULL
BEGIN
IF @IdExpinsR = 0
BEGIN
EXEC @IdExpinsR = NeoPresupuestoEquiposInsertaExpIns @IdPresupuesto, @IdCatalogoReserva
END
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos AS E INNER JOIN
PuMonedas AS M ON E.IdMoneda = M.IdMoneda
WHERE E.IdExpIns  = @IdExpinsR AND M.IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE (@IdExpInsCosto,0)
EXEC NeoExpInsCostos_GrabarActualizar @IdExpinsR, @IdMoneda, @CostoReserva
END
SET @IdExpInsCosto = 0
-- SI NO EXISTE EN PUEXPINS SE INSERTA PARA EL EQUIPO
-- SI TIENE COSTO MAYOR A CERO SE AGREGA O ACTUALIZA
IF NOT @IdExpInsVa IS NULL
BEGIN
IF @IdExpInsVa = 0
BEGIN
EXEC @IdExpInsVa = NeoPresupuestoEquiposInsertaExpIns @IdPresupuesto, @IdCatalogoVA
END
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos AS E INNER JOIN
PuMonedas AS M ON E.IdMoneda = M.IdMoneda
WHERE E.IdExpIns  = @IdExpInsVa AND M.IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE (@IdExpInsCosto,0)
EXEC NeoExpInsCostos_GrabarActualizar  @IdExpInsVa, @IdMoneda, @CostoVA
END
SET @IdExpInsCosto = 0
-- SI NO EXISTE EN PUEXPINS SE INSERTA PARA EL EQUIPO
-- SI TIENE COSTO MAYOR A CERO SE AGREGA O ACTUALIZA
IF NOT @IdExpInsCF IS NULL
BEGIN
IF @IdExpInsCF = 0
BEGIN
EXEC @IdExpInsCF = NeoPresupuestoEquiposInsertaExpIns @IdPresupuesto, @IdCatalogoCF
END
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos AS E INNER JOIN
PuMonedas AS M ON E.IdMoneda = M.IdMoneda
WHERE E.IdExpIns  = @IdExpInsCF AND M.IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE (@IdExpInsCosto,0)
EXEC NeoExpInsCostos_GrabarActualizar  @IdExpInsCF	, @IdMoneda, @CostoCF
END
SET @IdExpInsCosto = 0
-- SI NO EXISTE EN PUEXPINS SE INSERTA PARA LAS LLANTAS
-- SI TIENE COSTO MAYOR A CERO SE AGREGA O ACTUALIZA
IF NOT @IdExpInsLla IS NULL
BEGIN
IF @IdExpInsLla = 0
BEGIN
EXEC @IdExpInsLla = NeoPresupuestoEquiposInsertaExpIns @IdPresupuesto, @IdCatalogoLLa
END
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos AS E INNER JOIN
PuMonedas AS M ON E.IdMoneda = M.IdMoneda
WHERE E.IdExpIns  = @IdExpInsLla AND M.IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE (@IdExpInsCosto,0)
EXEC NeoExpInsCostos_GrabarActualizar  @IdExpInsLla, @IdMoneda, @CostoLL
END
SET @IdExpInsCosto = 0
-- SI NO EXISTE EN PUEXPINS SE INSERTA PARA LAS PIEZAS ESPECIALES
-- SI TIENE COSTO MAYOR A CERO SE AGREGA O ACTUALIZA
IF NOT @IdExpInsPza IS NULL
BEGIN
IF @IdExpInsPza = 0
BEGIN
EXEC @IdExpInsPza = NeoPresupuestoEquiposInsertaExpIns @IdPresupuesto, @IdCatalogoPza
END
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos AS E INNER JOIN
PuMonedas AS M ON E.IdMoneda = M.IdMoneda
WHERE E.IdExpIns  = @IdExpInsPza AND M.IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE (@IdExpInsCosto,0)
EXEC NeoExpInsCostos_GrabarActualizar  @IdExpInsPza, @IdMoneda, @CostoPzsEsp
END
SET @IdExpInsCosto = 0
-- SI NO EXISTE EN PUEXPINS SE INSERTA PARA EL COMBUSTIBLE
-- SI TIENE COSTO MAYOR A CERO SE AGREGA O ACTUALIZA
IF NOT @IdExpInsComb IS NULL
BEGIN
IF @IdExpInsComb = 0
BEGIN
EXEC @IdExpInsComb = NeoPresupuestoEquiposInsertaExpIns @IdPresupuesto, @IdCatalogoComb
END
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos AS E INNER JOIN
PuMonedas AS M ON E.IdMoneda = M.IdMoneda
WHERE E.IdExpIns  = @IdExpInsComb AND M.IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE (@IdExpInsCosto,0)
EXEC NeoExpInsCostos_GrabarActualizar  @IdExpInsComb, @IdMoneda, @CostoCombustible
END
SET @IdExpInsCosto = 0
-- SI NO EXISTE EN PUEXPINS SE INSERTA PARA EL LUBRICANTE
-- SI TIENE COSTO MAYOR A CERO SE AGREGA O ACTUALIZA
IF NOT @IdExpInsAcei IS NULL
BEGIN
IF @IdExpInsAcei = 0
BEGIN
EXEC @IdExpInsAcei = NeoPresupuestoEquiposInsertaExpIns @IdPresupuesto, @IdCatalogoLubricante
END
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos AS E INNER JOIN
PuMonedas AS M ON E.IdMoneda = M.IdMoneda
WHERE E.IdExpIns  = @IdExpInsAcei AND M.IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE (@IdExpInsCosto,0)
EXEC NeoExpInsCostos_GrabarActualizar  @IdExpInsAcei, @IdMoneda, @CostoLubricante
END
SET @IdExpInsCosto = 0
-- SI NO EXISTE EN PUEXPINS SE INSERTA PARA OTRAS FUENTES
-- SI TIENE COSTO MAYOR A CERO SE AGREGA O ACTUALIZA
IF NOT @IdExpInsOtrasFuentes IS NULL
BEGIN
IF @IdExpInsOtrasFuentes = 0
BEGIN
EXEC @IdExpInsOtrasFuentes = NeoPresupuestoEquiposInsertaExpIns @IdPresupuesto, @IdCatalogoOtrasFuentes
END
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos AS E INNER JOIN
PuMonedas AS M ON E.IdMoneda = M.IdMoneda
WHERE E.IdExpIns  = @IdExpInsAcei AND M.IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE (@IdExpInsOtrasFuentes,0)
EXEC NeoExpInsCostos_GrabarActualizar  @IdExpInsOtrasFuentes, @IdMoneda, @CostoOtrasF
END
SET @IdExpInsCosto = 0
--SE ACTUALIA O SE INSERTA EL COSTO HORARIO
IF @IdCostoHorario = 0
BEGIN
INSERT INTO PuCostosHorarios (
IdExpIns, IdExpInsCF, IdExpInsVa, IdExpInsLla, IdExpInsComb, IdExpInsAcei, IdExpInsOtrasFuentes,
IdExpInsPza, IdExpinsE, IdExpinsR, foper, potencia, ve, ha, vr, s, q,
factcomb, ccarter, horasc, faceite, hllantas, CantidadCombustible, CantidadLubricante,
hPiezas, NumSerie, Capacidad, VidaUtil, ValorComercial, Disponibilidad, Modelo,
Ubicacion, Marca, factFuentes, UnidadPotencia, Propietario, TipoCombustible, CalculoDetallado, ProponerCodigos )
VALUES ( @IdExpIns, @IdExpInsCF, @IdExpInsVa, @IdExpInsLla, @IdExpInsComb, @IdExpInsAcei, @IdExpInsOtrasFuentes,
@IdExpInsPza, @IdExpinsE, @IdExpinsR, @foper, @potencia, @ve, @ha, @vr, @s, @q,
@factcomb, @ccarter, @horasc, @faceite, @hllantas, @CantidadCombustible, @CantidadLubricante,
@hPiezas, @NumSerie, @Capacidad, @VidaUtil, @ValorComercial, @Disponibilidad, @Modelo,
@Ubicacion, @Marca, @factFuentes, @UnidadPotencia, @Propietario, @TipoCombustible, @CalculoDetallado, @ProponerCodigos )
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al insertar el insumo en ExpIns. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdCostoHorario = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuCostosHorarios
SET IdExpInsVa = @IdExpInsVa, IdExpInsLla = @IdExpInsLla, IdExpInsCF = @IdExpInsCF,
IdExpInsComb = @IdExpInsComb, IdExpInsAcei = @IdExpInsAcei, IdExpInsOtrasFuentes = @IdExpInsOtrasFuentes,
IdExpInsPza = @IdExpInsPza, IdExpinsE = @IdExpinsE, IdExpinsR = @IdExpinsR, foper = @foper,
potencia = @potencia, ve = @ve, ha = @ha, vr = @vr, s = @s, q = @q,
factcomb = @factcomb, ccarter = @ccarter, horasc = @horasc,
faceite = @faceite, hllantas = @hllantas, hPiezas = @hPiezas, NumSerie = @NumSerie,
Capacidad = @Capacidad, VidaUtil = @VidaUtil, ValorComercial = @ValorComercial,
Disponibilidad = @Disponibilidad, Modelo = @Modelo, Ubicacion = @Ubicacion, Marca = @Marca,
factFuentes = @factFuentes, UnidadPotencia = @UnidadPotencia,
Propietario = @Propietario, TipoCombustible = @TipoCombustible, CalculoDetallado = @CalculoDetallado,
CantidadCombustible = @CantidadCombustible, CantidadLubricante = @CantidadLubricante, ProponerCodigos = @ProponerCodigos
WHERE IdCostoHorario = @IdCostoHorario
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al Actualizar el insumo en PuCostosHorariosMO. No se afectaron registros.', 16, 1)
RETURN
END
END
-- ACTUALIZA EL COSTO TOTAL DEL EQUIPO
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos AS E INNER JOIN
PuMonedas AS M ON E.IdMoneda = M.IdMoneda
WHERE E.IdExpIns  = @IdExpIns AND M.IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE (@IdExpInsCosto,0)
EXEC NeoExpInsCostos_GrabarActualizar  @IdExpIns, @IdMoneda, @CostoTotalEquipo
--SE ACTUALIZA O SE INSERTA LA TASA DE INTERES
SELECT @IdCostoHorarioTI = IdCostoHorarioTI
FROM PUCOSTOSHORARIOSTI AS TI
WHERE IdCostoHorario = @IdCostoHorario AND IdMoneda = @IdMoneda
SET @IdCostoHorarioTI = COALESCE(@IdCostoHorarioTI,0)
IF @IdCostoHorarioTI <= 0
BEGIN
INSERT INTO PuCostosHorariosTI ( TasaInteres, IdCostoHorario, IdMoneda )
VALUES (@TasaInteres, @IdCostoHorario, @IdMoneda )
END
ELSE
BEGIN
UPDATE PuCostosHorariosTI
SET TasaInteres = @TasaInteres
WHERE IdMoneda = @IdMoneda AND IdCostoHorario = @IdCostoHorario
END
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
IF @NecesitaRoll = 1 BEGIN 	ROLLBACK TRAN END
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorarioActualizarCatGeneral]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[NeoCostoHorarioActualizarCatGeneral]
@IdCodigo int,
@Codigo varchar(20),
@IdUnidad int,
@Descripcion varchar(40)
AS
UPDATE PuCatalogo SET Codigo = @Codigo, IdUnidad = @IdUnidad, Descripcion = @Descripcion
WHERE IdCodigo = @IdCodigo
RETURN @@ROWCOUNT
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorarioDameEquipos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín
-- Create date: 16-Julio-2009
-- Description:	Carga todos los Equipos de un presupuesto
-- =============================================
CREATE PROCEDURE [dbo].[NeoCostoHorarioDameEquipos]
@IdPresupuesto Int,
@IdMoneda1 Int,
@IdMoneda2 Int
AS
BEGIN
SELECT CH.IdCostoHorario, EEQ.IdPresupuesto, EEQ.IdExpIns, CEQ.Codigo AS CodigoEQ, CEQ.Descripcion AS DescripcionEQ, CH.UnidadPotencia,
--DATOS DEL VALOR DE ADQUISICION
DTVA.Codigo AS CodigoVA, DTVA.Descripcion AS DescripcionVA, DTVA.DescripcionLarga AS DescripcionLargaVA,
DTVA.Unidad AS UnidadVA, DTVA.IdTipo AS TipoVA,	DTVA.CostoVA1, DTVA.CostoVA2,
COALESCE(CH.IdExpInsVa,0 ) AS IdExpInsVa, COALESCE(CVA.IdCodigo,0) As IdCodigoVA,
--DATOS DEL COSTO EN ESPERA
DTCE.Codigo AS CodigoE, DTCE.Descripcion AS DescripcionE, DTCE.DescripcionLarga AS DescripcionLargaE,
DTCE.Unidad AS UnidadE, DTCE.IdTipo AS TipoE,	DTCE.CostoE1, DTCE.CostoE2,
COALESCE(CH.IdExpInsE,0) AS IdExpInsE, COALESCE(CE.IdCodigo,0) As IdCodigoE,
--DATOS DEL COSTO EN RESERVA
DTCR.Codigo AS CodigoR, DTCR.Descripcion AS DescripcionR, DTCR.DescripcionLarga as DescripcionLargaR,
DTCR.Unidad AS UnidadR, DTCR.IdTipo AS TipoR,	DTCR.CostoR1, DTCR.CostoR2,
COALESCE(CH.IdExpInsR,0) AS IdExpInsR, COALESCE(CR.IdCodigo,0) As IdCodigoR,
--DATOS DE LAS LLANTAS
DTLL.Codigo AS CodigoLl, DTLL.Descripcion AS DescripcionLl, DTLL.DescripcionLarga AS DescripcionLargaLl,
DTLL.Unidad AS UnidadLl, DTLL.IdTipo AS TipoLl,	DTLL.CostoLL1, DTLL.CostoLL2,
COALESCE(CH.IdExpInsLla,0) AS IdExpInsLla, COALESCE(CLL.IdCodigo,0) As IdCodigoLla,
--DATOS DEL COMBUSTIBLE
DTCB.Codigo AS CodigoCB, DTCB.Descripcion AS DescripcionCB, DTCB.DescripcionLarga AS DescripcionLargaCB,
DTCB.Unidad AS UnidadCB, DTCB.IdTipo AS TipoCB,	DTCB.CostoCB1, DTCB.CostoCB2,
COALESCE(CH.IdExpInsComb,0) AS IdExpInsComb, COALESCE(CCB.IdCodigo,0)  As IdCodigoComb,
--DATOS DEL LUBRICANTE
DTAC.Codigo AS CodigoAC, DTAC.Descripcion AS DescripcionAC, DTAC.DescripcionLarga AS DescripcionLargaAC,
DTAC.Unidad AS UnidadAC, DTAC.IdTipo AS TipoAC,	DTAC.CostoAC1, DTAC.CostoAC2,
COALESCE(CH.IdExpInsAcei,0) AS IdExpInsAcei, COALESCE(CA.IdCodigo,0) As IdCodigoAceite,
--DATOS DEL OTRAS FUENTES DE ENERGIA
DTOF.Codigo AS CodigoOF, DTOF.Descripcion AS DescripcionOF, DTOF.DescripcionLarga AS DescripcionLargaOF,
DTOF.Unidad AS UnidadOF, DTOF.IdTipo AS TipoOF,	DTOF.CostoOF1, DTOF.CostoOF2,
COALESCE(CH.IdExpInsOtrasFuentes,0) AS IdExpInsOtrasFuentes, COALESCE(COF.IdCodigo,0) As IdCodigoOtrasFts,
--DATOS DE PIEZAS ESPECIALES
DTPE.Codigo AS CodigoPE, DTPE.Descripcion AS DescripcionPE, DTPE.DescripcionLarga AS DescripcionLargaPE,
DTPE.Unidad AS UnidadPE, DTPE.IdTipo AS TipoPE,	DTPE.CostoPE1, DTPE.CostoPE2,
COALESCE(CH.IdExpInsPza,0) AS IdExpInsPza, COALESCE(CP.IdCodigo,0) As IdCodigoPzs,
--FACTORES GENERALES
CH.faceite, CH.factcomb, CH.factFuentes, CH.hllantas, CH.hPiezas, CH.UnidadPotencia, CH.foper, CH.potencia, CH.ccarter, CH.horasc,
CH.ve, CH.ha, CH.vr, CH.s, CH.q, CH.NumSerie, CH.Capacidad, COALESCE(TI.TasaInteres,0) AS TasaInteres,
CH.VidaUtil,CH.Disponibilidad, CH.Modelo, CH.Ubicacion, CH.Marca, CH.ValorComercial, CH.Propietario,
CH.TipoCombustible, CH.CalculoDetallado, CH.CantidadCombustible, CH.CantidadLubricante
FROM PuCostosHorarios AS CH INNER JOIN
--EQUIPO
PuExpIns AS EEQ ON CH.IdExpIns = EEQ.IdExpIns INNER JOIN
PuCatalogo AS CEQ ON CEQ.IdCodigo = EEQ.IdCodigo LEFT JOIN
--TASA DE INTERES
(SELECT TI.TasaInteres, TI.IdCostoHorario
FROM PuCostosHorariosTI AS TI
WHERE TI.IdMoneda = @IdMoneda1) AS TI ON TI.IdCostoHorario = CH.IdCostoHorario LEFT JOIN
--VALOR DE ADQUISICION
PuExpIns AS EVA ON CH.IdExpInsVa = EVA.IdExpIns LEFT JOIN
PuCatalogo AS CVA ON CVA.IdCodigo = EVA.IdCodigo LEFT JOIN
(SELECT E.IdExpIns, C.Codigo, C.Descripcion, C.DescripcionLarga, U.Unidad, C.IdTipo,
EC1.Costo AS CostoVA1, EC2.Costo AS CostoVA2
FROM PuCatalogo C INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad LEFT JOIN
PuExpIns E ON E.IdCodigo = C.IdCodigo LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda1 ) EC1 ON EC1.IdExpIns = E.IdExpIns LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda2 ) EC2 ON EC2.IdExpIns = E.IdExpIns
WHERE IdPresupuesto = @IdPresupuesto ) AS DTVA ON DTVA.IdExpIns = CH.IdExpInsVa LEFT JOIN
--EQUIPO EN ESPERA
PuExpIns AS EE ON CH.IdExpInsE = EE.IdExpIns LEFT JOIN
PuCatalogo AS CE ON CE.IdCodigo = EE.IdCodigo LEFT JOIN
(SELECT E.IdExpIns, C.Codigo, C.Descripcion, C.DescripcionLarga, U.Unidad, C.IdTipo,
EC1.Costo AS CostoE1, EC2.Costo AS CostoE2
FROM PuCatalogo C INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad LEFT JOIN
PuExpIns E ON E.IdCodigo = C.IdCodigo LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda1 ) EC1 ON EC1.IdExpIns = E.IdExpIns LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda2 ) EC2 ON EC2.IdExpIns = E.IdExpIns
WHERE IdPresupuesto = @IdPresupuesto ) AS DTCE ON DTCE.IdExpIns = CH.IdExpInsE LEFT JOIN
--EQUIPO EN RESERVA
PuExpIns AS ER ON CH.IdExpInsR = ER.IdExpIns LEFT JOIN
PuCatalogo AS CR ON CR.IdCodigo = ER.IdCodigo LEFT JOIN
(SELECT E.IdExpIns, C.Codigo, C.Descripcion, C.DescripcionLarga, U.Unidad, C.IdTipo,
EC1.Costo AS CostoR1, EC2.Costo AS CostoR2
FROM PuCatalogo C INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad LEFT JOIN
PuExpIns E ON E.IdCodigo = C.IdCodigo LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda1 ) EC1 ON EC1.IdExpIns = E.IdExpIns LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda2 ) EC2 ON EC2.IdExpIns = E.IdExpIns
WHERE IdPresupuesto = @IdPresupuesto ) AS DTCR ON DTCR.IdExpIns = CH.IdExpInsR LEFT JOIN
--LLANTAS
PuExpIns AS ELL ON CH.IdExpInsLla = ELL.IdExpIns LEFT JOIN
PuCatalogo AS CLL ON CLL.IdCodigo = ELL.IdCodigo LEFT JOIN
(SELECT E.IdExpIns, C.Codigo, C.Descripcion, C.DescripcionLarga, U.Unidad, C.IdTipo,
EC1.Costo AS CostoLL1, EC2.Costo AS CostoLL2
FROM PuCatalogo C INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad LEFT JOIN
PuExpIns E ON E.IdCodigo = C.IdCodigo LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda1 ) EC1 ON EC1.IdExpIns = E.IdExpIns LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda2 ) EC2 ON EC2.IdExpIns = E.IdExpIns
WHERE IdPresupuesto = @IdPresupuesto) AS DTLL ON DTLL.IdExpIns = CH.IdExpInsLla LEFT JOIN
--COMBUSTIBLE
PuExpIns AS ECB ON CH.IdExpInsComb = ECB.IdExpIns LEFT JOIN
PuCatalogo AS CCB ON CCB.IdCodigo = ECB.IdCodigo LEFT JOIN
(SELECT E.IdExpIns, C.Codigo, C.Descripcion, C.DescripcionLarga, U.Unidad, C.IdTipo,
EC1.Costo AS CostoCB1, EC2.Costo AS CostoCB2
FROM PuCatalogo C INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad LEFT JOIN
PuExpIns E ON E.IdCodigo = C.IdCodigo LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda1 ) EC1 ON EC1.IdExpIns = E.IdExpIns LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda2 ) EC2 ON EC2.IdExpIns = E.IdExpIns
WHERE IdPresupuesto = @IdPresupuesto ) AS DTCB ON DTCB.IdExpIns = CH.IdExpInsComb LEFT JOIN
--ACEITE
PuExpIns AS EA ON CH.IdExpInsAcei = EA.IdExpIns LEFT JOIN
PuCatalogo AS CA ON CA.IdCodigo = EA.IdCodigo LEFT JOIN
(SELECT E.IdExpIns, C.Codigo, C.Descripcion, C.DescripcionLarga, U.Unidad, C.IdTipo,
EC1.Costo AS CostoAC1, EC2.Costo AS CostoAC2
FROM PuCatalogo C INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad LEFT JOIN
PuExpIns E ON E.IdCodigo = C.IdCodigo LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda1 ) EC1 ON EC1.IdExpIns = E.IdExpIns LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda2 ) EC2 ON EC2.IdExpIns = E.IdExpIns
WHERE IdPresupuesto = @IdPresupuesto ) AS DTAC ON DTAC.IdExpIns = CH.IdExpInsAcei LEFT JOIN
--OTRAS FUENTES DE ENERGIA
PuExpIns AS EOF ON CH.IdExpInsOtrasFuentes = EOF.IdExpIns LEFT JOIN
PuCatalogo AS COF ON COF.IdCodigo = EOF.IdCodigo LEFT JOIN
(SELECT E.IdExpIns, C.Codigo, C.Descripcion, C.DescripcionLarga, U.Unidad, C.IdTipo,
EC1.Costo AS CostoOF1, EC2.Costo AS CostoOF2
FROM PuCatalogo C INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad LEFT JOIN
PuExpIns E ON E.IdCodigo = C.IdCodigo LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda1 ) EC1 ON EC1.IdExpIns = E.IdExpIns LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda2 ) EC2 ON EC2.IdExpIns = E.IdExpIns
WHERE IdPresupuesto = @IdPresupuesto ) AS DTOF ON DTOF.IdExpIns = CH.IdExpInsOtrasFuentes LEFT JOIN
--PIEZAS ESPECIALES
PuExpIns AS EP ON CH.IdExpInsPza = EP.IdExpIns LEFT JOIN
PuCatalogo AS CP ON CP.IdCodigo = EP.IdCodigo LEFT JOIN
(SELECT E.IdExpIns, C.Codigo, C.Descripcion, C.DescripcionLarga, U.Unidad, C.IdTipo,
EC1.Costo AS CostoPE1, EC2.Costo AS CostoPE2
FROM PuCatalogo C INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad LEFT JOIN
PuExpIns E ON E.IdCodigo = C.IdCodigo LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda1 ) EC1 ON EC1.IdExpIns = E.IdExpIns LEFT JOIN
(SELECT *
FROM PuExpInsCostos EC
WHERE IdMoneda = @IdMoneda2 ) EC2 ON EC2.IdExpIns = E.IdExpIns
WHERE IdPresupuesto = @IdPresupuesto) AS DTPE ON DTPE.IdExpIns = CH.IdExpInsPza
WHERE EEQ.IdPresupuesto = @IdPresupuesto
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorarioDetalleBuscaId]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín
-- Create date: 13-Junio-2009
-- Description:	Busca el Id del Catálogo General, el IdExpIns y el Id de la tabla detalla de Costos Horarios
-- El tipo detalle con los consumos para la opción 1 y la Operación para la opción 2
-- =============================================
CREATE PROCEDURE [dbo].[NeoCostoHorarioDetalleBuscaId]
@TipoDetalle Int,
@IdPresupuesto Int,
@IdCostoHorario Int,
@IdExpIns Int = 0 Output,
@IdCodigo Int = 0 Output,
@Codigo Varchar(20)
AS
SET NOCOUNT ON;
DECLARE @IdDetalle Int
--BUSCA EL ID DEL CATALOGO GENERAL
SELECT @IdCodigo = IdCodigo FROM PuCatalogo
WHERE Codigo = @Codigo
SET @IdCodigo = COALESCE(@IdCodigo,0)
IF @IdCodigo > 0
BEGIN
--BUSCA EL IDEXPINS
SELECT @IdExpIns = IdExpIns FROM PuExpIns
WHERE IdCodigo = @IdCodigo AND IdPresupuesto = @IdPresupuesto
SET @IdExpIns = COALESCE(@IdExpIns,0)
IF @IdExpIns > 0
BEGIN
--Verifica si el Insumo esta en el Detalle de Cargo Fijo
IF @TipoDetalle = 1
BEGIN
SELECT @IdDetalle = IdCostoHorarioOC FROM PuCostosHorariosOC
WHERE IdExpIns = @IdExpIns AND IdCostoHorario = @IdCostoHorario
SET @IdDetalle = COALESCE(@IdDetalle,0)
END
ELSE IF @TipoDetalle = 2
BEGIN
SELECT @IdDetalle = IdCostoHorarioMO FROM PuCostosHorariosMO
WHERE IdExpIns = @IdExpIns AND IdCostoHorario = @IdCostoHorario
SET @IdDetalle = COALESCE(@IdDetalle,0)
END
END
END
SET @IdExpIns = COALESCE(@IdExpIns,0)
SET @IdDetalle = COALESCE(@IdDetalle,0)
RETURN @IdDetalle
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorarioDetalleMO_CargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín
-- Create date: 12,06,09
-- Description:	Carga el Detalle del la Operación del Equipo
-- =============================================
CREATE PROCEDURE [dbo].[NeoCostoHorarioDetalleMO_CargaDatos]
@IdExpIns Int,
@IdMoneda Int,
@IdPresupuesto Int
AS
Declare @Decimales as Int
--SE OBTIENE EL NUMERO DE DECIMALES PARA EL REDONDEO
EXEC @Decimales = NeoParametros_DecimalesRedondeo @IdPresupuesto
BEGIN
SELECT MO.IdCostoHorarioMO, COALESCE(MO.Renglon,0) AS Renglon, C.Codigo, C.IdTipo,
C.DescripcionLarga, C.Descripcion, U.Unidad, COALESCE(MOP.Costo,0) AS Costo,
CASE WHEN MO.Dividir  = 1 THEN '/' ELSE '*' END AS Dividir, COALESCE(MO.Volumen,0) AS Volumen,
CASE WHEN MO.Dividir = 1 THEN ROUND(COALESCE(MOP.Costo,0) / COALESCE(MO.Volumen,0), @Decimales)
ELSE ROUND(COALESCE(MOP.Costo,0) * COALESCE(MO.Volumen,0), @Decimales) END AS Importe
FROM PuCostosHorarios AS CH INNER JOIN
PuCostosHorariosMO  AS MO ON CH.IdCostoHorario = MO.IdCostoHorario INNER JOIN
PuExpIns AS EX ON MO.IdExpIns = EX.IdExpIns INNER JOIN
PuCatalogo AS C ON C.IdCodigo = EX.IdCodigo INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad LEFT JOIN
(SELECT ECMO.IdExpIns, ECMO.Costo
FROM PuExpInsCostos AS ECMO INNER JOIN
PuMonedas AS MMO ON ECMO.IdMoneda = MMO.IdMoneda
WHERE MMO.IdMoneda = @IdMoneda) AS MOP ON MOP.IdExpIns = EX.IdExpIns
WHERE CH.IdExpIns  = @IdExpIns
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorarioDetalleMO_Eliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 22-Junio-2009
---- Description:	Elimina un registro De la Operación del CostoHorario
---- =============================================
CREATE PROCEDURE [dbo].[NeoCostoHorarioDetalleMO_Eliminar]
@IdCostoHorarioMO Int
AS
BEGIN
SET NOCOUNT ON;
DELETE FROM PuCostosHorariosMO WHERE IdCostoHorarioMO = @IdCostoHorarioMO
RETURN @@ROWCOUNT
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorarioDetalleMO_Grabar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 18-Junio-2009
---- Description:	Graba la Operacion de Costos Horarios, se utiliza en el copiado y pegado
---- =============================================
CREATE PROCEDURE [dbo].[NeoCostoHorarioDetalleMO_Grabar]
@IdCostosHorarioMO Int Output,
@IdExpIns Int,
@IdCostoHorario Int,
@Renglon SmallInt,
@Dividir Bit,
@Volumen Decimal(18,6)
AS
BEGIN
SET NOCOUNT ON;
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @Renglon Is NULL BEGIN
SELECT @Renglon = MAX(Renglon) FROM PuCostosHorariosMO WHERE  IdCostoHorarioMO = @IdCostosHorarioMO
IF @Renglon IS NULL BEGIN
SET @Renglon = 10
END ELSE BEGIN
SET @Renglon = @Renglon + 10
END
END
IF @IdCostosHorarioMO = 0
BEGIN
INSERT INTO PuCostosHorariosMO (IdCostoHorario, IdExpIns, Renglon, Dividir, Volumen)
VALUES (@IdCostoHorario, @IdExpIns, @Renglon, @Dividir, @Volumen)
SET @RegistrosAfectados = @@ROWCOUNT
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al insertar el insumo en PuCostosHorariosMO. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdCostosHorarioMO = @@IDENTITY
END
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorarioDetalleMO_GrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 18-Junio-2009
---- Description:	Graba y Actualiza la Operacion de Costos Horarios
---- =============================================
CREATE PROCEDURE [dbo].[NeoCostoHorarioDetalleMO_GrabarActualizar]
@IdCostosHorarioMO Int Output,
@IdCodigoCatalogo Int,
@IdPresupuesto Int,
@IdExpIns Int,
@IdCostoHorario Int,
@Costo Money,
@Renglon SmallInt,
@Dividir Bit,
@Volumen Decimal(18,6),
@IdMoneda Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @IdExpInsCosto Int,
@RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
--- INSERTA O ACUTALIZA EL EQUIPO EN PUEXPINS
IF @IdExpIns = 0
BEGIN
-- INERTA
INSERT INTO PuExPins (IdPresupuesto, IdCodigo)
VALUES (@IdPresupuesto, @IdCodigoCatalogo)
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al insertar el insumo en ExpIns. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdExpIns = @@IDENTITY
END
---  BUSCA SI TIENE ASIGNADO EL COSO EN PESOS
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos AS E INNER JOIN
PuMonedas AS M ON E.IdMoneda = M.IdMoneda
WHERE E.IdExpIns  = @IdExpIns AND M.Moneda = 0
SET @IdExpInsCosto = COALESCE (@IdExpInsCosto,0)
EXEC NeoExpInsCostos_GrabarActualizar @IdExpIns, @IdMoneda, @Costo
IF @Renglon Is NULL
BEGIN
SELECT @Renglon = MAX(Renglon) FROM PuCostosHorariosMO WHERE  IdCostoHorarioMO = @IdCostosHorarioMO
IF @Renglon IS NULL
BEGIN
SET @Renglon = 10
END
ELSE
BEGIN
SET @Renglon = @Renglon + 10
END
END
IF @IdCostosHorarioMO = 0
BEGIN
INSERT INTO PuCostosHorariosMO (IdCostoHorario, IdExpIns, Renglon, Dividir, Volumen)
VALUES (@IdCostoHorario, @IdExpIns, @Renglon, @Dividir, @Volumen)
SET @RegistrosAfectados = @@ROWCOUNT
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al insertar el insumo en PuCostosHorariosMO. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdCostosHorarioMO = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuCostosHorariosMO
SET Renglon = @Renglon, @IdExpIns = IdExpIns, Dividir = @Dividir, Volumen = @Volumen
WHERE IdCostoHorarioMO = @IdCostosHorarioMO
SET @RegistrosAfectados = @@ROWCOUNT
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al Actualizar el insumo en PuCostosHorariosMO. No se afectaron registros.', 16, 1)
RETURN
END
END
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorarioDetalleOC_CargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín
-- Create date: 22-06-2009
-- Description:	Carga el Detalle de OtrosConsumos del EQ
-- =============================================
CREATE PROCEDURE [dbo].[NeoCostoHorarioDetalleOC_CargaDatos]
@IdExpIns Int,
@IdMoneda Int,
@IdPresupuesto Int
AS
Declare @Decimales as Int
--SE OBTIENE EL NUMERO DE DECIMALES PARA EL REDONDEO
EXEC @Decimales = NeoParametros_DecimalesRedondeo @IdPresupuesto
BEGIN
SELECT OC.IdCostoHorarioOC, COALESCE(OC.Renglon,0) AS Renglon, C.Codigo, C.IdTipo, C.DescripcionLarga,  C.Descripcion, U.Unidad,
COALESCE(OCP.Costo,0) AS Costo,
CASE WHEN OC.Dividir  = 1 THEN '/' ELSE '*' END AS Dividir, COALESCE(OC.Volumen,0) AS Volumen,
CASE WHEN OC.Dividir = 1 THEN ROUND(COALESCE(OCP.Costo,0) / COALESCE(OC.Volumen,0), @Decimales)
ELSE ROUND(COALESCE(OCP.Costo,0) * COALESCE(OC.Volumen,0), @Decimales) END AS Importe
FROM PuCostosHorarios AS CH INNER JOIN
PuCostosHorariosOC  AS OC ON CH.IdCostoHorario = OC.IdCostoHorario INNER JOIN
PuExpIns AS EX ON OC.IdExpIns = EX.IdExpIns INNER JOIN
PuCatalogo AS C ON C.IdCodigo = EX.IdCodigo INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad LEFT JOIN
(SELECT ECOC.IdExpIns, ECOC.Costo
FROM PuExpInsCostos AS ECOC INNER JOIN
PuMonedas AS MOC ON ECOC.IdMoneda = MOC.IdMoneda
WHERE MOC.IdMoneda = @IdMoneda) AS OCP ON OCP.IdExpIns = EX.IdExpIns
WHERE CH.IdExpIns  = @IdExpIns
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorarioDetalleOC_Eliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 22-Junio-2009
---- Description:	Elimina un registro De los Consumos del CostoHorario
---- =============================================
CREATE PROCEDURE [dbo].[NeoCostoHorarioDetalleOC_Eliminar]
@IdCostoHorarioOC Int
AS
BEGIN
SET NOCOUNT ON;
DELETE FROM PuCostosHorariosOC WHERE IdCostoHorarioOC = @IdCostoHorarioOC
RETURN @@ROWCOUNT
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorarioDetalleOC_Grabar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 03-Julio-2009
---- Description:	Graba Otros Consumos de Costos Horarios, se utiliza en el copiado y pegado
---- =============================================
CREATE PROCEDURE [dbo].[NeoCostoHorarioDetalleOC_Grabar]
@IdCostosHorarioOC Int Output,
@IdExpIns Int,
@IdCostoHorario Int,
@Renglon SmallInt,
@Dividir Bit,
@Volumen Decimal(18,6)
AS
BEGIN
SET NOCOUNT ON;
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @Renglon Is NULL BEGIN
SELECT @Renglon = MAX(Renglon) FROM PuCostosHorariosOC WHERE  IdCostoHorarioOC = @IdCostosHorarioOC
IF @Renglon IS NULL BEGIN
SET @Renglon = 10
END ELSE BEGIN
SET @Renglon = @Renglon + 10
END
END
INSERT INTO PuCostosHorariosOC (IdCostoHorario, IdExpIns, Renglon, Dividir, Volumen)
VALUES (@IdCostoHorario, @IdExpIns, @Renglon, @Dividir, @Volumen)
SET @RegistrosAfectados = @@ROWCOUNT
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al insertar el insumo en PuCostosHorariosOC. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdCostosHorarioOC = @@IDENTITY
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorarioDetalleOC_GrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 18-Junio-2009
---- Description:	Graba y Actualiza Otros Consumos de Costos Horarios
---- =============================================
CREATE PROCEDURE [dbo].[NeoCostoHorarioDetalleOC_GrabarActualizar]
@IdCostosHorarioOC Int Output,
@IdCodigoCatalogo Int,
@IdPresupuesto Int,
@IdExpIns Int,
@IdCostoHorario Int,
@Costo Money,
@Renglon SmallInt,
@Dividir Bit,
@Volumen Decimal(18,6),
@IdMoneda Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @IdExpInsCosto Int,
@RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
--- INSERTA O ACUTALIZA EL EQUIPO EN PUEXPINS
IF @IdExpIns = 0
BEGIN
-- INERTA
INSERT INTO PuExPins (IdPresupuesto, IdCodigo)
VALUES (@IdPresupuesto, @IdCodigoCatalogo)
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al insertar el insumo en ExpIns. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdExpIns = @@IDENTITY
END
---  BUSCA SI TIENE ASIGNADO COSO
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos AS E INNER JOIN
PuMonedas AS M ON E.IdMoneda = M.IdMoneda
WHERE E.IdExpIns = @IdExpIns AND M.IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE (@IdExpInsCosto,0)
EXEC NeoExpInsCostos_GrabarActualizar @IdExpIns, @IdMoneda, @Costo
IF @Renglon Is NULL
BEGIN
SELECT @Renglon = MAX(Renglon)
FROM PuCostosHorariosOC
WHERE  IdCostoHorarioOC = @IdCostosHorarioOC
IF @Renglon IS NULL
SET @Renglon = 10
ELSE
SET @Renglon = @Renglon + 10
END
IF @IdCostosHorarioOC = 0
BEGIN
INSERT INTO PuCostosHorariosOC (IdCostoHorario, IdExpIns, Renglon, Dividir, Volumen)
VALUES (@IdCostoHorario, @IdExpIns, @Renglon, @Dividir, @Volumen)
SET @RegistrosAfectados = @@ROWCOUNT
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al insertar el insumo en PuCostosHorariosOC. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdCostosHorarioOC = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuCostosHorariosOC
SET Renglon = @Renglon, IdExpIns =@IdExpIns, Dividir = @Dividir, Volumen = @Volumen
WHERE IdCostoHorarioOC = @IdCostosHorarioOC
SET @RegistrosAfectados = @@ROWCOUNT
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al Actualizar el insumo en PuCostosHorariosOC. No se afectaron registros.', 16, 1)
RETURN
END
END
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorarioGrabar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 24-Junio-2009
---- Description:	Graba Costos Horarios, se utiliza en el copiado y pegado
---- =============================================
CREATE PROCEDURE [dbo].[NeoCostoHorarioGrabar]
@IdCostoHorario Int OutPut,
@IdMoneda Int,
@IdExpIns Int,
@IdExpInsCF Int,
@IdExpInsVa Int,
@IdExpInsLla Int,
@IdExpInsComb Int,
@IdExpInsAcei Int,
@IdExpInsOtrasFuentes Int,
@IdExpInsPza Int,
@IdExpinsE Int,
@IdExpinsR Int,
@TasaInteres decimal(18, 10),
@foper Decimal(18, 10),
@potencia Decimal(18, 10),
@ve Int,
@ha Int,
@vr decimal(18, 10),
@s decimal(18, 10),
@q decimal(18, 10),
@factcomb decimal(18, 10),
@ccarter decimal(18, 10),
@horasc Int,
@faceite decimal(18, 10),
@hllantas Int,
@hPiezas Int,
@NumSerie Varchar(20),
@Capacidad Varchar(25),
@ValorComercial Money,
@Disponibilidad Varchar(1),
@Modelo Varchar(25),
@Ubicacion Varchar(25),
@Marca Varchar(25),
@factFuentes decimal(18, 10),
@UnidadPotencia Varchar(5),
@Propietario Varchar(80),
@VidaUtil Varchar(25),
@TipoCombustible SmallInt,
@CalculoDetallado Bit,
@CantidadCombustible Decimal(18, 10),
@CantidadLubricante Decimal(18, 10)
AS
SET NOCOUNT ON;
DECLARE @EsCostoHorario Bit,
@NecesitaRoll Bit = 1,
@Id Int,
@IdMatriz Int,
@IdCostoHorarioTI Int,
@RegistroAfectados Int,
@Error VarChar(200),
@ErrorSeverity Int,
@ErrorState Int
BEGIN TRAN
BEGIN TRY
SELECT @IdMatriz = IdCodigoMatriz FROM PuMatrices WHERE IdCodigoMatriz = @IdExpIns
SET @IdMatriz = COALESCE(@IdMatriz,0)
--Valida si el equipo tiene matriz antes de grabarlo como Costsos Horarios
IF @IdMatriz > 0
BEGIN
SELECT @Id = IdCostoHorario FROM PuCostosHorarios WHERE IdExpIns = @IdExpIns
SET @Id = COALESCE(@Id,0)
--Revisa si ya se grabo en la tabla de costos horarios, si es asi se elimina
IF @Id > 0 	BEGIN  DELETE PuCostosHorarios WHERE IdExpIns = @IdExpIns END
--Se actualiza el campo de EsCosto horario
UPDATE PuExpIns SET EsCostoHorario = 0 WHERE  IdExpIns = @IdExpIns
COMMIT TRAN
SET @NecesitaRoll = 0
--Envia el mensaje de error
RAISERROR('El equipo que desea grabar ya tiene una matriz, no puede grabar el análisis de Costo Horario.', 16, 1)
RETURN
END
ELSE
BEGIN
UPDATE PuExpIns SET EsCostoHorario = 1 WHERE  IdExpIns = @IdExpIns
END
INSERT INTO PuCostosHorarios (
IdExpIns, IdExpInsCF, IdExpInsVa, IdExpInsLla, IdExpInsComb, IdExpInsAcei, IdExpInsOtrasFuentes,
IdExpInsPza, IdExpinsE, IdExpinsR, foper, potencia, ve, ha, vr, s, q,
factcomb, ccarter, horasc, faceite, hllantas, CantidadCombustible, CantidadLubricante,
hPiezas, NumSerie, Capacidad, VidaUtil, ValorComercial, Disponibilidad, Modelo,
Ubicacion, Marca, factFuentes, UnidadPotencia, Propietario, TipoCombustible, CalculoDetallado )
VALUES ( @IdExpIns, @IdExpInsCF, @IdExpInsVa, @IdExpInsLla, @IdExpInsComb, @IdExpInsAcei, @IdExpInsOtrasFuentes,
@IdExpInsPza, @IdExpinsE, @IdExpinsR, @foper, @potencia, @ve, @ha, @vr, @s, @q,
@factcomb, @ccarter, @horasc, @faceite, @hllantas,@CantidadCombustible, @CantidadLubricante,
@hPiezas, @NumSerie, @Capacidad, @VidaUtil, @ValorComercial, @Disponibilidad, @Modelo,
@Ubicacion, @Marca, @factFuentes, @UnidadPotencia, @Propietario, @TipoCombustible, @CalculoDetallado )
SET @RegistroAfectados = @@ROWCOUNT
IF @RegistroAfectados = 0
BEGIN
RAISERROR('Error al insertar el Costos HOrarios. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdCostoHorario = @@IDENTITY
--SE ACTUALIZA O SE INSERTA LA TASA DE INTERES
SELECT @IdCostoHorarioTI = IdCostoHorarioTI
FROM PUCOSTOSHORARIOSTI AS TI
WHERE IdCostoHorario = @IdCostoHorario AND IdMoneda = @IdMoneda
SET @IdCostoHorarioTI = COALESCE(@IdCostoHorarioTI,0)
IF @IdCostoHorarioTI <= 0
BEGIN
INSERT INTO PuCostosHorariosTI ( TasaInteres, IdCostoHorario, IdMoneda )
VALUES (@TasaInteres, @IdCostoHorario, @IdMoneda )
END
ELSE
BEGIN
UPDATE PuCostosHorariosTI
SET TasaInteres = @TasaInteres
WHERE IdMoneda = @IdMoneda AND IdCostoHorario = @IdCostoHorario
END
COMMIT TRAN
RETURN @RegistroAfectados
END TRY
BEGIN CATCH
IF @NecesitaRoll = 1 BEGIN 	ROLLBACK TRAN END
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
GO
/****** Object:  StoredProcedure [dbo].[NeoCostoHorarioMO_DameDatosInsumo]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín
-- Create date: 19-07-2009
-- Description:	devuelve los datos de un inusmo del detalle
-- =============================================
CREATE PROCEDURE [dbo].[NeoCostoHorarioMO_DameDatosInsumo]
@IdPresupuesto Int,
@IdCostoHorario Int,
@IdMoneda Int,
@IdCodigo Int
AS
DECLARE @Decimales as Int
SET NOCOUNT ON;
--SE OBTIENE EL NUMERO DE DECIMALES
EXEC @Decimales = NeoParametros_DecimalesRedondeo @IdPresupuesto
SELECT COALESCE(PECH.IdCostoHorarioMO,0) AS IdCostoHorarioMO, COALESCE(PECH.Renglon,0) AS Renglon,
C.Codigo, C.Descripcion, c.DescripcionLarga,  U.Unidad, C.IdTipo, C.EsPorcentaje, C.EsAgrupador,
COALESCE(PECH.Volumen,0) AS Volumen, COALESCE(PEC.Costo,0) AS Costo,
CASE WHEN PECH.Dividir = 1 THEN '/' ELSE '*' END AS Dividir,
CASE WHEN PECH.Dividir = 1 THEN ROUND(COALESCE(PEC.Costo,0) / COALESCE(PECH.Volumen,0), @Decimales)
ELSE ROUND(COALESCE(PEC.Costo,0)* COALESCE(PECH.Volumen,0), @Decimales) END AS Importe
FROM PuCatalogo AS C LEFT JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad LEFT JOIN
(SELECT E1.IdExpIns, E1.IdCodigo, E1.IdPresupuesto, EC1.Costo
FROM PuExpIns AS E1 LEFT JOIN
PuExpInsCostos AS EC1 ON E1.IdExpIns = EC1.IdExpIns
WHERE EC1.IdMoneda = @IdMoneda AND E1.IdPresupuesto = @IdPresupuesto ) AS PEC ON PEC.IdCodigo = C.IdCodigo LEFT JOIN
(SELECT PC_MO.IdCostoHorarioMO, PC_MO.IdCostoHorario, E2.IdCodigo, E2.IdPresupuesto,
PC_MO.Renglon, PC_MO.Dividir, PC_MO.Volumen
FROM PuExpIns AS E2 LEFT JOIN
PuCostosHorariosMO AS PC_MO ON PC_MO.IdExpins = E2.IdExpIns
WHERE E2.IdPresupuesto = @IdPresupuesto AND PC_MO.IdCostoHorario = @IdCostoHorario) AS PECH ON PECH.IdCodigo = C.IdCodigo
WHERE C.Esporcentaje = 0 AND C.Idcodigo = @IdCodigo
GO
/****** Object:  StoredProcedure [dbo].[NeoExpIns_ActualizaCostosMO]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín Ramírez
-- Create date: 04-Agosto-09
-- Description:	Actuializa el Salario Base para llegar a un costo deseado
-- =============================================
CREATE PROCEDURE [dbo].[NeoExpIns_ActualizaCostosMO]
@IdExpIns Int,
@IdMoneda Int,
@SalarioBase Money,
@SalarioIntegrado Money
AS
BEGIN
SET NOCOUNT ON;
DECLARE @IdExpInsCostos Int
--SE OBTIENE EL IDEXPINSCOSTOS
SELECT @IdExpInsCostos = IdExpInsCosto
FROM PuExpInsCostos
WHERE IdExpIns = @IdExpIns AND IdMoneda = @IdMoneda
-- SE ACTUALIZA EL SALARIO BASE
UPDATE PuExpInsMO SET SalarioBase = @SalarioBase, SalarioIntegrado = @SalarioIntegrado
WHERE IdExpInsCosto = @IdExpInsCostos
END
GO
/****** Object:  StoredProcedure [dbo].[NeoExpIns_AsignarIntelimat]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 16-Julio-2009
-- Description:	Asigna el Intelimat a un ExpIns
-- =============================================
CREATE PROCEDURE [dbo].[NeoExpIns_AsignarIntelimat]
@IdExpIns AS Int,
@IdIntelimat AS Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @IdIntelimatActual AS Int
SELECT @IdIntelimatActual = IdIntelimat
FROM PuExpIns
WHERE IdExpIns = @IdExpIns
-- Reviso si es diferente y lo asigno
IF (@IdIntelimatActual IS NULL AND @IdIntelimat IS NOT NULL)
OR (@IdIntelimatActual IS NOT NULL AND @IdIntelimat IS NULL)
OR (@IdIntelimatActual IS NOT NULL AND @IdIntelimat IS NOT NULL AND @IdIntelimatActual <> @IdIntelimat) BEGIN
-- Asigno el Intelimat
UPDATE PuExpIns
SET IdIntelimat = @IdIntelimat
WHERE IdExpIns = @IdExpIns
-- Elimino los Parametros
DELETE FROM PuExpInsIntelimat
WHERE IdExpIns = @IdExpIns
END
END
GO
/****** Object:  StoredProcedure [dbo].[NeoExpIns_BuscaIdCatalogo]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín
-- Create date: 20-07-2009
-- Description:	Busca el Id en el Catálogo Genaral de un Insumo
-- =============================================
CREATE PROCEDURE [dbo].[NeoExpIns_BuscaIdCatalogo]
@Codigo Varchar(20)
AS
BEGIN
DECLARE @IdCodigo as Int
SELECT @IdCodigo = IdCodigo FROM PuCatalogo
WHERE Codigo = @Codigo
SET @IdCodigo = COALESCE(@IdCodigo,0)
RETURN @IdCodigo
END
GO
/****** Object:  StoredProcedure [dbo].[NeoExpIns_BuscaIdExpIns]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín
-- Create date: 25-Junio-2009
-- Description:	Regresa el IdExpIns de un insumo
CREATE PROCEDURE [dbo].[NeoExpIns_BuscaIdExpIns]
@IdPresupuesto Int,
@IdCodigoCatalogo Int
AS
DECLARE @IdExpIns Int
BEGIN
SELECT @IdExpIns = IdExpIns
FROM PuExpIns
WHERE IdCodigo = @IdCodigoCatalogo And IdPresupuesto = @IdPresupuesto
IF @IdExpIns = 0
RETURN 0
ELSE
RETURN @IdExpIns
END
GO
/****** Object:  StoredProcedure [dbo].[NeoExpIns_BuscaSiTieneMatriz]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 26-Julio-2009
---- Description:	Regresa el IdMatiz para verificar si el insumo tiene una matriz
---- =============================================
CREATE PROCEDURE [dbo].[NeoExpIns_BuscaSiTieneMatriz]
@IdExpIns Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE	@TieneMatriz Int
SELECT @TieneMatriz = IdMatriz FROM PuMatrices AS M INNER JOIN
PuExpIns AS E ON E.IdExpIns = M.IdCodigoMatriz
WHERE M.IdCodigoMatriz = @IdExpIns
SET @TieneMatriz = COALESCE(@TieneMatriz,0)
RETURN @TieneMatriz
END
GO
/****** Object:  StoredProcedure [dbo].[NeoExpIns_Eliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 26-Julio-2009
---- Description:	Elimina un registro de la Explosión de Insumos
---- =============================================
CREATE PROCEDURE [dbo].[NeoExpIns_Eliminar]
@IdExpIns Int,
@IdPresupuesto Int
AS
BEGIN
SET NOCOUNT ON;
DELETE FROM PuExpIns WHERE IdExpIns = @IdExpIns AND IdPresupuesto = @IdPresupuesto
RETURN @@ROWCOUNT
END
GO
/****** Object:  StoredProcedure [dbo].[NeoExpIns_GrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 30-Junio-2009
-- Description:	Graba/Actualiza en ExpIns
-- =============================================
CREATE PROCEDURE [dbo].[NeoExpIns_GrabarActualizar]
@IdExpIns Int OUT,
@IdPresupuesto Int,
@IdCodigo Int,
@IdUsuario Int,
@Costo AS Decimal(18, 6),
@IdMoneda As Int,
@IdProveedor AS Int = NULL,
@CostoFecha As DateTime = NULL,
@InsumoIntegrado AS Bit = 0,
@EsCostoHorario AS Bit = 0,
@IdIntelimat Int = NULL
AS
BEGIN
DECLARE @IdExpInsCosto Int,
@Error AS VarChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int,
@CostoActual AS Decimal(18, 6)
BEGIN TRAN
BEGIN TRY
IF @IdExpIns = 0
BEGIN
INSERT INTO PuExPins (IdPresupuesto, IdCodigo, IdProveedor, InsumoIntegrado, EsCostoHorario, IdIntelimat)
VALUES (@IdPresupuesto, @IdCodigo, @IdProveedor, @InsumoIntegrado, @EsCostoHorario, @IdIntelimat )
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al insertar el insumo en ExpIns. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdExpIns = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuExpIns
SET InsumoIntegrado = @InsumoIntegrado, EsCostoHorario = @EsCostoHorario,
IdProveedor = @IdProveedor
WHERE IdExpIns = @IdExpIns
END
-- Actualizo el Costo
IF @CostoFecha IS NULL BEGIN
SET @CostoFecha = GETDATE() END
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos
WHERE IdExpIns = @IdExpIns AND IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE(@IdExpInsCosto,0)
IF @IdExpInsCosto > 0
BEGIN
-- Existe el costo para esta moneda entonces se actualiza
SELECT @CostoActual = Costo FROM PuExpInsCostos WHERE IdExpIns = @IdExpIns AND IdMoneda = @IdMoneda
IF @CostoActual IS NULL
BEGIN
RAISERROR('Error al obtener el costo del concepto en ExpIns.', 16, 1)
RETURN
END
-- Revisa si el costo es diferente y lo actualiza
IF @Costo <> @CostoActual
BEGIN
UPDATE PuExpInsCostos
SET Costo = @Costo, Fecha = @CostoFecha
WHERE IdExpIns = @IdExpIns AND IdMoneda = @IdMoneda
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al actualizar Costo en ExpInsCostos.', 16, 1)
RETURN
END
--Graba en la bitacora
EXEC NeoBitacoraCostos_GrabaBitacora @IdExpIns,@IdMoneda,@IdUsuario,@Costo
END
END
ELSE
BEGIN
-- No existe el costo en esta moneda asi que se inserta
IF @Costo IS NOT NULL AND @Costo > 0
BEGIN
INSERT INTO PuExpInsCostos ( IdExpIns, IdMoneda, Costo, Fecha )
VALUES ( @IdExpIns, @IdMoneda, @Costo, @CostoFecha )
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al insertar Costo en ExpInsCostos.', 16, 1)
RETURN	END
--Graba en la bitacora
EXEC NeoBitacoraCostos_GrabaBitacora @IdExpIns,@IdMoneda,@IdUsuario,@Costo
END
END
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
RETURN @IdExpIns
END
GO
/****** Object:  StoredProcedure [dbo].[NeoExpIns_QuitarIntelimat]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 16-Julio-2009
-- Description:	Quita el Intelimat a un ExpIns
-- =============================================
CREATE PROCEDURE [dbo].[NeoExpIns_QuitarIntelimat]
@IdExpIns AS Int
AS
BEGIN
SET NOCOUNT ON;
-- Quito el Intelimat
UPDATE PuExpIns
SET IdIntelimat = NULL
WHERE IdExpIns = @IdExpIns
-- Elimino los Parametros
DELETE FROM PuExpInsIntelimat
WHERE IdExpIns = @IdExpIns
END
GO
/****** Object:  StoredProcedure [dbo].[NeoExpInsControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín Ramírez
-- Create date: 11-09-2009
-- Description:	Control de 3 puntos de la explosión de insumos
-- =============================================
CREATE PROCEDURE [dbo].[NeoExpInsControl3Puntos]
@IdPresupuesto Int,
@Codigo Varchar(20),
@IdExpIns Int,
@TipoFiltro Int
AS
BEGIN
IF @IdExpIns = 0 AND @Codigo IS NULL
BEGIN
IF @TipoFiltro = 0
BEGIN
SELECT E.IdExpIns, C.IdCodigo, C.Codigo, C.Descripcion, C.DescripcionLarga, C.IdCodigo, C.IdTipo,
U.Unidad, C.EsAgrupador, C.EsPorcentaje, E.Expins, E.EsCostoHorario, E.InsumoIntegrado
FROM PuExpIns E INNER JOIN
PuCatalogo C ON C.IdCodigo = E.IdCodigo INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad
WHERE E.IdPresupuesto = @IdPresupuesto
ORDER BY C.IdTipo, C.Codigo
END
ELSE IF  @TipoFiltro = 1
BEGIN
SELECT E.IdExpIns, C.IdCodigo, C.Codigo, C.Descripcion, C.DescripcionLarga, C.IdCodigo, C.IdTipo, U.Unidad,
C.EsAgrupador, C.EsPorcentaje, E.Expins, E.EsCostoHorario, E.InsumoIntegrado
FROM PuExpIns E INNER JOIN
PuCatalogo C ON C.IdCodigo = E.IdCodigo INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad
WHERE E.IdPresupuesto = @IdPresupuesto AND C.IdTipo = 1
ORDER BY C.IdTipo, C.Codigo
END
ELSE IF  @TipoFiltro = 2
BEGIN
SELECT E.IdExpIns, C.IdCodigo, C.Codigo, C.Descripcion, C.DescripcionLarga, C.IdCodigo, C.IdTipo, U.Unidad, C.EsAgrupador, C.EsPorcentaje,
E.Expins, E.EsCostoHorario, E.InsumoIntegrado
FROM PuExpIns E INNER JOIN
PuCatalogo C ON C.IdCodigo = E.IdCodigo INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad
WHERE E.IdPresupuesto = @IdPresupuesto AND C.IdTipo = 2
ORDER BY C.IdTipo, C.Codigo
END
ELSE IF  @TipoFiltro = 3
BEGIN
SELECT E.IdExpIns, C.IdCodigo, C.Codigo, C.Descripcion, C.DescripcionLarga, C.IdCodigo, C.IdTipo, U.Unidad, C.EsAgrupador, C.EsPorcentaje,
E.Expins, E.EsCostoHorario, E.InsumoIntegrado
FROM PuExpIns E INNER JOIN
PuCatalogo C ON C.IdCodigo = E.IdCodigo INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad
WHERE E.IdPresupuesto = @IdPresupuesto AND C.IdTipo = 3 AND E.EsCostoHorario = 1
ORDER BY C.IdTipo, C.Codigo
END
END
ELSE IF @IdExpIns > 0 AND @Codigo IS NULL
BEGIN
SELECT E.IdExpIns, C.IdCodigo, C.Codigo, C.Descripcion, C.DescripcionLarga, C.IdCodigo, C.IdTipo, U.Unidad,
C.EsAgrupador, C.EsPorcentaje, E.Expins, E.EsCostoHorario, E.InsumoIntegrado
FROM PuExpIns E INNER JOIN
PuCatalogo C ON C.IdCodigo = E.IdCodigo INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad
WHERE E.IdPresupuesto = @IdPresupuesto AND E.IdExpIns = @IdExpIns
END
ELSE IF @IdExpIns = 0 AND @Codigo IS NOT NULL
BEGIN
SELECT E.IdExpIns, C.IdCodigo, C.Codigo, C.Descripcion, C.DescripcionLarga, C.IdCodigo, C.IdTipo, U.Unidad,
C.EsAgrupador, C.EsPorcentaje, E.Expins, E.EsCostoHorario, E.InsumoIntegrado
FROM PuExpIns E INNER JOIN
PuCatalogo C ON C.IdCodigo = E.IdCodigo INNER JOIN
PuUnidades U ON U.IdUnidad = C.IdUnidad
WHERE E.IdPresupuesto = @IdPresupuesto AND C.Codigo = @Codigo
END
END
GO
/****** Object:  StoredProcedure [dbo].[NeoExpInsCostos_GrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín
-- Create date: 25-Junio-2009
-- Description:	Graba y Actualiza el Costo de un insumo en PuExpInsCostos
-- =============================================
CREATE PROCEDURE [dbo].[NeoExpInsCostos_GrabarActualizar]
@IdExpIns Int OUTPUT,
@IdMoneda Int,
@CostoNuevo Money
AS
SET NOCOUNT ON;
DECLARE @CostoActual AS Money,
@IdExpInsCosto Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int,
@RegistrosAfectados AS Int
SELECT @IdExpInsCosto = IdExpInsCosto FROM PuExpInsCostos
WHERE IdExpIns = @IdExpIns AND IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE(@IdExpInsCosto ,0)
IF @IdExpInsCosto = 0
BEGIN
--SI EL COSTO ES MAYOR A CERO SE INSERTA
IF @CostoNuevo > 0
BEGIN
INSERT INTO PuExPinsCostos (IdExpIns, IdMoneda, Costo, Fecha)
VALUES (@IdExpIns, @IdMoneda, @CostoNuevo, GETDATE())
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al insertar el costo en ExpInsCostos. No se afectaron registros.', 16, 1)
RETURN
END
END
END
ELSE
BEGIN
SELECT @CostoActual = Costo FROM PuExPinsCostos
WHERE IdExpInsCosto = @IdExpInsCosto
--SI EL COSTO ACTUAL ES DIFERENTE DEL COSTO NUEVO SE ACTUALIZA
IF @CostoActual <> @CostoNuevo
BEGIN
UPDATE PuExPinsCostos
SET Costo = @CostoNuevo, Fecha = GETDATE()
WHERE IdExpInsCosto = @IdExpInsCosto
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al actualizar Costo en ExpInsCostos. No se afectaron registros.', 16, 1)
RETURN
END
END
END
RETURN @RegistrosAfectados
GO
/****** Object:  StoredProcedure [dbo].[NeoMatrices_CargaDatosGrid]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 9-Junio-2009
-- Description:	Devuelve el DataTable con la Matriz de un Concepto
--              opcionalmente puede devolver el IdPresupuesto y la DescripcionLarga de la Matriz
-- =============================================
CREATE PROCEDURE [dbo].[NeoMatrices_CargaDatosGrid]
@IdExpInsMatriz AS Int,
@IdPresupuesto AS Int = 0 OUTPUT,
@DescripcionLarga AS VarChar(MAX) OUTPUT,
@IdMoneda AS Int,
@IdMoneda2 AS Int OUT,
@IdMoneda3 AS Int OUT,
@DescripcionMoneda2 AS VarChar(20) OUT,
@DescripcionMoneda3 AS VarChar(20) OUT,
@PendienteAnalizar AS Bit OUT,
@ObservacionPendiente AS VarChar(40) OUT,
@UnidadMatriz AS VarChar(20) OUT
AS
DECLARE @Decimales AS Int,
@Sql AS nVarChar(3000)
-- Obtengo el IdPresupuesto y la DescripcionLarga de la Matriz
IF @IdPresupuesto IS NULL OR @DescripcionLarga IS NULL BEGIN
SELECT @IdPresupuesto = EI.IdPresupuesto, @DescripcionLarga = C.DescripcionLarga, @PendienteAnalizar = PendienteAnalizar, @ObservacionPendiente = EI.ObservacionPendiente, @UnidadMatriz = U.Unidad
FROM PuExpIns AS EI INNER JOIN
PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad
WHERE EI.IdExpIns = @IdExpInsMatriz
END
-- Obtengo el Número de Decimales
EXEC @Decimales = NeoParametros_DecimalesRedondeo @IdPresupuesto = @IdPresupuesto
EXEC NeoMatrices_DameMonedasPresupuesto @IdPresupuesto, @IdMoneda, @IdMoneda2 OUT, @IdMoneda3 OUT
SET @Sql = 'SELECT M.IdMatriz, M.IdCodigoMatriz AS IdExpInsMatriz, M.IdCodigoInsumo AS IdExpInsInsumo, M.Renglon, C.Codigo, EI.Nivel, C.Descripcion, C.DescripcionLarga, C.IdTipo, U.Unidad,
COALESCE(EIC.Costo, 0) AS Costo, CASE WHEN M.Dividir = 1 THEN ''/'' ELSE ''*'' END AS Dividir, M.Volumen,
CASE WHEN M.Volumen <> 0 AND M.Dividir = 1 THEN ROUND(COALESCE(EIC.Costo, 0) / M.Volumen, ' + CAST(@Decimales AS VarChar) + ') WHEN M.Volumen <> 0 AND M.Dividir = 0 THEN ROUND(COALESCE(EIC.Costo, 0) * M.Volumen, ' + CAST(@Decimales AS VarChar) + ') ELSE 0 END AS Importe,
M.Expresion, C.EsPorcentaje, EI.EsCostoHorario, EI.PendienteAnalizar, I.Imagen '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += ', COALESCE(EIC2.Costo, 0) AS Costo2,
CASE WHEN M.Volumen <> 0 AND M.Dividir = 1 THEN ROUND(COALESCE(EIC2.Costo, 0) / M.Volumen, ' + CAST(@Decimales AS VarChar) + ') WHEN M.Volumen <> 0 AND M.Dividir = 0 THEN ROUND(COALESCE(EIC2.Costo, 0) * M.Volumen, ' + CAST(@Decimales AS VarChar) + ') ELSE 0 END AS Importe2 '
SELECT @DescripcionMoneda2 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda2
IF @IdMoneda3 > 0 BEGIN
SET @Sql += ', COALESCE(EIC3.Costo, 0) AS Costo3,
CASE WHEN M.Volumen <> 0 AND M.Dividir = 1 THEN ROUND(COALESCE(EIC3.Costo, 0) / M.Volumen, ' + CAST(@Decimales AS VarChar) + ') WHEN M.Volumen <> 0 AND M.Dividir = 0 THEN ROUND(COALESCE(EIC3.Costo, 0) * M.Volumen, ' + CAST(@Decimales AS VarChar) + ') ELSE 0 END AS Importe3 '
SELECT @DescripcionMoneda3 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda3
END
END
SET @Sql += 'FROM PuMatrices AS M INNER JOIN
PuExpIns AS EI ON EI.IdExpIns = M.IdCodigoInsumo INNER JOIN
PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad LEFT JOIN
PuImagenes AS I ON C.IdImagen = I.IdImagen LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS EIC ON EIC.IdExpIns = EI.IdExpIns '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS EIC2 ON EIC2.IdExpIns = EI.IdExpIns '
IF @IdMoneda3 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS EIC3 ON EIC3.IdExpIns = EI.IdExpIns '
END
END
SET @Sql += 'WHERE M.IdCodigoMatriz = ' + CAST(@IdExpInsMatriz AS VarChar) + '
ORDER BY M.Renglon'
EXEC sp_executesql @Sql
GO
/****** Object:  StoredProcedure [dbo].[NeoMatrices_DameMonedasPresupuesto]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 06-Ago-2009
-- Description:	Devuelve los IdMoneda  extra para mostrar en Matrices
-- =============================================
CREATE PROCEDURE [dbo].[NeoMatrices_DameMonedasPresupuesto]
@IdPresupuesto AS Int,
@IdMonedaCaptura AS Int,
@SegundoIdMoneda AS Int OUTPUT,
@TercerIdMoneda AS Int OUTPUT
AS
BEGIN
SET NOCOUNT ON;
DECLARE @X AS Int = 0,
@IdMoneda AS Int,
@Val AS VarChar(250)
EXEC @IdMoneda = NeoParametros_Lee 'SegundaMonedaEnPresupuesto', '0', @Idpresupuesto, @val
IF @IdMoneda > 0 BEGIN
IF @IdMoneda <> @IdMonedaCaptura BEGIN
SET @SegundoIdMoneda = @IdMoneda
SET @X += 1
END
EXEC @IdMoneda = NeoParametros_Lee 'TercerMonedaEnPresupuesto', '0', @Idpresupuesto
If @IdMoneda > 0 BEGIN
IF @IdMoneda <> @IdMonedaCaptura BEGIN
IF @X = 0 BEGIN
SET @SegundoIdMoneda = @IdMoneda
END ELSE BEGIN
SET @TercerIdMoneda = @IdMoneda
END
SET @X += 1
END
IF @X < 2 BEGIN
EXEC @IdMoneda = NeoParametros_Lee 'CuartaMonedaEnPresupuesto', '0', @Idpresupuesto
IF @IdMoneda > 0 BEGIN
IF @IdMoneda <> @IdMonedaCaptura BEGIN
IF @X = 0 BEGIN
SET @SegundoIdMoneda = @IdMoneda
END ELSE BEGIN
SET @TercerIdMoneda = @IdMoneda
END
END
END
END
END
END
END
GO
/****** Object:  StoredProcedure [dbo].[NeoMatrices_Eliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 1-Junio-2009
-- Description:	Método para eliminar insumos de matrices
-- =============================================
CREATE PROCEDURE [dbo].[NeoMatrices_Eliminar]
@IdMatriz AS Int
AS
BEGIN
SET NOCOUNT ON;
DELETE FROM PuMatrices
WHERE IdMatriz = @IdMatriz
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al eliminar el insumo. No se afectaron registros', 16, 1)
RETURN
END
END
GO
/****** Object:  StoredProcedure [dbo].[NeoMatrices_GrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 27-May-2009
-- Description:	Procedimiento para Guardar /Actualizar Insumos en Matrices
-- =============================================
CREATE PROCEDURE [dbo].[NeoMatrices_GrabarActualizar]
@IdPresupuesto AS Int,
@IdMatriz AS Int OUTPUT,
@IdExpInsMatriz AS Int,
@Renglon AS Int OUTPUT,
@IdExpInsInsumo AS Int OUTPUT,
@Costo AS Money,
@IdCodigoInsumo AS Int,
@Volumen AS Decimal(18, 6),
@Dividir AS Bit,
@Expresion AS VarChar(50),
@IdMoneda AS Int,
@EsCostoHorario AS Bit,
@IdUsuario AS Int
AS BEGIN
SET NOCOUNT ON;
DECLARE @CostoActual AS Money,
@IdProveedor AS Int,
@Error AS VarChar(1000),
@Severity  AS Int,
@State AS Int,
@IdTipoInsumo AS Int,
@CostoTipo AS Decimal(18, 6),
@Decimales AS Int,
@IdExpInsActual AS Int
BEGIN TRAN
BEGIN TRY
-- Reviso si el Insumo existe en ExpIns si no se inserta
IF @IdExpInsInsumo = 0 BEGIN
-- Hay que obtener el proveedor del Insumo
SELECT @IdProveedor  = IdProveedor
FROM PuCatalogo
WHERE IdCodigo = @IdCodigoInsumo
-- Se inserta el Insumo en ExpIns
INSERT INTO PuExpIns ( IdPresupuesto, IdCodigo, IdProveedor, EsCostoHorario )
VALUES ( @IdPresupuesto, @IdCodigoInsumo, @IdProveedor, @EsCostoHorario )
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al insertar el insumo en ExpIns. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdExpInsInsumo = @@IDENTITY
END ELSE BEGIN
UPDATE PuExpIns
SET EsCostoHorario = @EsCostoHorario
WHERE IdExpIns = @IdExpInsInsumo
END
-- Actualizo el Costo
IF EXISTS(SELECT IdExpInsCosto FROM PuExpInsCostos WHERE IdExpIns = @IdExpInsInsumo AND IdMoneda = @IdMoneda ) BEGIN
-- Existe el costo para esta moneda entonces se actualiza
SELECT @CostoActual = Costo FROM PuExpInsCostos WHERE IdExpIns = @IdExpInsInsumo AND IdMoneda = @IdMoneda
IF @CostoActual IS NULL BEGIN
RAISERROR('Error al obtener el costo del concepto en ExpIns.', 16, 1)
RETURN
END
-- Revisa si el costo es diferente y lo actualiza
IF @Costo <> @CostoActual BEGIN
UPDATE PuExpInsCostos
SET Costo = @Costo, Fecha = GETDATE()
WHERE IdExpIns = @IdExpInsInsumo AND IdMoneda = @IdMoneda
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al actualizar Costo en ExpInsCostos.', 16, 1)
RETURN
END
EXEC NeoBitacoraCostos_GrabaBitacora @IdExpInsInsumo, @IdMoneda, @IdUsuario, @Costo
END
END ELSE BEGIN
-- No existe el costo en esta moneda asi que se inserta
INSERT INTO PuExpInsCostos ( IdExpIns, IdMoneda, Costo, Fecha )
VALUES ( @IdExpInsInsumo, @IdMoneda, @Costo, GETDATE() )
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al insertar Costo en ExpInsCostos.', 16, 1)
RETURN
END
EXEC NeoBitacoraCostos_GrabaBitacora @IdExpInsInsumo, @IdMoneda, @IdUsuario, @Costo
END
-- Grabo/Actualizo el Concepto
IF @IdMatriz = 0 BEGIN
-- Si no se asignó renglon se calcula
IF @Renglon Is NULL BEGIN
SELECT @Renglon = MAX(Renglon) FROM PuMatrices WHERE IdCodigoMatriz = @IdExpInsMatriz
IF @Renglon IS NULL BEGIN
SET @Renglon = 1
END ELSE BEGIN
SET @Renglon = @Renglon + 1
END
END
-- Insertar
INSERT INTO PuMatrices ( IdCodigoMatriz, Renglon, IdCodigoInsumo, Dividir, Volumen, Expresion )
VALUES ( @IdExpInsMatriz, @Renglon, @IdExpInsInsumo, @Dividir, @Volumen, @Expresion )
SET @IdMatriz = @@IDENTITY
END ELSE BEGIN
-- Actualizar
UPDATE PuMatrices
SET Renglon = @Renglon, IdCodigoInsumo = @IdExpInsInsumo, Dividir = @Dividir, Volumen = @Volumen, Expresion = @Expresion
WHERE IdMatriz = @IdMatriz
END
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al Grabar/Actualizar. No se afectaron registros', 16, 1)
RETURN
END
--    -- Obtengo el Número de Decimales
--    EXEC @Decimales = NeoParametros_DecimalesRedondeo
--
--    -- Obtengo el Tipo de Insumo
--    SELECT @IdTipoInsumo = C.IdTipo
--    FROM PuExpIns AS EI INNER JOIN
--         PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo
--    WHERE EI.IdExpIns = @IdCodigoInsumo
--
--    -- Reviso si se afectan porcentajes y hago el cálculo
--    SET @CostoTipo = NULL
--    DECLARE Proc_NeoMatrices_GarbarActualizar CURSOR LOCAL FORWARD_ONLY KEYSET OPTIMISTIC FOR
--            SELECT EI.IdExpIns, EI.Costo
--            FROM PuMatrices AS M INNER JOIN
--                 PuExpIns AS EI ON EI.IdExpIns = M.IdCodigoInsumo INNER JOIN
--                 PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo
--            WHERE M.IdCodigoMatriz = @IdCodigoMatriz AND C.EsPorcentaje = @IdTipoInsumo
--            FOR UPDATE OF EI.Costo
--    OPEN Proc_NeoMatrices_GarbarActualizar
--    FETCH NEXT FROM Proc_NeoMatrices_GarbarActualizar INTO @IdExpInsActual, @CostoActual
--    WHILE @@FETCH_STATUS = 0 BEGIN
--      -- Si hay Porcentajes del Tipo se calcula el Costo acumulado por Tipo
--      IF @CostoTipo IS NULL BEGIN
--        SELECT @CostoTipo = SUM(CASE WHEN M.Dividir = 1 THEN ROUND(EI.Costo / M.Volumen, @Decimales) ELSE ROUND(EI.Costo * M.Volumen, @Decimales) END)
--        FROM PuMatrices AS M INNER JOIN
--             PuExpIns AS EI ON EI.IdExpIns = M.IdCodigoInsumo INNER JOIN
--             PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo
--        WHERE M.IdCodigoMatriz = @IdCodigoMatriz AND C.EsPorcentaje = 0 AND C.IdTipo = @IdTipoInsumo
--      END
--      IF @CostoTipo IS NULL BEGIN
--        SET @CostoTipo = 0
--      END
--      -- Revisa si el Costo esta mal y lo actualiza
--      IF @CostoActual <> @CostoTipo BEGIN
--        UPDATE PuExpIns
--        SET PuExpIns.Costo = @CostoTipo
--        WHERE CURRENT OF Proc_NeoMatrices_GarbarActualizar
--      END
--      FETCH NEXT FROM Proc_NeoMatrices_GarbarActualizar INTO @IdExpInsActual, @CostoActual
--    END
--    CLOSE Proc_NeoMatrices_GarbarActualizar
--    DEALLOCATE Proc_NeoMatrices_GarbarActualizar
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Severity = ERROR_SEVERITY()
SET @State = ERROR_STATE()
SET @Error = ERROR_MESSAGE()
RAISERROR(@Error, @Severity, @State)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoMatrices_GrabarSoloMatriz]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 27-May-2009
-- Description:	Procedimiento para Guardar /Actualizar Insumos en Matrices
-- =============================================
CREATE PROCEDURE [dbo].[NeoMatrices_GrabarSoloMatriz]
@IdPresupuesto AS Int,
@IdMatriz AS Int OUTPUT,
@Renglon AS Int OUTPUT,
@IdCodigoMatriz AS Int,
@IdCodigoInsumo AS Int,
@Volumen AS Decimal(18, 6),
@Dividir AS Bit,
@Expresion AS VarChar(50)
AS BEGIN
SET NOCOUNT ON;
DECLARE @Error AS VarChar(1000),
@Severity  AS Int,
@State AS Int
BEGIN TRAN
BEGIN TRY
-- Si no se asignó renglon se calcula
IF @Renglon Is NULL BEGIN
SELECT @Renglon = MAX(Renglon) FROM PuMatrices WHERE IdCodigoMatriz = @IdCodigoMatriz
IF @Renglon IS NULL BEGIN
SET @Renglon = 10
END ELSE BEGIN
SET @Renglon = @Renglon + 10
END
END
-- Inserto el detalle de la Matriz
INSERT INTO PuMatrices ( IdCodigoMatriz, Renglon, IdCodigoInsumo, Dividir, Volumen, Expresion )
VALUES ( @IdCodigoMatriz, @Renglon, @IdCodigoInsumo, @Dividir, @Volumen, @Expresion )
SET @IdMatriz = @@IDENTITY
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al Insertar. No se afectaron registros', 16, 1)
RETURN
END
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Severity = ERROR_SEVERITY()
SET @State = ERROR_STATE()
SET @Error = ERROR_MESSAGE()
RAISERROR(@Error, @Severity, @State)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoParametroReportes_Guardar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Carlos Bedolla
-- Create date: 23-Ago-2009
-- Description:   Guarda un parámetro de Reportes
-- =============================================
CREATE PROCEDURE [dbo].[NeoParametroReportes_Guardar]
@IdUsuario AS Int,
@IdRepHoja AS Int,
@Parametro AS VarChar(80),
@ValorString AS VarChar(255),
@ValorNumero AS Decimal(18,6),
@ValorFecha AS DateTime
AS
BEGIN
SET NOCOUNT ON;
DECLARE @IdRepOpcion AS Int,
@IdParametro AS Int
SELECT @IdParametro = P.IdParametro, @IdRepOpcion = O.IdRepOpcion
FROM PuRepParametros AS P LEFT JOIN
( SELECT IdRepOpcion, IdParametro
FROM PuRepOpciones
WHERE IdRepHoja = @IdRepHoja AND IdUsuario = @IdUsuario ) AS O ON O.IdParametro = P.IdParametro
WHERE P.Parametro = @Parametro
IF @IdParametro IS NULL BEGIN
-- Hay que crear el parámetro e insertarlo para este reporte
INSERT INTO PuRepParametros ( Parametro )
VALUES ( @Parametro )
INSERT INTO PuRepOpciones ( IdRepHoja, IdUsuario, IdParametro, ValorString, ValorNumero, ValorFecha )
VALUES ( @IdRepHoja, @IdUsuario, @@IDENTITY, @ValorString, @ValorNumero, @ValorFecha )
END ELSE BEGIN
IF @IdRepOpcion IS NULL BEGIN
-- Hay que insertar el parámetro para este reporte
INSERT INTO PuRepOpciones ( IdRepHoja, IdUsuario, IdParametro, ValorString, ValorNumero, ValorFecha )
VALUES ( @IdRepHoja, @IdUsuario, @IdParametro, @ValorString, @ValorNumero, @ValorFecha )
END ELSE BEGIN
-- Solo debo actualizar el parámetro
UPDATE PuRepOpciones
SET ValorString = @ValorString, ValorNumero = @ValorNumero, ValorFecha = @ValorFecha
WHERE IdRepOpcion = @IdRepOpcion
END
END
END
GO
/****** Object:  StoredProcedure [dbo].[NeoParametroReportes_Leer]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Carlos Bedolla
-- Create date: 23-Ago-2009
-- Description:   Lee un parámetro de Reportes
-- =============================================
CREATE PROCEDURE [dbo].[NeoParametroReportes_Leer]
@IdUsuario AS Int,
@IdRepHoja AS Int,
@Parametro AS VarChar(80)
AS
BEGIN
SET NOCOUNT ON;
SELECT O.ValorString, O.ValorNumero, O.ValorFecha
FROM PuRepParametros AS P INNER JOIN
PuRepOpciones AS O ON O.IdParametro = P.IdParametro
WHERE P.Parametro = @Parametro AND O.IdRepHoja = @IdRepHoja AND O.IdUsuario = @IdUsuario
END
GO
/****** Object:  StoredProcedure [dbo].[NeoParametros_DecimalesRedondeo]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 10-Junio-2009
-- Description:	Devuelve los Decimales para Redondeo de PuParametros
-- =============================================
CREATE PROCEDURE [dbo].[NeoParametros_DecimalesRedondeo]
@IdPresupuesto AS Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @Decimales AS Int,
@Dec AS VarChar(250)
EXEC @Dec = NeoParametros_Lee @Parametro = 'DecimalesRedondeo', @IdPresupuesto = @IdPresupuesto
IF @Dec IS NULL BEGIN
RAISERROR('Error al obtener el número de decimales', 16, 1)
RETURN 0
END
SET @Decimales = CAST(@Dec AS Int)
RETURN @Decimales
END
GO
/****** Object:  StoredProcedure [dbo].[NeoParametros_DecimalesRedondeoConceptos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 22-Junio-2009
-- Description:	Devuelve los Decimales para Redondeo de Conceptos y Partidas
-- =============================================
CREATE PROCEDURE [dbo].[NeoParametros_DecimalesRedondeoConceptos]
@IdPresupuesto AS Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @Decimales AS Int,
@Dec AS VarChar(250)
EXEC @Dec = NeoParametros_Lee @Parametro = 'DecimalesRedondeoConceptos', @IdPresupuesto = @IdPresupuesto
IF @Dec IS NULL BEGIN
RAISERROR('Error al obtener el número de decimales para conceptos', 16, 1)
RETURN 0
END
SET @Decimales = CAST(@Dec AS Int)
RETURN @Decimales
END
GO
/****** Object:  StoredProcedure [dbo].[NeoParametros_DecimalesRedondeoMatrices]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 22-Junio-2009
-- Description:	Devuelve los Decimales para Redondeo de Matrices
-- =============================================
CREATE PROCEDURE [dbo].[NeoParametros_DecimalesRedondeoMatrices]
@IdPresupuesto AS Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @Decimales AS Int,
@Dec AS VarChar(250)
EXEC @Dec = NeoParametros_Lee @Parametro = 'DecimalesRedondeoMatrices', @IdPresupuesto = @IdPresupuesto
IF @Dec IS NULL BEGIN
RAISERROR('Error al obtener el número de decimales para conceptos', 16, 1)
RETURN 0
END
SET @Decimales = CAST(@Dec AS Int)
RETURN @Decimales
END
GO
/****** Object:  StoredProcedure [dbo].[NeoParametros_Graba]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 7-Julio-2009
-- Description:	Graba el parametros especificado
-- =============================================
CREATE PROCEDURE [dbo].[NeoParametros_Graba]
@Parametro AS VarChar(30),
@Valor AS VarChar(250),
@IdPresupuesto AS Int = 0
AS
BEGIN
SET NOCOUNT ON;
DECLARE @Especifico AS Bit,
@IdPresupuestoParametro AS Int,
@Explicacion AS VarChar(250)
SELECT @Especifico = P.Especifico, @IdPresupuestoParametro = PP.IdPresupuestoParametro,
@Explicacion = P.Explicacion
FROM PuParametros AS P LEFT JOIN
PuPresupuestosParametros AS PP ON PP.Parametro = P.Parametro AND PP.IdPresupuesto = @IdPresupuesto
WHERE P.Parametro = @Parametro
IF @Especifico = 0 BEGIN
UPDATE PuParametros
SET Valor = @Valor
WHERE Parametro = @Parametro
END ELSE BEGIN
IF @IdPresupuestoParametro IS NULL BEGIN
INSERT INTO PuPresupuestosParametros ( IdPresupuesto, Parametro, Valor, Explicacion )
VALUES ( @IdPresupuesto, @Parametro, @Valor, @Explicacion )
END ELSE BEGIN
UPDATE PuPresupuestosParametros
SET Valor = @Valor
WHERE IdPresupuesto = @IdPresupuesto AND Parametro = @Parametro
END
END
END
GO
/****** Object:  StoredProcedure [dbo].[NeoParametros_Lee]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 10-Junio-2009
-- Description:	Lee el parametros especificado
-- =============================================
CREATE PROCEDURE [dbo].[NeoParametros_Lee]
@Parametro AS VarChar(30),
@ValorPorDefecto AS VarChar(250) = NULL,
@IdPresupuesto AS Int = 0,
@Valor AS VarChar(250) = '' OUT
AS
BEGIN
SET NOCOUNT ON;
DECLARE @Sql AS nVarChar(200),
@Especifico AS Bit,
@IdPresupuestoParametro AS Int,
@Valor2 AS VarChar(250),
@Explicacion AS VarChar(250),
@ReturnValue AS Int
SELECT @Valor = P.Valor, @Especifico = P.Especifico, @IdPresupuestoParametro = PP.IdPresupuestoParametro,
@Valor2 = PP.Valor, @Explicacion = P.Explicacion
FROM PuParametros AS P LEFT JOIN
PuPresupuestosParametros AS PP ON PP.Parametro = P.Parametro AND PP.IdPresupuesto = @IdPresupuesto
WHERE P.Parametro = @Parametro
IF @Valor IS NULL BEGIN
SET @Valor = @ValorPorDefecto
END
IF @Especifico = 1 BEGIN
IF @IdPresupuestoParametro IS NULL BEGIN
INSERT INTO PuPresupuestosParametros ( IdPresupuesto, Parametro, Valor, Explicacion )
VALUES ( @IdPresupuesto, @Parametro, @Valor, @Explicacion )
END ELSE BEGIN
SEt @Valor = @Valor2
END
END
IF @Valor IS NULL BEGIN
SET @Valor = @ValorPorDefecto
END
BEGIN TRY
SET @ReturnValue = CAST(@Valor AS Int)
END TRY
BEGIN CATCH
SET @ReturnValue = 0
END CATCH;
RETURN @ReturnValue
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPartidas_CargaDatosGrid]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 26-Mayo-2009
-- Description:	Devuelve el DataTable con las Partidas por IdPresupuesto y el FolioEstructuraPartidas
-- =============================================
CREATE PROCEDURE [dbo].[NeoPartidas_CargaDatosGrid]
@IdPresupuesto AS Int,
@SqlLike AS VarChar(max),
@ExcluirRegistrosEnBusqueda AS Bit,
@FolioEstructuraPartidas As Int OUTPUT,
@IdMoneda As Int
AS
DECLARE @Tipo AS VarChar(100),
@Sql AS nVarChar(max)
SET @Tipo = 'FolioEstructuraPartidas'
EXEC @FolioEstructuraPartidas = NeoPresupuestoConsecutivo_DameActual @Tipo, @IdPresupuesto
IF @ExcluirRegistrosEnBusqueda = 0 OR @SqlLike IS NULL  BEGIN
SELECT PP.IdPresupuestoPartida, PP.IdPresupuesto, PP.IdPartidaPadre, PP.PartidaWBS, PP.Partida, PP.Partida AS PartidaOriginal, PP.Renglon, PP.Cantidad, COALESCE(PPC.Costo, 0) AS Costo,
COALESCE(PPC.Precio, 0) AS Precio, PP.Cantidad * COALESCE(PPC.Costo, 0) AS ImporteCosto, PP.Cantidad * COALESCE(PPC.Precio, 0) AS ImportePrecio,
CASE WHEN MetrosCuadrados = 0 THEN CAST(0 AS Decimal(18,6)) ELSE COALESCE(PPC.Costo, 0) / MetrosCuadrados END AS CostoXM2,
CASE WHEN MetrosCuadrados = 0 THEN CAST(0 AS Decimal(18,6)) ELSE COALESCE(PPC.Precio, 0) / MetrosCuadrados END AS PrecioXM2,
MetrosCuadrados, DescripcionPartida, DescripcionPartidaLarga
FROM PuPresupuestosPartidas AS PP LEFT JOIN
(SELECT IdPresupuestoPartida, Costo, Precio
FROM PuPresupuestosPartidasCostos
WHERE IdMoneda = @IdMoneda) AS PPC ON PPC.IdPresupuestoPartida = PP.IdPresupuestoPartida
WHERE PP.IdPresupuesto = @IdPresupuesto
ORDER BY PP.IdPartidaPadre, PP.Renglon
END ELSE BEGIN
SET @Sql = 'WITH Arbol ( IdPresupuestoPartida, IdPresupuesto, IdPartidaPadre, PartidaWBS, Partida, PartidaOriginal, Renglon,
Cantidad, MetrosCuadrados, DescripcionPartida, DescripcionPartidaLarga )
AS (
SELECT PP.IdPresupuestoPartida, PP.Idpresupuesto, PP.IdPartidaPadre, PP.PartidaWBS, PP.Partida, PP.Partida AS PartidaOriginal, PP.Renglon,
PP.Cantidad, PP.MetrosCuadrados, PP.DescripcionPartida, PP.DescripcionPartidaLarga
FROM PuPresupuestosPartidas AS PP INNER JOIN
PuPresupuestosConceptos AS PC ON PP.IdPresupuestoPartida = PC.IdPresupuestoPartida INNER JOIN
PuExpIns AS EI ON EI.IdExpins = PC.IdExpIns INNER JOIN
PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo
WHERE PC.IdPresupuesto = ' + CAST(@IdPresupuesto AS VarChar) + ' ' + @SqlLike + '
GROUP BY PP.IdpresupuestoPartida, PP.IdPresupuesto, PP.IdPartidaPadre, PP.PartidaWBS, PP.Partida, PP.Renglon,
PP.Cantidad, PP.MetrosCuadrados, PP.DescripcionPartida, PP.DescripcionPartidaLarga
UNION ALL
SELECT PP.IdPresupuestoPartida, PP.IdPresupuesto, PP.IdPartidaPadre, PP.PartidaWBS, PP.Partida, PP.Partida AS PartidaOriginal, PP.Renglon,
PP.Cantidad, PP.MetrosCuadrados, PP.DescripcionPartida, PP.DescripcionPartidaLarga
FROM PuPresupuestosPartidas AS PP INNER JOIN
Arbol AS A ON A.IdpartidaPadre = PP.IdPresupuestoPartida
)
SELECT DISTINCT PP.IdPresupuestoPartida, PP.IdPresupuesto, PP.IdPartidaPadre, PP.PartidaWBS, PP.Partida, PP.Renglon, PP.Cantidad, COALESCE(PPC.Costo, 0) AS Costo,
COALESCE(PPC.Precio, 0) AS Precio, PP.Cantidad * COALESCE(PPC.Costo, 0) AS ImporteCosto, PP.Cantidad * COALESCE(PPC.Precio, 0) AS ImportePrecio,
CASE WHEN MetrosCuadrados = 0 THEN CAST(0 AS Decimal(18,6)) ELSE COALESCE(PPC.Costo, 0) / MetrosCuadrados END AS CostoXM2,
CASE WHEN MetrosCuadrados = 0 THEN CAST(0 AS Decimal(18,6)) ELSE COALESCE(PPC.Precio, 0) / MetrosCuadrados END AS PrecioXM2,
PP.MetrosCuadrados, PP.DescripcionPartida, PP.DescripcionPartidaLarga
FROM Arbol AS PP LEFT JOIN
(SELECT IdPresupuestoPartida, Costo, Precio
FROM PuPresupuestosPartidasCostos
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PPC ON PPC.IdPresupuestoPartida = PP.IdPresupuestoPartida
ORDER BY PP.IdPartidaPadre, PP.Renglon'
EXEC sp_executesql @Sql
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPartidas_DameDrPartida]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 2-Junio-2009
-- Description:	Devuelve un DataRow con los datos de la partida
--              se usa en el pegado desde Excel y en la pantalla de detalle
-- =============================================
CREATE PROCEDURE [dbo].[NeoPartidas_DameDrPartida]
@IdPresupuestoPartida AS Int,
@IdMoneda AS Int
AS
BEGIN
SET NOCOUNT ON;
SELECT PP.IdPresupuestoPartida, PP.IdPresupuesto, PP.IdPartidaPadre, PP.Partida, PP.PartidaAuxiliar, PP.ClavePresupuestal, PP.Renglon, PP.Cantidad, COALESCE(PPC.Costo, 0) AS Costo,
COALESCE(PPC.Precio, 0) AS Precio, PP.Cantidad * COALESCE(PPC.Costo, 0) AS ImporteCosto, PP.Cantidad * COALESCE(PPC.Precio, 0) AS ImportePrecio,
COALESCE(PPC.Costo, 0) * PP.MetrosCuadrados AS CostoXM2, COALESCE(PPC.Precio, 0) * PP.MetrosCuadrados AS PrecioXM2,
PP.MetrosCuadrados, PP.DescripcionPartida, PP.DescripcionPartidaLarga, PP.IdImagen
FROM PuPresupuestosPartidas AS PP LEFT JOIN
(SELECT IdPresupuestoPartida, Costo, Precio
FROM PuPresupuestosPartidasCostos
WHERE IdMoneda = @IdMoneda) AS PPC ON PPC.IdPresupuestoPartida = PP.IdPresupuestoPartida
WHERE PP.IdPresupuestoPartida = @IdPresupuestoPartida
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPartidas_DameDtBusqueda]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 28-Mayo-2009
-- Description:	Obtiene los IdPresupuestoPartida que contengan conceptos que coincidan con la busqueda
-- =============================================
CREATE PROCEDURE [dbo].[NeoPartidas_DameDtBusqueda]
@IdPresupuesto AS Int,
@SqlLike AS VarChar(2000)
AS
BEGIN
SET NOCOUNT ON;
DECLARE @Sql AS nVarChar(2000)
SET @Sql = 'SELECT PC.IdPresupuestoPartida
FROM PuPresupuestosConceptos AS PC INNER JOIN
PuExpIns AS EI ON EI.IdExpIns = PC.IdExpIns INNER JOIN
PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo
WHERE PC.IdPresupuesto = ' + CAST(@IdPresupuesto AS VarChar(10)) + ' ' + @SqlLike + '
GROUP BY PC.IdPresupuestoPartida '
EXEC sp_executesql @Sql
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPartidas_DameRenglon]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 26-Mayo-2009
-- Description:	Devuelve el Renglon de una Partida
-- =============================================
CREATE PROCEDURE [dbo].[NeoPartidas_DameRenglon]
@IdPresupuestoPartida AS Int
AS
SELECT Renglon
FROM PuPresupuestosPartidas
WHERE IdPresupuestoPartida = @IdPresupuestoPartida
GO
/****** Object:  StoredProcedure [dbo].[NeoPartidas_Eliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 1-Junio-2009
-- Description:	Método para eliminar conceptos
-- =============================================
CREATE PROCEDURE [dbo].[NeoPartidas_Eliminar]
@IdPresupuestoPartida AS Int,
@FolioEstructuraPartidas AS Int OUTPUT
AS
BEGIN
SET NOCOUNT ON;
DECLARE @Error AS VarChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int,
@Tipo AS VarChar(100),
@FolioEstructuraPartidasActual AS Int,
@IdPresupuesto AS Int
BEGIN TRAN
BEGIN TRY
-- Obtengo el IdPresupuesto
SELECT @IdPresupuesto = IdPresupuesto FROM PuPresupuestosPartidas WHERE IdPresupuestoPartida = @IdPresupuestoPartida
-- Revisa que se tenga la última version del arbol de partidas
SET @Tipo = 'FolioEstructuraPartidas'
EXEC @FolioEstructuraPartidasActual = NeoPresupuestoConsecutivo_DameActual @Tipo, @IdPresupuesto
IF @FolioEstructuraPartidas <> @FolioEstructuraPartidasActual BEGIN
RAISERROR('El arbol de partidas ha sido modificado por otro usuario, actualize y vuelva a intentarlo.', 16, 1)
RETURN
END
-- Obtengo el nuevo Folio de Estructura de Partidas
EXEC @FolioEstructuraPartidas = NeoPresupuestoConsecutivo_DameSiguiente @Tipo, @IdPresupuesto
EXEC NeoPartidas_EliminarRecursivo @IdPresupuestoPartida
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPartidas_EliminarRecursivo]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 1-Junio-2009
-- Description:	Método para eliminar conceptos
-- =============================================
CREATE PROCEDURE [dbo].[NeoPartidas_EliminarRecursivo]
@IdPresupuestoPartida AS Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @IdPresupuestoPartidaHija AS Int,
@Error AS varChar(200)
-- Obtengo las Partidas hijas y las elimino
DECLARE Proc_NeoPartidas_EliminarRecursivo CURSOR LOCAL FORWARD_ONLY FAST_FORWARD READ_ONLY FOR
SELECT IdPresupuestoPartida
FROM PuPresupuestosPartidas
WHERE IdPartidaPadre = @IdPresupuestoPartida
OPEN Proc_NeoPartidas_EliminarRecursivo
FETCH NEXT FROM Proc_NeoPartidas_EliminarRecursivo INTO @IdPresupuestoPartidaHija
WHILE @@FETCH_STATUS = 0 BEGIN
EXEC NeoPartidas_EliminarRecursivo @IdPresupuestoPartidaHija
FETCH NEXT FROM Proc_NeoPartidas_EliminarRecursivo INTO @IdPresupuestoPartidaHija
END
CLOSE Proc_NeoPartidas_EliminarRecursivo
DEALLOCATE Proc_NeoPartidas_EliminarRecursivo
-- Elimino las Ligas de Ruta Critica de los Conceptos
DELETE FROM PuLigasRuta
WHERE IdConceptoOrigen IN (SELECT PC.IdProgramaConcepto
FROM PuProgramaConceptos AS PC INNER JOIN
PuPresupuestosConceptos AS PC2 ON PC2.IdPresupuestoConcepto = PC.IdPresupuestoConcepto
WHERE PC2.IdPresupuestoPartida = @IdPresupuestoPartida) OR
IdConceptoDestino IN (SELECT PC.IdProgramaConcepto
FROM PuProgramaConceptos AS PC INNER JOIN
PuPresupuestosConceptos AS PC2 ON PC2.IdPresupuestoConcepto = PC.IdPresupuestoConcepto
WHERE PC2.IdPresupuestoPartida = @IdPresupuestoPartida)
-- Elimino los Conceptos de la partida Eliminada
DELETE FROM PuPresupuestosConceptos
WHERE IdPresupuestoPartida = @IdPresupuestoPartida
-- Elimino la partida
DELETE FROM PuPresupuestosPartidas
WHERE IdPresupuestoPartida = @IdPresupuestoPartida
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al eliminar la partida. No se afectaron registros', 16, 1)
RETURN
END
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPartidas_GrabaPosicionPartida]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 17-Mayo-2009
-- Last Edit:   28-Mayo-2009
-- Description:	Procedimiento para cambiar una Partida de padre, renglon y Renumerar
-- =============================================
CREATE PROCEDURE [dbo].[NeoPartidas_GrabaPosicionPartida]
@IdPresupuesto AS Int,
@IdPresupuestoPartida AS Int,
@IdPartidaPadre AS Int,
@Renglon AS Int,
@RenumerarPartida1 AS Int,
@RenumerarPartida2 AS Int,
@FolioEstructuraPartidas AS Int OUTPUT
AS
DECLARE @FolioEstructuraPartidasActual AS Int,
@Tipo AS VarChar(100),
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
-- Revisa que se tenga la última version del arbol de partidas
SET @Tipo = 'FolioEstructuraPartidas'
EXEC @FolioEstructuraPartidasActual = NeoPresupuestoConsecutivo_DameActual @Tipo, @IdPresupuesto
IF @FolioEstructuraPartidas <> @FolioEstructuraPartidasActual BEGIN
RAISERROR('El arbol de partidas ha sido modificado por otro usuario, actualize y vuelva a intentarlo.', 16, 1)
RETURN
END
IF @IdPresupuestoPartida = @IdPartidaPadre BEGIN
RAISERROR('La partida no puede estar contenida en si misma.', 16, 1)
RETURN
END
-- Obtengo el nuevo Folio de Estructura de Partidas
EXEC @FolioEstructuraPartidas = NeoPresupuestoConsecutivo_DameSiguiente @Tipo, @IdPresupuesto
-- Actualizo la nueva posición de la Partida
UPDATE PuPresupuestosPartidas
SET IdPartidaPadre = @IdPartidaPadre, Renglon = @Renglon
WHERE IdPresupuestoPartida = @IdPresupuestoPartida
-- Renumero los childs de las partidas padre
EXECUTE NeoPartidas_RenumerarRenglonPorNivel @IdPresupuesto, @RenumerarPartida1
EXECUTE NeoPartidas_RenumerarRenglonPorNivel @IdPresupuesto, @RenumerarPartida2
-- Comprometo los cambios
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
GO
/****** Object:  StoredProcedure [dbo].[NeoPartidas_GrabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 2-Junio-2009
-- Description:	Inserta o Actualiza un Partida
-- =============================================
CREATE PROCEDURE [dbo].[NeoPartidas_GrabarActualizar]
@IdPresupuestoPartida AS Int OUTPUT,
@IdPresupuesto AS Int,
@IdPartidaPadre AS Int,
@Partida AS VarChar(20),
@IdImagen AS Int,
@Renglon AS Int OUTPUT,
@Cantidad AS Decimal(18, 6),
@Costo AS Money,
@Precio AS Money,
@MetrosCuadrados AS Decimal(18, 6),
@DescripcionPartida AS VarChar(40),
@DescripcionPartidaLarga AS Text,
-- Este solo se usa cuando se Inserta una nueva partida
@FolioEstructuraPartidas AS Int OUTPUT,
@IdMoneda AS Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @FolioEstructuraPartidasActual AS Int,
@Tipo AS VarChar(100),
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
IF @IdPresupuestoPartida = 0 BEGIN
-- Revisa que se tenga la última version del arbol de partidas
SET @Tipo = 'FolioEstructuraPartidas'
EXEC @FolioEstructuraPartidasActual = NeoPresupuestoConsecutivo_DameActual @Tipo, @IdPresupuesto
IF @FolioEstructuraPartidas <> @FolioEstructuraPartidasActual BEGIN
RAISERROR('El arbol de partidas ha sido modificado por otro usuario, actualize y vuelva a intentarlo.', 16, 1)
RETURN
END
-- Obtengo el nuevo Folio de Estructura de Partidas
EXEC @FolioEstructuraPartidas = NeoPresupuestoConsecutivo_DameSiguiente @Tipo, @IdPresupuesto
-- Si se esta insertando y el Renglon es NULL lo calculo
IF @Renglon IS NULL BEGIN
IF @IdPartidaPadre IS NULL BEGIN
SELECT @Renglon = MAX(Renglon)
FROM PuPresupuestosPartidas
WHERE IdPresupuesto = @IdPresupuesto AND IdPartidaPadre IS NULL
END ELSE BEGIN
SELECT @Renglon = MAX(Renglon)
FROM PuPresupuestosPartidas
WHERE IdPresupuesto = @IdPresupuesto AND IdPartidaPadre = @IdPartidaPadre
END
IF @Renglon IS NULL
SET @Renglon = 0
SET @Renglon = @Renglon + 10
END
INSERT INTO PuPresupuestosPartidas ( IdPresupuesto, IdPartidaPadre, Partida, IdImagen, Renglon,
Cantidad, MetrosCuadrados, DescripcionPartida,
DescripcionPartidaLarga )
VALUES ( @IdPresupuesto, @IdPartidaPadre, @Partida, @IdImagen, @Renglon, @Cantidad,
@MetrosCuadrados, @DescripcionPartida, @DescripcionPartidaLarga )
SET @IdPresupuestoPartida = @@IDENTITY
IF @IdPresupuestoPartida = @IdPartidaPadre BEGIN
RAISERROR('La partida no puede estar contenida en si misma.', 16, 1)
RETURN
END
END ELSE BEGIN
IF @IdPresupuestoPartida = @IdPartidaPadre BEGIN
RAISERROR('La partida no puede estar contenida en si misma.', 16, 1)
RETURN
END
UPDATE PuPresupuestosPartidas
SET IdPresupuesto = @IdPresupuesto, IdPartidaPadre = @IdPartidaPadre, Partida = @Partida, IdImagen = @IdImagen,
Renglon = @Renglon, Cantidad = @Cantidad,
MetrosCuadrados = @MetrosCuadrados, DescripcionPartida = @DescripcionPartida,
DescripcionPartidaLarga = @DescripcionPartidaLarga
WHERE IdPresupuestoPartida = @IdPresupuestoPartida
END
-- Inserto/Actualizo el Costo y Precio
IF EXISTS(SELECT IdPresupuestoPartidaCosto FROM PuPresupuestosPartidasCostos WHERE IdPresupuestoPartida = @IdPresupuestoPartida AND IdMoneda = @IdMoneda) BEGIN
UPDATE PuPresupuestosPartidasCostos
SET Costo = @Costo, Precio = @Precio, Fecha = GETDATE()
WHERE IdPresupuestoPartida = @IdPresupuestoPartida AND IdMoneda = @IdMoneda
END ELSE BEGIN
INSERT INTO PuPresupuestosPartidasCostos ( IdPresupuestoPartida, IdMoneda, Costo, Precio, Fecha )
VALUES ( @IdPresupuestoPartida, @IdMoneda, @Costo, @Precio, GETDATE() )
END
-- Marca el presupuesto como Requiere Totalizar
UPDATE PuPresupuestos SET RequiereTotalizar = 1 WHERE IdPresupuesto = @IdPresupuesto AND RequiereTotalizar = 0
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPartidas_RenumerarRenglonPorNivel]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 27-Mayo-2009
-- Description:	Actualiza la posición de una Partida y renumera
-- =============================================
CREATE PROCEDURE [dbo].[NeoPartidas_RenumerarRenglonPorNivel]
@IdPresupuesto AS Int,
@IdNivel AS Int
AS
IF @IdNivel IS NULL BEGIN
UPDATE PuPresupuestosPartidas
SET Renglon = V.Renglon
FROM PuPresupuestosPartidas AS PP INNER JOIN
(SELECT IdPresupuestoPartida, ROW_NUMBER() OVER (ORDER BY PuPresupuestosPartidas.Renglon) * 10 AS Renglon
FROM PuPresupuestosPartidas
WHERE IdPresupuesto = @IdPresupuesto AND IdPartidaPadre IS NULL ) AS V ON V.IdPresupuestoPartida = PP.IdPresupuestoPartida
WHERE PP.IdPresupuesto = @IdPresupuesto AND PP.IdPartidaPadre IS NULL AND PP.Renglon <> V.Renglon
END ELSE BEGIN
UPDATE PuPresupuestosPartidas
SET Renglon = V.Renglon
FROM PuPresupuestosPartidas AS PP INNER JOIN
(SELECT IdPresupuestoPartida, ROW_NUMBER() OVER (ORDER BY PuPresupuestosPartidas.Renglon) * 10 AS Renglon
FROM PuPresupuestosPartidas
WHERE IdPresupuesto = @IdPresupuesto AND IdPartidaPadre = @IdNivel ) AS V ON V.IdPresupuestoPartida = PP.IdPresupuestoPartida
WHERE PP.IdPresupuesto = @IdPresupuesto AND PP.IdPartidaPadre = @IdNivel AND PP.Renglon <> V.Renglon
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPresupuestoConsecutivo_DameActual]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 27-Mayo-2009
-- Description:	Obtiene el siguiente Id de PuPresupuestosConsecutivos
-- =============================================
CREATE PROCEDURE [dbo].[NeoPresupuestoConsecutivo_DameActual]
@Tipo AS VarChar(100),
@IdPresupuesto AS Int
AS BEGIN
SET NOCOUNT ON;
DECLARE @Folio AS Int
-- Reviso si existe el registro del Presupuesto sino lo creo
IF NOT EXISTS(SELECT IdPresupuesto FROM PuPresupuestosConsecutivos WHERE IdPresupuesto = @IdPresupuesto) BEGIN
INSERT INTO PuPresupuestosConsecutivos ( IdPresupuesto )
VALUES ( @IdPresupuesto )
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al insertar resgistro para presupuesto en PuPresupuestosConsecutivos.', 16, 1)
RETURN 0
END
END
IF @Tipo = 'FolioControlConcepto' BEGIN
SELECT @Folio = FolioControlConcepto
FROM PuPresupuestosConsecutivos
WHERE IdPresupuesto = @IdPresupuesto
END ELSE IF @Tipo = 'FolioEstructuraPartidas' BEGIN
SELECT @Folio = FolioEstructuraPartidas
FROM PuPresupuestosConsecutivos
WHERE IdPresupuesto = @IdPresupuesto
END ELSE IF @Tipo = 'FolioPrograma' BEGIN
SELECT @Folio = FolioPrograma
FROM PuPresupuestosConsecutivos
WHERE IdPresupuesto = @IdPresupuesto
END ELSE BEGIN
DECLARE @Error AS VarChar(100)
SET @Error = 'El Tipo que especificó no esta definido: ' + @Tipo + '.'
RAISERROR(@Error, 16, 1)
RETURN 0
END
RETURN @Folio
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPresupuestoConsecutivo_DameSiguiente]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 27-Mayo-2009
-- Description:	Obtiene el siguiente Id de PuPresupuestosConsecutivos
-- =============================================
CREATE PROCEDURE [dbo].[NeoPresupuestoConsecutivo_DameSiguiente]
@Tipo AS VarChar(100),
@IdPresupuesto AS Int
AS BEGIN
SET NOCOUNT ON;
DECLARE @Folio AS Int
-- Reviso si existe el registro del Presupuesto sino lo creo
IF NOT EXISTS(SELECT IdPresupuesto FROM PuPresupuestosConsecutivos WHERE IdPresupuesto = @IdPresupuesto) BEGIN
INSERT INTO PuPresupuestosConsecutivos ( IdPresupuesto )
VALUES ( @IdPresupuesto )
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al insertar resgistro para presupuesto en PuPresupuestosConsecutivos.', 16, 1)
RETURN 0
END
END
IF @Tipo = 'FolioControlConcepto' BEGIN
UPDATE PuPresupuestosConsecutivos
SET FolioControlConcepto = FolioControlConcepto + 1
WHERE IdPresupuesto = @IdPresupuesto
END ELSE IF @Tipo = 'FolioEstructuraPartidas' BEGIN
UPDATE PuPresupuestosConsecutivos
SET FolioEstructuraPartidas = FolioEstructuraPartidas + 1
WHERE IdPresupuesto = @IdPresupuesto
END ELSE IF @Tipo = 'FolioPrograma' BEGIN
UPDATE PuPresupuestosConsecutivos
SET FolioPrograma = FolioPrograma + 1
WHERE IdPresupuesto = @IdPresupuesto
END ELSE BEGIN
DECLARE @Error AS VarChar(100)
SET @Error = 'El Tipo que especificó no esta definido: ' + @Tipo + '.'
RAISERROR(@Error, 16, 1)
RETURN 0
END
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al incrementar Presupuesto Consecutivo. No se afectaron registros.', 16, 1)
RETURN 0
END
IF @Tipo = 'FolioControlConcepto' BEGIN
SELECT @Folio = FolioControlConcepto
FROM PuPresupuestosConsecutivos
WHERE IdPresupuesto = @IdPresupuesto
END ELSE IF @Tipo = 'FolioEstructuraPartidas' BEGIN
SELECT @Folio = FolioEstructuraPartidas
FROM PuPresupuestosConsecutivos
WHERE IdPresupuesto = @IdPresupuesto
END ELSE IF @Tipo = 'FolioPrograma' BEGIN
SELECT @Folio = FolioPrograma
FROM PuPresupuestosConsecutivos
WHERE IdPresupuesto = @IdPresupuesto
END
RETURN @Folio
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPresupuestoConsecutivo_Reiniciar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 4-Junio-2009
-- Description:	Reinicia Id de PuPresupuestosConsecutivos
-- =============================================
CREATE PROCEDURE [dbo].[NeoPresupuestoConsecutivo_Reiniciar]
@Tipo AS VarChar(100),
@IdPresupuesto AS Int
AS BEGIN
SET NOCOUNT ON;
DECLARE @Folio AS Int
-- Reviso si existe el registro del Presupuesto sino lo creo
IF NOT EXISTS(SELECT IdPresupuesto FROM PuPresupuestosConsecutivos WHERE IdPresupuesto = @IdPresupuesto) BEGIN
INSERT INTO PuPresupuestosConsecutivos ( IdPresupuesto )
VALUES ( @IdPresupuesto )
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al insertar resgistro para presupuesto en PuPresupuestosConsecutivos.', 16, 1)
RETURN 0
END
END ELSE BEGIN
-- Por ahora solo soprta FolioControlConcepto
-- si en el futuro se necesita reiniciar los demas se implementará
/*IF @Tipo = 'FolioContrato' BEGIN
UPDATE PuPresupuestosConsecutivos
SET FolioContrato = 0
WHERE IdPresupuesto = @IdPresupuesto
END ELSE*/ IF @Tipo = 'FolioControlConcepto' BEGIN
SELECT @Folio = MAX(Control)
FROM PuPresupuestosConceptos
WHERE IdPresupuesto = @IdPresupuesto
IF @Folio IS NULL
SET @Folio = 0
UPDATE PuPresupuestosConsecutivos
SET FolioControlConcepto = @Folio
WHERE IdPresupuesto = @IdPresupuesto
--    END ELSE IF @Tipo = 'FolioEstructuraPartidas' BEGIN
--      UPDATE PuPresupuestosConsecutivos
--      SET FolioEstructuraPartidas = 0
--      WHERE IdPresupuesto = @IdPresupuesto
--    END ELSE IF @Tipo = 'FolioPrograma' BEGIN
--      UPDATE PuPresupuestosConsecutivos
--      SET FolioPrograma = 0
--      WHERE IdPresupuesto = @IdPresupuesto
END ELSE BEGIN
DECLARE @Error AS VarChar(100)
SET @Error = 'El Tipo que especificó no esta definido: ' + @Tipo + '.'
RAISERROR(@Error, 16, 1)
RETURN 0
END
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al reiniciar Presupuesto Consecutivo. No se afectaron registros.', 16, 1)
RETURN 0
END
END
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPresupuestoEquiposInsertaExpIns]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			Jose Luis Colín
-- Create date: 26-Junio-2009
-- Description:	Graba en ExpIns
-- =============================================
CREATE PROCEDURE [dbo].[NeoPresupuestoEquiposInsertaExpIns]
@IdPresupuesto Int,
@IdCodigoInsumo Int
AS
BEGIN
SET NOCOUNT ON;
DECLARE @IdExpIns Int,
@RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
INSERT INTO PuExPins (IdPresupuesto, IdCodigo)
VALUES (@IdPresupuesto, @IdCodigoInsumo)
IF @@ROWCOUNT = 0
BEGIN
RAISERROR('Error al insertar el insumo en ExpIns. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdExpIns = @@IDENTITY
COMMIT TRAN
RETURN @IdExpIns
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPresupuestoManoObraBuscaExpInsCostoMO]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín
-- Create date: 13-Junio-2009
-- Description:	Regresa el IdExpInsCostosMO de un insumo
CREATE PROCEDURE [dbo].[NeoPresupuestoManoObraBuscaExpInsCostoMO]
@IdExpIns Int
AS
DECLARE @IdExpInsMO Int
BEGIN
SET NOCOUNT ON;
SELECT @IdExpInsMO = EC_MO.IdExpInsCostoOP
FROM PuExpInsCostosOP AS EC_MO INNER JOIN
PuExpInsCostos AS EC ON EC_MO.IdExpInsCosto = EC.IdExpInsCosto
WHERE EC.IdExpIns = @IdExpIns
IF @IdExpInsMO > 0
RETURN @IdExpInsMO
ELSE
RETURN 0
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPresupuestoManoObraBuscaId]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín
-- Create date: 29-Junio-2009
-- Description:	Carga los datos del la mano de obra del presupuesto
-- =============================================
CREATE PROCEDURE [dbo].[NeoPresupuestoManoObraBuscaId]
@Codigo Varchar(20),
@IdPresupuesto Int,
@IdMoneda Int,
@IdCodigo Int = 0 Output,
@IdExpIns Int = 0 Output,
@IdExpInsCosto Int = 0 Output,
@IdExpInsMO Int = 0 OutPut
AS
SET NOCOUNT ON;
-- BUSCA EL ID DEL CATALOGO GENERAL
SELECT @IdCodigo = IdCodigo FROM PuCatalogo
WHERE Codigo = @Codigo
SET @IdCodigo = COALESCE(@IdCodigo,0)
IF @IdCodigo > 0
BEGIN
--BUSCA EL ID EXPINS
SELECT @IdExpIns = IdExpIns FROM PuExpIns
WHERe IdCodigo = @IdCodigo AND IdPresupuesto = @IdPresupuesto
SET @IdExpIns = COALESCE(@IdExpIns,0)
IF @IdExpIns > 0
BEGIN
--BUSCA EL ID EXPINSCCOSTOS
SELECT @IdExpInsCosto = IdExpInsCosto FROM PuExpInsCostos
WHERE IdExpIns = @IdExpIns AND IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE(@IdExpInsCosto,0)
IF @IdExpInsCosto > 0
BEGIN
SELECT @IdExpInsMO = IdExpInsMO FROM PuExpInsMO
WHERE IdExpInsCosto = @IdExpInsCosto
SET @IdExpInsMO = COALESCE(@IdExpInsMO,0)
END
END
END
SET @IdExpIns = COALESCE(@IdExpIns,0)
SET @IdExpInsCosto = COALESCE(@IdExpInsCosto,0)
SET @IdExpInsMO = COALESCE(@IdExpInsMO,0)
GO
/****** Object:  StoredProcedure [dbo].[NeoPresupuestoManoObraEliminar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:		José Luis Colín
---- Create date:	07-Julio-2009
---- Description:	Elimina un registro del Catalogo de Mano de Obra del Presupuesto
---- =============================================
CREATE PROCEDURE [dbo].[NeoPresupuestoManoObraEliminar]
@IdExpInsMO Int
AS
BEGIN
SET NOCOUNT ON;
DELETE FROM PuExpInsMO WHERE IdExpInsMO = @IdExpInsMO
RETURN @@ROWCOUNT
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPresupuestoManoObraGarabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 02-Julio-2009
---- Description:	Graba y Actualiza el Catalogo de Mano de Obra del Presupuesto
---- =============================================
CREATE PROCEDURE [dbo].[NeoPresupuestoManoObraGarabarActualizar]
@IdCodigoInsumo Int,
@IdPresupuesto Int,
@IdExpIns Int,
@IdMoneda Int,
@IdExpInsMO Int Output,
@SalarioBase Money,
@Fasar Decimal(18,8),
@SalarioReal Money,
@FactorSalarioIntegrado Decimal(18,8),
@SalarioIntegrado Money,
@Viaticos Money,
@AlimentacionYHospedaje Money,
@GastosDeSepelio Money,
@OtrasPrestaciones Money,
@RiesgoDeTrabajo Decimal(18,8),
@TipoFasar smallint,
@CostoTotal Money
AS
BEGIN
SET NOCOUNT ON;
DECLARE @IdExpInsCosto Int,
@RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
--- SE BUSCA EL IDEXPINS
IF NOT @IdExpIns > 0 BEGIN
SELECT @IdExpIns = IdExpIns FROM PuExpIns
WHERE IdCodigo = @IdCodigoInsumo AND IdPresupuesto = @IdPresupuesto
SET @IdExpIns = COALESCE(@IdExpIns,0)  END
--- SI EL INSUMO NO EXITE EN PUEXPINS SE AGREGA, Y ACTUALIZA EL COSTO.
--- EN CASO DE QUE EXISTA EL COSTO SE ACTUALIZA SI ES DIFERENCTE AL COSTO ALMANCENADO
EXEC @IdExpIns = NeoExpIns_GrabarActualizar @IdExpIns,  @IdPresupuesto,  @IdCodigoInsumo,  @CostoTotal,  @IdMoneda
SELECT @IdExpInsCosto = IdExpInsCosto FROM PuExpInsCostos
WHERE IdExpIns = @IdExpIns AND IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE(@IdExpInsCosto,0)
IF @IdExpInsCosto = 0
BEGIN
INSERT INTO PuExpInsCostos ( IdExpIns, IdMoneda, Costo, Fecha)
VALUES(@IdExpIns, @IdMoneda, @CostoTotal, GETDATE())
SET @IdExpInsCosto  = @@IDENTITY
END
--POR ULTIMO SE AGREGA ALA TABLA PuExpInsMO SI EN IdExpInsMO ES CERO
IF @IdExpInsMO = 0
BEGIN
INSERT INTO PuExpInsMO ( IdExpInsCosto, SalarioBase, Fasar, SalarioReal, FactorSalarioIntegrado,
SalarioIntegrado, Viaticos, AlimentacionYHospedaje, GastosDeSepelio, OtrasPrestaciones, TipoFasar, RiesgosdeTrabajo )
VALUES ( @IdExpInsCosto, @SalarioBase, @Fasar, @SalarioReal, @FactorSalarioIntegrado, @SalarioIntegrado, @Viaticos,
@AlimentacionYHospedaje, @GastosDeSepelio, @OtrasPrestaciones, @TipoFasar, @RiesgoDeTrabajo )
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al actualizar PuExpInsMO. No se afectaron registros.', 16, 1)
RETURN
END
SET  @IdExpInsMO = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuExpInsMO
SET IdExpInsCosto = @IdExpInsCosto, SalarioBase = @SalarioBase, Fasar = @Fasar, SalarioReal = @SalarioReal,
FactorSalarioIntegrado = @FactorSalarioIntegrado, SalarioIntegrado = @SalarioIntegrado, Viaticos = @Viaticos,
AlimentacionYHospedaje = @AlimentacionYHospedaje, GastosDeSepelio = @GastosDeSepelio,
OtrasPrestaciones = @OtrasPrestaciones, RiesgosdeTrabajo = @RiesgoDeTrabajo, TipoFasar = @TipoFasar
WHERE IdExpInsMO = @IdExpInsMO
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al actualizar PuExpInsMO. No se afectaron registros.', 16, 1)
RETURN
END
END
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPresupuestoMaterialesGarabarActualizar]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:			José Luis Colín
---- Create date: 06-Septiembre-2009
---- Description:	Graba y Actualiza el Catalogo de Materiales del Presupuesto
---- =============================================
CREATE PROCEDURE [dbo].[NeoPresupuestoMaterialesGarabarActualizar]
@IdPresupuesto Int,
@IdMoneda Int,
@IdCodigo Int,
@IdExpIns Int,
@IdExpInsCosto Int,
@IdExpInsCostoOP Int Output,
@CostoLAB Money,
@Fletes Money,
@Maniobra Money,
@Almacenaje Money,
@Derechos Money,
@Mermas Money,
@Costo Money
AS
BEGIN
DECLARE @RegistrosAfectados Int,
@Error AS varChar(200),
@ErrorSeverity AS Int,
@ErrorState AS Int
BEGIN TRAN
BEGIN TRY
EXEC @IdExpIns = NeoExpIns_GrabarActualizar @IdExpIns,  @IdPresupuesto,  @IdCodigo,  @Costo,  @IdMoneda
IF @IdExpInsCosto = 0
BEGIN
SELECT @IdExpInsCosto = IdExpInsCosto
FROM PuExpInsCostos
WHERE IdExpIns = @IdExpIns AND IdMoneda = @IdMoneda
SET @IdExpInsCosto = COALESCE(@IdExpInsCosto,0)
END
IF @IdExpInsCosto = 0
BEGIN
INSERT INTO PuExpInsCostos ( IdExpIns, IdMoneda, Costo, Fecha)
VALUES(@IdExpIns, @IdMoneda, @Costo, GETDATE())
SET @IdExpInsCosto  = @@IDENTITY
END
--POR ULTIMO SE AGREGA ALA TABLA PuExpInsMO SI EN IdExpInsMO ES CERO
IF @IdExpInsCostoOP = 0
BEGIN
INSERT INTO PuExpInsCostosOP( IdExpInsCosto, CostoLAB, Fletes, Maniobra, Almacenaje, Derechos, Mermas )
VALUES(@IdExpInsCosto, @CostoLAB, @Fletes, @Maniobra, @Almacenaje, @Derechos, @Mermas )
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al actualizar PuExpInsCostosOP. No se afectaron registros.', 16, 1)
RETURN
END
SET  @IdExpInsCostoOP = @@IDENTITY
END
ELSE
BEGIN
UPDATE PuExpInsCostosOP
SET IdExpInsCosto = @IdExpInsCosto, CostoLAB = @CostoLAB, Fletes = @Fletes, Maniobra = @Maniobra,
Almacenaje = @Almacenaje, Derechos = @Derechos, Mermas = @Mermas
WHERE IdExpInsCostoOP = @IdExpInsCostoOP
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
BEGIN
RAISERROR('Error al actualizar PuExpInsCostosOP. No se afectaron registros.', 16, 1)
RETURN
END
END
COMMIT TRAN
RETURN @RegistrosAfectados
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Error = ERROR_MESSAGE();
SET @ErrorSeverity = ERROR_SEVERITY();
SET @ErrorState = ERROR_STATE();
RAISERROR(@Error, @ErrorSeverity, @ErrorState)
RETURN
END CATCH;
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPresupuestoParticipa_Actualiza]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín Ramírez
-- Create date: 04-Agosto-2009
-- Description:	Actualiza la Cantidad de los insumos
-- =============================================
CREATE PROCEDURE [dbo].[NeoPresupuestoParticipa_Actualiza]
@IdExpInsInsumo Int,
@IdExpInsMatriz Int,
@Volumen Decimal(18, 6),
@Expresion Varchar(50),
@EnMatriz Bit,
@EnLlantas Bit,
@EnOtrasFuentes Bit,
@EnPiezas Bit,
@EnOperacion Bit,
@EnOtrosConsumos bit
AS
BEGIN
SET NOCOUNT ON;
-- ACTUALIZA MATRICES
IF @EnMatriz = 1 	BEGIN
UPDATE PuMatrices SET Volumen = @Volumen, Expresion = @Expresion
WHERE IdCodigoMatriz = @IdExpInsMatriz AND IdCodigoInsumo = @IdExpInsInsumo  		END
-- ACTUALIZA LAS LLANTAS
IF @EnLlantas = 1 BEGIN
UPDATE PuCostosHorarios SET hllantas = @Volumen
WHERE IdExpInsLla = @IdExpInsInsumo AND IdExpIns = @IdExpInsMatriz	END
-- ACTUALIZA OTRAS FUENTES
IF @EnOtrasFuentes = 1 BEGIN
UPDATE PuCostosHorarios SET factFuentes = @Volumen
WHERE IdExpInsOtrasFuentes = @IdExpInsInsumo AND IdExpIns = @IdExpInsMatriz	END
-- ACTUALIZA PIEZAS ESPECIALES
IF @EnPiezas = 1 BEGIN
UPDATE PuCostosHorarios SET hPiezas = @Volumen
WHERE IdExpInsPza = @IdExpInsInsumo AND IdExpIns = @IdExpInsMatriz	END
-- ACTUALIZA LA OPERACION DE COSTOS HORARIOS
IF @EnOperacion = 1 BEGIN
UPDATE PuCostosHorariosMO SET Volumen = @Volumen
WHERE IdExpins = @IdExpInsInsumo
AND IdCostoHorario = (	SELECT IdCostoHorario
FROM PuCostosHorarios
WHERE IdExpins = @IdExpInsMatriz)		END
-- ACTUALIZA OTROS CONSUMOS DE COSTOS HORARIOS
IF @EnOtrosConsumos = 1 BEGIN
UPDATE PuCostosHorariosOC SET Volumen = @Volumen
WHERE IdExpins = @IdExpInsInsumo
AND IdCostoHorario = (	SELECT IdCostoHorario
FROM PuCostosHorarios
WHERE IdExpins = @IdExpInsMatriz)		END
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPresupuestoParticipa_CargaDatos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        José Luis Colín Ramírez
-- Create date:		03-Agosto-09
-- Description:   Verifica si un insumo participa en una matriz o en Costos horarios
-- =============================================
CREATE PROCEDURE [dbo].[NeoPresupuestoParticipa_CargaDatos]
@IdExpIns Int
AS
BEGIN
SET NOCOUNT ON;
--  REVISA EN PUMATRICES
SELECT M.IdCodigoMatriz, M.IdCodigoInsumo, E.IdPresupuesto, C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
CASE WHEN M.Dividir  = 1 THEN '/' ELSE '*' END AS Dividir,
M.Volumen, E.EsCostoHorario, C.EsPorcentaje, M.Expresion,
CAST(1 AS Bit) AS ParticipaEnMatriz, CAST(0 AS Bit) AS ParticipaEnCH,
CAST(1 AS Bit) AS EsModificable,CAST(0 AS Bit) AS EnPartida,
CAST(0 AS Bit) AS EnLlantas, CAST(0 AS Bit) AS EnOtrasFuentes,
CAST(0 AS Bit) AS EnPiezas, CAST(0 AS Bit) AS EnOperacion,
CAST(0 AS Bit) AS EnOtrosConsumos, CAST(0 AS Bit) AS EnCombustible,
CAST(0 AS Bit) AS EnAceite, CAST(0 AS Bit) AS EnVA,
CAST(0 AS Bit) AS EnReserva, CAST(0 AS Bit) AS EnEspera,
CAST(0 AS Bit) AS EnCargoFijo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuMatrices AS M ON M.IdCodigoMatriz = E.IdExpIns
WHERE M.IdCodigoInsumo = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS ACEITE
SELECT CH.IdExpIns as IdCodigoMatriz, CH.IdExpInsAcei AS IdCodigoInsumo, E.IdPresupuesto, C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
NULL AS Dividir, NULL AS Volumen, E.EsCostoHorario, C.EsPorcentaje, NULL AS Expresion,
CAST(0 AS Bit) AS ParticipaEnMatriz, CAST(1 AS Bit) AS ParticipaEnCH,
CAST(0 AS Bit) AS EsModificable, CAST(0 AS Bit) AS EnPartida,
CAST(0 AS Bit) AS EnLlantas, CAST(0 AS Bit) AS EnOtrasFuentes,
CAST(0 AS Bit) AS EnPiezas, CAST(0 AS Bit) AS EnOperacion,
CAST(0 AS Bit) AS EnOtrosConsumos, CAST(0 AS Bit) AS EnCombustible,
CAST(1 AS Bit) AS EnAceite, CAST(0 AS Bit) AS EnVA,
CAST(0 AS Bit) AS EnReserva, CAST(0 AS Bit) AS EnEspera,
CAST(0 AS Bit) AS EnCargoFijo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuCostosHorarios AS CH ON CH.IdExpIns = E.IdExpIns
WHERE CH.IdExpInsAcei = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS COMBUSTIBLE
SELECT CH.IdExpIns as IdCodigoMatriz, CH.IdExpInsComb AS IdCodigoInsumo, E.IdPresupuesto, C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
NULL AS Dividir, NULL AS Volumen, E.EsCostoHorario, C.EsPorcentaje, NULL AS Expresion,
CAST(0 AS Bit) AS ParticipaEnMatriz, CAST(1 AS Bit) AS ParticipaEnCH,
CAST(0 AS Bit) AS EsModificable,  CAST(0 AS Bit) AS EnPartida,
CAST(0 AS Bit) AS EnLlantas, CAST(0 AS Bit) AS EnOtrasFuentes,
CAST(0 AS Bit) AS EnPiezas, CAST(0 AS Bit) AS EnOperacion,
CAST(0 AS Bit) AS EnOtrosConsumos, CAST(1 AS Bit) AS EnCombustible,
CAST(0 AS Bit) AS EnAceite, CAST(0 AS Bit) AS EnVA,
CAST(0 AS Bit) AS EnReserva, CAST(0 AS Bit) AS EnEspera,
CAST(0 AS Bit) AS EnCargoFijo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuCostosHorarios AS CH ON CH.IdExpIns = E.IdExpIns
WHERE CH.IdExpInsComb = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS ESPERA
SELECT CH.IdExpIns as IdCodigoMatriz, CH.IdExpinsE AS IdCodigoInsumo,  E.IdPresupuesto, C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
NULL AS Dividir, NULL AS Volumen, E.EsCostoHorario, C.EsPorcentaje, NULL AS Expresion,
CAST(0 AS Bit) AS ParticipaEnMatriz, CAST(1 AS Bit) AS ParticipaEnCH,
CAST(0 AS Bit) AS EsModificable, CAST(0 AS Bit) AS EnPartida,
CAST(0 AS Bit) AS EnLlantas, CAST(0 AS Bit) AS EnOtrasFuentes,
CAST(0 AS Bit) AS EnPiezas, CAST(0 AS Bit) AS EnOperacion,
CAST(0 AS Bit) AS EnOtrosConsumos, CAST(0 AS Bit) AS EnCombustible,
CAST(0 AS Bit) AS EnAceite, CAST(0 AS Bit) AS EnVA,
CAST(0 AS Bit) AS EnReserva, CAST(1 AS Bit) AS EnEspera,
CAST(0 AS Bit) AS EnCargoFijo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuCostosHorarios AS CH ON CH.IdExpIns = E.IdExpIns
WHERE CH.IdExpinsE = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS LLANTAS
SELECT CH.IdExpIns as IdCodigoMatriz, CH.IdExpInsLla AS IdCodigoInsumo,  E.IdPresupuesto, C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
'/' AS Dividir, CH.hllantas AS Volumen, E.EsCostoHorario, C.EsPorcentaje, NULL AS Expresion,
CAST(0 AS Bit) AS ParticipaEnMatriz, CAST(1 AS Bit) AS ParticipaEnCH,
CAST(1 AS Bit) AS EsModificable, CAST(0 AS Bit) AS EnPartida,
CAST(1 AS Bit) AS EnLlantas, CAST(0 AS Bit) AS EnOtrasFuentes,
CAST(0 AS Bit) AS EnPiezas, CAST(0 AS Bit) AS EnOperacion,
CAST(0 AS Bit) AS EnOtrosConsumos, CAST(0 AS Bit) AS EnCombustible,
CAST(0 AS Bit) AS EnAceite, CAST(0 AS Bit) AS EnVA,
CAST(0 AS Bit) AS EnReserva, CAST(0 AS Bit) AS EnEspera,
CAST(0 AS Bit) AS EnCargoFijo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuCostosHorarios AS CH ON CH.IdExpIns = E.IdExpIns
WHERE CH.IdExpInsLla = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS OTRAS FUENTES
SELECT CH.IdExpIns as IdCodigoMatriz, CH.IdExpInsOtrasFuentes AS IdCodigoInsumo, E.IdPresupuesto, C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
'*' AS Dividir, CH.factFuentes AS Volumen, E.EsCostoHorario, C.EsPorcentaje, NULL AS Expresion,
CAST(0 AS Bit) AS ParticipaEnMatriz, CAST(1 AS Bit) AS ParticipaEnCH,
CAST(1 AS Bit) AS EsModificable, CAST(0 AS Bit) AS EnPartida,
CAST(0 AS Bit) AS EnLlantas, CAST(1 AS Bit) AS EnOtrasFuentes,
CAST(0 AS Bit) AS EnPiezas, CAST(0 AS Bit) AS EnOperacion,
CAST(0 AS Bit) AS EnOtrosConsumos, CAST(0 AS Bit) AS EnCombustible,
CAST(0 AS Bit) AS EnAceite, CAST(0 AS Bit) AS EnVA,
CAST(0 AS Bit) AS EnReserva, CAST(0 AS Bit) AS EnEspera,
CAST(0 AS Bit) AS EnCargoFijo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuCostosHorarios AS CH ON CH.IdExpIns = E.IdExpIns
WHERE CH.IdExpInsOtrasFuentes = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS PIEZAS ESPECIALES
SELECT CH.IdExpIns as IdCodigoMatriz, CH.IdExpInsPza AS IdCodigoInsumo, E.IdPresupuesto, C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
'*' AS Dividir, CH.hPiezas AS Volumen, E.EsCostoHorario, C.EsPorcentaje, NULL AS Expresion,
CAST(0 AS Bit) AS ParticipaEnMatriz, CAST(1 AS Bit) AS ParticipaEnCH,
CAST(1 AS Bit) AS EsModificable, CAST(0 AS Bit) AS EnPartida,
CAST(0 AS Bit) AS EnLlantas, CAST(0 AS Bit) AS EnOtrasFuentes,
CAST(1 AS Bit) AS EnPiezas, CAST(0 AS Bit) AS EnOperacion,
CAST(0 AS Bit) AS EnOtrosConsumos, CAST(0 AS Bit) AS EnCombustible,
CAST(0 AS Bit) AS EnAceite, CAST(0 AS Bit) AS EnVA,
CAST(0 AS Bit) AS EnReserva, CAST(0 AS Bit) AS EnEspera,
CAST(0 AS Bit) AS EnCargoFijo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuCostosHorarios AS CH ON CH.IdExpIns = E.IdExpIns
WHERE CH.IdExpInsPza = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS RESERVA
SELECT CH.IdExpIns as IdCodigoMatriz,CH.IdExpinsR AS IdCodigoInsumo,  E.IdPresupuesto, C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
NULL AS Dividir, NULL AS Volumen, E.EsCostoHorario, C.EsPorcentaje, NULL AS Expresion,
CAST(0 AS Bit) AS ParticipaEnMatriz, CAST(1 AS Bit) AS ParticipaEnCH,
CAST(0 AS Bit) AS EsModificable,CAST(0 AS Bit) AS EnPartida,
CAST(0 AS Bit) AS EnLlantas, CAST(0 AS Bit) AS EnOtrasFuentes,
CAST(0 AS Bit) AS EnPiezas, CAST(0 AS Bit) AS EnOperacion,
CAST(0 AS Bit) AS EnOtrosConsumos, CAST(0 AS Bit) AS EnCombustible,
CAST(0 AS Bit) AS EnAceite, CAST(0 AS Bit) AS EnVA,
CAST(1 AS Bit) AS EnReserva, CAST(0 AS Bit) AS EnEspera,
CAST(0 AS Bit) AS EnCargoFijo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuCostosHorarios AS CH ON CH.IdExpIns = E.IdExpIns
WHERE CH.IdExpinsR = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS CARGO FIJO
SELECT CH.IdExpIns as IdCodigoMatriz, CH.IdExpInsVa AS IdCodigoInsumo, E.IdPresupuesto,  C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
NULL AS Dividir, NULL AS Volumen, E.EsCostoHorario, C.EsPorcentaje, NULL AS Expresion,
CAST(0 AS Bit) AS ParticipaEnMatriz, CAST(1 AS Bit) AS ParticipaEnCH,
CAST(0 AS Bit) AS EsModificable, CAST(0 AS Bit) AS EnPartida,
CAST(0 AS Bit) AS EnLlantas, CAST(0 AS Bit) AS EnOtrasFuentes,
CAST(0 AS Bit) AS EnPiezas, CAST(0 AS Bit) AS EnOperacion,
CAST(0 AS Bit) AS EnOtrosConsumos, CAST(0 AS Bit) AS EnCombustible,
CAST(0 AS Bit) AS EnAceite, CAST(0 AS Bit) AS EnVA,
CAST(0 AS Bit) AS EnReserva, CAST(0 AS Bit) AS EnEspera,
CAST(1 AS Bit) AS EnCargoFijo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuCostosHorarios AS CH ON CH.IdExpIns = E.IdExpIns
WHERE CH.IdExpInsCF = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS VALOR DE ADQUISISCION
SELECT CH.IdExpIns as IdCodigoMatriz, CH.IdExpInsVa AS IdCodigoInsumo, E.IdPresupuesto,  C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
NULL AS Dividir, NULL AS Volumen, E.EsCostoHorario, C.EsPorcentaje, NULL AS Expresion,
CAST(0 AS Bit) AS ParticipaEnMatriz, CAST(1 AS Bit) AS ParticipaEnCH,
CAST(0 AS Bit) AS EsModificable, CAST(0 AS Bit) AS EnPartida,
CAST(0 AS Bit) AS EnLlantas, CAST(0 AS Bit) AS EnOtrasFuentes,
CAST(0 AS Bit) AS EnPiezas, CAST(0 AS Bit) AS EnOperacion,
CAST(0 AS Bit) AS EnOtrosConsumos, CAST(0 AS Bit) AS EnCombustible,
CAST(0 AS Bit) AS EnAceite, CAST(1 AS Bit) AS EnVA,
CAST(0 AS Bit) AS EnReserva, CAST(0 AS Bit) AS EnEspera,
CAST(0 AS Bit) AS EnCargoFijo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuCostosHorarios AS CH ON CH.IdExpIns = E.IdExpIns
WHERE CH.IdExpInsVa = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS OPERACION
SELECT CH.IdExpIns as IdCodigoMatriz, CH_MO.IdExpins AS IdCodigoInsumo, E.IdPresupuesto, C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
CASE WHEN CH_MO.Dividir  = 1 THEN '/' ELSE '*' END AS Dividir, CH_MO.Volumen,
E.EsCostoHorario, C.EsPorcentaje, NULL AS Expresion,
CAST(0 AS Bit) AS ParticipaEnMatriz, CAST(1 AS Bit) AS ParticipaEnCH,
CAST(1 AS Bit) AS EsModificable, CAST(0 AS Bit) AS EnPartida,
CAST(0 AS Bit) AS EnLlantas, CAST(0 AS Bit) AS EnOtrasFuentes,
CAST(0 AS Bit) AS EnPiezas, CAST(1 AS Bit) AS EnOperacion,
CAST(0 AS Bit) AS EnOtrosConsumos, CAST(0 AS Bit) AS EnCombustible,
CAST(0 AS Bit) AS EnAceite, CAST(0 AS Bit) AS EnVA,
CAST(0 AS Bit) AS EnReserva, CAST(0 AS Bit) AS EnEspera,
CAST(0 AS Bit) AS EnCargoFijo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuCostosHorarios AS CH ON CH.IdExpIns = E.IdExpIns INNER JOIN
PuCostosHorariosMO AS CH_MO ON CH_MO.IdCostoHorario = CH.IdCostoHorario
WHERE CH_MO.IdExpins = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS OTROS CONSUMOS
SELECT CH.IdExpIns as IdCodigoMatriz, CH_OC.IdExpins AS IdCodigoInsumo, E.IdPresupuesto, C.Codigo, C.DescripcionLarga, C.Descripcion, U.Unidad, C.IdTipo,
CASE WHEN CH_OC.Dividir  = 1 THEN '/' ELSE '*' END AS Dividir, CH_OC.Volumen,
E.EsCostoHorario, C.EsPorcentaje, NULL AS Expresion,
CAST(0 AS Bit) AS ParticipaEnMatriz, CAST(1 AS Bit) AS ParticipaEnCH,
CAST(1 AS Bit) AS EsModificable, CAST(0 AS Bit) AS EnPartida,
CAST(0 AS Bit) AS EnLlantas, CAST(0 AS Bit) AS EnOtrasFuentes,
CAST(0 AS Bit) AS EnPiezas, CAST(0 AS Bit) AS EnOperacion,
CAST(1 AS Bit) AS EnOtrosConsumos, CAST(0 AS Bit) AS EnCombustible,
CAST(0 AS Bit) AS EnAceite, CAST(0 AS Bit) AS EnVA,
CAST(0 AS Bit) AS EnReserva, CAST(0 AS Bit) AS EnEspera,
CAST(0 AS Bit) AS EnCargoFijo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuCostosHorarios AS CH ON CH.IdExpIns = E.IdExpIns INNER JOIN
PuCostosHorariosOC AS CH_OC ON CH_OC.IdCostoHorario = CH.IdCostoHorario
WHERE CH_OC.IdExpins = @IdExpIns
UNION
--REVISA EN EL PRESUPUESTO
SELECT PP.IdPresupuestoPartida AS IdCodigoMatriz, E.IdExpIns AS IdCodigoInsumo, E.IdPresupuesto,
PP.Partida, PP.DescripcionPartidaLarga AS DescripcionLarga, PP.DescripcionPartida AS Descripcion, NULL AS Unidad, NULL AS IdTipo,
NULL AS Dividir, PC.Cantidad AS Volumen, CAST(0 AS Bit) AS EsCostoHorario, C.EsPorcentaje, NULL AS Expresion,
CAST(0 AS Bit) AS ParticipaEnMatriz, CAST(0 AS Bit) AS ParticipaEnCH,
CAST(0 AS Bit) AS EsModificable, CAST(1 AS Bit) AS EnPartida,
CAST(0 AS Bit) AS EnLlantas, CAST(0 AS Bit) AS EnOtrasFuentes,
CAST(0 AS Bit) AS EnPiezas, CAST(0 AS Bit) AS EnOperacion,
CAST(0 AS Bit) AS EnOtrosConsumos, CAST(0 AS Bit) AS EnCombustible,
CAST(0 AS Bit) AS EnAceite, CAST(0 AS Bit) AS EnVA,
CAST(0 AS Bit) AS EnReserva, CAST(0 AS Bit) AS EnEspera,
CAST(0 AS Bit) AS EnCargoFijo
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad INNER JOIN
PuExpIns AS E ON E.IdCodigo = C.IdCodigo INNER JOIN
PuPresupuestosConceptos AS PC ON PC.IdExpIns = E.IdExpIns INNER JOIN
PuPresupuestosPartidas AS PP ON PP.IdPresupuestoPartida = PC.IdPresupuestoPartida
WHERE E.IdExpIns = @IdExpIns
END
GO
/****** Object:  StoredProcedure [dbo].[NeoPresupuestoParticipa_ChecaSiParticipa]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:			José Luis Colín Ramírez
-- Create date: 03-Agosto-09
-- Description:	Verifica si un insumo participa en una matriz o en Costos horarios
-- =============================================
CREATE PROCEDURE [dbo].[NeoPresupuestoParticipa_ChecaSiParticipa]
@IdExpIns Int
AS
BEGIN
SET NOCOUNT ON;
--	REVISA EN PUMATRICES
SELECT IdCodigoMatriz FROM PuMatrices
WHERE IdCodigoInsumo = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS ACEITE
SELECT IdCostoHorario AS IdCodigoMatriz FROM PuCostosHorarios
WHERE IdExpInsAcei = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS COMBUSTIBLE
SELECT IdCostoHorario AS IdCodigoMatriz FROM PuCostosHorarios
WHERE IdExpInsComb = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS ESPERA
SELECT IdCostoHorario AS IdCodigoMatriz FROM PuCostosHorarios
WHERE IdExpinsE = @IdExpIns
UNION
-- REVISA EN EL CARGO FIJO
SELECT IdCostoHorario AS IdCodigoMatriz FROM PuCostosHorarios
WHERE IdExpInsCF = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS LLANTAS
SELECT IdCostoHorario AS IdCodigoMatriz FROM PuCostosHorarios
WHERE IdExpInsLla = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS OTRAS FUENTES
SELECT IdCostoHorario AS IdCodigoMatriz FROM PuCostosHorarios
WHERE IdExpInsOtrasFuentes = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS PIEZAS ESPECIALES
SELECT IdCostoHorario AS IdCodigoMatriz FROM PuCostosHorarios
WHERE IdExpInsPza = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS RESERVA
SELECT IdCostoHorario AS IdCodigoMatriz FROM PuCostosHorarios
WHERE IdExpinsR = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS VALOR DE ADQUISISCION
SELECT IdCostoHorario AS IdCodigoMatriz FROM PuCostosHorarios
WHERE IdExpInsVa = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS OPERACION
SELECT IdCostoHorarioMO AS IdCodigoMatriz  FROM PuCostosHorariosMO
WHERE IdExpins = @IdExpIns
UNION
-- REVISA EN COSTOS HORARIOS OTROS CONSUMOS
SELECT IdCostoHorarioOC AS IdCodigoMatriz  FROM PuCostosHorariosOC
WHERE IdExpins = @IdExpIns
UNION
--REVISA SI PARTICIPA EN EL PRESUPUESTO
SELECT IdPresupuestoConcepto AS IdCodigoMatriz FROM PuPresupuestosConceptos
WHERE IdExpIns = @IdExpIns
END
GO
/****** Object:  StoredProcedure [dbo].[NeoProgramaControl3Puntos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
---- =============================================
---- Author:		José Luis Colín
---- Create date:	22-Julio-2009,
---- Description:	Control de 3 puntos del Programa
---- Modificado:	Dámaso Hernández Guillén
---- Fecha:			29-Agosto-2009
---- =============================================
CREATE PROCEDURE [dbo].[NeoProgramaControl3Puntos]
@IdPresupuesto Int,
@IdPrograma Int,
@NoPrograma Int
AS
IF  @IdPrograma = 0 AND @NoPrograma = 0
SELECT P.IdPrograma, P.NoPrograma, P.Descripcion, P.FechaInicio, P.FechaFinal, P.NoPeriodos,
CASE WHEN P.Periodicidad=1 THEN 'Mensual' WHEN P.Periodicidad=2 THEN 'Quincenal' WHEN P.Periodicidad=3 THEN 'Semanal' WHEN P.Periodicidad=4  THEN 'Diaria' END AS PeriodicidadStr,
C.Calendario, C.Descripcion, P.Vigente, P.DiasCalendario, P.DiasHabiles, P.Periodicidad,P.CapturarPorcentaje
FROM PuProgramas AS P INNER JOIN
PuCalendarios AS C ON P.IdCalendario = C.IdCalendario
WHERE P.IdPresupuesto=@IdPresupuesto
ORDER BY P.NoPrograma
ELSE IF  @IdPrograma = 0 AND @NoPrograma > 0
SELECT P.IdPrograma, P.NoPrograma, P.Descripcion, P.FechaInicio, P.FechaFinal, P.NoPeriodos,
CASE WHEN P.Periodicidad=1 THEN 'Mensual' WHEN P.Periodicidad=2 THEN 'Quincenal' WHEN P.Periodicidad=3 THEN 'Semanal' WHEN P.Periodicidad=4  THEN 'Diaria' END AS PeriodicidadStr,
C.Calendario, C.Descripcion, P.Vigente, P.DiasCalendario, P.DiasHabiles, P.Periodicidad,P.CapturarPorcentaje
FROM PuProgramas AS P INNER JOIN
PuCalendarios AS C ON P.IdCalendario = C.IdCalendario
WHERE P.IdPresupuesto = @IdPresupuesto AND P.NoPrograma=@NoPrograma
ELSE IF   @IdPrograma >0 AND @NoPrograma = 0
SELECT P.IdPrograma, P.NoPrograma, P.Descripcion, P.FechaInicio, P.FechaFinal, P.NoPeriodos,
CASE WHEN P.Periodicidad=1 THEN 'Mensual' WHEN P.Periodicidad=2 THEN 'Quincenal' WHEN P.Periodicidad=3 THEN 'Semanal' WHEN P.Periodicidad=4  THEN 'Diaria' END AS PeriodicidadStr,
C.Calendario, C.Descripcion, P.Vigente, P.DiasCalendario, P.DiasHabiles, P.Periodicidad,P.CapturarPorcentaje
FROM PuProgramas AS P INNER JOIN
PuCalendarios AS C ON P.IdCalendario = C.IdCalendario
WHERE P.IdPresupuesto=@IdPresupuesto AND P.IdPrograma=@IdPrograma
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaActualizaPartidaArbol]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Modify date: <27 de Septiembre del 2009>
-- Description:	<Obtiene los conceptos de un programa de obra>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaActualizaPartidaArbol]
@IdPresupuestoPartida as int,
@IdPrograma as int,
@FechaInicio as date,
@FechaFinal as date,
@Duracion as int
AS
SET NOCOUNT ON;
-- Actualiza Partidas
WITH Arbol (IdPartidaPadre, IdPresupuestoPartida)
AS (
SELECT IdPartidaPadre, IdPresupuestoPartida
FROM PuPresupuestosPartidas
WHERE IdPresupuestoPartida =@IdPresupuestoPartida
UNION ALL
SELECT PP.IdPartidaPadre, PP.IdPresupuestoPartida
FROM PuPresupuestosPartidas AS PP INNER JOIN
Arbol AS A ON A.IdPresupuestoPartida = PP.IdPartidaPadre
)
UPDATE PuProgramaPartidas
SET FechaInicio=@FechaInicio, FechaFinal=@FechaFinal, Duracion=@Duracion
FROM PuProgramaPartidas AS PP INNER JOIN
Arbol AS A ON  PP.IdPresupuestoPartida = A.IdPresupuestoPartida
WHERE PP.IdPrograma=@IdPrograma;
------------------------------------------------------------------------------------
-- Actualiza Conceptos
WITH Arbol (IdPartidaPadre, IdPresupuestoPartida)
AS (
SELECT IdPartidaPadre, IdPresupuestoPartida
FROM PuPresupuestosPartidas
WHERE IdPresupuestoPartida = @IdPresupuestoPartida
UNION ALL
SELECT PP.IdPartidaPadre, PP.IdPresupuestoPartida
FROM PuPresupuestosPartidas AS PP INNER JOIN
Arbol AS A ON A.IdPresupuestoPartida = PP.IdPartidaPadre
)
UPDATE PuProgramaConceptos
SET FechaInicio=@FechaInicio, FechaFinal=@FechaFinal, Duracion=@Duracion,
Rendimiento = CASE WHEN @Duracion = 0 THEN 0 ELSE ROUND(PC.CantidadTotal/@Duracion,6) END
FROM PuProgramaConceptos AS PP INNER JOIN
PuPresupuestosConceptos AS PC ON PP.IdPresupuestoConcepto = PC.IdPresupuestoConcepto INNER JOIN
Arbol AS A ON  PC.IdPresupuestoPartida = A.IdPresupuestoPartida
WHERE PP.IdPrograma=@IdPrograma;
------------------------------------------------------------------------------------
-- Borra ligas
WITH Arbol (IdPartidaPadre, IdPresupuestoPartida)
AS (
SELECT IdPartidaPadre, IdPresupuestoPartida
FROM PuPresupuestosPartidas
WHERE IdPresupuestoPartida = @IdPresupuestoPartida
UNION ALL
SELECT PP.IdPartidaPadre, PP.IdPresupuestoPartida
FROM PuPresupuestosPartidas AS PP INNER JOIN
Arbol AS A ON A.IdPresupuestoPartida = PP.IdPartidaPadre
)
DELETE FROM PuLigasRuta
FROM PuLigasRuta AS L INNER JOIN
PuProgramaConceptos AS PP ON L.IdConceptoOrigen=PP.IdProgramaConcepto OR L.IdConceptoDestino=PP.IdProgramaConcepto INNER JOIN
PuPresupuestosConceptos AS PC ON PP.IdPresupuestoConcepto = PC.IdPresupuestoConcepto INNER JOIN
Arbol AS A ON  PC.IdPresupuestoPartida = A.IdPresupuestoPartida
WHERE PP.IdPrograma=@IdPrograma;
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaActualizaProgramaConcepto]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <17 de Junio del 2009>
-- Description:	<Actualiza el concepto de un programa de obra>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaActualizaProgramaConcepto]
@IdProgramaConcepto AS int,
@FechaInicio as dateTime,
@FechaFinal as datetime,
@Rendimiento as money,
@FechasAlInicio as bit
AS
SET NOCOUNT ON;
if @FechasAlInicio=1
UPDATE PuProgramaConceptos SET FechaInicio=@FechaInicio, FechaFinal=@FechaFinal,Duracion=1, Rendimiento=@Rendimiento,
Holgura=-1, ActividadCritica=0
WHERE IdProgramaConcepto=@IdProgramaConcepto
else
UPDATE PuProgramaConceptos SET FechaInicio=@FechaInicio, FechaFinal=@FechaFinal
WHERE IdProgramaConcepto=@IdProgramaConcepto
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaActualizaProgramaConceptoFechas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <13 Septiembre 2009>
-- Description:	<Actualiza las fechas al calcular la ruta crítica>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaActualizaProgramaConceptoFechas]
@IdProgramaConcepto AS int,
@FechaInicio as DateTime,
@FechaFinal as datetime,
@FechaInicioTardia as DateTime,
@FechaFinalTardia as datetime,
@Holgura as integer,
@ActividadCritica as bit
AS
SET NOCOUNT ON;
UPDATE PuProgramaConceptos SET FechaInicio=@FechaInicio, FechaFinal=@FechaFinal,
FechaInicioTardia=@FechaInicioTardia, FechaFinalTardia=@FechaInicioTardia,
Holgura=@Holgura,ActividadCritica=@ActividadCritica
WHERE IdProgramaConcepto=@IdProgramaConcepto
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaActualizaProgramaConceptoPeriodos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <21 Septiembre 2009>
-- Description:	<Actualiza porcentajes>
-- =============================================
Create PROCEDURE [dbo].[NeoRutaActualizaProgramaConceptoPeriodos]
@IdProgramaConcepto AS int,
@FechaInicio as DateTime,
@FechaFinal as datetime,
@Rendimiento as decimal(18,6),
@Duracion as int
AS
SET NOCOUNT ON;
UPDATE PuProgramaConceptos SET FechaInicio=@FechaInicio, FechaFinal=@FechaFinal,
Rendimiento=@Rendimiento, Duracion=@Duracion
WHERE IdProgramaConcepto=@IdProgramaConcepto
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaActualizaProgramaPartida]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <15 de Septiembre del 2009>
-- Description:	<Actualiza la partida de un programa de obra>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaActualizaProgramaPartida]
@IdProgramaPartida AS int,
@FechaInicio as DateTime,
@FechaFinal as datetime,
@Duracion as int
AS
SET NOCOUNT ON;
UPDATE PuProgramaPartidas SET FechaInicio=@FechaInicio, FechaFinal=@FechaFinal,Duracion=@Duracion
WHERE IdProgramaPartida=@IdProgramaPartida
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaAgregaActualizaPeriodos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <19 de septiembre 2009>
-- Description:	<Inserta,actualiza o elimina periodos del programa de obra>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaAgregaActualizaPeriodos]
@IdProgramaConceptoPeriodo as int,
@IdProgramaConcepto as int,
@NoPeriodo as int,
@Porcentaje as	decimal(18,6)
AS
SET NOCOUNT ON;
IF @IdProgramaConceptoPeriodo =0
INSERT INTO PuProgramaConceptosPeriodos (IdProgramaConcepto,NoPeriodo,Porcentaje)
VALUES(@IdProgramaConcepto,@NoPeriodo,@Porcentaje)
ELSE
IF @Porcentaje = 0
DELETE FROM PuProgramaConceptosPeriodos WHERE IdProgramaConceptoPeriodo =@IdProgramaConceptoPeriodo
ELSE
UPDATE PuProgramaConceptosPeriodos SET Porcentaje=@Porcentaje WHERE IdProgramaConceptoPeriodo=@IdProgramaConceptoPeriodo
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaAgregaConceptosFueraDeProgramaObra]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <16 de Junio del 2009>
-- Description:	<Inserta los conceptos del presupuesto que aun no participan en un programa de obra>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaAgregaConceptosFueraDeProgramaObra]
@IdPresupuesto AS Int,
@IdPrograma AS int,
@FechaInicio AS datetime,
@FechaFinal AS datetime,
@CapturarPorcentaje AS bit
AS
SET NOCOUNT ON;
/*
--Inserta los nuevos registros
DECLARE Proc_InsertaConceptos CURSOR LOCAL FORWARD_ONLY FAST_FORWARD READ_ONLY
FOR
SELECT P.CantidadTotal, P.IdPresupuestoConcepto
FROM PuPresupuestosConceptos AS P
WHERE P.IdPresupuesto=@IdPresupuesto AND NOT EXISTS(SELECT IdPresupuestoConcepto FROM PuProgramaConceptos
WHERE IdPrograma=@IdPrograma AND IdPresupuestoConcepto=P.IdPresupuestoConcepto)
OPEN Proc_InsertaConceptos
FETCH NEXT FROM Proc_InsertaConceptos INTO @CantidadTotal, @IdPresupuestoConcepto
WHILE @@FETCH_STATUS = 0
BEGIN
SET @Rendimiento = ROUND(@CantidadTotal/@Duracion,2)
INSERT INTO PuProgramasConceptos(IdPrograma,IdPresupuestoConcepto,FechaInicio,FechaFinal,Duracion,Rendimiento)
VALUES(@IdPrograma,@IdPresupuestoConcepto,@FechaInicio,@FechaFinal,@Duracion,@Rendimiento)
FETCH NEXT FROM Proc_NeoMatrices_GarbarActualizar INTO @CantidadTotal, @IdPresupuestoConcepto
END
CLOSE Proc_InsertaConceptos
DEALLOCATE Proc_InsertaConceptos
*/
INSERT INTO PuProgramaConceptos(IdPrograma,IdPresupuestoConcepto,FechaInicio,FechaFinal,Duracion,Rendimiento)
SELECT @IdPrograma, P.IdPresupuestoConcepto, @FechaInicio, @FechaFinal,1, ROUND(P.CantidadTotal/1,2)
FROM PuPresupuestosConceptos AS P
WHERE P.IdPresupuesto=@IdPresupuesto AND NOT EXISTS(SELECT IdPresupuestoConcepto FROM PuProgramaConceptos
WHERE IdPrograma=@IdPrograma AND IdPresupuestoConcepto=P.IdPresupuestoConcepto)
INSERT INTO PuProgramaConceptosPeriodos(NoPeriodo,Porcentaje,IdProgramaConcepto)
SELECT 1,CASE WHEN @CapturarPorcentaje=1 THEN 100 ELSE P.CantidadTotal END AS Porcentaje,PC.IdProgramaConcepto
FROM PuPresupuestosConceptos AS P INNER JOIN
PuProgramaConceptos AS PC ON P.IdPresupuestoConcepto=PC.IdPresupuestoConcepto
WHERE PC.IdProgramaConcepto IN (SELECT PC2.IdProgramaConcepto FROM PuProgramaConceptos AS PC2 LEFT JOIN
PuProgramaConceptosPeriodos AS PP ON PC2.IdProgramaConcepto=PP.IdProgramaConcepto
WHERE IdPrograma =@IdPrograma AND PP.IdProgramaConceptoPeriodo IS NULL)
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaAgregaPartidasFueraDeProgramaObra]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <16 de Junio del 2009>
-- Description:	<Inserta las partidas del presupuesto que aun no participan en un programa de obra>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaAgregaPartidasFueraDeProgramaObra]
@IdPresupuesto AS Int,
@IdPrograma AS int,
@FechaInicio AS datetime,
@FechaFinal AS datetime
AS
SET NOCOUNT ON;
INSERT INTO PuProgramaPartidas(IdPrograma,IdPresupuestoPartida,FechaInicio,FechaFinal,Duracion)
SELECT @IdPrograma, P.IdPresupuestoPartida, @FechaInicio, @FechaFinal, 1
FROM PuPresupuestosPartidas AS P
WHERE P.IdPresupuesto=@IdPresupuesto AND NOT EXISTS(SELECT IdPresupuestoPartida FROM PuProgramaPartidas
WHERE IdPrograma=@IdPrograma AND IdPresupuestoPartida=P.IdPresupuestoPartida)
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaCalendario]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <15 de Junio del 2009>
-- Description:	<Obtiene el calendario y los días no laborables de un calendario>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaCalendario]
@IdCalendario AS Int
AS
SELECT IdCalendario,Calendario,Descripcion,Lunes, Martes, Miercoles, Jueves, Viernes, Sabado, Domingo
FROM PuCalendarios
WHERE IdCalendario =@IdCalendario
SELECT FechaNoLaborable
FROM PuCalendariosDet AS P
WHERE IdCalendario =@IdCalendario
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaObtieneConceptos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <17 de Junio del 2009>
-- Description:	<Obtiene los conceptos de un programa de obra>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaObtieneConceptos]
@IdPrograma AS int
AS
SET NOCOUNT ON;
SELECT P.IdPresupuestoConcepto, P.IdPresupuestoPartida, PC.IdProgramaConcepto, PC.FechaInicio, PC.FechaFinal, PC.Duracion, P.CantidadTotal
FROM PuPresupuestosConceptos  AS P INNER JOIN
PuProgramaConceptos AS PC ON P.IdPresupuestoConcepto=PC.IdPresupuestoConcepto
WHERE PC.IdPrograma=@IdPrograma
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaObtieneDatosPartidas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <17 de Junio del 2009>
-- Description:	<Obtiene las partidas a vizualizar en la ruta crítica>
-- Modificado:	<30 Agosto 2009>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaObtieneDatosPartidas]
@IdPresupuesto int,
@IdPrograma int,
@IdMoneda int
AS
DECLARE
@Decimales AS Int
EXEC @Decimales = NeoParametros_DecimalesRedondeo @IdPresupuesto = @IdPresupuesto
SELECT CAST(P.IdPartidaPadre AS DECIMAL) AS IdPartidaPadre,  CAST(P.IdPresupuestoPartida AS DECIMAL) AS IdPartidaArbol,
P.Partida, P.Renglon, P.Cantidad,P.DescripcionPartida, PP.FechaInicio, PP.FechaFinal, PP.Duracion, PP.Total,
R.Responsable,0 AS EsConcepto,PP.ActividadCritica, R.IdResponsable, PP.IdProgramaPartida,P.PartidaWBS,
COALESCE(PRE.Precio,0) AS Precio,ROUND(COALESCE(PRE.Precio, 0)* P.Cantidad,@Decimales) AS Importe
FROM PuPresupuestosPartidas P INNER JOIN
PuProgramaPartidas AS PP ON P.IdPresupuestoPartida = PP.IdPresupuestoPartida LEFT JOIN
(SELECT Precio,IdPresupuestoPartida FROM PuPresupuestosPartidasCostos
WHERE IdMoneda=@IdMoneda) AS PRE ON P.IdPresupuestoPartida=PRE.IdPresupuestoPartida LEFT JOIN
PuResponsables AS R ON PP.IdResponsable = R.IdResponsable
WHERE P.IdPresupuesto = @IdPresupuesto AND PP.IdPrograma = @IdPrograma
ORDER BY P.Renglon
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaObtieneDatosPresupuesto]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <17 de Junio del 2009>
-- Description:	<Obtiene los conceptos a vizualizar en la ruta crítica>
-- Modificado:	<15 de Septiembre 2009>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaObtieneDatosPresupuesto]
@IdPresupuesto int,
@IdPrograma int,
@IdMoneda int
AS
DECLARE
@Decimales AS Int
EXEC @Decimales = NeoParametros_DecimalesRedondeo @IdPresupuesto = @IdPresupuesto
SELECT CAST(PA.IdPresupuestoPartida AS DECIMAL) AS IdPartidaPadre,CAST(PA.IdPresupuestoPartida AS DECIMAL)+ (CAST (P.IdPresupuestoConcepto AS DECIMAL) /1000000) AS IdPartidaArbol,
PA.Partida AS Partida,CAST(P.Control AS Varchar (20)) AS Control ,P.Renglon, C.Codigo, CAST(0 AS bit) AS Marca, P.CodigoAuxiliar,C.Descripcion, U.Unidad, R.Responsable,
PC.Duracion, PC.FechaInicio, PC.FechaFinal, PC.Rendimiento, PC.ActividadCritica,Pc.Holgura,pc.FechaInicioTardia,pc.FechaFinalTardia, PC.Avance,
P.Cantidad, P.CantidadTotal,COALESCE(PP.Precio,0) AS Precio, PC.Total,CAST( 1 AS BIT) AS EsConcepto,
ROUND(COALESCE(PP.Precio, 0)* P.Cantidad,@Decimales) AS Importe,
P.IdPresupuestoConcepto, P.IdPresupuestoPartida, P.IdExpIns, PC.IdResponsable,PC.IdProgramaConcepto,PA.PartidaWBS
FROM PuCatalogo AS C INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad INNER JOIN
PuExpIns AS E ON C.IdCodigo = E.IdCodigo INNER JOIN
PuPresupuestosConceptos AS P ON E.IdExpIns = P.IdExpIns INNER JOIN
PuPresupuestosPartidas AS PA ON P.IdPresupuestoPartida = PA.IdPresupuestoPartida LEFT JOIN
(SELECT Precio,IdPresupuestoConcepto FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda=@IdMoneda) AS PP ON P.IdPresupuestoConcepto=PP.IdPresupuestoConcepto INNER JOIN
PuProgramaConceptos AS PC ON P.IdPresupuestoConcepto = PC.IdPresupuestoConcepto LEFT JOIN
PuResponsables AS R ON PC.IdResponsable = R.IdResponsable
WHERE P.IdPresupuesto=@IdPresupuesto AND PC.IdPrograma=@IdPrograma
ORDER BY P.Renglon
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaObtieneFechasMinMaxPartidas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <17 de Junio del 2009>
-- Description:	<Obtiene la fecha de inicio y fecha final de cada partida basado en las fecha de los conceptos>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaObtieneFechasMinMaxPartidas]
@IdPrograma AS int
AS
SET NOCOUNT ON;
SELECT MIN(FechaInicio)AS FechaInicio, MAX(FechaFinal)AS FechaFinal,C.IdPresupuestoPartida
FROM PuPresupuestosConceptos AS C INNER JOIN
PuProgramaConceptos AS P ON C.IdPresupuestoConcepto=P.IdPresupuestoConcepto
WHERE P.IdPrograma=@IdPrograma
GROUP BY C.IdPresupuestoPartida
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaObtienePartidas]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <17 de Junio del 2009>
-- Description:	<Obtiene las partidas de un programa de obra>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaObtienePartidas]
@IdPrograma AS int
AS
SET NOCOUNT ON;
SELECT A.IdPartidaPadre,A.IdPresupuestoPartida,A.Partida,P.IdProgramaPartida,P.FechaInicio,P.FechaFinal,P.Duracion
FROM PuPresupuestosPartidas AS A INNER JOIN
PuProgramaPartidas AS P ON A.IdPresupuestoPartida=P.IdPresupuestoPartida
WHERE P.IdPrograma=@IdPrograma
ORDER BY A.IdPartidaPadre,A.IdPresupuestoPartida
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaObtienePeriodoPartidaArbol]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Modify date: <27 de Septiembre del 2009>
-- Description:	<Obtiene los periodos de conceptos que participan una partida>
-- =============================================
create PROCEDURE [dbo].[NeoRutaObtienePeriodoPartidaArbol]
@IdPresupuestoPartida as int
AS
SET NOCOUNT ON;
------------------------------------------------------------------------------------
-- Obtiene los periodos
WITH Arbol (IdPartidaPadre, IdPresupuestoPartida)
AS (
SELECT IdPartidaPadre, IdPresupuestoPartida
FROM PuPresupuestosPartidas
WHERE IdPresupuestoPartida = @IdPresupuestoPartida
UNION ALL
SELECT PP.IdPartidaPadre, PP.IdPresupuestoPartida
FROM PuPresupuestosPartidas AS PP INNER JOIN
Arbol AS A ON A.IdPresupuestoPartida = PP.IdPartidaPadre
)
SELECT P.IdProgramaConceptoPeriodo,P.IdProgramaConcepto,P.NoPeriodo,P.Porcentaje
FROM PuProgramaConceptosPeriodos AS P INNER JOIN
PuProgramaConceptos AS PP ON P.IdProgramaConcepto =PP.IdProgramaConcepto INNER JOIN
PuPresupuestosConceptos AS PC ON PP.IdPresupuestoConcepto = PC.IdPresupuestoConcepto INNER JOIN
Arbol AS A ON  PC.IdPresupuestoPartida = A.IdPresupuestoPartida;
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaObtienePeriodos]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <19 de septiembre 2009>
-- Description:	<Obtiene los periodos del programa de obra>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaObtienePeriodos]
@IdPrograma AS int
AS
SET NOCOUNT ON;
SELECT P.IdProgramaConceptoPeriodo,P.IdProgramaConcepto,P.NoPeriodo,P.Porcentaje
FROM PuProgramaConceptosPeriodos AS P INNER JOIN
PuProgramaConceptos AS C ON P.IdProgramaConcepto = C.IdProgramaConcepto
WHERE C.IdPrograma = @IdPrograma
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaObtienePeriodosConcepto]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Modify date: <27 de Septiembre del 2009>
-- Description:	<Obtiene los periodos de conceptos que participan una partida>
-- =============================================
create PROCEDURE [dbo].[NeoRutaObtienePeriodosConcepto]
@IdProgramaConcepto as int
AS
SET NOCOUNT ON;
------------------------------------------------------------------------------------
-- Obtiene los periodos
SELECT P.IdProgramaConceptoPeriodo,P.IdProgramaConcepto,P.NoPeriodo,P.Porcentaje
FROM PuProgramaConceptosPeriodos AS P
WHERE IdProgramaConcepto=@IdProgramaConcepto
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaObtienePrimerProgramaDeObra]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <17 de Junio del 2009>
-- Description:	<Obtiene el primer programa de obra del presupuesto>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaObtienePrimerProgramaDeObra]
@IdPresupuesto int,
@IdPrograma int=0
AS
SET @IdPrograma=(SELECT TOP 1 IdPrograma FROM PuProgramas WHERE IdPresupuesto=@IdPresupuesto ORDER BY NoPrograma ASC)
IF @IdPrograma IS null
RETURN
SELECT P.IdPrograma, P.NoPrograma, P.Descripcion, P.FechaInicio, P.FechaFinal,
P.NoPeriodos, P.Periodicidad, C.IdCalendario, C.Calendario, C.Descripcion,P.CapturarPorcentaje
FROM PuProgramas AS P INNER JOIN
PuCalendarios AS C ON P.IdCalendario=C.IdCalendario
WHERE P.IdPrograma=@IdPrograma
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaObtieneProgramaDeObra]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <17 de Junio del 2009>
-- Description:	<Obtiene el programa de obra indicado>
-- =============================================
CREATE PROCEDURE [dbo].[NeoRutaObtieneProgramaDeObra]
@IdPrograma int
AS
SELECT P.IdPrograma, P.NoPrograma, P.Descripcion, P.FechaInicio, P.FechaFinal,
P.NoPeriodos, P.Periodicidad, C.IdCalendario, C.Calendario, C.Descripcion,P.CapturarPorcentaje
FROM PuProgramas AS P INNER JOIN
PuCalendarios AS C ON P.IdCalendario=C.IdCalendario
WHERE P.IdPrograma=@IdPrograma
GO
/****** Object:  StoredProcedure [dbo].[NeoRutaTieneDatosPresupuesto]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Dámaso Hernández Guillén>
-- Create date: <29 de Julio del 2009>
-- Description:	<Revisa si hay datos en el presupuesto>
-- =============================================
create PROCEDURE [dbo].[NeoRutaTieneDatosPresupuesto]
@IdPresupuesto AS int
AS
SET NOCOUNT ON;
DECLARE @Cuantos as int
SET @Cuantos= (SELECT COUNT(IdPresupuestoConcepto) FROM PuPresupuestosConceptos WHERE IdPresupuesto=@IdPresupuesto)
IF @Cuantos =0
SET @Cuantos= (SELECT COUNT(IdPresupuestoPartida) FROM PuPresupuestosPartidas WHERE IdPresupuesto=@IdPresupuesto)
SELECT @Cuantos
GO
/****** Object:  Trigger [dbo].[TrPuPresupuestosPartidas_NecesitaRecalcularWBS]    Script Date: 09/10/2018 11:01:04 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Calor Bedolla / Andrés Estrada
-- Create date: 15-Septiembre-2009
-- Description:	Marca el Presupuesto como Necesita recalcular WBS
-- =============================================
CREATE TRIGGER [dbo].[TrPuPresupuestosPartidas_NecesitaRecalcularWBS]
ON [dbo].[PuPresupuestosPartidas]
AFTER INSERT, UPDATE, DELETE
AS
DECLARE @CuantosEnDel AS Int
DECLARE @CuantosEnIns as Int
DECLARE @IdPresupuesto AS Int
SELECT @CuantosEnDel = COUNT(*) FROM Deleted
SELECT @CuantosEnIns = COUNT(*) FROM Inserted
IF @CuantosEnDel > 0 AND @CuantosEnIns > 0
-- UPDATE
BEGIN
DECLARE @IdPartidaIns INT
DECLARE @RenIns INT
DECLARE @idPartidaDel INT
DECLARE @RenDel INT
SELECT @IdPartidaIns = IdPartidaPadre, @RenIns = Renglon
FROM Inserted
SELECT @IdPartidaDel = IdPartidaPadre, @RenDel = Renglon
FROM Deleted
IF @IdPartidaIns <> @IdPartidaDel OR @RenIns <> @RenDel BEGIN
SELECT @IdPresupuesto = MIN(IdPresupuesto) FROM Inserted
UPDATE PuPresupuestos SET RequiereCalcularWBS = 1 WHERE IdPresupuesto = @IdPresupuesto AND RequiereCalcularWBS = 0
END
END
ELSE IF @CuantosEnDel > 0 AND @CuantosEnIns = 0
-- DELETE
BEGIN
SELECT @IdPresupuesto = MIN(IdPresupuesto) FROM Deleted
UPDATE PuPresupuestos SET RequiereCalcularWBS = 1 WHERE IdPresupuesto = @IdPresupuesto AND RequiereCalcularWBS = 0
END
ELSE IF @CuantosEnDel = 0 AND @CuantosEnIns > 0
-- INSERT
BEGIN
SELECT @IdPresupuesto = MIN(IdPresupuesto) FROM Inserted
UPDATE PuPresupuestos SET RequiereCalcularWBS = 1 WHERE IdPresupuesto = @IdPresupuesto AND RequiereCalcularWBS = 0
END
GO
ALTER TABLE [dbo].[PuPresupuestosPartidas] ENABLE TRIGGER [TrPuPresupuestosPartidas_NecesitaRecalcularWBS]
GO
