﻿SET NUMERIC_ROUNDABORT OFF 
GO 
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON 
GO 
SET XACT_ABORT ON 
GO 
SET TRANSACTION ISOLATION LEVEL Serializable 
GO 
BEGIN TRANSACTION 
GO 
/*
Run this script on:

        LAPRGONZALEZ\SQLEXPRESS01.NuevaBaseVuelo    -  This database will be modified

to synchronize it with:

        LAPRGONZALEZ\SQLEXPRESS01.baseSourceBakVuelo

You are recommended to back up your database before running this script

Script created by SQL Compare Engine version 13.4.5.6953 from Red Gate Software Ltd at 03/10/2018 11:02:29 a. m.

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Altering [dbo].[PuExpIns]'
GO
ALTER TABLE [dbo].[PuExpIns] ALTER COLUMN [ObservacionPendiente] [varchar] (80) COLLATE Modern_Spanish_CI_AS NULL
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Altering [dbo].[NeoMatrices_CargaDatosGrid]'
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 9-Junio-2009
-- Description:	Devuelve el DataTable con la Matriz de un Concepto
--              opcionalmente puede devolver el IdPresupuesto y la DescripcionLarga de la Matriz
-- =============================================
ALTER PROCEDURE [dbo].[NeoMatrices_CargaDatosGrid]
@IdExpInsMatriz AS Int,
@IdPresupuesto AS Int = 0 OUTPUT,
@DescripcionLarga AS VarChar(MAX) OUTPUT,
@IdMoneda AS Int,
@IdMoneda2 AS Int OUT,
@IdMoneda3 AS Int OUT,
@DescripcionMoneda2 AS VarChar(20) OUT,
@DescripcionMoneda3 AS VarChar(20) OUT,
@PendienteAnalizar AS Bit OUT,
@ObservacionPendiente AS VarChar(80) OUT,
@UnidadMatriz AS VarChar(20) OUT
AS
DECLARE @Decimales AS Int,
@Sql AS nVarChar(3000)
-- Obtengo el IdPresupuesto y la DescripcionLarga de la Matriz
IF @IdPresupuesto IS NULL OR @DescripcionLarga IS NULL BEGIN
SELECT @IdPresupuesto = EI.IdPresupuesto, @DescripcionLarga = C.DescripcionLarga, @PendienteAnalizar = PendienteAnalizar, @ObservacionPendiente = EI.ObservacionPendiente, @UnidadMatriz = U.Unidad
FROM PuExpIns AS EI INNER JOIN
PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad
WHERE EI.IdExpIns = @IdExpInsMatriz
END
-- Obtengo el Número de Decimales
EXEC @Decimales = NeoParametros_DecimalesRedondeo @IdPresupuesto = @IdPresupuesto
EXEC NeoMatrices_DameMonedasPresupuesto @IdPresupuesto, @IdMoneda, @IdMoneda2 OUT, @IdMoneda3 OUT
SET @Sql = 'SELECT M.IdMatriz, M.IdCodigoMatriz AS IdExpInsMatriz, M.IdCodigoInsumo AS IdExpInsInsumo, M.Renglon, C.Codigo, EI.Nivel, C.Descripcion, C.DescripcionLarga, C.IdTipo, U.Unidad,
COALESCE(EIC.Costo, 0) AS Costo, CASE WHEN M.Dividir = 1 THEN ''/'' ELSE ''*'' END AS Dividir, M.Volumen,
CASE WHEN M.Volumen <> 0 AND M.Dividir = 1 THEN ROUND(COALESCE(EIC.Costo, 0) / M.Volumen, ' + CAST(@Decimales AS VarChar) + ') WHEN M.Volumen <> 0 AND M.Dividir = 0 THEN ROUND(COALESCE(EIC.Costo, 0) * M.Volumen, ' + CAST(@Decimales AS VarChar) + ') ELSE 0 END AS Importe,
M.Expresion, C.EsPorcentaje, EI.EsCostoHorario, EI.PendienteAnalizar, I.Imagen '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += ', COALESCE(EIC2.Costo, 0) AS Costo2,
CASE WHEN M.Volumen <> 0 AND M.Dividir = 1 THEN ROUND(COALESCE(EIC2.Costo, 0) / M.Volumen, ' + CAST(@Decimales AS VarChar) + ') WHEN M.Volumen <> 0 AND M.Dividir = 0 THEN ROUND(COALESCE(EIC2.Costo, 0) * M.Volumen, ' + CAST(@Decimales AS VarChar) + ') ELSE 0 END AS Importe2 '
SELECT @DescripcionMoneda2 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda2
IF @IdMoneda3 > 0 BEGIN
SET @Sql += ', COALESCE(EIC3.Costo, 0) AS Costo3,
CASE WHEN M.Volumen <> 0 AND M.Dividir = 1 THEN ROUND(COALESCE(EIC3.Costo, 0) / M.Volumen, ' + CAST(@Decimales AS VarChar) + ') WHEN M.Volumen <> 0 AND M.Dividir = 0 THEN ROUND(COALESCE(EIC3.Costo, 0) * M.Volumen, ' + CAST(@Decimales AS VarChar) + ') ELSE 0 END AS Importe3 '
SELECT @DescripcionMoneda3 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda3
END
END
SET @Sql += 'FROM PuMatrices AS M INNER JOIN
PuExpIns AS EI ON EI.IdExpIns = M.IdCodigoInsumo INNER JOIN
PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad LEFT JOIN
PuImagenes AS I ON C.IdImagen = I.IdImagen LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS EIC ON EIC.IdExpIns = EI.IdExpIns '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS EIC2 ON EIC2.IdExpIns = EI.IdExpIns '
IF @IdMoneda3 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS EIC3 ON EIC3.IdExpIns = EI.IdExpIns '
END
END
SET @Sql += 'WHERE M.IdCodigoMatriz = ' + CAST(@IdExpInsMatriz AS VarChar) + '
ORDER BY M.Renglon'
EXEC sp_executesql @Sql
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
/*
Run this script on:

LAPRGONZALEZ\SQLEXPRESS01.NuevaBaseVuelo    -  This database will be modified

to synchronize it with:

LAPRGONZALEZ\SQLEXPRESS01.baseSourceBakVuelo

You are recommended to back up your database before running this script

Script created by SQL Data Compare Engine version 13.4.5.6953 from Red Gate Software Ltd at 03/10/2018 11:02:35 a. m.

*/
		
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS, NOCOUNT ON
GO
SET DATEFORMAT YMD
GO
SET XACT_ABORT ON
GO

PRINT(N'Drop constraints from [dbo].[SegPermisos]')
ALTER TABLE [dbo].[SegPermisos] NOCHECK CONSTRAINT [FK_SegPermisos_SegGrupoPermisos]
ALTER TABLE [dbo].[SegPermisos] NOCHECK CONSTRAINT [FK_SegPermisos_SegSistemas]

PRINT(N'Add rows to [dbo].[SegPermisos]')
IF(NOT EXISTS(SELECT [Permiso], [IdSistema], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [PermisoDinamico] FROM [dbo].[SegPermisos] Where Nombre_Permiso = N'btnxActualizarCostosXCiudad'))
BEGIN
INSERT INTO [dbo].[SegPermisos] ([Permiso], [IdSistema], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [PermisoDinamico]) VALUES (185, 5, N'Corporativo', N'Corporativo', N'Actualización de costos x ciudad', N'btnxActualizarCostosXCiudad', 507, 0)
END
IF(NOT EXISTS(SELECT [Permiso], [IdSistema], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [PermisoDinamico] FROM [dbo].[SegPermisos] Where Nombre_Permiso = N'btnxDuplicarRuta'))
BEGIN
INSERT INTO [dbo].[SegPermisos] ([Permiso], [IdSistema], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [PermisoDinamico]) VALUES (186, 5, N'Presupuesto', N'Presupuesto', N'Duplicar ruta crítica', N'btnxDuplicarRuta', 505, 0)
END
PRINT(N'Operation applied to 2 rows out of 2')

PRINT(N'Add constraints to [dbo].[SegPermisos]')
ALTER TABLE [dbo].[SegPermisos] WITH CHECK CHECK CONSTRAINT [FK_SegPermisos_SegGrupoPermisos]
ALTER TABLE [dbo].[SegPermisos] WITH CHECK CHECK CONSTRAINT [FK_SegPermisos_SegSistemas]

Update [dbo].[Version] SET Version = '2012/04/17', Hora = '1230',VersionNeodata=2018, NombreNeodata ='Precios Unitarios 2018' 
COMMIT TRANSACTION 
GO 
SET NOEXEC OFF 
--This statement writes to the SQL Server Log so SQL Monitor can show this deployment. 
IF HAS_PERMS_BY_NAME(N'sys.xp_logevent', N'OBJECT', N'EXECUTE') = 1 
BEGIN 
DECLARE @databaseName AS nvarchar(2048), @eventMessage AS nvarchar(2048) 
SET @databaseName = REPLACE(REPLACE(DB_NAME(), N'\', N'\\'), N'"', N'\"') 
SET @eventMessage = N'Redgate SQL Compare: { "deployment": { "description": "Redgate SQL Compare deployed to ' + @databaseName + N'", "database": "' + @databaseName + N'" }}' 
EXECUTE sys.xp_logevent 55000, @eventMessage 
END 
GO 
IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION 
GO