﻿SET NUMERIC_ROUNDABORT OFF 
GO 
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON 
GO 
SET XACT_ABORT ON 
GO 
SET TRANSACTION ISOLATION LEVEL Serializable 
GO 
BEGIN TRANSACTION 
GO 
IF @@ERROR <> 0 SET NOEXEC ON
GO
/*
Run this script on:

        LAPRGONZALEZ\SQLEXPRESS01.NuevaBaseVuelo    -  This database will be modified

to synchronize it with:

        LAPRGONZALEZ\SQLEXPRESS01.baseSourceBakVuelo

You are recommended to back up your database before running this script

Script created by SQL Compare Engine version 13.4.5.6953 from Red Gate Software Ltd at 03/10/2018 11:45:39 a. m.

*/
SET NUMERIC_ROUNDABORT OFF
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Altering [dbo].[NeoPresupuestoConsecutivo_DameSiguiente]'
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 27-Mayo-2009
-- Description:	Obtiene el siguiente Id de PuPresupuestosConsecutivos
-- =============================================
ALTER PROCEDURE [dbo].[NeoPresupuestoConsecutivo_DameSiguiente]
@Tipo AS VarChar(100),
@IdPresupuesto AS Int
AS BEGIN
SET NOCOUNT ON;
DECLARE @Folio AS Int
DECLARE @ControlPaso AS Int
DECLARE @FolioControl AS Int
-- Reviso si existe el registro del Presupuesto sino lo creo
IF NOT EXISTS(SELECT IdPresupuesto FROM PuPresupuestosConsecutivos WHERE IdPresupuesto = @IdPresupuesto) BEGIN
INSERT INTO PuPresupuestosConsecutivos ( IdPresupuesto )
VALUES ( @IdPresupuesto )
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al insertar resgistro para presupuesto en PuPresupuestosConsecutivos.', 16, 1)
RETURN 0
END
END
IF @Tipo = 'FolioControlConcepto' BEGIN
SELECT @ControlPaso = MAX(Control) FROM PuPresupuestosConceptos WHERE IdPresupuesto = @IdPresupuesto
SELECT @FolioControl = FolioControlConcepto FROM PuPresupuestosConsecutivos WHERE IdPresupuesto = @IdPresupuesto
IF @FolioControl<@ControlPaso BEGIN
--Este es el caso en el que el folio consecutivo de control está mal ya que al sumar uno daría igual a un control que ya existe
--se debe corregir asignando el maximo control +1
UPDATE PuPresupuestosConsecutivos
SET FolioControlConcepto = @ControlPaso + 1
WHERE IdPresupuesto = @IdPresupuesto
END ELSE BEGIN
UPDATE PuPresupuestosConsecutivos
SET FolioControlConcepto = FolioControlConcepto + 1
WHERE IdPresupuesto = @IdPresupuesto
END
END ELSE IF @Tipo = 'FolioEstructuraPartidas' BEGIN
UPDATE PuPresupuestosConsecutivos
SET FolioEstructuraPartidas = FolioEstructuraPartidas + 1
WHERE IdPresupuesto = @IdPresupuesto
END ELSE IF @Tipo = 'FolioPrograma' BEGIN
UPDATE PuPresupuestosConsecutivos
SET FolioPrograma = FolioPrograma + 1
WHERE IdPresupuesto = @IdPresupuesto
END ELSE BEGIN
DECLARE @Error AS VarChar(100)
SET @Error = 'El Tipo que especificó no esta definido: ' + @Tipo + '.'
RAISERROR(@Error, 16, 1)
RETURN 0
END
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al incrementar Presupuesto Consecutivo. No se afectaron registros.', 16, 1)
RETURN 0
END
IF @Tipo = 'FolioControlConcepto' BEGIN
SELECT @Folio = FolioControlConcepto
FROM PuPresupuestosConsecutivos
WHERE IdPresupuesto = @IdPresupuesto
END ELSE IF @Tipo = 'FolioEstructuraPartidas' BEGIN
SELECT @Folio = FolioEstructuraPartidas
FROM PuPresupuestosConsecutivos
WHERE IdPresupuesto = @IdPresupuesto
END ELSE IF @Tipo = 'FolioPrograma' BEGIN
SELECT @Folio = FolioPrograma
FROM PuPresupuestosConsecutivos
WHERE IdPresupuesto = @IdPresupuesto
END
RETURN @Folio
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Adding foreign keys to [dbo].[PuContratos]'
GO
ALTER TABLE [dbo].[PuContratos] ADD CONSTRAINT [FK_PuContratos_PuPresupuestos] FOREIGN KEY ([IdPresupuesto]) REFERENCES [dbo].[PuPresupuestos] ([IdPresupuesto])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO

Update [dbo].[Version] SET Version = '2015/07/02', Hora = '1239',VersionNeodata=2018, NombreNeodata ='Precios Unitarios 2018' 
COMMIT TRANSACTION 
GO 
SET NOEXEC OFF 
--This statement writes to the SQL Server Log so SQL Monitor can show this deployment. 
IF HAS_PERMS_BY_NAME(N'sys.xp_logevent', N'OBJECT', N'EXECUTE') = 1 
BEGIN 
DECLARE @databaseName AS nvarchar(2048), @eventMessage AS nvarchar(2048) 
SET @databaseName = REPLACE(REPLACE(DB_NAME(), N'\', N'\\'), N'"', N'\"') 
SET @eventMessage = N'Redgate SQL Compare: { "deployment": { "description": "Redgate SQL Compare deployed to ' + @databaseName + N'", "database": "' + @databaseName + N'" }}' 
EXECUTE sys.xp_logevent 55000, @eventMessage 
END 
GO 
IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION 
GO