﻿/*
Estructura
*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL Serializable
GO
BEGIN TRANSACTION
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Dropping constraints from [dbo].[PuExpIns]'
GO
ALTER TABLE [dbo].[PuExpIns] DROP CONSTRAINT [DF_PuExplosionXProyecto_Expins]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Dropping constraints from [dbo].[PuExpIns]'
GO
ALTER TABLE [dbo].[PuExpIns] DROP CONSTRAINT [DF_PuExpIns_CantidadParaRequerir]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Dropping constraints from [dbo].[PuExpinsPar]'
GO
ALTER TABLE [dbo].[PuExpinsPar] DROP CONSTRAINT [DF_PuExpinsPar_Expins]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Dropping constraints from [dbo].[PuExpinsXconcepto]'
GO
ALTER TABLE [dbo].[PuExpinsXconcepto] DROP CONSTRAINT [DF_PuExpinsXconcepto_Volumen]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Dropping constraints from [dbo].[PuProgramaSumXPar]'
GO
ALTER TABLE [dbo].[PuProgramaSumXPar] DROP CONSTRAINT [DF_PuProgramaSumXPar_Cantidad]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Dropping constraints from [dbo].[PuProgramaSum]'
GO
ALTER TABLE [dbo].[PuProgramaSum] DROP CONSTRAINT [DF_PuProgramaSumXCon_Cantidad]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[PuContratos]'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
ALTER TABLE [dbo].[PuContratos] ADD
[Adendum] [money] NOT NULL CONSTRAINT [DF_PuContratos_Anticipo1] DEFAULT ((0))
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[PuExpIns]'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
ALTER TABLE [dbo].[PuExpIns] ALTER COLUMN [Expins] [decimal] (22, 8) NOT NULL
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
ALTER TABLE [dbo].[PuExpIns] ALTER COLUMN [CantidadParaRequerir] [decimal] (22, 8) NOT NULL
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[PuEstimaciones]'
GO
 
ALTER TABLE [dbo].[PuEstimaciones] ADD
[FolioFactura] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[PuExpinsPar]'
GO
 
ALTER TABLE [dbo].[PuExpinsPar] ALTER COLUMN [Expins] [decimal] (22, 8) NOT NULL
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[PuExpinsXconcepto]'
GO
 
ALTER TABLE [dbo].[PuExpinsXconcepto] ALTER COLUMN [Volumen] [decimal] (22, 10) NOT NULL
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[PuProgramaSum]'
GO
 
ALTER TABLE [dbo].[PuProgramaSum] ALTER COLUMN [Cantidad] [decimal] (22, 8) NOT NULL
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[PuProgramaSumXPar]'
GO
 
ALTER TABLE [dbo].[PuProgramaSumXPar] ALTER COLUMN [Cantidad] [decimal] (22, 8) NOT NULL
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[NeoCalculo_ActualizaProgSumId]'
GO
-- =============================================
-- Author:			Abel Davalos
-- Create date: 07-Octubre-2009
-- Description:	Actualiza en PuProgramaSum por Id Primario
-- =============================================
ALTER PROCEDURE [dbo].[NeoCalculo_ActualizaProgSumId]
@IdProgramaSum int,
@Cantidad Decimal(22,8)
AS
Begin
DECLARE @RegistrosAfectados Int
Begin
UPDATE PuProgramaSum SET Cantidad=@Cantidad WHERE IdProgramaSum=@IdProgramaSum
SET @RegistrosAfectados = @@ROWCOUNT
End
RETURN @RegistrosAfectados
End
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[NeoCalculo_ActualizaProgSumParId]'
GO
-- =============================================
-- Author:			Abel Davalos
-- Create date: 07-Octubre-2009
-- Description:	Actualiza en PuProgramaSumXPar por Id Primario
-- =============================================
ALTER PROCEDURE [dbo].[NeoCalculo_ActualizaProgSumParId]
@IdProgramaSumXPar int,
@Cantidad Decimal(22,8)
AS
Begin
DECLARE @RegistrosAfectados Int
Begin
UPDATE PuProgramaSumXPar SET Cantidad=@Cantidad WHERE IdProgramaSumXPar=@IdProgramaSumXPar
SET @RegistrosAfectados = @@ROWCOUNT
End
RETURN @RegistrosAfectados
End
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[NeoCalculo_ExpinsPar]'
GO
-- =============================================
-- Author:			Abel Davalos
-- Create date: 28-Septiembre-2009
-- Description:	Graba/Actualiza en ExpinsPar
-- =============================================
ALTER PROCEDURE [dbo].[NeoCalculo_ExpinsPar]
@IdExpinsPar int,
@IdPresupuestoPartida Int,
@IdExpins Int,
@Expins Decimal(22,8)
AS
IF @Idexpinspar = 0
Begin
INSERT INTO PuExpInsPar (Expins,IdPresupuestoPartida,IdExpins) VALUES (@Expins, @IdPresupuestoPartida, @IdExpins)
RETURN @@ROWCOUNT
End
ELSE
Begin
UPDATE PuExpinsPar SET Expins=@Expins WHERE Idexpinspar=@Idexpinspar
RETURN @@ROWCOUNT
End
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[NeoCalculo_ProgramaSum]'
GO
-- =============================================
-- Author:			Abel Davalos
-- Create date: 07-Octubre-2009
-- Description:	Actualiza en PuProgramaSum
-- =============================================
ALTER PROCEDURE [dbo].[NeoCalculo_ProgramaSum]
@IdPrograma int,
@IdExpins Int,
@NoPeriodo SmallInt,
@Cantidad Decimal(22,8)
AS
Begin
DECLARE @RegistrosAfectados Int
Begin
UPDATE PuProgramaSum SET Cantidad=@Cantidad WHERE IdPrograma=@IdPrograma AND IdExpins=@IdExpins AND NoPeriodo=@NoPeriodo
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
Begin
INSERT INTO PuProgramaSum (IdPrograma,IdExpins,NoPeriodo,Cantidad) VALUES (@IdPrograma,@IdExpins,@NoPeriodo,@Cantidad)
SET @RegistrosAfectados = @@ROWCOUNT
End
End
RETURN @RegistrosAfectados
End
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[NeoCalculo_ProgramaSumPar]'
GO
-- =============================================
-- Author:			Abel Davalos
-- Create date: 07-Octubre-2009
-- Description:	Actualiza en PuProgramaSum
-- =============================================
ALTER PROCEDURE [dbo].[NeoCalculo_ProgramaSumPar]
@IdProgramaPartida int,
@IdExpins Int,
@NoPeriodo SmallInt,
@Cantidad Decimal(22,8)
AS
Begin
DECLARE @RegistrosAfectados Int
Begin
UPDATE PuProgramaSumXPar SET Cantidad=@Cantidad
WHERE IdProgramaPartida=@IdProgramaPartida AND IdExpins=@IdExpins AND NoPeriodo=@NoPeriodo
SET @RegistrosAfectados = @@ROWCOUNT
IF @RegistrosAfectados = 0
Begin
INSERT INTO PuProgramaSumXPar (IdProgramaPartida,IdExpins,NoPeriodo,Cantidad)
VALUES (@IdProgramaPartida,@IdExpins,@NoPeriodo,@Cantidad)
SET @RegistrosAfectados = @@ROWCOUNT
End
End
RETURN @RegistrosAfectados
End
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Adding constraints to [dbo].[PuExpIns]'
GO
ALTER TABLE [dbo].[PuExpIns] ADD CONSTRAINT [DF_PuExplosionXProyecto_Expins] DEFAULT ((0)) FOR [Expins]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
ALTER TABLE [dbo].[PuExpIns] ADD CONSTRAINT [DF_PuExpIns_CantidadParaRequerir] DEFAULT ((0)) FOR [CantidadParaRequerir]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Adding constraints to [dbo].[PuExpinsPar]'
GO
ALTER TABLE [dbo].[PuExpinsPar] ADD CONSTRAINT [DF_PuExpinsPar_Expins] DEFAULT ((0)) FOR [Expins]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Adding constraints to [dbo].[PuExpinsXconcepto]'
GO
ALTER TABLE [dbo].[PuExpinsXconcepto] ADD CONSTRAINT [DF_PuExpinsXconcepto_Volumen] DEFAULT ((0)) FOR [Volumen]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Adding constraints to [dbo].[PuProgramaSumXPar]'
GO
ALTER TABLE [dbo].[PuProgramaSumXPar] ADD CONSTRAINT [DF_PuProgramaSumXPar_Cantidad] DEFAULT ((0)) FOR [Cantidad]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Adding constraints to [dbo].[PuProgramaSum]'
GO
ALTER TABLE [dbo].[PuProgramaSum] ADD CONSTRAINT [DF_PuProgramaSumXCon_Cantidad] DEFAULT ((0)) FOR [Cantidad]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 

/*
Datos
*/
	
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS, NOCOUNT ON
GO
SET DATEFORMAT YMD
GO
SET XACT_ABORT ON
GO

PRINT(N'Drop constraints from [dbo].[PuEmpresas]')
ALTER TABLE [dbo].[PuEmpresas] NOCHECK CONSTRAINT [FK_PuEmpresas_PuCiudades]
 
ALTER TABLE [dbo].[PuEmpresas] NOCHECK CONSTRAINT [FK_PuEmpresas_PuResponsables]
 

PRINT(N'Drop constraint FK_PuPresupuestos_PuEmpresas from [dbo].[PuPresupuestos]')
ALTER TABLE [dbo].[PuPresupuestos] NOCHECK CONSTRAINT [FK_PuPresupuestos_PuEmpresas]
 

PRINT(N'Drop constraints from [dbo].[PuCiudades]')
ALTER TABLE [dbo].[PuCiudades] NOCHECK CONSTRAINT [FK_PuCiudades_Estados]
 

PRINT(N'Drop constraint FK_LicLicitaciones_PuCiudades from [dbo].[LicLicitaciones]')
ALTER TABLE [dbo].[LicLicitaciones] NOCHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades]
 

PRINT(N'Drop constraint FK_LicLicitaciones_PuCiudades1 from [dbo].[LicLicitaciones]')
ALTER TABLE [dbo].[LicLicitaciones] NOCHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades1]
 

PRINT(N'Drop constraint FK_PuClientes_PuCiudades from [dbo].[PuClientes]')
ALTER TABLE [dbo].[PuClientes] NOCHECK CONSTRAINT [FK_PuClientes_PuCiudades]
 

PRINT(N'Drop constraint FK_PuContratistas_PuCiudades from [dbo].[PuContratistas]')
ALTER TABLE [dbo].[PuContratistas] NOCHECK CONSTRAINT [FK_PuContratistas_PuCiudades]
 

PRINT(N'Drop constraint FK_PuContratistasRepresentantesL_PuCiudades from [dbo].[PuContratistasRepresentantesL]')
ALTER TABLE [dbo].[PuContratistasRepresentantesL] NOCHECK CONSTRAINT [FK_PuContratistasRepresentantesL_PuCiudades]
 

PRINT(N'Drop constraint FK_PuCostoXCiudad_PuCiudades from [dbo].[PuCostosXCiudad]')
ALTER TABLE [dbo].[PuCostosXCiudad] NOCHECK CONSTRAINT [FK_PuCostoXCiudad_PuCiudades]
 

PRINT(N'Drop constraint FK_PuPresupuestos_PuCiudades from [dbo].[PuPresupuestos]')
ALTER TABLE [dbo].[PuPresupuestos] NOCHECK CONSTRAINT [FK_PuPresupuestos_PuCiudades]
 

PRINT(N'Drop constraint FK_PuProveedores_PuCiudades from [dbo].[PuProveedores]')
ALTER TABLE [dbo].[PuProveedores] NOCHECK CONSTRAINT [FK_PuProveedores_PuCiudades]
 

PRINT(N'Drop constraints from [dbo].[SegPermisos]')
ALTER TABLE [dbo].[SegPermisos] NOCHECK CONSTRAINT [FK_SegPermisos_SegGrupoPermisos]
 
ALTER TABLE [dbo].[SegPermisos] NOCHECK CONSTRAINT [FK_SegPermisos_SegSistemas]
 

PRINT(N'Update rows in [dbo].[PuParametros]')
UPDATE [dbo].[PuParametros] SET [Valor]='CIUDAD DE MÉXICO' WHERE [Parametro] = 'OPLugarCelebracion'
 
UPDATE [dbo].[PuParametros] SET [Valor]='CDMX' WHERE [Parametro] = 'OPCiudad'
 
PRINT(N'Operation applied to 2 rows out of 3')

PRINT(N'Update row in [dbo].[PuEstados]')
UPDATE [dbo].[PuEstados] SET [Estado]='CDMX', [Nombre]='Ciudad de México' WHERE [Estado] = 'DF' AND 'CDMX' NOT IN (SELECT [Estado] FROM [dbo].[PuEstados])
 

PRINT(N'Add row to [dbo].[SegPermisos]')
INSERT INTO [dbo].[SegPermisos] ([Permiso], [IdSistema], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [PermisoDinamico]) VALUES (195, 5, 'Presupuesto', 'Presupuesto', 'Convertir conceptos a paquetes', 'btnxConvertirConceptosAPaquetes', 505, 0)
 

PRINT(N'Add row to [dbo].[PuCiudades]')
SET IDENTITY_INSERT [dbo].[PuCiudades] ON
UPDATE [dbo].[PuCiudades] SET [Ciudad]='CDMX' WHERE [Ciudad]='DF' AND 'CDMX' NOT IN (SELECT [Ciudad] FROM [dbo].[PuCiudades])
 
--INSERT INTO [dbo].[PuCiudades] ([IdCiudad], [Ciudad], [Descripcion], [IdEstado]) VALUES (1, 'CDMX', 'Ciudad de México', 9)
SET IDENTITY_INSERT [dbo].[PuCiudades] OFF

PRINT(N'Add constraints to [dbo].[PuEmpresas]')
ALTER TABLE [dbo].[PuEmpresas] WITH CHECK CHECK CONSTRAINT [FK_PuEmpresas_PuCiudades]
 
ALTER TABLE [dbo].[PuEmpresas] WITH CHECK CHECK CONSTRAINT [FK_PuEmpresas_PuResponsables]
 
ALTER TABLE [dbo].[PuPresupuestos] WITH CHECK CHECK CONSTRAINT [FK_PuPresupuestos_PuEmpresas]
 

PRINT(N'Add constraints to [dbo].[PuCiudades]')
ALTER TABLE [dbo].[PuCiudades] CHECK CONSTRAINT [FK_PuCiudades_Estados]
 
ALTER TABLE [dbo].[LicLicitaciones] WITH CHECK CHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades]
 
ALTER TABLE [dbo].[LicLicitaciones] WITH CHECK CHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades1]
 
ALTER TABLE [dbo].[PuClientes] CHECK CONSTRAINT [FK_PuClientes_PuCiudades]
 
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_PuCiudades]
 
ALTER TABLE [dbo].[PuContratistasRepresentantesL] WITH CHECK CHECK CONSTRAINT [FK_PuContratistasRepresentantesL_PuCiudades]
 
ALTER TABLE [dbo].[PuCostosXCiudad] CHECK CONSTRAINT [FK_PuCostoXCiudad_PuCiudades]
 
ALTER TABLE [dbo].[PuPresupuestos] CHECK CONSTRAINT [FK_PuPresupuestos_PuCiudades]
 
ALTER TABLE [dbo].[PuProveedores] CHECK CONSTRAINT [FK_PuProveedores_PuCiudades]
 

PRINT(N'Add constraints to [dbo].[SegPermisos]')
ALTER TABLE [dbo].[SegPermisos] WITH CHECK CHECK CONSTRAINT [FK_SegPermisos_SegGrupoPermisos]
 
ALTER TABLE [dbo].[SegPermisos] WITH CHECK CHECK CONSTRAINT [FK_SegPermisos_SegSistemas]
 
Update [dbo].[Version] SET Version = '2016/08/12', Hora = '1439',VersionNeodata=2016 , NombreNeodata ='Precios Unitarios 2016'
 
COMMIT TRANSACTION
GO
 
SET NOEXEC OFF

-- This statement writes to the SQL Server Log so SQL Monitor can show this deployment.
IF HAS_PERMS_BY_NAME(N'sys.xp_logevent', N'OBJECT', N'EXECUTE') = 1
BEGIN
	DECLARE @databaseName AS nvarchar(2048), @eventMessage AS nvarchar(2048)
	SET @databaseName = REPLACE(REPLACE(DB_NAME(), N'\', N'\\'), N'"', N'\"')
	SET @eventMessage = N'Redgate SQL Compare: { "deployment": { "description": "Redgate SQL Compare deployed to ' + @databaseName + N'", "database": "' + @databaseName + N'" }}'
	EXECUTE sys.xp_logevent 55000, @eventMessage
END
GO
IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION
--PRINT 'The database update failed'
GO
