﻿SET NUMERIC_ROUNDABORT OFF 
GO 
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON 
GO 
SET XACT_ABORT ON 
GO 
SET TRANSACTION ISOLATION LEVEL Serializable 
GO 
BEGIN TRANSACTION 
GO 
/*
Run this script on:

        LAPRGONZALEZ\SQLEXPRESS01.NuevaBaseVuelo    -  This database will be modified

to synchronize it with:

        LAPRGONZALEZ\SQLEXPRESS01.baseSourceBakVuelo

You are recommended to back up your database before running this script

Script created by SQL Compare Engine version 13.4.5.6953 from Red Gate Software Ltd at 03/10/2018 10:32:40 a. m.

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Altering [dbo].[NeoPartidas_CargaDatosGrid]'
GO
-- =============================================
-- Author:        Carlos Bedolla
-- Create date: 26-Mayo-2009
-- Description:   Devuelve el DataTable con las Partidas por IdPresupuesto y el FolioEstructuraPartidas
-- =============================================
ALTER PROCEDURE [dbo].[NeoPartidas_CargaDatosGrid]
@IdPresupuesto AS Int,
@SqlLike AS VarChar(max),
@ExcluirRegistrosEnBusqueda AS Bit,
@FolioEstructuraPartidas As Int OUTPUT,
@IdMoneda As Int
AS
DECLARE @Tipo AS VarChar(100),
@Sql AS nVarChar(max)
SET @Tipo = 'FolioEstructuraPartidas'
EXEC @FolioEstructuraPartidas = NeoPresupuestoConsecutivo_DameActual @Tipo, @IdPresupuesto
IF @ExcluirRegistrosEnBusqueda = 0 OR @SqlLike IS NULL
BEGIN
SELECT PP.IdPresupuestoPartida, PP.IdPresupuesto, PP.IdPartidaPadre, PP.PartidaWBS, PP.Partida,
PP.Partida AS PartidaOriginal, PP.Renglon, PP.Cantidad, COALESCE(PPC.Costo, 0) AS Costo,
COALESCE(PPC.Precio, 0) AS Precio, PP.Cantidad * COALESCE(PPC.Costo, 0) AS ImporteCosto,
PP.Cantidad * COALESCE(PPC.Precio, 0) AS ImportePrecio,
CASE WHEN MetrosCuadrados = 0 THEN CAST(0 AS Decimal(18,6))
ELSE CAST((COALESCE(PPC.Costo, 0) / MetrosCuadrados) AS DECIMAL(19,2)) END AS CostoXM2,
CASE WHEN MetrosCuadrados = 0 THEN CAST(0 AS Decimal(18,6))
ELSE CAST((COALESCE(PPC.Precio, 0) / MetrosCuadrados) AS DECIMAL(19,2)) END AS PrecioXM2,
MetrosCuadrados, DescripcionPartida, DescripcionPartidaLarga
FROM PuPresupuestosPartidas AS PP LEFT JOIN
(SELECT IdPresupuestoPartida, Costo, Precio
FROM PuPresupuestosPartidasCostos
WHERE IdMoneda = @IdMoneda) AS PPC ON PPC.IdPresupuestoPartida = PP.IdPresupuestoPartida
WHERE PP.IdPresupuesto = @IdPresupuesto
ORDER BY PP.IdPartidaPadre, PP.Renglon
END ELSE
BEGIN
SET @Sql = 'WITH Arbol ( IdPresupuestoPartida, IdPresupuesto, IdPartidaPadre, PartidaWBS, Partida, PartidaOriginal, Renglon,
Cantidad, MetrosCuadrados, DescripcionPartida, DescripcionPartidaLarga )
AS (
SELECT PP.IdPresupuestoPartida, PP.Idpresupuesto, PP.IdPartidaPadre, PP.PartidaWBS, PP.Partida,
PP.Partida AS PartidaOriginal, PP.Renglon,
PP.Cantidad, PP.MetrosCuadrados, PP.DescripcionPartida, PP.DescripcionPartidaLarga
FROM PuPresupuestosPartidas AS PP INNER JOIN
PuPresupuestosConceptos AS PC ON PP.IdPresupuestoPartida = PC.IdPresupuestoPartida INNER JOIN
PuExpIns AS EI ON EI.IdExpins = PC.IdExpIns INNER JOIN
PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo
WHERE PC.IdPresupuesto = ' + CAST(@IdPresupuesto AS VarChar) + ' ' + @SqlLike + '
GROUP BY PP.IdpresupuestoPartida, PP.IdPresupuesto, PP.IdPartidaPadre, PP.PartidaWBS,
PP.Partida, PP.Renglon, PP.Cantidad, PP.MetrosCuadrados, PP.DescripcionPartida, PP.DescripcionPartidaLarga
UNION ALL
SELECT PP.IdPresupuestoPartida, PP.IdPresupuesto, PP.IdPartidaPadre, PP.PartidaWBS,
PP.Partida, PP.Partida AS PartidaOriginal, PP.Renglon,
PP.Cantidad, PP.MetrosCuadrados, PP.DescripcionPartida, PP.DescripcionPartidaLarga
FROM PuPresupuestosPartidas AS PP INNER JOIN
Arbol AS A ON A.IdpartidaPadre = PP.IdPresupuestoPartida
)
SELECT DISTINCT PP.IdPresupuestoPartida, PP.IdPresupuesto, PP.IdPartidaPadre,
PP.PartidaWBS, PP.Partida, PP.Renglon, PP.Cantidad, COALESCE(PPC.Costo, 0) AS Costo,
COALESCE(PPC.Precio, 0) AS Precio, PP.Cantidad * COALESCE(PPC.Costo, 0) AS ImporteCosto,
PP.Cantidad * COALESCE(PPC.Precio, 0) AS ImportePrecio,
CASE WHEN MetrosCuadrados = 0 THEN CAST(0 AS Decimal(18,6)) ELSE COALESCE(PPC.Costo, 0) / MetrosCuadrados END AS CostoXM2,
CASE WHEN MetrosCuadrados = 0 THEN CAST(0 AS Decimal(18,6)) ELSE COALESCE(PPC.Precio, 0) / MetrosCuadrados END AS PrecioXM2,
PP.MetrosCuadrados, PP.DescripcionPartida, PP.DescripcionPartidaLarga
FROM Arbol AS PP LEFT JOIN
(SELECT IdPresupuestoPartida, Costo, Precio
FROM PuPresupuestosPartidasCostos
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PPC ON PPC.IdPresupuestoPartida = PP.IdPresupuestoPartida
ORDER BY PP.IdPartidaPadre, PP.Renglon'
EXEC sp_executesql @Sql
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO

Update [dbo].[Version] SET Version = '2012/01/17', Hora = '1030',VersionNeodata=2018, NombreNeodata ='Precios Unitarios 2018' 
COMMIT TRANSACTION 
GO 
SET NOEXEC OFF 
--This statement writes to the SQL Server Log so SQL Monitor can show this deployment. 
IF HAS_PERMS_BY_NAME(N'sys.xp_logevent', N'OBJECT', N'EXECUTE') = 1 
BEGIN 
DECLARE @databaseName AS nvarchar(2048), @eventMessage AS nvarchar(2048) 
SET @databaseName = REPLACE(REPLACE(DB_NAME(), N'\', N'\\'), N'"', N'\"') 
SET @eventMessage = N'Redgate SQL Compare: { "deployment": { "description": "Redgate SQL Compare deployed to ' + @databaseName + N'", "database": "' + @databaseName + N'" }}' 
EXECUTE sys.xp_logevent 55000, @eventMessage 
END 
GO 
IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION 
GO