﻿SET NUMERIC_ROUNDABORT OFF 
GO 
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON 
GO 
SET XACT_ABORT ON 
GO 
SET TRANSACTION ISOLATION LEVEL Serializable 
GO 
BEGIN TRANSACTION 
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
/*
Run this script on:

        LAPRGONZALEZ\SQLEXPRESS01.NuevaBaseVuelo    -  This database will be modified

to synchronize it with:

        LAPRGONZALEZ\SQLEXPRESS01.baseSourceBakVuelo

You are recommended to back up your database before running this script

Script created by SQL Compare Engine version 13.4.5.6953 from Red Gate Software Ltd at 03/10/2018 11:34:16 a. m.

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
PRINT N'Altering [dbo].[SegUsuarios]'
GO
ALTER TABLE [dbo].[SegUsuarios] ADD
[Telefono] [varchar] (40) COLLATE Modern_Spanish_CI_AS NULL
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [dbo].[PuEstatusSolicitud]'
GO
CREATE TABLE [dbo].[PuEstatusSolicitud]
(
[IdEstatusSolicitud] [int] NOT NULL IDENTITY(1, 1),
[EstatusSolicitud] [int] NOT NULL,
[Descripcion] [nvarchar] (80) COLLATE Modern_Spanish_CI_AS NOT NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating primary key [PK_PuEstatusSolicitud] on [dbo].[PuEstatusSolicitud]'
GO
ALTER TABLE [dbo].[PuEstatusSolicitud] ADD CONSTRAINT [PK_PuEstatusSolicitud] PRIMARY KEY CLUSTERED  ([IdEstatusSolicitud])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [IX_PuEstatusSolicitud] on [dbo].[PuEstatusSolicitud]'
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuEstatusSolicitud] ON [dbo].[PuEstatusSolicitud] ([EstatusSolicitud])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [dbo].[PuCotizaciones]'
GO
CREATE TABLE [dbo].[PuCotizaciones]
(
[IdCotizacion] [int] NOT NULL IDENTITY(1, 1),
[Obra] [varchar] (20) COLLATE Modern_Spanish_CI_AS NULL,
[Codigo] [varchar] (20) COLLATE Modern_Spanish_CI_AS NOT NULL,
[DescripcionLarga] [varchar] (max) COLLATE Modern_Spanish_CI_AS NOT NULL,
[Unidad] [varchar] (20) COLLATE Modern_Spanish_CI_AS NOT NULL,
[Expins] [decimal] (18, 8) NOT NULL CONSTRAINT [DF_PuCotizaciones_Expins] DEFAULT ((0)),
[IdTipoSolicitud] [int] NOT NULL,
[IdEstatusSolicitud] [int] NOT NULL,
[IdUsuarioAnalista] [int] NOT NULL,
[FechaSolicitudAnalista] [datetime] NULL,
[ObservacionesAnalista] [varchar] (max) COLLATE Modern_Spanish_CI_AS NULL,
[IdUsuarioCotizador] [int] NULL,
[FechaAsignacionCotizador] [datetime] NULL,
[IdMoneda] [int] NOT NULL,
[Costo] [money] NOT NULL CONSTRAINT [DF_PuCotizaciones_Costo] DEFAULT ((0)),
[FechaCotizacion] [datetime] NULL,
[ObservacionesCotizador] [varchar] (max) COLLATE Modern_Spanish_CI_AS NULL,
[IdProveedor] [int] NULL,
[FechaSolicitudProveedor] [datetime] NULL,
[ObservacionesAdministrador] [varchar] (1000) COLLATE Modern_Spanish_CI_AS NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating primary key [PK_PuCotizaciones] on [dbo].[PuCotizaciones]'
GO
ALTER TABLE [dbo].[PuCotizaciones] ADD CONSTRAINT [PK_PuCotizaciones] PRIMARY KEY CLUSTERED  ([IdCotizacion])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [IX_PuCotizaciones] on [dbo].[PuCotizaciones]'
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCotizaciones] ON [dbo].[PuCotizaciones] ([Codigo])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [dbo].[PuTiposSolicitud]'
GO
CREATE TABLE [dbo].[PuTiposSolicitud]
(
[IdTipoSolicitud] [int] NOT NULL IDENTITY(1, 1),
[TipoSolicitud] [int] NOT NULL,
[Descripcion] [nvarchar] (80) COLLATE Modern_Spanish_CI_AS NOT NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating primary key [PK_PuTiposSolicitud] on [dbo].[PuTiposSolicitud]'
GO
ALTER TABLE [dbo].[PuTiposSolicitud] ADD CONSTRAINT [PK_PuTiposSolicitud] PRIMARY KEY CLUSTERED  ([IdTipoSolicitud])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [IX_PuTiposSolicitud] on [dbo].[PuTiposSolicitud]'
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuTiposSolicitud] ON [dbo].[PuTiposSolicitud] ([TipoSolicitud])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Altering [dbo].[PuExpInsCostos]'
GO
ALTER TABLE [dbo].[PuExpInsCostos] ADD
[PendienteCotizar] [bit] NOT NULL CONSTRAINT [DF_PuExpInsCostos_PendienteCotizar] DEFAULT ((0))
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [dbo].[PuProveedoresAdjuntos]'
GO
CREATE TABLE [dbo].[PuProveedoresAdjuntos]
(
[IdProveedorAdjunto] [int] NOT NULL IDENTITY(1, 1),
[IdUsuarioCotizador] [int] NOT NULL,
[IdProveedor] [int] NOT NULL,
[NombreDocumento] [varchar] (256) COLLATE Modern_Spanish_CI_AS NOT NULL,
[objDocumento] [varbinary] (max) NULL,
[Observaciones] [varchar] (8000) COLLATE Modern_Spanish_CI_AS NULL,
[Fecha] [datetime] NULL,
[Obra] [varchar] (20) COLLATE Modern_Spanish_CI_AS NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating primary key [PK_PuProveedoresAdjuntos] on [dbo].[PuProveedoresAdjuntos]'
GO
ALTER TABLE [dbo].[PuProveedoresAdjuntos] ADD CONSTRAINT [PK_PuProveedoresAdjuntos] PRIMARY KEY CLUSTERED  ([IdProveedorAdjunto])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [IX_PuProveedoresAdjuntos_1] on [dbo].[PuProveedoresAdjuntos]'
GO
CREATE NONCLUSTERED INDEX [IX_PuProveedoresAdjuntos_1] ON [dbo].[PuProveedoresAdjuntos] ([IdProveedor])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [IX_PuProveedoresAdjuntos_2] on [dbo].[PuProveedoresAdjuntos]'
GO
CREATE NONCLUSTERED INDEX [IX_PuProveedoresAdjuntos_2] ON [dbo].[PuProveedoresAdjuntos] ([IdUsuarioCotizador])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [IX_PuProveedoresAdjuntos] on [dbo].[PuProveedoresAdjuntos]'
GO
CREATE NONCLUSTERED INDEX [IX_PuProveedoresAdjuntos] ON [dbo].[PuProveedoresAdjuntos] ([Obra])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Altering [dbo].[NeoMatrices_CargaDatosGrid]'
GO
-- =============================================
-- Author:		Carlos Bedolla/abel
-- Create date: 9-Junio-2009
-- Description:	Devuelve el DataTable con la Matriz de un Concepto
--              opcionalmente puede devolver el IdPresupuesto y la DescripcionLarga de la Matriz
-- =============================================
ALTER PROCEDURE [dbo].[NeoMatrices_CargaDatosGrid]
@IdExpInsMatriz AS Int,
@VerObservaciones as Int,
@CodigoObra as Varchar(20),
@IdPresupuesto AS Int = 0 OUTPUT,
@DescripcionLarga AS VarChar(MAX) OUTPUT,
@IdMoneda AS Int,
@IdMoneda2 AS Int OUT,
@IdMoneda3 AS Int OUT,
@DescripcionMoneda2 AS VarChar(20) OUT,
@DescripcionMoneda3 AS VarChar(20) OUT,
@PendienteAnalizar AS Bit OUT,
@ObservacionPendiente AS VarChar(80) OUT,
@UnidadMatriz AS VarChar(20) OUT
AS
DECLARE @Decimales AS Int,
@Sql AS nVarChar(3000)
-- Obtengo el IdPresupuesto y la DescripcionLarga de la Matriz
IF @IdPresupuesto IS NULL OR @DescripcionLarga IS NULL BEGIN
SELECT @IdPresupuesto = EI.IdPresupuesto, @DescripcionLarga = C.DescripcionLarga, @PendienteAnalizar = PendienteAnalizar, @ObservacionPendiente = EI.ObservacionPendiente, @UnidadMatriz = U.Unidad
FROM PuExpIns AS EI INNER JOIN
PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad
WHERE EI.IdExpIns = @IdExpInsMatriz
END
-- Obtengo el Número de Decimales
EXEC @Decimales = NeoParametros_DecimalesRedondeo @IdPresupuesto = @IdPresupuesto
EXEC NeoMatrices_DameMonedasPresupuesto @IdPresupuesto, @IdMoneda, @IdMoneda2 OUT, @IdMoneda3 OUT
SET @Sql = 'SELECT M.IdMatriz, M.IdCodigoMatriz AS IdExpInsMatriz, M.IdCodigoInsumo AS IdExpInsInsumo, M.Renglon, C.Codigo, EI.Nivel, C.Descripcion, C.DescripcionLarga, C.IdTipo, U.Unidad,
COALESCE(EIC.Costo, 0) AS Costo, CASE WHEN M.Dividir = 1 THEN ''/'' ELSE ''*'' END AS Dividir, M.Volumen,
CASE WHEN M.Volumen <> 0 AND M.Dividir = 1 THEN ROUND(COALESCE(EIC.Costo, 0) / M.Volumen, ' + CAST(@Decimales AS VarChar) + ') WHEN M.Volumen <> 0 AND M.Dividir = 0 THEN ROUND(COALESCE(EIC.Costo, 0) * M.Volumen, ' + CAST(@Decimales AS VarChar) + ') ELSE 0 END AS Importe,
M.Expresion, C.EsPorcentaje, EI.EsCostoHorario, EI.PendienteAnalizar, I.Imagen '
IF @VerObservaciones >0
BEGIN
SET @Sql +=' ,Coalesce(PuCotizaciones.ObservacionesCotizador,'''') AS ObservacionesCotizador '
END
IF @IdMoneda2 > 0 BEGIN
SET @Sql += ', COALESCE(EIC2.Costo, 0) AS Costo2,
CASE WHEN M.Volumen <> 0 AND M.Dividir = 1 THEN ROUND(COALESCE(EIC2.Costo, 0) / M.Volumen, ' + CAST(@Decimales AS VarChar) + ') WHEN M.Volumen <> 0 AND M.Dividir = 0 THEN ROUND(COALESCE(EIC2.Costo, 0) * M.Volumen, ' + CAST(@Decimales AS VarChar) + ') ELSE 0 END AS Importe2 '
SELECT @DescripcionMoneda2 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda2
IF @IdMoneda3 > 0 BEGIN
SET @Sql += ', COALESCE(EIC3.Costo, 0) AS Costo3,
CASE WHEN M.Volumen <> 0 AND M.Dividir = 1 THEN ROUND(COALESCE(EIC3.Costo, 0) / M.Volumen, ' + CAST(@Decimales AS VarChar) + ') WHEN M.Volumen <> 0 AND M.Dividir = 0 THEN ROUND(COALESCE(EIC3.Costo, 0) * M.Volumen, ' + CAST(@Decimales AS VarChar) + ') ELSE 0 END AS Importe3 '
SELECT @DescripcionMoneda3 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda3
END
END
SET @Sql += 'FROM PuMatrices AS M INNER JOIN
PuExpIns AS EI ON EI.IdExpIns = M.IdCodigoInsumo INNER JOIN
PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad LEFT JOIN '
IF @VerObservaciones >0
BEGIN
SET @Sql +=' PuCotizaciones ON C.Codigo=PuCotizaciones.Codigo AND PuCotizaciones.IdMoneda=' +
CAST(@IdMoneda AS VarChar) + ' AND PuCotizaciones.Obra=''' + CAST(@CodigoObra AS VarChar) + ''' LEFT JOIN '
END
SET @Sql += ' PuImagenes AS I ON C.IdImagen = I.IdImagen LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS EIC ON EIC.IdExpIns = EI.IdExpIns '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS EIC2 ON EIC2.IdExpIns = EI.IdExpIns '
IF @IdMoneda3 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS EIC3 ON EIC3.IdExpIns = EI.IdExpIns '
END
END
SET @Sql += 'WHERE M.IdCodigoMatriz = ' + CAST(@IdExpInsMatriz AS VarChar) + '
ORDER BY M.Renglon'
EXEC sp_executesql @Sql
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Adding foreign keys to [dbo].[PuCotizaciones]'
GO
ALTER TABLE [dbo].[PuCotizaciones] ADD CONSTRAINT [FK_PuCotizaciones_PuTiposSolicitud] FOREIGN KEY ([IdTipoSolicitud]) REFERENCES [dbo].[PuTiposSolicitud] ([IdTipoSolicitud])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
ALTER TABLE [dbo].[PuCotizaciones] ADD CONSTRAINT [FK_PuCotizaciones_PuEstatusSolicitud] FOREIGN KEY ([IdEstatusSolicitud]) REFERENCES [dbo].[PuEstatusSolicitud] ([IdEstatusSolicitud])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
ALTER TABLE [dbo].[PuCotizaciones] ADD CONSTRAINT [FK_PuCotizaciones_SegUsuarios] FOREIGN KEY ([IdUsuarioAnalista]) REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
ALTER TABLE [dbo].[PuCotizaciones] ADD CONSTRAINT [FK_PuCotizaciones_SegUsuarios1] FOREIGN KEY ([IdUsuarioCotizador]) REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
ALTER TABLE [dbo].[PuCotizaciones] ADD CONSTRAINT [FK_PuCotizaciones_PuMonedas] FOREIGN KEY ([IdMoneda]) REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
ALTER TABLE [dbo].[PuCotizaciones] ADD CONSTRAINT [FK_PuCotizaciones_PuProveedores] FOREIGN KEY ([IdProveedor]) REFERENCES [dbo].[PuProveedores] ([IdProveedor])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Adding foreign keys to [dbo].[PuProveedoresAdjuntos]'
GO
ALTER TABLE [dbo].[PuProveedoresAdjuntos] ADD CONSTRAINT [FK_PuProveedoresAdjuntos_SegUsuarios] FOREIGN KEY ([IdUsuarioCotizador]) REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
ALTER TABLE [dbo].[PuProveedoresAdjuntos] ADD CONSTRAINT [FK_PuProveedoresAdjuntos_PuProveedores] FOREIGN KEY ([IdProveedor]) REFERENCES [dbo].[PuProveedores] ([IdProveedor])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
/*
Run this script on:

LAPRGONZALEZ\SQLEXPRESS01.NuevaBaseVuelo    -  This database will be modified

to synchronize it with:

LAPRGONZALEZ\SQLEXPRESS01.baseSourceBakVuelo

You are recommended to back up your database before running this script

Script created by SQL Data Compare Engine version 13.4.5.6953 from Red Gate Software Ltd at 03/10/2018 11:34:23 a. m.

*/
		
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS, NOCOUNT ON
GO
SET DATEFORMAT YMD
GO
SET XACT_ABORT ON
GO

PRINT(N'Drop constraints from [dbo].[SegPermisos]')
ALTER TABLE [dbo].[SegPermisos] NOCHECK CONSTRAINT [FK_SegPermisos_SegGrupoPermisos]
ALTER TABLE [dbo].[SegPermisos] NOCHECK CONSTRAINT [FK_SegPermisos_SegSistemas]

PRINT(N'Add rows to [dbo].[PuEstatusSolicitud]')
INSERT INTO [dbo].[PuEstatusSolicitud] ([EstatusSolicitud], [Descripcion]) VALUES (1, N'Cotizador no asignado')
INSERT INTO [dbo].[PuEstatusSolicitud] ([EstatusSolicitud], [Descripcion]) VALUES (2, N'En proceso')
INSERT INTO [dbo].[PuEstatusSolicitud] ([EstatusSolicitud], [Descripcion]) VALUES (3, N'Cotizado')
INSERT INTO [dbo].[PuEstatusSolicitud] ([EstatusSolicitud], [Descripcion]) VALUES (4, N'Autorizado por el administrador')
INSERT INTO [dbo].[PuEstatusSolicitud] ([EstatusSolicitud], [Descripcion]) VALUES (5, N'Revisar cotización')
PRINT(N'Operation applied to 5 rows out of 5')

PRINT(N'Add rows to [dbo].[PuParametros]')
INSERT INTO [dbo].[PuParametros] ([Parametro], [Valor], [Explicacion], [Especifico]) VALUES (N'CotizaEtapaActualizarCostos', N'4', N'Indica la etapa en la que debe estar el insumo para actualizar costos', 0)
INSERT INTO [dbo].[PuParametros] ([Parametro], [Valor], [Explicacion], [Especifico]) VALUES (N'CotizaVerObservaciones', N'0', N'Indica si se ven las observaciones en matrices y expins', 0)
PRINT(N'Operation applied to 2 rows out of 2')

PRINT(N'Add rows to [dbo].[PuTiposSolicitud]')
INSERT INTO [dbo].[PuTiposSolicitud] ([TipoSolicitud], [Descripcion]) VALUES (8, N'Presupuesto de referencia')
INSERT INTO [dbo].[PuTiposSolicitud] ([TipoSolicitud], [Descripcion]) VALUES (9, N'Fuera de catálogo')
INSERT INTO [dbo].[PuTiposSolicitud] ([TipoSolicitud], [Descripcion]) VALUES (10, N'Adjudicación directa')
INSERT INTO [dbo].[PuTiposSolicitud] ([TipoSolicitud], [Descripcion]) VALUES (11, N'Actualización de precio')
PRINT(N'Operation applied to 4 rows out of 4')

PRINT(N'Add rows to [dbo].[SegPermisos]')
INSERT INTO [dbo].[SegPermisos] ([Permiso], [IdSistema], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [PermisoDinamico]) VALUES (187, 5, N'Corporativo', N'Cotizaciones', N'Administrador de mercadeo', N'btnxUsuarioAdministradorMercadeo', 507, 0)
INSERT INTO [dbo].[SegPermisos] ([Permiso], [IdSistema], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [PermisoDinamico]) VALUES (188, 5, N'Corporativo', N'Cotizaciones', N'Usuario Analista', N'btnxUsuarioAnalista', 507, 0)
INSERT INTO [dbo].[SegPermisos] ([Permiso], [IdSistema], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [PermisoDinamico]) VALUES (189, 5, N'Corporativo', N'Cotizaciones', N'Usuario Cotizador', N'btnxUsuarioCotizador', 507, 0)
INSERT INTO [dbo].[SegPermisos] ([Permiso], [IdSistema], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [PermisoDinamico]) VALUES (190, 5, N'Corporativo', N'Cotizaciones', N'Estatus de solicitud', N'btnxEstatusDeSolicitud', 507, 0)
INSERT INTO [dbo].[SegPermisos] ([Permiso], [IdSistema], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [PermisoDinamico]) VALUES (191, 5, N'Corporativo', N'Cotizaciones', N'Tipos de solicitud', N'btnxTiposDeSolicitud', 507, 0)
INSERT INTO [dbo].[SegPermisos] ([Permiso], [IdSistema], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [PermisoDinamico]) VALUES (192, 5, N'Corporativo', N'Cotizaciones', N'Parámetros generales', N'btnxParametrosCotizaciones', 507, 0)
PRINT(N'Operation applied to 6 rows out of 6')

PRINT(N'Add constraints to [dbo].[SegPermisos]')
ALTER TABLE [dbo].[SegPermisos] WITH CHECK CHECK CONSTRAINT [FK_SegPermisos_SegGrupoPermisos]
ALTER TABLE [dbo].[SegPermisos] WITH CHECK CHECK CONSTRAINT [FK_SegPermisos_SegSistemas]

Update [dbo].[Version] SET Version = '2014/02/17', Hora = '1030',VersionNeodata=2018, NombreNeodata ='Precios Unitarios 2018' 
COMMIT TRANSACTION 
GO 
SET NOEXEC OFF 
--This statement writes to the SQL Server Log so SQL Monitor can show this deployment. 
IF HAS_PERMS_BY_NAME(N'sys.xp_logevent', N'OBJECT', N'EXECUTE') = 1 
BEGIN 
DECLARE @databaseName AS nvarchar(2048), @eventMessage AS nvarchar(2048) 
SET @databaseName = REPLACE(REPLACE(DB_NAME(), N'\', N'\\'), N'"', N'\"') 
SET @eventMessage = N'Redgate SQL Compare: { "deployment": { "description": "Redgate SQL Compare deployed to ' + @databaseName + N'", "database": "' + @databaseName + N'" }}' 
EXECUTE sys.xp_logevent 55000, @eventMessage 
END 
GO 
IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION 
GO