﻿SET NUMERIC_ROUNDABORT OFF 
GO 
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON 
GO 
SET XACT_ABORT ON 
GO 
SET TRANSACTION ISOLATION LEVEL Serializable 
GO 
BEGIN TRANSACTION 
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
/*
Run this script on:

        LAPRGONZALEZ\SQLEXPRESS01.NuevaBaseVuelo    -  This database will be modified

to synchronize it with:

        LAPRGONZALEZ\SQLEXPRESS01.baseSourceBakVuelo

You are recommended to back up your database before running this script

Script created by SQL Compare Engine version 13.4.5.6953 from Red Gate Software Ltd at 03/10/2018 11:37:49 a. m.

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
PRINT N'Dropping index [IX_PuCotizaciones] from [dbo].[PuCotizaciones]'
GO
DROP INDEX [IX_PuCotizaciones] ON [dbo].[PuCotizaciones]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Altering [dbo].[PuCotizaciones]'
GO
ALTER TABLE [dbo].[PuCotizaciones] ADD
[EnBitacora] [bit] NOT NULL CONSTRAINT [DF_PuCotizaciones_EnBitacora] DEFAULT ((0))
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [IX_PuCotizaciones] on [dbo].[PuCotizaciones]'
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCotizaciones] ON [dbo].[PuCotizaciones] ([Codigo], [IdMoneda])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [dbo].[PuCotizacionesBitacora]'
GO
CREATE TABLE [dbo].[PuCotizacionesBitacora]
(
[IdCotizacionBitacora] [int] NOT NULL IDENTITY(1, 1),
[Fecha] [datetime] NOT NULL,
[IdCotizacion] [int] NOT NULL,
[Obra] [varchar] (20) COLLATE Modern_Spanish_CI_AS NULL,
[Codigo] [varchar] (20) COLLATE Modern_Spanish_CI_AS NOT NULL,
[DescripcionLarga] [varchar] (max) COLLATE Modern_Spanish_CI_AS NOT NULL,
[Unidad] [varchar] (20) COLLATE Modern_Spanish_CI_AS NOT NULL,
[Expins] [decimal] (18, 8) NOT NULL CONSTRAINT [DF_PuCotizacionesBitacora_Expins] DEFAULT ((0)),
[IdTipoSolicitud] [int] NOT NULL,
[IdEstatusSolicitud] [int] NOT NULL,
[IdUsuarioAnalista] [int] NOT NULL,
[FechaSolicitudAnalista] [datetime] NULL,
[ObservacionesAnalista] [varchar] (max) COLLATE Modern_Spanish_CI_AS NULL,
[IdUsuarioCotizador] [int] NULL,
[FechaAsignacionCotizador] [datetime] NULL,
[IdMoneda] [int] NOT NULL,
[Costo] [money] NOT NULL CONSTRAINT [DF_PuCotizacionesBitacora_Costo] DEFAULT ((0)),
[FechaCotizacion] [datetime] NULL,
[ObservacionesCotizador] [varchar] (max) COLLATE Modern_Spanish_CI_AS NULL,
[IdProveedor] [int] NULL,
[FechaSolicitudProveedor] [datetime] NULL,
[ObservacionesAdministrador] [varchar] (1000) COLLATE Modern_Spanish_CI_AS NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating primary key [PK_PuCotizacionesBitacora] on [dbo].[PuCotizacionesBitacora]'
GO
ALTER TABLE [dbo].[PuCotizacionesBitacora] ADD CONSTRAINT [PK_PuCotizacionesBitacora] PRIMARY KEY CLUSTERED  ([IdCotizacionBitacora])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [IX_PuCotizacionesBitacora_1] on [dbo].[PuCotizacionesBitacora]'
GO
CREATE NONCLUSTERED INDEX [IX_PuCotizacionesBitacora_1] ON [dbo].[PuCotizacionesBitacora] ([Codigo])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [IX_PuCotizacionesBitacora_2] on [dbo].[PuCotizacionesBitacora]'
GO
CREATE NONCLUSTERED INDEX [IX_PuCotizacionesBitacora_2] ON [dbo].[PuCotizacionesBitacora] ([Fecha])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [IX_PuCotizacionesBitacora] on [dbo].[PuCotizacionesBitacora]'
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuCotizacionesBitacora] ON [dbo].[PuCotizacionesBitacora] ([IdCotizacion])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Altering [dbo].[NeoMatrices_CargaDatosGrid]'
GO
-- =============================================
-- Author:		Carlos Bedolla/abel
-- Create date: 9-Junio-2009
-- Description:	Devuelve el DataTable con la Matriz de un Concepto
--              opcionalmente puede devolver el IdPresupuesto y la DescripcionLarga de la Matriz
-- =============================================
ALTER PROCEDURE [dbo].[NeoMatrices_CargaDatosGrid]
@IdExpInsMatriz AS Int,
@VerObservaciones as Int,
@CodigoObra as Varchar(20),
@IdPresupuesto AS Int = 0 OUTPUT,
@DescripcionLarga AS VarChar(MAX) OUTPUT,
@IdMoneda AS Int,
@IdMoneda2 AS Int OUT,
@IdMoneda3 AS Int OUT,
@DescripcionMoneda2 AS VarChar(20) OUT,
@DescripcionMoneda3 AS VarChar(20) OUT,
@PendienteAnalizar AS Bit OUT,
@ObservacionPendiente AS VarChar(80) OUT,
@UnidadMatriz AS VarChar(20) OUT
AS
DECLARE @Decimales AS Int,
@Sql AS nVarChar(3000)
-- Obtengo el IdPresupuesto y la DescripcionLarga de la Matriz
IF @IdPresupuesto IS NULL OR @DescripcionLarga IS NULL BEGIN
SELECT @IdPresupuesto = EI.IdPresupuesto, @DescripcionLarga = C.DescripcionLarga, @PendienteAnalizar = PendienteAnalizar, @ObservacionPendiente = EI.ObservacionPendiente, @UnidadMatriz = U.Unidad
FROM PuExpIns AS EI INNER JOIN
PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo INNER JOIN
PuUnidades AS U ON C.IdUnidad = U.IdUnidad
WHERE EI.IdExpIns = @IdExpInsMatriz
END
-- Obtengo el Número de Decimales
EXEC @Decimales = NeoParametros_DecimalesRedondeo @IdPresupuesto = @IdPresupuesto
EXEC NeoMatrices_DameMonedasPresupuesto @IdPresupuesto, @IdMoneda, @IdMoneda2 OUT, @IdMoneda3 OUT
SET @Sql = 'SELECT M.IdMatriz, M.IdCodigoMatriz AS IdExpInsMatriz, M.IdCodigoInsumo AS IdExpInsInsumo, M.Renglon, C.Codigo, EI.Nivel, C.Descripcion, C.DescripcionLarga, C.IdTipo, U.Unidad,
COALESCE(EIC.Costo, 0) AS Costo, CASE WHEN M.Dividir = 1 THEN ''/'' ELSE ''*'' END AS Dividir, M.Volumen,
CASE WHEN M.Volumen <> 0 AND M.Dividir = 1 THEN ROUND(COALESCE(EIC.Costo, 0) / M.Volumen, ' + CAST(@Decimales AS VarChar) + ') WHEN M.Volumen <> 0 AND M.Dividir = 0 THEN ROUND(COALESCE(EIC.Costo, 0) * M.Volumen, ' + CAST(@Decimales AS VarChar) + ') ELSE 0 END AS Importe,
M.Expresion, C.EsPorcentaje, EI.EsCostoHorario, EI.PendienteAnalizar, I.Imagen '
IF @VerObservaciones >0
BEGIN
SET @Sql +=' ,Coalesce(PuCotizaciones.ObservacionesCotizador,'''') AS ObservacionesCotizador,Coalesce(Cast(PuEstatusSolicitud.EstatusSolicitud AS varchar),'''') AS EstatusSolicitud '
END
IF @IdMoneda2 > 0 BEGIN
SET @Sql += ', COALESCE(EIC2.Costo, 0) AS Costo2,
CASE WHEN M.Volumen <> 0 AND M.Dividir = 1 THEN ROUND(COALESCE(EIC2.Costo, 0) / M.Volumen, ' + CAST(@Decimales AS VarChar) + ') WHEN M.Volumen <> 0 AND M.Dividir = 0 THEN ROUND(COALESCE(EIC2.Costo, 0) * M.Volumen, ' + CAST(@Decimales AS VarChar) + ') ELSE 0 END AS Importe2 '
SELECT @DescripcionMoneda2 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda2
IF @IdMoneda3 > 0 BEGIN
SET @Sql += ', COALESCE(EIC3.Costo, 0) AS Costo3,
CASE WHEN M.Volumen <> 0 AND M.Dividir = 1 THEN ROUND(COALESCE(EIC3.Costo, 0) / M.Volumen, ' + CAST(@Decimales AS VarChar) + ') WHEN M.Volumen <> 0 AND M.Dividir = 0 THEN ROUND(COALESCE(EIC3.Costo, 0) * M.Volumen, ' + CAST(@Decimales AS VarChar) + ') ELSE 0 END AS Importe3 '
SELECT @DescripcionMoneda3 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda3
END
END
SET @Sql += 'FROM PuMatrices AS M INNER JOIN
PuExpIns AS EI ON EI.IdExpIns = M.IdCodigoInsumo INNER JOIN
PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo INNER JOIN
PuUnidades AS U ON U.IdUnidad = C.IdUnidad LEFT JOIN '
IF @VerObservaciones >0
BEGIN
SET @Sql +=' PuCotizaciones ON C.Codigo=PuCotizaciones.Codigo AND PuCotizaciones.IdMoneda=' +
CAST(@IdMoneda AS VarChar) + ' AND PuCotizaciones.Obra=''' + CAST(@CodigoObra AS VarChar) + ''' LEFT JOIN ' +
' PuEstatusSolicitud ON PuCotizaciones.IdEstatusSolicitud = PuEstatusSolicitud.IdEstatusSolicitud LEFT JOIN '
END
SET @Sql += ' PuImagenes AS I ON C.IdImagen = I.IdImagen LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS EIC ON EIC.IdExpIns = EI.IdExpIns '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS EIC2 ON EIC2.IdExpIns = EI.IdExpIns '
IF @IdMoneda3 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS EIC3 ON EIC3.IdExpIns = EI.IdExpIns '
END
END
SET @Sql += 'WHERE M.IdCodigoMatriz = ' + CAST(@IdExpInsMatriz AS VarChar) + '
ORDER BY M.Renglon'
EXEC sp_executesql @Sql
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Adding foreign keys to [dbo].[PuCotizacionesBitacora]'
GO
ALTER TABLE [dbo].[PuCotizacionesBitacora] ADD CONSTRAINT [FK_PuCotizacionesBitacora_PuTiposSolicitud] FOREIGN KEY ([IdTipoSolicitud]) REFERENCES [dbo].[PuTiposSolicitud] ([IdTipoSolicitud])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
ALTER TABLE [dbo].[PuCotizacionesBitacora] ADD CONSTRAINT [FK_PuCotizacionesBitacora_PuEstatusSolicitud] FOREIGN KEY ([IdEstatusSolicitud]) REFERENCES [dbo].[PuEstatusSolicitud] ([IdEstatusSolicitud])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
ALTER TABLE [dbo].[PuCotizacionesBitacora] ADD CONSTRAINT [FK_PuCotizacionesBitacora_SegUsuarios] FOREIGN KEY ([IdUsuarioAnalista]) REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
ALTER TABLE [dbo].[PuCotizacionesBitacora] ADD CONSTRAINT [FK_PuCotizacionesBitacora_SegUsuarios1] FOREIGN KEY ([IdUsuarioCotizador]) REFERENCES [dbo].[SegUsuarios] ([IdUsuario])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
ALTER TABLE [dbo].[PuCotizacionesBitacora] ADD CONSTRAINT [FK_PuCotizacionesBitacora_PuMonedas] FOREIGN KEY ([IdMoneda]) REFERENCES [dbo].[PuMonedas] ([IdMoneda])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
ALTER TABLE [dbo].[PuCotizacionesBitacora] ADD CONSTRAINT [FK_PuCotizacionesBitacora_PuProveedores] FOREIGN KEY ([IdProveedor]) REFERENCES [dbo].[PuProveedores] ([IdProveedor])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
/*
Run this script on:

LAPRGONZALEZ\SQLEXPRESS01.NuevaBaseVuelo    -  This database will be modified

to synchronize it with:

LAPRGONZALEZ\SQLEXPRESS01.baseSourceBakVuelo

You are recommended to back up your database before running this script

Script created by SQL Data Compare Engine version 13.4.5.6953 from Red Gate Software Ltd at 03/10/2018 11:37:55 a. m.

*/
		
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS, NOCOUNT ON
GO
SET DATEFORMAT YMD
GO
SET XACT_ABORT ON
GO

PRINT(N'Drop constraints from [dbo].[SegPermisos]')
ALTER TABLE [dbo].[SegPermisos] NOCHECK CONSTRAINT [FK_SegPermisos_SegGrupoPermisos]
ALTER TABLE [dbo].[SegPermisos] NOCHECK CONSTRAINT [FK_SegPermisos_SegSistemas]

PRINT(N'Update row in [dbo].[PuParametros]')
UPDATE [dbo].[PuParametros] SET [Valor]=N'C:\Neodata2014\Reportes' WHERE [Parametro] = cast(N'RutaReportes' COLLATE Modern_Spanish_CI_AS as varchar(30))

PRINT(N'Add row to [dbo].[PuParametros]')
INSERT INTO [dbo].[PuParametros] ([Parametro], [Valor], [Explicacion], [Especifico]) VALUES (N'CotizaDiasVigencia', N'90', N'Indica el número de dias para considerar una cotizacion vigente', 0)

PRINT(N'Add rows to [dbo].[SegPermisos]')
INSERT INTO [dbo].[SegPermisos] ([Permiso], [IdSistema], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [PermisoDinamico]) VALUES (193, 5, N'Corporativo', N'Cotizaciones', N'Bitácora cotizaciones (lectura)', N'btnxVerBitacoraCotizaciones', 507, 0)
INSERT INTO [dbo].[SegPermisos] ([Permiso], [IdSistema], [GrupoDescripcion], [SubGrupoDescripcion], [Descripcion], [Nombre_Permiso], [IdGrupoPermiso], [PermisoDinamico]) VALUES (194, 5, N'Corporativo', N'Cotizaciones', N'Bitácora cotizaciones (modificar)', N'btnxModBitacoraCotizaciones', 507, 0)
PRINT(N'Operation applied to 2 rows out of 2')

PRINT(N'Add constraints to [dbo].[SegPermisos]')
ALTER TABLE [dbo].[SegPermisos] WITH CHECK CHECK CONSTRAINT [FK_SegPermisos_SegGrupoPermisos]
ALTER TABLE [dbo].[SegPermisos] WITH CHECK CHECK CONSTRAINT [FK_SegPermisos_SegSistemas]

Update [dbo].[Version] SET Version = '2014/03/18', Hora = '1130',VersionNeodata=2018, NombreNeodata ='Precios Unitarios 2018' 
COMMIT TRANSACTION 
GO 
SET NOEXEC OFF 
--This statement writes to the SQL Server Log so SQL Monitor can show this deployment. 
IF HAS_PERMS_BY_NAME(N'sys.xp_logevent', N'OBJECT', N'EXECUTE') = 1 
BEGIN 
DECLARE @databaseName AS nvarchar(2048), @eventMessage AS nvarchar(2048) 
SET @databaseName = REPLACE(REPLACE(DB_NAME(), N'\', N'\\'), N'"', N'\"') 
SET @eventMessage = N'Redgate SQL Compare: { "deployment": { "description": "Redgate SQL Compare deployed to ' + @databaseName + N'", "database": "' + @databaseName + N'" }}' 
EXECUTE sys.xp_logevent 55000, @eventMessage 
END 
GO 
IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION 
GO