﻿/*
Estructura
*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL Serializable
GO
BEGIN TRANSACTION
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[PuMatrices]'
GO
 
ALTER TABLE [dbo].[PuMatrices] ALTER COLUMN [Expresion] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[NeoPresupuestoParticipa_Actualiza]'
GO
-- =============================================
-- Author:			José Luis Colín Ramírez
-- Create date: 04-Agosto-2009
-- Description:	Actualiza la Cantidad de los insumos
-- =============================================
ALTER PROCEDURE [dbo].[NeoPresupuestoParticipa_Actualiza]
@IdExpInsInsumo Int,
@IdExpInsMatriz Int,
@Volumen Decimal(18, 6),
@Expresion Varchar(100),
@EnMatriz Bit,
@EnLlantas Bit,
@EnOtrasFuentes Bit,
@EnPiezas Bit,
@EnOperacion Bit,
@EnOtrosConsumos bit
AS
BEGIN
SET NOCOUNT ON;
-- ACTUALIZA MATRICES
IF @EnMatriz = 1 	BEGIN
UPDATE PuMatrices SET Volumen = @Volumen, Expresion = @Expresion
WHERE IdCodigoMatriz = @IdExpInsMatriz AND IdCodigoInsumo = @IdExpInsInsumo  		END
-- ACTUALIZA LAS LLANTAS
IF @EnLlantas = 1 BEGIN
UPDATE PuCostosHorarios SET hllantas = @Volumen
WHERE IdExpInsLla = @IdExpInsInsumo AND IdExpIns = @IdExpInsMatriz	END
-- ACTUALIZA OTRAS FUENTES
IF @EnOtrasFuentes = 1 BEGIN
UPDATE PuCostosHorarios SET factFuentes = @Volumen
WHERE IdExpInsOtrasFuentes = @IdExpInsInsumo AND IdExpIns = @IdExpInsMatriz	END
-- ACTUALIZA PIEZAS ESPECIALES
IF @EnPiezas = 1 BEGIN
UPDATE PuCostosHorarios SET hPiezas = @Volumen
WHERE IdExpInsPza = @IdExpInsInsumo AND IdExpIns = @IdExpInsMatriz	END
-- ACTUALIZA LA OPERACION DE COSTOS HORARIOS
IF @EnOperacion = 1 BEGIN
UPDATE PuCostosHorariosMO SET Volumen = @Volumen
WHERE IdExpins = @IdExpInsInsumo
AND IdCostoHorario = (	SELECT IdCostoHorario
FROM PuCostosHorarios
WHERE IdExpins = @IdExpInsMatriz)		END
-- ACTUALIZA OTROS CONSUMOS DE COSTOS HORARIOS
IF @EnOtrosConsumos = 1 BEGIN
UPDATE PuCostosHorariosOC SET Volumen = @Volumen
WHERE IdExpins = @IdExpInsInsumo
AND IdCostoHorario = (	SELECT IdCostoHorario
FROM PuCostosHorarios
WHERE IdExpins = @IdExpInsMatriz)		END
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[NeoMatrices_GrabarActualizar]'
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 27-May-2009
-- Description:	Procedimiento para Guardar /Actualizar Insumos en Matrices
-- =============================================
ALTER PROCEDURE [dbo].[NeoMatrices_GrabarActualizar]
@IdPresupuesto AS Int,
@IdMatriz AS Int OUTPUT,
@IdExpInsMatriz AS Int,
@Renglon AS Int OUTPUT,
@IdExpInsInsumo AS Int OUTPUT,
@Costo AS Money,
@IdCodigoInsumo AS Int,
@Volumen AS Decimal(18, 6),
@Dividir AS Bit,
@Expresion AS VarChar(100),
@IdMoneda AS Int,
@EsCostoHorario AS Bit,
@IdUsuario AS Int
AS BEGIN
SET NOCOUNT ON;
DECLARE @CostoActual AS Money,
@IdProveedor AS Int,
@Error AS VarChar(1000),
@Severity  AS Int,
@State AS Int,
@IdTipoInsumo AS Int,
@CostoTipo AS Decimal(18, 6),
@Decimales AS Int,
@IdExpInsActual AS Int
BEGIN TRAN
BEGIN TRY
-- Reviso si el Insumo existe en ExpIns si no se inserta
IF @IdExpInsInsumo = 0 BEGIN
-- Hay que obtener el proveedor del Insumo
SELECT @IdProveedor  = IdProveedor
FROM PuCatalogo
WHERE IdCodigo = @IdCodigoInsumo
-- Se inserta el Insumo en ExpIns
INSERT INTO PuExpIns ( IdPresupuesto, IdCodigo, IdProveedor, EsCostoHorario )
VALUES ( @IdPresupuesto, @IdCodigoInsumo, @IdProveedor, @EsCostoHorario )
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al insertar el insumo en ExpIns. No se afectaron registros.', 16, 1)
RETURN
END
SET @IdExpInsInsumo = @@IDENTITY
END ELSE BEGIN
UPDATE PuExpIns
SET EsCostoHorario = @EsCostoHorario
WHERE IdExpIns = @IdExpInsInsumo
END
-- Actualizo el Costo
IF EXISTS(SELECT IdExpInsCosto FROM PuExpInsCostos WHERE IdExpIns = @IdExpInsInsumo AND IdMoneda = @IdMoneda ) BEGIN
-- Existe el costo para esta moneda entonces se actualiza
SELECT @CostoActual = Costo FROM PuExpInsCostos WHERE IdExpIns = @IdExpInsInsumo AND IdMoneda = @IdMoneda
IF @CostoActual IS NULL BEGIN
RAISERROR('Error al obtener el costo del concepto en ExpIns.', 16, 1)
RETURN
END
-- Revisa si el costo es diferente y lo actualiza
IF @Costo <> @CostoActual BEGIN
UPDATE PuExpInsCostos
SET Costo = @Costo, Fecha = GETDATE()
WHERE IdExpIns = @IdExpInsInsumo AND IdMoneda = @IdMoneda
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al actualizar Costo en ExpInsCostos.', 16, 1)
RETURN
END
EXEC NeoBitacoraCostos_GrabaBitacora @IdExpInsInsumo, @IdMoneda, @IdUsuario, @Costo
END
END ELSE BEGIN
-- No existe el costo en esta moneda asi que se inserta
INSERT INTO PuExpInsCostos ( IdExpIns, IdMoneda, Costo, Fecha )
VALUES ( @IdExpInsInsumo, @IdMoneda, @Costo, GETDATE() )
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al insertar Costo en ExpInsCostos.', 16, 1)
RETURN
END
EXEC NeoBitacoraCostos_GrabaBitacora @IdExpInsInsumo, @IdMoneda, @IdUsuario, @Costo
END
-- Grabo/Actualizo el Concepto
IF @IdMatriz = 0 BEGIN
-- Si no se asignó renglon se calcula
IF @Renglon Is NULL BEGIN
SELECT @Renglon = MAX(Renglon) FROM PuMatrices WHERE IdCodigoMatriz = @IdExpInsMatriz
IF @Renglon IS NULL BEGIN
SET @Renglon = 1
END ELSE BEGIN
SET @Renglon = @Renglon + 1
END
END
-- Insertar
INSERT INTO PuMatrices ( IdCodigoMatriz, Renglon, IdCodigoInsumo, Dividir, Volumen, Expresion )
VALUES ( @IdExpInsMatriz, @Renglon, @IdExpInsInsumo, @Dividir, @Volumen, @Expresion )
SET @IdMatriz = @@IDENTITY
END ELSE BEGIN
-- Actualizar
UPDATE PuMatrices
SET Renglon = @Renglon, IdCodigoInsumo = @IdExpInsInsumo, Dividir = @Dividir, Volumen = @Volumen, Expresion = @Expresion
WHERE IdMatriz = @IdMatriz
END
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al Grabar/Actualizar. No se afectaron registros', 16, 1)
RETURN
END
--    -- Obtengo el Número de Decimales
--    EXEC @Decimales = NeoParametros_DecimalesRedondeo
--
--    -- Obtengo el Tipo de Insumo
--    SELECT @IdTipoInsumo = C.IdTipo
--    FROM PuExpIns AS EI INNER JOIN
--         PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo
--    WHERE EI.IdExpIns = @IdCodigoInsumo
--
--    -- Reviso si se afectan porcentajes y hago el cálculo
--    SET @CostoTipo = NULL
--    DECLARE Proc_NeoMatrices_GarbarActualizar CURSOR LOCAL FORWARD_ONLY KEYSET OPTIMISTIC FOR
--            SELECT EI.IdExpIns, EI.Costo
--            FROM PuMatrices AS M INNER JOIN
--                 PuExpIns AS EI ON EI.IdExpIns = M.IdCodigoInsumo INNER JOIN
--                 PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo
--            WHERE M.IdCodigoMatriz = @IdCodigoMatriz AND C.EsPorcentaje = @IdTipoInsumo
--            FOR UPDATE OF EI.Costo
--    OPEN Proc_NeoMatrices_GarbarActualizar
--    FETCH NEXT FROM Proc_NeoMatrices_GarbarActualizar INTO @IdExpInsActual, @CostoActual
--    WHILE @@FETCH_STATUS = 0 BEGIN
--      -- Si hay Porcentajes del Tipo se calcula el Costo acumulado por Tipo
--      IF @CostoTipo IS NULL BEGIN
--        SELECT @CostoTipo = SUM(CASE WHEN M.Dividir = 1 THEN ROUND(EI.Costo / M.Volumen, @Decimales) ELSE ROUND(EI.Costo * M.Volumen, @Decimales) END)
--        FROM PuMatrices AS M INNER JOIN
--             PuExpIns AS EI ON EI.IdExpIns = M.IdCodigoInsumo INNER JOIN
--             PuCatalogo AS C ON C.IdCodigo = EI.IdCodigo
--        WHERE M.IdCodigoMatriz = @IdCodigoMatriz AND C.EsPorcentaje = 0 AND C.IdTipo = @IdTipoInsumo
--      END
--      IF @CostoTipo IS NULL BEGIN
--        SET @CostoTipo = 0
--      END
--      -- Revisa si el Costo esta mal y lo actualiza
--      IF @CostoActual <> @CostoTipo BEGIN
--        UPDATE PuExpIns
--        SET PuExpIns.Costo = @CostoTipo
--        WHERE CURRENT OF Proc_NeoMatrices_GarbarActualizar
--      END
--      FETCH NEXT FROM Proc_NeoMatrices_GarbarActualizar INTO @IdExpInsActual, @CostoActual
--    END
--    CLOSE Proc_NeoMatrices_GarbarActualizar
--    DEALLOCATE Proc_NeoMatrices_GarbarActualizar
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Severity = ERROR_SEVERITY()
SET @State = ERROR_STATE()
SET @Error = ERROR_MESSAGE()
RAISERROR(@Error, @Severity, @State)
RETURN
END CATCH;
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[NeoMatrices_GrabarSoloMatriz]'
GO
-- =============================================
-- Author:		Carlos Bedolla
-- Create date: 27-May-2009
-- Description:	Procedimiento para Guardar /Actualizar Insumos en Matrices
-- =============================================
ALTER PROCEDURE [dbo].[NeoMatrices_GrabarSoloMatriz]
@IdPresupuesto AS Int,
@IdMatriz AS Int OUTPUT,
@Renglon AS Int OUTPUT,
@IdCodigoMatriz AS Int,
@IdCodigoInsumo AS Int,
@Volumen AS Decimal(18, 6),
@Dividir AS Bit,
@Expresion AS VarChar(100)
AS BEGIN
SET NOCOUNT ON;
DECLARE @Error AS VarChar(1000),
@Severity  AS Int,
@State AS Int
BEGIN TRAN
BEGIN TRY
-- Si no se asignó renglon se calcula
IF @Renglon Is NULL BEGIN
SELECT @Renglon = MAX(Renglon) FROM PuMatrices WHERE IdCodigoMatriz = @IdCodigoMatriz
IF @Renglon IS NULL BEGIN
SET @Renglon = 10
END ELSE BEGIN
SET @Renglon = @Renglon + 10
END
END
-- Inserto el detalle de la Matriz
INSERT INTO PuMatrices ( IdCodigoMatriz, Renglon, IdCodigoInsumo, Dividir, Volumen, Expresion )
VALUES ( @IdCodigoMatriz, @Renglon, @IdCodigoInsumo, @Dividir, @Volumen, @Expresion )
SET @IdMatriz = @@IDENTITY
IF @@ROWCOUNT = 0 BEGIN
RAISERROR('Error al Insertar. No se afectaron registros', 16, 1)
RETURN
END
COMMIT TRAN
END TRY
BEGIN CATCH
ROLLBACK TRAN
SET @Severity = ERROR_SEVERITY()
SET @State = ERROR_STATE()
SET @Error = ERROR_MESSAGE()
RAISERROR(@Error, @Severity, @State)
RETURN
END CATCH;
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
Update [dbo].[Version] SET Version = '2017/11/06', Hora = '1300',VersionNeodata=2016, NombreNeodata ='Precios Unitarios 2016'
 
COMMIT TRANSACTION
GO
 
SET NOEXEC OFF
-- This statement writes to the SQL Server Log so SQL Monitor can show this deployment.
IF HAS_PERMS_BY_NAME(N'sys.xp_logevent', N'OBJECT', N'EXECUTE') = 1
BEGIN
	DECLARE @databaseName AS nvarchar(2048), @eventMessage AS nvarchar(2048)
	SET @databaseName = REPLACE(REPLACE(DB_NAME(), N'\', N'\\'), N'"', N'\"')
	SET @eventMessage = N'Redgate SQL Compare: { "deployment": { "description": "Redgate SQL Compare deployed to ' + @databaseName + N'", "database": "' + @databaseName + N'" }}'
	EXECUTE sys.xp_logevent 55000, @eventMessage
END
GO
IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION
GO
