﻿/*
Estructura
*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL Serializable
GO
BEGIN TRANSACTION
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
 
PRINT N'Creating index [IX_PuPlantillasCorreo] on [dbo].[PuPlantillasCorreo]'
GO
delete from PuPlantillasCorreo
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_PuPlantillasCorreo] ON [dbo].[PuPlantillasCorreo] ([Plantilla])
GO
SET IDENTITY_INSERT [dbo].[PuPlantillasCorreo] ON
GO
insert into PuPlantillasCorreo (IdPlantillaCorreo, Plantilla, URLplantilla, Descripcion) values (1,'PU-Archivo-Intercambio','https://cdn.neodata.com.mx/PU/HTML/Archivo-Intercambio-PU.html', 'Plantilla para el envío del presupuesto en formato archivo de intercambio.')
GO
SET IDENTITY_INSERT [dbo].[PuPlantillasCorreo] OFF
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
 
/*
datos
*/
	
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS, NOCOUNT ON
GO
SET DATEFORMAT YMD
GO
SET XACT_ABORT ON
GO

PRINT(N'Drop constraints from [dbo].[PuDocumentos]')
ALTER TABLE [dbo].[PuDocumentos] NOCHECK CONSTRAINT [FK_PuDocumentos_PuTiposDocumentos]
 

PRINT(N'Drop constraint FK_PuContratosFacturas_PuDocumentos from [dbo].[PuContratosFacturas]')
ALTER TABLE [dbo].[PuContratosFacturas] NOCHECK CONSTRAINT [FK_PuContratosFacturas_PuDocumentos]
 

PRINT(N'Drop constraint FK_PuContratosPlantillas_PuDocumentos from [dbo].[PuContratosPlantillas]')
ALTER TABLE [dbo].[PuContratosPlantillas] NOCHECK CONSTRAINT [FK_PuContratosPlantillas_PuDocumentos]
 

PRINT(N'Drop constraint FK_PuPresupuestosAdjuntos_PuDocumentos from [dbo].[PuPresupuestosAdjuntos]')
ALTER TABLE [dbo].[PuPresupuestosAdjuntos] NOCHECK CONSTRAINT [FK_PuPresupuestosAdjuntos_PuDocumentos]
 

PRINT(N'Drop constraint FK_PuPresupuestosAdjuntos_PuDocumentos1 from [dbo].[PuPresupuestosAdjuntos]')
ALTER TABLE [dbo].[PuPresupuestosAdjuntos] NOCHECK CONSTRAINT [FK_PuPresupuestosAdjuntos_PuDocumentos1]
 

PRINT(N'Drop constraint FK_PuPresupuestoAdjuntos_PuDocumentos from [dbo].[PuPresupuestosAdjuntosMonedas]')
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas] NOCHECK CONSTRAINT [FK_PuPresupuestoAdjuntos_PuDocumentos]
 

PRINT(N'Drop constraint FK_PuPresupuestoAdjuntos_PuDocumentos1 from [dbo].[PuPresupuestosAdjuntosMonedas]')
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas] NOCHECK CONSTRAINT [FK_PuPresupuestoAdjuntos_PuDocumentos1]
 

PRINT(N'Drop constraint FK_PuPresupuestoAdjuntos_PuDocumentos4 from [dbo].[PuPresupuestosAdjuntosMonedas]')
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas] NOCHECK CONSTRAINT [FK_PuPresupuestoAdjuntos_PuDocumentos4]
 

PRINT(N'Update rows in [dbo].[PuParametros]')
UPDATE [dbo].[PuParametros] SET [Valor]='1' WHERE [Parametro] = 'DividirDescripcionCada'
 
PRINT(N'Operation applied to 1 rows out of 2')

PRINT(N'Add constraints to [dbo].[PuDocumentos]')
ALTER TABLE [dbo].[PuDocumentos] WITH CHECK CHECK CONSTRAINT [FK_PuDocumentos_PuTiposDocumentos]
 
ALTER TABLE [dbo].[PuContratosFacturas] WITH CHECK CHECK CONSTRAINT [FK_PuContratosFacturas_PuDocumentos]
 
ALTER TABLE [dbo].[PuContratosPlantillas] WITH CHECK CHECK CONSTRAINT [FK_PuContratosPlantillas_PuDocumentos]
 
ALTER TABLE [dbo].[PuPresupuestosAdjuntos] WITH CHECK CHECK CONSTRAINT [FK_PuPresupuestosAdjuntos_PuDocumentos]
 
ALTER TABLE [dbo].[PuPresupuestosAdjuntos] WITH CHECK CHECK CONSTRAINT [FK_PuPresupuestosAdjuntos_PuDocumentos1]
 
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas] WITH CHECK CHECK CONSTRAINT [FK_PuPresupuestoAdjuntos_PuDocumentos]
 
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas] WITH CHECK CHECK CONSTRAINT [FK_PuPresupuestoAdjuntos_PuDocumentos1]
 
ALTER TABLE [dbo].[PuPresupuestosAdjuntosMonedas] WITH CHECK CHECK CONSTRAINT [FK_PuPresupuestoAdjuntos_PuDocumentos4]
 
Update [dbo].[Version] SET Version = '2018/07/13', Hora = '2323',VersionNeodata=2018, NombreNeodata ='Precios Unitarios 2018'
 
COMMIT TRANSACTION
GO
 
SET NOEXEC OFF
-- This statement writes to the SQL Server Log so SQL Monitor can show this deployment.
IF HAS_PERMS_BY_NAME(N'sys.xp_logevent', N'OBJECT', N'EXECUTE') = 1
BEGIN
	DECLARE @databaseName AS nvarchar(2048), @eventMessage AS nvarchar(2048)
	SET @databaseName = REPLACE(REPLACE(DB_NAME(), N'\', N'\\'), N'"', N'\"')
	SET @eventMessage = N'Redgate SQL Compare: { "deployment": { "description": "Redgate SQL Compare deployed to ' + @databaseName + N'", "database": "' + @databaseName + N'" }}'
	EXECUTE sys.xp_logevent 55000, @eventMessage
END
GO
IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION
GO

