﻿/*

Estructura

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
SET XACT_ABORT ON
GO	
SET TRANSACTION ISOLATION LEVEL Serializable
GO
BEGIN TRANSACTION
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Altering [dbo].[Version]'
GO
 
ALTER TABLE [dbo].[Version] ADD
[UltimaActualizacion] [datetime] NULL
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating [dbo].[Neo_DetieneActualizaUltimaModificacion]'
GO
-- =============================================
-- Author:		Victor Solares/Abel Dávalos
-- Create date: 11-Agosto-2017
-- Description:	Actualiza la fecha de ultima modificación en la tabla versión
-- =============================================
CREATE PROCEDURE [dbo].[Neo_DetieneActualizaUltimaModificacion]
-- Add the parameters for the stored procedure here
AS
BEGIN
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON;
DISABLE TRIGGER TrBiCatProcesos_ActualizaUltimaModificacion ON BiCatProcesos;
DISABLE TRIGGER TrBiCatSistemas_ActualizaUltimaModificacion ON BiCatSistemas;
DISABLE TRIGGER TrBitacora_ActualizaUltimaModificacion ON Bitacora;
DISABLE TRIGGER TrLicLicitaciones_ActualizaUltimaModificacion ON LicLicitaciones;
DISABLE TRIGGER TrLicLicitacionesContratistas_ActualizaUltimaModificacion ON LicLicitacionesContratistas;
DISABLE TRIGGER TrLicLicitacionesContratistasCuadro_ActualizaUltimaModificacion ON LicLicitacionesContratistasCuadro;
DISABLE TRIGGER TrLicLicitacionesContratistasDocumentos_ActualizaUltimaModificacion ON LicLicitacionesContratistasDocumentos;
DISABLE TRIGGER TrLicLicitacionesContratistasInsumos_ActualizaUltimaModificacion ON LicLicitacionesContratistasInsumos;
DISABLE TRIGGER TrLicLicitacionesContratistasPeriodos_ActualizaUltimaModificacion ON LicLicitacionesContratistasPeriodos;
DISABLE TRIGGER TrLicLicitacionesContratistasPrograma_ActualizaUltimaModificacion ON LicLicitacionesContratistasPrograma;
DISABLE TRIGGER TrLicLicitacionesContratistasProgramaPeriodos_ActualizaUltimaModificacion ON LicLicitacionesContratistasProgramaPeriodos;
DISABLE TRIGGER TrLicLicitacionesDocumentos_ActualizaUltimaModificacion ON LicLicitacionesDocumentos;
DISABLE TRIGGER TrLicLicitacionesFlujo_ActualizaUltimaModificacion ON LicLicitacionesFlujo;
DISABLE TRIGGER TrLicLicitacionesFlujoDet_ActualizaUltimaModificacion ON LicLicitacionesFlujoDet;
DISABLE TRIGGER TrLicLicitacionesInsumos_ActualizaUltimaModificacion ON LicLicitacionesInsumos;
DISABLE TRIGGER TrLicLicitacionesPartidas_ActualizaUltimaModificacion ON LicLicitacionesPartidas;
DISABLE TRIGGER TrLicLicitacionesPresupuesto_ActualizaUltimaModificacion ON LicLicitacionesPresupuesto;
DISABLE TRIGGER TrLicTiposLicitacion_ActualizaUltimaModificacion ON LicTiposLicitacion;
DISABLE TRIGGER TrLicTiposLicitacionDocumentos_ActualizaUltimaModificacion ON LicTiposLicitacionDocumentos;
DISABLE TRIGGER TrLicTiposLicitacionFlujo_ActualizaUltimaModificacion ON LicTiposLicitacionFlujo;
DISABLE TRIGGER TrLicTiposLicitacionFlujoDet_ActualizaUltimaModificacion ON LicTiposLicitacionFlujoDet;
DISABLE TRIGGER TrPuCalendarios_ActualizaUltimaModificacion ON PuCalendarios;
DISABLE TRIGGER TrPuCalendariosDet_ActualizaUltimaModificacion ON PuCalendariosDet;
DISABLE TRIGGER TrPuCamara_ActualizaUltimaModificacion ON PuCamara;
DISABLE TRIGGER TrPuCatalogo_ActualizaUltimaModificacion ON PuCatalogo;
DISABLE TRIGGER TrPuCatalogoIndices_ActualizaUltimaModificacion ON PuCatalogoIndices;
DISABLE TRIGGER TrPuCatDocumentosContratista_ActualizaUltimaModificacion ON PuCatDocumentosContratista;
DISABLE TRIGGER TrPuCatDocumentosContratos_ActualizaUltimaModificacion ON PuCatDocumentosContratos;
DISABLE TRIGGER TrPuCatEspecialidadesContratista_ActualizaUltimaModificacion ON PuCatEspecialidadesContratista;
DISABLE TRIGGER TrPuCatMaquinariaContratista_ActualizaUltimaModificacion ON PuCatMaquinariaContratista;
DISABLE TRIGGER TrPuCentros_ActualizaUltimaModificacion ON PuCentros;
DISABLE TRIGGER TrPuCiudades_ActualizaUltimaModificacion ON PuCiudades;
DISABLE TRIGGER TrPuClientes_ActualizaUltimaModificacion ON PuClientes;
DISABLE TRIGGER TrPuClientesContactos_ActualizaUltimaModificacion ON PuClientesContactos;
DISABLE TRIGGER TrPuContratantesConsecutivos_ActualizaUltimaModificacion ON PuContratantesConsecutivos;
DISABLE TRIGGER TrPuContratistaMaquinaria_ActualizaUltimaModificacion ON PuContratistaMaquinaria;
DISABLE TRIGGER TrPuContratistas_ActualizaUltimaModificacion ON PuContratistas;
DISABLE TRIGGER TrPuContratistasActividades_ActualizaUltimaModificacion ON PuContratistasActividades;
DISABLE TRIGGER TrPuContratistasDocumentos_ActualizaUltimaModificacion ON PuContratistasDocumentos;
DISABLE TRIGGER TrPuContratistasEspecialidades_ActualizaUltimaModificacion ON PuContratistasEspecialidades;
DISABLE TRIGGER TrPuContratistasRefrendos_ActualizaUltimaModificacion ON PuContratistasRefrendos;
DISABLE TRIGGER TrPuContratistasRepresentantesL_ActualizaUltimaModificacion ON PuContratistasRepresentantesL;
DISABLE TRIGGER TrPuContratos_ActualizaUltimaModificacion ON PuContratos;
DISABLE TRIGGER TrPuContratosConsecutivos_ActualizaUltimaModificacion ON PuContratosConsecutivos;
DISABLE TRIGGER TrPuContratosDeducciones_ActualizaUltimaModificacion ON PuContratosDeducciones;
DISABLE TRIGGER TrPuContratosDet_ActualizaUltimaModificacion ON PuContratosDet;
DISABLE TRIGGER TrPuContratosDocumentos_ActualizaUltimaModificacion ON PuContratosDocumentos;
DISABLE TRIGGER TrPuContratosFacturas_ActualizaUltimaModificacion ON PuContratosFacturas;
DISABLE TRIGGER TrPuContratosMonedas_ActualizaUltimaModificacion ON PuContratosMonedas;
DISABLE TRIGGER TrPuContratosPlantillas_ActualizaUltimaModificacion ON PuContratosPlantillas;
DISABLE TRIGGER TrPuContribuyente_ActualizaUltimaModificacion ON PuContribuyente;
DISABLE TRIGGER TrPuConversionesAcad_ActualizaUltimaModificacion ON PuConversionesAcad;
DISABLE TRIGGER TrPuCostosHorarios_ActualizaUltimaModificacion ON PuCostosHorarios;
DISABLE TRIGGER TrPuCostosHorariosMO_ActualizaUltimaModificacion ON PuCostosHorariosMO;
DISABLE TRIGGER TrPuCostosHorariosOC_ActualizaUltimaModificacion ON PuCostosHorariosOC;
DISABLE TRIGGER TrPuCostosHorariosTI_ActualizaUltimaModificacion ON PuCostosHorariosTI;
DISABLE TRIGGER TrPuCostosXCiudad_ActualizaUltimaModificacion ON PuCostosXCiudad;
DISABLE TRIGGER TrPuCotizaciones_ActualizaUltimaModificacion ON PuCotizaciones;
DISABLE TRIGGER TrPuCotizacionesBitacora_ActualizaUltimaModificacion ON PuCotizacionesBitacora;
DISABLE TRIGGER TrPuCuotasVigentesImss_ActualizaUltimaModificacion ON PuCuotasVigentesImss;
DISABLE TRIGGER TrPuDeducciones_ActualizaUltimaModificacion ON PuDeducciones;
DISABLE TRIGGER TrPuDocumentos_ActualizaUltimaModificacion ON PuDocumentos;
DISABLE TRIGGER TrPuEmpresaAfianzadora_ActualizaUltimaModificacion ON PuEmpresaAfianzadora;
DISABLE TRIGGER TrPuEmpresas_ActualizaUltimaModificacion ON PuEmpresas;
DISABLE TRIGGER TrPuEstados_ActualizaUltimaModificacion ON PuEstados;
DISABLE TRIGGER TrPuEstatusSolicitud_ActualizaUltimaModificacion ON PuEstatusSolicitud;
DISABLE TRIGGER TrPuEstimaciones_ActualizaUltimaModificacion ON PuEstimaciones;
DISABLE TRIGGER TrPuEstimacionesDeducciones_ActualizaUltimaModificacion ON PuEstimacionesDeducciones;
DISABLE TRIGGER TrPuEstimacionesDet_ActualizaUltimaModificacion ON PuEstimacionesDet;
DISABLE TRIGGER TrPuEstimacionesEstatusHistorico_ActualizaUltimaModificacion ON PuEstimacionesEstatusHistorico;
DISABLE TRIGGER TrPuEstimacionesTipos_ActualizaUltimaModificacion ON PuEstimacionesTipos;
DISABLE TRIGGER TrPuExpIns_ActualizaUltimaModificacion ON PuExpIns;
DISABLE TRIGGER TrPuExpInsCostos_ActualizaUltimaModificacion ON PuExpInsCostos;
DISABLE TRIGGER TrPuExpInsCostosBitacora_ActualizaUltimaModificacion ON PuExpInsCostosBitacora;
DISABLE TRIGGER TrPuExpinsCostosEQ_ActualizaUltimaModificacion ON PuExpinsCostosEQ;
DISABLE TRIGGER TrPuExpInsCostosOP_ActualizaUltimaModificacion ON PuExpInsCostosOP;
DISABLE TRIGGER TrPuExpInsDestajos_ActualizaUltimaModificacion ON PuExpInsDestajos;
DISABLE TRIGGER TrPuExpInsIntelimat_ActualizaUltimaModificacion ON PuExpInsIntelimat;
DISABLE TRIGGER TrPuExpInsMO_ActualizaUltimaModificacion ON PuExpInsMO;
DISABLE TRIGGER TrPuExpinsPar_ActualizaUltimaModificacion ON PuExpinsPar;
DISABLE TRIGGER TrPuExpinsXconcepto_ActualizaUltimaModificacion ON PuExpinsXconcepto;
DISABLE TRIGGER TrPuFamilias_ActualizaUltimaModificacion ON PuFamilias;
DISABLE TRIGGER TrPuFamiliasIndices_ActualizaUltimaModificacion ON PuFamiliasIndices;
DISABLE TRIGGER TrPuFichasTecnicas_ActualizaUltimaModificacion ON PuFichasTecnicas;
DISABLE TRIGGER TrPuGeneradores_ActualizaUltimaModificacion ON PuGeneradores;
DISABLE TRIGGER TrPuGeneradoresDet_ActualizaUltimaModificacion ON PuGeneradoresDet;
DISABLE TRIGGER TrPuGeneradoresDocumentos_ActualizaUltimaModificacion ON PuGeneradoresDocumentos;
DISABLE TRIGGER TrPuGeneradoresEstatusHistorico_ActualizaUltimaModificacion ON PuGeneradoresEstatusHistorico;
DISABLE TRIGGER TrPuGeneradoresIC_ActualizaUltimaModificacion ON PuGeneradoresIC;
DISABLE TRIGGER TrPuImagenes_ActualizaUltimaModificacion ON PuImagenes;
DISABLE TRIGGER TrPuIndices_ActualizaUltimaModificacion ON PuIndices;
DISABLE TRIGGER TrPuIndicesDet_ActualizaUltimaModificacion ON PuIndicesDet;
DISABLE TRIGGER TrPuIntelimat_ActualizaUltimaModificacion ON PuIntelimat;
DISABLE TRIGGER TrPuInteliPres_ActualizaUltimaModificacion ON PuInteliPres;
DISABLE TRIGGER TrPuLigasRuta_ActualizaUltimaModificacion ON PuLigasRuta;
DISABLE TRIGGER TrPuMatrices_ActualizaUltimaModificacion ON PuMatrices;
DISABLE TRIGGER TrPuMonedas_ActualizaUltimaModificacion ON PuMonedas;
DISABLE TRIGGER TrPuMonedasCalculadas_ActualizaUltimaModificacion ON PuMonedasCalculadas;
DISABLE TRIGGER TrPuMovimientos_ActualizaUltimaModificacion ON PuMovimientos;
DISABLE TRIGGER TrPuOficiosParametros_ActualizaUltimaModificacion ON PuOficiosParametros;
DISABLE TRIGGER TrPuOrdenesCambio_ActualizaUltimaModificacion ON PuOrdenesCambio;
DISABLE TRIGGER TrPuOrdenesCambioDet_ActualizaUltimaModificacion ON PuOrdenesCambioDet;
DISABLE TRIGGER TrPuOrdenesCambioTipo_ActualizaUltimaModificacion ON PuOrdenesCambioTipo;
DISABLE TRIGGER TrPuParametros_ActualizaUltimaModificacion ON PuParametros;
DISABLE TRIGGER TrPuPorcentajesFinanciamiento_ActualizaUltimaModificacion ON PuPorcentajesFinanciamiento;
DISABLE TRIGGER TrPuPorcentajesFM_ActualizaUltimaModificacion ON PuPorcentajesFM;
DISABLE TRIGGER TrPuPresupuestos_ActualizaUltimaModificacion ON PuPresupuestos;
DISABLE TRIGGER TrPuPresupuestosAdjuntos_ActualizaUltimaModificacion ON PuPresupuestosAdjuntos;
DISABLE TRIGGER TrPuPresupuestosAdjuntosMonedas_ActualizaUltimaModificacion ON PuPresupuestosAdjuntosMonedas;
DISABLE TRIGGER TrPuPresupuestosConceptos_ActualizaUltimaModificacion ON PuPresupuestosConceptos;
DISABLE TRIGGER TrPuPresupuestosConceptosPrecios_ActualizaUltimaModificacion ON PuPresupuestosConceptosPrecios;
DISABLE TRIGGER TrPuPresupuestosConsecutivos_ActualizaUltimaModificacion ON PuPresupuestosConsecutivos;
DISABLE TRIGGER TrPuPresupuestosMonedas_ActualizaUltimaModificacion ON PuPresupuestosMonedas;
DISABLE TRIGGER TrPuPresupuestosOficios_ActualizaUltimaModificacion ON PuPresupuestosOficios;
DISABLE TRIGGER TrPuPresupuestosParametros_ActualizaUltimaModificacion ON PuPresupuestosParametros;
DISABLE TRIGGER TrPuPresupuestosPartidas_ActualizaUltimaModificacion ON PuPresupuestosPartidas;
DISABLE TRIGGER TrPuPresupuestosPartidasCostos_ActualizaUltimaModificacion ON PuPresupuestosPartidasCostos;
DISABLE TRIGGER TrPuPresupuestosPrecios_ActualizaUltimaModificacion ON PuPresupuestosPrecios;
DISABLE TRIGGER TrPuPresupuestosPrestamos_ActualizaUltimaModificacion ON PuPresupuestosPrestamos;
DISABLE TRIGGER TrPuPresupuestosPrestamosDet_ActualizaUltimaModificacion ON PuPresupuestosPrestamosDet;
DISABLE TRIGGER TrPuPresupuestosVersion_ActualizaUltimaModificacion ON PuPresupuestosVersion;
DISABLE TRIGGER TrPuPresupuestosVersionCostos_ActualizaUltimaModificacion ON PuPresupuestosVersionCostos;
DISABLE TRIGGER TrPuProcedimientos_ActualizaUltimaModificacion ON PuProcedimientos;
DISABLE TRIGGER TrPuProgramaConceptos_ActualizaUltimaModificacion ON PuProgramaConceptos;
DISABLE TRIGGER TrPuProgramaConceptosPeriodos_ActualizaUltimaModificacion ON PuProgramaConceptosPeriodos;
DISABLE TRIGGER TrPuProgramaPartidas_ActualizaUltimaModificacion ON PuProgramaPartidas;
DISABLE TRIGGER TrPuProgramas_ActualizaUltimaModificacion ON PuProgramas;
DISABLE TRIGGER TrPuProgramasTipos_ActualizaUltimaModificacion ON PuProgramasTipos;
DISABLE TRIGGER TrPuProgramaSum_ActualizaUltimaModificacion ON PuProgramaSum;
DISABLE TRIGGER TrPuProgramaSumXPar_ActualizaUltimaModificacion ON PuProgramaSumXPar;
DISABLE TRIGGER TrPuProveedores_ActualizaUltimaModificacion ON PuProveedores;
DISABLE TRIGGER TrPuProveedoresAdjuntos_ActualizaUltimaModificacion ON PuProveedoresAdjuntos;
DISABLE TRIGGER TrPuReferenciaAcad_ActualizaUltimaModificacion ON PuReferenciaAcad;
DISABLE TRIGGER TrPuRepCarpetas_ActualizaUltimaModificacion ON PuRepCarpetas;
DISABLE TRIGGER TrPuRepHojas_ActualizaUltimaModificacion ON PuRepHojas;
DISABLE TRIGGER TrPuRepLibros_ActualizaUltimaModificacion ON PuRepLibros;
DISABLE TRIGGER TrPuRepOpciones_ActualizaUltimaModificacion ON PuRepOpciones;
DISABLE TRIGGER TrPuRepParametros_ActualizaUltimaModificacion ON PuRepParametros;
DISABLE TRIGGER TrPuResponsables_ActualizaUltimaModificacion ON PuResponsables;
DISABLE TRIGGER TrPuSesionCAOP_ActualizaUltimaModificacion ON PuSesionCAOP;
DISABLE TRIGGER TrPuStatusControlPadron_ActualizaUltimaModificacion ON PuStatusControlPadron;
DISABLE TRIGGER TrPuTipoInsumos_ActualizaUltimaModificacion ON PuTipoInsumos;
DISABLE TRIGGER TrPuTipoProveedor_ActualizaUltimaModificacion ON PuTipoProveedor;
DISABLE TRIGGER TrPuTiposDocumentos_ActualizaUltimaModificacion ON PuTiposDocumentos;
DISABLE TRIGGER TrPuTiposLicitacion_ActualizaUltimaModificacion ON PuTiposLicitacion;
DISABLE TRIGGER TrPuTiposSolicitud_ActualizaUltimaModificacion ON PuTiposSolicitud;
DISABLE TRIGGER TrPuUnidades_ActualizaUltimaModificacion ON PuUnidades;
DISABLE TRIGGER TrPuUnidadesAcad_ActualizaUltimaModificacion ON PuUnidadesAcad;
DISABLE TRIGGER TrPuVendedores_ActualizaUltimaModificacion ON PuVendedores;
DISABLE TRIGGER TrSegGrupoPermisos_ActualizaUltimaModificacion ON SegGrupoPermisos;
DISABLE TRIGGER TrSegPerfil_ActualizaUltimaModificacion ON SegPerfil;
DISABLE TRIGGER TrSegPermisos_ActualizaUltimaModificacion ON SegPermisos;
DISABLE TRIGGER TrSegSistemas_ActualizaUltimaModificacion ON SegSistemas;
DISABLE TRIGGER TrSegUsuarios_ActualizaUltimaModificacion ON SegUsuarios;
DISABLE TRIGGER TrSegUsuariosSistemas_ActualizaUltimaModificacion ON SegUsuariosSistemas;
DISABLE TRIGGER TrSegUsuariosXProyecto_ActualizaUltimaModificacion ON SegUsuariosXProyecto;
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating [dbo].[Neo_ActualizaUltimaModificacion]'
GO
-- =============================================
-- Author:		Victor Solares/Abel Dávalos
-- Create date: 10-Agosto-2017
-- Description:	Actualiza la fecha de ultima modificación en la tabla versión
-- =============================================
CREATE PROCEDURE [dbo].[Neo_ActualizaUltimaModificacion]
AS
BEGIN
DECLARE @RegistrosAfectados Int
DECLARE @IdVersion Int
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON;
UPDATE Version SET UltimaActualizacion=GETDATE()
--SET @RegistrosAfectados = @@ROWCOUNT
-- detiene triggers
Exec Neo_DetieneActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuOficiosParametros_ActualizaUltimaModificacion] on [dbo].[PuOficiosParametros]'
GO
CREATE TRIGGER [dbo].[TrPuOficiosParametros_ActualizaUltimaModificacion]
ON [dbo].[PuOficiosParametros]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuOficiosParametros_ActualizaUltimaModificacion] ON [dbo].[PuOficiosParametros]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuOrdenesCambio_ActualizaUltimaModificacion] on [dbo].[PuOrdenesCambio]'
GO
CREATE TRIGGER [dbo].[TrPuOrdenesCambio_ActualizaUltimaModificacion]
ON [dbo].[PuOrdenesCambio]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuOrdenesCambio_ActualizaUltimaModificacion] ON [dbo].[PuOrdenesCambio]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuOrdenesCambioDet_ActualizaUltimaModificacion] on [dbo].[PuOrdenesCambioDet]'
GO
CREATE TRIGGER [dbo].[TrPuOrdenesCambioDet_ActualizaUltimaModificacion]
ON [dbo].[PuOrdenesCambioDet]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuOrdenesCambioDet_ActualizaUltimaModificacion] ON [dbo].[PuOrdenesCambioDet]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuOrdenesCambioTipo_ActualizaUltimaModificacion] on [dbo].[PuOrdenesCambioTipo]'
GO
CREATE TRIGGER [dbo].[TrPuOrdenesCambioTipo_ActualizaUltimaModificacion]
ON [dbo].[PuOrdenesCambioTipo]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuOrdenesCambioTipo_ActualizaUltimaModificacion] ON [dbo].[PuOrdenesCambioTipo]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuParametros_ActualizaUltimaModificacion] on [dbo].[PuParametros]'
GO
CREATE TRIGGER [dbo].[TrPuParametros_ActualizaUltimaModificacion]
ON [dbo].[PuParametros]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuParametros_ActualizaUltimaModificacion] ON [dbo].[PuParametros]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPorcentajesFinanciamiento_ActualizaUltimaModificacion] on [dbo].[PuPorcentajesFinanciamiento]'
GO
CREATE TRIGGER [dbo].[TrPuPorcentajesFinanciamiento_ActualizaUltimaModificacion]
ON [dbo].[PuPorcentajesFinanciamiento]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPorcentajesFinanciamiento_ActualizaUltimaModificacion] ON [dbo].[PuPorcentajesFinanciamiento]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPorcentajesFM_ActualizaUltimaModificacion] on [dbo].[PuPorcentajesFM]'
GO
CREATE TRIGGER [dbo].[TrPuPorcentajesFM_ActualizaUltimaModificacion]
ON [dbo].[PuPorcentajesFM]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPorcentajesFM_ActualizaUltimaModificacion] ON [dbo].[PuPorcentajesFM]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestos_ActualizaUltimaModificacion] on [dbo].[PuPresupuestos]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestos_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestos_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosAdjuntos_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosAdjuntos]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosAdjuntos_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosAdjuntos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosAdjuntos_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosAdjuntos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosAdjuntosMonedas_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosAdjuntosMonedas]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosAdjuntosMonedas_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosAdjuntosMonedas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosAdjuntosMonedas_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosAdjuntosMonedas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosConceptos_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosConceptos]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosConceptos_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosConceptos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosConceptos_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosConceptos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosConceptosPrecios_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosConceptosPrecios]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosConceptosPrecios_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosConceptosPrecios]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosConceptosPrecios_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosConceptosPrecios]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosConsecutivos_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosConsecutivos]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosConsecutivos_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosConsecutivos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosConsecutivos_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosConsecutivos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosMonedas_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosMonedas]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosMonedas_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosMonedas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosMonedas_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosMonedas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosOficios_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosOficios]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosOficios_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosOficios]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosOficios_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosOficios]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosParametros_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosParametros]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosParametros_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosParametros]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosParametros_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosParametros]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosPartidas_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosPartidas]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosPartidas_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosPartidas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosPartidas_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosPartidas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosPartidasCostos_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosPartidasCostos]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosPartidasCostos_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosPartidasCostos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosPartidasCostos_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosPartidasCostos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosPrecios_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosPrecios]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosPrecios_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosPrecios]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosPrecios_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosPrecios]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosPrestamos_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosPrestamos]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosPrestamos_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosPrestamos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosPrestamos_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosPrestamos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosPrestamosDet_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosPrestamosDet]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosPrestamosDet_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosPrestamosDet]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosPrestamosDet_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosPrestamosDet]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosVersion_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosVersion]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosVersion_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosVersion]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosVersion_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosVersion]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuPresupuestosVersionCostos_ActualizaUltimaModificacion] on [dbo].[PuPresupuestosVersionCostos]'
GO
CREATE TRIGGER [dbo].[TrPuPresupuestosVersionCostos_ActualizaUltimaModificacion]
ON [dbo].[PuPresupuestosVersionCostos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuPresupuestosVersionCostos_ActualizaUltimaModificacion] ON [dbo].[PuPresupuestosVersionCostos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuProcedimientos_ActualizaUltimaModificacion] on [dbo].[PuProcedimientos]'
GO
CREATE TRIGGER [dbo].[TrPuProcedimientos_ActualizaUltimaModificacion]
ON [dbo].[PuProcedimientos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuProcedimientos_ActualizaUltimaModificacion] ON [dbo].[PuProcedimientos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuProgramaConceptos_ActualizaUltimaModificacion] on [dbo].[PuProgramaConceptos]'
GO
CREATE TRIGGER [dbo].[TrPuProgramaConceptos_ActualizaUltimaModificacion]
ON [dbo].[PuProgramaConceptos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuProgramaConceptos_ActualizaUltimaModificacion] ON [dbo].[PuProgramaConceptos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuProgramaConceptosPeriodos_ActualizaUltimaModificacion] on [dbo].[PuProgramaConceptosPeriodos]'
GO
CREATE TRIGGER [dbo].[TrPuProgramaConceptosPeriodos_ActualizaUltimaModificacion]
ON [dbo].[PuProgramaConceptosPeriodos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuProgramaConceptosPeriodos_ActualizaUltimaModificacion] ON [dbo].[PuProgramaConceptosPeriodos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuProgramaPartidas_ActualizaUltimaModificacion] on [dbo].[PuProgramaPartidas]'
GO
CREATE TRIGGER [dbo].[TrPuProgramaPartidas_ActualizaUltimaModificacion]
ON [dbo].[PuProgramaPartidas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuProgramaPartidas_ActualizaUltimaModificacion] ON [dbo].[PuProgramaPartidas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuProgramas_ActualizaUltimaModificacion] on [dbo].[PuProgramas]'
GO
CREATE TRIGGER [dbo].[TrPuProgramas_ActualizaUltimaModificacion]
ON [dbo].[PuProgramas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuProgramas_ActualizaUltimaModificacion] ON [dbo].[PuProgramas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuProgramasTipos_ActualizaUltimaModificacion] on [dbo].[PuProgramasTipos]'
GO
CREATE TRIGGER [dbo].[TrPuProgramasTipos_ActualizaUltimaModificacion]
ON [dbo].[PuProgramasTipos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuProgramasTipos_ActualizaUltimaModificacion] ON [dbo].[PuProgramasTipos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuProgramaSum_ActualizaUltimaModificacion] on [dbo].[PuProgramaSum]'
GO
CREATE TRIGGER [dbo].[TrPuProgramaSum_ActualizaUltimaModificacion]
ON [dbo].[PuProgramaSum]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuProgramaSum_ActualizaUltimaModificacion] ON [dbo].[PuProgramaSum]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuProgramaSumXPar_ActualizaUltimaModificacion] on [dbo].[PuProgramaSumXPar]'
GO
CREATE TRIGGER [dbo].[TrPuProgramaSumXPar_ActualizaUltimaModificacion]
ON [dbo].[PuProgramaSumXPar]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuProgramaSumXPar_ActualizaUltimaModificacion] ON [dbo].[PuProgramaSumXPar]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuProveedores_ActualizaUltimaModificacion] on [dbo].[PuProveedores]'
GO
CREATE TRIGGER [dbo].[TrPuProveedores_ActualizaUltimaModificacion]
ON [dbo].[PuProveedores]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuProveedores_ActualizaUltimaModificacion] ON [dbo].[PuProveedores]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuProveedoresAdjuntos_ActualizaUltimaModificacion] on [dbo].[PuProveedoresAdjuntos]'
GO
CREATE TRIGGER [dbo].[TrPuProveedoresAdjuntos_ActualizaUltimaModificacion]
ON [dbo].[PuProveedoresAdjuntos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuProveedoresAdjuntos_ActualizaUltimaModificacion] ON [dbo].[PuProveedoresAdjuntos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuReferenciaAcad_ActualizaUltimaModificacion] on [dbo].[PuReferenciaAcad]'
GO
CREATE TRIGGER [dbo].[TrPuReferenciaAcad_ActualizaUltimaModificacion]
ON [dbo].[PuReferenciaAcad]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuReferenciaAcad_ActualizaUltimaModificacion] ON [dbo].[PuReferenciaAcad]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuRepCarpetas_ActualizaUltimaModificacion] on [dbo].[PuRepCarpetas]'
GO
CREATE TRIGGER [dbo].[TrPuRepCarpetas_ActualizaUltimaModificacion]
ON [dbo].[PuRepCarpetas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuRepCarpetas_ActualizaUltimaModificacion] ON [dbo].[PuRepCarpetas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrBiCatProcesos_ActualizaUltimaModificacion] on [dbo].[BiCatProcesos]'
GO
CREATE TRIGGER [dbo].[TrBiCatProcesos_ActualizaUltimaModificacion]
ON [dbo].[BiCatProcesos] AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrBiCatProcesos_ActualizaUltimaModificacion] ON [dbo].[BiCatProcesos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuRepHojas_ActualizaUltimaModificacion] on [dbo].[PuRepHojas]'
GO
CREATE TRIGGER [dbo].[TrPuRepHojas_ActualizaUltimaModificacion]
ON [dbo].[PuRepHojas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuRepHojas_ActualizaUltimaModificacion] ON [dbo].[PuRepHojas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrBiCatSistemas_ActualizaUltimaModificacion] on [dbo].[BiCatSistemas]'
GO
CREATE TRIGGER [dbo].[TrBiCatSistemas_ActualizaUltimaModificacion]
ON [dbo].[BiCatSistemas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrBiCatSistemas_ActualizaUltimaModificacion] ON [dbo].[BiCatSistemas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuRepLibros_ActualizaUltimaModificacion] on [dbo].[PuRepLibros]'
GO
CREATE TRIGGER [dbo].[TrPuRepLibros_ActualizaUltimaModificacion]
ON [dbo].[PuRepLibros]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuRepLibros_ActualizaUltimaModificacion] ON [dbo].[PuRepLibros]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrBitacora_ActualizaUltimaModificacion] on [dbo].[Bitacora]'
GO
CREATE TRIGGER [dbo].[TrBitacora_ActualizaUltimaModificacion]
ON [dbo].[Bitacora]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrBitacora_ActualizaUltimaModificacion] ON [dbo].[Bitacora]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuRepOpciones_ActualizaUltimaModificacion] on [dbo].[PuRepOpciones]'
GO
CREATE TRIGGER [dbo].[TrPuRepOpciones_ActualizaUltimaModificacion]
ON [dbo].[PuRepOpciones]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuRepOpciones_ActualizaUltimaModificacion] ON [dbo].[PuRepOpciones]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicLicitaciones_ActualizaUltimaModificacion] on [dbo].[LicLicitaciones]'
GO
CREATE TRIGGER [dbo].[TrLicLicitaciones_ActualizaUltimaModificacion]
ON [dbo].[LicLicitaciones]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitaciones_ActualizaUltimaModificacion] ON [dbo].[LicLicitaciones]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuRepParametros_ActualizaUltimaModificacion] on [dbo].[PuRepParametros]'
GO
CREATE TRIGGER [dbo].[TrPuRepParametros_ActualizaUltimaModificacion]
ON [dbo].[PuRepParametros]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuRepParametros_ActualizaUltimaModificacion] ON [dbo].[PuRepParametros]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicLicitacionesContratistas_ActualizaUltimaModificacion] on [dbo].[LicLicitacionesContratistas]'
GO
CREATE TRIGGER [dbo].[TrLicLicitacionesContratistas_ActualizaUltimaModificacion]
ON [dbo].[LicLicitacionesContratistas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitacionesContratistas_ActualizaUltimaModificacion] ON [dbo].[LicLicitacionesContratistas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuResponsables_ActualizaUltimaModificacion] on [dbo].[PuResponsables]'
GO
CREATE TRIGGER [dbo].[TrPuResponsables_ActualizaUltimaModificacion]
ON [dbo].[PuResponsables]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuResponsables_ActualizaUltimaModificacion] ON [dbo].[PuResponsables]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicLicitacionesContratistasCuadro_ActualizaUltimaModificacion] on [dbo].[LicLicitacionesContratistasCuadro]'
GO
CREATE TRIGGER [dbo].[TrLicLicitacionesContratistasCuadro_ActualizaUltimaModificacion]
ON [dbo].[LicLicitacionesContratistasCuadro]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitacionesContratistasCuadro_ActualizaUltimaModificacion] ON [dbo].[LicLicitacionesContratistasCuadro]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuSesionCAOP_ActualizaUltimaModificacion] on [dbo].[PuSesionCAOP]'
GO
CREATE TRIGGER [dbo].[TrPuSesionCAOP_ActualizaUltimaModificacion]
ON [dbo].[PuSesionCAOP]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuSesionCAOP_ActualizaUltimaModificacion] ON [dbo].[PuSesionCAOP]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicLicitacionesContratistasDocumentos_ActualizaUltimaModificacion] on [dbo].[LicLicitacionesContratistasDocumentos]'
GO
CREATE TRIGGER [dbo].[TrLicLicitacionesContratistasDocumentos_ActualizaUltimaModificacion]
ON [dbo].[LicLicitacionesContratistasDocumentos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitacionesContratistasDocumentos_ActualizaUltimaModificacion] ON [dbo].[LicLicitacionesContratistasDocumentos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating trigger [dbo].[TrPuStatusControlPadron_ActualizaUltimaModificacion] on [dbo].[PuStatusControlPadron]'
GO
CREATE TRIGGER [dbo].[TrPuStatusControlPadron_ActualizaUltimaModificacion]
ON [dbo].[PuStatusControlPadron]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuStatusControlPadron_ActualizaUltimaModificacion] ON [dbo].[PuStatusControlPadron]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicLicitacionesContratistasInsumos_ActualizaUltimaModificacion] on [dbo].[LicLicitacionesContratistasInsumos]'
GO
CREATE TRIGGER [dbo].[TrLicLicitacionesContratistasInsumos_ActualizaUltimaModificacion]
ON [dbo].[LicLicitacionesContratistasInsumos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitacionesContratistasInsumos_ActualizaUltimaModificacion] ON [dbo].[LicLicitacionesContratistasInsumos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuTipoInsumos_ActualizaUltimaModificacion] on [dbo].[PuTipoInsumos]'
GO
CREATE TRIGGER [dbo].[TrPuTipoInsumos_ActualizaUltimaModificacion]
ON [dbo].[PuTipoInsumos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuTipoInsumos_ActualizaUltimaModificacion] ON [dbo].[PuTipoInsumos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicLicitacionesContratistasPeriodos_ActualizaUltimaModificacion] on [dbo].[LicLicitacionesContratistasPeriodos]'
GO
CREATE TRIGGER [dbo].[TrLicLicitacionesContratistasPeriodos_ActualizaUltimaModificacion]
ON [dbo].[LicLicitacionesContratistasPeriodos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitacionesContratistasPeriodos_ActualizaUltimaModificacion] ON [dbo].[LicLicitacionesContratistasPeriodos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuTipoProveedor_ActualizaUltimaModificacion] on [dbo].[PuTipoProveedor]'
GO
CREATE TRIGGER [dbo].[TrPuTipoProveedor_ActualizaUltimaModificacion]
ON [dbo].[PuTipoProveedor]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuTipoProveedor_ActualizaUltimaModificacion] ON [dbo].[PuTipoProveedor]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicLicitacionesContratistasPrograma_ActualizaUltimaModificacion] on [dbo].[LicLicitacionesContratistasPrograma]'
GO
CREATE TRIGGER [dbo].[TrLicLicitacionesContratistasPrograma_ActualizaUltimaModificacion]
ON [dbo].[LicLicitacionesContratistasPrograma]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitacionesContratistasPrograma_ActualizaUltimaModificacion] ON [dbo].[LicLicitacionesContratistasPrograma]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuTiposDocumentos_ActualizaUltimaModificacion] on [dbo].[PuTiposDocumentos]'
GO
CREATE TRIGGER [dbo].[TrPuTiposDocumentos_ActualizaUltimaModificacion]
ON [dbo].[PuTiposDocumentos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuTiposDocumentos_ActualizaUltimaModificacion] ON [dbo].[PuTiposDocumentos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicLicitacionesContratistasProgramaPeriodos_ActualizaUltimaModificacion] on [dbo].[LicLicitacionesContratistasProgramaPeriodos]'
GO
CREATE TRIGGER [dbo].[TrLicLicitacionesContratistasProgramaPeriodos_ActualizaUltimaModificacion]
ON [dbo].[LicLicitacionesContratistasProgramaPeriodos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitacionesContratistasProgramaPeriodos_ActualizaUltimaModificacion] ON [dbo].[LicLicitacionesContratistasProgramaPeriodos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuTiposLicitacion_ActualizaUltimaModificacion] on [dbo].[PuTiposLicitacion]'
GO
CREATE TRIGGER [dbo].[TrPuTiposLicitacion_ActualizaUltimaModificacion]
ON [dbo].[PuTiposLicitacion]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
DISABLE TRIGGER [dbo].[TrPuTiposLicitacion_ActualizaUltimaModificacion] ON [dbo].[PuTiposLicitacion]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicLicitacionesDocumentos_ActualizaUltimaModificacion] on [dbo].[LicLicitacionesDocumentos]'
GO
CREATE TRIGGER [dbo].[TrLicLicitacionesDocumentos_ActualizaUltimaModificacion]
ON [dbo].[LicLicitacionesDocumentos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitacionesDocumentos_ActualizaUltimaModificacion] ON [dbo].[LicLicitacionesDocumentos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuTiposSolicitud_ActualizaUltimaModificacion] on [dbo].[PuTiposSolicitud]'
GO
CREATE TRIGGER [dbo].[TrPuTiposSolicitud_ActualizaUltimaModificacion]
ON [dbo].[PuTiposSolicitud]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuTiposSolicitud_ActualizaUltimaModificacion] ON [dbo].[PuTiposSolicitud]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicLicitacionesFlujo_ActualizaUltimaModificacion] on [dbo].[LicLicitacionesFlujo]'
GO
CREATE TRIGGER [dbo].[TrLicLicitacionesFlujo_ActualizaUltimaModificacion]
ON [dbo].[LicLicitacionesFlujo]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitacionesFlujo_ActualizaUltimaModificacion] ON [dbo].[LicLicitacionesFlujo]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuUnidades_ActualizaUltimaModificacion] on [dbo].[PuUnidades]'
GO
CREATE TRIGGER [dbo].[TrPuUnidades_ActualizaUltimaModificacion]
ON [dbo].[PuUnidades]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuUnidades_ActualizaUltimaModificacion] ON [dbo].[PuUnidades]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicLicitacionesFlujoDet_ActualizaUltimaModificacion] on [dbo].[LicLicitacionesFlujoDet]'
GO
CREATE TRIGGER [dbo].[TrLicLicitacionesFlujoDet_ActualizaUltimaModificacion]
ON [dbo].[LicLicitacionesFlujoDet]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitacionesFlujoDet_ActualizaUltimaModificacion] ON [dbo].[LicLicitacionesFlujoDet]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuUnidadesAcad_ActualizaUltimaModificacion] on [dbo].[PuUnidadesAcad]'
GO
CREATE TRIGGER [dbo].[TrPuUnidadesAcad_ActualizaUltimaModificacion]
ON [dbo].[PuUnidadesAcad]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuUnidadesAcad_ActualizaUltimaModificacion] ON [dbo].[PuUnidadesAcad]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicLicitacionesInsumos_ActualizaUltimaModificacion] on [dbo].[LicLicitacionesInsumos]'
GO
CREATE TRIGGER [dbo].[TrLicLicitacionesInsumos_ActualizaUltimaModificacion]
ON [dbo].[LicLicitacionesInsumos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitacionesInsumos_ActualizaUltimaModificacion] ON [dbo].[LicLicitacionesInsumos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuVendedores_ActualizaUltimaModificacion] on [dbo].[PuVendedores]'
GO
CREATE TRIGGER [dbo].[TrPuVendedores_ActualizaUltimaModificacion]
ON [dbo].[PuVendedores]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
 
DISABLE TRIGGER [dbo].[TrPuVendedores_ActualizaUltimaModificacion] ON [dbo].[PuVendedores]
GO
 
PRINT N'Creating trigger [dbo].[TrLicLicitacionesPartidas_ActualizaUltimaModificacion] on [dbo].[LicLicitacionesPartidas]'
GO
CREATE TRIGGER [dbo].[TrLicLicitacionesPartidas_ActualizaUltimaModificacion]
ON [dbo].[LicLicitacionesPartidas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitacionesPartidas_ActualizaUltimaModificacion] ON [dbo].[LicLicitacionesPartidas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrSegGrupoPermisos_ActualizaUltimaModificacion] on [dbo].[SegGrupoPermisos]'
GO
CREATE TRIGGER [dbo].[TrSegGrupoPermisos_ActualizaUltimaModificacion]
ON [dbo].[SegGrupoPermisos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrSegGrupoPermisos_ActualizaUltimaModificacion] ON [dbo].[SegGrupoPermisos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicLicitacionesPresupuesto_ActualizaUltimaModificacion] on [dbo].[LicLicitacionesPresupuesto]'
GO
CREATE TRIGGER [dbo].[TrLicLicitacionesPresupuesto_ActualizaUltimaModificacion]
ON [dbo].[LicLicitacionesPresupuesto]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicLicitacionesPresupuesto_ActualizaUltimaModificacion] ON [dbo].[LicLicitacionesPresupuesto]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrSegPerfil_ActualizaUltimaModificacion] on [dbo].[SegPerfil]'
GO
CREATE TRIGGER [dbo].[TrSegPerfil_ActualizaUltimaModificacion]
ON [dbo].[SegPerfil]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrSegPerfil_ActualizaUltimaModificacion] ON [dbo].[SegPerfil]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicTiposLicitacion_ActualizaUltimaModificacion] on [dbo].[LicTiposLicitacion]'
GO
CREATE TRIGGER [dbo].[TrLicTiposLicitacion_ActualizaUltimaModificacion]
ON [dbo].[LicTiposLicitacion]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicTiposLicitacion_ActualizaUltimaModificacion] ON [dbo].[LicTiposLicitacion]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrSegPermisos_ActualizaUltimaModificacion] on [dbo].[SegPermisos]'
GO
CREATE TRIGGER [dbo].[TrSegPermisos_ActualizaUltimaModificacion]
ON [dbo].[SegPermisos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrSegPermisos_ActualizaUltimaModificacion] ON [dbo].[SegPermisos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicTiposLicitacionDocumentos_ActualizaUltimaModificacion] on [dbo].[LicTiposLicitacionDocumentos]'
GO
CREATE TRIGGER [dbo].[TrLicTiposLicitacionDocumentos_ActualizaUltimaModificacion]
ON [dbo].[LicTiposLicitacionDocumentos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicTiposLicitacionDocumentos_ActualizaUltimaModificacion] ON [dbo].[LicTiposLicitacionDocumentos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrSegSistemas_ActualizaUltimaModificacion] on [dbo].[SegSistemas]'
GO
CREATE TRIGGER [dbo].[TrSegSistemas_ActualizaUltimaModificacion]
ON [dbo].[SegSistemas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrSegSistemas_ActualizaUltimaModificacion] ON [dbo].[SegSistemas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicTiposLicitacionFlujo_ActualizaUltimaModificacion] on [dbo].[LicTiposLicitacionFlujo]'
GO
CREATE TRIGGER [dbo].[TrLicTiposLicitacionFlujo_ActualizaUltimaModificacion]
ON [dbo].[LicTiposLicitacionFlujo]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicTiposLicitacionFlujo_ActualizaUltimaModificacion] ON [dbo].[LicTiposLicitacionFlujo]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrSegUsuarios_ActualizaUltimaModificacion] on [dbo].[SegUsuarios]'
GO
CREATE TRIGGER [dbo].[TrSegUsuarios_ActualizaUltimaModificacion]
ON [dbo].[SegUsuarios]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
DISABLE TRIGGER [dbo].[TrSegUsuarios_ActualizaUltimaModificacion] ON [dbo].[SegUsuarios]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrLicTiposLicitacionFlujoDet_ActualizaUltimaModificacion] on [dbo].[LicTiposLicitacionFlujoDet]'
GO
CREATE TRIGGER [dbo].[TrLicTiposLicitacionFlujoDet_ActualizaUltimaModificacion]
ON [dbo].[LicTiposLicitacionFlujoDet]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrLicTiposLicitacionFlujoDet_ActualizaUltimaModificacion] ON [dbo].[LicTiposLicitacionFlujoDet]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrSegUsuariosSistemas_ActualizaUltimaModificacion] on [dbo].[SegUsuariosSistemas]'
GO
CREATE TRIGGER [dbo].[TrSegUsuariosSistemas_ActualizaUltimaModificacion]
ON [dbo].[SegUsuariosSistemas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrSegUsuariosSistemas_ActualizaUltimaModificacion] ON [dbo].[SegUsuariosSistemas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCalendarios_ActualizaUltimaModificacion] on [dbo].[PuCalendarios]'
GO
CREATE TRIGGER [dbo].[TrPuCalendarios_ActualizaUltimaModificacion]
ON [dbo].[PuCalendarios]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCalendarios_ActualizaUltimaModificacion] ON [dbo].[PuCalendarios]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrSegUsuariosXProyecto_ActualizaUltimaModificacion] on [dbo].[SegUsuariosXProyecto]'
GO
CREATE TRIGGER [dbo].[TrSegUsuariosXProyecto_ActualizaUltimaModificacion]
ON [dbo].[SegUsuariosXProyecto]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrSegUsuariosXProyecto_ActualizaUltimaModificacion] ON [dbo].[SegUsuariosXProyecto]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCalendariosDet_ActualizaUltimaModificacion] on [dbo].[PuCalendariosDet]'
GO
CREATE TRIGGER [dbo].[TrPuCalendariosDet_ActualizaUltimaModificacion]
ON [dbo].[PuCalendariosDet]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCalendariosDet_ActualizaUltimaModificacion] ON [dbo].[PuCalendariosDet]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCamara_ActualizaUltimaModificacion] on [dbo].[PuCamara]'
GO
CREATE TRIGGER [dbo].[TrPuCamara_ActualizaUltimaModificacion]
ON [dbo].[PuCamara]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCamara_ActualizaUltimaModificacion] ON [dbo].[PuCamara]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCatalogo_ActualizaUltimaModificacion] on [dbo].[PuCatalogo]'
GO
-- =============================================
-- Author:		Victor Solares/Abel Dávalos
-- Create date: 10-Agosto-2017
-- Description:	Actualiza la fecha de ultima modificación en la tabla versión
-- =============================================
CREATE TRIGGER [dbo].[TrPuCatalogo_ActualizaUltimaModificacion]
ON [dbo].[PuCatalogo]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCatalogo_ActualizaUltimaModificacion] ON [dbo].[PuCatalogo]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCatalogoIndices_ActualizaUltimaModificacion] on [dbo].[PuCatalogoIndices]'
GO
CREATE TRIGGER [dbo].[TrPuCatalogoIndices_ActualizaUltimaModificacion]
ON [dbo].[PuCatalogoIndices]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCatalogoIndices_ActualizaUltimaModificacion] ON [dbo].[PuCatalogoIndices]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCatDocumentosContratista_ActualizaUltimaModificacion] on [dbo].[PuCatDocumentosContratista]'
GO
CREATE TRIGGER [dbo].[TrPuCatDocumentosContratista_ActualizaUltimaModificacion]
ON [dbo].[PuCatDocumentosContratista]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCatDocumentosContratista_ActualizaUltimaModificacion] ON [dbo].[PuCatDocumentosContratista]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCatDocumentosContratos_ActualizaUltimaModificacion] on [dbo].[PuCatDocumentosContratos]'
GO
CREATE TRIGGER [dbo].[TrPuCatDocumentosContratos_ActualizaUltimaModificacion]
ON [dbo].[PuCatDocumentosContratos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCatDocumentosContratos_ActualizaUltimaModificacion] ON [dbo].[PuCatDocumentosContratos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCatEspecialidadesContratista_ActualizaUltimaModificacion] on [dbo].[PuCatEspecialidadesContratista]'
GO
CREATE TRIGGER [dbo].[TrPuCatEspecialidadesContratista_ActualizaUltimaModificacion]
ON [dbo].[PuCatEspecialidadesContratista]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCatEspecialidadesContratista_ActualizaUltimaModificacion] ON [dbo].[PuCatEspecialidadesContratista]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCatMaquinariaContratista_ActualizaUltimaModificacion] on [dbo].[PuCatMaquinariaContratista]'
GO
CREATE TRIGGER [dbo].[TrPuCatMaquinariaContratista_ActualizaUltimaModificacion]
ON [dbo].[PuCatMaquinariaContratista]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCatMaquinariaContratista_ActualizaUltimaModificacion] ON [dbo].[PuCatMaquinariaContratista]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCentros_ActualizaUltimaModificacion] on [dbo].[PuCentros]'
GO
CREATE TRIGGER [dbo].[TrPuCentros_ActualizaUltimaModificacion]
ON [dbo].[PuCentros]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCentros_ActualizaUltimaModificacion] ON [dbo].[PuCentros]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating trigger [dbo].[TrPuCiudades_ActualizaUltimaModificacion] on [dbo].[PuCiudades]'
GO
-- =============================================
-- Author:		Victor Solares/Abel Dávalos
-- Create date: 10-Agosto-2017
-- Description:	Actualiza la fecha de ultima modificación en la tabla versión
-- =============================================
CREATE TRIGGER [dbo].[TrPuCiudades_ActualizaUltimaModificacion]
ON [dbo].[PuCiudades]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCiudades_ActualizaUltimaModificacion] ON [dbo].[PuCiudades]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuClientes_ActualizaUltimaModificacion] on [dbo].[PuClientes]'
GO
-- =============================================
-- Author:		Victor Solares/Abel Dávalos
-- Create date: 10-Agosto-2017
-- Description:	Actualiza la fecha de ultima modificación en la tabla versión
-- =============================================
CREATE TRIGGER [dbo].[TrPuClientes_ActualizaUltimaModificacion]
ON [dbo].[PuClientes]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuClientes_ActualizaUltimaModificacion] ON [dbo].[PuClientes]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuClientesContactos_ActualizaUltimaModificacion] on [dbo].[PuClientesContactos]'
GO
-- =============================================
-- Author:		Victor Solares/Abel Dávalos
-- Create date: 15-Agosto-2017
-- Description:	Actualiza la fecha de ultima modificación en la tabla versión
-- =============================================
CREATE TRIGGER [dbo].[TrPuClientesContactos_ActualizaUltimaModificacion]
ON [dbo].[PuClientesContactos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuClientesContactos_ActualizaUltimaModificacion] ON [dbo].[PuClientesContactos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratantesConsecutivos_ActualizaUltimaModificacion] on [dbo].[PuContratantesConsecutivos]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratantesConsecutivos_ActualizaUltimaModificacion]
ON [dbo].[PuContratantesConsecutivos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratantesConsecutivos_ActualizaUltimaModificacion] ON [dbo].[PuContratantesConsecutivos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratistaMaquinaria_ActualizaUltimaModificacion] on [dbo].[PuContratistaMaquinaria]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratistaMaquinaria_ActualizaUltimaModificacion]
ON [dbo].[PuContratistaMaquinaria]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratistaMaquinaria_ActualizaUltimaModificacion] ON [dbo].[PuContratistaMaquinaria]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratistas_ActualizaUltimaModificacion] on [dbo].[PuContratistas]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratistas_ActualizaUltimaModificacion]
ON [dbo].[PuContratistas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratistas_ActualizaUltimaModificacion] ON [dbo].[PuContratistas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratistasActividades_ActualizaUltimaModificacion] on [dbo].[PuContratistasActividades]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratistasActividades_ActualizaUltimaModificacion]
ON [dbo].[PuContratistasActividades]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratistasActividades_ActualizaUltimaModificacion] ON [dbo].[PuContratistasActividades]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratistasDocumentos_ActualizaUltimaModificacion] on [dbo].[PuContratistasDocumentos]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratistasDocumentos_ActualizaUltimaModificacion]
ON [dbo].[PuContratistasDocumentos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratistasDocumentos_ActualizaUltimaModificacion] ON [dbo].[PuContratistasDocumentos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratistasEspecialidades_ActualizaUltimaModificacion] on [dbo].[PuContratistasEspecialidades]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratistasEspecialidades_ActualizaUltimaModificacion]
ON [dbo].[PuContratistasEspecialidades]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratistasEspecialidades_ActualizaUltimaModificacion] ON [dbo].[PuContratistasEspecialidades]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating trigger [dbo].[TrPuContratistasRefrendos_ActualizaUltimaModificacion] on [dbo].[PuContratistasRefrendos]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratistasRefrendos_ActualizaUltimaModificacion]
ON [dbo].[PuContratistasRefrendos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratistasRefrendos_ActualizaUltimaModificacion] ON [dbo].[PuContratistasRefrendos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratistasRepresentantesL_ActualizaUltimaModificacion] on [dbo].[PuContratistasRepresentantesL]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratistasRepresentantesL_ActualizaUltimaModificacion]
ON [dbo].[PuContratistasRepresentantesL]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratistasRepresentantesL_ActualizaUltimaModificacion] ON [dbo].[PuContratistasRepresentantesL]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratos_ActualizaUltimaModificacion] on [dbo].[PuContratos]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratos_ActualizaUltimaModificacion]
ON [dbo].[PuContratos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratos_ActualizaUltimaModificacion] ON [dbo].[PuContratos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratosConsecutivos_ActualizaUltimaModificacion] on [dbo].[PuContratosConsecutivos]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratosConsecutivos_ActualizaUltimaModificacion]
ON [dbo].[PuContratosConsecutivos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratosConsecutivos_ActualizaUltimaModificacion] ON [dbo].[PuContratosConsecutivos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratosDeducciones_ActualizaUltimaModificacion] on [dbo].[PuContratosDeducciones]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratosDeducciones_ActualizaUltimaModificacion]
ON [dbo].[PuContratosDeducciones]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratosDeducciones_ActualizaUltimaModificacion] ON [dbo].[PuContratosDeducciones]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratosDet_ActualizaUltimaModificacion] on [dbo].[PuContratosDet]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratosDet_ActualizaUltimaModificacion]
ON [dbo].[PuContratosDet]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratosDet_ActualizaUltimaModificacion] ON [dbo].[PuContratosDet]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratosDocumentos_ActualizaUltimaModificacion] on [dbo].[PuContratosDocumentos]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratosDocumentos_ActualizaUltimaModificacion]
ON [dbo].[PuContratosDocumentos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratosDocumentos_ActualizaUltimaModificacion] ON [dbo].[PuContratosDocumentos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratosFacturas_ActualizaUltimaModificacion] on [dbo].[PuContratosFacturas]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratosFacturas_ActualizaUltimaModificacion]
ON [dbo].[PuContratosFacturas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratosFacturas_ActualizaUltimaModificacion] ON [dbo].[PuContratosFacturas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratosMonedas_ActualizaUltimaModificacion] on [dbo].[PuContratosMonedas]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratosMonedas_ActualizaUltimaModificacion]
ON [dbo].[PuContratosMonedas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratosMonedas_ActualizaUltimaModificacion] ON [dbo].[PuContratosMonedas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContratosPlantillas_ActualizaUltimaModificacion] on [dbo].[PuContratosPlantillas]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContratosPlantillas_ActualizaUltimaModificacion]
ON [dbo].[PuContratosPlantillas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContratosPlantillas_ActualizaUltimaModificacion] ON [dbo].[PuContratosPlantillas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuContribuyente_ActualizaUltimaModificacion] on [dbo].[PuContribuyente]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuContribuyente_ActualizaUltimaModificacion]
ON [dbo].[PuContribuyente]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuContribuyente_ActualizaUltimaModificacion] ON [dbo].[PuContribuyente]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuConversionesAcad_ActualizaUltimaModificacion] on [dbo].[PuConversionesAcad]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuConversionesAcad_ActualizaUltimaModificacion]
ON [dbo].[PuConversionesAcad]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuConversionesAcad_ActualizaUltimaModificacion] ON [dbo].[PuConversionesAcad]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCostosHorarios_ActualizaUltimaModificacion] on [dbo].[PuCostosHorarios]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuCostosHorarios_ActualizaUltimaModificacion]
ON [dbo].[PuCostosHorarios]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCostosHorarios_ActualizaUltimaModificacion] ON [dbo].[PuCostosHorarios]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCostosHorariosMO_ActualizaUltimaModificacion] on [dbo].[PuCostosHorariosMO]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuCostosHorariosMO_ActualizaUltimaModificacion]
ON [dbo].[PuCostosHorariosMO]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCostosHorariosMO_ActualizaUltimaModificacion] ON [dbo].[PuCostosHorariosMO]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCostosHorariosOC_ActualizaUltimaModificacion] on [dbo].[PuCostosHorariosOC]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuCostosHorariosOC_ActualizaUltimaModificacion]
ON [dbo].[PuCostosHorariosOC]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCostosHorariosOC_ActualizaUltimaModificacion] ON [dbo].[PuCostosHorariosOC]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCostosHorariosTI_ActualizaUltimaModificacion] on [dbo].[PuCostosHorariosTI]'
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TrPuCostosHorariosTI_ActualizaUltimaModificacion]
ON [dbo].[PuCostosHorariosTI]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCostosHorariosTI_ActualizaUltimaModificacion] ON [dbo].[PuCostosHorariosTI]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCostosXCiudad_ActualizaUltimaModificacion] on [dbo].[PuCostosXCiudad]'
GO
CREATE TRIGGER [dbo].[TrPuCostosXCiudad_ActualizaUltimaModificacion]
ON [dbo].[PuCostosXCiudad]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCostosXCiudad_ActualizaUltimaModificacion] ON [dbo].[PuCostosXCiudad]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCotizaciones_ActualizaUltimaModificacion] on [dbo].[PuCotizaciones]'
GO
CREATE TRIGGER [dbo].[TrPuCotizaciones_ActualizaUltimaModificacion]
ON [dbo].[PuCotizaciones]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCotizaciones_ActualizaUltimaModificacion] ON [dbo].[PuCotizaciones]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCotizacionesBitacora_ActualizaUltimaModificacion] on [dbo].[PuCotizacionesBitacora]'
GO
CREATE TRIGGER [dbo].[TrPuCotizacionesBitacora_ActualizaUltimaModificacion]
ON [dbo].[PuCotizacionesBitacora]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCotizacionesBitacora_ActualizaUltimaModificacion] ON [dbo].[PuCotizacionesBitacora]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuCuotasVigentesImss_ActualizaUltimaModificacion] on [dbo].[PuCuotasVigentesImss]'
GO
CREATE TRIGGER [dbo].[TrPuCuotasVigentesImss_ActualizaUltimaModificacion]
ON [dbo].[PuCuotasVigentesImss]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuCuotasVigentesImss_ActualizaUltimaModificacion] ON [dbo].[PuCuotasVigentesImss]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuDeducciones_ActualizaUltimaModificacion] on [dbo].[PuDeducciones]'
GO
CREATE TRIGGER [dbo].[TrPuDeducciones_ActualizaUltimaModificacion]
ON [dbo].[PuDeducciones]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuDeducciones_ActualizaUltimaModificacion] ON [dbo].[PuDeducciones]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuDocumentos_ActualizaUltimaModificacion] on [dbo].[PuDocumentos]'
GO
CREATE TRIGGER [dbo].[TrPuDocumentos_ActualizaUltimaModificacion]
ON [dbo].[PuDocumentos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuDocumentos_ActualizaUltimaModificacion] ON [dbo].[PuDocumentos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuEmpresaAfianzadora_ActualizaUltimaModificacion] on [dbo].[PuEmpresaAfianzadora]'
GO
CREATE TRIGGER [dbo].[TrPuEmpresaAfianzadora_ActualizaUltimaModificacion]
ON [dbo].[PuEmpresaAfianzadora]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuEmpresaAfianzadora_ActualizaUltimaModificacion] ON [dbo].[PuEmpresaAfianzadora]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuEmpresas_ActualizaUltimaModificacion] on [dbo].[PuEmpresas]'
GO
CREATE TRIGGER [dbo].[TrPuEmpresas_ActualizaUltimaModificacion]
ON [dbo].[PuEmpresas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuEmpresas_ActualizaUltimaModificacion] ON [dbo].[PuEmpresas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuEstados_ActualizaUltimaModificacion] on [dbo].[PuEstados]'
GO
CREATE TRIGGER [dbo].[TrPuEstados_ActualizaUltimaModificacion]
ON [dbo].[PuEstados]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuEstados_ActualizaUltimaModificacion] ON [dbo].[PuEstados]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuEstatusSolicitud_ActualizaUltimaModificacion] on [dbo].[PuEstatusSolicitud]'
GO
CREATE TRIGGER [dbo].[TrPuEstatusSolicitud_ActualizaUltimaModificacion]
ON [dbo].[PuEstatusSolicitud]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuEstatusSolicitud_ActualizaUltimaModificacion] ON [dbo].[PuEstatusSolicitud]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuEstimaciones_ActualizaUltimaModificacion] on [dbo].[PuEstimaciones]'
GO
CREATE TRIGGER [dbo].[TrPuEstimaciones_ActualizaUltimaModificacion]
ON [dbo].[PuEstimaciones]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuEstimaciones_ActualizaUltimaModificacion] ON [dbo].[PuEstimaciones]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuEstimacionesDeducciones_ActualizaUltimaModificacion] on [dbo].[PuEstimacionesDeducciones]'
GO
CREATE TRIGGER [dbo].[TrPuEstimacionesDeducciones_ActualizaUltimaModificacion]
ON [dbo].[PuEstimacionesDeducciones]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuEstimacionesDeducciones_ActualizaUltimaModificacion] ON [dbo].[PuEstimacionesDeducciones]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuEstimacionesDet_ActualizaUltimaModificacion] on [dbo].[PuEstimacionesDet]'
GO
CREATE TRIGGER [dbo].[TrPuEstimacionesDet_ActualizaUltimaModificacion]
ON [dbo].[PuEstimacionesDet]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuEstimacionesDet_ActualizaUltimaModificacion] ON [dbo].[PuEstimacionesDet]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuEstimacionesEstatusHistorico_ActualizaUltimaModificacion] on [dbo].[PuEstimacionesEstatusHistorico]'
GO
CREATE TRIGGER [dbo].[TrPuEstimacionesEstatusHistorico_ActualizaUltimaModificacion]
ON [dbo].[PuEstimacionesEstatusHistorico]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuEstimacionesEstatusHistorico_ActualizaUltimaModificacion] ON [dbo].[PuEstimacionesEstatusHistorico]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuEstimacionesTipos_ActualizaUltimaModificacion] on [dbo].[PuEstimacionesTipos]'
GO
CREATE TRIGGER [dbo].[TrPuEstimacionesTipos_ActualizaUltimaModificacion]
ON [dbo].[PuEstimacionesTipos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuEstimacionesTipos_ActualizaUltimaModificacion] ON [dbo].[PuEstimacionesTipos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuExpIns_ActualizaUltimaModificacion] on [dbo].[PuExpIns]'
GO
CREATE TRIGGER [dbo].[TrPuExpIns_ActualizaUltimaModificacion]
ON [dbo].[PuExpIns]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuExpIns_ActualizaUltimaModificacion] ON [dbo].[PuExpIns]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuExpInsCostos_ActualizaUltimaModificacion] on [dbo].[PuExpInsCostos]'
GO
CREATE TRIGGER [dbo].[TrPuExpInsCostos_ActualizaUltimaModificacion]
ON [dbo].[PuExpInsCostos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuExpInsCostos_ActualizaUltimaModificacion] ON [dbo].[PuExpInsCostos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuExpInsCostosBitacora_ActualizaUltimaModificacion] on [dbo].[PuExpInsCostosBitacora]'
GO
CREATE TRIGGER [dbo].[TrPuExpInsCostosBitacora_ActualizaUltimaModificacion]
ON [dbo].[PuExpInsCostosBitacora]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuExpInsCostosBitacora_ActualizaUltimaModificacion] ON [dbo].[PuExpInsCostosBitacora]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuExpinsCostosEQ_ActualizaUltimaModificacion] on [dbo].[PuExpinsCostosEQ]'
GO
CREATE TRIGGER [dbo].[TrPuExpinsCostosEQ_ActualizaUltimaModificacion]
ON [dbo].[PuExpinsCostosEQ]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuExpinsCostosEQ_ActualizaUltimaModificacion] ON [dbo].[PuExpinsCostosEQ]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuExpInsCostosOP_ActualizaUltimaModificacion] on [dbo].[PuExpInsCostosOP]'
GO
CREATE TRIGGER [dbo].[TrPuExpInsCostosOP_ActualizaUltimaModificacion]
ON [dbo].[PuExpInsCostosOP]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuExpInsCostosOP_ActualizaUltimaModificacion] ON [dbo].[PuExpInsCostosOP]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuExpInsDestajos_ActualizaUltimaModificacion] on [dbo].[PuExpInsDestajos]'
GO
CREATE TRIGGER [dbo].[TrPuExpInsDestajos_ActualizaUltimaModificacion]
ON [dbo].[PuExpInsDestajos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuExpInsDestajos_ActualizaUltimaModificacion] ON [dbo].[PuExpInsDestajos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuExpInsIntelimat_ActualizaUltimaModificacion] on [dbo].[PuExpInsIntelimat]'
GO
CREATE TRIGGER [dbo].[TrPuExpInsIntelimat_ActualizaUltimaModificacion]
ON [dbo].[PuExpInsIntelimat]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuExpInsIntelimat_ActualizaUltimaModificacion] ON [dbo].[PuExpInsIntelimat]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating trigger [dbo].[TrPuExpInsMO_ActualizaUltimaModificacion] on [dbo].[PuExpInsMO]'
GO
CREATE TRIGGER [dbo].[TrPuExpInsMO_ActualizaUltimaModificacion]
ON [dbo].[PuExpInsMO]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuExpInsMO_ActualizaUltimaModificacion] ON [dbo].[PuExpInsMO]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuExpinsPar_ActualizaUltimaModificacion] on [dbo].[PuExpinsPar]'
GO
CREATE TRIGGER [dbo].[TrPuExpinsPar_ActualizaUltimaModificacion]
ON [dbo].[PuExpinsPar]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuExpinsPar_ActualizaUltimaModificacion] ON [dbo].[PuExpinsPar]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuExpinsXconcepto_ActualizaUltimaModificacion] on [dbo].[PuExpinsXconcepto]'
GO
CREATE TRIGGER [dbo].[TrPuExpinsXconcepto_ActualizaUltimaModificacion]
ON [dbo].[PuExpinsXconcepto]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuExpinsXconcepto_ActualizaUltimaModificacion] ON [dbo].[PuExpinsXconcepto]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuFamilias_ActualizaUltimaModificacion] on [dbo].[PuFamilias]'
GO
CREATE TRIGGER [dbo].[TrPuFamilias_ActualizaUltimaModificacion]
ON [dbo].[PuFamilias]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuFamilias_ActualizaUltimaModificacion] ON [dbo].[PuFamilias]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuFamiliasIndices_ActualizaUltimaModificacion] on [dbo].[PuFamiliasIndices]'
GO
CREATE TRIGGER [dbo].[TrPuFamiliasIndices_ActualizaUltimaModificacion]
ON [dbo].[PuFamiliasIndices]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuFamiliasIndices_ActualizaUltimaModificacion] ON [dbo].[PuFamiliasIndices]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuFichasTecnicas_ActualizaUltimaModificacion] on [dbo].[PuFichasTecnicas]'
GO
CREATE TRIGGER [dbo].[TrPuFichasTecnicas_ActualizaUltimaModificacion]
ON [dbo].[PuFichasTecnicas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuFichasTecnicas_ActualizaUltimaModificacion] ON [dbo].[PuFichasTecnicas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuGeneradores_ActualizaUltimaModificacion] on [dbo].[PuGeneradores]'
GO
CREATE TRIGGER [dbo].[TrPuGeneradores_ActualizaUltimaModificacion]
ON [dbo].[PuGeneradores]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuGeneradores_ActualizaUltimaModificacion] ON [dbo].[PuGeneradores]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuGeneradoresDet_ActualizaUltimaModificacion] on [dbo].[PuGeneradoresDet]'
GO
CREATE TRIGGER [dbo].[TrPuGeneradoresDet_ActualizaUltimaModificacion]
ON [dbo].[PuGeneradoresDet]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuGeneradoresDet_ActualizaUltimaModificacion] ON [dbo].[PuGeneradoresDet]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuGeneradoresDocumentos_ActualizaUltimaModificacion] on [dbo].[PuGeneradoresDocumentos]'
GO
CREATE TRIGGER [dbo].[TrPuGeneradoresDocumentos_ActualizaUltimaModificacion]
ON [dbo].[PuGeneradoresDocumentos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuGeneradoresDocumentos_ActualizaUltimaModificacion] ON [dbo].[PuGeneradoresDocumentos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuGeneradoresEstatusHistorico_ActualizaUltimaModificacion] on [dbo].[PuGeneradoresEstatusHistorico]'
GO
CREATE TRIGGER [dbo].[TrPuGeneradoresEstatusHistorico_ActualizaUltimaModificacion]
ON [dbo].[PuGeneradoresEstatusHistorico]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuGeneradoresEstatusHistorico_ActualizaUltimaModificacion] ON [dbo].[PuGeneradoresEstatusHistorico]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuGeneradoresIC_ActualizaUltimaModificacion] on [dbo].[PuGeneradoresIC]'
GO
CREATE TRIGGER [dbo].[TrPuGeneradoresIC_ActualizaUltimaModificacion]
ON [dbo].[PuGeneradoresIC]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuGeneradoresIC_ActualizaUltimaModificacion] ON [dbo].[PuGeneradoresIC]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuImagenes_ActualizaUltimaModificacion] on [dbo].[PuImagenes]'
GO
CREATE TRIGGER [dbo].[TrPuImagenes_ActualizaUltimaModificacion]
ON [dbo].[PuImagenes]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuImagenes_ActualizaUltimaModificacion] ON [dbo].[PuImagenes]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuIndices_ActualizaUltimaModificacion] on [dbo].[PuIndices]'
GO
CREATE TRIGGER [dbo].[TrPuIndices_ActualizaUltimaModificacion]
ON [dbo].[PuIndices]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuIndices_ActualizaUltimaModificacion] ON [dbo].[PuIndices]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuIndicesDet_ActualizaUltimaModificacion] on [dbo].[PuIndicesDet]'
GO
CREATE TRIGGER [dbo].[TrPuIndicesDet_ActualizaUltimaModificacion]
ON [dbo].[PuIndicesDet]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuIndicesDet_ActualizaUltimaModificacion] ON [dbo].[PuIndicesDet]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuIntelimat_ActualizaUltimaModificacion] on [dbo].[PuIntelimat]'
GO
CREATE TRIGGER [dbo].[TrPuIntelimat_ActualizaUltimaModificacion]
ON [dbo].[PuIntelimat]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuIntelimat_ActualizaUltimaModificacion] ON [dbo].[PuIntelimat]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuInteliPres_ActualizaUltimaModificacion] on [dbo].[PuInteliPres]'
GO
CREATE TRIGGER [dbo].[TrPuInteliPres_ActualizaUltimaModificacion]
ON [dbo].[PuInteliPres]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuInteliPres_ActualizaUltimaModificacion] ON [dbo].[PuInteliPres]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuLigasRuta_ActualizaUltimaModificacion] on [dbo].[PuLigasRuta]'
GO
CREATE TRIGGER [dbo].[TrPuLigasRuta_ActualizaUltimaModificacion]
ON [dbo].[PuLigasRuta]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuLigasRuta_ActualizaUltimaModificacion] ON [dbo].[PuLigasRuta]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuMatrices_ActualizaUltimaModificacion] on [dbo].[PuMatrices]'
GO
CREATE TRIGGER [dbo].[TrPuMatrices_ActualizaUltimaModificacion]
ON [dbo].[PuMatrices]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuMatrices_ActualizaUltimaModificacion] ON [dbo].[PuMatrices]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuMonedas_ActualizaUltimaModificacion] on [dbo].[PuMonedas]'
GO
CREATE TRIGGER [dbo].[TrPuMonedas_ActualizaUltimaModificacion]
ON [dbo].[PuMonedas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuMonedas_ActualizaUltimaModificacion] ON [dbo].[PuMonedas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuMonedasCalculadas_ActualizaUltimaModificacion] on [dbo].[PuMonedasCalculadas]'
GO
CREATE TRIGGER [dbo].[TrPuMonedasCalculadas_ActualizaUltimaModificacion]
ON [dbo].[PuMonedasCalculadas]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuMonedasCalculadas_ActualizaUltimaModificacion] ON [dbo].[PuMonedasCalculadas]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating trigger [dbo].[TrPuMovimientos_ActualizaUltimaModificacion] on [dbo].[PuMovimientos]'
GO
CREATE TRIGGER [dbo].[TrPuMovimientos_ActualizaUltimaModificacion]
ON [dbo].[PuMovimientos]
AFTER INSERT, UPDATE, DELETE
AS
BEGIN
exec Neo_ActualizaUltimaModificacion
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
DISABLE TRIGGER [dbo].[TrPuMovimientos_ActualizaUltimaModificacion] ON [dbo].[PuMovimientos]
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 
PRINT N'Creating [dbo].[Neo_ActivaActualizaUltimaModificacion]'
GO
-- =============================================
-- Author:		Victor Solares/Abel Dávalos
-- Create date: 11-Agosto-2017
-- Description:	Actualiza la fecha de ultima modificación en la tabla versión
-- =============================================
CREATE PROCEDURE [dbo].[Neo_ActivaActualizaUltimaModificacion]
-- Add the parameters for the stored procedure here
AS
BEGIN
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON;
-- Insert statements for procedure here
ENABLE TRIGGER TrBiCatProcesos_ActualizaUltimaModificacion ON BiCatProcesos;
ENABLE TRIGGER TrBiCatSistemas_ActualizaUltimaModificacion ON BiCatSistemas;
ENABLE TRIGGER TrBitacora_ActualizaUltimaModificacion ON Bitacora;
ENABLE TRIGGER TrLicLicitaciones_ActualizaUltimaModificacion ON LicLicitaciones;
ENABLE TRIGGER TrLicLicitacionesContratistas_ActualizaUltimaModificacion ON LicLicitacionesContratistas;
ENABLE TRIGGER TrLicLicitacionesContratistasCuadro_ActualizaUltimaModificacion ON LicLicitacionesContratistasCuadro;
ENABLE TRIGGER TrLicLicitacionesContratistasDocumentos_ActualizaUltimaModificacion ON LicLicitacionesContratistasDocumentos;
ENABLE TRIGGER TrLicLicitacionesContratistasInsumos_ActualizaUltimaModificacion ON LicLicitacionesContratistasInsumos;
ENABLE TRIGGER TrLicLicitacionesContratistasPeriodos_ActualizaUltimaModificacion ON LicLicitacionesContratistasPeriodos;
ENABLE TRIGGER TrLicLicitacionesContratistasPrograma_ActualizaUltimaModificacion ON LicLicitacionesContratistasPrograma;
ENABLE TRIGGER TrLicLicitacionesContratistasProgramaPeriodos_ActualizaUltimaModificacion ON LicLicitacionesContratistasProgramaPeriodos;
ENABLE TRIGGER TrLicLicitacionesDocumentos_ActualizaUltimaModificacion ON LicLicitacionesDocumentos;
ENABLE TRIGGER TrLicLicitacionesFlujo_ActualizaUltimaModificacion ON LicLicitacionesFlujo;
ENABLE TRIGGER TrLicLicitacionesFlujoDet_ActualizaUltimaModificacion ON LicLicitacionesFlujoDet;
ENABLE TRIGGER TrLicLicitacionesInsumos_ActualizaUltimaModificacion ON LicLicitacionesInsumos;
ENABLE TRIGGER TrLicLicitacionesPartidas_ActualizaUltimaModificacion ON LicLicitacionesPartidas;
ENABLE TRIGGER TrLicLicitacionesPresupuesto_ActualizaUltimaModificacion ON LicLicitacionesPresupuesto;
ENABLE TRIGGER TrLicTiposLicitacion_ActualizaUltimaModificacion ON LicTiposLicitacion;
ENABLE TRIGGER TrLicTiposLicitacionDocumentos_ActualizaUltimaModificacion ON LicTiposLicitacionDocumentos;
ENABLE TRIGGER TrLicTiposLicitacionFlujo_ActualizaUltimaModificacion ON LicTiposLicitacionFlujo;
ENABLE TRIGGER TrLicTiposLicitacionFlujoDet_ActualizaUltimaModificacion ON LicTiposLicitacionFlujoDet;
ENABLE TRIGGER TrPuCalendarios_ActualizaUltimaModificacion ON PuCalendarios;
ENABLE TRIGGER TrPuCalendariosDet_ActualizaUltimaModificacion ON PuCalendariosDet;
ENABLE TRIGGER TrPuCamara_ActualizaUltimaModificacion ON PuCamara;
ENABLE TRIGGER TrPuCatalogo_ActualizaUltimaModificacion ON PuCatalogo;
ENABLE TRIGGER TrPuCatalogoIndices_ActualizaUltimaModificacion ON PuCatalogoIndices;
ENABLE TRIGGER TrPuCatDocumentosContratista_ActualizaUltimaModificacion ON PuCatDocumentosContratista;
ENABLE TRIGGER TrPuCatDocumentosContratos_ActualizaUltimaModificacion ON PuCatDocumentosContratos;
ENABLE TRIGGER TrPuCatEspecialidadesContratista_ActualizaUltimaModificacion ON PuCatEspecialidadesContratista;
ENABLE TRIGGER TrPuCatMaquinariaContratista_ActualizaUltimaModificacion ON PuCatMaquinariaContratista;
ENABLE TRIGGER TrPuCentros_ActualizaUltimaModificacion ON PuCentros;
ENABLE TRIGGER TrPuCiudades_ActualizaUltimaModificacion ON PuCiudades;
ENABLE TRIGGER TrPuClientes_ActualizaUltimaModificacion ON PuClientes;
ENABLE TRIGGER TrPuClientesContactos_ActualizaUltimaModificacion ON PuClientesContactos;
ENABLE TRIGGER TrPuContratantesConsecutivos_ActualizaUltimaModificacion ON PuContratantesConsecutivos;
ENABLE TRIGGER TrPuContratistaMaquinaria_ActualizaUltimaModificacion ON PuContratistaMaquinaria;
ENABLE TRIGGER TrPuContratistas_ActualizaUltimaModificacion ON PuContratistas;
ENABLE TRIGGER TrPuContratistasActividades_ActualizaUltimaModificacion ON PuContratistasActividades;
ENABLE TRIGGER TrPuContratistasDocumentos_ActualizaUltimaModificacion ON PuContratistasDocumentos;
ENABLE TRIGGER TrPuContratistasEspecialidades_ActualizaUltimaModificacion ON PuContratistasEspecialidades;
ENABLE TRIGGER TrPuContratistasRefrendos_ActualizaUltimaModificacion ON PuContratistasRefrendos;
ENABLE TRIGGER TrPuContratistasRepresentantesL_ActualizaUltimaModificacion ON PuContratistasRepresentantesL;
ENABLE TRIGGER TrPuContratos_ActualizaUltimaModificacion ON PuContratos;
ENABLE TRIGGER TrPuContratosConsecutivos_ActualizaUltimaModificacion ON PuContratosConsecutivos;
ENABLE TRIGGER TrPuContratosDeducciones_ActualizaUltimaModificacion ON PuContratosDeducciones;
ENABLE TRIGGER TrPuContratosDet_ActualizaUltimaModificacion ON PuContratosDet;
ENABLE TRIGGER TrPuContratosDocumentos_ActualizaUltimaModificacion ON PuContratosDocumentos;
ENABLE TRIGGER TrPuContratosFacturas_ActualizaUltimaModificacion ON PuContratosFacturas;
ENABLE TRIGGER TrPuContratosMonedas_ActualizaUltimaModificacion ON PuContratosMonedas;
ENABLE TRIGGER TrPuContratosPlantillas_ActualizaUltimaModificacion ON PuContratosPlantillas;
ENABLE TRIGGER TrPuContribuyente_ActualizaUltimaModificacion ON PuContribuyente;
ENABLE TRIGGER TrPuConversionesAcad_ActualizaUltimaModificacion ON PuConversionesAcad;
ENABLE TRIGGER TrPuCostosHorarios_ActualizaUltimaModificacion ON PuCostosHorarios;
ENABLE TRIGGER TrPuCostosHorariosMO_ActualizaUltimaModificacion ON PuCostosHorariosMO;
ENABLE TRIGGER TrPuCostosHorariosOC_ActualizaUltimaModificacion ON PuCostosHorariosOC;
ENABLE TRIGGER TrPuCostosHorariosTI_ActualizaUltimaModificacion ON PuCostosHorariosTI;
ENABLE TRIGGER TrPuCostosXCiudad_ActualizaUltimaModificacion ON PuCostosXCiudad;
ENABLE TRIGGER TrPuCotizaciones_ActualizaUltimaModificacion ON PuCotizaciones;
ENABLE TRIGGER TrPuCotizacionesBitacora_ActualizaUltimaModificacion ON PuCotizacionesBitacora;
ENABLE TRIGGER TrPuCuotasVigentesImss_ActualizaUltimaModificacion ON PuCuotasVigentesImss;
ENABLE TRIGGER TrPuDeducciones_ActualizaUltimaModificacion ON PuDeducciones;
ENABLE TRIGGER TrPuDocumentos_ActualizaUltimaModificacion ON PuDocumentos;
ENABLE TRIGGER TrPuEmpresaAfianzadora_ActualizaUltimaModificacion ON PuEmpresaAfianzadora;
ENABLE TRIGGER TrPuEmpresas_ActualizaUltimaModificacion ON PuEmpresas;
ENABLE TRIGGER TrPuEstados_ActualizaUltimaModificacion ON PuEstados;
ENABLE TRIGGER TrPuEstatusSolicitud_ActualizaUltimaModificacion ON PuEstatusSolicitud;
ENABLE TRIGGER TrPuEstimaciones_ActualizaUltimaModificacion ON PuEstimaciones;
ENABLE TRIGGER TrPuEstimacionesDeducciones_ActualizaUltimaModificacion ON PuEstimacionesDeducciones;
ENABLE TRIGGER TrPuEstimacionesDet_ActualizaUltimaModificacion ON PuEstimacionesDet;
ENABLE TRIGGER TrPuEstimacionesEstatusHistorico_ActualizaUltimaModificacion ON PuEstimacionesEstatusHistorico;
ENABLE TRIGGER TrPuEstimacionesTipos_ActualizaUltimaModificacion ON PuEstimacionesTipos;
ENABLE TRIGGER TrPuExpIns_ActualizaUltimaModificacion ON PuExpIns;
ENABLE TRIGGER TrPuExpInsCostos_ActualizaUltimaModificacion ON PuExpInsCostos;
ENABLE TRIGGER TrPuExpInsCostosBitacora_ActualizaUltimaModificacion ON PuExpInsCostosBitacora;
ENABLE TRIGGER TrPuExpinsCostosEQ_ActualizaUltimaModificacion ON PuExpinsCostosEQ;
ENABLE TRIGGER TrPuExpInsCostosOP_ActualizaUltimaModificacion ON PuExpInsCostosOP;
ENABLE TRIGGER TrPuExpInsDestajos_ActualizaUltimaModificacion ON PuExpInsDestajos;
ENABLE TRIGGER TrPuExpInsIntelimat_ActualizaUltimaModificacion ON PuExpInsIntelimat;
ENABLE TRIGGER TrPuExpInsMO_ActualizaUltimaModificacion ON PuExpInsMO;
ENABLE TRIGGER TrPuExpinsPar_ActualizaUltimaModificacion ON PuExpinsPar;
ENABLE TRIGGER TrPuExpinsXconcepto_ActualizaUltimaModificacion ON PuExpinsXconcepto;
ENABLE TRIGGER TrPuFamilias_ActualizaUltimaModificacion ON PuFamilias;
ENABLE TRIGGER TrPuFamiliasIndices_ActualizaUltimaModificacion ON PuFamiliasIndices;
ENABLE TRIGGER TrPuFichasTecnicas_ActualizaUltimaModificacion ON PuFichasTecnicas;
ENABLE TRIGGER TrPuGeneradores_ActualizaUltimaModificacion ON PuGeneradores;
ENABLE TRIGGER TrPuGeneradoresDet_ActualizaUltimaModificacion ON PuGeneradoresDet;
ENABLE TRIGGER TrPuGeneradoresDocumentos_ActualizaUltimaModificacion ON PuGeneradoresDocumentos;
ENABLE TRIGGER TrPuGeneradoresEstatusHistorico_ActualizaUltimaModificacion ON PuGeneradoresEstatusHistorico;
ENABLE TRIGGER TrPuGeneradoresIC_ActualizaUltimaModificacion ON PuGeneradoresIC;
ENABLE TRIGGER TrPuImagenes_ActualizaUltimaModificacion ON PuImagenes;
ENABLE TRIGGER TrPuIndices_ActualizaUltimaModificacion ON PuIndices;
ENABLE TRIGGER TrPuIndicesDet_ActualizaUltimaModificacion ON PuIndicesDet;
ENABLE TRIGGER TrPuIntelimat_ActualizaUltimaModificacion ON PuIntelimat;
ENABLE TRIGGER TrPuInteliPres_ActualizaUltimaModificacion ON PuInteliPres;
ENABLE TRIGGER TrPuLigasRuta_ActualizaUltimaModificacion ON PuLigasRuta;
ENABLE TRIGGER TrPuMatrices_ActualizaUltimaModificacion ON PuMatrices;
ENABLE TRIGGER TrPuMonedas_ActualizaUltimaModificacion ON PuMonedas;
ENABLE TRIGGER TrPuMonedasCalculadas_ActualizaUltimaModificacion ON PuMonedasCalculadas;
ENABLE TRIGGER TrPuMovimientos_ActualizaUltimaModificacion ON PuMovimientos;
ENABLE TRIGGER TrPuOficiosParametros_ActualizaUltimaModificacion ON PuOficiosParametros;
ENABLE TRIGGER TrPuOrdenesCambio_ActualizaUltimaModificacion ON PuOrdenesCambio;
ENABLE TRIGGER TrPuOrdenesCambioDet_ActualizaUltimaModificacion ON PuOrdenesCambioDet;
ENABLE TRIGGER TrPuOrdenesCambioTipo_ActualizaUltimaModificacion ON PuOrdenesCambioTipo;
ENABLE TRIGGER TrPuParametros_ActualizaUltimaModificacion ON PuParametros;
ENABLE TRIGGER TrPuPorcentajesFinanciamiento_ActualizaUltimaModificacion ON PuPorcentajesFinanciamiento;
ENABLE TRIGGER TrPuPorcentajesFM_ActualizaUltimaModificacion ON PuPorcentajesFM;
ENABLE TRIGGER TrPuPresupuestos_ActualizaUltimaModificacion ON PuPresupuestos;
ENABLE TRIGGER TrPuPresupuestosAdjuntos_ActualizaUltimaModificacion ON PuPresupuestosAdjuntos;
ENABLE TRIGGER TrPuPresupuestosAdjuntosMonedas_ActualizaUltimaModificacion ON PuPresupuestosAdjuntosMonedas;
ENABLE TRIGGER TrPuPresupuestosConceptos_ActualizaUltimaModificacion ON PuPresupuestosConceptos;
ENABLE TRIGGER TrPuPresupuestosConceptosPrecios_ActualizaUltimaModificacion ON PuPresupuestosConceptosPrecios;
ENABLE TRIGGER TrPuPresupuestosConsecutivos_ActualizaUltimaModificacion ON PuPresupuestosConsecutivos;
ENABLE TRIGGER TrPuPresupuestosMonedas_ActualizaUltimaModificacion ON PuPresupuestosMonedas;
ENABLE TRIGGER TrPuPresupuestosOficios_ActualizaUltimaModificacion ON PuPresupuestosOficios;
ENABLE TRIGGER TrPuPresupuestosParametros_ActualizaUltimaModificacion ON PuPresupuestosParametros;
ENABLE TRIGGER TrPuPresupuestosPartidas_ActualizaUltimaModificacion ON PuPresupuestosPartidas;
ENABLE TRIGGER TrPuPresupuestosPartidasCostos_ActualizaUltimaModificacion ON PuPresupuestosPartidasCostos;
ENABLE TRIGGER TrPuPresupuestosPrecios_ActualizaUltimaModificacion ON PuPresupuestosPrecios;
ENABLE TRIGGER TrPuPresupuestosPrestamos_ActualizaUltimaModificacion ON PuPresupuestosPrestamos;
ENABLE TRIGGER TrPuPresupuestosPrestamosDet_ActualizaUltimaModificacion ON PuPresupuestosPrestamosDet;
ENABLE TRIGGER TrPuPresupuestosVersion_ActualizaUltimaModificacion ON PuPresupuestosVersion;
ENABLE TRIGGER TrPuPresupuestosVersionCostos_ActualizaUltimaModificacion ON PuPresupuestosVersionCostos;
ENABLE TRIGGER TrPuProcedimientos_ActualizaUltimaModificacion ON PuProcedimientos;
ENABLE TRIGGER TrPuProgramaConceptos_ActualizaUltimaModificacion ON PuProgramaConceptos;
ENABLE TRIGGER TrPuProgramaConceptosPeriodos_ActualizaUltimaModificacion ON PuProgramaConceptosPeriodos;
ENABLE TRIGGER TrPuProgramaPartidas_ActualizaUltimaModificacion ON PuProgramaPartidas;
ENABLE TRIGGER TrPuProgramas_ActualizaUltimaModificacion ON PuProgramas;
ENABLE TRIGGER TrPuProgramasTipos_ActualizaUltimaModificacion ON PuProgramasTipos;
ENABLE TRIGGER TrPuProgramaSum_ActualizaUltimaModificacion ON PuProgramaSum;
ENABLE TRIGGER TrPuProgramaSumXPar_ActualizaUltimaModificacion ON PuProgramaSumXPar;
ENABLE TRIGGER TrPuProveedores_ActualizaUltimaModificacion ON PuProveedores;
ENABLE TRIGGER TrPuProveedoresAdjuntos_ActualizaUltimaModificacion ON PuProveedoresAdjuntos;
ENABLE TRIGGER TrPuReferenciaAcad_ActualizaUltimaModificacion ON PuReferenciaAcad;
ENABLE TRIGGER TrPuRepCarpetas_ActualizaUltimaModificacion ON PuRepCarpetas;
ENABLE TRIGGER TrPuRepHojas_ActualizaUltimaModificacion ON PuRepHojas;
ENABLE TRIGGER TrPuRepLibros_ActualizaUltimaModificacion ON PuRepLibros;
ENABLE TRIGGER TrPuRepOpciones_ActualizaUltimaModificacion ON PuRepOpciones;
ENABLE TRIGGER TrPuRepParametros_ActualizaUltimaModificacion ON PuRepParametros;
ENABLE TRIGGER TrPuResponsables_ActualizaUltimaModificacion ON PuResponsables;
ENABLE TRIGGER TrPuSesionCAOP_ActualizaUltimaModificacion ON PuSesionCAOP;
ENABLE TRIGGER TrPuStatusControlPadron_ActualizaUltimaModificacion ON PuStatusControlPadron;
ENABLE TRIGGER TrPuTipoInsumos_ActualizaUltimaModificacion ON PuTipoInsumos;
ENABLE TRIGGER TrPuTipoProveedor_ActualizaUltimaModificacion ON PuTipoProveedor;
ENABLE TRIGGER TrPuTiposDocumentos_ActualizaUltimaModificacion ON PuTiposDocumentos;
ENABLE TRIGGER TrPuTiposLicitacion_ActualizaUltimaModificacion ON PuTiposLicitacion;
ENABLE TRIGGER TrPuTiposSolicitud_ActualizaUltimaModificacion ON PuTiposSolicitud;
ENABLE TRIGGER TrPuUnidades_ActualizaUltimaModificacion ON PuUnidades;
ENABLE TRIGGER TrPuUnidadesAcad_ActualizaUltimaModificacion ON PuUnidadesAcad;
ENABLE TRIGGER TrPuVendedores_ActualizaUltimaModificacion ON PuVendedores;
ENABLE TRIGGER TrSegGrupoPermisos_ActualizaUltimaModificacion ON SegGrupoPermisos;
ENABLE TRIGGER TrSegPerfil_ActualizaUltimaModificacion ON SegPerfil;
ENABLE TRIGGER TrSegPermisos_ActualizaUltimaModificacion ON SegPermisos;
ENABLE TRIGGER TrSegSistemas_ActualizaUltimaModificacion ON SegSistemas;
ENABLE TRIGGER TrSegUsuarios_ActualizaUltimaModificacion ON SegUsuarios;
ENABLE TRIGGER TrSegUsuariosSistemas_ActualizaUltimaModificacion ON SegUsuariosSistemas;
ENABLE TRIGGER TrSegUsuariosXProyecto_ActualizaUltimaModificacion ON SegUsuariosXProyecto;
END
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO 

/*
Datos
*/
		
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS, NOCOUNT ON
GO
SET DATEFORMAT YMD
GO
SET XACT_ABORT ON
GO

PRINT(N'Drop constraints from [dbo].[PuCiudades]')
ALTER TABLE [dbo].[PuCiudades] NOCHECK CONSTRAINT [FK_PuCiudades_Estados]
 

PRINT(N'Drop constraint FK_LicLicitaciones_PuCiudades from [dbo].[LicLicitaciones]')
ALTER TABLE [dbo].[LicLicitaciones] NOCHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades]
 

PRINT(N'Drop constraint FK_LicLicitaciones_PuCiudades1 from [dbo].[LicLicitaciones]')
ALTER TABLE [dbo].[LicLicitaciones] NOCHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades1]
 

PRINT(N'Drop constraint FK_PuClientes_PuCiudades from [dbo].[PuClientes]')
ALTER TABLE [dbo].[PuClientes] NOCHECK CONSTRAINT [FK_PuClientes_PuCiudades]
 

PRINT(N'Drop constraint FK_PuContratistas_PuCiudades from [dbo].[PuContratistas]')
ALTER TABLE [dbo].[PuContratistas] NOCHECK CONSTRAINT [FK_PuContratistas_PuCiudades]
 

PRINT(N'Drop constraint FK_PuContratistasRepresentantesL_PuCiudades from [dbo].[PuContratistasRepresentantesL]')
ALTER TABLE [dbo].[PuContratistasRepresentantesL] NOCHECK CONSTRAINT [FK_PuContratistasRepresentantesL_PuCiudades]
 

PRINT(N'Drop constraint FK_PuCostoXCiudad_PuCiudades from [dbo].[PuCostosXCiudad]')
ALTER TABLE [dbo].[PuCostosXCiudad] NOCHECK CONSTRAINT [FK_PuCostoXCiudad_PuCiudades]
 

PRINT(N'Drop constraint FK_PuEmpresas_PuCiudades from [dbo].[PuEmpresas]')
ALTER TABLE [dbo].[PuEmpresas] NOCHECK CONSTRAINT [FK_PuEmpresas_PuCiudades]
 

PRINT(N'Drop constraint FK_PuPresupuestos_PuCiudades from [dbo].[PuPresupuestos]')
ALTER TABLE [dbo].[PuPresupuestos] NOCHECK CONSTRAINT [FK_PuPresupuestos_PuCiudades]
 

PRINT(N'Drop constraint FK_PuProveedores_PuCiudades from [dbo].[PuProveedores]')
ALTER TABLE [dbo].[PuProveedores] NOCHECK CONSTRAINT [FK_PuProveedores_PuCiudades]
 

PRINT(N'Update 1 row in [dbo].[PuCiudades]')
UPDATE [dbo].[PuCiudades] SET [Descripcion]='Ciudad dee México' WHERE [Ciudad] = 'CDMX'
 

PRINT(N'Add constraints to [dbo].[PuCiudades]')
ALTER TABLE [dbo].[PuCiudades] CHECK CONSTRAINT [FK_PuCiudades_Estados]
 
ALTER TABLE [dbo].[LicLicitaciones] WITH CHECK CHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades]
 
ALTER TABLE [dbo].[LicLicitaciones] WITH CHECK CHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades1]
 
ALTER TABLE [dbo].[PuClientes] CHECK CONSTRAINT [FK_PuClientes_PuCiudades]
 
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_PuCiudades]
 
ALTER TABLE [dbo].[PuContratistasRepresentantesL] WITH CHECK CHECK CONSTRAINT [FK_PuContratistasRepresentantesL_PuCiudades]
 
ALTER TABLE [dbo].[PuCostosXCiudad] CHECK CONSTRAINT [FK_PuCostoXCiudad_PuCiudades]
 
ALTER TABLE [dbo].[PuEmpresas] WITH CHECK CHECK CONSTRAINT [FK_PuEmpresas_PuCiudades]
 
ALTER TABLE [dbo].[PuPresupuestos] CHECK CONSTRAINT [FK_PuPresupuestos_PuCiudades]
 
ALTER TABLE [dbo].[PuProveedores] CHECK CONSTRAINT [FK_PuProveedores_PuCiudades]
 
Update [dbo].[Version] SET Version = '2017/08/18', Hora = '1229',VersionNeodata=2016, NombreNeodata ='Precios Unitarios 2016'
 

COMMIT TRANSACTION
GO
 
SET NOEXEC OFF
-- This statement writes to the SQL Server Log so SQL Monitor can show this deployment.
IF HAS_PERMS_BY_NAME(N'sys.xp_logevent', N'OBJECT', N'EXECUTE') = 1
BEGIN
	DECLARE @databaseName AS nvarchar(2048), @eventMessage AS nvarchar(2048)
	SET @databaseName = REPLACE(REPLACE(DB_NAME(), N'\', N'\\'), N'"', N'\"')
	SET @eventMessage = N'Redgate SQL Compare: { "deployment": { "description": "Redgate SQL Compare deployed to ' + @databaseName + N'", "database": "' + @databaseName + N'" }}'
	EXECUTE sys.xp_logevent 55000, @eventMessage
END
GO
IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION
GO
