﻿/*
Estructura
*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL Serializable
GO
BEGIN TRANSACTION
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
 
PRINT N'Creating [dbo].[PuPlantillasCorreo]'
GO
CREATE TABLE [dbo].[PuPlantillasCorreo]
(
[IdPlantillaCorreo] [int] NOT NULL IDENTITY(1, 1),
[Plantilla] [varchar] (40) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[URLplantilla] [varchar] (500) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Descripcion] [varchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
 
PRINT N'Creating primary key [PK_PuPlantillasCorreo] on [dbo].[PuPlantillasCorreo]'
GO
ALTER TABLE [dbo].[PuPlantillasCorreo] ADD CONSTRAINT [PK_PuPlantillasCorreo] PRIMARY KEY CLUSTERED  ([IdPlantillaCorreo])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
 
/*
Datos
*/
		
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS, NOCOUNT ON
GO
SET DATEFORMAT YMD
GO
SET XACT_ABORT ON
GO

PRINT(N'Drop constraints from [dbo].[PuCiudades]')
ALTER TABLE [dbo].[PuCiudades] NOCHECK CONSTRAINT [FK_PuCiudades_Estados]
 

PRINT(N'Drop constraint FK_LicLicitaciones_PuCiudades from [dbo].[LicLicitaciones]')
ALTER TABLE [dbo].[LicLicitaciones] NOCHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades]
 

PRINT(N'Drop constraint FK_LicLicitaciones_PuCiudades1 from [dbo].[LicLicitaciones]')
ALTER TABLE [dbo].[LicLicitaciones] NOCHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades1]
 

PRINT(N'Drop constraint FK_PuClientes_PuCiudades from [dbo].[PuClientes]')
ALTER TABLE [dbo].[PuClientes] NOCHECK CONSTRAINT [FK_PuClientes_PuCiudades]
 

PRINT(N'Drop constraint FK_PuContratistas_PuCiudades from [dbo].[PuContratistas]')
ALTER TABLE [dbo].[PuContratistas] NOCHECK CONSTRAINT [FK_PuContratistas_PuCiudades]
 

PRINT(N'Drop constraint FK_PuContratistasRepresentantesL_PuCiudades from [dbo].[PuContratistasRepresentantesL]')
ALTER TABLE [dbo].[PuContratistasRepresentantesL] NOCHECK CONSTRAINT [FK_PuContratistasRepresentantesL_PuCiudades]
 

PRINT(N'Drop constraint FK_PuCostoXCiudad_PuCiudades from [dbo].[PuCostosXCiudad]')
ALTER TABLE [dbo].[PuCostosXCiudad] NOCHECK CONSTRAINT [FK_PuCostoXCiudad_PuCiudades]
 

PRINT(N'Drop constraint FK_PuEmpresas_PuCiudades from [dbo].[PuEmpresas]')
ALTER TABLE [dbo].[PuEmpresas] NOCHECK CONSTRAINT [FK_PuEmpresas_PuCiudades]
 

PRINT(N'Drop constraint FK_PuPresupuestos_PuCiudades from [dbo].[PuPresupuestos]')
ALTER TABLE [dbo].[PuPresupuestos] NOCHECK CONSTRAINT [FK_PuPresupuestos_PuCiudades]
 

PRINT(N'Drop constraint FK_PuProveedores_PuCiudades from [dbo].[PuProveedores]')
ALTER TABLE [dbo].[PuProveedores] NOCHECK CONSTRAINT [FK_PuProveedores_PuCiudades]
 

PRINT(N'Update rows in [dbo].[PuParametros]')
UPDATE [dbo].[PuParametros] SET [Valor]='C:\Neodata2018\Reportes' WHERE [Parametro] = 'RutaReportes'
 
UPDATE [dbo].[PuParametros] SET [Valor]='2018' WHERE [Parametro] = 'FAñoAplicacion'
 
UPDATE [dbo].[PuParametros] SET [Valor]='C:\Neodata2018\Reportes\LogoNeodata.jpg' WHERE [Parametro] = 'RutaLogotipoReportes'
 
UPDATE [dbo].[PuParametros] SET [Valor]='80.60' WHERE [Parametro] = 'FUma'
 
PRINT(N'Operation applied to 5 rows out of 5')

PRINT(N'Update row in [dbo].[PuCiudades]')
UPDATE [dbo].[PuCiudades] SET [Descripcion]='Ciudad de México' WHERE [Ciudad] = 'CDMX'
 

PRINT(N'Add row to [dbo].[PuCuotasVigentesImss]')

IF NOT EXISTS(SELECT Clave FROM PuCuotasVigentesImss WHERE Clave='2018') 
BEGIN
	INSERT INTO [dbo].[PuCuotasVigentesImss] ([Clave], [CuotaFijaPat], [ExcedentePat], [ExcedenteAse], [PrestDinPat], [PrestDinAse], [GastoMedPenPat], [GastoMedPenAse], [InvalidezVidaPat], [InvalidezVidaAse], [GuarderiasPat], [RetiroPat], [CesantiaVejezPat], [CesantiaVejezAse], [LimiteSuperior1], [LimiteSuperior2]) VALUES ('2018', 20.4000, 1.1000, 0.4000, 0.7000, 0.2500, 1.0500, 0.3750, 1.7500, 0.6250, 1.0000, 2.0000, 3.1500, 1.1250, 25.0000, 25.0000)
END

PRINT(N'Add rows to [dbo].[PuParametros]')
INSERT INTO [dbo].[PuParametros] ([Parametro], [Valor], [Explicacion], [Especifico]) VALUES ('CorreoDefault', NULL, 'Correo default para correos por MG', 0)
 
INSERT INTO [dbo].[PuParametros] ([Parametro], [Valor], [Explicacion], [Especifico]) VALUES ('RespaldarPorCorreo', '1', 'Check de Enviar respaldo por correo en Calculo', 0)
 
INSERT INTO [dbo].[PuParametros] ([Parametro], [Valor], [Explicacion], [Especifico]) VALUES ('RespaldarEnCarpeta', '1', 'Check de Enviar respaldo a carpeta de Archivos Intercambio', 0)
 
PRINT(N'Operation applied to 3 rows out of 3')

PRINT(N'Add row to [dbo].[PuPlantillasCorreo]')

INSERT INTO [dbo].[PuPlantillasCorreo] ([Plantilla], [URLplantilla], [Descripcion]) VALUES ('PU-Archivo-Intercambio', 'http://cdncorreos.neodata.com.mx/PU/HTML/Archivo-Intercambio-PU.html', 'Plantilla para el envío del presupuesto en formato archivo de intercambio.')
 


PRINT(N'Add constraints to [dbo].[PuCiudades]')
ALTER TABLE [dbo].[PuCiudades] CHECK CONSTRAINT [FK_PuCiudades_Estados]
 
ALTER TABLE [dbo].[LicLicitaciones] WITH CHECK CHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades]
 
ALTER TABLE [dbo].[LicLicitaciones] WITH CHECK CHECK CONSTRAINT [FK_LicLicitaciones_PuCiudades1]
 
ALTER TABLE [dbo].[PuClientes] CHECK CONSTRAINT [FK_PuClientes_PuCiudades]
 
ALTER TABLE [dbo].[PuContratistas] CHECK CONSTRAINT [FK_PuContratistas_PuCiudades]
 
ALTER TABLE [dbo].[PuContratistasRepresentantesL] WITH CHECK CHECK CONSTRAINT [FK_PuContratistasRepresentantesL_PuCiudades]
 
ALTER TABLE [dbo].[PuCostosXCiudad] CHECK CONSTRAINT [FK_PuCostoXCiudad_PuCiudades]
 
ALTER TABLE [dbo].[PuEmpresas] WITH CHECK CHECK CONSTRAINT [FK_PuEmpresas_PuCiudades]
 
ALTER TABLE [dbo].[PuPresupuestos] CHECK CONSTRAINT [FK_PuPresupuestos_PuCiudades]
 
ALTER TABLE [dbo].[PuProveedores] CHECK CONSTRAINT [FK_PuProveedores_PuCiudades]
 
Update [dbo].[Version] SET Version = '2018/02/13', Hora = '1548',VersionNeodata=2018, NombreNeodata ='Precios Unitarios 2018'
 
COMMIT TRANSACTION
GO
 
SET NOEXEC OFF
-- This statement writes to the SQL Server Log so SQL Monitor can show this deployment.
IF HAS_PERMS_BY_NAME(N'sys.xp_logevent', N'OBJECT', N'EXECUTE') = 1
BEGIN
	DECLARE @databaseName AS nvarchar(2048), @eventMessage AS nvarchar(2048)
	SET @databaseName = REPLACE(REPLACE(DB_NAME(), N'\', N'\\'), N'"', N'\"')
	SET @eventMessage = N'Redgate SQL Compare: { "deployment": { "description": "Redgate SQL Compare deployed to ' + @databaseName + N'", "database": "' + @databaseName + N'" }}'
	EXECUTE sys.xp_logevent 55000, @eventMessage
END
GO
IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION
GO
