﻿-- =============================================
-- Author: Carlos Bedolla
-- Create date: 26-Mayo-2009
-- Description: Devuelve el DataTable con los Conceptos por Partida
--              opcionalmente filtra o marca los concepto por SqlLike
-- =============================================
ALTER PROCEDURE [dbo].[NeoConceptos_CargaDatosGrid]
@IdPresupuestoPartida AS Int,
@SqlLike AS VarChar(max),
@ExcluirRegistrosEnBusqueda AS Bit,
@IdMoneda AS Int,
@IdMoneda2 AS Int OUT,
@IdMoneda3 AS Int OUT,
@DescripcionMoneda2 AS VarChar(20) OUT,
@DescripcionMoneda3 AS VarChar(20) OUT
AS
BEGIN
DECLARE @Sql AS nVarChar(max),
@Decimales AS Int,
@IdPresupuesto AS Int
-- Obtengo el IdPresupuesto
SELECT @IdPresupuesto = IdPresupuesto FROM PuPresupuestosPartidas WHERE IdPresupuestoPartida = @IdPresupuestoPartida
-- Obtengo el Número de Decimales
EXEC @Decimales = dbo.NeoParametros_DecimalesRedondeo @IdPresupuesto = @IdPresupuesto
EXEC dbo.NeoMatrices_DameMonedasPresupuesto @IdPresupuesto, @IdMoneda, @IdMoneda2 OUT, @IdMoneda3 OUT
--EXEC @MostrarImagen = NeoParametros_Lee 'MostrarImagen','0', @IdPresupuesto
IF @SqlLike IS NULL BEGIN
SET @Sql = 'SELECT 0 AS MarcaBusqueda, PC.IdPresupuestoConcepto, PC.IdPresupuestoPartida, PC.IdExpIns, PC.Control,
CAST(0 AS Bit) AS Marca, PC.Renglon, EI.Nivel, C.Codigo, C2.Codigo AS Agrupador, C.DescripcionLarga,
C.Descripcion, C.EsPorcentaje, U.Unidad, COALESCE(F.Familia,'+''''''+') AS Familia,
C.IdTipo, COALESCE(C.CodigoSap,'+''''''+') AS CodigoSap, PC.Cantidad, PC.CantidadTotal,
ROUND(COALESCE(EIC.Costo, 0), ' + CAST(@Decimales AS VarChar) + ') AS Costo, ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio, PC.Cantidad * ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe, PC.IndirectoEspecial,
PC.PorcentajeIndirectoEspecial, PC.CodigoAuxiliar, EI.EsCostoHorario,
PC.DescripcionAuxiliar, ET.EstimacionTipo, PC.RutaGenerador,
CASE WHEN PP.PrecioTotal = 0 THEN 0 ELSE (PC.CantidadTotal * ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ')) / PP.PrecioTotal END AS PorcentajeParticipacion,
EI.IdIntelimat, IM.EsNeodata, EI.PendienteAnalizar, I.Imagen '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += ', COALESCE(EIC2.Costo, 0) AS Costo2,
ROUND(COALESCE(PCP2.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio2, PC.CantidadTotal * ROUND(COALESCE(PCP2.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe2 '
SELECT @DescripcionMoneda2 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda2
IF @IdMoneda3 > 0 BEGIN
SET @Sql += ', COALESCE(EIC3.Costo, 0) AS Costo3,
ROUND(COALESCE(PCP3.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio3, PC.CantidadTotal * ROUND(COALESCE(PCP3.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe3 '
SELECT @DescripcionMoneda3 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda3
END
END
SET @Sql += 'FROM PuPresupuestosConceptos AS PC INNER JOIN
PuPresupuestos AS P ON P.IdPresupuesto = PC.IdPresupuesto INNER JOIN
PuExpIns AS EI ON PC.IdExpIns = EI.IdExpIns INNER JOIN
PuCatalogo AS C ON EI.IdCodigo = C.IdCodigo INNER JOIN
PuUnidades AS U ON C.Idunidad = U.Idunidad INNER JOIN
PuEstimacionesTipos AS ET ON ET.IdEstimacionTipo = PC.IdEstimacionTipo LEFT JOIN
PuFamilias as F ON C.IdFamilia = F.IdFamilia LEFT JOIN
PuCatalogo AS C2 ON PC.IdAgrupador = C2.IdCodigo LEFT JOIN
PuIntelimat AS IM ON IM.IdIntelimat = EI.IdIntelimat LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS EIC ON EIC.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PCP ON PCP.IdPresupuestoConcepto = PC.IdPresupuestoConcepto LEFT JOIN
(SELECT IdPresupuesto, PrecioTotal
FROM PuPresupuestosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PP ON PP.IdPresupuesto = P.IdPresupuesto LEFT JOIN
PuImagenes AS I ON I.IdImagen = C.IdImagen '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS EIC2 ON EIC2.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS PCP2 ON PCP2.IdPresupuestoConcepto = PC.IdPresupuestoConcepto '
IF @IdMoneda3 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS EIC3 ON EIC3.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS PCP3 ON PCP3.IdPresupuestoConcepto = PC.IdPresupuestoConcepto '
END
END
SET @Sql += 'WHERE PC.IdPresupuestoPartida = ' + CAST(@IdPresupuestoPartida AS VarChar) + '
ORDER BY PC.Renglon'
END ELSE BEGIN
IF @ExcluirRegistrosEnBusqueda = 1 BEGIN
SET @Sql = 'SELECT 1 AS MarcaBusqueda, PC.IdPresupuestoConcepto, PC.IdPresupuestoPartida,
PC.IdExpIns, PC.Control, CAST(0 AS Bit) AS Marca, PC.Renglon, EI.Nivel, C.Codigo, C2.Codigo AS Agrupador, C.DescripcionLarga,
C.Descripcion, C.EsPorcentaje, U.Unidad,COALESCE(F.Familia,'+''''''+') AS Familia,
C.IdTipo, COALESCE(C.CodigoSap,'+''''''+') AS CodigoSap,
PC.Cantidad, PC.CantidadTotal, ROUND(COALESCE(EIC.Costo, 0), ' + CAST(@Decimales AS VarChar) + ') AS Costo, ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio,
PC.Cantidad * ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe, PC.IndirectoEspecial, PC.PorcentajeIndirectoEspecial,
PC.CodigoAuxiliar, PC.DescripcionAuxiliar, ET.EstimacionTipo, PC.RutaGenerador, PC.CodigoAuxiliar, EI.EsCostoHorario,
CASE WHEN PP.PrecioTotal = 0 THEN 0 ELSE (PC.CantidadTotal * ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ')) / PP.PrecioTotal END AS PorcentajeParticipacion,
EI.IdIntelimat, IM.EsNeodata, I.Imagen, EI.PendienteAnalizar '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += ', COALESCE(EIC2.Costo, 0) AS Costo2,
ROUND(COALESCE(PCP2.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio2, PC.CantidadTotal * ROUND(COALESCE(PCP2.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe2 '
SELECT @DescripcionMoneda2 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda2
IF @IdMoneda3 > 0 BEGIN
SET @Sql += ', COALESCE(EIC3.Costo, 0) AS Costo3,
ROUND(COALESCE(PCP3.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio2, PC.CantidadTotal * ROUND(COALESCE(PCP3.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe3 '
SELECT @DescripcionMoneda3 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda3
END
END
SET @Sql += 'FROM PuPresupuestosConceptos AS PC INNER JOIN
PuPresupuestos AS P ON P.IdPresupuesto = PC.IdPresupuesto INNER JOIN
PuExpIns AS EI ON PC.IdExpIns = EI.IdExpIns INNER JOIN
PuCatalogo AS C ON EI.IdCodigo = C.IdCodigo INNER JOIN
PuUnidades AS U ON C.Idunidad = U.Idunidad INNER JOIN
PuEstimacionesTipos AS ET ON ET.IdEstimacionTipo = PC.IdEstimacionTipo LEFT JOIN
PuFamilias as F ON C.IdFamilia = F.IdFamilia LEFT JOIN
PuCatalogo AS C2 ON PC.IdAgrupador = C2.IdCodigo LEFT JOIN
PuIntelimat AS IM ON IM.IdIntelimat = EI.IdIntelimat LEFT JOIN
PuImagenes AS I ON I.IdImagen = C.IdImagen LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS EIC ON EIC.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PCP ON PCP.IdPresupuestoConcepto = PC.IdPresupuestoConcepto LEFT JOIN
(SELECT IdPresupuesto, PrecioTotal
FROM PuPresupuestosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PP ON PP.IdPresupuesto = P.IdPresupuesto '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS EIC2 ON EIC2.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS PCP2 ON PCP2.IdPresupuestoConcepto = PC.IdPresupuestoConcepto '
IF @IdMoneda3 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS EIC3 ON EIC3.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS PCP3 ON PCP3.IdPresupuestoConcepto = PC.IdPresupuestoConcepto '
END
END
SET @Sql += 'WHERE PC.IdPresupuestoPartida = ' + CAST(@IdPresupuestoPartida AS VarChar) + ' ' + @SqlLike + '
ORDER BY PC.Renglon '
END ELSE BEGIN
SET @Sql = 'SELECT COALESCE(M.MarcaBusqueda,0) AS MarcaBusqueda, PC.IdPresupuestoConcepto, PC.IdPresupuestoPartida,
PC.IdExpIns, PC.Control, CAST(0 AS Bit) AS Marca, PC.Renglon, EI.Nivel, C.Codigo, C2.Codigo AS Agrupador, C.DescripcionLarga,
C.Descripcion, C.EsPorcentaje, U.Unidad, COALESCE(F.Familia,'+''''''+') AS Familia,
C.IdTipo, COALESCE(C.CodigoSap,'+''''''+') AS CodigoSap,
PC.Cantidad, PC.CantidadTotal, ROUND(COALESCE(EIC.Costo, 0), ' + CAST(@Decimales AS VarChar) + ') AS Costo, ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio,
PC.Cantidad * ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe, PC.IndirectoEspecial, PC.PorcentajeIndirectoEspecial,
PC.CodigoAuxiliar, PC.DescripcionAuxiliar, ET.EstimacionTipo, PC.RutaGenerador, PC.CodigoAuxiliar, EI.EsCostoHorario,
CASE WHEN PP.PrecioTotal = 0 THEN 0 ELSE (PC.CantidadTotal * ROUND(COALESCE(PCP.Precio, 0), ' + CAST(@Decimales AS VarChar) + ')) / PP.PrecioTotal END AS PorcentajeParticipacion,
EI.IdIntelimat, IM.EsNeodata, I.Imagen, EI.PendienteAnalizar '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += ', COALESCE(EIC2.Costo, 0) AS Costo2,
ROUND(COALESCE(PCP2.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio2, PC.CantidadTotal * ROUND(COALESCE(PCP2.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe2 '
SELECT @DescripcionMoneda2 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda2
IF @IdMoneda3 > 0 BEGIN
SET @Sql += ', COALESCE(EIC3.Costo, 0) AS Costo3,
ROUND(COALESCE(PCP3.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Precio2, PC.CantidadTotal * ROUND(COALESCE(PCP3.Precio, 0), ' + CAST(@Decimales AS VarChar) + ') AS Importe3 '
SELECT @DescripcionMoneda3 = Descripcion FROM PuMonedas WHERE IdMoneda = @IdMoneda3
END
END
SET @Sql += 'FROM PuPresupuestosConceptos AS PC INNER JOIN
PuPresupuestos AS P ON P.IdPresupuesto = PC.IdPresupuesto INNER JOIN
PuExpIns AS EI ON PC.IdExpIns = EI.IdExpIns INNER JOIN
PuCatalogo AS C ON EI.IdCodigo = C.IdCodigo INNER JOIN
PuUnidades AS U ON C.Idunidad = U.Idunidad INNER JOIN
PuEstimacionesTipos AS ET ON ET.IdEstimacionTipo = PC.IdEstimacionTipo LEFT JOIN
PuFamilias as F ON C.IdFamilia = F.IdFamilia LEFT JOIN
PuCatalogo AS C2 ON PC.IdAgrupador = C2.IdCodigo LEFT JOIN
PuIntelimat AS IM ON IM.IdIntelimat = EI.IdIntelimat LEFT JOIN
PuImagenes AS I ON I.IdImagen = C.IdImagen LEFT JOIN
(SELECT PC.IdPresupuestoConcepto, 1 AS MarcaBusqueda, C.Codigo
FROM PuPresupuestosConceptos AS PC INNER JOIN
PuExpIns AS EI ON PC.IdExpIns = EI.IdExpIns INNER JOIN
PuCatalogo AS C ON EI.IdCodigo = C.IdCodigo
WHERE PC.IdPresupuestoPartida = ' + CAST(@IdPresupuestoPartida AS VarChar)  + ' ' + @SqlLike + '
) AS M ON M.IdPresupuestoConcepto = PC.IdPresupuestoConcepto LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS EIC ON EIC.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PCP ON PCP.IdPresupuestoConcepto = PC.IdPresupuestoConcepto LEFT JOIN
(SELECT IdPresupuesto, PrecioTotal
FROM PuPresupuestosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda AS VarChar) + ') AS PP ON PP.IdPresupuesto = P.IdPresupuesto '
IF @IdMoneda2 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS EIC2 ON EIC2.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda2 AS VarChar) + ') AS PCP2 ON PCP2.IdPresupuestoConcepto = PC.IdPresupuestoConcepto '
IF @IdMoneda3 > 0 BEGIN
SET @Sql += 'LEFT JOIN
(SELECT IdExpIns, Costo
FROM PuExpInsCostos
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS EIC3 ON EIC3.IdExpIns = EI.IdExpIns LEFT JOIN
(SELECT IdPresupuestoConcepto, Precio
FROM PuPresupuestosConceptosPrecios
WHERE IdMoneda = ' + CAST(@IdMoneda3 AS VarChar) + ') AS PCP3 ON PCP3.IdPresupuestoConcepto = PC.IdPresupuestoConcepto '
END
END
SET @Sql += 'WHERE PC.IdPresupuestoPartida = ' + CAST(@IdPresupuestoPartida AS VarChar)  + '
ORDER BY PC.Renglon '
END
END
EXEC sp_executesql @Sql
END
Update [dbo].[Version] SET Version = '2023/09/29', Hora = '1330',VersionNeodata=2021, NombreNeodata ='Precios Unitarios 2021'